/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XClientMessageEvent;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TypedListener;

public class TrayItem
extends Item {
    Tray parent;
    String toolTipText;
    long imageHandle;
    long tooltipsHandle;
    ImageList imageList;

    public TrayItem(Tray parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(parent.getItemCount());
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.parent.createItem(this, index);
    }

    void createHandle(int index) {
        this.state |= 8;
        this.handle = OS.gtk_plug_new(0L);
        if (this.handle == 0L) {
            this.error(2);
        }
        this.imageHandle = OS.gtk_image_new();
        if (this.imageHandle == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(this.handle, this.imageHandle);
        OS.gtk_widget_show(this.handle);
        OS.gtk_widget_show(this.imageHandle);
        long id = OS.gtk_plug_get_id(this.handle);
        int monitor = 0;
        long screen = OS.gdk_screen_get_default();
        if (screen != 0L) {
            monitor = OS.gdk_screen_get_number(screen);
        }
        byte[] trayBuffer = Converter.wcsToMbcs(null, "_NET_SYSTEM_TRAY_S" + monitor, true);
        long trayAtom = OS.gdk_atom_intern(trayBuffer, true);
        long xTrayAtom = OS.gdk_x11_atom_to_xatom(trayAtom);
        long xDisplay = OS.GDK_DISPLAY();
        long trayWindow = OS.XGetSelectionOwner(xDisplay, xTrayAtom);
        byte[] messageBuffer = Converter.wcsToMbcs(null, "_NET_SYSTEM_TRAY_OPCODE", true);
        long messageAtom = OS.gdk_atom_intern(messageBuffer, true);
        long xMessageAtom = OS.gdk_x11_atom_to_xatom(messageAtom);
        XClientMessageEvent event = new XClientMessageEvent();
        event.type = 33;
        event.window = trayWindow;
        event.message_type = xMessageAtom;
        event.format = 32;
        event.data[0] = 0L;
        event.data[1] = 0L;
        event.data[2] = id;
        long clientEvent = OS.g_malloc(XClientMessageEvent.sizeof);
        OS.memmove(clientEvent, event, (long)XClientMessageEvent.sizeof);
        OS.XSendEvent(xDisplay, trayWindow, false, 0L, clientEvent);
        OS.g_free(clientEvent);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    long gtk_button_press_event(long widget, long eventPtr) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, eventPtr, (long)GdkEventButton.sizeof);
        if (gdkEvent.type == 6) {
            return 0L;
        }
        if (gdkEvent.button == 3 && gdkEvent.type == 4) {
            this.sendEvent(35);
            return 0L;
        }
        if (gdkEvent.type == 5) {
            this.postEvent(14);
        } else {
            this.postEvent(13);
        }
        return 0L;
    }

    void hookEvents() {
        int eventMask = 256;
        OS.gtk_widget_add_events(this.handle, eventMask);
        OS.g_signal_connect(this.handle, OS.button_press_event, this.display.windowProc3, 2L);
    }

    public boolean getVisible() {
        this.checkWidget();
        return OS.GTK_WIDGET_VISIBLE(this.handle);
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.tooltipsHandle != 0L) {
            OS.g_object_unref(this.tooltipsHandle);
        }
        this.tooltipsHandle = 0L;
        this.imageHandle = 0L;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        this.toolTipText = null;
        if (this.handle != 0L) {
            OS.gtk_widget_destroy(this.handle);
        }
        this.handle = 0L;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        if (image != null) {
            int imageIndex;
            Rectangle rect = image.getBounds();
            OS.gtk_widget_set_size_request(this.handle, rect.width, rect.height);
            if (this.imageList == null) {
                this.imageList = new ImageList();
            }
            if ((imageIndex = this.imageList.indexOf(image)) == -1) {
                imageIndex = this.imageList.add(image);
            } else {
                this.imageList.put(imageIndex, image);
            }
            long pixbuf = this.imageList.getPixbuf(imageIndex);
            OS.gtk_image_set_from_pixbuf(this.imageHandle, pixbuf);
            OS.gtk_widget_show(this.imageHandle);
        } else {
            OS.gtk_widget_set_size_request(this.handle, 1, 1);
            OS.gtk_image_set_from_pixbuf(this.imageHandle, 0L);
            OS.gtk_widget_hide(this.imageHandle);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        byte[] buffer = null;
        if (string != null && string.length() > 0) {
            buffer = Converter.wcsToMbcs(null, string, true);
        }
        if (this.tooltipsHandle == 0L) {
            this.tooltipsHandle = OS.gtk_tooltips_new();
            if (this.tooltipsHandle == 0L) {
                this.error(2);
            }
            OS.g_object_ref(this.tooltipsHandle);
            OS.gtk_object_sink(this.tooltipsHandle);
        }
        OS.gtk_tooltips_set_tip(this.tooltipsHandle, this.handle, buffer, null);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (OS.GTK_WIDGET_VISIBLE(this.handle) == visible) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            OS.gtk_widget_show(this.handle);
        } else {
            OS.gtk_widget_hide(this.handle);
            this.sendEvent(23);
        }
    }
}

