/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Contributor(s):
 *
 * IBM
 * -  Binding to permit interfacing between Cairo and SWT
 * -  Copyright (C) 2005 IBM Corp.  All Rights Reserved.
 *
 * ***** END LICENSE BLOCK ***** */
package org.eclipse.swt.internal.cairo;

import org.eclipse.swt.internal.Library;

public class Cairo {
	static {
		Library.loadLibrary("swt-cairo");
	}

	/** Constants */
	public static final int CAIRO_FORMAT_ARGB32 = 0;
	public static final int CAIRO_FORMAT_RGB24 = 1;
	public static final int CAIRO_FORMAT_A8 = 2;
	public static final int CAIRO_FORMAT_A1 = 3;
	public static final int CAIRO_OPERATOR_CLEAR = 0;
	public static final int CAIRO_OPERATOR_SRC = 1;
	public static final int CAIRO_OPERATOR_DST = 2;
	public static final int CAIRO_OPERATOR_OVER = 3;
	public static final int CAIRO_OPERATOR_OVER_REVERSE = 4;
	public static final int CAIRO_OPERATOR_IN = 5;
	public static final int CAIRO_OPERATOR_IN_REVERSE = 6;
	public static final int CAIRO_OPERATOR_OUT = 7;
	public static final int CAIRO_OPERATOR_OUT_REVERSE = 8;
	public static final int CAIRO_OPERATOR_ATOP = 9;
	public static final int CAIRO_OPERATOR_ATOP_REVERSE = 10;
	public static final int CAIRO_OPERATOR_XOR = 11;
	public static final int CAIRO_OPERATOR_ADD = 12;
	public static final int CAIRO_OPERATOR_SATURATE = 13;
	public static final int CAIRO_FILL_RULE_WINDING = 0;
	public static final int CAIRO_FILL_RULE_EVEN_ODD = 1;
	public static final int CAIRO_LINE_CAP_BUTT = 0;
	public static final int CAIRO_LINE_CAP_ROUND = 1;
	public static final int CAIRO_LINE_CAP_SQUARE = 2;
	public static final int CAIRO_LINE_JOIN_MITER = 0;
	public static final int CAIRO_LINE_JOIN_ROUND = 1;
	public static final int CAIRO_LINE_JOIN_BEVEL = 2;
	public static final int CAIRO_FONT_SLANT_NORMAL = 0;
	public static final int CAIRO_FONT_SLANT_ITALIC = 1;
	public static final int CAIRO_FONT_SLANT_OBLIQUE = 2;
	public static final int CAIRO_FONT_WEIGHT_NORMAL = 0;
	public static final int CAIRO_FONT_WEIGHT_BOLD = 1;
	public static final int CAIRO_STATUS_SUCCESS = 0;
	public static final int CAIRO_STATUS_NO_MEMORY = 1;
	public static final int CAIRO_STATUS_INVALID_RESTORE = 2;
	public static final int CAIRO_STATUS_INVALID_POP_GROUP = 3;
	public static final int CAIRO_STATUS_NO_CURRENT_POINT = 4;
	public static final int CAIRO_STATUS_INVALID_MATRIX = 5;
	public static final int CAIRO_STATUS_NO_TARGET_SURFACE = 6;
	public static final int CAIRO_STATUS_NULL_POINTER =7;
	public static final int CAIRO_FILTER_FAST = 0;
	public static final int CAIRO_FILTER_GOOD = 1;
	public static final int CAIRO_FILTER_BEST = 2;
	public static final int CAIRO_FILTER_NEAREST = 3;
	public static final int CAIRO_FILTER_BILINEAR = 4;
	public static final int CAIRO_FILTER_GAUSSIAN = 5;
	public static final int CAIRO_EXTEND_NONE = 0;
	public static final int CAIRO_EXTEND_REPEAT = 1;
	public static final int CAIRO_EXTEND_REFLECT = 2;
	
/** 64*/
public static final synchronized native int cairo_font_extents_t_sizeof ();
	
/** Custom natives */ 
public static final synchronized native void cairo_add_path (long /*int*/ cr1, long /*int*/ cr2);
public static final synchronized native void cairo_extents (long /*int*/ cr, double[] extents);
public static final synchronized native void cairo_points (long /*int*/ cr, int[] n_types, int[] n_points, byte[] types, float[] points);

/** Natives */
public static final synchronized native long /*int*/ cairo_create ();
public static final synchronized native void cairo_reference (long /*int*/ cr);
public static final synchronized native void cairo_destroy (long /*int*/ cr);
public static final synchronized native void cairo_save (long /*int*/ cr);
public static final synchronized native void cairo_restore (long /*int*/ cr);
public static final synchronized native void cairo_copy (long /*int*/ dest, long /*int*/ src);
public static final synchronized native void cairo_set_target_surface (long /*int*/ cr, long /*int*/ surface);
public static final synchronized native void cairo_set_target_image (long /*int*/ cr, long /*int*/ data, int format, int width, int height, int stride);
public static final synchronized native void cairo_set_target_drawable (long /*int*/ cr, long /*int*/ dpy, long /*int*/ drawable);
public static final synchronized native void cairo_set_operator (long /*int*/ cr, int op);
public static final synchronized native void cairo_set_rgb_color (long /*int*/ cr, double red, double green, double blue);
public static final synchronized native void cairo_set_pattern (long /*int*/ cr, long /*int*/ pattern);
public static final synchronized native void cairo_set_alpha (long /*int*/ cr, double alpha);
public static final synchronized native void cairo_set_tolerance (long /*int*/ cr, double tolerance);
public static final synchronized native void cairo_set_fill_rule (long /*int*/ cr, int fill_rule);
public static final synchronized native void cairo_set_line_width (long /*int*/ cr, double width);
public static final synchronized native void cairo_set_line_cap (long /*int*/ cr, int line_cap);
public static final synchronized native void cairo_set_line_join (long /*int*/ cr, int line_join);
public static final synchronized native void cairo_set_dash (long /*int*/ cr, double[] dashes, int ndash, double offset);
public static final synchronized native void cairo_set_miter_limit (long /*int*/ cr, double limit);
public static final synchronized native void cairo_translate (long /*int*/ cr, double tx, double ty);
public static final synchronized native void cairo_scale (long /*int*/ cr, double sx, double sy);
public static final synchronized native void cairo_rotate (long /*int*/ cr, double angle);
public static final synchronized native void cairo_concat_matrix (long /*int*/ cr, long /*int*/ matrix);
public static final synchronized native void cairo_set_matrix (long /*int*/ cr, long /*int*/ matrix);
public static final synchronized native void cairo_default_matrix (long /*int*/ cr);
public static final synchronized native void cairo_identity_matrix (long /*int*/ cr);
public static final synchronized native void cairo_transform_point (long /*int*/ cr, double[] x, double[] y);
public static final synchronized native void cairo_transform_distance (long /*int*/ cr, double[] dx, double[] dy);
public static final synchronized native void cairo_inverse_transform_point (long /*int*/ cr, double[] x, double[] y);
public static final synchronized native void cairo_inverse_transform_distance (long /*int*/ cr, double[] dx, double[] dy);
public static final synchronized native void cairo_new_path (long /*int*/ cr);
public static final synchronized native void cairo_move_to (long /*int*/ cr, double x, double y);
public static final synchronized native void cairo_line_to (long /*int*/ cr, double x, double y);
public static final synchronized native void cairo_curve_to (long /*int*/ cr, double x1, double y1, double x2, double y2, double x3, double y3);
public static final synchronized native void cairo_arc (long /*int*/ cr, double xc, double yc, double radius, double angle1, double angle2);
public static final synchronized native void cairo_arc_negative (long /*int*/ cr, double xc, double yc, double radius, double angle1, double angle2);
//public static final synchronized native void cairo_arc_to (long /*int*/ cr, double x1, double y1, double x2, double y2, double radius);
public static final synchronized native void cairo_rel_move_to (long /*int*/ cr, double dx, double dy);
public static final synchronized native void cairo_rel_line_to (long /*int*/ cr, double dx, double dy);
public static final synchronized native void cairo_rel_curve_to (long /*int*/ cr, double dx1, double dy1, double dx2, double dy2, double dx3, double dy3);
public static final synchronized native void cairo_rectangle (long /*int*/ cr, double x, double y, double width, double height);
public static final synchronized native void cairo_close_path (long /*int*/ cr);
public static final synchronized native void cairo_stroke (long /*int*/ cr);
public static final synchronized native void cairo_fill (long /*int*/ cr);
public static final synchronized native void cairo_copy_page (long /*int*/ cr);
public static final synchronized native void cairo_show_page (long /*int*/ cr);
public static final synchronized native int cairo_in_stroke (long /*int*/ cr, double x, double y);
public static final synchronized native int cairo_in_fill (long /*int*/ cr, double x, double y);
public static final synchronized native void cairo_stroke_extents (long /*int*/ cr, double[] x1, double[] y1, double[] x2, double[] y2);
public static final synchronized native void cairo_fill_extents (long /*int*/ cr, double[] x1, double[] y1, double[] x2, double[] y2);
public static final synchronized native void cairo_init_clip (long /*int*/ cr);
public static final synchronized native void cairo_clip (long /*int*/ cr);
public static final synchronized native void cairo_select_font (long /*int*/ cr, byte[] family, int slant, int weight);
public static final synchronized native void cairo_scale_font (long /*int*/ cr, double scale);
public static final synchronized native void cairo_transform_font (long /*int*/ cr, long /*int*/ matrix);
public static final synchronized native void cairo_show_text (long /*int*/ ct, byte[] utf8);
public static final synchronized native void cairo_show_glyphs (long /*int*/ ct, long /*int*/ glyphs, int num_glyphs);
public static final synchronized native long /*int*/ cairo_current_font (long /*int*/ ct);
public static final synchronized native void cairo_current_font_extents (long /*int*/ ct, cairo_font_extents_t extents);
public static final synchronized native void cairo_set_font (long /*int*/ ct, long /*int*/ font);
public static final synchronized native void cairo_text_extents (long /*int*/ ct, byte[] utf8, long /*int*/ extents);
public static final synchronized native void cairo_glyph_extents (long /*int*/ ct, long /*int*/ glyphs, int num_glyphs, long /*int*/ extents);
public static final synchronized native void cairo_text_path  (long /*int*/ ct, byte[] utf8);
public static final synchronized native void cairo_glyph_path (long /*int*/ ct, long /*int*/ glyphs, int num_glyphs);
public static final synchronized native void cairo_font_reference (long /*int*/ font);
public static final synchronized native void cairo_font_destroy (long /*int*/ font);
public static final synchronized native void cairo_show_surface (long /*int*/ cr, long /*int*/ surface, int width, int height);
public static final synchronized native long /*int*/ cairo_current_operator (long /*int*/ cr);
public static final synchronized native void cairo_current_rgb_color (long /*int*/ cr, double[] red, double[] green, double[] blue);
public static final synchronized native long /*int*/ cairo_current_pattern (long /*int*/ cr);
public static final synchronized native	double cairo_current_alpha (long /*int*/ cr);
public static final synchronized native double cairo_current_tolerance (long /*int*/ cr);
public static final synchronized native void cairo_current_point (long /*int*/ cr, double[] x, double[] y);
public static final synchronized native int cairo_current_fill_rule (long /*int*/ cr);
public static final synchronized native double cairo_current_line_width (long /*int*/ cr);
public static final synchronized native int cairo_current_line_cap (long /*int*/ cr);
public static final synchronized native int cairo_current_line_join (long /*int*/ cr);
public static final synchronized native double cairo_current_miter_limit (long /*int*/ cr);
public static final synchronized native void cairo_current_matrix (long /*int*/ cr, long /*int*/ matrix);
public static final synchronized native long /*int*/ cairo_current_target_surface (long /*int*/ cr);
public static final synchronized native void cairo_current_path (long /*int*/ cr, long /*int*/ move_to, long /*int*/ line_to, long /*int*/ curve_to, long /*int*/ close_path,long /*int*/ closure);
public static final synchronized native void cairo_current_path_flat (long /*int*/ cr, long /*int*/ move_to, long /*int*/ line_to, long /*int*/ close_path, long /*int*/ closure);
public static final synchronized native int cairo_status (long /*int*/ cr);
public static final synchronized native long /*int*/ cairo_status_string (long /*int*/ cr);
public static final synchronized native long /*int*/ cairo_surface_create_for_image (long /*int*/ data, int format, int width, int height, int stride);
public static final synchronized native long /*int*/ cairo_surface_create_similar (long /*int*/ other, int format, int width, int height);
public static final synchronized native void cairo_surface_reference (long /*int*/ surface);
public static final synchronized native void cairo_surface_destroy (long /*int*/ surface);
public static final synchronized native int cairo_surface_set_repeat (long /*int*/ surface, int repeat);
public static final synchronized native int cairo_surface_set_matrix (long /*int*/ surface, long /*int*/ matrix);
public static final synchronized native int cairo_surface_get_matrix (long /*int*/ surface, long /*int*/ matrix);
public static final synchronized native int cairo_surface_set_filter (long /*int*/ surface, int filter);
public static final synchronized native int cairo_surface_get_filter (long /*int*/ surface);
public static final synchronized native long /*int*/ cairo_image_surface_create (int format, int width, int height);
public static final synchronized native long /*int*/ cairo_image_surface_create_for_data (long /*int*/ data, int format, int width, int height, int stride);
public static final synchronized native long /*int*/ cairo_pattern_create_for_surface (long /*int*/ surface);
public static final synchronized native long /*int*/ cairo_pattern_create_linear (double x0, double y0, double x1, double y1);
public static final synchronized native long /*int*/ cairo_pattern_create_radial (double cx0, double cy0, double radius0, double cx1, double cy1, double radius1);
public static final synchronized native void cairo_pattern_reference (long /*int*/ pattern);
public static final synchronized native void cairo_pattern_destroy (long /*int*/ pattern);
public static final synchronized native int cairo_pattern_add_color_stop (long /*int*/ pattern, double offset, double red, double green, double blue, double alpha);
public static final synchronized native int cairo_pattern_set_matrix (long /*int*/ pattern, long /*int*/ matrix);
public static final synchronized native int cairo_pattern_get_matrix (long /*int*/ pattern, long /*int*/ matrix);
public static final synchronized native int cairo_pattern_set_extend (long /*int*/ pattern, int extend);
public static final synchronized native int cairo_pattern_get_extend (long /*int*/ pattern);
public static final synchronized native int cairo_pattern_set_filter (long /*int*/ pattern, int filter);
public static final synchronized native int cairo_pattern_get_filter (long /*int*/ pattern);
public static final synchronized native long /*int*/ cairo_xlib_surface_create (long /*int*/ dpy, long /*int*/ drawable, long /*int*/ visual, int format, long /*int*/ colormap);
public static final synchronized native long /*int*/ cairo_matrix_create ();
public static final synchronized native void cairo_matrix_destroy (long /*int*/ matrix);
public static final synchronized native int cairo_matrix_copy (long /*int*/ matrix, long /*int*/ other);
public static final synchronized native int cairo_matrix_set_identity (long /*int*/ matrix);
public static final synchronized native int cairo_matrix_set_affine (long /*int*/ cr, double a, double b, double c, double d, double tx, double ty);
public static final synchronized native int cairo_matrix_get_affine (long /*int*/ matrix, double[] a, double[] b, double[] c, double[] d, double[] tx, double[] ty);
public static final synchronized native int cairo_matrix_translate (long /*int*/ matrix, double tx, double ty);
public static final synchronized native int cairo_matrix_scale (long /*int*/ matrix, double sx, double sy);
public static final synchronized native int cairo_matrix_rotate (long /*int*/ matrix, double radians);
public static final synchronized native int cairo_matrix_invert (long /*int*/ matrix);
public static final synchronized native int cairo_matrix_multiply (long /*int*/ result, long /*int*/ a, long /*int*/ b);
public static final synchronized native int cairo_matrix_transform_distance (long /*int*/ matrix, double[] dx, double[] dy);
public static final synchronized native int cairo_matrix_transform_point (long /*int*/ matrix, double[] x, double[] y);

}
