/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others. All rights reserved.
 * The contents of this file are made available under the terms
 * of the GNU Lesser General Public License (LGPL) Version 2.1 that
 * accompanies this distribution (lgpl-v21.txt).  The LGPL is also
 * available at http://www.gnu.org/licenses/lgpl.html.  If the version
 * of the LGPL at http://www.gnu.org is different to the version of
 * the LGPL accompanying this distribution and there is any conflict
 * between the two license versions, the terms of the LGPL accompanying
 * this distribution shall govern.
 *******************************************************************************/
package org.eclipse.swt.internal.gtk;

 
import org.eclipse.swt.internal.*;

public class OS extends Platform {
	static {
		Library.loadLibrary("swt-pi");
	}
	
	/** OS Constants */
	public static final boolean IsAIX, IsSunOS, IsLinux, IsHPUX;
	static {
		
		/* Initialize the OS flags and locale constants */
		String osName = System.getProperty ("os.name");
		boolean isAIX = false, isSunOS = false, isLinux = false, isHPUX = false;
		if (osName.equals ("Linux")) isLinux = true;
		if (osName.equals ("AIX")) isAIX = true;
		if (osName.equals ("Solaris")) isSunOS = true;
		if (osName.equals ("SunOS")) isSunOS = true;
		if (osName.equals ("HP-UX")) isHPUX = true;
		IsAIX = isAIX;  IsSunOS = isSunOS;  IsLinux = isLinux;  IsHPUX = isHPUX;
	}

	/** Constants */
	public static final int G_SIGNAL_MATCH_DATA = 1 << 4;
	public static final int G_SIGNAL_MATCH_ID = 1 << 0;
	public static final int GDK_2BUTTON_PRESS = 0x5;
	public static final int GDK_3BUTTON_PRESS = 0x6;
	public static final int GDK_ACTION_COPY = 1 << 1;
	public static final int GDK_ACTION_MOVE = 1 << 2;
	public static final int GDK_ACTION_LINK = 1 << 3;
	public static final int GDK_Alt_L = 0xffe9;
	public static final int GDK_Alt_R = 0xffea;
	public static final int GDK_AND = 4;
	public static final int GDK_BackSpace = 0xff08;
	public static final int GDK_BOTTOM_LEFT_CORNER = 0xc;
	public static final int GDK_BOTTOM_RIGHT_CORNER = 0xe;
	public static final int GDK_BOTTOM_SIDE = 0x10;
	public static final int GDK_BUTTON1_MASK = 0x100;
	public static final int GDK_BUTTON2_MASK = 0x200;
	public static final int GDK_BUTTON3_MASK = 0x400;
	public static final int GDK_BUTTON_MOTION_MASK	= 1 << 4;
	public static final int GDK_BUTTON1_MOTION_MASK	= 1 << 5;
	public static final int GDK_BUTTON2_MOTION_MASK	= 1 << 6;
	public static final int GDK_BUTTON3_MOTION_MASK	= 1 << 7;
	public static final int GDK_BUTTON_PRESS = 0x4;
	public static final int GDK_BUTTON_PRESS_MASK = 0x100;
	public static final int GDK_BUTTON_RELEASE = 0x7;
	public static final int GDK_BUTTON_RELEASE_MASK = 0x200;
	public static final int GDK_CAP_BUTT = 0x1;
	public static final int GDK_CAP_PROJECTING = 3;
	public static final int GDK_CAP_ROUND = 0x2;
	public static final int GDK_COLORSPACE_RGB = 0;
	public static final int GDK_CONFIGURE = 13;
	public static final int GDK_CONTROL_MASK = 0x4;
	public static final int GDK_COPY = 0x0;
	public static final int GDK_CROSS = 0x1e;
	public static final int GDK_CROSSING_NORMAL = 0;
	public static final int GDK_CROSSING_GRAB = 1;
	public static final int GDK_CROSSING_UNGRAB = 2;
	public static final int GDK_Break = 0xff6b;
	public static final int GDK_Cancel = 0xff69;
	public static final int GDK_Caps_Lock = 0xffE5;
	public static final int GDK_Clear = 0xff0B;
	public static final int GDK_Control_L = 0xffe3;
	public static final int GDK_Control_R = 0xffe4;
	public static final int GDK_CURRENT_TIME = 0x0;
	public static final int GDK_DECOR_BORDER = 0x2;
	public static final int GDK_DECOR_MAXIMIZE = 0x40;
	public static final int GDK_DECOR_MENU = 0x10;
	public static final int GDK_DECOR_MINIMIZE = 0x20;
	public static final int GDK_DECOR_RESIZEH = 0x4;
	public static final int GDK_DECOR_TITLE = 0x8;
	public static final int GDK_DOUBLE_ARROW = 0x2a;
	public static final int GDK_Delete = 0xffff;
	public static final int GDK_Down = 0xff54;
	public static final int GDK_ENTER_NOTIFY_MASK = 0x1000;
	public static final int GDK_ENTER_NOTIFY = 10;
	public static final int GDK_EVEN_ODD_RULE = 0;
	public static final int GDK_EXPOSE = 2;
	public static final int GDK_EXPOSURE_MASK = 0x2;
	public static final int GDK_End = 0xff57;
	public static final int GDK_Escape = 0xff1b;
	public static final int GDK_F1 = 0xffbe;
	public static final int GDK_F10 = 0xffc7;
	public static final int GDK_F11 = 0xffc8;
	public static final int GDK_F12 = 0xffc9;
	public static final int GDK_F13 = 0xffca;
	public static final int GDK_F14 = 0xffcb;
	public static final int GDK_F15 = 0xffcc;
	public static final int GDK_F2 = 0xffbf;
	public static final int GDK_F3 = 0xffc0;
	public static final int GDK_F4 = 0xffc1;
	public static final int GDK_F5 = 0xffc2;
	public static final int GDK_F6 = 0xffc3;
	public static final int GDK_F7 = 0xffc4;
	public static final int GDK_F8 = 0xffc5;
	public static final int GDK_F9 = 0xffc6;
	public static final int GDK_FLEUR = 0x34;
	public static final int GDK_FOCUS_CHANGE = 0xc;
	public static final int GDK_FOCUS_CHANGE_MASK = 0x4000;
	public static final int GDK_GC_CLIP_MASK = 0x80;
	public static final int GDK_GC_CLIP_X_ORIGIN = 0x800;
	public static final int GDK_GC_CLIP_Y_ORIGIN = 0x1000;
	public static final int GDK_GRAB_SUCCESS = 0x0;
	public static final int GDK_HAND2 = 0x3c;
	public static final int GDK_Help = 0xFF6A;
	public static final int GDK_HINT_MIN_SIZE = 1 << 1;
	public static final int GDK_Home = 0xff50;
	public static final int GDK_INCLUDE_INFERIORS = 0x1;
	public static final int GDK_INPUT_ONLY = 1;
	public static final int GDK_INTERP_BILINEAR = 0x2;
	public static final int GDK_Insert = 0xff63;
	public static final int GDK_ISO_Left_Tab = 0xfe20;
	public static final int GDK_JOIN_MITER = 0x0;
	public static final int GDK_JOIN_ROUND = 0x1;
	public static final int GDK_JOIN_BEVEL = 0x2;
	public static final int GDK_KEY_PRESS = 0x8;
	public static final int GDK_KEY_PRESS_MASK = 0x400;
	public static final int GDK_KEY_RELEASE = 0x9;
	public static final int GDK_KEY_RELEASE_MASK = 0x800;
	public static final int GDK_KP_0 = 0xffb0;
	public static final int GDK_KP_1 = 0xffb1;
	public static final int GDK_KP_2 = 0xffb2;
	public static final int GDK_KP_3 = 0xffb3;
	public static final int GDK_KP_4 = 0xffb4;
	public static final int GDK_KP_5 = 0xffb5;
	public static final int GDK_KP_6 = 0xffb6;
	public static final int GDK_KP_7 = 0xffb7;
	public static final int GDK_KP_8 = 0xffb8;
	public static final int GDK_KP_9 = 0xffb9;
	public static final int GDK_KP_Add = 0xffab;
	public static final int GDK_KP_Decimal = 0xffae;
	public static final int GDK_KP_Delete = 0xFF9F;
	public static final int GDK_KP_Divide = 0xffaf;
	public static final int GDK_KP_Down = 0xFF99;
	public static final int GDK_KP_End = 0xFF9C;
	public static final int GDK_KP_Enter = 0xff8d;
	public static final int GDK_KP_Equal = 0xffbd;
	public static final int GDK_KP_Home = 0xFF95;
	public static final int GDK_KP_Insert = 0xFF9E;
	public static final int GDK_KP_Left = 0xFF96;
	public static final int GDK_KP_Multiply = 0xffaa;
	public static final int GDK_KP_Page_Down = 0xFF9B;
	public static final int GDK_KP_Page_Up = 0xFF9A;
	public static final int GDK_KP_Right = 0xFF98;
	public static final int GDK_KP_Subtract = 0xffad;
	public static final int GDK_KP_Up = 0xFF97;
	public static final int GDK_LEAVE_NOTIFY = 11;
	public static final int GDK_LEAVE_NOTIFY_MASK = 0x2000;
	public static final int GDK_LEFT_PTR = 0x44;
	public static final int GDK_LEFT_SIDE = 0x46;
	public static final int GDK_LINE_ON_OFF_DASH = 0x1;
	public static final int GDK_LINE_SOLID = 0x0;
	public static final int GDK_Linefeed = 0xff0A;
	public static final int GDK_LSB_FIRST = 0x0;
	public static final int GDK_Left = 0xff51;
	public static final int GDK_Meta_L = 0xFFE7;
	public static final int GDK_Meta_R = 0xFFE8;
	public static final int GDK_MAP = 14;
	public static final int GDK_MOD1_MASK = 0x8;
	public static final int GDK_MOTION_NOTIFY = 0x3;
	public static final int GDK_NO_EXPOSE = 30;
	public static final int GDK_NONE = 0;
	public static final int GDK_NOTIFY_INFERIOR = 2;
	public static final int GDK_Num_Lock = 0xFF7F;
	public static final int GDK_OVERLAP_RECTANGLE_OUT = 0x1;
	public static final int GDK_PIXBUF_ALPHA_BILEVEL = 0x0;
	public static final int GDK_POINTER_MOTION_HINT_MASK = 0x8;
	public static final int GDK_POINTER_MOTION_MASK = 0x4;
	public static final int GDK_PROPERTY_NOTIFY = 16;
	public static final int GDK_Page_Down = 0xff56;
	public static final int GDK_Page_Up = 0xff55;
	public static final int GDK_Pause = 0xff13;
	public static final int GDK_Print = 0xff61;
	public static final int GDK_QUESTION_ARROW = 0x5c;
	public static final int GDK_RGB_DITHER_NORMAL = 0x1;
	public static final int GDK_RIGHT_SIDE = 0x60;
	public static final int GDK_Return = 0xff0d;
	public static final int GDK_Right = 0xff53;
	public static final int GDK_space = 0x20;
	public static final int GDK_SB_H_DOUBLE_ARROW = 0x6c;
	public static final int GDK_SB_UP_ARROW = 0x72;
	public static final int GDK_SB_V_DOUBLE_ARROW = 0x74;
	public static final int GDK_SCROLL_UP = 0; 
	public static final int GDK_SCROLL_DOWN = 1;
	public static final int GDK_SCROLL_LEFT = 2;
	public static final int GDK_SCROLL_RIGHT = 3;
	public static final int GDK_SELECTION_CLEAR = 17;
	public static final int GDK_SELECTION_NOTIFY = 19;
	public static final int GDK_SELECTION_REQUEST = 18;
	public static final int GDK_SHIFT_MASK = 0x1;
	public static final int GDK_SIZING = 0x78;
	public static final int GDK_STIPPLED = 0x2;
	public static final int GDK_Shift_L = 0xffe1;
	public static final int GDK_Shift_R = 0xffe2;
	public static final int GDK_SCROLL = 31;
	public static final int GDK_Scroll_Lock = 0xff14;
	public static final int GDK_TOP_LEFT_CORNER = 0x86;
	public static final int GDK_TOP_RIGHT_CORNER = 0x88;
	public static final int GDK_TOP_SIDE = 0x8a;
	public static final int GDK_Tab = 0xff09;
	public static final int GDK_Up = 0xff52;
	public static final int GDK_WATCH = 0x96;
	public static final int GDK_XOR = 0x2;
	public static final int GDK_XTERM = 0x98;
	public static final int GDK_X_CURSOR = 0x0;
	public static final int GDK_VISIBILITY_FULLY_OBSCURED = 2;
	public static final int GDK_VISIBILITY_NOTIFY_MASK = 1 << 17;
	public static final int GDK_WINDOW_CHILD = 2;
	public static final int GDK_WINDOW_STATE_ICONIFIED  = 1 << 1;
	public static final int GDK_WINDOW_STATE_MAXIMIZED  = 1 << 2;
	public static final int GTK_ACCEL_VISIBLE = 0x1;
	public static final int GTK_ARROW_DOWN = 0x1;
	public static final int GTK_ARROW_LEFT = 0x2;
	public static final int GTK_ARROW_RIGHT = 0x3;
	public static final int GTK_ARROW_UP = 0x0;
	public static final int GTK_CAN_DEFAULT = 0x2000;
	public static final int GTK_CAN_FOCUS = 0x800;
	public static final int GTK_CELL_RENDERER_MODE_ACTIVATABLE = 1;
	public static final int GTK_CLIST_SHOW_TITLES = 0x4;
	public static final int GTK_CORNER_TOP_LEFT = 0x0;
	public static final int GTK_CORNER_TOP_RIGHT = 0x2;
	public static final int GTK_DIALOG_DESTROY_WITH_PARENT = 1 << 1;
	public static final int GTK_DIALOG_MODAL = 1 << 0;
	public static final int GTK_DIR_TAB_FORWARD = 0;
	public static final int GTK_DIR_TAB_BACKWARD = 1;
	public static final int GTK_FILE_CHOOSER_ACTION_OPEN = 0;
	public static final int GTK_FILE_CHOOSER_ACTION_SAVE = 1;
	public static final int GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER = 2;
	public static final int GTK_HAS_FOCUS = 1 << 12;
	public static final int GTK_ICON_SIZE_DIALOG = 6;
	public static final int GTK_JUSTIFY_CENTER = 0x2;
	public static final int GTK_JUSTIFY_LEFT = 0x0;
	public static final int GTK_JUSTIFY_RIGHT = 0x1;
	public static final int GTK_MAPPED = 1 << 7;
	public static final int GTK_MESSAGE_INFO = 0;
	public static final int GTK_MESSAGE_WARNING = 1;
	public static final int GTK_MESSAGE_QUESTION = 2;
	public static final int GTK_MESSAGE_ERROR = 3;
	public static final int GTK_NO_WINDOW = 1 << 5;
	public static final int GTK_ORIENTATION_HORIZONTAL = 0x0;
	public static final int GTK_ORIENTATION_VERTICAL = 0x1;
	public static final int GTK_PACK_START = 0;
	public static final int GTK_POLICY_ALWAYS = 0x0;
	public static final int GTK_POLICY_AUTOMATIC = 0x1;
	public static final int GTK_POLICY_NEVER = 0x2;
	public static final int GTK_POS_BOTTOM = 0x3;
	public static final int GTK_PROGRESS_CONTINUOUS = 0x0;
	public static final int GTK_PROGRESS_DISCRETE = 0x1;
	public static final int GTK_PROGRESS_LEFT_TO_RIGHT = 0x0;
	public static final int GTK_PROGRESS_BOTTOM_TO_TOP = 0x2;
	public static final int GTK_REALIZED  = 1 << 6;
	public static final int GTK_RELIEF_NONE = 0x2;
	public static final int GTK_RC_BG = 1 << 1;
	public static final int GTK_RC_FG = 1 << 0;
	public static final int GTK_RESPONSE_CANCEL = 0xfffffffa;
	public static final int GTK_RESPONSE_OK = 0xfffffffb;
	public static final int GTK_SELECTION_BROWSE = 0x2;
	public static final int GTK_SELECTION_MULTIPLE = 0x3;
	public static final int GTK_SENSITIVE = 0x200;
	public static final int GTK_SHADOW_ETCHED_IN = 0x3;
	public static final int GTK_SHADOW_ETCHED_OUT = 0x4;
	public static final int GTK_SHADOW_IN = 0x1;
	public static final int GTK_SHADOW_NONE = 0x0;
	public static final int GTK_SHADOW_OUT = 0x2;
	public static final int GTK_STATE_ACTIVE = 0x1;
	public static final int GTK_STATE_INSENSITIVE = 0x4;
	public static final int GTK_STATE_NORMAL = 0x0;
	public static final int GTK_STATE_PRELIGHT = 0x2;
	public static final int GTK_STATE_SELECTED = 0x3;
	public static final int GTK_TEXT_DIR_LTR = 1;
	public static final int GTK_TEXT_DIR_NONE = 0 ;
	public static final int GTK_TEXT_DIR_RTL = 2;
	public static final int GTK_TEXT_WINDOW_TEXT = 2;
	public static final int GTK_TOOLBAR_CHILD_BUTTON = 0x1;
	public static final int GTK_TOOLBAR_CHILD_RADIOBUTTON = 0x3;
	public static final int GTK_TOOLBAR_CHILD_TOGGLEBUTTON = 0x2;
	public static final int GTK_TREE_VIEW_COLUMN_GROW_ONLY = 0;
	public static final int GTK_TREE_VIEW_COLUMN_AUTOSIZE = 1;
	public static final int GTK_TREE_VIEW_COLUMN_FIXED = 2;
	public static final int GTK_TREE_VIEW_DROP_BEFORE = 0;
	public static final int GTK_TREE_VIEW_DROP_AFTER = 1;
	public static final int GTK_TREE_VIEW_DROP_INTO_OR_BEFORE = 2;
	public static final int GTK_TREE_VIEW_DROP_INTO_OR_AFTER = 3;
	public static final int GDK_UNMAP = 15;
	public static final int GTK_VISIBILITY_FULL = 0x2;
	public static final int GTK_VISIBILITY_NONE = 0x0;
	public static final int GTK_VISIBLE = 0x100;
	public static final int GDK_WA_X = 1 << 2;
	public static final int GDK_WA_Y = 1 << 3;
	public static final int GTK_WINDOW_POPUP = 0x1;
	public static final int GTK_WINDOW_TOPLEVEL = 0x0;
	public static final int GDK_WINDOW_TYPE_HINT_DIALOG = 1;
	public static final int GTK_WRAP_NONE = 0;
	public static final int GTK_WRAP_WORD = 2;
	public static final int G_LOG_FLAG_FATAL = 0x2;
	public static final int G_LOG_FLAG_RECURSION = 0x1;
	public static final int G_LOG_LEVEL_MASK = 0xfffffffc;
	public static final int None = 0;
	public static final int PANGO_ALIGN_LEFT = 0;
	public static final int PANGO_ALIGN_CENTER = 1;
	public static final int PANGO_ALIGN_RIGHT = 2;
	public static final int PANGO_DIRECTION_LTR = 0;
	public static final int PANGO_DIRECTION_RTL = 1;	
	public static final int PANGO_SCALE = 1024;
	public static final int PANGO_STRETCH_NORMAL = 0x4;
	public static final int PANGO_STYLE_ITALIC = 0x2;
	public static final int PANGO_STYLE_NORMAL = 0x0;
	public static final int PANGO_STYLE_OBLIQUE = 0x1;
	public static final int PANGO_TAB_LEFT = 0;
	public static final int PANGO_UNDERLINE_LOW = 3;
	public static final int PANGO_UNDERLINE_SINGLE = 1;
	public static final int PANGO_WEIGHT_BOLD = 0x2bc;
	public static final int PANGO_WEIGHT_NORMAL = 0x190;
	public static final int PANGO_WRAP_WORD = 0;
	public static final int PANGO_WRAP_WORD_CHAR = 2;
	public static final int XA_CARDINAL = 6;
	public static final int XA_WINDOW = 33;
	
	/** Signals */
	public static final byte[] activate = ascii("activate");
	public static final byte[] button_press_event = ascii("button-press-event");
	public static final byte[] button_release_event = ascii("button-release-event");
	public static final byte[] changed = ascii("changed");
	public static final byte[] change_current_page = ascii("change-current-page");
	public static final byte[] clicked = ascii("clicked");
	public static final byte[] commit = ascii("commit");
	public static final byte[] configure_event = ascii("configure-event");
	public static final byte[] delete_event = ascii("delete-event");
	public static final byte[] delete_range = ascii("delete-range");
	public static final byte[] delete_text = ascii("delete-text");
	public static final byte[] drag_data_delete = ascii("drag_data_delete");
	public static final byte[] drag_data_get = ascii("drag_data_get");
	public static final byte[] drag_data_received = ascii("drag_data_received");
	public static final byte[] drag_drop = ascii("drag_drop");
	public static final byte[] drag_end = ascii("drag_end");
	public static final byte[] drag_leave = ascii("drag_leave");
	public static final byte[] drag_motion = ascii("drag_motion");
	public static final byte[] enter_notify_event = ascii("enter-notify-event");
	public static final byte[] event = ascii("event");
	public static final byte[] event_after = ascii("event-after");
	public static final byte[] expand_collapse_cursor_row = ascii("expand-collapse-cursor-row");
	public static final byte[] expose_event = ascii("expose-event");
	public static final byte[] focus = ascii("focus");
	public static final byte[] focus_in_event = ascii("focus-in-event");
	public static final byte[] focus_out_event = ascii("focus-out-event");
	public static final byte[] hide = ascii("hide");
	public static final byte[] input = ascii("input");
	public static final byte[] insert_text = ascii("insert-text");
	public static final byte[] key_press_event = ascii("key-press-event");
	public static final byte[] key_release_event = ascii("key-release-event");
	public static final byte[] leave_notify_event = ascii("leave-notify-event");
	public static final byte[] map = ascii("map");
	public static final byte[] map_event = ascii("map-event");
	public static final byte[] mnemonic_activate = ascii("mnemonic-activate");
	public static final byte[] motion_notify_event = ascii("motion-notify-event");
	public static final byte[] move_focus = ascii("move-focus");
	public static final byte[] output = ascii("output");
	public static final byte[] popup_menu = ascii("popup-menu");
	public static final byte[] preedit_changed = ascii("preedit-changed");
	public static final byte[] realize = ascii("realize");
	public static final byte[] row_activated = ascii("row-activated");
	public static final byte[] row_changed = ascii("row-changed");
	public static final byte[] scroll_child = ascii("scroll-child");
	public static final byte[] scroll_event = ascii("scroll-event");
	public static final byte[] select = ascii("select");
	public static final byte[] show = ascii("show");
	public static final byte[] show_help = ascii("show-help");
	public static final byte[] size_allocate = ascii("size-allocate");
	public static final byte[] style_set = ascii("style-set");
	public static final byte[] switch_page = ascii("switch-page");
	public static final byte[] test_collapse_row = ascii("test-collapse-row");
	public static final byte[] test_expand_row = ascii("test-expand-row");
	public static final byte[] toggled = ascii("toggled");
	public static final byte[] unmap = ascii("unmap");
	public static final byte[] unmap_event = ascii("unmap-event");
	public static final byte[] unrealize = ascii("unrealize");
	public static final byte[] value_changed = ascii("value-changed");
	public static final byte[] visibility_notify_event = ascii("visibility-notify-event");
	public static final byte[] window_state_event = ascii("window-state-event");
	
	/** Properties */
	public static final byte[] active = ascii("active");
	public static final byte[] background_gdk = ascii("background-gdk");
	public static final byte[] button_relief = ascii("button-relief");
	public static final byte[] cell_background_gdk = ascii("cell-background-gdk");
	public static final byte[] default_border = ascii("default-border");
	public static final byte[] expander_size = ascii("expander-size");
	public static final byte[] fixed_height_mode = ascii("fixed-height-mode");
	public static final byte[] focus_line_width = ascii("focus-line-width");
	public static final byte[] font_desc = ascii("font-desc");
	public static final byte[] foreground_gdk = ascii("foreground-gdk");
	public static final byte[] gtk_cursor_blink = ascii("gtk-cursor-blink");
	public static final byte[] gtk_cursor_blink_time = ascii("gtk-cursor-blink-time");
	public static final byte[] gtk_double_click_time = ascii("gtk-double-click-time");
	public static final byte[] horizontal_separator = ascii("horizontal-separator");
	public static final byte[] inconsistent = ascii("inconsistent");
	public static final byte[] interior_focus = ascii("interior-focus");
	public static final byte[] mode = ascii("mode");
	public static final byte[] pixbuf = ascii("pixbuf");
	public static final byte[] text = ascii("text");
	public static final byte[] xalign = ascii("xalign");
	
	public static final int GTK_VERSION = VERSION(gtk_major_version(), gtk_minor_version(), gtk_micro_version()); 
	
protected static byte [] ascii (String name) {
	int length = name.length ();
	char [] chars = new char [length];
	name.getChars (0, length, chars, 0);
	byte [] buffer = new byte [length + 1];
	for (int i=0; i<length; i++) {
		buffer [i] = (byte) chars [i];
	}
	return buffer;
}

public static int VERSION(int major, int minor, int micro) {
	return (major << 16) + (minor << 8) + micro;
}

/** 64 bit */
public static final int PTR_SIZEOF = PTR_sizeof();
public static final native int PTR_sizeof();
public static final native int GInterfaceInfo_sizeof ();
public static final native int GPollFD_sizeof ();
public static final native int GTypeInfo_sizeof ();
public static final native int GTypeQuery_sizeof ();
public static final native int GdkColor_sizeof();
public static final native int GdkDragContext_sizeof();
public static final native int GdkEvent_sizeof();
public static final native int GdkEventButton_sizeof();
public static final native int GdkEventCrossing_sizeof();
public static final native int GdkEventExpose_sizeof();
public static final native int GdkEventFocus_sizeof();
public static final native int GdkEventKey_sizeof();
public static final native int GdkEventMotion_sizeof();
public static final native int GdkEventScroll_sizeof();
public static final native int GdkEventVisibility_sizeof();
public static final native int GdkEventWindowState_sizeof();
public static final native int GdkGCValues_sizeof();
public static final native int GdkGeometry_sizeof();
public static final native int GdkImage_sizeof();
public static final native int GdkRectangle_sizeof();
public static final native int GdkVisual_sizeof();
public static final native int GdkWindowAttr_sizeof();
public static final native int GtkAdjustment_sizeof();
public static final native int GtkAllocation_sizeof();
public static final native int GtkBorder_sizeof();
public static final native int GtkColorSelectionDialog_sizeof();
public static final native int GtkCombo_sizeof();
public static final native int GtkFileSelection_sizeof();
public static final native int GtkFixed_sizeof();
public static final native int GtkFixedClass_sizeof();
public static final native int GtkRequisition_sizeof();
public static final native int GtkSelectionData_sizeof();
public static final native int GtkTargetEntry_sizeof();
public static final native int GtkTargetPair_sizeof();
public static final native int GtkTextIter_sizeof();
public static final native int GtkTreeIter_sizeof();
public static final native int PangoAttribute_sizeof();
public static final native int PangoItem_sizeof();
public static final native int PangoLayoutLine_sizeof();
public static final native int PangoLayoutRun_sizeof();
public static final native int PangoLogAttr_sizeof();
public static final native int PangoRectangle_sizeof();
public static final native int XAnyEvent_sizeof();
public static final native int XButtonEvent_sizeof();
public static final native int XClientMessageEvent_sizeof();
public static final native int XEvent_sizeof();
public static final native int XCrossingEvent_sizeof();
public static final native int XExposeEvent_sizeof();
public static final native int XFocusChangeEvent_sizeof();
public static final native int XVisibilityEvent_sizeof();
public static final native int XWindowChanges_sizeof();
public static final native long /*int*/ getenv(byte[] name);
public static final native long /*int*/ localeconv_decimal_point();
public static final native int strlen(long /*int*/ str);

/** Object private fields accessors */
public static final native int GTK_WIDGET_HEIGHT(long /*int*/ widget);
public static final native int GTK_WIDGET_WIDTH(long /*int*/ widget);
public static final native long /*int*/ GTK_WIDGET_WINDOW(long /*int*/ widget);
public static final native int GTK_WIDGET_X(long /*int*/ widget);
public static final native int GTK_WIDGET_Y(long /*int*/ widget);
public static final native long /*int*/ GTK_SCROLLED_WINDOW_HSCROLLBAR(long /*int*/ widget);
public static final native long /*int*/ GTK_SCROLLED_WINDOW_VSCROLLBAR(long /*int*/ widget);
public static final native int GTK_SCROLLED_WINDOW_SCROLLBAR_SPACING(long /*int*/ widget);
public static final native void GTK_ACCEL_LABEL_SET_ACCEL_STRING(long /*int*/ acce_label, long /*int*/ string);
public static final native long /*int*/ GTK_ACCEL_LABEL_GET_ACCEL_STRING(long /*int*/ acce_label);
public static final native long /*int*/ GTK_ENTRY_IM_CONTEXT(long /*int*/ widget);
public static final native long /*int*/ GTK_TEXTVIEW_IM_CONTEXT(long /*int*/ widget);
public static final native void GTK_WIDGET_SET_HEIGHT(long /*int*/ widget, int height);
public static final native void GTK_WIDGET_SET_WIDTH(long /*int*/ widget, int width);
public static final native void GTK_WIDGET_SET_X(long /*int*/ widget, int x);
public static final native void GTK_WIDGET_SET_Y(long /*int*/ widget, int y);
public static final native int GTK_WIDGET_REQUISITION_WIDTH(long /*int*/ widget);
public static final native int GTK_WIDGET_REQUISITION_HEIGHT(long /*int*/ widget);

/** X11 Native methods and constants */
public static final int Above = 0;
public static final int Below = 1;
public static final int ButtonRelease = 5;
public static final int ClientMessage = 33;
public static final int CurrentTime = 0;
public static final int CWSibling = 0x20;
public static final int CWStackMode = 0x40;
public static final int EnterNotify = 7;
public static final int Expose = 12;
public static final int FocusChangeMask = 1 << 21;
public static final int FocusIn = 9;
public static final int FocusOut = 10;
public static final int GraphicsExpose = 13;
public static final int NoExpose = 14;
public static final int ExposureMask = 1 << 15;
public static final long /*int*/ NoEventMask = 0;
public static final int NotifyNonlinear = 3;
public static final int NotifyPointer = 5;
public static final int RevertToParent = 2;
public static final int VisibilityChangeMask = 1 << 16;
public static final int VisibilityFullyObscured = 2;
public static final int VisibilityNotify = 15;
public static final int SYSTEM_TRAY_REQUEST_DOCK = 0;
public static final native int _Call(long /*int*/ proc, long /*int*/ arg1, long /*int*/ arg2);
public static final int Call(long /*int*/ proc, long /*int*/ arg1, long /*int*/ arg2) {
	lock.lock();
	try {
		return _Call(proc, arg1, arg2);
	} finally {
		lock.unlock();
	}
}
public static final native boolean GDK_WINDOWING_X11();
public static final native long /*int*/ _GDK_PIXMAP_XID(long /*int*/ pixmap);
public static final long /*int*/ GDK_PIXMAP_XID(long /*int*/ pixmap) {
	lock.lock();
	try {
		return _GDK_PIXMAP_XID(pixmap);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _XCheckMaskEvent(long /*int*/ display, long /*int*/ event_mask, long /*int*/ event_return);
public static final boolean XCheckMaskEvent(long /*int*/ display, long /*int*/ event_mask, long /*int*/ event_return) {
	lock.lock();
	try {
		return _XCheckMaskEvent(display, event_mask, event_return);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _XCheckWindowEvent(long /*int*/ display, long /*int*/ window, long /*int*/ event_mask, long /*int*/ event_return);
public static final boolean XCheckWindowEvent(long /*int*/ display, long /*int*/ window, long /*int*/ event_mask, long /*int*/ event_return) {
	lock.lock();
	try {
		return _XCheckWindowEvent(display, window, event_mask, event_return);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _XCheckIfEvent(long /*int*/ display, long /*int*/ event_return, long /*int*/ predicate, long /*int*/ arg);
public static final boolean XCheckIfEvent(long /*int*/ display, long /*int*/ event_return, long /*int*/ predicate, long /*int*/ arg) {
	lock.lock();
	try {
		return _XCheckIfEvent(display, event_return, predicate, arg);
	} finally {
		lock.unlock();
	}
}
public static final native int _XDefaultScreen(long /*int*/ display);
public static final int XDefaultScreen(long /*int*/ display) {
	lock.lock();
	try {
		return _XDefaultScreen(display);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _XDefaultRootWindow(long /*int*/ display);
public static final long /*int*/ XDefaultRootWindow(long /*int*/ display) {
	lock.lock();
	try {
		return _XDefaultRootWindow(display);
	} finally {
		lock.unlock();
	}
}
public static final native void _XFlush(long /*int*/ display);
public static final void XFlush(long /*int*/ display) {
	lock.lock();
	try {
		_XFlush(display);
	} finally {
		lock.unlock();
	}
}
public static final native void _XFree(long /*int*/ address);
public static final void XFree(long /*int*/ address) {
	lock.lock();
	try {
		_XFree(address);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _XGetSelectionOwner(long /*int*/ display, long /*int*/ selection);
public static final long /*int*/ XGetSelectionOwner(long /*int*/ display, long /*int*/ selection) {
	lock.lock();
	try {
		return _XGetSelectionOwner(display, selection);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _XInternAtom(long /*int*/ display, byte[] name, boolean ifExists);
public static final long /*int*/ XInternAtom(long /*int*/ display, byte[] name, boolean ifExists) {
	lock.lock();
	try {
		return _XInternAtom(display, name, ifExists);
	} finally {
		lock.unlock();
	}
}
public static final native int _XQueryTree(long /*int*/ display, long /*int*/ w, long /*int*/[] root_return, long /*int*/[] parent_return, long /*int*/[] children_return, int[] nchildren_return);
public static final int XQueryTree(long /*int*/ display, long /*int*/ w, long /*int*/[] root_return, long /*int*/[] parent_return, long /*int*/[] children_return, int[] nchildren_return) {
	lock.lock();
	try {
		return _XQueryTree(display, w, root_return, parent_return, children_return, nchildren_return);
	} finally {
		lock.unlock();
	}
}
public static final native int _XKeysymToKeycode(long /*int*/ display, long /*int*/ keysym);
public static final int XKeysymToKeycode(long /*int*/ display, long /*int*/ keysym) {
	lock.lock();
	try {
		return _XKeysymToKeycode(display, keysym);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _XListProperties(long /*int*/ display, long /*int*/ window, int[] num_prop_return);
public static final long /*int*/ XListProperties(long /*int*/ display, long /*int*/ window, int[] num_prop_return) {
	lock.lock();
	try {
		return _XListProperties(display, window, num_prop_return);
	} finally {
		lock.unlock();
	}
}
public static final native int _XReconfigureWMWindow(long /*int*/ display, long /*int*/ window, int screen, int valueMask, XWindowChanges values);
public static final int XReconfigureWMWindow(long /*int*/ display, long /*int*/ window, int screen, int valueMask, XWindowChanges values) {
	lock.lock();
	try {
		return _XReconfigureWMWindow(display, window, screen, valueMask, values);
	} finally {
		lock.unlock();
	}
}
public static final native int _XSendEvent(long /*int*/ display, long /*int*/ w, boolean propogate, long /*int*/ event_mask, long /*int*/ event_send);
public static final int XSendEvent(long /*int*/ display, long /*int*/ w, boolean propogate, long /*int*/ event_mask, long /*int*/ event_send) {
	lock.lock();
	try {
		return _XSendEvent(display, w, propogate, event_mask, event_send);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _XSetIOErrorHandler(long /*int*/ handler);
public static final long /*int*/ XSetIOErrorHandler(long /*int*/ handler) {
	lock.lock();
	try {
		return _XSetIOErrorHandler(handler);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _XSetErrorHandler(long /*int*/ handler);
public static final long /*int*/ XSetErrorHandler(long /*int*/ handler) {
	lock.lock();
	try {
		return _XSetErrorHandler(handler);
	} finally {
		lock.unlock();
	}
}
public static final native int _XSetInputFocus(long /*int*/ display, long /*int*/ window, int revert, int time);
public static final int XSetInputFocus(long /*int*/ display, long /*int*/ window, int revert, int time) {
	lock.lock();
	try {
		return _XSetInputFocus(display, window, revert, time);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _XSynchronize(long /*int*/ display, boolean onoff);
public static final long /*int*/ XSynchronize(long /*int*/ display, boolean onoff) {
	lock.lock();
	try {
		return _XSynchronize(display, onoff);
	} finally {
		lock.unlock();
	}
}
public static final native void _XTestFakeButtonEvent(long /*int*/ display, int button, boolean is_press, long /*int*/ delay);
public static final void XTestFakeButtonEvent(long /*int*/ display, int button, boolean is_press, long /*int*/ delay) {
	lock.lock();
	try {
		_XTestFakeButtonEvent(display, button, is_press, delay);
	} finally {
		lock.unlock();
	}
}
public static final native void _XTestFakeKeyEvent(long /*int*/ display, int keycode, boolean is_press, long /*int*/ delay);
public static final void XTestFakeKeyEvent(long /*int*/ display, int keycode, boolean is_press, long /*int*/ delay) {
	lock.lock();
	try {
		_XTestFakeKeyEvent(display, keycode, is_press, delay);
	} finally {
		lock.unlock();
	}
}
public static final native void _XTestFakeMotionEvent(long /*int*/ display, int screen_number, int x, int y, long /*int*/ delay);
public static final void XTestFakeMotionEvent(long /*int*/ display, int screen_number, int x, int y, long /*int*/ delay) {
	lock.lock();
	try {
		_XTestFakeMotionEvent(display, screen_number, x, y, delay);
	} finally {
		lock.unlock();
	}
}
public static final native int _XWarpPointer(long /*int*/ display, long /*int*/ sourceWindow, long /*int*/ destWindow, int sourceX, int sourceY, int sourceWidth, int sourceHeight, int destX, int destY);
public static final int XWarpPointer(long /*int*/ display, long /*int*/ sourceWindow, long /*int*/ destWindow, int sourceX, int sourceY, int sourceWidth, int sourceHeight, int destX, int destY) {
	lock.lock();
	try {
		return _XWarpPointer(display, sourceWindow, destWindow, sourceX, sourceY, sourceWidth, sourceHeight, destX, destY);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_x11_atom_to_xatom(long /*int*/ atom);
public static final long /*int*/ gdk_x11_atom_to_xatom(long /*int*/ atom) {
	lock.lock();
	try {
		return _gdk_x11_atom_to_xatom(atom);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_x11_colormap_get_xcolormap(long /*int*/ colormap);
public static final long /*int*/ gdk_x11_colormap_get_xcolormap(long /*int*/ colormap) {
	lock.lock();
	try {
		return _gdk_x11_colormap_get_xcolormap(colormap);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_x11_drawable_get_xdisplay(long /*int*/ drawable);
public static final long /*int*/ gdk_x11_drawable_get_xdisplay(long /*int*/ drawable) {
	lock.lock();
	try {
		return _gdk_x11_drawable_get_xdisplay(drawable);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_x11_drawable_get_xid(long /*int*/ drawable);
public static final long /*int*/ gdk_x11_drawable_get_xid(long /*int*/ drawable) {
	lock.lock();
	try {
		return _gdk_x11_drawable_get_xid(drawable);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_x11_screen_get_window_manager_name(long /*int*/ screen);
public static final long /*int*/ gdk_x11_screen_get_window_manager_name(long /*int*/ screen) {	
	lock.lock();
	try {
		return _gdk_x11_screen_get_window_manager_name(screen);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_x11_visual_get_xvisual(long /*int*/ visual);
public static final long /*int*/ gdk_x11_visual_get_xvisual(long /*int*/ visual) {
	lock.lock();
	try {
		return _gdk_x11_visual_get_xvisual(visual);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_pixmap_foreign_new(long /*int*/ anid);
public static final long /*int*/ gdk_pixmap_foreign_new(long /*int*/ anid) {
	lock.lock();
	try {
		return _gdk_pixmap_foreign_new(anid);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_window_lookup(long /*int*/ xid);
public static final long /*int*/ gdk_window_lookup(long /*int*/ xid) {
	lock.lock();
	try {
		return _gdk_window_lookup(xid);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_add_filter(long /*int*/ window, long /*int*/ function, long /*int*/ data);
public static final void gdk_window_add_filter(long /*int*/ window, long /*int*/ function, long /*int*/ data) {
	lock.lock();
	try {
		_gdk_window_add_filter(window, function, data);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_remove_filter(long /*int*/ window, long /*int*/ function, long /*int*/ data);
public static final void gdk_window_remove_filter(long /*int*/ window, long /*int*/ function, long /*int*/ data) {
	lock.lock();
	try {
		_gdk_window_remove_filter(window, function, data);
	} finally {
		lock.unlock();
	}
}
public static final native void memmove(long /*int*/ dest, XButtonEvent src, long /*int*/ size);
public static final native void memmove(long /*int*/ dest, XClientMessageEvent src, long /*int*/ size);
public static final native void memmove(long /*int*/ dest, XCrossingEvent src, long /*int*/ size);
public static final native void memmove(long /*int*/ dest, XExposeEvent src, long /*int*/ size);
public static final native void memmove(long /*int*/ dest, XFocusChangeEvent src, long /*int*/ size);
public static final native void memmove(XButtonEvent dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(XCrossingEvent dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(XExposeEvent dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(XFocusChangeEvent dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(XVisibilityEvent dest, long /*int*/ src, long /*int*/ size);

/** Natives */
public static final native int Call (long /*int*/ func, long /*int*/ arg0, int arg1, int arg2);
public static final native long /*int*/ _GDK_DISPLAY();
public static final long /*int*/ GDK_DISPLAY() {
	lock.lock();
	try {
		return _GDK_DISPLAY();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _GDK_ROOT_PARENT();
public static final long /*int*/ GDK_ROOT_PARENT() {
	lock.lock();
	try {
		return _GDK_ROOT_PARENT();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _GDK_TYPE_COLOR();
public static final long /*int*/ GDK_TYPE_COLOR() {
	lock.lock();
	try {
		return _GDK_TYPE_COLOR();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _GDK_TYPE_PIXBUF();
public static final long /*int*/ GDK_TYPE_PIXBUF() {
	lock.lock();
	try {
		return _GDK_TYPE_PIXBUF();
	} finally {
		lock.unlock();
	}
}
public static final native boolean _GTK_IS_BUTTON(long /*int*/ obj);
public static final boolean GTK_IS_BUTTON(long /*int*/ obj) {
	lock.lock();
	try {
		return _GTK_IS_BUTTON(obj);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _GTK_IS_CELL_RENDERER_PIXBUF(long /*int*/ obj);
public static final boolean GTK_IS_CELL_RENDERER_PIXBUF(long /*int*/ obj) {
	lock.lock();
	try {
		return _GTK_IS_CELL_RENDERER_PIXBUF(obj);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _GTK_IS_CELL_RENDERER_TEXT(long /*int*/ obj);
public static final boolean GTK_IS_CELL_RENDERER_TEXT(long /*int*/ obj) {
	lock.lock();
	try {
		return _GTK_IS_CELL_RENDERER_TEXT(obj);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _GTK_IS_CONTAINER(long /*int*/ obj);
public static final boolean GTK_IS_CONTAINER(long /*int*/ obj) {
	lock.lock();
	try {
		return _GTK_IS_CONTAINER(obj);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _GTK_IS_IMAGE_MENU_ITEM(long /*int*/ obj);
public static final boolean GTK_IS_IMAGE_MENU_ITEM(long /*int*/ obj) {
	lock.lock();
	try {
		return _GTK_IS_IMAGE_MENU_ITEM(obj);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _GTK_STOCK_CANCEL();
public static final long /*int*/ GTK_STOCK_CANCEL() {
	lock.lock();
	try {
		return _GTK_STOCK_CANCEL();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _GTK_STOCK_OK();
public static final long /*int*/ GTK_STOCK_OK() {
	lock.lock();
	try {
		return _GTK_STOCK_OK();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _GTK_TYPE_FIXED();
public static final long /*int*/ GTK_TYPE_FIXED() {
	lock.lock();
	try {
		return _GTK_TYPE_FIXED();
	} finally {
		lock.unlock();
	}
}
public static final native int _GTK_WIDGET_FLAGS(long /*int*/ wid);
public static final int GTK_WIDGET_FLAGS(long /*int*/ wid) {
	lock.lock();
	try {
		return _GTK_WIDGET_FLAGS(wid);
	} finally {
		lock.unlock();
	}
}
public static final native int _GTK_WIDGET_STATE(long /*int*/ wid);
public static final int GTK_WIDGET_STATE(long /*int*/ wid) {
	lock.lock();
	try {
		return _GTK_WIDGET_STATE(wid);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _GTK_WIDGET_HAS_DEFAULT(long /*int*/ wid);
public static final boolean GTK_WIDGET_HAS_DEFAULT(long /*int*/ wid) {
	lock.lock();
	try {
		return _GTK_WIDGET_HAS_DEFAULT(wid);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _GTK_WIDGET_HAS_FOCUS(long /*int*/ wid);
public static final boolean GTK_WIDGET_HAS_FOCUS(long /*int*/ wid) {
	lock.lock();
	try {
		return _GTK_WIDGET_HAS_FOCUS(wid);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _GTK_WIDGET_IS_SENSITIVE(long /*int*/ wid);
public static final boolean GTK_WIDGET_IS_SENSITIVE(long /*int*/ wid) {
	lock.lock();
	try {
		return _GTK_WIDGET_IS_SENSITIVE(wid);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _GTK_WIDGET_MAPPED(long /*int*/ wid);
public static final boolean GTK_WIDGET_MAPPED(long /*int*/ wid) {
	lock.lock();
	try {
		return _GTK_WIDGET_MAPPED(wid);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _GTK_WIDGET_SENSITIVE(long /*int*/ wid);
public static final boolean GTK_WIDGET_SENSITIVE(long /*int*/ wid) {
	lock.lock();
	try {
		return _GTK_WIDGET_SENSITIVE(wid);
	} finally {
		lock.unlock();
	}
}
public static final native void _GTK_WIDGET_SET_FLAGS(long /*int*/ wid, int flag);
public static final void GTK_WIDGET_SET_FLAGS(long /*int*/ wid, int flag) {
	lock.lock();
	try {
		_GTK_WIDGET_SET_FLAGS(wid, flag);
	} finally {
		lock.unlock();
	}
}
public static final native void _GTK_WIDGET_UNSET_FLAGS(long /*int*/ wid, int flag);
public static final void GTK_WIDGET_UNSET_FLAGS(long /*int*/ wid, int flag) {
	lock.lock();
	try {
		_GTK_WIDGET_UNSET_FLAGS(wid, flag);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _GTK_WIDGET_VISIBLE(long /*int*/ wid);
public static final boolean GTK_WIDGET_VISIBLE(long /*int*/ wid) {
	lock.lock();
	try {
		return _GTK_WIDGET_VISIBLE(wid);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _G_OBJECT_CLASS (long /*int*/ klass);
public static final long /*int*/ G_OBJECT_CLASS (long /*int*/ klass) {
	lock.lock();
	try {
		return _G_OBJECT_CLASS(klass);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _G_OBJECT_GET_CLASS (long /*int*/ object);
public static final long /*int*/ G_OBJECT_GET_CLASS (long /*int*/ object) {
	lock.lock();
	try {
		return _G_OBJECT_GET_CLASS(object);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _G_TYPE_BOOLEAN();
public static final long /*int*/ G_TYPE_BOOLEAN() {
	lock.lock();
	try {
		return _G_TYPE_BOOLEAN();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _G_TYPE_INT();
public static final long /*int*/ G_TYPE_INT() {
	lock.lock();
	try {
		return _G_TYPE_INT();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _G_OBJECT_TYPE (long /*int*/ instance);
public static final long /*int*/ G_OBJECT_TYPE (long /*int*/ instance) {
	lock.lock();
	try {
		return _G_OBJECT_TYPE(instance);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _G_TYPE_STRING();
public static final long /*int*/ G_TYPE_STRING() {
	lock.lock();
	try {
		return _G_TYPE_STRING();
	} finally {
		lock.unlock();
	}
}
public static final native int _PANGO_PIXELS(int dimension);
public static final int PANGO_PIXELS(int dimension) {
	lock.lock();
	try {
		return _PANGO_PIXELS(dimension);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _PANGO_TYPE_FONT_DESCRIPTION();
public static final long /*int*/ PANGO_TYPE_FONT_DESCRIPTION() {
	lock.lock();
	try {
		return _PANGO_TYPE_FONT_DESCRIPTION();
	} finally {
		lock.unlock();
	}
}
public static final native boolean _g_main_context_acquire(long /*int*/ context);
public static final boolean g_main_context_acquire(long /*int*/ context) {
	lock.lock();
	try {
		return _g_main_context_acquire(context);
	} finally {
		lock.unlock();
	}
}
public static final native int _g_main_context_check(long /*int*/ context, int max_priority, long /*int*/ fds, int n_fds);
public static final int g_main_context_check(long /*int*/ context, int max_priority, long /*int*/ fds, int n_fds) {
	lock.lock();
	try {
		return _g_main_context_check(context, max_priority, fds, n_fds);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_main_context_default();
public static final long /*int*/ g_main_context_default() {
	lock.lock();
	try {
		return _g_main_context_default();
	} finally {
		lock.unlock();
	}
}
public static final native boolean _g_main_context_iteration(long /*int*/ context, boolean may_block);
public static final boolean g_main_context_iteration(long /*int*/ context, boolean may_block) {
	lock.lock();
	try {
		return _g_main_context_iteration(context, may_block);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _g_main_context_pending(long /*int*/ context);
public static final boolean g_main_context_pending(long /*int*/ context) {
	lock.lock();
	try {
		return _g_main_context_pending(context);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_main_context_get_poll_func(long /*int*/ context);
public static final long /*int*/ g_main_context_get_poll_func(long /*int*/ context) {
	lock.lock();
	try {
		return _g_main_context_get_poll_func(context);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _g_main_context_prepare(long /*int*/ context, int[] priority);
public static final boolean g_main_context_prepare(long /*int*/ context, int[] priority) {
	lock.lock();
	try {
		return _g_main_context_prepare(context, priority);
	} finally {
		lock.unlock();
	}
}
public static final native int _g_main_context_query(long /*int*/ context, int max_priority, int[] timeout_, long /*int*/ fds, int n_fds);
public static final int g_main_context_query(long /*int*/ context, int max_priority, int[] timeout_, long /*int*/ fds, int n_fds) {
	lock.lock();
	try {
		return _g_main_context_query(context, max_priority, timeout_, fds, n_fds);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_main_context_release(long /*int*/ context);
public static final void g_main_context_release(long /*int*/ context) {
	lock.lock();
	try {
		_g_main_context_release(context);
	} finally {
		lock.unlock();
	}
}
public static final native void g_main_context_wakeup(long /*int*/ context);
public static final native long /*int*/ _g_filename_to_utf8(long /*int*/ opsysstring, long /*int*/ len, long /*int*/[] bytes_read, long /*int*/[] bytes_written, long /*int*/[] error);
public static final long /*int*/ g_filename_to_utf8(long /*int*/ opsysstring, long /*int*/ len, long /*int*/[] bytes_read, long /*int*/[] bytes_written, long /*int*/[] error) {
	lock.lock();
	try {
		return _g_filename_to_utf8(opsysstring, len, bytes_read, bytes_written, error);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_filename_to_uri(long /*int*/ filename, long /*int*/ hostname, long /*int*/[] error);
public static final long /*int*/ g_filename_to_uri(long /*int*/ filename, long /*int*/ hostname, long /*int*/[] error) {
	lock.lock();
	try {
		return _g_filename_to_uri(filename, hostname, error);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_filename_from_utf8(long /*int*/ opsysstring, long /*int*/ len,  long /*int*/[] bytes_read, long /*int*/[] bytes_written, long /*int*/[] error);
public static final long /*int*/ g_filename_from_utf8(long /*int*/ opsysstring, long /*int*/ len,  long /*int*/[] bytes_read, long /*int*/[] bytes_written, long /*int*/[] error) {
	lock.lock();
	try {
		return _g_filename_from_utf8(opsysstring, len, bytes_read, bytes_written, error);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_filename_from_uri(long /*int*/ uri, long /*int*/[] hostname, long /*int*/[] error);
public static final long /*int*/ g_filename_from_uri(long /*int*/ uri, long /*int*/[] hostname, long /*int*/[] error) {
	lock.lock();
	try {
		return _g_filename_from_uri(uri, hostname, error);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_free(long /*int*/ mem);
public static final void g_free(long /*int*/ mem) {
	lock.lock();
	try {
		_g_free(mem);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_list_append(long /*int*/ list, long /*int*/ data);
public static final long /*int*/ g_list_append(long /*int*/ list, long /*int*/ data) {
	lock.lock();
	try {
		return _g_list_append(list, data);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_list_data(long /*int*/ list);
public static final long /*int*/ g_list_data(long /*int*/ list) {
	lock.lock();
	try {
		return _g_list_data(list);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_list_free(long /*int*/ list);
public static final void g_list_free(long /*int*/ list) {
	lock.lock();
	try {
		_g_list_free(list);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_list_free_1(long /*int*/ list);
public static final void g_list_free_1(long /*int*/ list) {
	lock.lock();
	try {
		_g_list_free_1(list);
	} finally {
		lock.unlock();
	}
}
public static final native int _g_list_length(long /*int*/ list);
public static final int g_list_length(long /*int*/ list) {
	lock.lock();
	try {
		return _g_list_length(list);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_list_set_next(long /*int*/ list, long /*int*/ llist);
public static final void g_list_set_next(long /*int*/ list, long /*int*/ llist) {
	lock.lock();
	try {
		_g_list_set_next(list, llist);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_list_next(long /*int*/ list);
public static final long /*int*/ g_list_next(long /*int*/ list) {
	lock.lock();
	try {
		return _g_list_next(list);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_list_nth(long /*int*/ list, int n);
public static final long /*int*/ g_list_nth(long /*int*/ list, int n) {
	lock.lock();
	try {
		return _g_list_nth(list, n);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_list_nth_data(long /*int*/ list, int n);
public static final long /*int*/ g_list_nth_data(long /*int*/ list, int n) {
	lock.lock();
	try {
		return _g_list_nth_data(list, n);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_list_prepend(long /*int*/ list, long /*int*/ data);
public static final long /*int*/ g_list_prepend(long /*int*/ list, long /*int*/ data) {
	lock.lock();
	try {
		return _g_list_prepend(list, data);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_list_set_previous(long /*int*/ list, long /*int*/ llist);
public static final void g_list_set_previous(long /*int*/ list, long /*int*/ llist) {
	lock.lock();
	try {
		_g_list_set_previous(list, llist);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_list_previous(long /*int*/ list);
public static final long /*int*/ g_list_previous(long /*int*/ list) {
	lock.lock();
	try {
		return _g_list_previous(list);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_list_remove_link(long /*int*/ list, long /*int*/ link);
public static final long /*int*/ g_list_remove_link(long /*int*/ list, long /*int*/ link) {
	lock.lock();
	try {
		return _g_list_remove_link(list, link);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_list_reverse(long /*int*/ list);
public static final long /*int*/ g_list_reverse(long /*int*/ list) {
	lock.lock();
	try {
		return _g_list_reverse(list);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_locale_from_utf8(long /*int*/ utf8string, long /*int*/ len, long /*int*/[] bytes_read, long /*int*/[] bytes_written, long /*int*/[] error);
public static final long /*int*/ g_locale_from_utf8(long /*int*/ utf8string, long /*int*/ len, long /*int*/[] bytes_read, long /*int*/[] bytes_written, long /*int*/[] error) {
	lock.lock();
	try {
		return _g_locale_from_utf8(utf8string, len, bytes_read, bytes_written, error);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_locale_to_utf8(long /*int*/ opsysstring, long /*int*/ len, long /*int*/[] bytes_read, long /*int*/[] bytes_written, long /*int*/[] error);
public static final long /*int*/ g_locale_to_utf8(long /*int*/ opsysstring, long /*int*/ len, long /*int*/[] bytes_read, long /*int*/[] bytes_written, long /*int*/[] error) {
	lock.lock();
	try {
		return _g_locale_to_utf8(opsysstring, len, bytes_read, bytes_written, error);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_log_default_handler(long /*int*/ log_domain, int log_levels, long /*int*/ message, long /*int*/ unused_data);
public static final void g_log_default_handler(long /*int*/ log_domain, int log_levels, long /*int*/ message, long /*int*/ unused_data) {
	lock.lock();
	try {
		_g_log_default_handler(log_domain, log_levels, message, unused_data);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_log_remove_handler(byte[] log_domain, int handler_id);
public static final void g_log_remove_handler(byte[] log_domain, int handler_id) {
	lock.lock();
	try {
		_g_log_remove_handler(log_domain, handler_id);
	} finally {
		lock.unlock();
	}
}
public static final native int _g_log_set_handler(byte[] log_domain, int log_levels, long /*int*/ log_func, long /*int*/ user_data);
public static final int g_log_set_handler(byte[] log_domain, int log_levels, long /*int*/ log_func, long /*int*/ user_data) {
	lock.lock();
	try {
		return _g_log_set_handler(log_domain, log_levels, log_func, user_data);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_malloc(long /*int*/ size);
public static final long /*int*/ g_malloc(long /*int*/ size) {
	lock.lock();
	try {
		return _g_malloc(size);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_object_get(long /*int*/ object, byte[] first_property_name, int[] value, long /*int*/ terminator);
public static final void g_object_get(long /*int*/ object, byte[] first_property_name, int[] value, long /*int*/ terminator) {
	lock.lock();
	try {
		_g_object_get(object, first_property_name, value, terminator);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_object_get_qdata(long /*int*/ object, int quark);
public static final long /*int*/ g_object_get_qdata(long /*int*/ object, int quark) {
	lock.lock();
	try {
		return _g_object_get_qdata(object, quark);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_object_new (long /*int*/ type, long /*int*/ first_property_name);
public static final long /*int*/ g_object_new (long /*int*/ type, long /*int*/ first_property_name) {
	lock.lock();
	try {
		return _g_object_new(type, first_property_name);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_object_ref(long /*int*/ object);
public static final long /*int*/ g_object_ref(long /*int*/ object) {
	lock.lock();
	try {
		return _g_object_ref(object);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_object_set(long /*int*/ object, byte[] first_property_name, boolean data, long /*int*/ terminator);
public static final void g_object_set(long /*int*/ object, byte[] first_property_name, boolean data, long /*int*/ terminator) {
	lock.lock();
	try {
		_g_object_set(object, first_property_name, data, terminator);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_object_set(long /*int*/ object, byte[] first_property_name, int data, long /*int*/ terminator);
public static final void g_object_set(long /*int*/ object, byte[] first_property_name, int data, long /*int*/ terminator) {
	lock.lock();
	try {
		_g_object_set(object, first_property_name, data, terminator);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_object_set(long /*int*/ object, byte[] first_property_name, float data, long /*int*/ terminator);
public static final void g_object_set(long /*int*/ object, byte[] first_property_name, float data, long /*int*/ terminator) {
	lock.lock();
	try {
		_g_object_set(object, first_property_name, data, terminator);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_object_set(long /*int*/ object, byte[] first_property_name, long data, long /*int*/ terminator);
public static final void g_object_set(long /*int*/ object, byte[] first_property_name, long data, long /*int*/ terminator) {
	lock.lock();
	try {
		_g_object_set(object, first_property_name, data, terminator);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_object_set_qdata(long /*int*/ object, int quark, long /*int*/ data);
public static final void g_object_set_qdata(long /*int*/ object, int quark, long /*int*/ data) {
	lock.lock();
	try {
		_g_object_set_qdata(object, quark, data);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_object_unref(long /*int*/ object);
public static final void g_object_unref(long /*int*/ object) {
	lock.lock();
	try {
		_g_object_unref(object);
	} finally {
		lock.unlock();
	}
}
public static final native int _g_quark_from_string(byte[] string);
public static final int g_quark_from_string(byte[] string) {
	lock.lock();
	try {
		return _g_quark_from_string(string);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_set_prgname(byte[] prgname);
public static final void g_set_prgname(byte[] prgname) {
	lock.lock();
	try {
		_g_set_prgname(prgname);
	} finally {
		lock.unlock();
	}
}
public static final native int _g_signal_connect(long /*int*/ instance, byte[] detailed_signal, long /*int*/ proc, long /*int*/ data);
public static final int g_signal_connect(long /*int*/ instance, byte[] detailed_signal, long /*int*/ proc, long /*int*/ data) {
	lock.lock();
	try {
		return _g_signal_connect(instance, detailed_signal, proc, data);
	} finally {
		lock.unlock();
	}
}
public static final native int _g_signal_connect_after(long /*int*/ instance, byte[] detailed_signal, long /*int*/ proc, long /*int*/ data);
public static final int g_signal_connect_after(long /*int*/ instance, byte[] detailed_signal, long /*int*/ proc, long /*int*/ data) {
	lock.lock();
	try {
		return _g_signal_connect_after(instance, detailed_signal, proc, data);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_signal_emit_by_name(long /*int*/ instance, byte[] detailed_signal);
public static final void g_signal_emit_by_name(long /*int*/ instance, byte[] detailed_signal) {
	lock.lock();
	try {
		_g_signal_emit_by_name(instance, detailed_signal);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_signal_emit_by_name(long /*int*/ instance, byte[] detailed_signal, long /*int*/ data);
public static final void g_signal_emit_by_name(long /*int*/ instance, byte[] detailed_signal, long /*int*/ data) {
	lock.lock();
	try {
		_g_signal_emit_by_name(instance, detailed_signal, data);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_signal_emit_by_name(long /*int*/ instance, byte[] detailed_signal, long /*int*/ data1, long /*int*/ data2);
public static final void g_signal_emit_by_name(long /*int*/ instance, byte[] detailed_signal, long /*int*/ data1, long /*int*/ data2) {
	lock.lock();
	try {
		_g_signal_emit_by_name(instance, detailed_signal, data1, data2);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_signal_emit_by_name(long /*int*/ instance, byte[] detailed_signal, byte [] data);
public static final void g_signal_emit_by_name(long /*int*/ instance, byte[] detailed_signal, byte [] data) {
	lock.lock();
	try {
		_g_signal_emit_by_name(instance, detailed_signal, data);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_signal_handler_disconnect(long /*int*/ instance, int handler_id);
public static final void g_signal_handler_disconnect(long /*int*/ instance, int handler_id) {
	lock.lock();
	try {
		_g_signal_handler_disconnect(instance, handler_id);
	} finally {
		lock.unlock();
	}
}
public static final native int _g_signal_handlers_block_matched(long /*int*/ instance, int mask, int signal_id, int detail, long /*int*/ closure, long /*int*/ func, long /*int*/ data);
public static final int g_signal_handlers_block_matched(long /*int*/ instance, int mask, int signal_id, int detail, long /*int*/ closure, long /*int*/ func, long /*int*/ data) {
	lock.lock();
	try {
		return _g_signal_handlers_block_matched(instance, mask, signal_id, detail, closure, func, data);
	} finally {
		lock.unlock();
	}
}
public static final native int _g_signal_handlers_disconnect_matched(long /*int*/ instance, int mask, int signal_id, int detail, long /*int*/ closure, long /*int*/ func, long /*int*/ data);
public static final int g_signal_handlers_disconnect_matched(long /*int*/ instance, int mask, int signal_id, int detail, long /*int*/ closure, long /*int*/ func, long /*int*/ data) {
	lock.lock();
	try {
		return _g_signal_handlers_disconnect_matched(instance, mask, signal_id, detail, closure, func, data);
	} finally {
		lock.unlock();
	}
}
public static final native int _g_signal_handlers_unblock_matched(long /*int*/ instance, int mask, int signal_id, int detail, long /*int*/ closure, long /*int*/ func, long /*int*/ data);
public static final int g_signal_handlers_unblock_matched(long /*int*/ instance, int mask, int signal_id, int detail, long /*int*/ closure, long /*int*/ func, long /*int*/ data) {
	lock.lock();
	try {
		return _g_signal_handlers_unblock_matched(instance, mask, signal_id, detail, closure, func, data);
	} finally {
		lock.unlock();
	}
}
public static final native int _g_signal_lookup (byte[] name, long /*int*/ itype);
public static final int g_signal_lookup (byte[] name, long /*int*/ itype) {
	lock.lock();
	try {
		return _g_signal_lookup(name, itype);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_signal_stop_emission_by_name(long /*int*/ instance, byte[] detailed_signal);
public static final void g_signal_stop_emission_by_name(long /*int*/ instance, byte[] detailed_signal) {
	lock.lock();
	try {
		_g_signal_stop_emission_by_name(instance, detailed_signal);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_slist_data (long /*int*/ list);
public static final long /*int*/ g_slist_data (long /*int*/ list) {
	lock.lock();
	try {
		return _g_slist_data(list);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_slist_free (long /*int*/ list);
public static final void g_slist_free (long /*int*/ list) {
	lock.lock();
	try {
		_g_slist_free(list);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_slist_next (long /*int*/ list);
public static final long /*int*/ g_slist_next (long /*int*/ list) {
	lock.lock();
	try {
		return _g_slist_next(list);
	} finally {
		lock.unlock();
	}
}
public static final native int _g_slist_length (long /*int*/ list);
public static final int g_slist_length (long /*int*/ list) {
	lock.lock();
	try {
		return _g_slist_length(list);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_strfreev(long /*int*/ string_array);
public static final void g_strfreev(long /*int*/ string_array) {
	lock.lock();
	try {
		_g_strfreev(string_array);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_type_add_interface_static (long /*int*/ instance_type, long /*int*/ interface_type, long /*int*/ info);
public static final void g_type_add_interface_static (long /*int*/ instance_type, long /*int*/ interface_type, long /*int*/ info) {
	lock.lock();
	try {
		_g_type_add_interface_static(instance_type, interface_type, info);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_type_class_peek (long /*int*/ g_class);
public static final long /*int*/ g_type_class_peek (long /*int*/ g_class) {
	lock.lock();
	try {
		return _g_type_class_peek(g_class);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_type_class_peek_parent (long /*int*/ g_class);
public static final long /*int*/ g_type_class_peek_parent (long /*int*/ g_class) {
	lock.lock();
	try {
		return _g_type_class_peek_parent(g_class);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_type_from_name (byte[] name);
public static final long /*int*/ g_type_from_name (byte[] name) {
	lock.lock();
	try {
		return _g_type_from_name(name);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_type_interface_peek_parent (long /*int*/ iface);
public static final long /*int*/ g_type_interface_peek_parent (long /*int*/ iface) {
	lock.lock();
	try {
		return _g_type_interface_peek_parent(iface);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _g_type_is_a (long /*int*/ type, long /*int*/ is_a_type);
public static final boolean g_type_is_a (long /*int*/ type, long /*int*/ is_a_type) {
	lock.lock();
	try {
		return _g_type_is_a(type, is_a_type);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_type_name (long /*int*/ handle);
public static final long /*int*/ g_type_name (long /*int*/ handle) {
	lock.lock();
	try {
		return _g_type_name(handle);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_type_parent (long /*int*/ type);
public static final long /*int*/ g_type_parent (long /*int*/ type) {
	lock.lock();
	try {
		return _g_type_parent(type);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_type_query (long /*int*/ type, long /*int*/ query);
public static final void g_type_query (long /*int*/ type, long /*int*/ query) {
	lock.lock();
	try {
		_g_type_query(type, query);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_type_register_static (long /*int*/ parent_type, byte[] type_name, long /*int*/ info, int flags);
public static final long /*int*/ g_type_register_static (long /*int*/ parent_type, byte[] type_name, long /*int*/ info, int flags) {
	lock.lock();
	try {
		return _g_type_register_static(parent_type, type_name, info, flags);
	} finally {
		lock.unlock();
	}
}
public static final native void _g_thread_init(long /*int*/ vtable);
public static final void g_thread_init(long /*int*/ vtable) {
	lock.lock();
	try {
		_g_thread_init(vtable);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _g_thread_supported();
public static final boolean g_thread_supported() {
	lock.lock();
	try {
		return _g_thread_supported();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_utf16_to_utf8(char[] str, long /*int*/ len, long /*int*/[] items_read, long /*int*/[] items_written, long /*int*/[] error);
public static final long /*int*/ g_utf16_to_utf8(char[] str, long /*int*/ len, long /*int*/[] items_read, long /*int*/[] items_written, long /*int*/[] error) {
	lock.lock();
	try {
		return _g_utf16_to_utf8(str, len, items_read, items_written, error);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_utf8_offset_to_pointer(long /*int*/ str, long /*int*/ offset);
public static final long /*int*/ g_utf8_offset_to_pointer(long /*int*/ str, long /*int*/ offset) {
	lock.lock();
	try {
		return _g_utf8_offset_to_pointer(str, offset);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_utf8_pointer_to_offset(long /*int*/ str, long /*int*/ pos);
public static final long /*int*/ g_utf8_pointer_to_offset(long /*int*/ str, long /*int*/ pos) {
	lock.lock();
	try {
		return _g_utf8_pointer_to_offset(str, pos);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_utf8_strlen(long /*int*/ str, long /*int*/ max);
public static final long /*int*/ g_utf8_strlen(long /*int*/ str, long /*int*/ max) {
	lock.lock();
	try {
		return _g_utf8_strlen(str, max);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_utf8_to_utf16(byte[] str, long /*int*/ len, long /*int*/[] items_read, long /*int*/[] items_written, long /*int*/[] error);
public static final long /*int*/ g_utf8_to_utf16(byte[] str, long /*int*/ len, long /*int*/[] items_read, long /*int*/[] items_written, long /*int*/[] error) {
	lock.lock();
	try {
		return _g_utf8_to_utf16(str, len, items_read, items_written, error);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _g_utf8_to_utf16(long /*int*/ str, long /*int*/ len, long /*int*/[] items_read, long /*int*/[] items_written, long /*int*/[] error);
public static final long /*int*/ g_utf8_to_utf16(long /*int*/ str, long /*int*/ len, long /*int*/[] items_read, long /*int*/[] items_written, long /*int*/[] error) {
	lock.lock();
	try {
		return _g_utf8_to_utf16(str, len, items_read, items_written, error);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_atom_intern(byte[] atom_name, boolean only_if_exists);
public static final long /*int*/ gdk_atom_intern(byte[] atom_name, boolean only_if_exists) {
	lock.lock();
	try {
		return _gdk_atom_intern(atom_name, only_if_exists);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_atom_name(long /*int*/ atom);
public static final long /*int*/ gdk_atom_name(long /*int*/ atom) {
	lock.lock();
	try {
		return _gdk_atom_name(atom);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_beep();
public static final void gdk_beep() {
	lock.lock();
	try {
		_gdk_beep();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_bitmap_create_from_data(long /*int*/ window, byte[] data, int width, int height);
public static final long /*int*/ gdk_bitmap_create_from_data(long /*int*/ window, byte[] data, int width, int height) {
	lock.lock();
	try {
		return _gdk_bitmap_create_from_data(window, data, width, height);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gdk_color_white(long /*int*/ colormap, GdkColor color);
public static final boolean gdk_color_white(long /*int*/ colormap, GdkColor color) {
	lock.lock();
	try {
		return _gdk_color_white(colormap, color);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gdk_colormap_alloc_color(long /*int*/ colormap, GdkColor color, boolean writeable, boolean best_match);
public static final boolean gdk_colormap_alloc_color(long /*int*/ colormap, GdkColor color, boolean writeable, boolean best_match) {
	lock.lock();
	try {
		return _gdk_colormap_alloc_color(colormap, color, writeable, best_match);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_colormap_free_colors(long /*int*/ colormap, GdkColor colors, int ncolors);
public static final void gdk_colormap_free_colors(long /*int*/ colormap, GdkColor colors, int ncolors) {
	lock.lock();
	try {
		_gdk_colormap_free_colors(colormap, colors, ncolors);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_colormap_get_system();
public static final long /*int*/ gdk_colormap_get_system() {
	lock.lock();
	try {
		return _gdk_colormap_get_system();
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_colormap_query_color(long /*int*/ colormap, long /*int*/ pixel, GdkColor result);
public static final void gdk_colormap_query_color(long /*int*/ colormap, long /*int*/ pixel, GdkColor result) {
	lock.lock();
	try {
		_gdk_colormap_query_color(colormap, pixel, result);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_cursor_destroy(long /*int*/ cursor);
public static final void gdk_cursor_destroy(long /*int*/ cursor) {
	lock.lock();
	try {
		_gdk_cursor_destroy(cursor);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_cursor_new(long /*int*/ cursor_type);
public static final long /*int*/ gdk_cursor_new(long /*int*/ cursor_type) {
	lock.lock();
	try {
		return _gdk_cursor_new(cursor_type);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_cursor_new_from_pixmap(long /*int*/ source, long /*int*/ mask, GdkColor fg, GdkColor bg, int x, int y);
public static final long /*int*/ gdk_cursor_new_from_pixmap(long /*int*/ source, long /*int*/ mask, GdkColor fg, GdkColor bg, int x, int y) {
	lock.lock();
	try {
		return _gdk_cursor_new_from_pixmap(source, mask, fg, bg, x, y);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_drag_status(long /*int*/ context, int action, int time);
public static final void gdk_drag_status(long /*int*/ context, int action, int time) {
	lock.lock();
	try {
		_gdk_drag_status(context, action, time);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_draw_arc(long /*int*/ drawable, long /*int*/ gc, int filled, int x, int y, int width, int height, int angle1, int angle2);
public static final void gdk_draw_arc(long /*int*/ drawable, long /*int*/ gc, int filled, int x, int y, int width, int height, int angle1, int angle2) {
	lock.lock();
	try {
		_gdk_draw_arc(drawable, gc, filled, x, y, width, height, angle1, angle2);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_draw_drawable(long /*int*/ drawable, long /*int*/ gc, long /*int*/ src, int xsrc, int ysrc, int xdest, int ydest, int width, int height);
public static final void gdk_draw_drawable(long /*int*/ drawable, long /*int*/ gc, long /*int*/ src, int xsrc, int ysrc, int xdest, int ydest, int width, int height) {
	lock.lock();
	try {
		_gdk_draw_drawable(drawable, gc, src, xsrc, ysrc, xdest, ydest, width, height);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_draw_layout(long /*int*/ drawable, long /*int*/ gc, int x, int y, long /*int*/ layout);
public static final void gdk_draw_layout(long /*int*/ drawable, long /*int*/ gc, int x, int y, long /*int*/ layout) {
	lock.lock();
	try {
		_gdk_draw_layout(drawable, gc, x, y, layout);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_draw_layout_with_colors(long /*int*/ drawable, long /*int*/ gc, int x, int y, long /*int*/ layout, GdkColor foreground, GdkColor background);
public static final void gdk_draw_layout_with_colors(long /*int*/ drawable, long /*int*/ gc, int x, int y, long /*int*/ layout, GdkColor foreground, GdkColor background) {
	lock.lock();
	try {
		_gdk_draw_layout_with_colors(drawable, gc, x, y, layout, foreground, background);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_draw_line(long /*int*/ drawable, long /*int*/ gc, int x1, int y1, int x2, int y2);
public static final void gdk_draw_line(long /*int*/ drawable, long /*int*/ gc, int x1, int y1, int x2, int y2) {
	lock.lock();
	try {
		_gdk_draw_line(drawable, gc, x1, y1, x2, y2);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_draw_lines(long /*int*/ drawable, long /*int*/ gc, int[] points, int npoints);
public static final void gdk_draw_lines(long /*int*/ drawable, long /*int*/ gc, int[] points, int npoints) {
	lock.lock();
	try {
		_gdk_draw_lines(drawable, gc, points, npoints);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_draw_pixbuf(long /*int*/ drawable, long /*int*/ gc, long /*int*/ pixbuf, int xsrc, int ysrc, int xdest, int ydest, int width, int height, int dither, int x_dither, int y_dither);
public static final void gdk_draw_pixbuf(long /*int*/ drawable, long /*int*/ gc, long /*int*/ pixbuf, int xsrc, int ysrc, int xdest, int ydest, int width, int height, int dither, int x_dither, int y_dither) {
	lock.lock();
	try {
		_gdk_draw_pixbuf(drawable, gc, pixbuf, xsrc, ysrc, xdest, ydest, width, height, dither, x_dither, y_dither);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_draw_point(long /*int*/ drawable, long /*int*/ gc, int x, int y);
public static final void gdk_draw_point(long /*int*/ drawable, long /*int*/ gc, int x, int y) {
	lock.lock();
	try {
		_gdk_draw_point(drawable, gc, x, y);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_draw_polygon(long /*int*/ drawable, long /*int*/ gc, int filled, int[] points, int npoints);
public static final void gdk_draw_polygon(long /*int*/ drawable, long /*int*/ gc, int filled, int[] points, int npoints) {
	lock.lock();
	try {
		_gdk_draw_polygon(drawable, gc, filled, points, npoints);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_draw_rectangle(long /*int*/ drawable, long /*int*/ gc, int filled, int x, int y, int width, int height);
public static final void gdk_draw_rectangle(long /*int*/ drawable, long /*int*/ gc, int filled, int x, int y, int width, int height) {
	lock.lock();
	try {
		_gdk_draw_rectangle(drawable, gc, filled, x, y, width, height);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_drawable_get_image(long /*int*/ drawable, int x, int y, int width, int height);
public static final long /*int*/ gdk_drawable_get_image(long /*int*/ drawable, int x, int y, int width, int height) {
	lock.lock();
	try {
		return _gdk_drawable_get_image(drawable, x, y, width, height);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_drawable_get_size(long /*int*/ drawable, int[] width, int[] height);
public static final void gdk_drawable_get_size(long /*int*/ drawable, int[] width, int[] height) {
	lock.lock();
	try {
		_gdk_drawable_get_size(drawable, width, height);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_drawable_get_visible_region(long /*int*/ drawable);
public static final long /*int*/ gdk_drawable_get_visible_region(long /*int*/ drawable) {
	lock.lock();
	try {
		return _gdk_drawable_get_visible_region(drawable);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_event_copy(long /*int*/ event);
public static final long /*int*/ gdk_event_copy(long /*int*/ event) {
	lock.lock();
	try {
		return _gdk_event_copy(event);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_event_free(long /*int*/ event);
public static final void gdk_event_free(long /*int*/ event) {
	lock.lock();
	try {
		_gdk_event_free(event);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_event_get();
public static final long /*int*/ gdk_event_get() {
	lock.lock();
	try {
		return _gdk_event_get();
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gdk_event_get_root_coords(long /*int*/ event, double[] px, double[] py);
public static final boolean gdk_event_get_root_coords(long /*int*/ event, double[] px, double[] py) {
	lock.lock();
	try {
		return _gdk_event_get_root_coords(event, px, py);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gdk_event_get_coords(long /*int*/ event, double[] px, double[] py);
public static final boolean gdk_event_get_coords(long /*int*/ event, double[] px, double[] py) {
	lock.lock();
	try {
		return _gdk_event_get_coords(event, px, py);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_event_get_graphics_expose(long /*int*/ window);
public static final long /*int*/ gdk_event_get_graphics_expose(long /*int*/ window) {
	lock.lock();
	try {
		return _gdk_event_get_graphics_expose(window);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gdk_event_get_state(long /*int*/ event, int[] pmod);
public static final boolean gdk_event_get_state(long /*int*/ event, int[] pmod) {
	lock.lock();
	try {
		return _gdk_event_get_state(event, pmod);
	} finally {
		lock.unlock();
	}
}
public static final native int _gdk_event_get_time(long /*int*/ event);
public static final int gdk_event_get_time(long /*int*/ event) {
	lock.lock();
	try {
		return _gdk_event_get_time(event);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_event_handler_set(long /*int*/ func, long /*int*/ data, long /*int*/ notify);
public static final void gdk_event_handler_set(long /*int*/ func, long /*int*/ data, long /*int*/ notify) {
	lock.lock();
	try {
		_gdk_event_handler_set(func, data, notify);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_event_put(long /*int*/ event);
public static final void gdk_event_put(long /*int*/ event) {
	lock.lock();
	try {
		_gdk_event_put(event);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_error_trap_push();
public static final void gdk_error_trap_push() {
	lock.lock();
	try {
		_gdk_error_trap_push();
	} finally {
		lock.unlock();
	}
}
public static final native int _gdk_error_trap_pop();
public static final int gdk_error_trap_pop() {
	lock.lock();
	try {
		return _gdk_error_trap_pop();
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_flush();
public static final void gdk_flush() {
	lock.lock();
	try {
		_gdk_flush();
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_free_text_list(long /*int*/ list);
public static final void gdk_free_text_list(long /*int*/ list) {
	lock.lock();
	try {
		_gdk_free_text_list(list);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_gc_get_values(long /*int*/ gc, GdkGCValues values);
public static final void gdk_gc_get_values(long /*int*/ gc, GdkGCValues values) {
	lock.lock();
	try {
		_gdk_gc_get_values(gc, values);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_gc_new(long /*int*/ window);
public static final long /*int*/ gdk_gc_new(long /*int*/ window) {
	lock.lock();
	try {
		return _gdk_gc_new(window);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_gc_set_background(long /*int*/ gc, GdkColor color);
public static final void gdk_gc_set_background(long /*int*/ gc, GdkColor color) {
	lock.lock();
	try {
		_gdk_gc_set_background(gc, color);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_gc_set_clip_mask(long /*int*/ gc, long /*int*/ mask);
public static final void gdk_gc_set_clip_mask(long /*int*/ gc, long /*int*/ mask) {
	lock.lock();
	try {
		_gdk_gc_set_clip_mask(gc, mask);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_gc_set_clip_origin(long /*int*/ gc, int x, int y);
public static final void gdk_gc_set_clip_origin(long /*int*/ gc, int x, int y) {
	lock.lock();
	try {
		_gdk_gc_set_clip_origin(gc, x, y);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_gc_set_clip_rectangle(long /*int*/ gc, GdkRectangle rectangle);
public static final void gdk_gc_set_clip_rectangle(long /*int*/ gc, GdkRectangle rectangle) {
	lock.lock();
	try {
		_gdk_gc_set_clip_rectangle(gc, rectangle);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_gc_set_clip_region(long /*int*/ gc, long /*int*/ region);
public static final void gdk_gc_set_clip_region(long /*int*/ gc, long /*int*/ region) {
	lock.lock();
	try {
		_gdk_gc_set_clip_region(gc, region);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_gc_set_dashes(long /*int*/ gc, int dash_offset, byte[] dash_list, int n);
public static final void gdk_gc_set_dashes(long /*int*/ gc, int dash_offset, byte[] dash_list, int n) {
	lock.lock();
	try {
		_gdk_gc_set_dashes(gc, dash_offset, dash_list, n);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_gc_set_exposures(long /*int*/ gc, boolean exposures);
public static final void gdk_gc_set_exposures(long /*int*/ gc, boolean exposures) {
	lock.lock();
	try {
		_gdk_gc_set_exposures(gc, exposures);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_gc_set_fill(long /*int*/ gc, int fill);
public static final void gdk_gc_set_fill(long /*int*/ gc, int fill) {
	lock.lock();
	try {
		_gdk_gc_set_fill(gc, fill);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_gc_set_foreground(long /*int*/ gc, GdkColor color);
public static final void gdk_gc_set_foreground(long /*int*/ gc, GdkColor color) {
	lock.lock();
	try {
		_gdk_gc_set_foreground(gc, color);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_gc_set_function(long /*int*/ gc, long /*int*/ function);
public static final void gdk_gc_set_function(long /*int*/ gc, long /*int*/ function) {
	lock.lock();
	try {
		_gdk_gc_set_function(gc, function);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_gc_set_line_attributes(long /*int*/ gc, int line_width, int line_style, int cap_style, int join_style);
public static final void gdk_gc_set_line_attributes(long /*int*/ gc, int line_width, int line_style, int cap_style, int join_style) {
	lock.lock();
	try {
		_gdk_gc_set_line_attributes(gc, line_width, line_style, cap_style, join_style);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_gc_set_stipple(long /*int*/ gc, long /*int*/ stipple);
public static final void gdk_gc_set_stipple(long /*int*/ gc, long /*int*/ stipple) {
	lock.lock();
	try {
		_gdk_gc_set_stipple(gc, stipple);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_gc_set_subwindow(long /*int*/ gc, long /*int*/ mode);
public static final void gdk_gc_set_subwindow(long /*int*/ gc, long /*int*/ mode) {
	lock.lock();
	try {
		_gdk_gc_set_subwindow(gc, mode);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_gc_set_values(long /*int*/ gc, GdkGCValues values, int values_mask);
public static final void gdk_gc_set_values(long /*int*/ gc, GdkGCValues values, int values_mask) {
	lock.lock();
	try {
		_gdk_gc_set_values(gc, values, values_mask);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_image_get(long /*int*/ window, int x, int y, int width, int height);
public static final long /*int*/ gdk_image_get(long /*int*/ window, int x, int y, int width, int height) {
	lock.lock();
	try {
		return _gdk_image_get(window, x, y, width, height);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_image_get_pixel(long /*int*/ image, int x, int y);
public static final long /*int*/ gdk_image_get_pixel(long /*int*/ image, int x, int y) {
	lock.lock();
	try {
		return _gdk_image_get_pixel(image, x, y);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_keyboard_ungrab(int time);
public static final void gdk_keyboard_ungrab(int time) {
	lock.lock();
	try {
		_gdk_keyboard_ungrab(time);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_keymap_get_default();
public static final long /*int*/ gdk_keymap_get_default() {
	lock.lock();
	try {
		return _gdk_keymap_get_default();
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gdk_keymap_translate_keyboard_state (long /*int*/ keymap, int hardware_keycode, int state, int group, int[] keyval, int[] effective_group, int[] level,  int[] consumed_modifiers);
public static final boolean gdk_keymap_translate_keyboard_state (long /*int*/ keymap, int hardware_keycode, int state, int group, int[] keyval, int[] effective_group, int[] level,  int[] consumed_modifiers) {
	lock.lock();
	try {
		return _gdk_keymap_translate_keyboard_state(keymap, hardware_keycode, state, group, keyval, effective_group, level, consumed_modifiers);
	} finally {
		lock.unlock();
	}
}
public static final native int _gdk_keyval_to_lower(int keyval);
public static final int gdk_keyval_to_lower(int keyval) {
	lock.lock();
	try {
		return _gdk_keyval_to_lower(keyval);
	} finally {
		lock.unlock();
	}
}
public static final native int _gdk_keyval_to_unicode(int keyval);
public static final int gdk_keyval_to_unicode(int keyval) {
	lock.lock();
	try {
		return _gdk_keyval_to_unicode(keyval);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_pango_context_get();
public static final long /*int*/ gdk_pango_context_get() {
	lock.lock();
	try {
		return _gdk_pango_context_get();
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_pango_context_set_colormap(long /*int*/ context, long /*int*/ colormap);
public static final void gdk_pango_context_set_colormap(long /*int*/ context, long /*int*/ colormap) {
	lock.lock();
	try {
		_gdk_pango_context_set_colormap(context, colormap);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_pango_layout_get_clip_region(long /*int*/ layout, int x_origin, int y_origin, int[] index_ranges, int n_ranges);
public static final long /*int*/ gdk_pango_layout_get_clip_region(long /*int*/ layout, int x_origin, int y_origin, int[] index_ranges, int n_ranges) {
	lock.lock();
	try {
		return _gdk_pango_layout_get_clip_region(layout, x_origin, y_origin, index_ranges, n_ranges);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_pixbuf_copy_area(long /*int*/ src_pixbuf, int src_x, int src_y, int width, int height, long /*int*/ dest_pixbuf, int dest_x, int dest_y);
public static final void gdk_pixbuf_copy_area(long /*int*/ src_pixbuf, int src_x, int src_y, int width, int height, long /*int*/ dest_pixbuf, int dest_x, int dest_y) {
	lock.lock();
	try {
		_gdk_pixbuf_copy_area(src_pixbuf, src_x, src_y, width, height, dest_pixbuf, dest_x, dest_y);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_pixbuf_get_from_drawable(long /*int*/ dest, long /*int*/ src, long /*int*/ cmap, int src_x, int src_y, int dest_x, int dest_y, int width, int height);
public static final long /*int*/ gdk_pixbuf_get_from_drawable(long /*int*/ dest, long /*int*/ src, long /*int*/ cmap, int src_x, int src_y, int dest_x, int dest_y, int width, int height) {
	lock.lock();
	try {
		return _gdk_pixbuf_get_from_drawable(dest, src, cmap, src_x, src_y, dest_x, dest_y, width, height);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gdk_pixbuf_get_has_alpha(long /*int*/ pixbuf);
public static final boolean gdk_pixbuf_get_has_alpha(long /*int*/ pixbuf) {
	lock.lock();
	try {
		return _gdk_pixbuf_get_has_alpha(pixbuf);
	} finally {
		lock.unlock();
	}
}
public static final native int _gdk_pixbuf_get_height(long /*int*/ pixbuf);
public static final int gdk_pixbuf_get_height(long /*int*/ pixbuf) {
	lock.lock();
	try {
		return _gdk_pixbuf_get_height(pixbuf);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_pixbuf_get_pixels(long /*int*/ pixbuf);
public static final long /*int*/ gdk_pixbuf_get_pixels(long /*int*/ pixbuf) {
	lock.lock();
	try {
		return _gdk_pixbuf_get_pixels(pixbuf);
	} finally {
		lock.unlock();
	}
}
public static final native int _gdk_pixbuf_get_rowstride(long /*int*/ pixbuf);
public static final int gdk_pixbuf_get_rowstride(long /*int*/ pixbuf) {
	lock.lock();
	try {
		return _gdk_pixbuf_get_rowstride(pixbuf);
	} finally {
		lock.unlock();
	}
}
public static final native int _gdk_pixbuf_get_width(long /*int*/ pixbuf);
public static final int gdk_pixbuf_get_width(long /*int*/ pixbuf) {
	lock.lock();
	try {
		return _gdk_pixbuf_get_width(pixbuf);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_pixbuf_new(int colorspace, boolean has_alpha, int bits_per_sample, int width, int height);
public static final long /*int*/ gdk_pixbuf_new(int colorspace, boolean has_alpha, int bits_per_sample, int width, int height) {
	lock.lock();
	try {
		return _gdk_pixbuf_new(colorspace, has_alpha, bits_per_sample, width, height);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_pixbuf_render_to_drawable(long /*int*/ pixbuf, long /*int*/ drawable, long /*int*/ gc, int src_x, int src_y, int dest_x, int dest_y, int width, int height, int dither, int x_dither, int y_dither);
public static final void gdk_pixbuf_render_to_drawable(long /*int*/ pixbuf, long /*int*/ drawable, long /*int*/ gc, int src_x, int src_y, int dest_x, int dest_y, int width, int height, int dither, int x_dither, int y_dither) {
	lock.lock();
	try {
		_gdk_pixbuf_render_to_drawable(pixbuf, drawable, gc, src_x, src_y, dest_x, dest_y, width, height, dither, x_dither, y_dither);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_pixbuf_render_to_drawable_alpha(long /*int*/ pixbuf, long /*int*/ drawable, int src_x, int src_y, int dest_x, int dest_y, int width, int height, int alpha_mode, int alpha_threshold, int dither, int x_dither, int y_dither);
public static final void gdk_pixbuf_render_to_drawable_alpha(long /*int*/ pixbuf, long /*int*/ drawable, int src_x, int src_y, int dest_x, int dest_y, int width, int height, int alpha_mode, int alpha_threshold, int dither, int x_dither, int y_dither) {
	lock.lock();
	try {
		_gdk_pixbuf_render_to_drawable_alpha(pixbuf, drawable, src_x, src_y, dest_x, dest_y, width, height, alpha_mode, alpha_threshold, dither, x_dither, y_dither);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_pixbuf_render_pixmap_and_mask(long /*int*/ pixbuf, long /*int*/[] pixmap_return, long /*int*/[] mask_return, int alpha_threshold);
public static final void gdk_pixbuf_render_pixmap_and_mask(long /*int*/ pixbuf, long /*int*/[] pixmap_return, long /*int*/[] mask_return, int alpha_threshold) {
	lock.lock();
	try {
		_gdk_pixbuf_render_pixmap_and_mask(pixbuf, pixmap_return, mask_return, alpha_threshold);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_pixbuf_scale(long /*int*/ src, long /*int*/ dest, int dest_x, int dest_y, int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, double scale_y, int interp_type);
public static final void gdk_pixbuf_scale(long /*int*/ src, long /*int*/ dest, int dest_x, int dest_y, int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, double scale_y, int interp_type) {
	lock.lock();
	try {
		_gdk_pixbuf_scale(src, dest, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_pixbuf_scale_simple(long /*int*/ src, int dest_width, int dest_height, int interp_type);
public static final long /*int*/ gdk_pixbuf_scale_simple(long /*int*/ src, int dest_width, int dest_height, int interp_type) {
	lock.lock();
	try {
		return _gdk_pixbuf_scale_simple(src, dest_width, dest_height, interp_type);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_pixmap_new(long /*int*/ window, int width, int height, int depth);
public static final long /*int*/ gdk_pixmap_new(long /*int*/ window, int width, int height, int depth) {
	lock.lock();
	try {
		return _gdk_pixmap_new(window, width, height, depth);
	} finally {
		lock.unlock();
	}
}
public static final native int _gdk_pointer_grab(long /*int*/ window, boolean owner_events, int event_mask, long /*int*/ confine_to, long /*int*/ cursor, int time);
public static final int gdk_pointer_grab(long /*int*/ window, boolean owner_events, int event_mask, long /*int*/ confine_to, long /*int*/ cursor, int time) {
	lock.lock();
	try {
		return _gdk_pointer_grab(window, owner_events, event_mask, confine_to, cursor, time);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gdk_pointer_is_grabbed();
public static final boolean gdk_pointer_is_grabbed() {
	lock.lock();
	try {
		return _gdk_pointer_is_grabbed();
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_pointer_ungrab(int time);
public static final void gdk_pointer_ungrab(int time) {
	lock.lock();
	try {
		_gdk_pointer_ungrab(time);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gdk_property_get(long /*int*/ window, long /*int*/ property, long /*int*/ type, long /*int*/ offset, long /*int*/ length, int pdelete, long /*int*/[] actual_property_type, int[] actual_format, int[] actual_length, long /*int*/[] data);
public static final boolean gdk_property_get(long /*int*/ window, long /*int*/ property, long /*int*/ type, long /*int*/ offset, long /*int*/ length, int pdelete, long /*int*/[] actual_property_type, int[] actual_format, int[] actual_length, long /*int*/[] data) {
	lock.lock();
	try {
		return _gdk_property_get(window, property, type, offset, length, pdelete, actual_property_type, actual_format, actual_length, data);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_region_destroy(long /*int*/ region);
public static final void gdk_region_destroy(long /*int*/ region) {
	lock.lock();
	try {
		_gdk_region_destroy(region);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gdk_region_empty(long /*int*/ region);
public static final boolean gdk_region_empty(long /*int*/ region) {
	lock.lock();
	try {
		return _gdk_region_empty(region);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_region_get_clipbox(long /*int*/ region, GdkRectangle rectangle);
public static final void gdk_region_get_clipbox(long /*int*/ region, GdkRectangle rectangle) {
	lock.lock();
	try {
		_gdk_region_get_clipbox(region, rectangle);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_region_get_rectangles(long /*int*/ region, long /*int*/[] rectangles, int[] n_rectangles);
public static final void gdk_region_get_rectangles(long /*int*/ region, long /*int*/[] rectangles, int[] n_rectangles) {
	lock.lock();
	try {
		_gdk_region_get_rectangles(region, rectangles, n_rectangles);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_region_intersect(long /*int*/ source1, long /*int*/ source2);
public static final void gdk_region_intersect(long /*int*/ source1, long /*int*/ source2) {
	lock.lock();
	try {
		_gdk_region_intersect(source1, source2);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_region_new();
public static final long /*int*/ gdk_region_new() {
	lock.lock();
	try {
		return _gdk_region_new();
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_region_offset(long /*int*/ region, int dx, int dy);
public static final void gdk_region_offset(long /*int*/ region, int dx, int dy) {
	lock.lock();
	try {
		_gdk_region_offset(region, dx, dy);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gdk_region_point_in(long /*int*/ region, int x, int y);
public static final boolean gdk_region_point_in(long /*int*/ region, int x, int y) {
	lock.lock();
	try {
		return _gdk_region_point_in(region, x, y);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_region_polygon(int[] points, int npoints, int fill_rule);
public static final long /*int*/ gdk_region_polygon(int[] points, int npoints, int fill_rule) {
	lock.lock();
	try {
		return _gdk_region_polygon(points, npoints, fill_rule);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_region_rectangle(GdkRectangle rectangle);
public static final long /*int*/ gdk_region_rectangle(GdkRectangle rectangle) {
	lock.lock();
	try {
		return _gdk_region_rectangle(rectangle);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_region_rect_in(long /*int*/ region, GdkRectangle rect);
public static final long /*int*/ gdk_region_rect_in(long /*int*/ region, GdkRectangle rect) {
	lock.lock();
	try {
		return _gdk_region_rect_in(region, rect);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_region_subtract(long /*int*/ source1, long /*int*/ source2);
public static final void gdk_region_subtract(long /*int*/ source1, long /*int*/ source2) {
	lock.lock();
	try {
		_gdk_region_subtract(source1, source2);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_region_union(long /*int*/ source1, long /*int*/ source2);
public static final void gdk_region_union(long /*int*/ source1, long /*int*/ source2) {
	lock.lock();
	try {
		_gdk_region_union(source1, source2);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_region_union_with_rect(long /*int*/ region, GdkRectangle rect);
public static final void gdk_region_union_with_rect(long /*int*/ region, GdkRectangle rect) {
	lock.lock();
	try {
		_gdk_region_union_with_rect(region, rect);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_rgb_init();
public static final void gdk_rgb_init() {
	lock.lock();
	try {
		_gdk_rgb_init();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_screen_get_default();
public static final long /*int*/ gdk_screen_get_default() {
	lock.lock();
	try {
		return _gdk_screen_get_default();
	} finally {
		lock.unlock();
	}
}
public static final native int _gdk_screen_get_monitor_at_window(long /*int*/ screen, long /*int*/ window);
public static final int gdk_screen_get_monitor_at_window(long /*int*/ screen, long /*int*/ window) {
	lock.lock();
	try {
		return _gdk_screen_get_monitor_at_window(screen, window);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_screen_get_monitor_geometry (long /*int*/ screen, int monitor_num, GdkRectangle dest);
public static final void gdk_screen_get_monitor_geometry (long /*int*/ screen, int monitor_num, GdkRectangle dest) {
	lock.lock();
	try {
		_gdk_screen_get_monitor_geometry(screen, monitor_num, dest);
	} finally {
		lock.unlock();
	}
}
public static final native int _gdk_screen_get_n_monitors(long /*int*/ screen);
public static final int gdk_screen_get_n_monitors(long /*int*/ screen) {
	lock.lock();
	try {
		return _gdk_screen_get_n_monitors(screen);
	} finally {
		lock.unlock();
	}
}
public static final native int _gdk_screen_get_number(long /*int*/ screen);
public static final int gdk_screen_get_number(long /*int*/ screen) {
	lock.lock();
	try {
		return _gdk_screen_get_number(screen);
	} finally {
		lock.unlock();
	}
}
public static final native int _gdk_screen_height();
public static final int gdk_screen_height() {
	lock.lock();
	try {
		return _gdk_screen_height();
	} finally {
		lock.unlock();
	}
}
public static final native int _gdk_screen_width();
public static final int gdk_screen_width() {
	lock.lock();
	try {
		return _gdk_screen_width();
	} finally {
		lock.unlock();
	}
}
public static final native int _gdk_screen_width_mm();
public static final int gdk_screen_width_mm() {
	lock.lock();
	try {
		return _gdk_screen_width_mm();
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_set_program_class(byte[] program_class);
public static final void gdk_set_program_class(byte[] program_class) {
	lock.lock();
	try {
		_gdk_set_program_class(program_class);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gdk_utf8_to_compound_text(byte[] str, long /*int*/[] encoding, int[] format, long /*int*/[] ctext, int[] length);
public static final boolean gdk_utf8_to_compound_text(byte[] str, long /*int*/[] encoding, int[] format, long /*int*/[] ctext, int[] length) {
	lock.lock();
	try {
		return _gdk_utf8_to_compound_text(str, encoding, format, ctext, length);
	} finally {
		lock.unlock();
	}
}
public static final native int _gdk_text_property_to_utf8_list  (long /*int*/ encoding, int format, long /*int*/ text, int length,  long /*int*/[] list);
public static final int gdk_text_property_to_utf8_list  (long /*int*/ encoding, int format, long /*int*/ text, int length,  long /*int*/[] list) {
	lock.lock();
	try {
		return _gdk_text_property_to_utf8_list(encoding, format, text, length, list);
	} finally {
		lock.unlock();
	}
}
public static final native  int _gdk_unicode_to_keyval(int wc);
public static final  int gdk_unicode_to_keyval(int wc) {
	lock.lock();
	try {
		return _gdk_unicode_to_keyval(wc);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_visual_get_system();
public static final long /*int*/ gdk_visual_get_system() {
	lock.lock();
	try {
		return _gdk_visual_get_system();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_window_at_pointer(int[] win_x, int[] win_y);
public static final long /*int*/ gdk_window_at_pointer(int[] win_x, int[] win_y) {
	lock.lock();
	try {
		return _gdk_window_at_pointer(win_x, win_y);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_begin_paint_rect(long /*int*/ window, GdkRectangle rectangle);
public static final void gdk_window_begin_paint_rect(long /*int*/ window, GdkRectangle rectangle) {
	lock.lock();
	try {
		_gdk_window_begin_paint_rect(window, rectangle);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_destroy(long /*int*/ window);
public static final void gdk_window_destroy(long /*int*/ window) {
	lock.lock();
	try {
		_gdk_window_destroy(window);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_end_paint(long /*int*/ window);
public static final void gdk_window_end_paint(long /*int*/ window) {
	lock.lock();
	try {
		_gdk_window_end_paint(window);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_window_get_children(long /*int*/ window);
public static final long /*int*/ gdk_window_get_children(long /*int*/ window) {
	lock.lock();
	try {
		return _gdk_window_get_children(window);
	} finally {
		lock.unlock();
	}
}
public static final native int _gdk_window_get_events(long /*int*/ window);
public static final int gdk_window_get_events(long /*int*/ window) {
	lock.lock();
	try {
		return _gdk_window_get_events(window);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_focus(long /*int*/ window, int timestamp);
public static final void gdk_window_focus(long /*int*/ window, int timestamp) {
	lock.lock();
	try {
		_gdk_window_focus(window, timestamp);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_freeze_updates(long /*int*/ window);
public static final void gdk_window_freeze_updates(long /*int*/ window) {
	lock.lock();
	try {
		_gdk_window_freeze_updates(window);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_get_frame_extents(long /*int*/ window, GdkRectangle rect);
public static final void gdk_window_get_frame_extents(long /*int*/ window, GdkRectangle rect) {
	lock.lock();
	try {
		_gdk_window_get_frame_extents(window, rect);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_get_internal_paint_info(long /*int*/ window, long /*int*/ [] real_drawable, int[] x_offset, int[] y_offset);
public static final void gdk_window_get_internal_paint_info(long /*int*/ window, long /*int*/ [] real_drawable, int[] x_offset, int[] y_offset) {
	lock.lock();
	try {
		_gdk_window_get_internal_paint_info(window, real_drawable, x_offset, y_offset);
	} finally {
		lock.unlock();
	}
}
public static final native int _gdk_window_get_origin(long /*int*/ window, int[] x, int[] y);
public static final int gdk_window_get_origin(long /*int*/ window, int[] x, int[] y) {
	lock.lock();
	try {
		return _gdk_window_get_origin(window, x, y);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_window_get_parent(long /*int*/ window);
public static final long /*int*/ gdk_window_get_parent(long /*int*/ window) {
	lock.lock();
	try {
		return _gdk_window_get_parent(window);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_window_get_pointer(long /*int*/ window, int[] x, int[] y, int[] mask);
public static final long /*int*/ gdk_window_get_pointer(long /*int*/ window, int[] x, int[] y, int[] mask) {
	lock.lock();
	try {
		return _gdk_window_get_pointer(window, x, y, mask);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_get_user_data(long /*int*/ window, long /*int*/[] data);
public static final void gdk_window_get_user_data(long /*int*/ window, long /*int*/[] data) {
	lock.lock();
	try {
		_gdk_window_get_user_data(window, data);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_hide(long /*int*/ window);
public static final void gdk_window_hide(long /*int*/ window) {
	lock.lock();
	try {
		_gdk_window_hide(window);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_invalidate_rect(long /*int*/ window, GdkRectangle rectangle, boolean invalidate_children);
public static final void gdk_window_invalidate_rect(long /*int*/ window, GdkRectangle rectangle, boolean invalidate_children) {
	lock.lock();
	try {
		_gdk_window_invalidate_rect(window, rectangle, invalidate_children);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_invalidate_region(long /*int*/ window, long /*int*/ region, boolean invalidate_children);
public static final void gdk_window_invalidate_region(long /*int*/ window, long /*int*/ region, boolean invalidate_children) {
	lock.lock();
	try {
		_gdk_window_invalidate_region(window, region, invalidate_children);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_move(long /*int*/ window, int x, int y);
public static final void gdk_window_move(long /*int*/ window, int x, int y) {
	lock.lock();
	try {
		_gdk_window_move(window, x, y);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gdk_window_new(long /*int*/ parent, GdkWindowAttr attributes, int attributes_mask);
public static final long /*int*/ gdk_window_new(long /*int*/ parent, GdkWindowAttr attributes, int attributes_mask) {
	lock.lock();
	try {
		return _gdk_window_new(parent, attributes, attributes_mask);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_lower(long /*int*/ window);
public static final void gdk_window_lower(long /*int*/ window) {
	lock.lock();
	try {
		_gdk_window_lower(window);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_process_all_updates();
public static final void gdk_window_process_all_updates() {
	lock.lock();
	try {
		_gdk_window_process_all_updates();
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_process_updates(long /*int*/ window, boolean update_children);
public static final void gdk_window_process_updates(long /*int*/ window, boolean update_children) {
	lock.lock();
	try {
		_gdk_window_process_updates(window, update_children);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_raise(long /*int*/ window);
public static final void gdk_window_raise(long /*int*/ window) {
	lock.lock();
	try {
		_gdk_window_raise(window);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_resize(long /*int*/ window, int width, int height);
public static final void gdk_window_resize(long /*int*/ window, int width, int height) {
	lock.lock();
	try {
		_gdk_window_resize(window, width, height);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_scroll(long /*int*/ window, int dx, int dy);
public static final void gdk_window_scroll(long /*int*/ window, int dx, int dy) {
	lock.lock();
	try {
		_gdk_window_scroll(window, dx, dy);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_set_accept_focus(long /*int*/ window, boolean accept_focus);
public static final void gdk_window_set_accept_focus(long /*int*/ window, boolean accept_focus) {
	lock.lock();
	try {
		_gdk_window_set_accept_focus(window, accept_focus);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_set_back_pixmap(long /*int*/ window, long /*int*/ pixmap, boolean parent_relative);
public static final void gdk_window_set_back_pixmap(long /*int*/ window, long /*int*/ pixmap, boolean parent_relative) {
	lock.lock();
	try {
		_gdk_window_set_back_pixmap(window, pixmap, parent_relative);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_set_cursor(long /*int*/ window, long /*int*/ cursor);
public static final void gdk_window_set_cursor(long /*int*/ window, long /*int*/ cursor) {
	lock.lock();
	try {
		_gdk_window_set_cursor(window, cursor);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_set_decorations(long /*int*/ window, int decorations);
public static final void gdk_window_set_decorations(long /*int*/ window, int decorations) {
	lock.lock();
	try {
		_gdk_window_set_decorations(window, decorations);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_set_events(long /*int*/ window, int event_mask);
public static final void gdk_window_set_events(long /*int*/ window, int event_mask) {
	lock.lock();
	try {
		_gdk_window_set_events(window, event_mask);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_set_icon(long /*int*/ window, long /*int*/ icon_window, long /*int*/ pixmap, long /*int*/ mask);
public static final void gdk_window_set_icon(long /*int*/ window, long /*int*/ icon_window, long /*int*/ pixmap, long /*int*/ mask) {
	lock.lock();
	try {
		_gdk_window_set_icon(window, icon_window, pixmap, mask);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_set_icon_list(long /*int*/ window, long /*int*/ pixbufs);
public static final void gdk_window_set_icon_list(long /*int*/ window, long /*int*/ pixbufs) {
	lock.lock();
	try {
		_gdk_window_set_icon_list(window, pixbufs);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_set_keep_above(long /*int*/ window, boolean setting);
public static final void gdk_window_set_keep_above(long /*int*/ window, boolean setting) {
	lock.lock();
	try {
		_gdk_window_set_keep_above(window, setting);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_set_override_redirect(long /*int*/ window, boolean override_redirect);
public static final void gdk_window_set_override_redirect(long /*int*/ window, boolean override_redirect) {
	lock.lock();
	try {
		_gdk_window_set_override_redirect(window, override_redirect);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_set_user_data(long /*int*/ window, long /*int*/ user_data);
public static final void gdk_window_set_user_data(long /*int*/ window, long /*int*/ user_data) {
	lock.lock();
	try {
		_gdk_window_set_user_data(window, user_data);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_shape_combine_region (long /*int*/ window, long /*int*/  shape_region, int offset_x,  int offset_y);
public static final void gdk_window_shape_combine_region (long /*int*/ window, long /*int*/  shape_region, int offset_x,  int offset_y) {
	lock.lock();
	try {
		_gdk_window_shape_combine_region(window, shape_region, offset_x, offset_y);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_show(long /*int*/ window);
public static final void gdk_window_show(long /*int*/ window) {
	lock.lock();
	try {
		_gdk_window_show(window);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_show_unraised(long /*int*/ window);
public static final void gdk_window_show_unraised(long /*int*/ window) {
	lock.lock();
	try {
		_gdk_window_show_unraised(window);
	} finally {
		lock.unlock();
	}
}
public static final native void _gdk_window_thaw_updates(long /*int*/ window);
public static final void gdk_window_thaw_updates(long /*int*/ window) {
	lock.lock();
	try {
		_gdk_window_thaw_updates(window);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_accel_group_new();
public static final long /*int*/ gtk_accel_group_new() {
	lock.lock();
	try {
		return _gtk_accel_group_new();
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_accel_groups_activate(long /*int*/ accelGroup, int accelKey, int accelMods);
public static final boolean gtk_accel_groups_activate(long /*int*/ accelGroup, int accelKey, int accelMods) {
	lock.lock();
	try {
		return _gtk_accel_groups_activate(accelGroup, accelKey, accelMods);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_accel_label_set_accel_widget(long /*int*/ accel_label, long /*int*/ accel_widget);
public static final void gtk_accel_label_set_accel_widget(long /*int*/ accel_label, long /*int*/ accel_widget) {
	lock.lock();
	try {
		_gtk_accel_label_set_accel_widget(accel_label, accel_widget);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_adjustment_changed(long /*int*/ adjustment);
public static final void gtk_adjustment_changed(long /*int*/ adjustment) {
	lock.lock();
	try {
		_gtk_adjustment_changed(adjustment);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_adjustment_new(double value, double lower, double upper, double step_increment, double page_increment, double page_size);
public static final long /*int*/ gtk_adjustment_new(double value, double lower, double upper, double step_increment, double page_increment, double page_size) {
	lock.lock();
	try {
		return _gtk_adjustment_new(value, lower, upper, step_increment, page_increment, page_size);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_adjustment_set_value(long /*int*/ adjustment, double value);
public static final void gtk_adjustment_set_value(long /*int*/ adjustment, double value) {
	lock.lock();
	try {
		_gtk_adjustment_set_value(adjustment, value);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_adjustment_value_changed(long /*int*/ adjustment);
public static final void gtk_adjustment_value_changed(long /*int*/ adjustment) {
	lock.lock();
	try {
		_gtk_adjustment_value_changed(adjustment);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_arrow_new(int arrow_type, int shadow_type);
public static final long /*int*/ gtk_arrow_new(int arrow_type, int shadow_type) {
	lock.lock();
	try {
		return _gtk_arrow_new(arrow_type, shadow_type);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_arrow_set(long /*int*/ arrow, int arrow_type, int shadow_type);
public static final void gtk_arrow_set(long /*int*/ arrow, int arrow_type, int shadow_type) {
	lock.lock();
	try {
		_gtk_arrow_set(arrow, arrow_type, shadow_type);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_bin_get_child(long /*int*/ bin);
public static final long /*int*/ gtk_bin_get_child(long /*int*/ bin) {
	lock.lock();
	try {
		return _gtk_bin_get_child(bin);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_box_set_child_packing(long /*int*/ box, long /*int*/ child, boolean expand, boolean fill, int padding, int pack_type);
public static final void gtk_box_set_child_packing(long /*int*/ box, long /*int*/ child, boolean expand, boolean fill, int padding, int pack_type) {
	lock.lock();
	try {
		_gtk_box_set_child_packing(box, child, expand, fill, padding, pack_type);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_button_clicked(long /*int*/ button);
public static final void gtk_button_clicked(long /*int*/ button) {
	lock.lock();
	try {
		_gtk_button_clicked(button);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_button_new();
public static final long /*int*/ gtk_button_new() {
	lock.lock();
	try {
		return _gtk_button_new();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_button_set_relief(long /*int*/ button, int newstyle);
public static final void gtk_button_set_relief(long /*int*/ button, int newstyle) {
	lock.lock();
	try {
		_gtk_button_set_relief(button, newstyle);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_cell_renderer_get_size(long /*int*/ cell, long /*int*/ widget, GdkRectangle area, int[] x_offset, int[] y_offset, int[] width, int[] height);
public static final void gtk_cell_renderer_get_size(long /*int*/ cell, long /*int*/ widget, GdkRectangle area, int[] x_offset, int[] y_offset, int[] width, int[] height) {
	lock.lock();
	try {
		_gtk_cell_renderer_get_size(cell, widget, area, x_offset, y_offset, width, height);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_cell_renderer_pixbuf_new();
public static final long /*int*/ gtk_cell_renderer_pixbuf_new() {
	lock.lock();
	try {
		return _gtk_cell_renderer_pixbuf_new();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_cell_renderer_text_new();
public static final long /*int*/ gtk_cell_renderer_text_new() {
	lock.lock();
	try {
		return _gtk_cell_renderer_text_new();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_cell_renderer_toggle_new();
public static final long /*int*/ gtk_cell_renderer_toggle_new() {
	lock.lock();
	try {
		return _gtk_cell_renderer_toggle_new();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_check_button_new();
public static final long /*int*/ gtk_check_button_new() {
	lock.lock();
	try {
		return _gtk_check_button_new();
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_check_menu_item_get_active(long /*int*/ check_menu_item);
public static final boolean gtk_check_menu_item_get_active(long /*int*/ check_menu_item) {
	lock.lock();
	try {
		return _gtk_check_menu_item_get_active(check_menu_item);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_check_menu_item_new_with_label(byte[] label);
public static final long /*int*/ gtk_check_menu_item_new_with_label(byte[] label) {
	lock.lock();
	try {
		return _gtk_check_menu_item_new_with_label(label);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_check_menu_item_set_active(long /*int*/ wid, boolean active);
public static final void gtk_check_menu_item_set_active(long /*int*/ wid, boolean active) {
	lock.lock();
	try {
		_gtk_check_menu_item_set_active(wid, active);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_check_version(int required_major, int required_minor, int required_micro);
public static final long /*int*/ gtk_check_version(int required_major, int required_minor, int required_micro) {
	lock.lock();
	try {
		return _gtk_check_version(required_major, required_minor, required_micro);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_clipboard_clear(long /*int*/ clipboard);
public static final void gtk_clipboard_clear(long /*int*/ clipboard) {
	lock.lock();
	try {
		_gtk_clipboard_clear(clipboard);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_clipboard_get(long /*int*/ selection);
public static final long /*int*/ gtk_clipboard_get(long /*int*/ selection) {
	lock.lock();
	try {
		return _gtk_clipboard_get(selection);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_clipboard_set_with_data(long /*int*/ clipboard, long /*int*/ target, int n_targets, long /*int*/ get_func, long /*int*/ clear_func, long /*int*/ user_data);
public static final boolean gtk_clipboard_set_with_data(long /*int*/ clipboard, long /*int*/ target, int n_targets, long /*int*/ get_func, long /*int*/ clear_func, long /*int*/ user_data) {
	lock.lock();
	try {
		return _gtk_clipboard_set_with_data(clipboard, target, n_targets, get_func, clear_func, user_data);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_clipboard_wait_for_contents(long /*int*/ clipboard, long /*int*/ target);
public static final long /*int*/ gtk_clipboard_wait_for_contents(long /*int*/ clipboard, long /*int*/ target) {
	lock.lock();
	try {
		return _gtk_clipboard_wait_for_contents(clipboard, target);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_color_selection_dialog_new(byte[] title);
public static final long /*int*/ gtk_color_selection_dialog_new(byte[] title) {
	lock.lock();
	try {
		return _gtk_color_selection_dialog_new(title);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_color_selection_get_current_color(long /*int*/ colorsel, GdkColor color);
public static final void gtk_color_selection_get_current_color(long /*int*/ colorsel, GdkColor color) {
	lock.lock();
	try {
		_gtk_color_selection_get_current_color(colorsel, color);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_color_selection_set_current_color(long /*int*/ colorsel, GdkColor color);
public static final void gtk_color_selection_set_current_color(long /*int*/ colorsel, GdkColor color) {
	lock.lock();
	try {
		_gtk_color_selection_set_current_color(colorsel, color);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_color_selection_set_has_palette(long /*int*/ colorsel, boolean has_palette);
public static final void gtk_color_selection_set_has_palette(long /*int*/ colorsel, boolean has_palette) {
	lock.lock();
	try {
		_gtk_color_selection_set_has_palette(colorsel, has_palette);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_combo_disable_activate(long /*int*/ combo);
public static final void gtk_combo_disable_activate(long /*int*/ combo) {
	lock.lock();
	try {
		_gtk_combo_disable_activate(combo);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_combo_new();
public static final long /*int*/ gtk_combo_new() {
	lock.lock();
	try {
		return _gtk_combo_new();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_combo_set_case_sensitive(long /*int*/ combo, boolean val);
public static final void gtk_combo_set_case_sensitive(long /*int*/ combo, boolean val) {
	lock.lock();
	try {
		_gtk_combo_set_case_sensitive(combo, val);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_combo_set_popdown_strings(long /*int*/ combo, long /*int*/ strings);
public static final void gtk_combo_set_popdown_strings(long /*int*/ combo, long /*int*/ strings) {
	lock.lock();
	try {
		_gtk_combo_set_popdown_strings(combo, strings);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_container_add(long /*int*/ container, long /*int*/ widget);
public static final void gtk_container_add(long /*int*/ container, long /*int*/ widget) {
	lock.lock();
	try {
		_gtk_container_add(container, widget);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_container_forall(long /*int*/ container, long /*int*/ callback, long /*int*/ callback_data);
public static final void gtk_container_forall(long /*int*/ container, long /*int*/ callback, long /*int*/ callback_data) {
	lock.lock();
	try {
		_gtk_container_forall(container, callback, callback_data);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_container_get_border_width(long /*int*/ container);
public static final int gtk_container_get_border_width(long /*int*/ container) {
	lock.lock();
	try {
		return _gtk_container_get_border_width(container);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_container_get_children(long /*int*/ container);
public static final long /*int*/ gtk_container_get_children(long /*int*/ container) {
	lock.lock();
	try {
		return _gtk_container_get_children(container);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_container_remove(long /*int*/ container, long /*int*/ widget);
public static final void gtk_container_remove(long /*int*/ container, long /*int*/ widget) {
	lock.lock();
	try {
		_gtk_container_remove(container, widget);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_container_resize_children(long /*int*/ container);
public static final void gtk_container_resize_children(long /*int*/ container) {
	lock.lock();
	try {
		_gtk_container_resize_children(container);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_container_set_border_width(long /*int*/ container, int border_width);
public static final void gtk_container_set_border_width(long /*int*/ container, int border_width) {
	lock.lock();
	try {
		_gtk_container_set_border_width(container, border_width);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_dialog_add_button(long /*int*/ dialog, byte[]  button_text, int response_id);
public static final long /*int*/ gtk_dialog_add_button(long /*int*/ dialog, byte[]  button_text, int response_id) {
	lock.lock();
	try {
		return _gtk_dialog_add_button(dialog, button_text, response_id);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_dialog_run(long /*int*/ dialog);
public static final int gtk_dialog_run(long /*int*/ dialog) {
	lock.lock();
	try {
		return _gtk_dialog_run(dialog);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_drag_begin(long /*int*/ widget, long /*int*/ targets, int actions, int button, long /*int*/ event);
public static final long /*int*/ gtk_drag_begin(long /*int*/ widget, long /*int*/ targets, int actions, int button, long /*int*/ event) {
	lock.lock();
	try {
		return _gtk_drag_begin(widget, targets, actions, button, event);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_drag_check_threshold(long /*int*/ widget, int start_x, int start_y, int current_x, int current_y);
public static final boolean gtk_drag_check_threshold(long /*int*/ widget, int start_x, int start_y, int current_x, int current_y) {
	lock.lock();
	try {
		return _gtk_drag_check_threshold(widget, start_x, start_y, current_x, current_y);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_drag_dest_find_target(long /*int*/ widget, long /*int*/ context, long /*int*/ target_list);
public static final long /*int*/ gtk_drag_dest_find_target(long /*int*/ widget, long /*int*/ context, long /*int*/ target_list) {
	lock.lock();
	try {
		return _gtk_drag_dest_find_target(widget, context, target_list);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_drag_dest_set(long /*int*/ widget, int flags, long /*int*/ targets, int n_targets, int actions);
public static final void gtk_drag_dest_set(long /*int*/ widget, int flags, long /*int*/ targets, int n_targets, int actions) {
	lock.lock();
	try {
		_gtk_drag_dest_set(widget, flags, targets, n_targets, actions);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_drag_dest_unset(long /*int*/ widget);
public static final void gtk_drag_dest_unset(long /*int*/ widget) {
	lock.lock();
	try {
		_gtk_drag_dest_unset(widget);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_drag_finish(long /*int*/ context, boolean success, boolean delete, int time);
public static final void gtk_drag_finish(long /*int*/ context, boolean success, boolean delete, int time) {
	lock.lock();
	try {
		_gtk_drag_finish(context, success, delete, time);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_drag_get_data(long /*int*/ widget, long /*int*/ context, long /*int*/ target, int time);
public static final void gtk_drag_get_data(long /*int*/ widget, long /*int*/ context, long /*int*/ target, int time) {
	lock.lock();
	try {
		_gtk_drag_get_data(widget, context, target, time);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_drawing_area_new();
public static final long /*int*/ gtk_drawing_area_new() {
	lock.lock();
	try {
		return _gtk_drawing_area_new();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_editable_copy_clipboard(long /*int*/ editable);
public static final void gtk_editable_copy_clipboard(long /*int*/ editable) {
	lock.lock();
	try {
		_gtk_editable_copy_clipboard(editable);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_editable_cut_clipboard(long /*int*/ editable);
public static final void gtk_editable_cut_clipboard(long /*int*/ editable) {
	lock.lock();
	try {
		_gtk_editable_cut_clipboard(editable);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_editable_delete_selection(long /*int*/ editable);
public static final void gtk_editable_delete_selection(long /*int*/ editable) {
	lock.lock();
	try {
		_gtk_editable_delete_selection(editable);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_editable_delete_text(long /*int*/ editable, int start_pos, int end_pos);
public static final void gtk_editable_delete_text(long /*int*/ editable, int start_pos, int end_pos) {
	lock.lock();
	try {
		_gtk_editable_delete_text(editable, start_pos, end_pos);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_editable_get_chars(long /*int*/ editable, int start_pos, int end_pos);
public static final long /*int*/ gtk_editable_get_chars(long /*int*/ editable, int start_pos, int end_pos) {
	lock.lock();
	try {
		return _gtk_editable_get_chars(editable, start_pos, end_pos);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_editable_get_editable(long /*int*/ editable);
public static final boolean gtk_editable_get_editable(long /*int*/ editable) {
	lock.lock();
	try {
		return _gtk_editable_get_editable(editable);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_editable_get_position(long /*int*/ editable);
public static final int gtk_editable_get_position(long /*int*/ editable) {
	lock.lock();
	try {
		return _gtk_editable_get_position(editable);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_editable_get_selection_bounds(long /*int*/ editable, int[] start, int[] end);
public static final boolean gtk_editable_get_selection_bounds(long /*int*/ editable, int[] start, int[] end) {
	lock.lock();
	try {
		return _gtk_editable_get_selection_bounds(editable, start, end);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_editable_insert_text(long /*int*/ editable, byte[] new_text, int new_text_length, int[] position);
public static final void gtk_editable_insert_text(long /*int*/ editable, byte[] new_text, int new_text_length, int[] position) {
	lock.lock();
	try {
		_gtk_editable_insert_text(editable, new_text, new_text_length, position);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_editable_paste_clipboard(long /*int*/ editable);
public static final void gtk_editable_paste_clipboard(long /*int*/ editable) {
	lock.lock();
	try {
		_gtk_editable_paste_clipboard(editable);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_editable_select_region(long /*int*/ editable, int start, int end);
public static final void gtk_editable_select_region(long /*int*/ editable, int start, int end) {
	lock.lock();
	try {
		_gtk_editable_select_region(editable, start, end);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_editable_set_editable(long /*int*/ entry, boolean editable);
public static final void gtk_editable_set_editable(long /*int*/ entry, boolean editable) {
	lock.lock();
	try {
		_gtk_editable_set_editable(entry, editable);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_editable_set_position(long /*int*/ editable, int position);
public static final void gtk_editable_set_position(long /*int*/ editable, int position) {
	lock.lock();
	try {
		_gtk_editable_set_position(editable, position);
	} finally {
		lock.unlock();
	}
}
public static final native char _gtk_entry_get_invisible_char(long /*int*/ entry);
public static final char gtk_entry_get_invisible_char(long /*int*/ entry) {
	lock.lock();
	try {
		return _gtk_entry_get_invisible_char(entry);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_entry_get_layout (long /*int*/ entry);
public static final long /*int*/ gtk_entry_get_layout (long /*int*/ entry) {
	lock.lock();
	try {
		return _gtk_entry_get_layout(entry);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_entry_get_max_length(long /*int*/ entry);
public static final int gtk_entry_get_max_length(long /*int*/ entry) {
	lock.lock();
	try {
		return _gtk_entry_get_max_length(entry);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_entry_get_text(long /*int*/ entry);
public static final long /*int*/ gtk_entry_get_text(long /*int*/ entry) {
	lock.lock();
	try {
		return _gtk_entry_get_text(entry);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_entry_get_visibility(long /*int*/ entry);
public static final boolean gtk_entry_get_visibility(long /*int*/ entry) {
	lock.lock();
	try {
		return _gtk_entry_get_visibility(entry);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_entry_new();
public static final long /*int*/ gtk_entry_new() {
	lock.lock();
	try {
		return _gtk_entry_new();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_entry_set_activates_default(long /*int*/ entry, boolean setting);
public static final void gtk_entry_set_activates_default(long /*int*/ entry, boolean setting) {
	lock.lock();
	try {
		_gtk_entry_set_activates_default(entry, setting);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_entry_set_alignment(long /*int*/ entry, float xalign);
public static final void gtk_entry_set_alignment(long /*int*/ entry, float xalign) {
	lock.lock();
	try {
		_gtk_entry_set_alignment(entry, xalign);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_entry_set_has_frame(long /*int*/ entry, boolean setting);
public static final void gtk_entry_set_has_frame(long /*int*/ entry, boolean setting) {
	lock.lock();
	try {
		_gtk_entry_set_has_frame(entry, setting);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_entry_set_invisible_char(long /*int*/ entry, char ch);
public static final void gtk_entry_set_invisible_char(long /*int*/ entry, char ch) {
	lock.lock();
	try {
		_gtk_entry_set_invisible_char(entry, ch);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_entry_set_max_length(long /*int*/ entry, int max);
public static final void gtk_entry_set_max_length(long /*int*/ entry, int max) {
	lock.lock();
	try {
		_gtk_entry_set_max_length(entry, max);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_entry_set_text(long /*int*/ entry, byte[] text);
public static final void gtk_entry_set_text(long /*int*/ entry, byte[] text) {
	lock.lock();
	try {
		_gtk_entry_set_text(entry, text);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_entry_set_visibility(long /*int*/ entry, boolean visible);
public static final void gtk_entry_set_visibility(long /*int*/ entry, boolean visible) {
	lock.lock();
	try {
		_gtk_entry_set_visibility(entry, visible);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_events_pending();
public static final int gtk_events_pending() {
	lock.lock();
	try {
		return _gtk_events_pending();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_file_chooser_add_filter(long /*int*/ chooser, long /*int*/ filter);
public static final void gtk_file_chooser_add_filter(long /*int*/ chooser, long /*int*/ filter) {
	lock.lock();
	try {
		_gtk_file_chooser_add_filter(chooser, filter);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_file_chooser_dialog_new(byte[] title, long /*int*/ parent, int action, long /*int*/ first_button_text, int first_button_id, long /*int*/ second_button_text, int second_button_id, long /*int*/ terminator);
public static final long /*int*/ gtk_file_chooser_dialog_new(byte[] title, long /*int*/ parent, int action, long /*int*/ first_button_text, int first_button_id, long /*int*/ second_button_text, int second_button_id, long /*int*/ terminator) {
	lock.lock();
	try {
		return _gtk_file_chooser_dialog_new(title, parent, action, first_button_text, first_button_id, second_button_text, second_button_id, terminator);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_file_chooser_get_current_folder(long /*int*/ chooser);
public static final long /*int*/ gtk_file_chooser_get_current_folder(long /*int*/ chooser) {
	lock.lock();
	try {
		return _gtk_file_chooser_get_current_folder(chooser);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_file_chooser_get_filename(long /*int*/ chooser);
public static final long /*int*/ gtk_file_chooser_get_filename(long /*int*/ chooser) {
	lock.lock();
	try {
		return _gtk_file_chooser_get_filename(chooser);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_file_chooser_get_filenames(long /*int*/ chooser);
public static final long /*int*/ gtk_file_chooser_get_filenames(long /*int*/ chooser) {
	lock.lock();
	try {
		return _gtk_file_chooser_get_filenames(chooser);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_file_chooser_set_current_folder(long /*int*/ chooser, byte[] filename);
public static final void gtk_file_chooser_set_current_folder(long /*int*/ chooser, byte[] filename) {
	lock.lock();
	try {
		_gtk_file_chooser_set_current_folder(chooser, filename);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_file_chooser_set_current_name(long /*int*/ chooser, byte[] name);
public static final void gtk_file_chooser_set_current_name(long /*int*/ chooser, byte[] name) {
	lock.lock();
	try {
		_gtk_file_chooser_set_current_name(chooser, name);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_file_chooser_set_extra_widget(long /*int*/ chooser, long /*int*/ extra_widget);
public static final void gtk_file_chooser_set_extra_widget(long /*int*/ chooser, long /*int*/ extra_widget) {
	lock.lock();
	try {
		_gtk_file_chooser_set_extra_widget(chooser, extra_widget);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_file_chooser_set_filename(long /*int*/ chooser, byte[] name);
public static final void gtk_file_chooser_set_filename(long /*int*/ chooser, byte[] name) {
	lock.lock();
	try {
		_gtk_file_chooser_set_filename(chooser, name);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_file_chooser_set_select_multiple(long /*int*/ chooser, boolean select_multiple);
public static final void gtk_file_chooser_set_select_multiple(long /*int*/ chooser, boolean select_multiple) {
	lock.lock();
	try {
		_gtk_file_chooser_set_select_multiple(chooser, select_multiple);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_file_filter_add_pattern(long /*int*/ filter, byte[] pattern);
public static final void gtk_file_filter_add_pattern(long /*int*/ filter, byte[] pattern) {
	lock.lock();
	try {
		_gtk_file_filter_add_pattern(filter, pattern);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_file_filter_new();
public static final long /*int*/ gtk_file_filter_new() {
	lock.lock();
	try {
		return _gtk_file_filter_new();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_file_filter_set_name(long /*int*/ filter, byte[] name);
public static final void gtk_file_filter_set_name(long /*int*/ filter, byte[] name) {
	lock.lock();
	try {
		_gtk_file_filter_set_name(filter, name);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_file_selection_get_filename(long /*int*/ filesel);
public static final long /*int*/ gtk_file_selection_get_filename(long /*int*/ filesel) {
	lock.lock();
	try {
		return _gtk_file_selection_get_filename(filesel);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_file_selection_get_selections(long /*int*/ filesel);
public static final long /*int*/ gtk_file_selection_get_selections(long /*int*/ filesel) {
	lock.lock();
	try {
		return _gtk_file_selection_get_selections(filesel);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_file_selection_hide_fileop_buttons(long /*int*/ filesel);
public static final void gtk_file_selection_hide_fileop_buttons(long /*int*/ filesel) {
	lock.lock();
	try {
		_gtk_file_selection_hide_fileop_buttons(filesel);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_file_selection_new(byte[] title);
public static final long /*int*/ gtk_file_selection_new(byte[] title) {
	lock.lock();
	try {
		return _gtk_file_selection_new(title);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_file_selection_set_filename(long /*int*/ filesel, long /*int*/ filename);
public static final void gtk_file_selection_set_filename(long /*int*/ filesel, long /*int*/ filename) {
	lock.lock();
	try {
		_gtk_file_selection_set_filename(filesel, filename);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_file_selection_set_select_multiple(long /*int*/ filesel, boolean select_multiple);
public static final void gtk_file_selection_set_select_multiple(long /*int*/ filesel, boolean select_multiple) {
	lock.lock();
	try {
		_gtk_file_selection_set_select_multiple(filesel, select_multiple);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_fixed_move(long /*int*/ fixed, long /*int*/ widget, int x, int y);
public static final void gtk_fixed_move(long /*int*/ fixed, long /*int*/ widget, int x, int y) {
	lock.lock();
	try {
		_gtk_fixed_move(fixed, widget, x, y);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_fixed_new();
public static final long /*int*/ gtk_fixed_new() {
	lock.lock();
	try {
		return _gtk_fixed_new();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_fixed_set_has_window(long /*int*/ fixed, boolean has_window);
public static final void gtk_fixed_set_has_window(long /*int*/ fixed, boolean has_window) {
	lock.lock();
	try {
		_gtk_fixed_set_has_window(fixed, has_window);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_font_selection_dialog_get_font_name(long /*int*/ fsd);
public static final long /*int*/ gtk_font_selection_dialog_get_font_name(long /*int*/ fsd) {
	lock.lock();
	try {
		return _gtk_font_selection_dialog_get_font_name(fsd);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_font_selection_dialog_new(byte[] title);
public static final long /*int*/ gtk_font_selection_dialog_new(byte[] title) {
	lock.lock();
	try {
		return _gtk_font_selection_dialog_new(title);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_font_selection_dialog_set_font_name(long /*int*/ fsd, byte[] fontname);
public static final boolean gtk_font_selection_dialog_set_font_name(long /*int*/ fsd, byte[] fontname) {
	lock.lock();
	try {
		return _gtk_font_selection_dialog_set_font_name(fsd, fontname);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_frame_new(byte[] label);
public static final long /*int*/ gtk_frame_new(byte[] label) {
	lock.lock();
	try {
		return _gtk_frame_new(label);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_frame_get_label_widget(long /*int*/ frame);
public static final long /*int*/ gtk_frame_get_label_widget(long /*int*/ frame) {
	lock.lock();
	try {
		return _gtk_frame_get_label_widget(frame);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_frame_set_label(long /*int*/ frame, byte[] label);
public static final void gtk_frame_set_label(long /*int*/ frame, byte[] label) {
	lock.lock();
	try {
		_gtk_frame_set_label(frame, label);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_frame_set_label_widget(long /*int*/ frame, long /*int*/ label_widget);
public static final void gtk_frame_set_label_widget(long /*int*/ frame, long /*int*/ label_widget) {
	lock.lock();
	try {
		_gtk_frame_set_label_widget(frame, label_widget);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_frame_set_shadow_type(long /*int*/ frame, int type);
public static final void gtk_frame_set_shadow_type(long /*int*/ frame, int type) {
	lock.lock();
	try {
		_gtk_frame_set_shadow_type(frame, type);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_get_current_event();
public static final long /*int*/ gtk_get_current_event() {
	lock.lock();
	try {
		return _gtk_get_current_event();
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_get_current_event_state (int[] state);
public static final boolean gtk_get_current_event_state (int[] state) {
	lock.lock();
	try {
		return _gtk_get_current_event_state(state);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_get_current_event_time();
public static final int gtk_get_current_event_time() {
	lock.lock();
	try {
		return _gtk_get_current_event_time();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_get_default_language();
public static final long /*int*/ gtk_get_default_language() {
	lock.lock();
	try {
		return _gtk_get_default_language();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_get_event_widget(long /*int*/ event);
public static final long /*int*/ gtk_get_event_widget(long /*int*/ event) {
	lock.lock();
	try {
		return _gtk_get_event_widget(event);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_grab_add(long /*int*/ widget);
public static final void gtk_grab_add(long /*int*/ widget) {
	lock.lock();
	try {
		_gtk_grab_add(widget);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_grab_get_current();
public static final long /*int*/ gtk_grab_get_current() {
	lock.lock();
	try {
		return _gtk_grab_get_current();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_grab_remove(long /*int*/ widget);
public static final void gtk_grab_remove(long /*int*/ widget) {
	lock.lock();
	try {
		_gtk_grab_remove(widget);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_hbox_new(boolean homogeneous, int spacing);
public static final long /*int*/ gtk_hbox_new(boolean homogeneous, int spacing) {
	lock.lock();
	try {
		return _gtk_hbox_new(homogeneous, spacing);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_hscale_new(long /*int*/ adjustment);
public static final long /*int*/ gtk_hscale_new(long /*int*/ adjustment) {
	lock.lock();
	try {
		return _gtk_hscale_new(adjustment);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_hscrollbar_new(long /*int*/ adjustment);
public static final long /*int*/ gtk_hscrollbar_new(long /*int*/ adjustment) {
	lock.lock();
	try {
		return _gtk_hscrollbar_new(adjustment);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_hseparator_new();
public static final long /*int*/ gtk_hseparator_new() {
	lock.lock();
	try {
		return _gtk_hseparator_new();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_icon_factory_lookup_default(byte[] stock_id);
public static final long /*int*/ gtk_icon_factory_lookup_default(byte[] stock_id) {
	lock.lock();
	try {
		return _gtk_icon_factory_lookup_default(stock_id);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_icon_set_render_icon(long /*int*/ icon_set, long /*int*/ style, int direction, int state, int size, long /*int*/ widget, long /*int*/ detail);
public static final long /*int*/ gtk_icon_set_render_icon(long /*int*/ icon_set, long /*int*/ style, int direction, int state, int size, long /*int*/ widget, long /*int*/ detail) {
	lock.lock();
	try {
		return _gtk_icon_set_render_icon(icon_set, style, direction, state, size, widget, detail);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_im_context_filter_keypress(long /*int*/ context, long /*int*/ event);
public static final boolean gtk_im_context_filter_keypress(long /*int*/ context, long /*int*/ event) {
	lock.lock();
	try {
		return _gtk_im_context_filter_keypress(context, event);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_im_context_focus_in(long /*int*/ context);
public static final void gtk_im_context_focus_in(long /*int*/ context) {
	lock.lock();
	try {
		_gtk_im_context_focus_in(context);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_im_context_focus_out(long /*int*/ context);
public static final void gtk_im_context_focus_out(long /*int*/ context) {
	lock.lock();
	try {
		_gtk_im_context_focus_out(context);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_im_context_get_preedit_string(long /*int*/ context, long /*int*/[] str, long /*int*/[] attrs, int[] cursor_pos);
public static final void gtk_im_context_get_preedit_string(long /*int*/ context, long /*int*/[] str, long /*int*/[] attrs, int[] cursor_pos) {
	lock.lock();
	try {
		_gtk_im_context_get_preedit_string(context, str, attrs, cursor_pos);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_im_context_get_type();
public static final long /*int*/ gtk_im_context_get_type() {
	lock.lock();
	try {
		return _gtk_im_context_get_type();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_im_context_reset(long /*int*/ context);
public static final void gtk_im_context_reset(long /*int*/ context) {
	lock.lock();
	try {
		_gtk_im_context_reset(context);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_im_context_set_client_window(long /*int*/ context, long /*int*/ window);
public static final void gtk_im_context_set_client_window(long /*int*/ context, long /*int*/ window) {
	lock.lock();
	try {
		_gtk_im_context_set_client_window(context, window);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_im_context_set_cursor_location(long /*int*/ context, GdkRectangle area);
public static final void gtk_im_context_set_cursor_location(long /*int*/ context, GdkRectangle area) {
	lock.lock();
	try {
		_gtk_im_context_set_cursor_location(context, area);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_im_multicontext_append_menuitems (long /*int*/ context, long /*int*/ menushell);
public static final void gtk_im_multicontext_append_menuitems (long /*int*/ context, long /*int*/ menushell) {
	lock.lock();
	try {
		_gtk_im_multicontext_append_menuitems(context, menushell);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_im_multicontext_new();
public static final long /*int*/ gtk_im_multicontext_new() {
	lock.lock();
	try {
		return _gtk_im_multicontext_new();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_image_menu_item_new_with_label(byte[] label);
public static final long /*int*/ gtk_image_menu_item_new_with_label(byte[] label) {
	lock.lock();
	try {
		return _gtk_image_menu_item_new_with_label(label);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_image_menu_item_set_image(long /*int*/ menu_item, long /*int*/ image);
public static final void gtk_image_menu_item_set_image(long /*int*/ menu_item, long /*int*/ image) {
	lock.lock();
	try {
		_gtk_image_menu_item_set_image(menu_item, image);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_image_new();
public static final long /*int*/ gtk_image_new() {
	lock.lock();
	try {
		return _gtk_image_new();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_image_new_from_pixbuf(long /*int*/ pixbuf); 
public static final long /*int*/ gtk_image_new_from_pixbuf(long /*int*/ pixbuf) {
	lock.lock();
	try {
		return _gtk_image_new_from_pixbuf(pixbuf);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_image_new_from_pixmap(long /*int*/ pixmap, long /*int*/ mask);
public static final long /*int*/ gtk_image_new_from_pixmap(long /*int*/ pixmap, long /*int*/ mask) {
	lock.lock();
	try {
		return _gtk_image_new_from_pixmap(pixmap, mask);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_image_set_from_pixbuf(long /*int*/ image, long /*int*/ pixbuf);
public static final void gtk_image_set_from_pixbuf(long /*int*/ image, long /*int*/ pixbuf) {
	lock.lock();
	try {
		_gtk_image_set_from_pixbuf(image, pixbuf);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_image_set_from_pixmap(long /*int*/ image, long /*int*/ pixmap, long /*int*/ mask);
public static final void gtk_image_set_from_pixmap(long /*int*/ image, long /*int*/ pixmap, long /*int*/ mask) {
	lock.lock();
	try {
		_gtk_image_set_from_pixmap(image, pixmap, mask);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_init_check(long /*int*/[] argc, long /*int*/[] argv);
public static final boolean gtk_init_check(long /*int*/[] argc, long /*int*/[] argv) {
	lock.lock();
	try {
		return _gtk_init_check(argc, argv);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_label_get_mnemonic_keyval(long /*int*/ label);
public static final int gtk_label_get_mnemonic_keyval(long /*int*/ label) {
	lock.lock();
	try {
		return _gtk_label_get_mnemonic_keyval(label);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_label_new(byte[] label);
public static final long /*int*/ gtk_label_new(byte[] label) {
	lock.lock();
	try {
		return _gtk_label_new(label);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_label_new_with_mnemonic(byte[] str);
public static final long /*int*/ gtk_label_new_with_mnemonic(byte[] str) {
	lock.lock();
	try {
		return _gtk_label_new_with_mnemonic(str);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_label_set_attributes(long /*int*/ label, long /*int*/ attrs);
public static final void gtk_label_set_attributes(long /*int*/ label, long /*int*/ attrs) {
	lock.lock();
	try {
		_gtk_label_set_attributes(label, attrs);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_label_set_justify(long /*int*/ label, int jtype);
public static final void gtk_label_set_justify(long /*int*/ label, int jtype) {
	lock.lock();
	try {
		_gtk_label_set_justify(label, jtype);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_label_set_line_wrap(long /*int*/ label, boolean wrap);
public static final void gtk_label_set_line_wrap(long /*int*/ label, boolean wrap) {
	lock.lock();
	try {
		_gtk_label_set_line_wrap(label, wrap);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_label_set_text(long /*int*/ label, long /*int*/ str);
public static final void gtk_label_set_text(long /*int*/ label, long /*int*/ str) {
	lock.lock();
	try {
		_gtk_label_set_text(label, str);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_label_set_text(long /*int*/ label, byte[] str);
public static final void gtk_label_set_text(long /*int*/ label, byte[] str) {
	lock.lock();
	try {
		_gtk_label_set_text(label, str);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_label_set_text_with_mnemonic(long /*int*/ label, byte[] str);
public static final void gtk_label_set_text_with_mnemonic(long /*int*/ label, byte[] str) {
	lock.lock();
	try {
		_gtk_label_set_text_with_mnemonic(label, str);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_list_append_items(long /*int*/ list, long /*int*/ items);
public static final void gtk_list_append_items(long /*int*/ list, long /*int*/ items) {
	lock.lock();
	try {
		_gtk_list_append_items(list, items);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_list_clear_items(long /*int*/ list, int start, int end);
public static final void gtk_list_clear_items(long /*int*/ list, int start, int end) {
	lock.lock();
	try {
		_gtk_list_clear_items(list, start, end);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_list_insert_items(long /*int*/ list, long /*int*/ items, int position);
public static final void gtk_list_insert_items(long /*int*/ list, long /*int*/ items, int position) {
	lock.lock();
	try {
		_gtk_list_insert_items(list, items, position);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_list_item_new_with_label(byte[] label);
public static final long /*int*/ gtk_list_item_new_with_label(byte[] label) {
	lock.lock();
	try {
		return _gtk_list_item_new_with_label(label);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_list_remove_items(long /*int*/ list, long /*int*/ items);
public static final void gtk_list_remove_items(long /*int*/ list, long /*int*/ items) {
	lock.lock();
	try {
		_gtk_list_remove_items(list, items);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_list_select_item(long /*int*/ list, int item);
public static final void gtk_list_select_item(long /*int*/ list, int item) {
	lock.lock();
	try {
		_gtk_list_select_item(list, item);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_list_unselect_all(long /*int*/ list);
public static final void gtk_list_unselect_all(long /*int*/ list) {
	lock.lock();
	try {
		_gtk_list_unselect_all(list);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_list_unselect_item(long /*int*/ list, int item);
public static final void gtk_list_unselect_item(long /*int*/ list, int item) {
	lock.lock();
	try {
		_gtk_list_unselect_item(list, item);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_list_store_append(long /*int*/ list_store, long /*int*/ iter);
public static final void gtk_list_store_append(long /*int*/ list_store, long /*int*/ iter) {
	lock.lock();
	try {
		_gtk_list_store_append(list_store, iter);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_list_store_clear(long /*int*/ store);
public static final void gtk_list_store_clear(long /*int*/ store) {
	lock.lock();
	try {
		_gtk_list_store_clear(store);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_list_store_insert(long /*int*/ list_store, long /*int*/ iter, int position);
public static final void gtk_list_store_insert(long /*int*/ list_store, long /*int*/ iter, int position) {
	lock.lock();
	try {
		_gtk_list_store_insert(list_store, iter, position);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_list_store_newv(int numColumns, long /*int*/[] types);
public static final long /*int*/ gtk_list_store_newv(int numColumns, long /*int*/[] types) {
	lock.lock();
	try {
		return _gtk_list_store_newv(numColumns, types);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_list_store_remove(long /*int*/ list_store, long /*int*/ iter);
public static final void gtk_list_store_remove(long /*int*/ list_store, long /*int*/ iter) {
	lock.lock();
	try {
		_gtk_list_store_remove(list_store, iter);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_list_store_set(long /*int*/ store, long /*int*/ iter, int column, byte[] value, long /*int*/ terminator);
public static final void gtk_list_store_set(long /*int*/ store, long /*int*/ iter, int column, byte[] value, long /*int*/ terminator) {
	lock.lock();
	try {
		_gtk_list_store_set(store, iter, column, value, terminator);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_list_store_set(long /*int*/ store, long /*int*/ iter, int column, int value, long /*int*/ terminator);
public static final void gtk_list_store_set(long /*int*/ store, long /*int*/ iter, int column, int value, long /*int*/ terminator) {
	lock.lock();
	try {
		_gtk_list_store_set(store, iter, column, value, terminator);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_list_store_set(long /*int*/ store, long /*int*/ iter, int column, long value, long /*int*/ terminator);
public static final void gtk_list_store_set(long /*int*/ store, long /*int*/ iter, int column, long value, long /*int*/ terminator) {
	lock.lock();
	try {
		_gtk_list_store_set(store, iter, column, value, terminator);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_list_store_set(long /*int*/ store, long /*int*/ iter, int column, GdkColor value, long /*int*/ terminator);
public static final void gtk_list_store_set(long /*int*/ store, long /*int*/ iter, int column, GdkColor value, long /*int*/ terminator) {
	lock.lock();
	try {
		_gtk_list_store_set(store, iter, column, value, terminator);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_list_store_set(long /*int*/ store, long /*int*/ iter, int column, boolean value, long /*int*/ terminator);
public static final void gtk_list_store_set(long /*int*/ store, long /*int*/ iter, int column, boolean value, long /*int*/ terminator) {
	lock.lock();
	try {
		_gtk_list_store_set(store, iter, column, value, terminator);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_major_version();
public static final int gtk_major_version() {
	lock.lock();
	try {
		return _gtk_major_version();
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_minor_version();
public static final int gtk_minor_version() {
	lock.lock();
	try {
		return _gtk_minor_version();
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_micro_version();
public static final int gtk_micro_version() {
	lock.lock();
	try {
		return _gtk_micro_version();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_main();
public static final void gtk_main() {
	lock.lock();
	try {
		_gtk_main();
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_main_iteration();
public static final int gtk_main_iteration() {
	lock.lock();
	try {
		return _gtk_main_iteration();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_main_do_event(long /*int*/ event);
public static final void gtk_main_do_event(long /*int*/ event) {
	lock.lock();
	try {
		_gtk_main_do_event(event);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_menu_bar_new();
public static final long /*int*/ gtk_menu_bar_new() {
	lock.lock();
	try {
		return _gtk_menu_bar_new();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_menu_item_remove_submenu(long /*int*/ menu_item);
public static final void gtk_menu_item_remove_submenu(long /*int*/ menu_item) {
	lock.lock();
	try {
		_gtk_menu_item_remove_submenu(menu_item);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_menu_item_set_submenu(long /*int*/ menu_item, long /*int*/ submenu);
public static final void gtk_menu_item_set_submenu(long /*int*/ menu_item, long /*int*/ submenu) {
	lock.lock();
	try {
		_gtk_menu_item_set_submenu(menu_item, submenu);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_menu_new();
public static final long /*int*/ gtk_menu_new() {
	lock.lock();
	try {
		return _gtk_menu_new();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_menu_popdown(long /*int*/ menu);
public static final void gtk_menu_popdown(long /*int*/ menu) {
	lock.lock();
	try {
		_gtk_menu_popdown(menu);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_menu_popup(long /*int*/ menu, long /*int*/ parent_menu_shell, long /*int*/ parent_menu_item, long /*int*/ func, long /*int*/ data, int button, int activate_time);
public static final void gtk_menu_popup(long /*int*/ menu, long /*int*/ parent_menu_shell, long /*int*/ parent_menu_item, long /*int*/ func, long /*int*/ data, int button, int activate_time) {
	lock.lock();
	try {
		_gtk_menu_popup(menu, parent_menu_shell, parent_menu_item, func, data, button, activate_time);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_menu_shell_deactivate(long /*int*/ menu_shell);
public static final void gtk_menu_shell_deactivate(long /*int*/ menu_shell) {
	lock.lock();
	try {
		_gtk_menu_shell_deactivate(menu_shell);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_menu_shell_insert(long /*int*/ menu_shell, long /*int*/ child, int position);
public static final void gtk_menu_shell_insert(long /*int*/ menu_shell, long /*int*/ child, int position) {
	lock.lock();
	try {
		_gtk_menu_shell_insert(menu_shell, child, position);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_menu_shell_select_item(long /*int*/ menu_shell, long /*int*/ menu_item);
public static final void gtk_menu_shell_select_item(long /*int*/ menu_shell, long /*int*/ menu_item) {
	lock.lock();
	try {
		_gtk_menu_shell_select_item(menu_shell, menu_item);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_message_dialog_new(long /*int*/ parent, int flags, int type, int buttons, byte[] message_format);
public static final long /*int*/ gtk_message_dialog_new(long /*int*/ parent, int flags, int type, int buttons, byte[] message_format) {
	lock.lock();
	try {
		return _gtk_message_dialog_new(parent, flags, type, buttons, message_format);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_misc_set_alignment(long /*int*/ misc, float xalign, float yalign);
public static final void gtk_misc_set_alignment(long /*int*/ misc, float xalign, float yalign) {
	lock.lock();
	try {
		_gtk_misc_set_alignment(misc, xalign, yalign);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_notebook_get_current_page(long /*int*/ notebook);
public static final int gtk_notebook_get_current_page(long /*int*/ notebook) {
	lock.lock();
	try {
		return _gtk_notebook_get_current_page(notebook);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_notebook_get_scrollable(long /*int*/ notebook);
public static final boolean gtk_notebook_get_scrollable(long /*int*/ notebook) {
	lock.lock();
	try {
		return _gtk_notebook_get_scrollable(notebook);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_notebook_insert_page(long /*int*/ notebook, long /*int*/ child, long /*int*/ tab_label, int position);
public static final void gtk_notebook_insert_page(long /*int*/ notebook, long /*int*/ child, long /*int*/ tab_label, int position) {
	lock.lock();
	try {
		_gtk_notebook_insert_page(notebook, child, tab_label, position);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_notebook_new();
public static final long /*int*/ gtk_notebook_new() {
	lock.lock();
	try {
		return _gtk_notebook_new();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_notebook_remove_page(long /*int*/ notebook, int page_num);
public static final void gtk_notebook_remove_page(long /*int*/ notebook, int page_num) {
	lock.lock();
	try {
		_gtk_notebook_remove_page(notebook, page_num);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_notebook_set_current_page(long /*int*/ notebook, int page_num);
public static final void gtk_notebook_set_current_page(long /*int*/ notebook, int page_num) {
	lock.lock();
	try {
		_gtk_notebook_set_current_page(notebook, page_num);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_notebook_set_scrollable(long /*int*/ notebook, boolean scrollable);
public static final void gtk_notebook_set_scrollable(long /*int*/ notebook, boolean scrollable) {
	lock.lock();
	try {
		_gtk_notebook_set_scrollable(notebook, scrollable);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_notebook_set_show_tabs(long /*int*/ notebook, boolean show_tabs);
public static final void gtk_notebook_set_show_tabs(long /*int*/ notebook, boolean show_tabs) {
	lock.lock();
	try {
		_gtk_notebook_set_show_tabs(notebook, show_tabs);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_notebook_set_tab_pos(long /*int*/ notebook, int pos);
public static final void gtk_notebook_set_tab_pos(long /*int*/ notebook, int pos) {
	lock.lock();
	try {
		_gtk_notebook_set_tab_pos(notebook, pos);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_object_sink(long /*int*/ object);
public static final void gtk_object_sink(long /*int*/ object) {
	lock.lock();
	try {
		_gtk_object_sink(object);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_paint_handle(long /*int*/ style, long /*int*/ window, int state_type, int shadow_type, GdkRectangle area, long /*int*/ widget, byte[] detail, int x , int y, int width, int height, int orientation);
public static final void gtk_paint_handle(long /*int*/ style, long /*int*/ window, int state_type, int shadow_type, GdkRectangle area, long /*int*/ widget, byte[] detail, int x , int y, int width, int height, int orientation) {
	lock.lock();
	try {
		_gtk_paint_handle(style, window, state_type, shadow_type, area, widget, detail, x, y, width, height, orientation);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_paint_focus(long /*int*/ style, long /*int*/ window, int state_type, GdkRectangle area, long /*int*/ widget, byte[] detail, int x , int y, int width, int height);
public static final void gtk_paint_focus(long /*int*/ style, long /*int*/ window, int state_type, GdkRectangle area, long /*int*/ widget, byte[] detail, int x , int y, int width, int height) {
	lock.lock();
	try {
		_gtk_paint_focus(style, window, state_type, area, widget, detail, x, y, width, height);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_plug_get_id(long /*int*/ plug);
public static final long /*int*/ gtk_plug_get_id(long /*int*/ plug) {
	lock.lock();
	try {
		return _gtk_plug_get_id(plug);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_plug_new(long /*int*/ socket_id);
public static final long /*int*/ gtk_plug_new(long /*int*/ socket_id) {
	lock.lock();
	try {
		return _gtk_plug_new(socket_id);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_progress_bar_new();
public static final long /*int*/ gtk_progress_bar_new() {
	lock.lock();
	try {
		return _gtk_progress_bar_new();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_progress_bar_pulse(long /*int*/ pbar);
public static final void gtk_progress_bar_pulse(long /*int*/ pbar) {
	lock.lock();
	try {
		_gtk_progress_bar_pulse(pbar);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_progress_bar_set_fraction(long /*int*/ pbar, double fraction);
public static final void gtk_progress_bar_set_fraction(long /*int*/ pbar, double fraction) {
	lock.lock();
	try {
		_gtk_progress_bar_set_fraction(pbar, fraction);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_progress_bar_set_orientation(long /*int*/ pbar, int orientation);
public static final void gtk_progress_bar_set_orientation(long /*int*/ pbar, int orientation) {
	lock.lock();
	try {
		_gtk_progress_bar_set_orientation(pbar, orientation);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_radio_button_get_group(long /*int*/ radio_button);
public static final long /*int*/ gtk_radio_button_get_group(long /*int*/ radio_button) {
	lock.lock();
	try {
		return _gtk_radio_button_get_group(radio_button);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_radio_button_new(long /*int*/ group);
public static final long /*int*/ gtk_radio_button_new(long /*int*/ group) {
	lock.lock();
	try {
		return _gtk_radio_button_new(group);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_radio_menu_item_get_group(long /*int*/ radio_menu_item);
public static final long /*int*/ gtk_radio_menu_item_get_group(long /*int*/ radio_menu_item) {
	lock.lock();
	try {
		return _gtk_radio_menu_item_get_group(radio_menu_item);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_radio_menu_item_new(long /*int*/ group);
public static final long /*int*/ gtk_radio_menu_item_new(long /*int*/ group) {
	lock.lock();
	try {
		return _gtk_radio_menu_item_new(group);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_radio_menu_item_new_with_label(long /*int*/ group, byte[] label);
public static final long /*int*/ gtk_radio_menu_item_new_with_label(long /*int*/ group, byte[] label) {
	lock.lock();
	try {
		return _gtk_radio_menu_item_new_with_label(group, label);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_range_get_adjustment(long /*int*/ range);
public static final long /*int*/ gtk_range_get_adjustment(long /*int*/ range) {
	lock.lock();
	try {
		return _gtk_range_get_adjustment(range);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_range_set_increments(long /*int*/ range, double step, double page);
public static final void gtk_range_set_increments(long /*int*/ range, double step, double page) {
	lock.lock();
	try {
		_gtk_range_set_increments(range, step, page);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_range_set_inverted(long /*int*/ range, boolean setting);
public static final void gtk_range_set_inverted(long /*int*/ range, boolean setting) {
	lock.lock();
	try {
		_gtk_range_set_inverted(range, setting);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_range_set_range(long /*int*/ range, double min, double max);
public static final void gtk_range_set_range(long /*int*/ range, double min, double max) {
	lock.lock();
	try {
		_gtk_range_set_range(range, min, max);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_range_set_value(long /*int*/ range, double value);
public static final void gtk_range_set_value(long /*int*/ range, double value) {
	lock.lock();
	try {
		_gtk_range_set_value(range, value);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_rc_parse_string(byte[] rc_string);
public static final void gtk_rc_parse_string(byte[] rc_string) {
	lock.lock();
	try {
		_gtk_rc_parse_string(rc_string);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_rc_style_get_bg_pixmap_name(long /*int*/ style, int index);
public static final long /*int*/ gtk_rc_style_get_bg_pixmap_name(long /*int*/ style, int index) {
	lock.lock();
	try {
		return _gtk_rc_style_get_bg_pixmap_name(style, index);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_rc_style_get_color_flags(long /*int*/ style, int index);
public static final int gtk_rc_style_get_color_flags(long /*int*/ style, int index) {
	lock.lock();
	try {
		return _gtk_rc_style_get_color_flags(style, index);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_rc_style_set_bg(long /*int*/ style, int index, GdkColor color);
public static final void gtk_rc_style_set_bg(long /*int*/ style, int index, GdkColor color) {
	lock.lock();
	try {
		_gtk_rc_style_set_bg(style, index, color);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_rc_style_set_bg_pixmap_name(long /*int*/ style, int index, long /*int*/ name);
public static final void gtk_rc_style_set_bg_pixmap_name(long /*int*/ style, int index, long /*int*/ name) {
	lock.lock();
	try {
		_gtk_rc_style_set_bg_pixmap_name(style, index, name);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_rc_style_set_color_flags(long /*int*/ style, int index, int flag);
public static final void gtk_rc_style_set_color_flags(long /*int*/ style, int index, int flag) {
	lock.lock();
	try {
		_gtk_rc_style_set_color_flags(style, index, flag);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_scale_set_digits(long /*int*/ scale, int digits);
public static final void gtk_scale_set_digits(long /*int*/ scale, int digits) {
	lock.lock();
	try {
		_gtk_scale_set_digits(scale, digits);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_scale_set_draw_value(long /*int*/ scale, boolean draw_value);
public static final void gtk_scale_set_draw_value(long /*int*/ scale, boolean draw_value) {
	lock.lock();
	try {
		_gtk_scale_set_draw_value(scale, draw_value);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_scrolled_window_get_hadjustment(long /*int*/ scrolled_window);
public static final long /*int*/ gtk_scrolled_window_get_hadjustment(long /*int*/ scrolled_window) {
	lock.lock();
	try {
		return _gtk_scrolled_window_get_hadjustment(scrolled_window);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_scrolled_window_get_policy(long /*int*/ scrolled_window, int[] hscrollbar_policy, int[] vscrollbar_policy);
public static final void gtk_scrolled_window_get_policy(long /*int*/ scrolled_window, int[] hscrollbar_policy, int[] vscrollbar_policy) {
	lock.lock();
	try {
		_gtk_scrolled_window_get_policy(scrolled_window, hscrollbar_policy, vscrollbar_policy);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_scrolled_window_get_shadow_type(long /*int*/ scrolled_window);
public static final int gtk_scrolled_window_get_shadow_type(long /*int*/ scrolled_window) {
	lock.lock();
	try {
		return _gtk_scrolled_window_get_shadow_type(scrolled_window);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_scrolled_window_get_vadjustment(long /*int*/ scrolled_window);
public static final long /*int*/ gtk_scrolled_window_get_vadjustment(long /*int*/ scrolled_window) {
	lock.lock();
	try {
		return _gtk_scrolled_window_get_vadjustment(scrolled_window);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_scrolled_window_new(long /*int*/ hadjustment, long /*int*/ vadjustment);
public static final long /*int*/ gtk_scrolled_window_new(long /*int*/ hadjustment, long /*int*/ vadjustment) {
	lock.lock();
	try {
		return _gtk_scrolled_window_new(hadjustment, vadjustment);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_scrolled_window_set_placement(long /*int*/ scrolled_window, int placement);
public static final void gtk_scrolled_window_set_placement(long /*int*/ scrolled_window, int placement) {
	lock.lock();
	try {
		_gtk_scrolled_window_set_placement(scrolled_window, placement);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_scrolled_window_set_policy(long /*int*/ scrolled_window, int hscrollbar_policy, int vscrollbar_policy);
public static final void gtk_scrolled_window_set_policy(long /*int*/ scrolled_window, int hscrollbar_policy, int vscrollbar_policy) {
	lock.lock();
	try {
		_gtk_scrolled_window_set_policy(scrolled_window, hscrollbar_policy, vscrollbar_policy);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_scrolled_window_set_shadow_type(long /*int*/ scrolled_window, int type);
public static final void gtk_scrolled_window_set_shadow_type(long /*int*/ scrolled_window, int type) {
	lock.lock();
	try {
		_gtk_scrolled_window_set_shadow_type(scrolled_window, type);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_settings_get_default();
public static final long /*int*/ gtk_settings_get_default() {
	lock.lock();
	try {
		return _gtk_settings_get_default();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_selection_data_free(long /*int*/ selection_data);
public static final void gtk_selection_data_free(long /*int*/ selection_data) {
	lock.lock();
	try {
		_gtk_selection_data_free(selection_data);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_selection_data_set(long /*int*/ selection_data, long /*int*/ type, int format, long /*int*/ data, int length);
public static final void gtk_selection_data_set(long /*int*/ selection_data, long /*int*/ type, int format, long /*int*/ data, int length) {
	lock.lock();
	try {
		_gtk_selection_data_set(selection_data, type, format, data, length);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_separator_menu_item_new();
public static final long /*int*/ gtk_separator_menu_item_new() {
	lock.lock();
	try {
		return _gtk_separator_menu_item_new();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_set_locale();
public static final long /*int*/ gtk_set_locale() {
	lock.lock();
	try {
		return _gtk_set_locale();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_socket_get_id(long /*int*/ socket);
public static final long /*int*/ gtk_socket_get_id(long /*int*/ socket) {
	lock.lock();
	try {
		return _gtk_socket_get_id(socket);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_socket_new();
public static final long /*int*/ gtk_socket_new() {
	lock.lock();
	try {
		return _gtk_socket_new();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_spin_button_new(long /*int*/ adjustment, double climb_rate, int digits);
public static final long /*int*/ gtk_spin_button_new(long /*int*/ adjustment, double climb_rate, int digits) {
	lock.lock();
	try {
		return _gtk_spin_button_new(adjustment, climb_rate, digits);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_spin_button_get_adjustment(long /*int*/ spin_button);
public static final long /*int*/ gtk_spin_button_get_adjustment(long /*int*/ spin_button) {
	lock.lock();
	try {
		return _gtk_spin_button_get_adjustment(spin_button);
	} finally {
		lock.unlock();
	}
}

public static final native int _gtk_spin_button_get_digits(long /*int*/ spin_button);
public static final int gtk_spin_button_get_digits(long /*int*/ spin_button) {
	lock.lock();
	try {
		return _gtk_spin_button_get_digits(spin_button);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_spin_button_set_digits(long /*int*/ spin_button, int digits);
public static final void gtk_spin_button_set_digits(long /*int*/ spin_button, int digits) {
	lock.lock();
	try {
		_gtk_spin_button_set_digits(spin_button, digits);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_spin_button_set_increments(long /*int*/ spin_button, double step, double page);
public static final void gtk_spin_button_set_increments(long /*int*/ spin_button, double step, double page) {
	lock.lock();
	try {
		_gtk_spin_button_set_increments(spin_button, step, page);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_spin_button_set_range(long /*int*/ spin_button, double max, double min);
public static final void gtk_spin_button_set_range(long /*int*/ spin_button, double max, double min) {
	lock.lock();
	try {
		_gtk_spin_button_set_range(spin_button, max, min);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_spin_button_set_value(long /*int*/ spin_button, double value);
public static final void gtk_spin_button_set_value(long /*int*/ spin_button, double value) {
	lock.lock();
	try {
		_gtk_spin_button_set_value(spin_button, value);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_spin_button_set_wrap(long /*int*/ spin_button, boolean wrap);
public static final void gtk_spin_button_set_wrap(long /*int*/ spin_button, boolean wrap) {
	lock.lock();
	try {
		_gtk_spin_button_set_wrap(spin_button, wrap);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_style_get_base(long /*int*/ style, int index, GdkColor color);
public static final void gtk_style_get_base(long /*int*/ style, int index, GdkColor color) {
	lock.lock();
	try {
		_gtk_style_get_base(style, index, color);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_style_get_black(long /*int*/ style, GdkColor color);
public static final void gtk_style_get_black(long /*int*/ style, GdkColor color) {
	lock.lock();
	try {
		_gtk_style_get_black(style, color);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_style_get_bg(long /*int*/ style, int index, GdkColor color);
public static final void gtk_style_get_bg(long /*int*/ style, int index, GdkColor color) {
	lock.lock();
	try {
		_gtk_style_get_bg(style, index, color);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_style_get_dark(long /*int*/ style, int index, GdkColor color);
public static final void gtk_style_get_dark(long /*int*/ style, int index, GdkColor color) {
	lock.lock();
	try {
		_gtk_style_get_dark(style, index, color);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_style_get_fg(long /*int*/ style, int index, GdkColor color);
public static final void gtk_style_get_fg(long /*int*/ style, int index, GdkColor color) {
	lock.lock();
	try {
		_gtk_style_get_fg(style, index, color);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_style_get_font_desc(long /*int*/ style);
public static final long /*int*/ gtk_style_get_font_desc(long /*int*/ style) {
	lock.lock();
	try {
		return _gtk_style_get_font_desc(style);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_style_get_light(long /*int*/ style, int index, GdkColor color);
public static final void gtk_style_get_light(long /*int*/ style, int index, GdkColor color) {
	lock.lock();
	try {
		_gtk_style_get_light(style, index, color);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_style_get_text(long /*int*/ style, int index, GdkColor color);
public static final void gtk_style_get_text(long /*int*/ style, int index, GdkColor color) {
	lock.lock();
	try {
		_gtk_style_get_text(style, index, color);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_style_get_xthickness(long /*int*/ style);
public static final int gtk_style_get_xthickness(long /*int*/ style) {
	lock.lock();
	try {
		return _gtk_style_get_xthickness(style);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_style_get_ythickness(long /*int*/ style);
public static final int gtk_style_get_ythickness(long /*int*/ style) {
	lock.lock();
	try {
		return _gtk_style_get_ythickness(style);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_target_list_new(long /*int*/ targets, int ntargets);
public static final long /*int*/ gtk_target_list_new(long /*int*/ targets, int ntargets) {
	lock.lock();
	try {
		return _gtk_target_list_new(targets, ntargets);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_target_list_unref(long /*int*/ list);
public static final void gtk_target_list_unref(long /*int*/ list) {
	lock.lock();
	try {
		_gtk_target_list_unref(list);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_buffer_copy_clipboard(long /*int*/ buffer, long /*int*/ clipboard);
public static final void gtk_text_buffer_copy_clipboard(long /*int*/ buffer, long /*int*/ clipboard) {
	lock.lock();
	try {
		_gtk_text_buffer_copy_clipboard(buffer, clipboard);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_buffer_cut_clipboard(long /*int*/ buffer, long /*int*/ clipboard, boolean default_editable);
public static final void gtk_text_buffer_cut_clipboard(long /*int*/ buffer, long /*int*/ clipboard, boolean default_editable) {
	lock.lock();
	try {
		_gtk_text_buffer_cut_clipboard(buffer, clipboard, default_editable);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_buffer_delete(long /*int*/ buffer, byte[] start, byte[] end);
public static final void gtk_text_buffer_delete(long /*int*/ buffer, byte[] start, byte[] end) {
	lock.lock();
	try {
		_gtk_text_buffer_delete(buffer, start, end);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_buffer_get_bounds(long /*int*/ buffer, byte[] start, byte[] end);
public static final void gtk_text_buffer_get_bounds(long /*int*/ buffer, byte[] start, byte[] end) {
	lock.lock();
	try {
		_gtk_text_buffer_get_bounds(buffer, start, end);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_text_buffer_get_char_count(long /*int*/ buffer);
public static final int gtk_text_buffer_get_char_count(long /*int*/ buffer) {
	lock.lock();
	try {
		return _gtk_text_buffer_get_char_count(buffer);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_buffer_get_end_iter(long /*int*/ buffer, byte[] iter);
public static final void gtk_text_buffer_get_end_iter(long /*int*/ buffer, byte[] iter) {
	lock.lock();
	try {
		_gtk_text_buffer_get_end_iter(buffer, iter);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_text_buffer_get_insert(long /*int*/ buffer);
public static final long /*int*/ gtk_text_buffer_get_insert(long /*int*/ buffer) {
	lock.lock();
	try {
		return _gtk_text_buffer_get_insert(buffer);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_buffer_get_iter_at_line(long /*int*/ buffer, byte[] iter, int line_number);
public static final void gtk_text_buffer_get_iter_at_line(long /*int*/ buffer, byte[] iter, int line_number) {
	lock.lock();
	try {
		_gtk_text_buffer_get_iter_at_line(buffer, iter, line_number);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_buffer_get_iter_at_mark(long /*int*/ buffer, byte[] iter, long /*int*/ mark);
public static final void gtk_text_buffer_get_iter_at_mark(long /*int*/ buffer, byte[] iter, long /*int*/ mark) {
	lock.lock();
	try {
		_gtk_text_buffer_get_iter_at_mark(buffer, iter, mark);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_buffer_get_iter_at_offset(long /*int*/ buffer, byte[] iter, int char_offset);
public static final void gtk_text_buffer_get_iter_at_offset(long /*int*/ buffer, byte[] iter, int char_offset) {
	lock.lock();
	try {
		_gtk_text_buffer_get_iter_at_offset(buffer, iter, char_offset);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_text_buffer_get_line_count(long /*int*/ buffer);
public static final int gtk_text_buffer_get_line_count(long /*int*/ buffer) {
	lock.lock();
	try {
		return _gtk_text_buffer_get_line_count(buffer);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_text_buffer_get_selection_bound(long /*int*/ buffer);
public static final long /*int*/ gtk_text_buffer_get_selection_bound(long /*int*/ buffer) {
	lock.lock();
	try {
		return _gtk_text_buffer_get_selection_bound(buffer);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_text_buffer_get_selection_bounds(long /*int*/ buffer, byte[] start, byte[] end);
public static final boolean gtk_text_buffer_get_selection_bounds(long /*int*/ buffer, byte[] start, byte[] end) {
	lock.lock();
	try {
		return _gtk_text_buffer_get_selection_bounds(buffer, start, end);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_text_buffer_get_text(long /*int*/ buffer, byte[] start, byte[] end, boolean include_hidden_chars);
public static final long /*int*/ gtk_text_buffer_get_text(long /*int*/ buffer, byte[] start, byte[] end, boolean include_hidden_chars) {
	lock.lock();
	try {
		return _gtk_text_buffer_get_text(buffer, start, end, include_hidden_chars);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_buffer_insert(long /*int*/ buffer, byte[] iter, byte[] text, int len);
public static final void gtk_text_buffer_insert(long /*int*/ buffer, byte[] iter, byte[] text, int len) {
	lock.lock();
	try {
		_gtk_text_buffer_insert(buffer, iter, text, len);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_buffer_insert(long /*int*/ buffer, long /*int*/ iter, byte[] text, int len);
public static final void gtk_text_buffer_insert(long /*int*/ buffer, long /*int*/ iter, byte[] text, int len) {
	lock.lock();
	try {
		_gtk_text_buffer_insert(buffer, iter, text, len);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_buffer_move_mark(long /*int*/ buffer, long /*int*/ mark, byte[] where);
public static final void gtk_text_buffer_move_mark(long /*int*/ buffer, long /*int*/ mark, byte[] where) {
	lock.lock();
	try {
		_gtk_text_buffer_move_mark(buffer, mark, where);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_buffer_paste_clipboard(long /*int*/ buffer, long /*int*/ clipboard, byte[] override_location, boolean default_editable);
public static final void gtk_text_buffer_paste_clipboard(long /*int*/ buffer, long /*int*/ clipboard, byte[] override_location, boolean default_editable) {
	lock.lock();
	try {
		_gtk_text_buffer_paste_clipboard(buffer, clipboard, override_location, default_editable);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_buffer_place_cursor(long /*int*/ buffer, byte[] where);
public static final void gtk_text_buffer_place_cursor(long /*int*/ buffer, byte[] where) {
	lock.lock();
	try {
		_gtk_text_buffer_place_cursor(buffer, where);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_buffer_set_text(long /*int*/ buffer, byte[] text, int len);
public static final void gtk_text_buffer_set_text(long /*int*/ buffer, byte[] text, int len) {
	lock.lock();
	try {
		_gtk_text_buffer_set_text(buffer, text, len);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_text_iter_get_line(byte[] iter);
public static final int gtk_text_iter_get_line(byte[] iter) {
	lock.lock();
	try {
		return _gtk_text_iter_get_line(iter);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_text_iter_get_offset(byte[] iter);
public static final int gtk_text_iter_get_offset(byte[] iter) {
	lock.lock();
	try {
		return _gtk_text_iter_get_offset(iter);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_view_buffer_to_window_coords(long /*int*/ text_view, int win, int buffer_x, int buffer_y, int[] window_x, int[] window_y);
public static final void gtk_text_view_buffer_to_window_coords(long /*int*/ text_view, int win, int buffer_x, int buffer_y, int[] window_x, int[] window_y) {
	lock.lock();
	try {
		_gtk_text_view_buffer_to_window_coords(text_view, win, buffer_x, buffer_y, window_x, window_y);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_text_view_get_buffer(long /*int*/ text_view);
public static final long /*int*/ gtk_text_view_get_buffer(long /*int*/ text_view) {
	lock.lock();
	try {
		return _gtk_text_view_get_buffer(text_view);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_text_view_get_editable(long /*int*/ text_view);
public static final boolean gtk_text_view_get_editable(long /*int*/ text_view) {
	lock.lock();
	try {
		return _gtk_text_view_get_editable(text_view);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_view_get_iter_at_location(long /*int*/ text_view, byte[] iter, int x, int y);
public static final void gtk_text_view_get_iter_at_location(long /*int*/ text_view, byte[] iter, int x, int y) {
	lock.lock();
	try {
		_gtk_text_view_get_iter_at_location(text_view, iter, x, y);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_view_get_iter_location(long /*int*/ text_view, byte[] iter, GdkRectangle location);
public static final void gtk_text_view_get_iter_location(long /*int*/ text_view, byte[] iter, GdkRectangle location) {
	lock.lock();
	try {
		_gtk_text_view_get_iter_location(text_view, iter, location);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_view_get_line_at_y(long /*int*/ text_view, byte[] target_iter, int y, int[] line_top);
public static final void gtk_text_view_get_line_at_y(long /*int*/ text_view, byte[] target_iter, int y, int[] line_top) {
	lock.lock();
	try {
		_gtk_text_view_get_line_at_y(text_view, target_iter, y, line_top);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_view_get_visible_rect(long /*int*/ text_view, GdkRectangle visible_rect);
public static final void gtk_text_view_get_visible_rect(long /*int*/ text_view, GdkRectangle visible_rect) {
	lock.lock();
	try {
		_gtk_text_view_get_visible_rect(text_view, visible_rect);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_text_view_get_window(long /*int*/ text_view, int win);
public static final long /*int*/ gtk_text_view_get_window(long /*int*/ text_view, int win) {
	lock.lock();
	try {
		return _gtk_text_view_get_window(text_view, win);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_text_view_new();
public static final long /*int*/ gtk_text_view_new() {
	lock.lock();
	try {
		return _gtk_text_view_new();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_view_scroll_mark_onscreen(long /*int*/ text_view, long /*int*/ mark);
public static final void gtk_text_view_scroll_mark_onscreen(long /*int*/ text_view, long /*int*/ mark) {
	lock.lock();
	try {
		_gtk_text_view_scroll_mark_onscreen(text_view, mark);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_text_view_scroll_to_iter(long /*int*/ text_view, byte[] iter, double within_margin, boolean use_align, double xalign, double yalign);
public static final boolean gtk_text_view_scroll_to_iter(long /*int*/ text_view, byte[] iter, double within_margin, boolean use_align, double xalign, double yalign) {
	lock.lock();
	try {
		return _gtk_text_view_scroll_to_iter(text_view, iter, within_margin, use_align, xalign, yalign);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_view_set_editable(long /*int*/ text_view, boolean setting);
public static final void gtk_text_view_set_editable(long /*int*/ text_view, boolean setting) {
	lock.lock();
	try {
		_gtk_text_view_set_editable(text_view, setting);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_view_set_justification(long /*int*/ text_view, int justification);
public static final void gtk_text_view_set_justification(long /*int*/ text_view, int justification) {
	lock.lock();
	try {
		_gtk_text_view_set_justification(text_view, justification);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_view_set_tabs(long /*int*/ text_view, long /*int*/ tabs);
public static final void gtk_text_view_set_tabs(long /*int*/ text_view, long /*int*/ tabs) {
	lock.lock();
	try {
		_gtk_text_view_set_tabs(text_view, tabs);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_view_set_wrap_mode(long /*int*/ text_view, int wrap_mode);
public static final void gtk_text_view_set_wrap_mode(long /*int*/ text_view, int wrap_mode) {
	lock.lock();
	try {
		_gtk_text_view_set_wrap_mode(text_view, wrap_mode);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_text_view_window_to_buffer_coords(long /*int*/ text_view, int win, int window_x, int window_y, int[] buffer_x, int[] buffer_y);
public static final void gtk_text_view_window_to_buffer_coords(long /*int*/ text_view,  int win, int window_x, int window_y, int[] buffer_x, int[] buffer_y) {
	lock.lock();
	try {
		_gtk_text_view_window_to_buffer_coords(text_view, win, window_x, window_y, buffer_x, buffer_y);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_timeout_add(int interval, long /*int*/ function, long /*int*/ data);
public static final int gtk_timeout_add(int interval, long /*int*/ function, long /*int*/ data) {
	lock.lock();
	try {
		return _gtk_timeout_add(interval, function, data);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_timeout_remove(int timeout_handler_id);
public static final void gtk_timeout_remove(int timeout_handler_id) {
	lock.lock();
	try {
		_gtk_timeout_remove(timeout_handler_id);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_toggle_button_get_active(long /*int*/ toggle_button);
public static final boolean gtk_toggle_button_get_active(long /*int*/ toggle_button) {
	lock.lock();
	try {
		return _gtk_toggle_button_get_active(toggle_button);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_toggle_button_new();
public static final long /*int*/ gtk_toggle_button_new() {
	lock.lock();
	try {
		return _gtk_toggle_button_new();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_toggle_button_set_active(long /*int*/ toggle_button, boolean is_active);
public static final void gtk_toggle_button_set_active(long /*int*/ toggle_button, boolean is_active) {
	lock.lock();
	try {
		_gtk_toggle_button_set_active(toggle_button, is_active);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_toggle_button_set_mode(long /*int*/ toggle_button, boolean draw_indicator);
public static final void gtk_toggle_button_set_mode(long /*int*/ toggle_button, boolean draw_indicator) {
	lock.lock();
	try {
		_gtk_toggle_button_set_mode(toggle_button, draw_indicator);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_toolbar_insert_widget(long /*int*/ toolbar, long /*int*/ widget, byte[] tooltip_text, byte[] tooltip_private_text, int position);
public static final void gtk_toolbar_insert_widget(long /*int*/ toolbar, long /*int*/ widget, byte[] tooltip_text, byte[] tooltip_private_text, int position) {
	lock.lock();
	try {
		_gtk_toolbar_insert_widget(toolbar, widget, tooltip_text, tooltip_private_text, position);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_toolbar_new();
public static final long /*int*/ gtk_toolbar_new() {
	lock.lock();
	try {
		return _gtk_toolbar_new();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_toolbar_set_orientation(long /*int*/ toolbar, int orientation);
public static final void gtk_toolbar_set_orientation(long /*int*/ toolbar, int orientation) {
	lock.lock();
	try {
		_gtk_toolbar_set_orientation(toolbar, orientation);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tooltips_disable(long /*int*/ tooltips);
public static final void gtk_tooltips_disable(long /*int*/ tooltips) {
	lock.lock();
	try {
		_gtk_tooltips_disable(tooltips);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tooltips_enable(long /*int*/ tooltips);
public static final void gtk_tooltips_enable(long /*int*/ tooltips) {
	lock.lock();
	try {
		_gtk_tooltips_enable(tooltips);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_tooltips_new();
public static final long /*int*/ gtk_tooltips_new() {
	lock.lock();
	try {
		return _gtk_tooltips_new();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tooltips_set_tip(long /*int*/ tooltips, long /*int*/ widget, byte[] tip_text, byte[] tip_private);
public static final void gtk_tooltips_set_tip(long /*int*/ tooltips, long /*int*/ widget, byte[] tip_text, byte[] tip_private) {
	lock.lock();
	try {
		_gtk_tooltips_set_tip(tooltips, widget, tip_text, tip_private);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_model_get(long /*int*/ tree_model, long /*int*/ iter, int column, int[] value, long /*int*/ terminator);
public static final void gtk_tree_model_get(long /*int*/ tree_model, long /*int*/ iter, int column, int[] value, long /*int*/ terminator) {
	lock.lock();
	try {
		_gtk_tree_model_get(tree_model, iter, column, value, terminator);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_model_get(long /*int*/ tree_model, long /*int*/ iter, int column, long[] value, long /*int*/ terminator);
public static final void gtk_tree_model_get(long /*int*/ tree_model, long /*int*/ iter, int column, long[] value, long /*int*/ terminator) {
	lock.lock();
	try {
		_gtk_tree_model_get(tree_model, iter, column, value, terminator);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_tree_model_get_iter(long /*int*/ tree_model, long /*int*/ iter, long /*int*/ path);
public static final boolean gtk_tree_model_get_iter(long /*int*/ tree_model, long /*int*/ iter, long /*int*/ path) {
	lock.lock();
	try {
		return _gtk_tree_model_get_iter(tree_model, iter, path);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_tree_model_get_iter_first(long /*int*/ tree_model, long /*int*/ iter);
public static final boolean gtk_tree_model_get_iter_first(long /*int*/ tree_model, long /*int*/ iter) {
	lock.lock();
	try {
		return _gtk_tree_model_get_iter_first(tree_model, iter);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_tree_model_get_n_columns(long /*int*/ tree_model);
public static final int gtk_tree_model_get_n_columns(long /*int*/ tree_model) {
	lock.lock();
	try {
		return _gtk_tree_model_get_n_columns(tree_model);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_tree_model_get_path(long /*int*/ tree_model, long /*int*/ iter);
public static final long /*int*/ gtk_tree_model_get_path(long /*int*/ tree_model, long /*int*/ iter) {
	lock.lock();
	try {
		return _gtk_tree_model_get_path(tree_model, iter);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_tree_model_get_type();
public static final long /*int*/ gtk_tree_model_get_type() {
	lock.lock();
	try {
		return _gtk_tree_model_get_type();
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_tree_model_iter_children(long /*int*/ model, long /*int*/ iter, long /*int*/ parent);
public static final boolean gtk_tree_model_iter_children(long /*int*/ model, long /*int*/ iter, long /*int*/ parent) {
	lock.lock();
	try {
		return _gtk_tree_model_iter_children(model, iter, parent);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_tree_model_iter_n_children(long /*int*/ model, long /*int*/ iter);
public static final int gtk_tree_model_iter_n_children(long /*int*/ model, long /*int*/ iter) {
	lock.lock();
	try {
		return _gtk_tree_model_iter_n_children(model, iter);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_tree_model_iter_next(long /*int*/ model, long /*int*/ iter);
public static final boolean gtk_tree_model_iter_next(long /*int*/ model, long /*int*/ iter) {
	lock.lock();
	try {
		return _gtk_tree_model_iter_next(model, iter);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_tree_model_iter_nth_child(long /*int*/ tree_model, long /*int*/ iter, long /*int*/ parent, int n);
public static final boolean gtk_tree_model_iter_nth_child(long /*int*/ tree_model, long /*int*/ iter, long /*int*/ parent, int n) {
	lock.lock();
	try {
		return _gtk_tree_model_iter_nth_child(tree_model, iter, parent, n);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_path_append_index(long /*int*/ path, int index);
public static final void gtk_tree_path_append_index(long /*int*/ path, int index) {
	lock.lock();
	try {
		_gtk_tree_path_append_index(path, index);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_tree_path_compare(long /*int*/ a, long /*int*/ b);
public static final long /*int*/ gtk_tree_path_compare(long /*int*/ a, long /*int*/ b) {
	lock.lock();
	try {
		 return _gtk_tree_path_compare(a, b);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_path_down(long /*int*/ path);
public static final void gtk_tree_path_down(long /*int*/ path) {
	lock.lock();
	try {
		 _gtk_tree_path_down(path);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_path_free(long /*int*/ path);
public static final void gtk_tree_path_free(long /*int*/ path) {
	lock.lock();
	try {
		_gtk_tree_path_free(path);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_tree_path_get_depth(long /*int*/ path);
public static final int gtk_tree_path_get_depth(long /*int*/ path) {
	lock.lock();
	try {
		return _gtk_tree_path_get_depth(path);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_tree_path_get_indices(long /*int*/ path);
public static final long /*int*/ gtk_tree_path_get_indices(long /*int*/ path) {
	lock.lock();
	try {
		return _gtk_tree_path_get_indices(path);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_tree_path_new();
public static final long /*int*/ gtk_tree_path_new() {
	lock.lock();
	try {
		return _gtk_tree_path_new();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_tree_path_new_first();
public static final long /*int*/ gtk_tree_path_new_first() {
	lock.lock();
	try {
		return _gtk_tree_path_new_first();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_tree_path_new_from_string(byte[] path);
public static final long /*int*/ gtk_tree_path_new_from_string(byte[] path) {
	lock.lock();
	try {
		return _gtk_tree_path_new_from_string(path);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_tree_path_new_from_string(long /*int*/ path);
public static final long /*int*/ gtk_tree_path_new_from_string(long /*int*/ path) {
	lock.lock();
	try {
		return _gtk_tree_path_new_from_string(path);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_path_next(long /*int*/ path);
public static final void gtk_tree_path_next(long /*int*/ path) {
	lock.lock();
	try {
		_gtk_tree_path_next(path);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_tree_path_prev(long /*int*/ path);
public static final boolean gtk_tree_path_prev(long /*int*/ path) {
	lock.lock();
	try {
		return _gtk_tree_path_prev(path);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_tree_path_up(long /*int*/ path);
public static final boolean gtk_tree_path_up(long /*int*/ path) {
	lock.lock();
	try {
		return _gtk_tree_path_up(path);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_tree_selection_get_selected(long /*int*/ selection, long /*int*/[] model, long /*int*/ iter);
public static final boolean gtk_tree_selection_get_selected(long /*int*/ selection, long /*int*/[] model, long /*int*/ iter) {
	lock.lock();
	try {
		return _gtk_tree_selection_get_selected(selection, model, iter);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_tree_selection_get_selected_rows(long /*int*/ selection, long /*int*/[] model);
public static final long /*int*/ gtk_tree_selection_get_selected_rows(long /*int*/ selection, long /*int*/[] model) {
	lock.lock();
	try {
		return _gtk_tree_selection_get_selected_rows(selection, model);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_tree_selection_path_is_selected(long /*int*/ selection, long /*int*/ path);
public static final boolean gtk_tree_selection_path_is_selected(long /*int*/ selection, long /*int*/ path) {
	lock.lock();
	try {
		return _gtk_tree_selection_path_is_selected(selection, path);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_selection_select_all(long /*int*/ selection);
public static final void gtk_tree_selection_select_all(long /*int*/ selection) {
	lock.lock();
	try {
		_gtk_tree_selection_select_all(selection);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_selection_select_iter(long /*int*/ selection, long /*int*/ iter);
public static final void gtk_tree_selection_select_iter(long /*int*/ selection, long /*int*/ iter) {
	lock.lock();
	try {
		_gtk_tree_selection_select_iter(selection, iter);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_selection_selected_foreach(long /*int*/ selection, long /*int*/ func, long /*int*/ data);
public static final void gtk_tree_selection_selected_foreach(long /*int*/ selection, long /*int*/ func, long /*int*/ data) {
	lock.lock();
	try {
		_gtk_tree_selection_selected_foreach(selection, func, data);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_selection_set_mode(long /*int*/ selection, int mode);
public static final void gtk_tree_selection_set_mode(long /*int*/ selection, int mode) {
	lock.lock();
	try {
		_gtk_tree_selection_set_mode(selection, mode);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_selection_unselect_all(long /*int*/ selection);
public static final void gtk_tree_selection_unselect_all(long /*int*/ selection) {
	lock.lock();
	try {
		_gtk_tree_selection_unselect_all(selection);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_selection_unselect_iter(long /*int*/ selection, long /*int*/ iter);
public static final void gtk_tree_selection_unselect_iter(long /*int*/ selection, long /*int*/ iter) {
	lock.lock();
	try {
		_gtk_tree_selection_unselect_iter(selection, iter);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_store_append(long /*int*/ store, long /*int*/ iter, long /*int*/ parent);
public static final void gtk_tree_store_append(long /*int*/ store, long /*int*/ iter, long /*int*/ parent) {
	lock.lock();
	try {
		_gtk_tree_store_append(store, iter, parent);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_store_clear(long /*int*/ store);
public static final void gtk_tree_store_clear(long /*int*/ store) {
	lock.lock();
	try {
		_gtk_tree_store_clear(store);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_store_insert(long /*int*/ store, long /*int*/ iter, long /*int*/ parent, int position);
public static final void gtk_tree_store_insert(long /*int*/ store, long /*int*/ iter, long /*int*/ parent, int position) {
	lock.lock();
	try {
		_gtk_tree_store_insert(store, iter, parent, position);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_tree_store_newv(int numColumns, long /*int*/[] types);
public static final long /*int*/ gtk_tree_store_newv(int numColumns, long /*int*/[] types) {
	lock.lock();
	try {
		return _gtk_tree_store_newv(numColumns, types);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_store_remove(long /*int*/ store, long /*int*/ iter);
public static final void gtk_tree_store_remove(long /*int*/ store, long /*int*/ iter) {
	lock.lock();
	try {
		_gtk_tree_store_remove(store, iter);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_store_set(long /*int*/ store, long /*int*/ iter, int column, byte[] value, long /*int*/ terminator);
public static final void gtk_tree_store_set(long /*int*/ store, long /*int*/ iter, int column, byte[] value, long /*int*/ terminator) {
	lock.lock();
	try {
		_gtk_tree_store_set(store, iter, column, value, terminator);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_store_set(long /*int*/ store, long /*int*/ iter, int column, int value, long /*int*/ terminator);
public static final void gtk_tree_store_set(long /*int*/ store, long /*int*/ iter, int column, int value, long /*int*/ terminator) {
	lock.lock();
	try {
		_gtk_tree_store_set(store, iter, column, value, terminator);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_store_set(long /*int*/ store, long /*int*/ iter, int column, long value, long /*int*/ terminator);
public static final void gtk_tree_store_set(long /*int*/ store, long /*int*/ iter, int column, long value, long /*int*/ terminator) {
	lock.lock();
	try {
		_gtk_tree_store_set(store, iter, column, value, terminator);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_store_set(long /*int*/ store, long /*int*/ iter, int column, GdkColor value, long /*int*/ terminator);
public static final void gtk_tree_store_set(long /*int*/ store, long /*int*/ iter, int column, GdkColor value, long /*int*/ terminator) {
	lock.lock();
	try {
		_gtk_tree_store_set(store, iter, column, value, terminator);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_store_set(long /*int*/ store, long /*int*/ iter, int column, boolean value, long /*int*/ terminator);
public static final void gtk_tree_store_set(long /*int*/ store, long /*int*/ iter, int column, boolean value, long /*int*/ terminator) {
	lock.lock();
	try {
		_gtk_tree_store_set(store, iter, column, value, terminator);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_tree_view_collapse_row(long /*int*/ view, long /*int*/ path);
public static final boolean gtk_tree_view_collapse_row(long /*int*/ view, long /*int*/ path) {
	lock.lock();
	try {
		return _gtk_tree_view_collapse_row(view, path);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_column_add_attribute(long /*int*/ treeColumn, long /*int*/ cellRenderer, byte[] attribute, int column);
public static final void gtk_tree_view_column_add_attribute(long /*int*/ treeColumn, long /*int*/ cellRenderer, byte[] attribute, int column) {
	lock.lock();
	try {
		_gtk_tree_view_column_add_attribute(treeColumn, cellRenderer, attribute, column);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_tree_view_column_cell_get_position(long /*int*/ tree_column, long /*int*/ cell_renderer, int[] start_pos, int[] width);
public static final boolean gtk_tree_view_column_cell_get_position(long /*int*/ tree_column, long /*int*/ cell_renderer, int[] start_pos, int[] width) {
	lock.lock();
	try {
		return _gtk_tree_view_column_cell_get_position(tree_column, cell_renderer, start_pos, width);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_column_cell_get_size(long /*int*/ tree_column, GdkRectangle cell_area, int[] x_offset, int[] y_offset, int[] width, int[] height);
public static final void gtk_tree_view_column_cell_get_size(long /*int*/ tree_column, GdkRectangle cell_area, int[] x_offset, int[] y_offset, int[] width, int[] height) {
	lock.lock();
	try {
		_gtk_tree_view_column_cell_get_size(tree_column, cell_area, x_offset, y_offset, width, height);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_column_cell_set_cell_data(long /*int*/ tree_column, long /*int*/ tree_model, long /*int*/ iter, boolean is_expander, boolean is_expanded);
public static final void gtk_tree_view_column_cell_set_cell_data(long /*int*/ tree_column, long /*int*/ tree_model, long /*int*/ iter, boolean is_expander, boolean is_expanded) {
	lock.lock();
	try {
		_gtk_tree_view_column_cell_set_cell_data(tree_column, tree_model, iter, is_expander, is_expanded);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_column_clear(long /*int*/ tree_column);
public static final void gtk_tree_view_column_clear(long /*int*/ tree_column) {
	lock.lock();
	try {
		_gtk_tree_view_column_clear(tree_column);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_tree_view_column_get_reorderable(long /*int*/ column);
public static final boolean gtk_tree_view_column_get_reorderable(long /*int*/ column) {
	lock.lock();
	try {
		return _gtk_tree_view_column_get_reorderable(column);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_tree_view_column_get_cell_renderers(long /*int*/ tree_column);
public static final long /*int*/ gtk_tree_view_column_get_cell_renderers(long /*int*/ tree_column) {
	lock.lock();
	try {
		return _gtk_tree_view_column_get_cell_renderers(tree_column);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_tree_view_column_get_fixed_width(long /*int*/ column);
public static final int gtk_tree_view_column_get_fixed_width(long /*int*/ column) {
	lock.lock();
	try {
		return _gtk_tree_view_column_get_fixed_width(column);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_tree_view_column_get_resizable(long /*int*/ column);
public static final boolean gtk_tree_view_column_get_resizable(long /*int*/ column) {
	lock.lock();
	try {
		return _gtk_tree_view_column_get_resizable(column);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_tree_view_column_get_spacing(long /*int*/ tree_column);
public static final int gtk_tree_view_column_get_spacing(long /*int*/ tree_column) {
	lock.lock();
	try {
		return _gtk_tree_view_column_get_spacing(tree_column);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_tree_view_column_get_visible(long /*int*/ column);
public static final boolean gtk_tree_view_column_get_visible(long /*int*/ column) {
	lock.lock();
	try {
		return _gtk_tree_view_column_get_visible(column);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_tree_view_column_get_width(long /*int*/ column);
public static final int gtk_tree_view_column_get_width(long /*int*/ column) {
	lock.lock();
	try {
		return _gtk_tree_view_column_get_width(column);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_tree_view_column_new();
public static final long /*int*/ gtk_tree_view_column_new() {
	lock.lock();
	try {
		return _gtk_tree_view_column_new();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_column_pack_start(long /*int*/ tree_column, long /*int*/ cell_renderer, boolean expand);
public static final void gtk_tree_view_column_pack_start(long /*int*/ tree_column, long /*int*/ cell_renderer, boolean expand) {
	lock.lock();
	try {
		_gtk_tree_view_column_pack_start(tree_column, cell_renderer, expand);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_column_pack_end(long /*int*/ tree_column, long /*int*/ cell_renderer, boolean expand);
public static final void gtk_tree_view_column_pack_end(long /*int*/ tree_column, long /*int*/ cell_renderer, boolean expand) {
	lock.lock();
	try {
		_gtk_tree_view_column_pack_end(tree_column, cell_renderer, expand);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_column_set_alignment(long /*int*/ tree_column, float xalign);
public static final void gtk_tree_view_column_set_alignment(long /*int*/ tree_column, float xalign) {
	lock.lock();
	try {
		_gtk_tree_view_column_set_alignment(tree_column, xalign);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_column_set_cell_data_func(long /*int*/ tree_column, long /*int*/ cell_renderer, long /*int*/ func, long /*int*/ func_data, long /*int*/ destroy);
public static final void gtk_tree_view_column_set_cell_data_func(long /*int*/ tree_column, long /*int*/ cell_renderer, long /*int*/ func, long /*int*/ func_data, long /*int*/ destroy) {
	lock.lock();
	try {
		_gtk_tree_view_column_set_cell_data_func(tree_column, cell_renderer, func, func_data, destroy);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_column_set_clickable(long /*int*/ column, boolean clickable);
public static final void gtk_tree_view_column_set_clickable(long /*int*/ column, boolean clickable) {
	lock.lock();
	try {
		_gtk_tree_view_column_set_clickable(column, clickable);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_column_set_fixed_width(long /*int*/ column, int fixed_width);
public static final void gtk_tree_view_column_set_fixed_width(long /*int*/ column, int fixed_width) {
	lock.lock();
	try {
		_gtk_tree_view_column_set_fixed_width(column, fixed_width);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_column_set_reorderable(long /*int*/ column, boolean reorderable);
public static final void gtk_tree_view_column_set_reorderable(long /*int*/ column, boolean reorderable) {
	lock.lock();
	try {
		_gtk_tree_view_column_set_reorderable(column, reorderable);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_column_set_resizable(long /*int*/ column, boolean resizable);
public static final void gtk_tree_view_column_set_resizable(long /*int*/ column, boolean resizable) {
	lock.lock();
	try {
		_gtk_tree_view_column_set_resizable(column, resizable);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_column_set_sizing(long /*int*/ column, int type);
public static final void gtk_tree_view_column_set_sizing(long /*int*/ column, int type) {
	lock.lock();
	try {
		_gtk_tree_view_column_set_sizing(column, type);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_column_set_title(long /*int*/ tree_column, byte[] title);
public static final void gtk_tree_view_column_set_title(long /*int*/ tree_column, byte[] title) {
	lock.lock();
	try {
		_gtk_tree_view_column_set_title(tree_column, title);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_column_set_visible (long /*int*/ tree_column, boolean visible);
public static final void gtk_tree_view_column_set_visible (long /*int*/ tree_column, boolean visible) {
	lock.lock();
	try {
		_gtk_tree_view_column_set_visible(tree_column, visible);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_column_set_widget(long /*int*/ tree_column, long /*int*/ widget);
public static final void gtk_tree_view_column_set_widget(long /*int*/ tree_column, long /*int*/ widget) {
	lock.lock();
	try {
		_gtk_tree_view_column_set_widget(tree_column, widget);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_set_drag_dest_row(long /*int*/ view, long /*int*/ path, int pos);
public static final void gtk_tree_view_set_drag_dest_row(long /*int*/ view, long /*int*/ path, int pos) {
	lock.lock();
	try {
		_gtk_tree_view_set_drag_dest_row(view, path, pos);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_tree_view_expand_row(long /*int*/ view, long /*int*/ path, boolean open_all);
public static final boolean gtk_tree_view_expand_row(long /*int*/ view, long /*int*/ path, boolean open_all) {
	lock.lock();
	try {
		return _gtk_tree_view_expand_row(view, path, open_all);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_tree_view_get_bin_window(long /*int*/ tree_view);
public static final long /*int*/ gtk_tree_view_get_bin_window(long /*int*/ tree_view) {
	lock.lock();
	try {
		return _gtk_tree_view_get_bin_window(tree_view);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_get_cell_area(long /*int*/ tree_view, long /*int*/ path, long /*int*/ column, GdkRectangle rect);
public static final void gtk_tree_view_get_cell_area(long /*int*/ tree_view, long /*int*/ path, long /*int*/ column, GdkRectangle rect) {
	lock.lock();
	try {
		_gtk_tree_view_get_cell_area(tree_view, path, column, rect);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/_gtk_tree_view_get_expander_column(long /*int*/ tree_view);
public static final long /*int*/gtk_tree_view_get_expander_column(long /*int*/ tree_view) {
	lock.lock();
	try {
		return _gtk_tree_view_get_expander_column(tree_view);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_tree_view_get_column(long /*int*/ tree_view, int n);
public static final long /*int*/ gtk_tree_view_get_column(long /*int*/ tree_view, int n) {
	lock.lock();
	try {
		return _gtk_tree_view_get_column(tree_view, n);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_tree_view_get_columns(long /*int*/ tree_view);
public static final long /*int*/ gtk_tree_view_get_columns(long /*int*/ tree_view) {
	lock.lock();
	try {
		return _gtk_tree_view_get_columns(tree_view);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_get_cursor(long /*int*/ tree_view, long /*int*/[] path, long /*int*/[] focus_column);
public static final void gtk_tree_view_get_cursor(long /*int*/ tree_view, long /*int*/[] path, long /*int*/[] focus_column) {
	lock.lock();
	try {
		_gtk_tree_view_get_cursor(tree_view, path, focus_column);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_tree_view_get_headers_visible(long /*int*/ tree_view);
public static final boolean gtk_tree_view_get_headers_visible(long /*int*/ tree_view) {
	lock.lock();
	try {
		return _gtk_tree_view_get_headers_visible(tree_view);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_tree_view_get_path_at_pos(long /*int*/ tree_view, int x, int y, long /*int*/[] path, long /*int*/[] column, int[] cell_x, int[] cell_y);
public static final boolean gtk_tree_view_get_path_at_pos(long /*int*/ tree_view, int x, int y, long /*int*/[] path, long /*int*/[] column, int[] cell_x, int[] cell_y) {
	lock.lock();
	try {
		return _gtk_tree_view_get_path_at_pos(tree_view, x, y, path, column, cell_x, cell_y);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_tree_view_get_rules_hint(long /*int*/ tree_view);
public static final boolean gtk_tree_view_get_rules_hint(long /*int*/ tree_view) {
	lock.lock();
	try {
		return _gtk_tree_view_get_rules_hint(tree_view);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_tree_view_get_selection(long /*int*/ tree_view);
public static final long /*int*/ gtk_tree_view_get_selection(long /*int*/ tree_view) {
	lock.lock();
	try {
		return _gtk_tree_view_get_selection(tree_view);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_get_visible_rect(long /*int*/ tree_view, GdkRectangle visible_rect);
public static final void gtk_tree_view_get_visible_rect(long /*int*/ tree_view, GdkRectangle visible_rect) {
	lock.lock();
	try {
		_gtk_tree_view_get_visible_rect(tree_view, visible_rect);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_tree_view_insert_column(long /*int*/ tree_view, long /*int*/ column, int position);
public static final int gtk_tree_view_insert_column(long /*int*/ tree_view, long /*int*/ column, int position) {
	lock.lock();
	try {
		return _gtk_tree_view_insert_column(tree_view, column, position);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_move_column_after(long /*int*/ tree_view, long /*int*/ column, long /*int*/ base_column);
public static final void gtk_tree_view_move_column_after(long /*int*/ tree_view, long /*int*/ column, long /*int*/base_column) {
	lock.lock();
	try {
		_gtk_tree_view_move_column_after(tree_view, column, base_column);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_tree_view_new_with_model(long /*int*/ model);
public static final long /*int*/ gtk_tree_view_new_with_model(long /*int*/ model) {
	lock.lock();
	try {
		return _gtk_tree_view_new_with_model(model);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_remove_column(long /*int*/ tree_view, long /*int*/ column);
public static final void gtk_tree_view_remove_column(long /*int*/ tree_view, long /*int*/ column) {
	lock.lock();
	try {
		_gtk_tree_view_remove_column(tree_view, column);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_tree_view_row_expanded(long /*int*/ view, long /*int*/ path);
public static final boolean gtk_tree_view_row_expanded(long /*int*/ view, long /*int*/ path) {
	lock.lock();
	try {
		return _gtk_tree_view_row_expanded(view, path);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_scroll_to_cell(long /*int*/ tree_view, long /*int*/ path, long /*int*/ column, boolean use_align, float row_aligh, float column_align);
public static final void gtk_tree_view_scroll_to_cell(long /*int*/ tree_view, long /*int*/ path, long /*int*/ column, boolean use_align, float row_aligh, float column_align) {
	lock.lock();
	try {
		_gtk_tree_view_scroll_to_cell(tree_view, path, column, use_align, row_aligh, column_align);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_scroll_to_point (long /*int*/ tree_view, int tree_x, int tree_y);
public static final void gtk_tree_view_scroll_to_point (long /*int*/ tree_view, int tree_x, int tree_y) {
	lock.lock();
	try {
		_gtk_tree_view_scroll_to_point(tree_view, tree_x, tree_y);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_set_cursor(long /*int*/ tree_view, long /*int*/ path, long /*int*/ focus_column, boolean start_editing);
public static final void gtk_tree_view_set_cursor(long /*int*/ tree_view, long /*int*/ path, long /*int*/ focus_column, boolean start_editing) {
	lock.lock();
	try {
		_gtk_tree_view_set_cursor(tree_view, path, focus_column, start_editing);
	} finally {
		lock.unlock();
	}
} 
public static final native void _gtk_tree_view_set_headers_visible(long /*int*/ tree_view, boolean visible);
public static final void gtk_tree_view_set_headers_visible(long /*int*/ tree_view, boolean visible) {
	lock.lock();
	try {
		_gtk_tree_view_set_headers_visible(tree_view, visible);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_set_model(long /*int*/ tree_view, long /*int*/ model);
public static final void gtk_tree_view_set_model(long /*int*/ tree_view, long /*int*/ model) {
	lock.lock();
	try {
		_gtk_tree_view_set_model(tree_view, model);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_set_rules_hint(long /*int*/ tree_view, boolean setting);
public static final void gtk_tree_view_set_rules_hint(long /*int*/ tree_view, boolean setting) {
	lock.lock();
	try {
		_gtk_tree_view_set_rules_hint(tree_view, setting);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_set_search_column(long /*int*/ tree_view, int column);
public static final void gtk_tree_view_set_search_column(long /*int*/ tree_view, int column) {
	lock.lock();
	try {
		_gtk_tree_view_set_search_column(tree_view, column);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_tree_to_widget_coords(long /*int*/ tree_view, int tx, int ty, int[] wx, int[] wy);
public static final void gtk_tree_view_tree_to_widget_coords(long /*int*/ tree_view, int tx, int ty, int[] wx, int[] wy) {
	lock.lock();
	try {
		_gtk_tree_view_tree_to_widget_coords(tree_view, tx, ty, wx, wy);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_unset_rows_drag_dest(long /*int*/ tree_view);
public static final void gtk_tree_view_unset_rows_drag_dest(long /*int*/ tree_view) {
	lock.lock();
	try {
		_gtk_tree_view_unset_rows_drag_dest(tree_view);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_tree_view_widget_to_tree_coords(long /*int*/ tree_view, int wx, int wy, int[] tx, int[] ty);
public static final void gtk_tree_view_widget_to_tree_coords(long /*int*/ tree_view, int wx, int wy, int[] tx, int[] ty) {
	lock.lock();
	try {
		_gtk_tree_view_widget_to_tree_coords(tree_view, wx, wy, tx, ty);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_vbox_new(boolean homogeneous, int spacing);
public static final long /*int*/ gtk_vbox_new(boolean homogeneous, int spacing) {
	lock.lock();
	try {
		return _gtk_vbox_new(homogeneous, spacing);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_vscale_new(long /*int*/ adjustment);
public static final long /*int*/ gtk_vscale_new(long /*int*/ adjustment) {
	lock.lock();
	try {
		return _gtk_vscale_new(adjustment);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_vscrollbar_new(long /*int*/ adjustment);
public static final long /*int*/ gtk_vscrollbar_new(long /*int*/ adjustment) {
	lock.lock();
	try {
		return _gtk_vscrollbar_new(adjustment);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_vseparator_new();
public static final long /*int*/ gtk_vseparator_new() {
	lock.lock();
	try {
		return _gtk_vseparator_new();
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_add_accelerator(long /*int*/ widget, byte[] accel_signal, long /*int*/ accel_group, int accel_key, int accel_mods, int accel_flags);
public static final void gtk_widget_add_accelerator(long /*int*/ widget, byte[] accel_signal, long /*int*/ accel_group, int accel_key, int accel_mods, int accel_flags) {
	lock.lock();
	try {
		_gtk_widget_add_accelerator(widget, accel_signal, accel_group, accel_key, accel_mods, accel_flags);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_add_events(long /*int*/ widget, int events);
public static final void gtk_widget_add_events(long /*int*/ widget, int events) {
	lock.lock();
	try {
		_gtk_widget_add_events(widget, events);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_widget_child_focus(long /*int*/ widget, int direction);
public static final boolean gtk_widget_child_focus(long /*int*/ widget, int direction) {
	lock.lock();
	try {
		return _gtk_widget_child_focus(widget, direction);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_widget_create_pango_layout(long /*int*/ widget, byte[] text);
public static final long /*int*/ gtk_widget_create_pango_layout(long /*int*/ widget, byte[] text) {
	lock.lock();
	try {
		return _gtk_widget_create_pango_layout(widget, text);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_widget_create_pango_layout(long /*int*/ widget, long /*int*/ text);
public static final long /*int*/ gtk_widget_create_pango_layout(long /*int*/ widget, long /*int*/ text) {
	lock.lock();
	try {
		return _gtk_widget_create_pango_layout(widget, text);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_destroy(long /*int*/ widget);
public static final void gtk_widget_destroy(long /*int*/ widget) {
	lock.lock();
	try {
		_gtk_widget_destroy(widget);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_widget_event(long /*int*/ widget, long /*int*/ event);
public static final boolean gtk_widget_event(long /*int*/ widget, long /*int*/ event) {
	lock.lock();
	try {
		return _gtk_widget_event(widget, event);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_widget_get_child_visible (long /*int*/ widget);
public static final boolean gtk_widget_get_child_visible (long /*int*/ widget) {
	lock.lock();
	try {
		return _gtk_widget_get_child_visible(widget);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_widget_get_default_direction();
public static final int gtk_widget_get_default_direction() {
	lock.lock();
	try {
		return _gtk_widget_get_default_direction();
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_widget_get_default_style();
public static final long /*int*/ gtk_widget_get_default_style() {
	lock.lock();
	try {
		return _gtk_widget_get_default_style();
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_widget_get_direction(long /*int*/ widget);
public static final int gtk_widget_get_direction(long /*int*/ widget) {
	lock.lock();
	try {
		return _gtk_widget_get_direction(widget);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_widget_get_events(long /*int*/ widget);
public static final int gtk_widget_get_events(long /*int*/ widget) {
	lock.lock();
	try {
		return _gtk_widget_get_events(widget);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_widget_get_modifier_style(long /*int*/ widget);
public static final long /*int*/ gtk_widget_get_modifier_style(long /*int*/ widget) {
	lock.lock();
	try {
		return _gtk_widget_get_modifier_style(widget);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_widget_get_pango_context(long /*int*/ widget);
public static final long /*int*/ gtk_widget_get_pango_context(long /*int*/ widget) {
	lock.lock();
	try {
		return _gtk_widget_get_pango_context(widget);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_widget_get_parent(long /*int*/ widget);
public static final long /*int*/ gtk_widget_get_parent(long /*int*/ widget) {
	lock.lock();
	try {
		return _gtk_widget_get_parent(widget);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_widget_get_style(long /*int*/ widget);
public static final long /*int*/ gtk_widget_get_style(long /*int*/ widget) {
	lock.lock();
	try {
		return _gtk_widget_get_style(widget);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_get_size_request(long /*int*/ widget, int [] width, int [] height);
public static final void gtk_widget_get_size_request(long /*int*/ widget, int [] width, int [] height) {
	lock.lock();
	try {
		_gtk_widget_get_size_request(widget, width, height);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_widget_get_toplevel (long /*int*/ widget);
public static final long /*int*/ gtk_widget_get_toplevel (long /*int*/ widget) {
	lock.lock();
	try {
		return _gtk_widget_get_toplevel(widget);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_grab_focus(long /*int*/ widget);
public static final void gtk_widget_grab_focus(long /*int*/ widget) {
	lock.lock();
	try {
		_gtk_widget_grab_focus(widget);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_hide(long /*int*/ widget);
public static final void gtk_widget_hide(long /*int*/ widget) {
	lock.lock();
	try {
		_gtk_widget_hide(widget);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_widget_is_focus(long /*int*/ widget);
public static final boolean gtk_widget_is_focus(long /*int*/ widget) {
	lock.lock();
	try {
		return _gtk_widget_is_focus(widget);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_map(long /*int*/ widget);
public static final void gtk_widget_map(long /*int*/ widget) {
	lock.lock();
	try {
		_gtk_widget_map(widget);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_widget_mnemonic_activate(long /*int*/ widget, boolean group_cycling);
public static final boolean gtk_widget_mnemonic_activate(long /*int*/ widget, boolean group_cycling) {
	lock.lock();
	try {
		return _gtk_widget_mnemonic_activate(widget, group_cycling);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_modify_base(long /*int*/ widget, int state, GdkColor color);
public static final void gtk_widget_modify_base(long /*int*/ widget, int state, GdkColor color) {
	lock.lock();
	try {
		_gtk_widget_modify_base(widget, state, color);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_modify_bg(long /*int*/ widget, int state, GdkColor color);
public static final void gtk_widget_modify_bg(long /*int*/ widget, int state, GdkColor color) {
	lock.lock();
	try {
		_gtk_widget_modify_bg(widget, state, color);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_modify_fg(long /*int*/ widget, int state, GdkColor color);
public static final void gtk_widget_modify_fg(long /*int*/ widget, int state, GdkColor color) {
	lock.lock();
	try {
		_gtk_widget_modify_fg(widget, state, color);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_modify_font(long /*int*/ widget, long /*int*/ pango_font_descr);
public static final void gtk_widget_modify_font(long /*int*/ widget, long /*int*/ pango_font_descr) {
	lock.lock();
	try {
		_gtk_widget_modify_font(widget, pango_font_descr);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_modify_style(long /*int*/ widget, long /*int*/ style);
public static final void gtk_widget_modify_style(long /*int*/ widget, long /*int*/ style) {
	lock.lock();
	try {
		_gtk_widget_modify_style(widget, style);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_modify_text(long /*int*/ widget, int state, GdkColor color);
public static final void gtk_widget_modify_text(long /*int*/ widget, int state, GdkColor color) {
	lock.lock();
	try {
		_gtk_widget_modify_text(widget, state, color);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_realize(long /*int*/ widget);
public static final void gtk_widget_realize(long /*int*/ widget) {
	lock.lock();
	try {
		_gtk_widget_realize(widget);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_remove_accelerator(long /*int*/ widget, long /*int*/ accel_group, int accel_key, int accel_mods);
public static final void gtk_widget_remove_accelerator(long /*int*/ widget, long /*int*/ accel_group, int accel_key, int accel_mods) {
	lock.lock();
	try {
		_gtk_widget_remove_accelerator(widget, accel_group, accel_key, accel_mods);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_reparent(long /*int*/ widget, long /*int*/ new_parent);
public static final void gtk_widget_reparent(long /*int*/ widget, long /*int*/ new_parent) {
	lock.lock();
	try {
		_gtk_widget_reparent(widget, new_parent);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_set_default_direction(int dir);
public static final void gtk_widget_set_default_direction(int dir) {
	lock.lock();
	try {
		_gtk_widget_set_default_direction(dir);
	} finally {
		lock.unlock();
	}
} 
public static final native void _gtk_widget_set_direction(long /*int*/ widget, int dir);
public static final void gtk_widget_set_direction(long /*int*/ widget, int dir) {
	lock.lock();
	try {
		_gtk_widget_set_direction(widget, dir);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_set_double_buffered(long /*int*/ widget, boolean double_buffered);
public static final void gtk_widget_set_double_buffered(long /*int*/ widget, boolean double_buffered) {
	lock.lock();
	try {
		_gtk_widget_set_double_buffered(widget, double_buffered);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_set_name(long /*int*/ widget, byte[] name);
public static final void gtk_widget_set_name(long /*int*/ widget, byte[] name) {
	lock.lock();
	try {
		_gtk_widget_set_name(widget, name);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_set_redraw_on_allocate(long /*int*/ widget, boolean redraw);
public static final void gtk_widget_set_redraw_on_allocate(long /*int*/ widget, boolean redraw) {
	lock.lock();
	try {
		_gtk_widget_set_redraw_on_allocate(widget, redraw);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_set_sensitive(long /*int*/ widget, boolean sensitive);
public static final void gtk_widget_set_sensitive(long /*int*/ widget, boolean sensitive) {
	lock.lock();
	try {
		_gtk_widget_set_sensitive(widget, sensitive);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_set_size_request(long /*int*/ widget, int width, int height);
public static final void gtk_widget_set_size_request(long /*int*/ widget, int width, int height) {
	lock.lock();
	try {
		_gtk_widget_set_size_request(widget, width, height);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_set_state(long /*int*/ widget, int state);
public static final void gtk_widget_set_state(long /*int*/ widget, int state) {
	lock.lock();
	try {
		_gtk_widget_set_state(widget, state);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_shape_combine_mask(long /*int*/ widget, long /*int*/ shape_mask, int offset_x, int offset_y);
public static final void gtk_widget_shape_combine_mask(long /*int*/ widget, long /*int*/ shape_mask, int offset_x, int offset_y) {
	lock.lock();
	try {
		_gtk_widget_shape_combine_mask(widget, shape_mask, offset_x, offset_y);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_show(long /*int*/ widget);
public static final void gtk_widget_show(long /*int*/ widget) {
	lock.lock();
	try {
		_gtk_widget_show(widget);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_show_now(long /*int*/ widget);
public static final void gtk_widget_show_now(long /*int*/ widget) {
	lock.lock();
	try {
		_gtk_widget_show_now(widget);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_size_allocate(long /*int*/ widget, GtkAllocation allocation);
public static final void gtk_widget_size_allocate(long /*int*/ widget, GtkAllocation allocation) {
	lock.lock();
	try {
		_gtk_widget_size_allocate(widget, allocation);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_size_request(long /*int*/ widget, GtkRequisition requisition);
public static final void gtk_widget_size_request(long /*int*/ widget, GtkRequisition requisition) {
	lock.lock();
	try {
		_gtk_widget_size_request(widget, requisition);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_style_get(long /*int*/ widget, byte[] property_name, int[] value, long /*int*/ terminator);
public static final void gtk_widget_style_get(long /*int*/ widget, byte[] property_name, int[] value, long /*int*/ terminator) {
	lock.lock();
	try {
		_gtk_widget_style_get(widget, property_name, value, terminator);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_style_get(long /*int*/ widget, byte[] property_name, long[] value, long /*int*/ terminator);
public static final void gtk_widget_style_get(long /*int*/ widget, byte[] property_name, long[] value, long /*int*/ terminator) {
	lock.lock();
	try {
		_gtk_widget_style_get(widget, property_name, value, terminator);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_widget_unrealize(long /*int*/ widget);
public static final void gtk_widget_unrealize(long /*int*/ widget) {
	lock.lock();
	try {
		_gtk_widget_unrealize(widget);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _gtk_window_activate_default(long /*int*/ window);
public static final boolean gtk_window_activate_default(long /*int*/ window) {
	lock.lock();
	try {
		return _gtk_window_activate_default(window);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_window_add_accel_group(long /*int*/ window, long /*int*/ accel_group);
public static final void gtk_window_add_accel_group(long /*int*/ window, long /*int*/ accel_group) {
	lock.lock();
	try {
		_gtk_window_add_accel_group(window, accel_group);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_window_deiconify(long /*int*/ handle);
public static final void gtk_window_deiconify(long /*int*/ handle) {
	lock.lock();
	try {
		_gtk_window_deiconify(handle);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_window_get_focus(long /*int*/ window);
public static final long /*int*/ gtk_window_get_focus(long /*int*/ window) {
	lock.lock();
	try {
		return _gtk_window_get_focus(window);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_window_get_icon_list(long /*int*/ window);
public static final long /*int*/ gtk_window_get_icon_list(long /*int*/ window) {
	lock.lock();
	try {
		return _gtk_window_get_icon_list(window);
	} finally {
		lock.unlock();
	}
}
public static final native int _gtk_window_get_mnemonic_modifier(long /*int*/ window);
public static final int gtk_window_get_mnemonic_modifier(long /*int*/ window) {
	lock.lock();
	try {
		return _gtk_window_get_mnemonic_modifier(window);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_window_get_position(long /*int*/ handle, int[] x, int[] y);
public static final void gtk_window_get_position(long /*int*/ handle, int[] x, int[] y) {
	lock.lock();
	try {
		_gtk_window_get_position(handle, x, y);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_window_get_size(long /*int*/ handle, int[] x, int[] y);
public static final void gtk_window_get_size(long /*int*/ handle, int[] x, int[] y) {
	lock.lock();
	try {
		_gtk_window_get_size(handle, x, y);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_window_iconify(long /*int*/ handle);
public static final void gtk_window_iconify(long /*int*/ handle) {
	lock.lock();
	try {
		_gtk_window_iconify(handle);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_window_maximize(long /*int*/ handle);
public static final void gtk_window_maximize(long /*int*/ handle) {
	lock.lock();
	try {
		_gtk_window_maximize(handle);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_window_move(long /*int*/ handle, int x, int y);
public static final void gtk_window_move(long /*int*/ handle, int x, int y) {
	lock.lock();
	try {
		_gtk_window_move(handle, x, y);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _gtk_window_new(int type);
public static final long /*int*/ gtk_window_new(int type) {
	lock.lock();
	try {
		return _gtk_window_new(type);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_window_present(long /*int*/ window);
public static final void gtk_window_present(long /*int*/ window) {
	lock.lock();
	try {
		_gtk_window_present(window);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_window_remove_accel_group(long /*int*/ window, long /*int*/ accel_group);
public static final void gtk_window_remove_accel_group(long /*int*/ window, long /*int*/ accel_group) {
	lock.lock();
	try {
		_gtk_window_remove_accel_group(window, accel_group);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_window_resize(long /*int*/ handle, int x, int y);
public static final void gtk_window_resize(long /*int*/ handle, int x, int y) {
	lock.lock();
	try {
		_gtk_window_resize(handle, x, y);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_window_set_default(long /*int*/ window, long /*int*/ widget);
public static final void gtk_window_set_default(long /*int*/ window, long /*int*/ widget) {
	lock.lock();
	try {
		_gtk_window_set_default(window, widget);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_window_set_destroy_with_parent(long /*int*/ window, boolean setting);
public static final void gtk_window_set_destroy_with_parent(long /*int*/ window, boolean setting) {
	lock.lock();
	try {
		_gtk_window_set_destroy_with_parent(window, setting);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_window_set_geometry_hints(long /*int*/ window, long /*int*/ geometry_widget, GdkGeometry geometry, int geom_mask);
public static final void gtk_window_set_geometry_hints(long /*int*/ window, long /*int*/ geometry_widget, GdkGeometry geometry, int geom_mask) {
	lock.lock();
	try {
		_gtk_window_set_geometry_hints(window, geometry_widget, geometry, geom_mask);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_window_set_icon_list(long /*int*/ window, long /*int*/ list);
public static final void gtk_window_set_icon_list(long /*int*/ window, long /*int*/ list) {	
	lock.lock();
	try {
		_gtk_window_set_icon_list(window, list);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_window_set_modal(long /*int*/ window, boolean modal);
public static final void gtk_window_set_modal(long /*int*/ window, boolean modal) {
	lock.lock();
	try {
		_gtk_window_set_modal(window, modal);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_window_set_resizable(long /*int*/ window, boolean resizable);
public static final void gtk_window_set_resizable(long /*int*/ window, boolean resizable) {
	lock.lock();
	try {
		_gtk_window_set_resizable(window, resizable);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_window_set_title(long /*int*/ window, byte[] title);
public static final void gtk_window_set_title(long /*int*/ window, byte[] title) {
	lock.lock();
	try {
		_gtk_window_set_title(window, title);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_window_set_type_hint(long /*int*/ window, int hint);
public static final void gtk_window_set_type_hint(long /*int*/ window, int hint) {
	lock.lock();
	try {
		_gtk_window_set_type_hint(window, hint);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_window_set_transient_for(long /*int*/ window, long /*int*/ parent);
public static final void gtk_window_set_transient_for(long /*int*/ window, long /*int*/ parent) {
	lock.lock();
	try {
		_gtk_window_set_transient_for(window, parent);
	} finally {
		lock.unlock();
	}
}
public static final native void _gtk_window_unmaximize(long /*int*/ handle);
public static final void gtk_window_unmaximize(long /*int*/ handle) {
	lock.lock();
	try {
		_gtk_window_unmaximize(handle);
	} finally {
		lock.unlock();
	}
}
public static final native void memmove(long /*int*/ dest, GInterfaceInfo src, int size);
public static final native void memmove(long /*int*/ dest, GObjectClass src);
public static final native void memmove(long /*int*/ dest, GTypeInfo src, int size);
public static final native void memmove(long /*int*/ dest, GtkTargetEntry src, long /*int*/ size);
public static final native void memmove(long /*int*/ dest, GtkAdjustment src);
public static final native void memmove(long /*int*/ dest, GdkEventButton src, long /*int*/ size);
public static final native void memmove(long /*int*/ dest, GtkWidgetClass src);
public static final native void memmove(long /*int*/ dest, PangoAttribute src, long /*int*/ size);
public static final native void memmove(GObjectClass  dest, long /*int*/ src);
public static final native void memmove(GTypeQuery dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(GtkColorSelectionDialog dest, long /*int*/ src);
public static final native void memmove(GtkFileSelection dest, long /*int*/ src);
public static final native void memmove(GdkDragContext dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(GtkSelectionData dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(GtkWidgetClass dest, long /*int*/ src);
public static final native void memmove(GtkTargetPair dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(GtkCombo dest, long /*int*/ src);
public static final native void memmove(GtkAdjustment dest, long /*int*/ src);
public static final native void memmove(GtkBorder dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(GdkColor dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(GdkEvent dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(GdkEventButton dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(GdkEventCrossing dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(GdkEventExpose dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(GdkEventFocus dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(GdkEventKey dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(GdkEventMotion dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(GdkEventScroll dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(GdkEventVisibility dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(GdkEventWindowState dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(GtkFixed dest, long /*int*/ src);
public static final native void memmove(long /*int*/ dest, GtkFixed src);
public static final native void memmove(GdkVisual dest, long /*int*/ src);
public static final native void memmove(GdkImage dest, long /*int*/ src);
public static final native void memmove(GdkRectangle dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(PangoAttribute dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(PangoItem dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(PangoLayoutLine dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(PangoLayoutRun dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(PangoLogAttr dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(long /*int*/ dest, int[] src, long /*int*/ size);
public static final native void memmove(long /*int*/ dest, long[] src, long /*int*/ size);
public static final native void memmove(long /*int*/ dest, byte[] src, long /*int*/ size);
public static final native void memmove(long /*int*/ dest, char[] src, long /*int*/ size);
public static final native void memmove(long /*int*/ dest, double[] src, long /*int*/ size);
public static final native void memmove(int[] dest, byte[] src, long /*int*/ size);
public static final native void memmove(byte[] dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(char[] dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(int[] dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(long /*int*/ dest, long /*int*/ src, long /*int*/ size);
public static final native void memmove(long[] dest, long /*int*/ src, long /*int*/ size);
public static final native void memset(long /*int*/ buffer, char c, long /*int*/ num);
public static final native long /*int*/ _pango_attr_background_new (short red, short green, short blue);
public static final long /*int*/ pango_attr_background_new (short red, short green, short blue) {
	lock.lock();
	try {
		return _pango_attr_background_new(red, green, blue);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_attr_font_desc_new(long /*int*/ desc);
public static final long /*int*/ pango_attr_font_desc_new(long /*int*/ desc) {
	lock.lock();
	try {
		return _pango_attr_font_desc_new(desc);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_attr_foreground_new (short red, short green, short blue);
public static final long /*int*/ pango_attr_foreground_new (short red, short green, short blue) {
	lock.lock();
	try {
		return _pango_attr_foreground_new(red, green, blue);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_attr_shape_new(PangoRectangle ink_rect, PangoRectangle logical_rect);
public static final long /*int*/ pango_attr_shape_new(PangoRectangle ink_rect, PangoRectangle logical_rect) {
	lock.lock();
	try {
		return _pango_attr_shape_new(ink_rect, logical_rect);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_attr_list_insert(long /*int*/ list, long /*int*/ attr);
public static final void pango_attr_list_insert(long /*int*/ list, long /*int*/ attr) {
	lock.lock();
	try {
		_pango_attr_list_insert(list, attr);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_attr_list_change(long /*int*/ list, long /*int*/ attr);
public static final void pango_attr_list_change(long /*int*/ list, long /*int*/ attr) {
	lock.lock();
	try {
		_pango_attr_list_change(list, attr);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_attr_list_new();
public static final long /*int*/ pango_attr_list_new() {
	lock.lock();
	try {
		return _pango_attr_list_new();
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_attr_list_unref(long /*int*/ list);
public static final void pango_attr_list_unref(long /*int*/ list) {
	lock.lock();
	try {
		_pango_attr_list_unref(list);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_attr_strikethrough_new(boolean strikethrough);
public static final long /*int*/ pango_attr_strikethrough_new(boolean strikethrough) {
	lock.lock();
	try {
		return _pango_attr_strikethrough_new(strikethrough);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_attr_underline_new(int underline);
public static final long /*int*/ pango_attr_underline_new(int underline) {
	lock.lock();
	try {
		return _pango_attr_underline_new(underline);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_attr_weight_new(int weight);
public static final long /*int*/ pango_attr_weight_new(int weight) {
	lock.lock();
	try {
		return _pango_attr_weight_new(weight);
	} finally {
		lock.unlock();
	}
}
public static final native int _pango_context_get_base_dir(long /*int*/ context);
public static final int pango_context_get_base_dir(long /*int*/ context) {
	lock.lock();
	try {
		return _pango_context_get_base_dir(context);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_context_get_language(long /*int*/ context);
public static final long /*int*/ pango_context_get_language(long /*int*/ context) {
	lock.lock();
	try {
		return _pango_context_get_language(context);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_context_get_metrics(long /*int*/ context, long /*int*/ desc, long /*int*/ language);
public static final long /*int*/ pango_context_get_metrics(long /*int*/ context, long /*int*/ desc, long /*int*/ language) {
	lock.lock();
	try {
		return _pango_context_get_metrics(context, desc, language);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_context_list_families(long /*int*/ context, long /*int*/[] families, int[] n_families);
public static final void pango_context_list_families(long /*int*/ context, long /*int*/[] families, int[] n_families) {
	lock.lock();
	try {
		_pango_context_list_families(context, families, n_families);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_context_set_base_dir(long /*int*/ context, int direction);
public static final void pango_context_set_base_dir(long /*int*/ context, int direction) {
	lock.lock();
	try {
		_pango_context_set_base_dir(context, direction);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_context_set_language(long /*int*/ context, long /*int*/ language);
public static final void pango_context_set_language(long /*int*/ context, long /*int*/ language) {
	lock.lock();
	try {
		_pango_context_set_language(context, language);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_font_description_copy(long /*int*/ desc);
public static final long /*int*/ pango_font_description_copy(long /*int*/ desc) {
	lock.lock();
	try {
		return _pango_font_description_copy(desc);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_font_description_free(long /*int*/ desc);
public static final void pango_font_description_free(long /*int*/ desc) {
	lock.lock();
	try {
		_pango_font_description_free(desc);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_font_description_from_string(byte[] str);
public static final long /*int*/ pango_font_description_from_string(byte[] str) {
	lock.lock();
	try {
		return _pango_font_description_from_string(str);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_font_description_get_family(long /*int*/ desc);
public static final long /*int*/ pango_font_description_get_family(long /*int*/ desc) {
	lock.lock();
	try {
		return _pango_font_description_get_family(desc);
	} finally {
		lock.unlock();
	}
}
public static final native int _pango_font_description_get_size(long /*int*/ desc);
public static final int pango_font_description_get_size(long /*int*/ desc) {
	lock.lock();
	try {
		return _pango_font_description_get_size(desc);
	} finally {
		lock.unlock();
	}
}
public static final native int _pango_font_description_get_style(long /*int*/ desc);
public static final int pango_font_description_get_style(long /*int*/ desc) {
	lock.lock();
	try {
		return _pango_font_description_get_style(desc);
	} finally {
		lock.unlock();
	}
}
public static final native int _pango_font_description_get_weight(long /*int*/ desc);
public static final int pango_font_description_get_weight(long /*int*/ desc) {
	lock.lock();
	try {
		return _pango_font_description_get_weight(desc);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_font_description_new();
public static final long /*int*/ pango_font_description_new() {
	lock.lock();
	try {
		return _pango_font_description_new();
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_font_description_set_family(long /*int*/ desc, byte[] family);
public static final void pango_font_description_set_family(long /*int*/ desc, byte[] family) {
	lock.lock();
	try {
		_pango_font_description_set_family(desc, family);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_font_description_set_size(long /*int*/ desc, int size);
public static final void pango_font_description_set_size(long /*int*/ desc, int size) {
	lock.lock();
	try {
		_pango_font_description_set_size(desc, size);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_font_description_set_stretch(long /*int*/ desc, int stretch);
public static final void pango_font_description_set_stretch(long /*int*/ desc, int stretch) {
	lock.lock();
	try {
		_pango_font_description_set_stretch(desc, stretch);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_font_description_set_style(long /*int*/ desc, int weight);
public static final void pango_font_description_set_style(long /*int*/ desc, int weight) {
	lock.lock();
	try {
		_pango_font_description_set_style(desc, weight);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_font_description_set_weight(long /*int*/ desc, int weight);
public static final void pango_font_description_set_weight(long /*int*/ desc, int weight) {
	lock.lock();
	try {
		_pango_font_description_set_weight(desc, weight);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_font_description_to_string(long /*int*/ desc);
public static final long /*int*/ pango_font_description_to_string(long /*int*/ desc) {
	lock.lock();
	try {
		return _pango_font_description_to_string(desc);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_font_face_describe(long /*int*/ face);
public static final long /*int*/ pango_font_face_describe(long /*int*/ face) {
	lock.lock();
	try {
		return _pango_font_face_describe(face);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_font_family_get_name(long /*int*/ family);
public static final long /*int*/ pango_font_family_get_name(long /*int*/ family) {
	lock.lock();
	try {
		return _pango_font_family_get_name(family);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_font_family_list_faces(long /*int*/ family, long /*int*/[] faces, int[] n_faces);
public static final void pango_font_family_list_faces(long /*int*/ family, long /*int*/[] faces, int[] n_faces) {
	lock.lock();
	try {
		_pango_font_family_list_faces(family, faces, n_faces);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_font_get_metrics(long /*int*/ font, long /*int*/ language);
public static final long /*int*/ pango_font_get_metrics(long /*int*/ font, long /*int*/ language) {
	lock.lock();
	try {
		return _pango_font_get_metrics(font, language);
	} finally {
		lock.unlock();
	}
}
public static final native int _pango_font_metrics_get_approximate_char_width(long /*int*/ metrics);
public static final int pango_font_metrics_get_approximate_char_width(long /*int*/ metrics) {
	lock.lock();
	try {
		return _pango_font_metrics_get_approximate_char_width(metrics);
	} finally {
		lock.unlock();
	}
}
public static final native int _pango_font_metrics_get_ascent(long /*int*/ metrics);
public static final int pango_font_metrics_get_ascent(long /*int*/ metrics) {
	lock.lock();
	try {
		return _pango_font_metrics_get_ascent(metrics);
	} finally {
		lock.unlock();
	}
}
public static final native int _pango_font_metrics_get_descent(long /*int*/ metrics);
public static final int pango_font_metrics_get_descent(long /*int*/ metrics) {
	lock.lock();
	try {
		return _pango_font_metrics_get_descent(metrics);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_font_metrics_unref(long /*int*/ metrics);
public static final void pango_font_metrics_unref(long /*int*/ metrics) {
	lock.lock();
	try {
		_pango_font_metrics_unref(metrics);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_language_from_string(byte[] language);
public static final long /*int*/ pango_language_from_string(byte[] language) {
	lock.lock();
	try {
		return _pango_language_from_string(language);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_layout_context_changed (long /*int*/ layout);
public static final void pango_layout_context_changed (long /*int*/ layout) {
	lock.lock();
	try {
		_pango_layout_context_changed(layout);
	} finally {
		lock.unlock();
	}
}
public static final native int _pango_layout_get_alignment(long /*int*/ layout);
public static final int pango_layout_get_alignment(long /*int*/ layout) {
	lock.lock();
	try {
		return _pango_layout_get_alignment(layout);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_layout_get_attributes(long /*int*/ layout);
public static final long /*int*/ pango_layout_get_attributes(long /*int*/ layout) {
	lock.lock();
	try {
		return _pango_layout_get_attributes(layout);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_layout_get_iter(long /*int*/ layout);
public static final long /*int*/ pango_layout_get_iter(long /*int*/ layout) {
	lock.lock();
	try {
		return _pango_layout_get_iter(layout);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_layout_get_line(long /*int*/ layout, int line);
public static final long /*int*/ pango_layout_get_line(long /*int*/ layout, int line) {
	lock.lock();
	try {
		return _pango_layout_get_line(layout, line);
	} finally {
		lock.unlock();
	}
}
public static final native int _pango_layout_get_line_count(long /*int*/ layout);
public static final int pango_layout_get_line_count(long /*int*/ layout) {
	lock.lock();
	try {
		return _pango_layout_get_line_count(layout);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_layout_get_log_attrs(long /*int*/ layout, long /*int*/[] attrs, int[] n_attrs);
public static final void pango_layout_get_log_attrs(long /*int*/ layout, long /*int*/[] attrs, int[] n_attrs) {
	lock.lock();
	try {
		_pango_layout_get_log_attrs(layout, attrs, n_attrs);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_layout_get_size(long /*int*/ layout, int[] width, int[] height);
public static final void pango_layout_get_size(long /*int*/ layout, int[] width, int[] height) {
	lock.lock();
	try {
		_pango_layout_get_size(layout, width, height);
	} finally {
		lock.unlock();
	}
}
public static final native int _pango_layout_get_spacing(long /*int*/ layout);
public static final int pango_layout_get_spacing(long /*int*/ layout) {
	lock.lock();
	try {
		return _pango_layout_get_spacing(layout);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_layout_get_tabs(long /*int*/ layout);
public static final long /*int*/ pango_layout_get_tabs(long /*int*/ layout) {
	lock.lock();
	try {
		return _pango_layout_get_tabs(layout);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_layout_get_text(long /*int*/ layout);
public static final long /*int*/ pango_layout_get_text(long /*int*/ layout) {
	lock.lock();
	try {
		return _pango_layout_get_text(layout);
	} finally {
		lock.unlock();
	}
}
public static final native int _pango_layout_get_width(long /*int*/ layout);
public static final int pango_layout_get_width(long /*int*/ layout) {
	lock.lock();
	try {
		return _pango_layout_get_width(layout);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_layout_index_to_pos(long /*int*/ layout, int index, PangoRectangle pos);
public static final void pango_layout_index_to_pos(long /*int*/ layout, int index, PangoRectangle pos) {
	lock.lock();
	try {
		_pango_layout_index_to_pos(layout, index, pos);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_layout_iter_free(long /*int*/ iter);
public static final void pango_layout_iter_free(long /*int*/ iter) {
	lock.lock();
	try {
		_pango_layout_iter_free(iter);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_layout_iter_get_line_extents(long /*int*/ iter, PangoRectangle ink_rect, PangoRectangle logical_rect);
public static final void pango_layout_iter_get_line_extents(long /*int*/ iter, PangoRectangle ink_rect, PangoRectangle logical_rect) {
	lock.lock();
	try {
		_pango_layout_iter_get_line_extents(iter, ink_rect, logical_rect);
	} finally {
		lock.unlock();
	}
}
public static final native int _pango_layout_iter_get_index(long /*int*/ iter);
public static final int pango_layout_iter_get_index(long /*int*/ iter) {
	lock.lock();
	try {
		return _pango_layout_iter_get_index(iter);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_layout_iter_get_run(long /*int*/ iter);
public static final long /*int*/ pango_layout_iter_get_run(long /*int*/ iter) {
	lock.lock();
	try {
		return _pango_layout_iter_get_run(iter);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _pango_layout_iter_next_line(long /*int*/ iter);
public static final boolean pango_layout_iter_next_line(long /*int*/ iter) {
	lock.lock();
	try {
		return _pango_layout_iter_next_line(iter);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _pango_layout_iter_next_run(long /*int*/ iter);
public static final boolean pango_layout_iter_next_run(long /*int*/ iter) {
	lock.lock();
	try {
		return _pango_layout_iter_next_run(iter);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_layout_line_get_extents(long /*int*/ line, PangoRectangle ink_rect, PangoRectangle logical_rect);
public static final void pango_layout_line_get_extents(long /*int*/ line, PangoRectangle ink_rect, PangoRectangle logical_rect) {
	lock.lock();
	try {
		_pango_layout_line_get_extents(line, ink_rect, logical_rect);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _pango_layout_line_x_to_index(long /*int*/ line, int x_pos, int[] index_, int[] trailing);
public static final boolean pango_layout_line_x_to_index(long /*int*/ line, int x_pos, int[] index_, int[] trailing) {
	lock.lock();
	try {
		return _pango_layout_line_x_to_index(line, x_pos, index_, trailing);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_layout_new(long /*int*/ context);
public static final long /*int*/ pango_layout_new(long /*int*/ context) {
	lock.lock();
	try {
		return _pango_layout_new(context);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_layout_set_alignment (long /*int*/ layout, int alignment);
public static final void pango_layout_set_alignment (long /*int*/ layout, int alignment) {
	lock.lock();
	try {
		_pango_layout_set_alignment(layout, alignment);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_layout_set_attributes(long /*int*/ layout, long /*int*/ attrs);
public static final void pango_layout_set_attributes(long /*int*/ layout, long /*int*/ attrs) {
	lock.lock();
	try {
		_pango_layout_set_attributes(layout, attrs);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_layout_set_font_description(long /*int*/ context, long /*int*/ descr);
public static final void pango_layout_set_font_description(long /*int*/ context, long /*int*/ descr) {
	lock.lock();
	try {
		_pango_layout_set_font_description(context, descr);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_layout_set_single_paragraph_mode(long /*int*/ context, boolean setting);
public static final void pango_layout_set_single_paragraph_mode(long /*int*/ context, boolean setting) {
	lock.lock();
	try {
		_pango_layout_set_single_paragraph_mode(context, setting);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_layout_set_spacing(long /*int*/ layout, int spacing);
public static final void pango_layout_set_spacing(long /*int*/ layout, int spacing) {
	lock.lock();
	try {
		_pango_layout_set_spacing(layout, spacing);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_layout_set_tabs(long /*int*/ layout, long /*int*/ tabs);
public static final void pango_layout_set_tabs(long /*int*/ layout, long /*int*/ tabs) {
	lock.lock();
	try {
		_pango_layout_set_tabs(layout, tabs);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_layout_set_text(long /*int*/ layout, byte[] text, int length);
public static final void pango_layout_set_text(long /*int*/ layout, byte[] text, int length) {
	lock.lock();
	try {
		_pango_layout_set_text(layout, text, length);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_layout_set_width(long /*int*/ layout, int width);
public static final void pango_layout_set_width(long /*int*/ layout, int width) {
	lock.lock();
	try {
		_pango_layout_set_width(layout, width);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_layout_set_wrap (long /*int*/ layout, int wrap);
public static final void pango_layout_set_wrap (long /*int*/ layout, int wrap) {
	lock.lock();
	try {
		_pango_layout_set_wrap(layout, wrap);
	} finally {
		lock.unlock();
	}
}
public static final native boolean _pango_layout_xy_to_index(long /*int*/ layout, int x, int y, int[] index, int[] trailing);
public static final boolean pango_layout_xy_to_index(long /*int*/ layout, int x, int y, int[] index, int[] trailing) {
	lock.lock();
	try {
		return _pango_layout_xy_to_index(layout, x, y, index, trailing);
	} finally {
		lock.unlock();
	}
}
public static final native int _pango_tab_array_get_size(long /*int*/ tab_array);
public static final int pango_tab_array_get_size(long /*int*/ tab_array) {
	lock.lock();
	try {
		return _pango_tab_array_get_size(tab_array);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_tab_array_get_tabs(long /*int*/ tab_array, long /*int*/[] alignments, long /*int*/[] locations);
public static final void pango_tab_array_get_tabs(long /*int*/ tab_array, long /*int*/[] alignments, long /*int*/[] locations) {
	lock.lock();
	try {
		_pango_tab_array_get_tabs(tab_array, alignments, locations);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_tab_array_free(long /*int*/ tab_array);
public static final void pango_tab_array_free(long /*int*/ tab_array) {
	lock.lock();
	try {
		_pango_tab_array_free(tab_array);
	} finally {
		lock.unlock();
	}
}
public static final native long /*int*/ _pango_tab_array_new(int initial_size, boolean positions_in_pixels);
public static final long /*int*/ pango_tab_array_new(int initial_size, boolean positions_in_pixels) {
	lock.lock();
	try {
		return _pango_tab_array_new(initial_size, positions_in_pixels);
	} finally {
		lock.unlock();
	}
}
public static final native void _pango_tab_array_set_tab(long /*int*/ tab_array, int tab_index, long /*int*/ alignment, int location);
public static final void pango_tab_array_set_tab(long /*int*/ tab_array, int tab_index, long /*int*/ alignment, int location) {
	lock.lock();
	try {
		_pango_tab_array_set_tab(tab_array, tab_index, alignment, location);
	} finally {
		lock.unlock();
	}
}
}
