/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.browser.MozillaDelegate;
import org.eclipse.swt.browser.PromptDialog;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIDOMWindow;
import org.eclipse.swt.internal.mozilla.nsIEmbeddingSiteWindow;
import org.eclipse.swt.internal.mozilla.nsIMemory;
import org.eclipse.swt.internal.mozilla.nsIPromptService;
import org.eclipse.swt.internal.mozilla.nsIServiceManager;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.internal.mozilla.nsIWebBrowserChrome;
import org.eclipse.swt.internal.mozilla.nsIWindowWatcher;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

class PromptService {
    XPCOMObject supports;
    XPCOMObject promptService;
    int refCount = 0;

    public PromptService() {
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.supports = new XPCOMObject(nArray){

            public long method0(long[] args) {
                return PromptService.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return PromptService.this.AddRef();
            }

            public long method2(long[] args) {
                return PromptService.this.Release();
            }
        };
        int[] nArray2 = new int[12];
        nArray2[0] = 2;
        nArray2[3] = 3;
        nArray2[4] = 5;
        nArray2[5] = 4;
        nArray2[6] = 6;
        nArray2[7] = 10;
        nArray2[8] = 7;
        nArray2[9] = 8;
        nArray2[10] = 7;
        nArray2[11] = 7;
        this.promptService = new XPCOMObject(nArray2){

            public long method0(long[] args) {
                return PromptService.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return PromptService.this.AddRef();
            }

            public long method2(long[] args) {
                return PromptService.this.Release();
            }

            public long method3(long[] args) {
                return PromptService.this.Alert(args[0], args[1], args[2]);
            }

            public long method4(long[] args) {
                return PromptService.this.AlertCheck(args[0], args[1], args[2], args[3], args[4]);
            }

            public long method5(long[] args) {
                return PromptService.this.Confirm(args[0], args[1], args[2], args[3]);
            }

            public long method6(long[] args) {
                return PromptService.this.ConfirmCheck(args[0], args[1], args[2], args[3], args[4], args[5]);
            }

            public long method7(long[] args) {
                return PromptService.this.ConfirmEx(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9]);
            }

            public long method8(long[] args) {
                return PromptService.this.Prompt(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }

            public long method9(long[] args) {
                return PromptService.this.PromptUsernameAndPassword(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
            }

            public long method10(long[] args) {
                return PromptService.this.PromptPassword(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }

            public long method11(long[] args) {
                return PromptService.this.Select(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.promptService != null) {
            this.promptService.dispose();
            this.promptService = null;
        }
    }

    long getAddress() {
        return this.promptService.getAddress();
    }

    long QueryInterface(long riid, long ppvObject) {
        if (riid == 0L || ppvObject == 0L) {
            return -2147467262L;
        }
        nsID guid = new nsID();
        XPCOM.memmove(guid, riid, 16);
        if (guid.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.supports.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (guid.Equals(nsIPromptService.NS_IPROMPTSERVICE_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.promptService.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        XPCOM.memmove(ppvObject, new long[1], (long)C.PTR_SIZEOF);
        return -2147467262L;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    Browser getBrowser(long aDOMWindow) {
        if (aDOMWindow == 0L) {
            return null;
        }
        long[] result = new long[1];
        int rc = XPCOM.NS_GetServiceManager(result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0L) {
            Mozilla.error(-2147467262);
        }
        nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
        result[0] = 0L;
        byte[] aContractID = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/embedcomp/window-watcher;1", true);
        rc = serviceManager.GetServiceByContractID(aContractID, nsIWindowWatcher.NS_IWINDOWWATCHER_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0L) {
            Mozilla.error(-2147467262);
        }
        serviceManager.Release();
        nsIWindowWatcher windowWatcher = new nsIWindowWatcher(result[0]);
        result[0] = 0L;
        nsIDOMWindow window = new nsIDOMWindow(aDOMWindow);
        rc = window.GetTop(result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0L) {
            Mozilla.error(-2147467262);
        }
        aDOMWindow = result[0];
        result[0] = 0L;
        rc = windowWatcher.GetChromeForWindow(aDOMWindow, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0L) {
            Mozilla.error(-2147467262);
        }
        windowWatcher.Release();
        nsIWebBrowserChrome webBrowserChrome = new nsIWebBrowserChrome(result[0]);
        result[0] = 0L;
        rc = webBrowserChrome.QueryInterface(nsIEmbeddingSiteWindow.NS_IEMBEDDINGSITEWINDOW_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0L) {
            Mozilla.error(-2147467262);
        }
        webBrowserChrome.Release();
        nsIEmbeddingSiteWindow embeddingSiteWindow = new nsIEmbeddingSiteWindow(result[0]);
        result[0] = 0L;
        rc = embeddingSiteWindow.GetSiteWindow(result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0L) {
            Mozilla.error(-2147467262);
        }
        embeddingSiteWindow.Release();
        return Mozilla.findBrowser(result[0]);
    }

    String getLabel(int buttonFlag, int index, long buttonTitle) {
        String label = null;
        int flag = (buttonFlag & 255 * index) / index;
        switch (flag) {
            case 2: {
                label = SWT.getMessage("SWT_Cancel");
                break;
            }
            case 4: {
                label = SWT.getMessage("SWT_No");
                break;
            }
            case 1: {
                label = SWT.getMessage("SWT_OK");
                break;
            }
            case 5: {
                label = SWT.getMessage("SWT_Save");
                break;
            }
            case 3: {
                label = SWT.getMessage("SWT_Yes");
                break;
            }
            case 127: {
                int length = XPCOM.strlen_PRUnichar(buttonTitle);
                char[] dest = new char[length];
                XPCOM.memmove(dest, buttonTitle, (long)(length * 2));
                label = new String(dest);
            }
        }
        return label;
    }

    public long Alert(long aParent, long aDialogTitle, long aText) {
        Browser browser = this.getBrowser(aParent);
        int length = XPCOM.strlen_PRUnichar(aDialogTitle);
        char[] dest = new char[length];
        XPCOM.memmove(dest, aDialogTitle, (long)(length * 2));
        String titleLabel = new String(dest);
        length = XPCOM.strlen_PRUnichar(aText);
        dest = new char[length];
        XPCOM.memmove(dest, aText, (long)(length * 2));
        String textLabel = new String(dest);
        Shell shell = browser == null ? new Shell() : browser.getShell();
        MessageBox messageBox = new MessageBox(shell, 40);
        messageBox.setText(titleLabel);
        messageBox.setMessage(textLabel);
        messageBox.open();
        return 0L;
    }

    public long AlertCheck(long aParent, long aDialogTitle, long aText, long aCheckMsg, long aCheckState) {
        Browser browser = this.getBrowser(aParent);
        int length = XPCOM.strlen_PRUnichar(aDialogTitle);
        char[] dest = new char[length];
        XPCOM.memmove(dest, aDialogTitle, (long)(length * 2));
        String titleLabel = new String(dest);
        length = XPCOM.strlen_PRUnichar(aText);
        dest = new char[length];
        XPCOM.memmove(dest, aText, (long)(length * 2));
        String textLabel = new String(dest);
        length = XPCOM.strlen_PRUnichar(aCheckMsg);
        dest = new char[length];
        XPCOM.memmove(dest, aCheckMsg, (long)(length * 2));
        String checkLabel = new String(dest);
        Shell shell = browser == null ? new Shell() : browser.getShell();
        PromptDialog dialog = new PromptDialog(shell);
        int[] check = new int[1];
        if (aCheckState != 0L) {
            XPCOM.memmove(check, aCheckState, 4L);
        }
        dialog.alertCheck(titleLabel, textLabel, checkLabel, check);
        if (aCheckState != 0L) {
            XPCOM.memmove(aCheckState, check, 4L);
        }
        return 0L;
    }

    public long Confirm(long aParent, long aDialogTitle, long aText, long _retval) {
        Browser browser = this.getBrowser(aParent);
        int length = XPCOM.strlen_PRUnichar(aDialogTitle);
        char[] dest = new char[length];
        XPCOM.memmove(dest, aDialogTitle, (long)(length * 2));
        String titleLabel = new String(dest);
        length = XPCOM.strlen_PRUnichar(aText);
        dest = new char[length];
        XPCOM.memmove(dest, aText, (long)(length * 2));
        String textLabel = new String(dest);
        Shell shell = browser == null ? new Shell() : browser.getShell();
        MessageBox messageBox = new MessageBox(shell, 292);
        messageBox.setText(titleLabel);
        messageBox.setMessage(textLabel);
        int id = messageBox.open();
        int[] result = new int[]{id == 32 ? 1 : 0};
        XPCOM.memmove(_retval, result, 4L);
        return 0L;
    }

    public long ConfirmCheck(long aParent, long aDialogTitle, long aText, long aCheckMsg, long aCheckState, long _retval) {
        return -2147467263L;
    }

    public long ConfirmEx(long aParent, long aDialogTitle, long aText, long aButtonFlags, long aButton0Title, long aButton1Title, long aButton2Title, long aCheckMsg, long aCheckState, long _retval) {
        Browser browser = this.getBrowser(aParent);
        int length = XPCOM.strlen_PRUnichar(aDialogTitle);
        char[] dest = new char[length];
        XPCOM.memmove(dest, aDialogTitle, (long)(length * 2));
        String titleLabel = new String(dest);
        length = XPCOM.strlen_PRUnichar(aText);
        dest = new char[length];
        XPCOM.memmove(dest, aText, (long)(length * 2));
        String textLabel = new String(dest);
        String checkLabel = null;
        if (aCheckMsg != 0L) {
            length = XPCOM.strlen_PRUnichar(aCheckMsg);
            dest = new char[length];
            XPCOM.memmove(dest, aCheckMsg, (long)(length * 2));
            checkLabel = new String(dest);
        }
        String button0Label = this.getLabel((int)aButtonFlags, 1, aButton0Title);
        String button1Label = this.getLabel((int)aButtonFlags, 256, aButton1Title);
        String button2Label = this.getLabel((int)aButtonFlags, 65536, aButton2Title);
        int defaultIndex = 0;
        if ((aButtonFlags & 0x1000000L) != 0L) {
            defaultIndex = 1;
        } else if ((aButtonFlags & 0x2000000L) != 0L) {
            defaultIndex = 2;
        }
        Shell shell = browser == null ? new Shell() : browser.getShell();
        PromptDialog dialog = new PromptDialog(shell);
        int[] check = new int[1];
        int[] result = new int[1];
        if (aCheckState != 0L) {
            XPCOM.memmove(check, aCheckState, 4L);
        }
        dialog.confirmEx(titleLabel, textLabel, checkLabel, button0Label, button1Label, button2Label, defaultIndex, check, result);
        if (aCheckState != 0L) {
            XPCOM.memmove(aCheckState, check, 4L);
        }
        XPCOM.memmove(_retval, result, 4L);
        return 0L;
    }

    public long Prompt(long aParent, long aDialogTitle, long aText, long aValue, long aCheckMsg, long aCheckState, long _retval) {
        char[] dest;
        int length;
        Browser browser = this.getBrowser(aParent);
        String titleLabel = null;
        String checkLabel = null;
        String[] valueLabel = new String[1];
        if (aDialogTitle != 0L) {
            length = XPCOM.strlen_PRUnichar(aDialogTitle);
            dest = new char[length];
            XPCOM.memmove(dest, aDialogTitle, (long)(length * 2));
            titleLabel = new String(dest);
        }
        length = XPCOM.strlen_PRUnichar(aText);
        dest = new char[length];
        XPCOM.memmove(dest, aText, (long)(length * 2));
        String textLabel = new String(dest);
        long[] valueAddr = new long[1];
        XPCOM.memmove(valueAddr, aValue, (long)C.PTR_SIZEOF);
        if (valueAddr[0] != 0L) {
            length = XPCOM.strlen_PRUnichar(valueAddr[0]);
            dest = new char[length];
            XPCOM.memmove(dest, valueAddr[0], (long)(length * 2));
            valueLabel[0] = new String(dest);
        }
        if (aCheckMsg != 0L && (length = XPCOM.strlen_PRUnichar(aCheckMsg)) > 0) {
            dest = new char[length];
            XPCOM.memmove(dest, aCheckMsg, (long)(length * 2));
            checkLabel = new String(dest);
        }
        Shell shell = browser == null ? new Shell() : browser.getShell();
        PromptDialog dialog = new PromptDialog(shell);
        int[] check = new int[1];
        int[] result = new int[1];
        if (aCheckState != 0L) {
            XPCOM.memmove(check, aCheckState, 4L);
        }
        dialog.prompt(titleLabel, textLabel, checkLabel, valueLabel, check, result);
        XPCOM.memmove(_retval, result, 4L);
        if (result[0] == 1) {
            long[] result2 = new long[1];
            if (valueLabel[0] != null) {
                int cnt = valueLabel[0].length();
                char[] buffer = new char[cnt + 1];
                valueLabel[0].getChars(0, cnt, buffer, 0);
                int size = buffer.length * 2;
                long ptr = C.malloc(size);
                XPCOM.memmove(ptr, buffer, (long)size);
                XPCOM.memmove(aValue, new long[]{ptr}, (long)C.PTR_SIZEOF);
                if (valueAddr[0] != 0L) {
                    int rc = XPCOM.NS_GetServiceManager(result2);
                    if (rc != 0) {
                        SWT.error(rc);
                    }
                    if (result2[0] == 0L) {
                        SWT.error(-2147467262);
                    }
                    nsIServiceManager serviceManager = new nsIServiceManager(result2[0]);
                    result2[0] = 0L;
                    byte[] aContractID = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/xpcom/memory-service;1", true);
                    rc = serviceManager.GetServiceByContractID(aContractID, nsIMemory.NS_IMEMORY_IID, result2);
                    if (rc != 0) {
                        SWT.error(rc);
                    }
                    if (result2[0] == 0L) {
                        SWT.error(-2147467262);
                    }
                    serviceManager.Release();
                    nsIMemory memory = new nsIMemory(result2[0]);
                    result2[0] = 0L;
                    memory.Free(valueAddr[0]);
                    memory.Release();
                }
            }
        }
        if (aCheckState != 0L) {
            XPCOM.memmove(aCheckState, check, 4L);
        }
        return 0L;
    }

    public long PromptUsernameAndPassword(long aParent, long aDialogTitle, long aText, long aUsername, long aPassword, long aCheckMsg, long aCheckState, long _retval) {
        String titleLabel;
        char[] dest;
        int length;
        Browser browser = this.getBrowser(aParent);
        String checkLabel = null;
        String[] userLabel = new String[1];
        String[] passLabel = new String[1];
        if (aDialogTitle != 0L) {
            length = XPCOM.strlen_PRUnichar(aDialogTitle);
            dest = new char[length];
            XPCOM.memmove(dest, aDialogTitle, (long)(length * 2));
            titleLabel = new String(dest);
        } else {
            titleLabel = "";
        }
        length = XPCOM.strlen_PRUnichar(aText);
        dest = new char[length];
        XPCOM.memmove(dest, aText, (long)(length * 2));
        String textLabel = new String(dest);
        long[] userAddr = new long[1];
        XPCOM.memmove(userAddr, aUsername, (long)C.PTR_SIZEOF);
        if (userAddr[0] != 0L) {
            length = XPCOM.strlen_PRUnichar(userAddr[0]);
            dest = new char[length];
            XPCOM.memmove(dest, userAddr[0], (long)(length * 2));
            userLabel[0] = new String(dest);
        }
        long[] passAddr = new long[1];
        XPCOM.memmove(passAddr, aPassword, (long)C.PTR_SIZEOF);
        if (passAddr[0] != 0L) {
            length = XPCOM.strlen_PRUnichar(passAddr[0]);
            dest = new char[length];
            XPCOM.memmove(dest, passAddr[0], (long)(length * 2));
            passLabel[0] = new String(dest);
        }
        if (aCheckMsg != 0L && (length = XPCOM.strlen_PRUnichar(aCheckMsg)) > 0) {
            dest = new char[length];
            XPCOM.memmove(dest, aCheckMsg, (long)(length * 2));
            checkLabel = new String(dest);
        }
        Shell shell = browser == null ? new Shell() : browser.getShell();
        PromptDialog dialog = new PromptDialog(shell);
        int[] check = new int[1];
        int[] result = new int[1];
        if (aCheckState != 0L) {
            XPCOM.memmove(check, aCheckState, 4L);
        }
        dialog.promptUsernameAndPassword(titleLabel, textLabel, checkLabel, userLabel, passLabel, check, result);
        XPCOM.memmove(_retval, result, 4L);
        if (result[0] == 1) {
            nsIMemory memory;
            byte[] aContractID;
            nsIServiceManager serviceManager;
            int rc;
            long ptr;
            int size;
            char[] buffer;
            int cnt;
            long[] result2 = new long[1];
            if (userLabel[0] != null) {
                cnt = userLabel[0].length();
                buffer = new char[cnt + 1];
                userLabel[0].getChars(0, cnt, buffer, 0);
                size = buffer.length * 2;
                ptr = C.malloc(size);
                XPCOM.memmove(ptr, buffer, (long)size);
                XPCOM.memmove(aUsername, new long[]{ptr}, (long)C.PTR_SIZEOF);
                if (userAddr[0] != 0L) {
                    rc = XPCOM.NS_GetServiceManager(result2);
                    if (rc != 0) {
                        SWT.error(rc);
                    }
                    if (result2[0] == 0L) {
                        SWT.error(-2147467262);
                    }
                    serviceManager = new nsIServiceManager(result2[0]);
                    result2[0] = 0L;
                    aContractID = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/xpcom/memory-service;1", true);
                    rc = serviceManager.GetServiceByContractID(aContractID, nsIMemory.NS_IMEMORY_IID, result2);
                    if (rc != 0) {
                        SWT.error(rc);
                    }
                    if (result[0] == 0) {
                        SWT.error(-2147467262);
                    }
                    serviceManager.Release();
                    memory = new nsIMemory(result2[0]);
                    result2[0] = 0L;
                    memory.Free(userAddr[0]);
                    memory.Release();
                }
            }
            if (passLabel[0] != null) {
                cnt = passLabel[0].length();
                buffer = new char[cnt + 1];
                passLabel[0].getChars(0, cnt, buffer, 0);
                size = buffer.length * 2;
                ptr = C.malloc(size);
                XPCOM.memmove(ptr, buffer, (long)size);
                XPCOM.memmove(aPassword, new long[]{ptr}, (long)C.PTR_SIZEOF);
                if (passAddr[0] != 0L) {
                    rc = XPCOM.NS_GetServiceManager(result2);
                    if (rc != 0) {
                        SWT.error(rc);
                    }
                    if (result2[0] == 0L) {
                        SWT.error(-2147467262);
                    }
                    serviceManager = new nsIServiceManager(result2[0]);
                    result2[0] = 0L;
                    aContractID = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/xpcom/memory-service;1", true);
                    rc = serviceManager.GetServiceByContractID(aContractID, nsIMemory.NS_IMEMORY_IID, result2);
                    if (rc != 0) {
                        SWT.error(rc);
                    }
                    if (result2[0] == 0L) {
                        SWT.error(-2147467262);
                    }
                    serviceManager.Release();
                    memory = new nsIMemory(result2[0]);
                    result2[0] = 0L;
                    memory.Free(passAddr[0]);
                    memory.Release();
                }
            }
        }
        if (aCheckState != 0L) {
            XPCOM.memmove(aCheckState, check, 4L);
        }
        return 0L;
    }

    public long PromptPassword(long aParent, long aDialogTitle, long aText, long aPassword, long aCheckMsg, long aCheckState, long _retval) {
        return -2147467263L;
    }

    public long Select(long aParent, long aDialogTitle, long aText, long aCount, long aSelectList, long aOutSelection, long _retval) {
        return -2147467263L;
    }
}

