/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleFactory;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.accessibility.gtk.ATK;
import org.eclipse.swt.internal.accessibility.gtk.AtkActionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkComponentIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkSelectionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextIface;
import org.eclipse.swt.internal.accessibility.gtk.GtkAccessible;
import org.eclipse.swt.internal.gtk.GObjectClass;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

class AccessibleObject {
    long handle;
    long parentType;
    int index = -1;
    int id = -1;
    Accessible accessible;
    AccessibleObject parent;
    Hashtable children = new Hashtable(9);
    boolean isLightweight = false;
    static long actionNamePtr = -1L;
    static long descriptionPtr = -1L;
    static long keybindingPtr = -1L;
    static long namePtr = -1L;
    static final Hashtable AccessibleObjects = new Hashtable(9);
    static final long ATK_ACTION_TYPE = ATK.g_type_from_name(Converter.wcsToMbcs(null, "AtkAction", true));
    static final long ATK_COMPONENT_TYPE = ATK.g_type_from_name(Converter.wcsToMbcs(null, "AtkComponent", true));
    static final long ATK_HYPERTEXT_TYPE = ATK.g_type_from_name(Converter.wcsToMbcs(null, "AtkHypertext", true));
    static final long ATK_SELECTION_TYPE = ATK.g_type_from_name(Converter.wcsToMbcs(null, "AtkSelection", true));
    static final long ATK_TEXT_TYPE = ATK.g_type_from_name(Converter.wcsToMbcs(null, "AtkText", true));
    static final boolean DEBUG = Display.DEBUG;

    AccessibleObject(long l, long l2, Accessible accessible, long l3, boolean bl) {
        this.handle = ATK.g_object_new(l, 0L);
        this.parentType = l3;
        ATK.atk_object_initialize(this.handle, l2);
        this.accessible = accessible;
        this.isLightweight = bl;
        AccessibleObjects.put(new LONG(this.handle), this);
        if (DEBUG) {
            System.out.println("new AccessibleObject: " + this.handle);
        }
    }

    void addChild(AccessibleObject accessibleObject) {
        this.children.put(new LONG(accessibleObject.handle), accessibleObject);
        accessibleObject.setParent(this);
    }

    static long atkAction_get_keybinding(long l, long l2) {
        AccessibleListener[] accessibleListenerArray;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkAction_get_keybinding");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        long l3 = 0L;
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_ACTION_TYPE)) {
            long l4 = ATK.g_type_interface_peek_parent(ATK.ATK_ACTION_GET_IFACE(accessibleObject.handle));
            AtkActionIface atkActionIface = new AtkActionIface();
            ATK.memmove(atkActionIface, l4);
            if (atkActionIface.get_keybinding != 0L) {
                l3 = ATK.call(atkActionIface.get_keybinding, accessibleObject.handle, l2);
            }
        }
        if ((accessibleListenerArray = accessibleObject.getAccessibleListeners()).length == 0) {
            return l3;
        }
        AccessibleEvent accessibleEvent = new AccessibleEvent(accessibleObject);
        accessibleEvent.childID = accessibleObject.id;
        if (l3 != 0L) {
            int n = OS.strlen(l3);
            byte[] byArray = new byte[n];
            OS.memmove(byArray, l3, (long)n);
            accessibleEvent.result = new String(Converter.mbcsToWcs(null, byArray));
        }
        int n = 0;
        while (n < accessibleListenerArray.length) {
            accessibleListenerArray[n].getKeyboardShortcut(accessibleEvent);
            ++n;
        }
        if (accessibleEvent.result == null) {
            return l3;
        }
        if (keybindingPtr != -1L) {
            OS.g_free(keybindingPtr);
        }
        byte[] byArray = Converter.wcsToMbcs(null, accessibleEvent.result, true);
        keybindingPtr = OS.g_malloc(byArray.length);
        OS.memmove(keybindingPtr, byArray, (long)byArray.length);
        return keybindingPtr;
    }

    static long atkAction_get_name(long l, long l2) {
        AccessibleControlListener[] accessibleControlListenerArray;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkAction_get_name");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        long l3 = 0L;
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_ACTION_TYPE)) {
            long l4 = ATK.g_type_interface_peek_parent(ATK.ATK_ACTION_GET_IFACE(accessibleObject.handle));
            AtkActionIface atkActionIface = new AtkActionIface();
            ATK.memmove(atkActionIface, l4);
            if (atkActionIface.get_name != 0L) {
                l3 = ATK.call(atkActionIface.get_name, accessibleObject.handle, l2);
            }
        }
        if ((accessibleControlListenerArray = accessibleObject.getControlListeners()).length == 0) {
            return l3;
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessibleObject);
        accessibleControlEvent.childID = accessibleObject.id;
        if (l3 != 0L) {
            int n = OS.strlen(l3);
            byte[] byArray = new byte[n];
            OS.memmove(byArray, l3, (long)n);
            accessibleControlEvent.result = new String(Converter.mbcsToWcs(null, byArray));
        }
        int n = 0;
        while (n < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n].getDefaultAction(accessibleControlEvent);
            ++n;
        }
        if (accessibleControlEvent.result == null) {
            return l3;
        }
        if (actionNamePtr != -1L) {
            OS.g_free(actionNamePtr);
        }
        byte[] byArray = Converter.wcsToMbcs(null, accessibleControlEvent.result, true);
        actionNamePtr = OS.g_malloc(byArray.length);
        OS.memmove(actionNamePtr, byArray, (long)byArray.length);
        return actionNamePtr;
    }

    static long atkComponent_get_extents(long l, long l2, long l3, long l4, long l5, long l6) {
        int[] nArray;
        int[] nArray2;
        long l7;
        long l8;
        GtkAccessible gtkAccessible;
        AccessibleControlListener[] accessibleControlListenerArray;
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkComponent_get_extents");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        OS.memmove(l2, new int[1], 4L);
        OS.memmove(l3, new int[1], 4L);
        OS.memmove(l4, new int[1], 4L);
        OS.memmove(l5, new int[1], 4L);
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_COMPONENT_TYPE)) {
            long l9 = ATK.g_type_interface_peek_parent(ATK.ATK_COMPONENT_GET_IFACE(accessibleObject.handle));
            object = new AtkComponentIface();
            ATK.memmove((AtkComponentIface)object, l9);
            if (((AtkComponentIface)object).get_extents != 0L) {
                ATK.call(((AtkComponentIface)object).get_extents, accessibleObject.handle, l2, l3, l4, l5, l6);
            }
        }
        if ((accessibleControlListenerArray = accessibleObject.getControlListeners()).length == 0) {
            return 0L;
        }
        int[] nArray3 = new int[1];
        object = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        OS.memmove(nArray3, l2, 4L);
        OS.memmove((int[])object, l3, 4L);
        OS.memmove(nArray4, l4, 4L);
        OS.memmove(nArray5, l5, 4L);
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessibleObject);
        accessibleControlEvent.childID = accessibleObject.id;
        accessibleControlEvent.x = nArray3[0];
        accessibleControlEvent.y = (int)object[0];
        accessibleControlEvent.width = nArray4[0];
        accessibleControlEvent.height = nArray5[0];
        if (l6 == 1L) {
            long l10 = ATK.GTK_ACCESSIBLE(accessibleObject.handle);
            gtkAccessible = new GtkAccessible();
            ATK.memmove(gtkAccessible, l10);
            l8 = ATK.gtk_widget_get_toplevel(gtkAccessible.widget);
            l7 = OS.GTK_WIDGET_WINDOW(l8);
            nArray2 = new int[1];
            nArray = new int[1];
            OS.gdk_window_get_origin(l7, nArray2, nArray);
            accessibleControlEvent.x += nArray2[0];
            accessibleControlEvent.y += nArray[0];
        }
        int n = 0;
        while (n < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n].getLocation(accessibleControlEvent);
            ++n;
        }
        if (l6 == 1L) {
            long l11 = ATK.GTK_ACCESSIBLE(accessibleObject.handle);
            gtkAccessible = new GtkAccessible();
            ATK.memmove(gtkAccessible, l11);
            l8 = ATK.gtk_widget_get_toplevel(gtkAccessible.widget);
            l7 = OS.GTK_WIDGET_WINDOW(l8);
            nArray2 = new int[1];
            nArray = new int[1];
            OS.gdk_window_get_origin(l7, nArray2, nArray);
            accessibleControlEvent.x -= nArray2[0];
            accessibleControlEvent.y -= nArray[0];
        }
        OS.memmove(l2, new int[]{accessibleControlEvent.x}, 4L);
        OS.memmove(l3, new int[]{accessibleControlEvent.y}, 4L);
        OS.memmove(l4, new int[]{accessibleControlEvent.width}, 4L);
        OS.memmove(l5, new int[]{accessibleControlEvent.height}, 4L);
        return 0L;
    }

    static long atkComponent_get_position(long l, long l2, long l3, long l4) {
        int[] nArray;
        int[] nArray2;
        long l5;
        long l6;
        GtkAccessible gtkAccessible;
        AccessibleControlListener[] accessibleControlListenerArray;
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkComponent_get_position, object: " + l + " x: " + l2 + " y: " + l3 + " coord: " + l4);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        OS.memmove(l2, new int[1], 4L);
        OS.memmove(l3, new int[1], 4L);
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_COMPONENT_TYPE)) {
            long l7 = ATK.g_type_interface_peek_parent(ATK.ATK_COMPONENT_GET_IFACE(accessibleObject.handle));
            object = new AtkComponentIface();
            ATK.memmove((AtkComponentIface)object, l7);
            if (((AtkComponentIface)object).get_extents != 0L) {
                ATK.call(((AtkComponentIface)object).get_position, accessibleObject.handle, l2, l3, l4);
            }
        }
        if ((accessibleControlListenerArray = accessibleObject.getControlListeners()).length == 0) {
            return 0L;
        }
        int[] nArray3 = new int[1];
        object = new int[1];
        OS.memmove(nArray3, l2, 4L);
        OS.memmove((int[])object, l3, 4L);
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessibleObject);
        accessibleControlEvent.childID = accessibleObject.id;
        accessibleControlEvent.x = nArray3[0];
        accessibleControlEvent.y = (int)object[0];
        if (l4 == 1L) {
            long l8 = ATK.GTK_ACCESSIBLE(accessibleObject.handle);
            gtkAccessible = new GtkAccessible();
            ATK.memmove(gtkAccessible, l8);
            l6 = ATK.gtk_widget_get_toplevel(gtkAccessible.widget);
            l5 = OS.GTK_WIDGET_WINDOW(l6);
            nArray2 = new int[1];
            nArray = new int[1];
            OS.gdk_window_get_origin(l5, nArray2, nArray);
            accessibleControlEvent.x += nArray2[0];
            accessibleControlEvent.y += nArray[0];
        }
        int n = 0;
        while (n < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n].getLocation(accessibleControlEvent);
            ++n;
        }
        if (l4 == 1L) {
            long l9 = ATK.GTK_ACCESSIBLE(accessibleObject.handle);
            gtkAccessible = new GtkAccessible();
            ATK.memmove(gtkAccessible, l9);
            l6 = ATK.gtk_widget_get_toplevel(gtkAccessible.widget);
            l5 = OS.GTK_WIDGET_WINDOW(l6);
            nArray2 = new int[1];
            nArray = new int[1];
            OS.gdk_window_get_origin(l5, nArray2, nArray);
            accessibleControlEvent.x -= nArray2[0];
            accessibleControlEvent.y -= nArray[0];
        }
        OS.memmove(l2, new int[]{accessibleControlEvent.x}, 4L);
        OS.memmove(l3, new int[]{accessibleControlEvent.y}, 4L);
        return 0L;
    }

    static long atkComponent_get_size(long l, long l2, long l3, long l4) {
        AccessibleControlListener[] accessibleControlListenerArray;
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkComponent_get_size");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        OS.memmove(l2, new int[1], 4L);
        OS.memmove(l3, new int[1], 4L);
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_COMPONENT_TYPE)) {
            long l5 = ATK.g_type_interface_peek_parent(ATK.ATK_COMPONENT_GET_IFACE(accessibleObject.handle));
            object = new AtkComponentIface();
            ATK.memmove((AtkComponentIface)object, l5);
            if (((AtkComponentIface)object).get_extents != 0L) {
                ATK.call(((AtkComponentIface)object).get_size, accessibleObject.handle, l2, l3, l4);
            }
        }
        if ((accessibleControlListenerArray = accessibleObject.getControlListeners()).length == 0) {
            return 0L;
        }
        int[] nArray = new int[1];
        object = new int[1];
        OS.memmove(nArray, l2, 4L);
        OS.memmove((int[])object, l3, 4L);
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessibleObject);
        accessibleControlEvent.childID = accessibleObject.id;
        accessibleControlEvent.width = nArray[0];
        accessibleControlEvent.height = (int)object[0];
        int n = 0;
        while (n < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n].getLocation(accessibleControlEvent);
            ++n;
        }
        OS.memmove(l2, new int[]{accessibleControlEvent.width}, 4L);
        OS.memmove(l3, new int[]{accessibleControlEvent.height}, 4L);
        return 0L;
    }

    static long atkComponent_ref_accessible_at_point(long l, long l2, long l3, long l4) {
        AccessibleObject accessibleObject;
        AccessibleControlListener[] accessibleControlListenerArray;
        AccessibleObject accessibleObject2;
        if (DEBUG) {
            System.out.println("-->atkComponent_ref_accessible_at_point");
        }
        if ((accessibleObject2 = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        long l5 = 0L;
        if (ATK.g_type_is_a(accessibleObject2.parentType, ATK_COMPONENT_TYPE)) {
            long l6 = ATK.g_type_interface_peek_parent(ATK.ATK_COMPONENT_GET_IFACE(accessibleObject2.handle));
            AtkComponentIface atkComponentIface = new AtkComponentIface();
            ATK.memmove(atkComponentIface, l6);
            if (atkComponentIface.ref_accessible_at_point != 0L) {
                l5 = ATK.call(atkComponentIface.ref_accessible_at_point, accessibleObject2.handle, l2, l3, l4);
            }
        }
        if ((accessibleControlListenerArray = accessibleObject2.getControlListeners()).length == 0) {
            return l5;
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessibleObject2);
        accessibleControlEvent.childID = accessibleObject2.id;
        accessibleControlEvent.x = (int)l2;
        accessibleControlEvent.y = (int)l3;
        if (l4 == 1L) {
            long l7 = ATK.GTK_ACCESSIBLE(accessibleObject2.handle);
            GtkAccessible gtkAccessible = new GtkAccessible();
            ATK.memmove(gtkAccessible, l7);
            long l8 = ATK.gtk_widget_get_toplevel(gtkAccessible.widget);
            long l9 = OS.GTK_WIDGET_WINDOW(l8);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gdk_window_get_origin(l9, nArray, nArray2);
            accessibleControlEvent.x += nArray[0];
            accessibleControlEvent.y += nArray2[0];
        }
        int n = 0;
        while (n < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n].getChildAtPoint(accessibleControlEvent);
            ++n;
        }
        if (accessibleControlEvent.childID == accessibleObject2.id) {
            accessibleControlEvent.childID = -1;
        }
        if ((accessibleObject = accessibleObject2.getChildByID(accessibleControlEvent.childID)) != null) {
            if (l5 > 0L) {
                OS.g_object_unref(l5);
            }
            OS.g_object_ref(accessibleObject.handle);
            return accessibleObject.handle;
        }
        return l5;
    }

    static long atkHypertext_get_link(long l, long l2) {
        if (DEBUG) {
            System.out.println("-->atkHypertext_get_link");
        }
        return 0L;
    }

    static long atkHypertext_get_n_links(long l) {
        if (DEBUG) {
            System.out.println("-->atkHypertext_get_n_links");
        }
        return 0L;
    }

    static long atkHypertext_get_link_index(long l, long l2) {
        if (DEBUG) {
            System.out.println("-->atkHypertext_get_link_index");
        }
        return 0L;
    }

    static long atkObject_get_description(long l) {
        int n;
        AccessibleListener[] accessibleListenerArray;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkObject_get_description");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        long l2 = 0L;
        long l3 = ATK.g_type_class_peek(accessibleObject.parentType);
        AtkObjectClass atkObjectClass = new AtkObjectClass();
        ATK.memmove(atkObjectClass, l3);
        if (atkObjectClass.get_description != 0L) {
            l2 = ATK.call(atkObjectClass.get_description, accessibleObject.handle);
        }
        if ((accessibleListenerArray = accessibleObject.getAccessibleListeners()).length == 0) {
            return l2;
        }
        AccessibleEvent accessibleEvent = new AccessibleEvent(accessibleObject);
        accessibleEvent.childID = accessibleObject.id;
        if (l2 != 0L) {
            n = OS.strlen(l2);
            byte[] byArray = new byte[n];
            OS.memmove(byArray, l2, (long)n);
            accessibleEvent.result = new String(Converter.mbcsToWcs(null, byArray));
        }
        n = 0;
        while (n < accessibleListenerArray.length) {
            accessibleListenerArray[n].getDescription(accessibleEvent);
            ++n;
        }
        if (accessibleEvent.result == null) {
            return l2;
        }
        if (descriptionPtr != -1L) {
            OS.g_free(descriptionPtr);
        }
        byte[] byArray = Converter.wcsToMbcs(null, accessibleEvent.result, true);
        descriptionPtr = OS.g_malloc(byArray.length);
        OS.memmove(descriptionPtr, byArray, (long)byArray.length);
        return descriptionPtr;
    }

    static long atkObject_get_name(long l) {
        int n;
        AccessibleListener[] accessibleListenerArray;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkObject_get_name: " + l);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        long l2 = 0L;
        long l3 = ATK.g_type_class_peek(accessibleObject.parentType);
        AtkObjectClass atkObjectClass = new AtkObjectClass();
        ATK.memmove(atkObjectClass, l3);
        if (atkObjectClass.get_name != 0L) {
            l2 = ATK.call(atkObjectClass.get_name, accessibleObject.handle);
        }
        if ((accessibleListenerArray = accessibleObject.getAccessibleListeners()).length == 0) {
            return l2;
        }
        AccessibleEvent accessibleEvent = new AccessibleEvent(accessibleObject);
        accessibleEvent.childID = accessibleObject.id;
        if (l2 != 0L) {
            n = OS.strlen(l2);
            byte[] byArray = new byte[n];
            OS.memmove(byArray, l2, (long)n);
            accessibleEvent.result = new String(Converter.mbcsToWcs(null, byArray));
        }
        n = 0;
        while (n < accessibleListenerArray.length) {
            accessibleListenerArray[n].getName(accessibleEvent);
            ++n;
        }
        if (accessibleEvent.result == null) {
            return l2;
        }
        if (namePtr != -1L) {
            OS.g_free(namePtr);
        }
        byte[] byArray = Converter.wcsToMbcs(null, accessibleEvent.result, true);
        namePtr = OS.g_malloc(byArray.length);
        OS.memmove(namePtr, byArray, (long)byArray.length);
        return namePtr;
    }

    static long atkObject_get_n_children(long l) {
        AccessibleControlListener[] accessibleControlListenerArray;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkObject_get_n_children: " + l);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        long l2 = 0L;
        long l3 = ATK.g_type_class_peek(accessibleObject.parentType);
        AtkObjectClass atkObjectClass = new AtkObjectClass();
        ATK.memmove(atkObjectClass, l3);
        if (atkObjectClass.get_n_children != 0L) {
            l2 = ATK.call(atkObjectClass.get_n_children, accessibleObject.handle);
        }
        if ((accessibleControlListenerArray = accessibleObject.getControlListeners()).length == 0) {
            return l2;
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessibleObject);
        accessibleControlEvent.childID = accessibleObject.id;
        accessibleControlEvent.detail = (int)l2;
        int n = 0;
        while (n < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n].getChildCount(accessibleControlEvent);
            ++n;
        }
        return accessibleControlEvent.detail;
    }

    static long atkObject_get_index_in_parent(long l) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkObjectCB_get_index_in_parent.  ");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        if (accessibleObject.index != -1) {
            return accessibleObject.index;
        }
        long l2 = ATK.g_type_class_peek(accessibleObject.parentType);
        AtkObjectClass atkObjectClass = new AtkObjectClass();
        ATK.memmove(atkObjectClass, l2);
        if (atkObjectClass.get_index_in_parent == 0L) {
            return 0L;
        }
        return ATK.call(atkObjectClass.get_index_in_parent, accessibleObject.handle);
    }

    static long atkObject_get_parent(long l) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkObject_get_parent: " + l);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        if (accessibleObject.parent != null) {
            return accessibleObject.parent.handle;
        }
        long l2 = ATK.g_type_class_peek(accessibleObject.parentType);
        AtkObjectClass atkObjectClass = new AtkObjectClass();
        ATK.memmove(atkObjectClass, l2);
        if (atkObjectClass.get_parent == 0L) {
            return 0L;
        }
        return ATK.call(atkObjectClass.get_parent, accessibleObject.handle);
    }

    static long atkObject_get_role(long l) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkObject_get_role: " + l);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        if (accessibleObject.getAccessibleListeners().length != 0) {
            AccessibleControlListener[] accessibleControlListenerArray = accessibleObject.getControlListeners();
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessibleObject);
            accessibleControlEvent.childID = accessibleObject.id;
            accessibleControlEvent.detail = -1;
            int n = 0;
            while (n < accessibleControlListenerArray.length) {
                accessibleControlListenerArray[n].getRole(accessibleControlEvent);
                ++n;
            }
            if (accessibleControlEvent.detail != -1) {
                switch (accessibleControlEvent.detail) {
                    case 44: {
                        return 7L;
                    }
                    case 10: {
                        return 18L;
                    }
                    case 46: {
                        return 11L;
                    }
                    case 18: {
                        return 16L;
                    }
                    case 41: {
                        return 28L;
                    }
                    case 30: {
                        return 60L;
                    }
                    case 33: {
                        return 30L;
                    }
                    case 34: {
                        return 31L;
                    }
                    case 11: {
                        return 32L;
                    }
                    case 2: {
                        return 33L;
                    }
                    case 12: {
                        return 34L;
                    }
                    case 48: {
                        return 41L;
                    }
                    case 43: {
                        return 42L;
                    }
                    case 3: {
                        return 47L;
                    }
                    case 21: {
                        return 49L;
                    }
                    case 51: {
                        return 50L;
                    }
                    case 24: {
                        return 54L;
                    }
                    case 29: {
                        return 55L;
                    }
                    case 25: {
                        return 56L;
                    }
                    case 26: {
                        return 57L;
                    }
                    case 60: {
                        return 37L;
                    }
                    case 37: {
                        return 36L;
                    }
                    case 42: {
                        return 60L;
                    }
                    case 22: {
                        return 62L;
                    }
                    case 13: {
                        return 63L;
                    }
                    case 35: {
                        return 64L;
                    }
                    case 36: {
                        return 31L;
                    }
                    case 45: {
                        return 43L;
                    }
                    case 9: {
                        return 68L;
                    }
                }
            }
        }
        long l2 = ATK.g_type_class_peek(accessibleObject.parentType);
        AtkObjectClass atkObjectClass = new AtkObjectClass();
        ATK.memmove(atkObjectClass, l2);
        if (atkObjectClass.get_role == 0L) {
            return 0L;
        }
        return ATK.call(atkObjectClass.get_role, accessibleObject.handle);
    }

    static long atkObject_ref_child(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkObject_ref_child: " + l2 + " of: " + l);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        accessibleObject.updateChildren();
        AccessibleObject accessibleObject2 = accessibleObject.getChildByIndex((int)l2);
        if (accessibleObject2 != null) {
            OS.g_object_ref(accessibleObject2.handle);
            return accessibleObject2.handle;
        }
        long l3 = ATK.g_type_class_peek(accessibleObject.parentType);
        AtkObjectClass atkObjectClass = new AtkObjectClass();
        ATK.memmove(atkObjectClass, l3);
        if (atkObjectClass.ref_child == 0L) {
            return 0L;
        }
        return ATK.call(atkObjectClass.ref_child, accessibleObject.handle, l2);
    }

    static long atkObject_ref_state_set(long l) {
        AccessibleControlListener[] accessibleControlListenerArray;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkObject_ref_state_set");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        long l2 = 0L;
        long l3 = ATK.g_type_class_peek(accessibleObject.parentType);
        AtkObjectClass atkObjectClass = new AtkObjectClass();
        ATK.memmove(atkObjectClass, l3);
        if (atkObjectClass.ref_state_set != 0L) {
            l2 = ATK.call(atkObjectClass.ref_state_set, accessibleObject.handle);
        }
        if ((accessibleControlListenerArray = accessibleObject.getControlListeners()).length == 0) {
            return l2;
        }
        long l4 = l2;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessibleObject);
        accessibleControlEvent.childID = accessibleObject.id;
        accessibleControlEvent.detail = -1;
        int n = 0;
        while (n < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n].getState(accessibleControlEvent);
            ++n;
        }
        if (accessibleControlEvent.detail != -1) {
            n = accessibleControlEvent.detail;
            if ((n & 0x800) != 0) {
                ATK.atk_state_set_add_state(l4, 3);
            }
            if ((n & 0x10) != 0) {
                ATK.atk_state_set_add_state(l4, 4);
            }
            if ((n & 0x200) != 0) {
                ATK.atk_state_set_add_state(l4, 9);
            }
            if ((n & 0x100000) != 0) {
                ATK.atk_state_set_add_state(l4, 10);
            }
            if ((n & 4) != 0) {
                ATK.atk_state_set_add_state(l4, 11);
            }
            if ((n & 0x80) != 0) {
                ATK.atk_state_set_add_state(l4, 2);
            }
            if ((n & 0x8000) == 0) {
                ATK.atk_state_set_add_state(l4, 28);
            }
            if ((n & 0x1000000) != 0) {
                ATK.atk_state_set_add_state(l4, 16);
            }
            if ((n & 0x10000) == 0) {
                ATK.atk_state_set_add_state(l4, 23);
            }
            if ((n & 8) != 0) {
                ATK.atk_state_set_add_state(l4, 18);
            }
            if ((n & 0x40) == 0) {
                ATK.atk_state_set_add_state(l4, 6);
            }
            if ((n & 0x200000) != 0) {
                ATK.atk_state_set_add_state(l4, 20);
            }
            if ((n & 2) != 0) {
                ATK.atk_state_set_add_state(l4, 21);
            }
            if ((n & 0x20000) != 0) {
                ATK.atk_state_set_add_state(l4, 19);
            }
        }
        return l4;
    }

    static long atkSelection_is_child_selected(long l, long l2) {
        AccessibleControlListener[] accessibleControlListenerArray;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkSelection_is_child_selected");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        long l3 = 0L;
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_SELECTION_TYPE)) {
            long l4 = ATK.g_type_interface_peek_parent(ATK.ATK_SELECTION_GET_IFACE(accessibleObject.handle));
            AtkSelectionIface atkSelectionIface = new AtkSelectionIface();
            ATK.memmove(atkSelectionIface, l4);
            if (atkSelectionIface.is_child_selected != 0L) {
                l3 = ATK.call(atkSelectionIface.is_child_selected, accessibleObject.handle, l2);
            }
        }
        if ((accessibleControlListenerArray = accessibleObject.getControlListeners()).length == 0) {
            return l3;
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessibleObject);
        accessibleControlEvent.childID = accessibleObject.id;
        int n = 0;
        while (n < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n].getSelection(accessibleControlEvent);
            ++n;
        }
        AccessibleObject accessibleObject2 = accessibleObject.getChildByID(accessibleControlEvent.childID);
        if (accessibleObject2 != null) {
            return (long)accessibleObject2.index == l2 ? 1 : 0;
        }
        return l3;
    }

    static long atkSelection_ref_selection(long l, long l2) {
        AccessibleControlListener[] accessibleControlListenerArray;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkSelection_ref_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        long l3 = 0L;
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_SELECTION_TYPE)) {
            long l4 = ATK.g_type_interface_peek_parent(ATK.ATK_SELECTION_GET_IFACE(accessibleObject.handle));
            AtkSelectionIface atkSelectionIface = new AtkSelectionIface();
            ATK.memmove(atkSelectionIface, l4);
            if (atkSelectionIface.ref_selection != 0L) {
                l3 = ATK.call(atkSelectionIface.ref_selection, accessibleObject.handle, l2);
            }
        }
        if ((accessibleControlListenerArray = accessibleObject.getControlListeners()).length == 0) {
            return l3;
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessibleObject);
        accessibleControlEvent.childID = accessibleObject.id;
        int n = 0;
        while (n < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n].getSelection(accessibleControlEvent);
            ++n;
        }
        AccessibleObject accessibleObject2 = accessibleObject.getChildByID(accessibleControlEvent.childID);
        if (accessibleObject2 != null) {
            if (l3 > 0L) {
                OS.g_object_unref(l3);
            }
            OS.g_object_ref(accessibleObject2.handle);
            return accessibleObject2.handle;
        }
        return l3;
    }

    static long atkText_get_caret_offset(long l) {
        AccessibleTextListener[] accessibleTextListenerArray;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkText_get_caret_offset");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        long l2 = 0L;
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_TEXT_TYPE)) {
            long l3 = ATK.g_type_interface_peek_parent(ATK.ATK_TEXT_GET_IFACE(accessibleObject.handle));
            AtkTextIface atkTextIface = new AtkTextIface();
            ATK.memmove(atkTextIface, l3);
            if (atkTextIface.get_caret_offset != 0L) {
                l2 = ATK.call(atkTextIface.get_caret_offset, accessibleObject.handle);
            }
        }
        if ((accessibleTextListenerArray = accessibleObject.getTextListeners()).length == 0) {
            return l2;
        }
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessibleObject);
        accessibleTextEvent.childID = accessibleObject.id;
        accessibleTextEvent.offset = (int)l2;
        int n = 0;
        while (n < accessibleTextListenerArray.length) {
            accessibleTextListenerArray[n].getCaretOffset(accessibleTextEvent);
            ++n;
        }
        return accessibleTextEvent.offset;
    }

    static long atkText_get_character_at_offset(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkText_get_character_at_offset");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        String string = accessibleObject.getText();
        if (string != null) {
            return string.charAt((int)l2);
        }
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_TEXT_TYPE)) {
            long l3 = ATK.g_type_class_peek(accessibleObject.parentType);
            AtkTextIface atkTextIface = new AtkTextIface();
            ATK.memmove(atkTextIface, l3);
            if (atkTextIface.get_character_at_offset != 0L) {
                return ATK.call(atkTextIface.get_character_at_offset, accessibleObject.handle, l2);
            }
        }
        return 0L;
    }

    static long atkText_get_character_count(long l) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkText_get_character_count");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        String string = accessibleObject.getText();
        if (string != null) {
            return string.length();
        }
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_TEXT_TYPE)) {
            long l2 = ATK.g_type_class_peek(accessibleObject.parentType);
            AtkTextIface atkTextIface = new AtkTextIface();
            ATK.memmove(atkTextIface, l2);
            if (atkTextIface.get_character_count != 0L) {
                return ATK.call(atkTextIface.get_character_count, accessibleObject.handle);
            }
        }
        return 0L;
    }

    static long atkText_get_n_selections(long l) {
        AccessibleTextListener[] accessibleTextListenerArray;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkText_get_n_selections");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        long l2 = 0L;
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_TEXT_TYPE)) {
            long l3 = ATK.g_type_interface_peek_parent(ATK.ATK_TEXT_GET_IFACE(accessibleObject.handle));
            AtkTextIface atkTextIface = new AtkTextIface();
            ATK.memmove(atkTextIface, l3);
            if (atkTextIface.get_n_selections != 0L) {
                l2 = ATK.call(atkTextIface.get_n_selections, accessibleObject.handle);
            }
        }
        if ((accessibleTextListenerArray = accessibleObject.getTextListeners()).length == 0) {
            return l2;
        }
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessibleObject);
        accessibleTextEvent.childID = accessibleObject.id;
        int n = 0;
        while (n < accessibleTextListenerArray.length) {
            accessibleTextListenerArray[n].getSelectionRange(accessibleTextEvent);
            ++n;
        }
        return accessibleTextEvent.length == 0 ? l2 : 1L;
    }

    static long atkText_get_selection(long l, long l2, long l3, long l4) {
        AccessibleTextListener[] accessibleTextListenerArray;
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkText_get_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        OS.memmove(l3, new int[1], 4L);
        OS.memmove(l4, new int[1], 4L);
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_TEXT_TYPE)) {
            long l5 = ATK.g_type_interface_peek_parent(ATK.ATK_TEXT_GET_IFACE(accessibleObject.handle));
            object = new AtkTextIface();
            ATK.memmove((AtkTextIface)object, l5);
            if (((AtkTextIface)object).get_selection != 0L) {
                ATK.call(((AtkTextIface)object).get_selection, accessibleObject.handle, l2, l3, l4);
            }
        }
        if ((accessibleTextListenerArray = accessibleObject.getTextListeners()).length == 0) {
            return 0L;
        }
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessibleObject);
        accessibleTextEvent.childID = accessibleObject.id;
        object = new int[1];
        int[] nArray = new int[1];
        OS.memmove((int[])object, l3, 4L);
        OS.memmove(nArray, l4, 4L);
        accessibleTextEvent.offset = (int)object[0];
        accessibleTextEvent.length = nArray[0] - object[0];
        int n = 0;
        while (n < accessibleTextListenerArray.length) {
            accessibleTextListenerArray[n].getSelectionRange(accessibleTextEvent);
            ++n;
        }
        OS.memmove(l3, new int[]{accessibleTextEvent.offset}, 4L);
        OS.memmove(l4, new int[]{accessibleTextEvent.offset + accessibleTextEvent.length}, 4L);
        return 0L;
    }

    static long atkText_get_text(long l, long l2, long l3) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkText_get_text: " + l2 + "," + l3);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        String string = accessibleObject.getText();
        if (string.length() > 0) {
            l3 = l3 == -1L ? (long)string.length() : Math.min(l3, (long)string.length());
            l2 = Math.min(l2, l3);
            string = string.substring((int)l2, (int)l3);
            byte[] byArray = Converter.wcsToMbcs(null, string, true);
            long l4 = OS.g_malloc(byArray.length);
            OS.memmove(l4, byArray, (long)byArray.length);
            return l4;
        }
        return 0L;
    }

    static long atkText_get_text_after_offset(long l, long l2, long l3, long l4, long l5) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkText_get_text_after_offset");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        int n = (int)l2;
        String string = accessibleObject.getText();
        if (string.length() > 0) {
            int n2 = string.length();
            int n3 = n = Math.min(n, n2 - 1);
            int n4 = n;
            switch ((int)l3) {
                case 0: {
                    if (n2 <= n) break;
                    break;
                }
                case 1: {
                    int n5 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n - 1);
                    if (n5 == -1) {
                        n3 = n4 = n2;
                        break;
                    }
                    if ((n5 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n5)) == n2) {
                        n3 = n4 = n2;
                        break;
                    }
                    n3 = n5;
                    int n6 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n5);
                    if (n6 == -1) {
                        n4 = n2;
                        break;
                    }
                    n4 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n6);
                    break;
                }
                case 2: {
                    int n5 = AccessibleObject.previousIndexOfNotChar(string, " \n", n);
                    if (n5 == -1 || n5 != n - 1) {
                        n = AccessibleObject.nextIndexOfNotChar(string, " \n", n);
                    }
                    if (n == -1) {
                        n3 = n4 = n2;
                        break;
                    }
                    int n6 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n);
                    if (n6 == -1) {
                        n3 = n4 = n2;
                        break;
                    }
                    if ((n6 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n6)) == n2) {
                        n3 = n4 = n2;
                        break;
                    }
                    n3 = n6;
                    int n7 = AccessibleObject.nextIndexOfNotChar(string, " \n", n6);
                    if (n7 == n2) {
                        n3 = n4 = n2;
                        break;
                    }
                    if ((n7 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n7)) == -1) {
                        n4 = n2;
                        break;
                    }
                    n4 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n7);
                    break;
                }
                case 3: {
                    int n5 = AccessibleObject.previousIndexOfChar(string, "!?.", n);
                    int n6 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n);
                    int n8 = 0;
                    if (n5 >= n6) {
                        n8 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n);
                    } else {
                        n8 = AccessibleObject.nextIndexOfChar(string, "!?.", n);
                        if (n8 == -1) {
                            n3 = n4 = n2;
                            break;
                        }
                        n8 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n8);
                    }
                    if (n8 == n2) {
                        n3 = n4 = n2;
                        break;
                    }
                    n3 = n8;
                    int n9 = AccessibleObject.nextIndexOfChar(string, "!?.", n8);
                    if (n9 == -1) {
                        n4 = n2;
                        break;
                    }
                    n4 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n9);
                    break;
                }
                case 4: {
                    int n5 = AccessibleObject.nextIndexOfChar(string, "!?.", n);
                    if (n5 == -1) {
                        n3 = n4 = n2;
                        break;
                    }
                    if ((n5 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n5)) == n2) {
                        n3 = n4 = n2;
                        break;
                    }
                    n3 = n5;
                    int n6 = AccessibleObject.nextIndexOfNotChar(string, " \n", n5);
                    if (n6 == n2) {
                        n3 = n4 = n2;
                        break;
                    }
                    if ((n6 = AccessibleObject.nextIndexOfChar(string, "!?.", n6)) == -1) {
                        n4 = n2;
                        break;
                    }
                    n4 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n6);
                    break;
                }
                case 5: {
                    int n5 = string.indexOf(10, n - 1);
                    if (n5 == -1) {
                        n3 = n4 = n2;
                        break;
                    }
                    if ((n5 = AccessibleObject.nextIndexOfNotChar(string, "\n", n5)) == n2) {
                        n3 = n4 = n2;
                        break;
                    }
                    n3 = n5;
                    int n6 = string.indexOf(10, n5);
                    if (n6 == -1) {
                        n4 = n2;
                        break;
                    }
                    n4 = n6 = AccessibleObject.nextIndexOfNotChar(string, "\n", n6);
                    break;
                }
                case 6: {
                    int n6;
                    int n5 = AccessibleObject.nextIndexOfChar(string, "\n", n);
                    if (n5 == -1) {
                        n3 = n4 = n2;
                        break;
                    }
                    n3 = n5;
                    n4 = n3 == n2 ? n2 : ((n6 = AccessibleObject.nextIndexOfChar(string, "\n", n5 + 1)) == -1 ? n2 : n6);
                }
            }
            OS.memmove(l4, new int[]{n3}, 4L);
            OS.memmove(l5, new int[]{++n4}, 4L);
            string = string.substring(n3, n4);
            byte[] byArray = Converter.wcsToMbcs(null, string, true);
            long l6 = OS.g_malloc(byArray.length);
            OS.memmove(l6, byArray, (long)byArray.length);
            return l6;
        }
        return 0L;
    }

    static long atkText_get_text_at_offset(long l, long l2, long l3, long l4, long l5) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkText_get_text_at_offset: " + l2 + " start: " + l4 + " end: " + l5);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        int n = (int)l2;
        String string = accessibleObject.getText();
        if (string.length() > 0) {
            int n2 = string.length();
            int n3 = n = Math.min(n, n2 - 1);
            int n4 = n;
            switch ((int)l3) {
                case 0: {
                    if (n2 <= n) break;
                    break;
                }
                case 1: {
                    int n5 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n);
                    if (n5 == -1) {
                        n4 = 0;
                        n3 = 0;
                        break;
                    }
                    if ((n5 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n5) + 1) == -1) {
                        n3 = 0;
                        break;
                    }
                    n3 = n5;
                    int n6 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n5);
                    n4 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n6);
                    break;
                }
                case 2: {
                    int n5 = AccessibleObject.previousIndexOfNotChar(string, "!?.", n + 1);
                    n5 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n5);
                    n5 = AccessibleObject.previousIndexOfNotChar(string, " \n", n5 + 1);
                    if (n5 == -1) {
                        n4 = 0;
                        n3 = 0;
                        break;
                    }
                    n3 = n5 + 1;
                    int n6 = AccessibleObject.nextIndexOfNotChar(string, " \n", n3);
                    if (n6 == n2) {
                        n4 = n3;
                        break;
                    }
                    if ((n6 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n6)) == -1) {
                        n4 = n3;
                        break;
                    }
                    n4 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n6);
                    break;
                }
                case 3: {
                    int n5 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n + 1);
                    if (n5 == -1) {
                        n4 = 0;
                        n3 = 0;
                        break;
                    }
                    n5 = AccessibleObject.previousIndexOfChar(string, "!?.", n5) + 1;
                    n3 = AccessibleObject.nextIndexOfNotChar(string, " \n", n5);
                    int n6 = AccessibleObject.nextIndexOfChar(string, "!?.", n3);
                    n4 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n6);
                    break;
                }
                case 4: {
                    int n5 = AccessibleObject.previousIndexOfNotChar(string, "!?.", n + 1);
                    n5 = AccessibleObject.previousIndexOfChar(string, "!?.", n5);
                    n5 = AccessibleObject.previousIndexOfNotChar(string, " \n", n5 + 1);
                    if (n5 == -1) {
                        n4 = 0;
                        n3 = 0;
                        break;
                    }
                    n3 = n5 + 1;
                    int n6 = AccessibleObject.nextIndexOfNotChar(string, " \n", n3);
                    if (n6 == n2) {
                        n4 = n3;
                        break;
                    }
                    if ((n6 = AccessibleObject.nextIndexOfChar(string, "!?.", n6)) == -1) {
                        n4 = n3;
                        break;
                    }
                    n4 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n6);
                    break;
                }
                case 5: {
                    n3 = AccessibleObject.previousIndexOfChar(string, "\n", n) + 1;
                    int n5 = AccessibleObject.nextIndexOfChar(string, "\n", n3);
                    if (n5 < n2) {
                        ++n5;
                    }
                    n4 = n5;
                    break;
                }
                case 6: {
                    int n5 = AccessibleObject.previousIndexOfChar(string, "\n", n);
                    if (n5 == -1) {
                        n4 = 0;
                        n3 = 0;
                        break;
                    }
                    n3 = n5;
                    n4 = AccessibleObject.nextIndexOfChar(string, "\n", n5 + 1);
                }
            }
            OS.memmove(l4, new int[]{n3}, 4L);
            OS.memmove(l5, new int[]{++n4}, 4L);
            string = string.substring(n3, n4);
            byte[] byArray = Converter.wcsToMbcs(null, string, true);
            long l6 = OS.g_malloc(byArray.length);
            OS.memmove(l6, byArray, (long)byArray.length);
            return l6;
        }
        return 0L;
    }

    static long atkText_get_text_before_offset(long l, long l2, long l3, long l4, long l5) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkText_get_text_before_offset");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) == null) {
            return 0L;
        }
        int n = (int)l2;
        String string = accessibleObject.getText();
        if (string.length() > 0) {
            int n2 = string.length();
            int n3 = n = Math.min(n, n2 - 1);
            int n4 = n;
            switch ((int)l3) {
                case 0: {
                    if (n2 < n || n <= 0) break;
                    break;
                }
                case 1: {
                    int n5 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n - 1);
                    if (n5 == -1) {
                        n4 = 0;
                        n3 = 0;
                        break;
                    }
                    int n6 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n5);
                    if (n6 == -1) {
                        n4 = 0;
                        n3 = 0;
                        break;
                    }
                    n4 = n5 + 1;
                    n3 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n6) + 1;
                    break;
                }
                case 2: {
                    int n5 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n);
                    if (n5 == -1) {
                        n4 = 0;
                        n3 = 0;
                        break;
                    }
                    if ((n5 = AccessibleObject.previousIndexOfNotChar(string, " \n", n5 + 1)) == -1) {
                        n4 = 0;
                        n3 = 0;
                        break;
                    }
                    n4 = n5 + 1;
                    int n6 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n4);
                    if ((n6 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n6)) == -1) {
                        n3 = 0;
                        break;
                    }
                    n3 = AccessibleObject.previousIndexOfNotChar(string, " \n", n6 + 1) + 1;
                    break;
                }
                case 3: {
                    int n5 = AccessibleObject.previousIndexOfChar(string, "!?.", n);
                    if (n5 == -1) {
                        n4 = 0;
                        n3 = 0;
                        break;
                    }
                    int n6 = AccessibleObject.previousIndexOfNotChar(string, "!?.", n5);
                    if (n6 == -1) {
                        n4 = 0;
                        n3 = 0;
                        break;
                    }
                    n4 = n5 + 1;
                    n3 = AccessibleObject.previousIndexOfChar(string, "!?.", n6) + 1;
                    break;
                }
                case 4: {
                    int n5 = AccessibleObject.previousIndexOfChar(string, "!?.", n);
                    if (n5 == -1) {
                        n4 = 0;
                        n3 = 0;
                        break;
                    }
                    if ((n5 = AccessibleObject.previousIndexOfNotChar(string, " \n", n5 + 1)) == -1) {
                        n4 = 0;
                        n3 = 0;
                        break;
                    }
                    n4 = n5 + 1;
                    int n6 = AccessibleObject.previousIndexOfNotChar(string, "!?.", n4);
                    if ((n6 = AccessibleObject.previousIndexOfChar(string, "!?.", n6)) == -1) {
                        n3 = 0;
                        break;
                    }
                    n3 = AccessibleObject.previousIndexOfNotChar(string, " \n", n6 + 1) + 1;
                    break;
                }
                case 5: {
                    int n5 = AccessibleObject.previousIndexOfChar(string, "\n", n);
                    if (n5 == -1) {
                        n4 = 0;
                        n3 = 0;
                        break;
                    }
                    n4 = n5 + 1;
                    n3 = AccessibleObject.previousIndexOfChar(string, "\n", n5) + 1;
                    break;
                }
                case 6: {
                    int n5 = AccessibleObject.previousIndexOfChar(string, "\n", n);
                    if (n5 == -1) {
                        n4 = 0;
                        n3 = 0;
                        break;
                    }
                    n4 = n5;
                    n3 = AccessibleObject.previousIndexOfChar(string, "\n", n5);
                    if (n3 != -1) break;
                    n3 = 0;
                }
            }
            OS.memmove(l4, new int[]{--n3}, 4L);
            OS.memmove(l5, new int[]{n4}, 4L);
            string = string.substring(n3, n4);
            byte[] byArray = Converter.wcsToMbcs(null, string, true);
            long l6 = OS.g_malloc(byArray.length);
            OS.memmove(l6, byArray, (long)byArray.length);
            return l6;
        }
        return 0L;
    }

    AccessibleListener[] getAccessibleListeners() {
        if (this.accessible == null) {
            return new AccessibleListener[0];
        }
        AccessibleListener[] accessibleListenerArray = this.accessible.getAccessibleListeners();
        return accessibleListenerArray != null ? accessibleListenerArray : new AccessibleListener[]{};
    }

    static AccessibleObject getAccessibleObject(long l) {
        return (AccessibleObject)AccessibleObjects.get(new LONG(l));
    }

    AccessibleObject getChildByHandle(long l) {
        return (AccessibleObject)this.children.get(new LONG(l));
    }

    AccessibleObject getChildByID(int n) {
        if (n == -1) {
            return this;
        }
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            AccessibleObject accessibleObject = (AccessibleObject)enumeration.nextElement();
            if (accessibleObject.id != n) continue;
            return accessibleObject;
        }
        return null;
    }

    AccessibleObject getChildByIndex(int n) {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            AccessibleObject accessibleObject = (AccessibleObject)enumeration.nextElement();
            if (accessibleObject.index != n) continue;
            return accessibleObject;
        }
        return null;
    }

    AccessibleControlListener[] getControlListeners() {
        if (this.accessible == null) {
            return new AccessibleControlListener[0];
        }
        AccessibleControlListener[] accessibleControlListenerArray = this.accessible.getControlListeners();
        return accessibleControlListenerArray != null ? accessibleControlListenerArray : new AccessibleControlListener[]{};
    }

    String getText() {
        AccessibleControlListener[] accessibleControlListenerArray;
        long l = 0L;
        String string = "";
        if (ATK.g_type_is_a(this.parentType, ATK_TEXT_TYPE)) {
            long l2 = ATK.g_type_interface_peek_parent(ATK.ATK_TEXT_GET_IFACE(this.handle));
            AtkTextIface atkTextIface = new AtkTextIface();
            ATK.memmove(atkTextIface, l2);
            long l3 = 0L;
            if (atkTextIface.get_character_count != 0L) {
                l3 = ATK.call(atkTextIface.get_character_count, this.handle);
            }
            if (l3 > 0L && atkTextIface.get_text != 0L && (l = ATK.call(atkTextIface.get_text, this.handle, 0L, l3)) != 0L) {
                int n = OS.strlen(l);
                byte[] byArray = new byte[n];
                OS.memmove(byArray, l, (long)n);
                string = new String(Converter.mbcsToWcs(null, byArray));
            }
        }
        if ((accessibleControlListenerArray = this.getControlListeners()).length == 0) {
            return string;
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = this.id;
        accessibleControlEvent.result = string;
        int n = 0;
        while (n < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n].getValue(accessibleControlEvent);
            ++n;
        }
        return accessibleControlEvent.result;
    }

    AccessibleTextListener[] getTextListeners() {
        if (this.accessible == null) {
            return new AccessibleTextListener[0];
        }
        AccessibleTextListener[] accessibleTextListenerArray = this.accessible.getTextListeners();
        return accessibleTextListenerArray != null ? accessibleTextListenerArray : new AccessibleTextListener[]{};
    }

    static long gObjectClass_finalize(long l) {
        long l2 = ATK.g_type_class_peek_parent(ATK.G_OBJECT_GET_CLASS(l));
        long l3 = ATK.G_OBJECT_CLASS(l2);
        GObjectClass gObjectClass = new GObjectClass();
        ATK.memmove(gObjectClass, l3);
        ATK.call(gObjectClass.finalize, l);
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        if (accessibleObject != null) {
            AccessibleObjects.remove(new LONG(l));
            accessibleObject.release();
        }
        return 0L;
    }

    static int nextIndexOfChar(String string, String string2, int n) {
        int n2 = string.length();
        int n3 = 0;
        while (n3 < string2.length()) {
            char c = string2.charAt(n3);
            int n4 = string.indexOf(c, n);
            if (n4 != -1) {
                n2 = Math.min(n2, n4);
            }
            ++n3;
        }
        return n2;
    }

    static int nextIndexOfNotChar(String string, String string2, int n) {
        int n2 = string.length();
        int n3 = n;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (string2.indexOf(c) == -1) break;
            ++n3;
        }
        return n3;
    }

    static int previousIndexOfChar(String string, String string2, int n) {
        int n2 = -1;
        if (n < 0) {
            return n2;
        }
        string = string.substring(0, n);
        int n3 = 0;
        while (n3 < string2.length()) {
            char c = string2.charAt(n3);
            int n4 = string.lastIndexOf(c);
            if (n4 != -1) {
                n2 = Math.max(n2, n4);
            }
            ++n3;
        }
        return n2;
    }

    static int previousIndexOfNotChar(String string, String string2, int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            char c = string.charAt(n2);
            if (string2.indexOf(c) == -1) break;
            --n2;
        }
        return n2;
    }

    void release() {
        if (DEBUG) {
            System.out.println("AccessibleObject.release: " + this.handle);
        }
        this.accessible = null;
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            AccessibleObject accessibleObject = (AccessibleObject)enumeration.nextElement();
            if (!accessibleObject.isLightweight) continue;
            OS.g_object_unref(accessibleObject.handle);
        }
        if (this.parent != null) {
            this.parent.removeChild(this, false);
        }
    }

    void removeChild(AccessibleObject accessibleObject, boolean bl) {
        this.children.remove(new LONG(accessibleObject.handle));
        if (bl && accessibleObject.isLightweight) {
            OS.g_object_unref(accessibleObject.handle);
        }
    }

    void selectionChanged() {
        OS.g_signal_emit_by_name(this.handle, ATK.selection_changed);
    }

    void setFocus(int n) {
        this.updateChildren();
        AccessibleObject accessibleObject = this.getChildByID(n);
        if (accessibleObject != null) {
            ATK.atk_focus_tracker_notify(accessibleObject.handle);
        }
    }

    void setParent(AccessibleObject accessibleObject) {
        this.parent = accessibleObject;
    }

    void textCaretMoved(int n) {
        OS.g_signal_emit_by_name(this.handle, ATK.text_caret_moved, n);
    }

    void textChanged(int n, int n2, int n3) {
        if (n == 1) {
            OS.g_signal_emit_by_name(this.handle, ATK.text_changed_delete, n2, n3);
        } else {
            OS.g_signal_emit_by_name(this.handle, ATK.text_changed_insert, n2, n3);
        }
    }

    void textSelectionChanged() {
        OS.g_signal_emit_by_name(this.handle, ATK.text_selection_changed);
    }

    void updateChildren() {
        if (this.isLightweight) {
            return;
        }
        AccessibleControlListener[] accessibleControlListenerArray = this.getControlListeners();
        if (accessibleControlListenerArray.length == 0) {
            return;
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        int n = 0;
        while (n < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n].getChildren(accessibleControlEvent);
            ++n;
        }
        if (accessibleControlEvent.children != null && accessibleControlEvent.children.length > 0) {
            Vector<LONG> vector = new Vector<LONG>(this.children.size());
            if (accessibleControlEvent.children[0] instanceof Integer) {
                long l = AccessibleFactory.getDefaultParentType();
                int n2 = 0;
                while (n2 < accessibleControlEvent.children.length) {
                    AccessibleObject accessibleObject = this.getChildByIndex(n2);
                    if (accessibleObject == null) {
                        long l2 = AccessibleFactory.getChildType(this.accessible, n2);
                        accessibleObject = new AccessibleObject(l2, 0L, this.accessible, l, true);
                        AccessibleObjects.put(new LONG(accessibleObject.handle), accessibleObject);
                        this.addChild(accessibleObject);
                        accessibleObject.index = n2;
                    }
                    try {
                        accessibleObject.id = (Integer)accessibleControlEvent.children[n2];
                    }
                    catch (ClassCastException classCastException) {}
                    vector.addElement(new LONG(accessibleObject.handle));
                    ++n2;
                }
            } else {
                int n3 = 0;
                int n4 = 0;
                while (n4 < accessibleControlEvent.children.length) {
                    AccessibleObject accessibleObject = null;
                    try {
                        accessibleObject = ((Accessible)accessibleControlEvent.children[n4]).accessibleObject;
                    }
                    catch (ClassCastException classCastException) {}
                    if (accessibleObject != null) {
                        accessibleObject.index = n3++;
                        vector.addElement(new LONG(accessibleObject.handle));
                    }
                    ++n4;
                }
            }
            Enumeration enumeration = this.children.keys();
            while (enumeration.hasMoreElements()) {
                LONG lONG = (LONG)enumeration.nextElement();
                if (vector.contains(lONG)) continue;
                AccessibleObject accessibleObject = (AccessibleObject)this.children.get(lONG);
                this.removeChild(accessibleObject, true);
            }
        }
    }
}

