/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.browser.MozillaDelegate;
import org.eclipse.swt.browser.SimpleEnumerator;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsEmbedString;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIDirectoryServiceProvider;
import org.eclipse.swt.internal.mozilla.nsIDirectoryServiceProvider2;
import org.eclipse.swt.internal.mozilla.nsIFile;
import org.eclipse.swt.internal.mozilla.nsILocalFile;
import org.eclipse.swt.internal.mozilla.nsISupports;

class AppFileLocProvider {
    XPCOMObject supports;
    XPCOMObject directoryServiceProvider;
    XPCOMObject directoryServiceProvider2;
    int refCount = 0;
    String mozillaPath;
    String profilePath;
    String[] pluginDirs;
    static final String SEPARATOR_OS = System.getProperty("file.separator");
    static final String CHROME_DIR = "chrome";
    static final String COMPONENTS_DIR = "components";
    static final String HISTORY_FILE = "history.dat";
    static final String LOCALSTORE_FILE = "localstore.rdf";
    static final String MIMETYPES_FILE = "mimeTypes.rdf";
    static final String PLUGINS_DIR = "plugins";
    static final String USER_PLUGINS_DIR = ".mozilla" + SEPARATOR_OS + "plugins";
    static final String PREFERENCES_FILE = "prefs.js";

    public AppFileLocProvider(String string) {
        this.mozillaPath = String.valueOf(string) + SEPARATOR_OS;
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.supports = new XPCOMObject(nArray){

            public long method0(long[] lArray) {
                return AppFileLocProvider.this.queryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return AppFileLocProvider.this.AddRef();
            }

            public long method2(long[] lArray) {
                return AppFileLocProvider.this.Release();
            }
        };
        int[] nArray2 = new int[4];
        nArray2[0] = 2;
        nArray2[3] = 3;
        this.directoryServiceProvider = new XPCOMObject(nArray2){

            public long method0(long[] lArray) {
                return AppFileLocProvider.this.queryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return AppFileLocProvider.this.AddRef();
            }

            public long method2(long[] lArray) {
                return AppFileLocProvider.this.Release();
            }

            public long method3(long[] lArray) {
                return AppFileLocProvider.this.getFile(lArray[0], lArray[1], lArray[2]);
            }
        };
        int[] nArray3 = new int[5];
        nArray3[0] = 2;
        nArray3[3] = 3;
        nArray3[4] = 2;
        this.directoryServiceProvider2 = new XPCOMObject(nArray3){

            public long method0(long[] lArray) {
                return AppFileLocProvider.this.queryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return AppFileLocProvider.this.AddRef();
            }

            public long method2(long[] lArray) {
                return AppFileLocProvider.this.Release();
            }

            public long method3(long[] lArray) {
                return AppFileLocProvider.this.getFile(lArray[0], lArray[1], lArray[2]);
            }

            public long method4(long[] lArray) {
                return AppFileLocProvider.this.getFiles(lArray[0], lArray[1]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.directoryServiceProvider != null) {
            this.directoryServiceProvider.dispose();
            this.directoryServiceProvider = null;
        }
        if (this.directoryServiceProvider2 != null) {
            this.directoryServiceProvider2.dispose();
            this.directoryServiceProvider2 = null;
        }
    }

    long getAddress() {
        return this.directoryServiceProvider.getAddress();
    }

    long queryInterface(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return -2147467262L;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, l, 16);
        if (nsID2.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(l2, new long[]{this.supports.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (nsID2.Equals(nsIDirectoryServiceProvider.NS_IDIRECTORYSERVICEPROVIDER_IID)) {
            XPCOM.memmove(l2, new long[]{this.directoryServiceProvider.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (nsID2.Equals(nsIDirectoryServiceProvider2.NS_IDIRECTORYSERVICEPROVIDER2_IID)) {
            XPCOM.memmove(l2, new long[]{this.directoryServiceProvider2.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        XPCOM.memmove(l2, new long[1], (long)C.PTR_SIZEOF);
        return -2147467262L;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    void setProfilePath(String string) {
        this.profilePath = string;
    }

    int getFiles(long l, long l2) {
        Object object;
        int n = XPCOM.strlen(l);
        byte[] byArray = new byte[n];
        XPCOM.memmove(byArray, l, (long)n);
        String string = new String(MozillaDelegate.mbcsToWcs(null, byArray));
        String[] stringArray = null;
        if (string.equals("APluginsDL")) {
            if (this.pluginDirs == null) {
                int n2 = 0;
                long l3 = C.getenv(MozillaDelegate.wcsToMbcs(null, "MOZ_PLUGIN_PATH", true));
                if (l3 != 0L) {
                    int n3 = C.strlen(l3);
                    byte[] byArray2 = new byte[n3];
                    C.memmove(byArray2, l3, (long)n3);
                    object = new String(MozillaDelegate.mbcsToWcs(null, byArray2));
                    if (((String)object).length() > 0) {
                        this.pluginDirs = new String[3];
                        this.pluginDirs[n2++] = object;
                    }
                }
                if (this.pluginDirs == null) {
                    this.pluginDirs = new String[2];
                }
                this.pluginDirs[n2++] = String.valueOf(this.mozillaPath) + PLUGINS_DIR;
                this.pluginDirs[n2++] = String.valueOf(System.getProperty("user.home")) + SEPARATOR_OS + USER_PLUGINS_DIR;
            }
            stringArray = this.pluginDirs;
        }
        XPCOM.memmove(l2, new long[1], (long)C.PTR_SIZEOF);
        if (stringArray != null) {
            long[] lArray = new long[1];
            nsISupports[] nsISupportsArray = new nsISupports[stringArray.length];
            int n4 = 0;
            while (n4 < stringArray.length) {
                nsEmbedString nsEmbedString2 = new nsEmbedString(stringArray[n4]);
                int n5 = XPCOM.NS_NewLocalFile(nsEmbedString2.getAddress(), true, lArray);
                if (n5 != 0) {
                    Mozilla.error(n5);
                }
                if (lArray[0] == 0L) {
                    Mozilla.error(-2147467261);
                }
                nsEmbedString2.dispose();
                object = new nsILocalFile(lArray[0]);
                lArray[0] = 0L;
                n5 = ((nsISupports)object).QueryInterface(nsIFile.NS_IFILE_IID, lArray);
                if (n5 != 0) {
                    Mozilla.error(n5);
                }
                if (lArray[0] == 0L) {
                    Mozilla.error(-2147467261);
                }
                ((nsISupports)object).Release();
                nsIFile nsIFile2 = new nsIFile(lArray[0]);
                lArray[0] = 0L;
                nsISupportsArray[n4] = nsIFile2;
                ++n4;
            }
            SimpleEnumerator simpleEnumerator = new SimpleEnumerator(nsISupportsArray);
            simpleEnumerator.AddRef();
            XPCOM.memmove(l2, new long[]{simpleEnumerator.getAddress()}, (long)C.PTR_SIZEOF);
            return 0;
        }
        return -2147467259;
    }

    int getFile(long l, long l2, long l3) {
        int n = XPCOM.strlen(l);
        byte[] byArray = new byte[n];
        XPCOM.memmove(byArray, l, (long)n);
        String string = new String(MozillaDelegate.mbcsToWcs(null, byArray));
        String string2 = null;
        if (string.equals("UHist")) {
            string2 = String.valueOf(this.profilePath) + HISTORY_FILE;
        } else if (string.equals("UMimTyp")) {
            string2 = String.valueOf(this.profilePath) + MIMETYPES_FILE;
        } else if (string.equals("PrefF")) {
            string2 = String.valueOf(this.profilePath) + PREFERENCES_FILE;
        } else if (string.equals("PrefD")) {
            string2 = this.profilePath;
        } else if (string.equals("UChrm")) {
            string2 = String.valueOf(this.profilePath) + CHROME_DIR;
        } else if (string.equals("ProfD")) {
            string2 = this.profilePath;
        } else if (string.equals("LclSt")) {
            string2 = String.valueOf(this.profilePath) + LOCALSTORE_FILE;
        } else if (string.equals("cachePDir")) {
            string2 = this.profilePath;
        } else if (string.equals("Home")) {
            string2 = System.getProperty("user.home");
        } else if (string.equals("TmpD")) {
            string2 = System.getProperty("java.io.tmpdir");
        } else if (string.equals("GreD")) {
            string2 = this.mozillaPath;
        } else if (string.equals("GreComsD")) {
            string2 = String.valueOf(this.mozillaPath) + COMPONENTS_DIR;
        } else if (string.equals("MozBinD")) {
            string2 = this.mozillaPath;
        } else if (string.equals("CurProcD")) {
            string2 = this.mozillaPath;
        } else if (string.equals("ComsD")) {
            string2 = String.valueOf(this.mozillaPath) + COMPONENTS_DIR;
        } else if (string.equals("XCurProcD")) {
            string2 = this.mozillaPath;
        }
        XPCOM.memmove(l2, new int[]{1}, 4L);
        XPCOM.memmove(l3, new long[1], (long)C.PTR_SIZEOF);
        if (string2 != null && string2.length() > 0) {
            long[] lArray = new long[1];
            nsEmbedString nsEmbedString2 = new nsEmbedString(string2);
            int n2 = XPCOM.NS_NewLocalFile(nsEmbedString2.getAddress(), true, lArray);
            if (n2 != 0) {
                Mozilla.error(n2);
            }
            if (lArray[0] == 0L) {
                Mozilla.error(-2147467261);
            }
            nsEmbedString2.dispose();
            nsILocalFile nsILocalFile2 = new nsILocalFile(lArray[0]);
            lArray[0] = 0L;
            n2 = nsILocalFile2.QueryInterface(nsIFile.NS_IFILE_IID, lArray);
            if (n2 != 0) {
                Mozilla.error(n2);
            }
            if (lArray[0] == 0L) {
                Mozilla.error(-2147467261);
            }
            XPCOM.memmove(l3, new long[]{lArray[0]}, (long)C.PTR_SIZEOF);
            nsILocalFile2.Release();
            return 0;
        }
        return -2147467259;
    }
}

