/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GtkColorSelectionDialog;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;

    public ColorDialog(Shell shell) {
        this(shell, 0);
    }

    public ColorDialog(Shell shell, int n) {
        super(shell, n);
        this.checkSubclass();
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB open() {
        boolean bl;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        long l = OS.gtk_color_selection_dialog_new(byArray);
        if (this.parent != null) {
            long l2 = this.parent.topHandle();
            OS.gtk_window_set_transient_for(l, l2);
            long l3 = OS.gtk_window_get_icon_list(l2);
            if (l3 != 0L) {
                OS.gtk_window_set_icon_list(l, l3);
                OS.g_list_free(l3);
            }
        }
        GtkColorSelectionDialog gtkColorSelectionDialog = new GtkColorSelectionDialog();
        OS.memmove(gtkColorSelectionDialog, l);
        GdkColor gdkColor = new GdkColor();
        if (this.rgb != null) {
            gdkColor.red = (short)(this.rgb.red & 0xFF | (this.rgb.red & 0xFF) << 8);
            gdkColor.green = (short)(this.rgb.green & 0xFF | (this.rgb.green & 0xFF) << 8);
            gdkColor.blue = (short)(this.rgb.blue & 0xFF | (this.rgb.blue & 0xFF) << 8);
            OS.gtk_color_selection_set_current_color(gtkColorSelectionDialog.colorsel, gdkColor);
        }
        OS.gtk_color_selection_set_has_palette(gtkColorSelectionDialog.colorsel, true);
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.addIdleProc();
        int n = OS.gtk_dialog_run(l);
        boolean bl2 = bl = n == -5;
        if (bl) {
            OS.gtk_color_selection_get_current_color(gtkColorSelectionDialog.colorsel, gdkColor);
            int n2 = gdkColor.red >> 8 & 0xFF;
            int n3 = gdkColor.green >> 8 & 0xFF;
            int n4 = gdkColor.blue >> 8 & 0xFF;
            this.rgb = new RGB(n2, n3, n4);
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(l);
        if (!bl) {
            return null;
        }
        return this.rgb;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }
}

