/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;

    public FontDialog(Shell shell) {
        this(shell, 32768);
    }

    public FontDialog(Shell shell, int n) {
        super(shell, n);
        this.checkSubclass();
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] fontDataArray = new FontData[]{this.fontData};
        return fontDataArray;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        boolean bl;
        long l;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        long l2 = OS.gtk_font_selection_dialog_new(byArray);
        if (this.parent != null) {
            long l3 = this.parent.topHandle();
            OS.gtk_window_set_transient_for(l2, l3);
            l = OS.gtk_window_get_icon_list(l3);
            if (l != 0L) {
                OS.gtk_window_set_icon_list(l2, l);
                OS.g_list_free(l);
            }
        }
        if (this.fontData != null) {
            Display display = this.parent != null ? this.parent.display : Display.getCurrent();
            Font font = new Font((Device)display, this.fontData);
            l = OS.pango_font_description_to_string(font.handle);
            int n = OS.strlen(l);
            byte[] byArray2 = new byte[n + 1];
            OS.memmove(byArray2, l, (long)n);
            font.dispose();
            OS.g_free(l);
            OS.gtk_font_selection_dialog_set_font_name(l2, byArray2);
        }
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.addIdleProc();
        int n = OS.gtk_dialog_run(l2);
        boolean bl2 = bl = n == -5;
        if (bl) {
            long l4 = OS.gtk_font_selection_dialog_get_font_name(l2);
            int n2 = OS.strlen(l4);
            byte[] byArray3 = new byte[n2 + 1];
            OS.memmove(byArray3, l4, (long)n2);
            OS.g_free(l4);
            long l5 = OS.pango_font_description_from_string(byArray3);
            Font font = Font.gtk_new(display, l5);
            this.fontData = font.getFontData()[0];
            OS.pango_font_description_free(l5);
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(l2);
        if (!bl) {
            return null;
        }
        return this.fontData;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontDataArray) {
        this.fontData = fontDataArray != null && fontDataArray.length > 0 ? fontDataArray[0] : null;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }
}

