/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TabFolder
extends Composite {
    TabItem[] items;
    ImageList imageList;

    public TabFolder(Composite composite, int n) {
        super(composite, TabFolder.checkStyle(n));
    }

    static int checkStyle(int n) {
        n = TabFolder.checkBits(n, 128, 1024, 0, 0, 0, 0);
        return n & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    long childStyle() {
        long l = OS.gtk_widget_get_modifier_style(this.handle);
        if ((OS.gtk_rc_style_get_color_flags(l, 0) & 2) != 0) {
            return 0L;
        }
        OS.gtk_widget_realize(this.handle);
        return OS.gtk_widget_get_style(this.handle);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    long clientHandle() {
        int n = OS.gtk_notebook_get_current_page(this.handle);
        if (n != -1 && this.items[n] != null) {
            return this.items[n].pageHandle;
        }
        return this.handle;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        Point point = super.computeSize(n, n2, bl);
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        boolean bl2 = OS.gtk_notebook_get_scrollable(this.handle);
        OS.gtk_notebook_set_scrollable(this.handle, false);
        Point point2 = this.computeNativeSize(this.handle, n, n2, bl);
        OS.gtk_notebook_set_scrollable(this.handle, bl2);
        point.x = Math.max(point2.x, point.x);
        point.y = Math.max(point2.y, point.y);
        return point;
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        this.forceResize();
        long l = this.clientHandle();
        int n5 = OS.GTK_WIDGET_X(l);
        int n6 = OS.GTK_WIDGET_Y(l);
        n -= n5;
        n2 -= n6;
        n3 += n5 + n5;
        if ((this.style & 0x400) != 0) {
            int n7 = OS.GTK_WIDGET_HEIGHT(this.handle);
            int n8 = OS.GTK_WIDGET_HEIGHT(l);
            n4 += n7 - n8;
        } else {
            n4 += n5 + n6;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    void createHandle(int n) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        this.handle = OS.gtk_notebook_new();
        if (this.handle == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        OS.gtk_notebook_set_scrollable(this.handle, true);
        OS.gtk_notebook_set_show_tabs(this.handle, true);
        if ((this.style & 0x400) != 0) {
            OS.gtk_notebook_set_tab_pos(this.handle, 3);
        }
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.items = new TabItem[4];
    }

    void createItem(TabItem tabItem, int n) {
        long l;
        long l2;
        long l3;
        long l4 = OS.gtk_container_get_children(this.handle);
        int n2 = 0;
        if (l4 != 0L) {
            n2 = OS.g_list_length(l4);
            OS.g_list_free(l4);
        }
        if (n < 0 || n > n2) {
            this.error(6);
        }
        if (n2 == this.items.length) {
            TabItem[] tabItemArray = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, tabItemArray, 0, this.items.length);
            this.items = tabItemArray;
        }
        if ((l3 = OS.gtk_hbox_new(false, 0)) == 0L) {
            this.error(2);
        }
        if ((l2 = OS.gtk_label_new_with_mnemonic(null)) == 0L) {
            this.error(2);
        }
        if ((l = OS.gtk_image_new()) == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(l3, l);
        OS.gtk_container_add(l3, l2);
        long l5 = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (l5 == 0L) {
            this.error(2);
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 48L);
        OS.gtk_notebook_insert_page(this.handle, l5, l3, n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 48L);
        OS.gtk_widget_show(l3);
        OS.gtk_widget_show(l2);
        OS.gtk_widget_show(l5);
        tabItem.state |= 8;
        tabItem.handle = l3;
        tabItem.labelHandle = l2;
        tabItem.imageHandle = l;
        tabItem.pageHandle = l5;
        System.arraycopy(this.items, n, this.items, n + 1, n2++ - n);
        this.items[n] = tabItem;
        if ((this.state & 0x1000) != 0) {
            tabItem.setForegroundColor(this.getForegroundColor());
        }
        if ((this.state & 0x4000) != 0) {
            tabItem.setFontDescription(this.getFontDescription());
        }
        if (n2 == 1) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 48L);
            OS.gtk_notebook_set_current_page(this.handle, 0);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 48L);
            Event event = new Event();
            event.item = this.items[0];
            this.sendEvent(13, event);
        }
    }

    void destroyItem(TabItem tabItem) {
        int n;
        int n2 = 0;
        int n3 = this.getItemCount();
        while (n2 < n3) {
            if (this.items[n2] == tabItem) break;
            ++n2;
        }
        if (n2 == n3) {
            this.error(15);
        }
        int n4 = OS.gtk_notebook_get_current_page(this.handle);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 48L);
        OS.gtk_notebook_remove_page(this.handle, n2);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 48L);
        System.arraycopy(this.items, n2 + 1, this.items, n2, --n3 - n2);
        this.items[n3] = null;
        if (n2 == n4 && (n = OS.gtk_notebook_get_current_page(this.handle)) != -1) {
            Control control = this.items[n].getControl();
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
                control.setVisible(true);
            }
            Event event = new Event();
            event.item = this.items[n];
            this.sendEvent(13, event);
        }
    }

    long eventHandle() {
        return this.fixedHandle;
    }

    public TabItem getItem(int n) {
        long l;
        this.checkWidget();
        if (n < 0 || n >= this.getItemCount()) {
            this.error(6);
        }
        if ((l = OS.gtk_container_get_children(this.handle)) == 0L) {
            this.error(8);
        }
        int n2 = OS.g_list_length(l);
        OS.g_list_free(l);
        if (n < 0 || n >= n2) {
            this.error(8);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        long l = OS.gtk_container_get_children(this.handle);
        if (l == 0L) {
            return 0;
        }
        int n = OS.g_list_length(l);
        OS.g_list_free(l);
        return n;
    }

    public TabItem[] getItems() {
        this.checkWidget();
        int n = this.getItemCount();
        TabItem[] tabItemArray = new TabItem[n];
        System.arraycopy(this.items, 0, tabItemArray, 0, n);
        return tabItemArray;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int n = OS.gtk_notebook_get_current_page(this.handle);
        if (n == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[n]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return OS.gtk_notebook_get_current_page(this.handle);
    }

    long gtk_focus(long l, long l2) {
        return 0L;
    }

    long gtk_switch_page(long l, long l2, long l3) {
        Control control;
        Widget widget;
        int n = OS.gtk_notebook_get_current_page(this.handle);
        if (n != -1 && (widget = this.items[n].getControl()) != null && !widget.isDisposed()) {
            ((Control)widget).setVisible(false);
        }
        if ((control = ((TabItem)(widget = this.items[(int)l3])).getControl()) != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
            control.setVisible(true);
        }
        Event event = new Event();
        event.item = widget;
        this.postEvent(13, event);
        return 0L;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.switch_page, this.display.closures[48], false);
    }

    public int indexOf(TabItem tabItem) {
        long l;
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        if ((l = OS.gtk_container_get_children(this.handle)) == 0L) {
            return -1;
        }
        int n = OS.g_list_length(l);
        OS.g_list_free(l);
        int n2 = 0;
        while (n2 < n) {
            if (this.items[n2] == tabItem) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    Point minimumSize(int n, int n2, boolean bl) {
        Control[] controlArray = this._getChildren();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < controlArray.length) {
            SerializableCompatibility serializableCompatibility;
            Control control = controlArray[n5];
            int n6 = 0;
            int n7 = 0;
            long l = OS.gtk_container_get_children(this.handle);
            if (l != 0L) {
                n7 = OS.g_list_length(l);
                OS.g_list_free(l);
            }
            while (n6 < n7) {
                if (this.items[n6].control == control) break;
                ++n6;
            }
            if (n6 == n7) {
                serializableCompatibility = control.getBounds();
                n3 = Math.max(n3, serializableCompatibility.x + serializableCompatibility.width);
                n4 = Math.max(n4, serializableCompatibility.y + serializableCompatibility.height);
            } else {
                serializableCompatibility = control.computeSize(n, n2, bl);
                n3 = Math.max(n3, ((Point)serializableCompatibility).x);
                n4 = Math.max(n4, ((Point)serializableCompatibility).y);
            }
            ++n5;
        }
        return new Point(n3, n4);
    }

    boolean mnemonicHit(char c) {
        int n = this.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            long l = this.items[n2].labelHandle;
            if (l != 0L && this.mnemonicHit(l, c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean mnemonicMatch(char c) {
        int n = this.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            long l = this.items[n2].labelHandle;
            if (l != 0L && this.mnemonicHit(l, c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    void releaseChildren(boolean bl) {
        if (this.items != null) {
            int n = 0;
            while (n < this.items.length) {
                TabItem tabItem = this.items[n];
                if (tabItem != null && !tabItem.isDisposed()) {
                    tabItem.release(false);
                }
                ++n;
            }
            this.items = null;
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int n = this.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            TabItem tabItem = this.items[n2];
            if (tabItem.control == control) {
                tabItem.setControl(null);
            }
            ++n2;
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5;
        int n6 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if ((n6 & 0x100) != 0 && (n5 = this.getSelectionIndex()) != -1) {
            TabItem tabItem = this.items[n5];
            Control control = tabItem.control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
            }
        }
        return n6;
    }

    void setFontDescription(long l) {
        super.setFontDescription(l);
        TabItem[] tabItemArray = this.getItems();
        int n = 0;
        while (n < tabItemArray.length) {
            if (tabItemArray[n] != null) {
                tabItemArray[n].setFontDescription(l);
            }
            ++n;
        }
    }

    void setForegroundColor(GdkColor gdkColor) {
        super.setForegroundColor(gdkColor);
        TabItem[] tabItemArray = this.getItems();
        int n = 0;
        while (n < tabItemArray.length) {
            if (tabItemArray[n] != null) {
                tabItemArray[n].setForegroundColor(gdkColor);
            }
            ++n;
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.getItemCount()) {
            return;
        }
        this.setSelection(n, false);
    }

    void setSelection(int n, boolean bl) {
        Widget widget;
        if (n < 0) {
            return;
        }
        int n2 = OS.gtk_notebook_get_current_page(this.handle);
        if (n2 == n) {
            return;
        }
        if (n2 != -1) {
            TabItem tabItem = this.items[n2];
            widget = tabItem.control;
            if (widget != null && !widget.isDisposed()) {
                widget.setVisible(false);
            }
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 48L);
        OS.gtk_notebook_set_current_page(this.handle, n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 48L);
        int n3 = OS.gtk_notebook_get_current_page(this.handle);
        if (n3 != -1) {
            widget = this.items[n3];
            Control control = ((TabItem)widget).control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
                control.setVisible(true);
            }
            if (bl) {
                Event event = new Event();
                event.item = widget;
                this.sendEvent(13, event);
            }
        }
    }

    public void setSelection(TabItem tabItem) {
        if (tabItem == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{tabItem});
    }

    public void setSelection(TabItem[] tabItemArray) {
        this.checkWidget();
        if (tabItemArray == null) {
            this.error(4);
        }
        if (tabItemArray.length == 0) {
            this.setSelection(-1, false);
        } else {
            int n = tabItemArray.length - 1;
            while (n >= 0) {
                int n2 = this.indexOf(tabItemArray[n]);
                if (n2 != -1) {
                    this.setSelection(n2, false);
                }
                --n;
            }
        }
    }

    boolean traversePage(boolean bl) {
        if (bl) {
            OS.gtk_notebook_next_page(this.handle);
        } else {
            OS.gtk_notebook_prev_page(this.handle);
        }
        return true;
    }
}

