/*******************************************************************************
 * Copyright (c) 2000, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - initial API and implementation
 *******************************************************************************/

#include "swt.h"
#include "cde_structs.h"

#ifndef NO_DtActionArg
typedef struct DtActionArg_FID_CACHE {
	int cached;
	jclass clazz;
	jfieldID name, argClass;
} DtActionArg_FID_CACHE;

DtActionArg_FID_CACHE DtActionArgFc;

void cacheDtActionArgFields(JNIEnv *env, jobject lpObject)
{
	if (DtActionArgFc.cached) return;
	DtActionArgFc.clazz = (*env)->GetObjectClass(env, lpObject);
	DtActionArgFc.name = (*env)->GetFieldID(env, DtActionArgFc.clazz, "name", "J");
	DtActionArgFc.argClass = (*env)->GetFieldID(env, DtActionArgFc.clazz, "argClass", "I");
	DtActionArgFc.cached = 1;
}

DtActionArg *getDtActionArgFields(JNIEnv *env, jobject lpObject, DtActionArg *lpStruct)
{
	if (!DtActionArgFc.cached) cacheDtActionArgFields(env, lpObject);
	lpStruct->u.file.name = (char *)(*env)->GetLongField(env, lpObject, DtActionArgFc.name);
	lpStruct->argClass = (*env)->GetIntField(env, lpObject, DtActionArgFc.argClass);
	return lpStruct;
}

void setDtActionArgFields(JNIEnv *env, jobject lpObject, DtActionArg *lpStruct)
{
	if (!DtActionArgFc.cached) cacheDtActionArgFields(env, lpObject);
	(*env)->SetLongField(env, lpObject, DtActionArgFc.name, (jlong)lpStruct->u.file.name);
	(*env)->SetIntField(env, lpObject, DtActionArgFc.argClass, (jint)lpStruct->argClass);
}
#endif

