/*******************************************************************************
 * Copyright (c) 2000, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - initial API and implementation
 *******************************************************************************/

#include "swt.h"
#include "xpcom_stats.h"

#ifdef NATIVE_STATS

int XPCOM_nativeFunctionCount = 128;
int XPCOM_nativeFunctionCallCount[128];
char * XPCOM_nativeFunctionNames[] = {
	"Call",
	"NS_1GetComponentManager",
	"NS_1GetServiceManager",
	"NS_1InitXPCOM2",
	"NS_1NewLocalFile",
	"VtblCall__IJ",
	"VtblCall__IJF",
	"VtblCall__IJI",
	"VtblCall__IJII",
	"VtblCall__IJIIIII",
	"VtblCall__IJIIIIZ",
	"VtblCall__IJIIZ",
	"VtblCall__IJII_3C",
	"VtblCall__IJII_3J",
	"VtblCall__IJIJJ",
	"VtblCall__IJI_3B_3Z",
	"VtblCall__IJI_3C",
	"VtblCall__IJI_3I_3I_3I_3I",
	"VtblCall__IJJ",
	"VtblCall__IJJI",
	"VtblCall__IJJIIJ_3Z_3J",
	"VtblCall__IJJI_3J",
	"VtblCall__IJJJ",
	"VtblCall__IJJJI",
	"VtblCall__IJJJII",
	"VtblCall__IJJJIIII",
	"VtblCall__IJJJIZ",
	"VtblCall__IJJJI_3C",
	"VtblCall__IJJJI_3I",
	"VtblCall__IJJJJ",
	"VtblCall__IJJJJJJ",
	"VtblCall__IJJJJJJJ",
	"VtblCall__IJJJJJJJJ",
	"VtblCall__IJJJJZ",
	"VtblCall__IJJJJZ_3CJJIJZ_3J_3J",
	"VtblCall__IJJJZ",
	"VtblCall__IJJJ_3CJJJ",
	"VtblCall__IJJJ_3I",
	"VtblCall__IJJLorg_eclipse_swt_internal_mozilla_nsID_2",
	"VtblCall__IJJLorg_eclipse_swt_internal_mozilla_nsID_2_3J",
	"VtblCall__IJJZ",
	"VtblCall__IJJZZ",
	"VtblCall__IJJZZJI",
	"VtblCall__IJJZZJIIIIIZZZZSJ",
	"VtblCall__IJJZ_3Z",
	"VtblCall__IJJ_3B",
	"VtblCall__IJJ_3BJ_3J",
	"VtblCall__IJJ_3BZ",
	"VtblCall__IJJ_3B_3B_3BJ_3J",
	"VtblCall__IJJ_3B_3C",
	"VtblCall__IJJ_3CI",
	"VtblCall__IJJ_3C_3C",
	"VtblCall__IJJ_3C_3CI_3C_3C_3C_3C_3Z_3I",
	"VtblCall__IJJ_3C_3CI_3J_3I_3Z",
	"VtblCall__IJJ_3C_3C_3C_3Z",
	"VtblCall__IJJ_3C_3C_3C_3Z_3Z",
	"VtblCall__IJJ_3C_3C_3J",
	"VtblCall__IJJ_3C_3C_3J_3C_3Z_3Z",
	"VtblCall__IJJ_3C_3C_3J_3J_3C_3Z_3Z",
	"VtblCall__IJJ_3C_3C_3Z",
	"VtblCall__IJJ_3J",
	"VtblCall__IJJ_3Z",
	"VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2J",
	"VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2JLorg_eclipse_swt_internal_mozilla_nsID_2_3J",
	"VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2Lorg_eclipse_swt_internal_mozilla_nsID_2_3J",
	"VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2Lorg_eclipse_swt_internal_mozilla_nsID_2_3Z",
	"VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2_3B_3BJ",
	"VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2_3B_3BJ_3B_3B",
	"VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2_3J",
	"VtblCall__IJLorg_eclipse_swt_internal_mozilla_nsID_2_3Z",
	"VtblCall__IJZ",
	"VtblCall__IJZJ",
	"VtblCall__IJZ_3Z",
	"VtblCall__IJ_3B",
	"VtblCall__IJ_3BI",
	"VtblCall__IJ_3BI_3I",
	"VtblCall__IJ_3BJ",
	"VtblCall__IJ_3BJLorg_eclipse_swt_internal_mozilla_nsID_2_3J",
	"VtblCall__IJ_3BLorg_eclipse_swt_internal_mozilla_nsID_2J",
	"VtblCall__IJ_3BLorg_eclipse_swt_internal_mozilla_nsID_2_3J",
	"VtblCall__IJ_3BLorg_eclipse_swt_internal_mozilla_nsID_2_3Z",
	"VtblCall__IJ_3BZJ_3J_3Z",
	"VtblCall__IJ_3BZ_3J_3Z",
	"VtblCall__IJ_3B_3B",
	"VtblCall__IJ_3B_3BZ",
	"VtblCall__IJ_3B_3B_3BZZ_3J",
	"VtblCall__IJ_3B_3B_3J",
	"VtblCall__IJ_3B_3I",
	"VtblCall__IJ_3B_3I_3J",
	"VtblCall__IJ_3B_3J",
	"VtblCall__IJ_3B_3J_3Z",
	"VtblCall__IJ_3B_3Z",
	"VtblCall__IJ_3B_3Z_3J",
	"VtblCall__IJ_3C",
	"VtblCall__IJ_3CIJJJ",
	"VtblCall__IJ_3CJ_3J",
	"VtblCall__IJ_3CZ",
	"VtblCall__IJ_3C_3C",
	"VtblCall__IJ_3C_3C_3CZ",
	"VtblCall__IJ_3C_3Z",
	"VtblCall__IJ_3F",
	"VtblCall__IJ_3I",
	"VtblCall__IJ_3I_3I",
	"VtblCall__IJ_3I_3I_3I_3I",
	"VtblCall__IJ_3I_3J",
	"VtblCall__IJ_3I_3J_3J",
	"VtblCall__IJ_3J",
	"VtblCall__IJ_3J_3J_3J",
	"VtblCall__IJ_3S",
	"VtblCall__IJ_3Z",
	"XPCOMGlueShutdown",
	"XPCOMGlueStartup",
	"memmove__JLorg_eclipse_swt_internal_mozilla_nsID_2I",
	"memmove__Lorg_eclipse_swt_internal_mozilla_nsID_2JI",
	"nsEmbedCString_1Length",
	"nsEmbedCString_1delete",
	"nsEmbedCString_1get",
	"nsEmbedCString_1new__",
	"nsEmbedCString_1new___3BI",
	"nsEmbedString_1Length",
	"nsEmbedString_1delete",
	"nsEmbedString_1get",
	"nsEmbedString_1new__",
	"nsEmbedString_1new___3C",
	"nsID_1Equals",
	"nsID_1delete",
	"nsID_1new",
	"strlen_1PRUnichar",
};

#define STATS_NATIVE(func) Java_org_eclipse_swt_tools_internal_NativeStats_##func

JNIEXPORT jint JNICALL STATS_NATIVE(XPCOM_1GetFunctionCount)
	(JNIEnv *env, jclass that)
{
	return XPCOM_nativeFunctionCount;
}

JNIEXPORT jstring JNICALL STATS_NATIVE(XPCOM_1GetFunctionName)
	(JNIEnv *env, jclass that, jint index)
{
	return env->NewStringUTF(XPCOM_nativeFunctionNames[index]);
}

JNIEXPORT jint JNICALL STATS_NATIVE(XPCOM_1GetFunctionCallCount)
	(JNIEnv *env, jclass that, jint index)
{
	return XPCOM_nativeFunctionCallCount[index];
}

#endif
