/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class ExpandBar
extends Composite {
    ExpandItem[] items;
    ExpandItem lastFocus;
    int itemCount;
    int spacing;
    int yCurrentScroll;

    public ExpandBar(Composite parent, int style) {
        super(parent, style);
    }

    public void addExpandListener(ExpandListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (wHint != -1 && wHint < 0) {
                wHint = 0;
            }
            if (hHint != -1 && hHint < 0) {
                hHint = 0;
            }
            Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
            int border = OS.gtk_container_get_border_width(this.handle);
            size.x += 2 * border;
            size.y += 2 * border;
            return size;
        }
        int height = 0;
        int width = 0;
        if ((wHint == -1 || hHint == -1) && this.itemCount > 0) {
            height += this.spacing;
            GC gc = new GC(this);
            int i = 0;
            while (i < this.itemCount) {
                ExpandItem item = this.items[i];
                height += item.getHeaderHeight();
                if (item.expanded) {
                    height += item.height;
                }
                height += this.spacing;
                width = Math.max(width, item.getPreferredWidth(gc));
                ++i;
            }
            gc.dispose();
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    void createHandle(int index) {
        this.state |= 8;
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
            if (this.fixedHandle == 0L) {
                this.error(2);
            }
            OS.gtk_fixed_set_has_window(this.fixedHandle, true);
            this.handle = OS.gtk_vbox_new(false, 0);
            if (this.handle == 0L) {
                this.error(2);
            }
            if ((this.style & 0x200) != 0) {
                this.scrolledHandle = OS.gtk_scrolled_window_new(0L, 0L);
                if (this.scrolledHandle == 0L) {
                    this.error(2);
                }
                int vsp = (this.style & 0x200) != 0 ? 1 : 2;
                OS.gtk_scrolled_window_set_policy(this.scrolledHandle, 2, vsp);
                OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
                OS.gtk_scrolled_window_add_with_viewport(this.scrolledHandle, this.handle);
            } else {
                OS.gtk_container_add(this.fixedHandle, this.handle);
            }
            OS.gtk_container_set_border_width(this.handle, 0);
        } else {
            long topHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
            if (topHandle == 0L) {
                this.error(2);
            }
            OS.gtk_fixed_set_has_window(topHandle, true);
            if ((this.style & 0x200) != 0) {
                this.fixedHandle = topHandle;
                this.scrolledHandle = OS.gtk_scrolled_window_new(0L, 0L);
                if (this.scrolledHandle == 0L) {
                    this.error(2);
                }
                this.handle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
                if (this.handle == 0L) {
                    this.error(2);
                }
                OS.gtk_fixed_set_has_window(this.handle, true);
                OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
                boolean warnings = this.display.getWarnings();
                this.display.setWarnings(false);
                OS.gtk_container_add(this.scrolledHandle, this.handle);
                this.display.setWarnings(warnings);
            } else {
                this.handle = topHandle;
            }
            OS.GTK_WIDGET_SET_FLAGS(this.handle, 2048);
        }
    }

    void createItem(ExpandItem item, int style, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ExpandItem[] newItems = new ExpandItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount - index);
        this.items[index] = item;
        ++this.itemCount;
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && this.lastFocus == null) {
            this.lastFocus = item;
        }
        item.width = Math.max(0, this.getClientArea().width - this.spacing * 2);
        this.layoutItems(index, true);
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.items = new ExpandItem[4];
    }

    void destroyItem(ExpandItem item) {
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && item == this.lastFocus) {
            int focusIndex;
            int n = focusIndex = index > 0 ? index - 1 : 1;
            if (focusIndex < this.itemCount) {
                this.lastFocus = this.items[focusIndex];
                this.lastFocus.redraw();
            } else {
                this.lastFocus = null;
            }
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        item.redraw();
        this.layoutItems(index, true);
    }

    long eventHandle() {
        return OS.GTK_VERSION >= OS.VERSION(2, 4, 0) ? this.fixedHandle : this.handle;
    }

    boolean forceFocus(long focusHandle) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (this.lastFocus != null && this.lastFocus.setFocus()) {
                return true;
            }
            int i = 0;
            while (i < this.itemCount) {
                ExpandItem item = this.items[i];
                if (item.setFocus()) {
                    return true;
                }
                ++i;
            }
        }
        return super.forceFocus(focusHandle);
    }

    boolean hasFocus() {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            int i = 0;
            while (i < this.itemCount) {
                ExpandItem item = this.items[i];
                if (item.hasFocus()) {
                    return true;
                }
                ++i;
            }
        }
        return super.hasFocus();
    }

    int getBandHeight() {
        if (this.font == null) {
            return 24;
        }
        GC gc = new GC(this);
        FontMetrics metrics = gc.getFontMetrics();
        gc.dispose();
        return Math.max(24, metrics.getHeight());
    }

    GdkColor getForegroundColor() {
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && (this.state & 0x1000) == 0) {
            return this.display.getSystemColor((int)30).handle;
        }
        return super.getForegroundColor();
    }

    public ExpandItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ExpandItem[] getItems() {
        this.checkWidget();
        ExpandItem[] result = new ExpandItem[this.itemCount];
        System.arraycopy(this.items, 0, result, 0, this.itemCount);
        return result;
    }

    public int getSpacing() {
        this.checkWidget();
        return this.spacing;
    }

    long gtk_button_press_event(long widget, long event) {
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0)) {
            GdkEventButton gdkEvent = new GdkEventButton();
            OS.memmove(gdkEvent, event, (long)GdkEventButton.sizeof);
            int x = (int)gdkEvent.x;
            int y = (int)gdkEvent.y;
            int i = 0;
            while (i < this.itemCount) {
                boolean hover;
                ExpandItem item = this.items[i];
                boolean bl = hover = item.x <= x && x < item.x + item.width && item.y <= y && y < item.y + this.getBandHeight();
                if (hover && item != this.lastFocus) {
                    this.lastFocus.redraw();
                    this.lastFocus = item;
                    this.lastFocus.redraw();
                    this.forceFocus();
                    break;
                }
                ++i;
            }
        }
        return super.gtk_button_press_event(widget, event);
    }

    long gtk_button_release_event(long widget, long event) {
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && this.lastFocus != null) {
            boolean hover;
            GdkEventButton gdkEvent = new GdkEventButton();
            OS.memmove(gdkEvent, event, (long)GdkEventButton.sizeof);
            int x = (int)gdkEvent.x;
            int y = (int)gdkEvent.y;
            boolean bl = hover = this.lastFocus.x <= x && x < this.lastFocus.x + this.lastFocus.width && this.lastFocus.y <= y && y < this.lastFocus.y + this.getBandHeight();
            if (hover) {
                Event ev = new Event();
                ev.item = this.lastFocus;
                this.notifyListeners(this.lastFocus.expanded ? 18 : 17, ev);
                this.lastFocus.expanded = !this.lastFocus.expanded;
                this.showItem(this.lastFocus);
            }
        }
        return super.gtk_button_release_event(widget, event);
    }

    long gtk_expose_event(long widget, long eventPtr) {
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0)) {
            GdkEventExpose gdkEvent = new GdkEventExpose();
            OS.memmove(gdkEvent, eventPtr, (long)GdkEventExpose.sizeof);
            GCData data = new GCData();
            data.damageRgn = gdkEvent.region;
            GC gc = GC.gtk_new(this, data);
            OS.gdk_gc_set_clip_region(gc.handle, gdkEvent.region);
            boolean hasFocus = this.isFocusControl();
            int i = 0;
            while (i < this.itemCount) {
                ExpandItem item = this.items[i];
                item.drawItem(gc, hasFocus && item == this.lastFocus);
                ++i;
            }
            gc.dispose();
        }
        return super.gtk_expose_event(widget, eventPtr);
    }

    long gtk_focus_in_event(long widget, long event) {
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && this.lastFocus != null) {
            this.lastFocus.redraw();
        }
        return super.gtk_focus_in_event(widget, event);
    }

    long gtk_focus_out_event(long widget, long event) {
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && this.lastFocus != null) {
            this.lastFocus.redraw();
        }
        return super.gtk_focus_out_event(widget, event);
    }

    long gtk_key_press_event(long widget, long event) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (!this.hasFocus()) {
                return 0L;
            }
            long result = super.gtk_key_press_event(widget, event);
            if (result != 0L) {
                return result;
            }
            int index = 0;
            while (index < this.itemCount) {
                if (this.items[index].hasFocus()) break;
                ++index;
            }
            GdkEventKey gdkEvent = new GdkEventKey();
            OS.memmove(gdkEvent, event, (long)GdkEventKey.sizeof);
            boolean next = false;
            switch (gdkEvent.keyval) {
                case 65361: 
                case 65362: {
                    next = false;
                    break;
                }
                case 65363: 
                case 65364: {
                    next = true;
                    break;
                }
                default: {
                    return result;
                }
            }
            int start = index;
            int offset = next ? 1 : -1;
            while ((index = (index + offset + this.itemCount) % this.itemCount) != start) {
                ExpandItem item = this.items[index];
                if (!item.setFocus()) continue;
                return result;
            }
            return result;
        }
        if (this.lastFocus != null) {
            GdkEventKey keyEvent = new GdkEventKey();
            OS.memmove(keyEvent, event, (long)GdkEventKey.sizeof);
            switch (keyEvent.keyval) {
                case 32: 
                case 65293: {
                    Event ev = new Event();
                    ev.item = this.lastFocus;
                    this.sendEvent(this.lastFocus.expanded ? 18 : 17, ev);
                    this.lastFocus.expanded = !this.lastFocus.expanded;
                    this.showItem(this.lastFocus);
                    break;
                }
                case 65362: 
                case 65431: {
                    int focusIndex = this.indexOf(this.lastFocus);
                    if (focusIndex <= 0) break;
                    this.lastFocus.redraw();
                    this.lastFocus = this.items[focusIndex - 1];
                    this.lastFocus.redraw();
                    break;
                }
                case 65364: 
                case 65433: {
                    int focusIndex = this.indexOf(this.lastFocus);
                    if (focusIndex >= this.itemCount - 1) break;
                    this.lastFocus.redraw();
                    this.lastFocus = this.items[focusIndex + 1];
                    this.lastFocus.redraw();
                }
            }
        }
        return super.gtk_key_press_event(widget, event);
    }

    public int indexOf(ExpandItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void layoutItems(int index, boolean setScrollbar) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            int i = 0;
            while (i < this.itemCount) {
                ExpandItem item = this.items[i];
                if (item != null) {
                    item.resizeControl(this.yCurrentScroll);
                }
                ++i;
            }
        } else {
            if (index < this.itemCount) {
                ExpandItem item;
                int y = this.spacing - this.yCurrentScroll;
                int i = 0;
                while (i < index) {
                    item = this.items[i];
                    if (item.expanded) {
                        y += item.height;
                    }
                    y += item.getHeaderHeight() + this.spacing;
                    ++i;
                }
                i = index;
                while (i < this.itemCount) {
                    item = this.items[i];
                    item.setBounds(this.spacing, y, 0, 0, true, false);
                    if (item.expanded) {
                        y += item.height;
                    }
                    y += item.getHeaderHeight() + this.spacing;
                    ++i;
                }
            }
            if (setScrollbar) {
                this.setScrollbar();
            }
        }
    }

    long parentingHandle() {
        return OS.GTK_VERSION >= OS.VERSION(2, 4, 0) ? this.fixedHandle : this.handle;
    }

    void releaseChildren(boolean destroy) {
        int i = 0;
        while (i < this.itemCount) {
            ExpandItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    public void removeExpandListener(ExpandListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int result = super.setBounds(x, y, width, height, move, resize);
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && resize) {
            if ((this.style & 0x200) != 0) {
                this.setScrollbar();
            } else {
                int i = 0;
                while (i < this.itemCount) {
                    ExpandItem item = this.items[i];
                    int newWidth = Math.max(0, this.getClientArea().width - this.spacing * 2);
                    if (item.width != newWidth) {
                        item.setBounds(0, 0, newWidth, item.height, false, true);
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    void setFontDescription(long font) {
        super.setFontDescription(font);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            int i = 0;
            while (i < this.itemCount) {
                this.items[i].setFontDescription(font);
                ++i;
            }
            this.layoutItems(0, true);
        }
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            int i = 0;
            while (i < this.itemCount) {
                this.items[i].setForegroundColor(color);
                ++i;
            }
        }
    }

    void setScrollbar() {
        if (this.itemCount == 0) {
            return;
        }
        if ((this.style & 0x200) == 0) {
            return;
        }
        int height = this.getClientArea().height;
        ExpandItem item = this.items[this.itemCount - 1];
        int maxHeight = item.y + this.getBandHeight() + this.spacing;
        if (item.expanded) {
            maxHeight += item.height;
        }
        long adjustmentHandle = OS.gtk_scrolled_window_get_vadjustment(this.scrolledHandle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, adjustmentHandle);
        this.yCurrentScroll = (int)adjustment.value;
        if (this.yCurrentScroll > 0 && height > maxHeight) {
            this.yCurrentScroll = Math.max(0, this.yCurrentScroll + maxHeight - height);
            this.layoutItems(0, false);
        }
        adjustment.value = Math.min(this.yCurrentScroll, maxHeight += this.yCurrentScroll);
        adjustment.upper = maxHeight;
        adjustment.page_size = height;
        OS.memmove(adjustmentHandle, adjustment);
        OS.gtk_adjustment_changed(adjustmentHandle);
        int policy = maxHeight > height ? 0 : 2;
        OS.gtk_scrolled_window_set_policy(this.scrolledHandle, 2, policy);
        int width = OS.GTK_WIDGET_WIDTH(this.fixedHandle) - this.spacing * 2;
        if (policy == 0) {
            long vHandle = OS.GTK_SCROLLED_WINDOW_VSCROLLBAR(this.scrolledHandle);
            GtkRequisition requisition = new GtkRequisition();
            OS.gtk_widget_size_request(vHandle, requisition);
            width -= requisition.width;
        }
        width = Math.max(0, width);
        int i = 0;
        while (i < this.itemCount) {
            ExpandItem item2 = this.items[i];
            item2.setBounds(0, 0, width, item2.height, false, true);
            ++i;
        }
    }

    public void setSpacing(int spacing) {
        this.checkWidget();
        if (spacing < 0) {
            return;
        }
        if (spacing == this.spacing) {
            return;
        }
        this.spacing = spacing;
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.gtk_box_set_spacing(this.handle, spacing);
            OS.gtk_container_set_border_width(this.handle, spacing);
        } else {
            if ((this.style & 0x200) == 0) {
                int width = Math.max(0, this.getClientArea().width - spacing * 2);
                int i = 0;
                while (i < this.itemCount) {
                    ExpandItem item = this.items[i];
                    if (item.width != width) {
                        item.setBounds(0, 0, width, item.height, false, true);
                    }
                    ++i;
                }
            }
            this.layoutItems(0, true);
            this.redraw();
        }
    }

    void showItem(ExpandItem item) {
        Control control = item.control;
        if (control != null && !control.isDisposed()) {
            control.setVisible(item.expanded);
        }
        item.redraw();
        int index = this.indexOf(item);
        this.layoutItems(index + 1, true);
    }

    void updateScrollBarValue(ScrollBar bar) {
        this.yCurrentScroll = bar.getSelection();
        this.layoutItems(0, false);
    }
}

