/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventMotion;
import org.eclipse.swt.internal.gtk.GdkEventWindowState;
import org.eclipse.swt.internal.gtk.GdkGeometry;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GdkWindowAttr;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XFocusChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.TypedListener;

public class Shell
extends Decorations {
    long shellHandle;
    long tooltipsHandle;
    long tooltipWindow;
    long group;
    long modalGroup;
    boolean mapped;
    boolean moved;
    boolean resized;
    boolean opened;
    boolean fullScreen;
    boolean showWithParent;
    int oldX;
    int oldY;
    int oldWidth;
    int oldHeight;
    int minWidth;
    int minHeight;
    Control lastActive;
    static final int MAXIMUM_TRIM = 128;

    public Shell() {
        this((Display)null);
    }

    public Shell(int style) {
        this((Display)null, style);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int style) {
        this(display, null, style, 0L, false);
    }

    Shell(Display display, Shell parent, int style, long handle, boolean embedded) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        if (parent != null && parent.isDisposed()) {
            this.error(5);
        }
        this.style = Shell.checkStyle(style);
        this.parent = parent;
        this.display = display;
        if (handle != 0L) {
            if (embedded) {
                this.handle = handle;
            } else {
                this.shellHandle = handle;
                this.state |= 0x400000;
            }
        }
        this.createWidget(0);
    }

    public Shell(Shell parent) {
        this(parent, 2144);
    }

    public Shell(Shell parent, int style) {
        this(parent != null ? parent.display : null, parent, style, 0L, false);
    }

    public static Shell gtk_new(Display display, long handle) {
        return new Shell(display, null, 8, handle, true);
    }

    public static Shell internal_new(Display display, long handle) {
        return new Shell(display, null, 8, handle, false);
    }

    static int checkStyle(int style) {
        style = Decorations.checkStyle(style);
        if (((style &= 0xBFFFFFFF) & 0x4000) != 0) {
            style &= 0xFFFFFB0F;
        }
        int mask = 229376;
        int bits = style & ~mask;
        if ((style & 0x20000) != 0) {
            return bits | 0x20000;
        }
        if ((style & 0x10000) != 0) {
            return bits | 0x10000;
        }
        if ((style & 0x8000) != 0) {
            return bits | 0x8000;
        }
        return bits;
    }

    public void addShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(21, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
        this.addListener(26, typedListener);
        this.addListener(27, typedListener);
    }

    void adjustTrim() {
        if (this.display.ignoreTrim) {
            return;
        }
        int width = OS.GTK_WIDGET_WIDTH(this.shellHandle);
        int height = OS.GTK_WIDGET_HEIGHT(this.shellHandle);
        long window = OS.GTK_WIDGET_WINDOW(this.shellHandle);
        GdkRectangle rect = new GdkRectangle();
        OS.gdk_window_get_frame_extents(window, rect);
        int trimWidth = Math.max(0, rect.width - width);
        int trimHeight = Math.max(0, rect.height - height);
        if (trimWidth > 128 || trimHeight > 128) {
            this.display.ignoreTrim = true;
            return;
        }
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        if ((this.style & 8) == 0) {
            hasTitle = (this.style & 0x4E0) != 0;
            hasResize = (this.style & 0x10) != 0;
            boolean bl = hasBorder = (this.style & 0x800) != 0;
        }
        if (hasTitle) {
            if (hasResize) {
                this.display.titleResizeTrimWidth = trimWidth;
                this.display.titleResizeTrimHeight = trimHeight;
                return;
            }
            if (hasBorder) {
                this.display.titleBorderTrimWidth = trimWidth;
                this.display.titleBorderTrimHeight = trimHeight;
                return;
            }
            this.display.titleTrimWidth = trimWidth;
            this.display.titleTrimHeight = trimHeight;
            return;
        }
        if (hasResize) {
            this.display.resizeTrimWidth = trimWidth;
            this.display.resizeTrimHeight = trimHeight;
            return;
        }
        if (hasBorder) {
            this.display.borderTrimWidth = trimWidth;
            this.display.borderTrimHeight = trimHeight;
            return;
        }
    }

    void bringToTop(boolean force) {
        if (!OS.GTK_WIDGET_VISIBLE(this.shellHandle)) {
            return;
        }
        Display display = this.display;
        Shell activeShell = display.activeShell;
        if (activeShell == this) {
            return;
        }
        if (!force) {
            long focusHandle;
            if (activeShell == null) {
                return;
            }
            if (!display.activePending && (focusHandle = OS.gtk_window_get_focus(activeShell.shellHandle)) != 0L && !OS.GTK_WIDGET_HAS_FOCUS(focusHandle)) {
                return;
            }
        }
        boolean xFocus = false;
        if (activeShell != null) {
            if (OS.GTK_VERSION < OS.VERSION(2, 6, 8)) {
                xFocus = activeShell.isUndecorated();
            }
            display.activeShell = null;
            display.activePending = true;
        }
        long window = OS.GTK_WIDGET_WINDOW(this.shellHandle);
        if ((xFocus || (this.style & 0x4000) != 0) && OS.GDK_WINDOWING_X11()) {
            long xDisplay = OS.gdk_x11_drawable_get_xdisplay(window);
            long xWindow = OS.gdk_x11_drawable_get_xid(window);
            OS.gdk_error_trap_push();
            OS.XSetInputFocus(xDisplay, xWindow, 2, 0);
            OS.gdk_error_trap_pop();
        } else if (display.windowManager.toLowerCase().equals("metacity")) {
            OS.gdk_window_focus(window, display.lastUserEventTime);
        } else {
            OS.gdk_window_focus(window, 0);
        }
        display.activeShell = this;
        display.activePending = true;
    }

    void checkBorder() {
    }

    void checkOpen() {
        if (!this.opened) {
            this.resized = false;
        }
    }

    long childStyle() {
        return 0L;
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    void closeWidget() {
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = super.computeTrim(x, y, width, height);
        int border = 0;
        if ((this.style & 0xCF8) == 0) {
            border = OS.gtk_container_get_border_width(this.shellHandle);
        }
        int trimWidth = this.trimWidth();
        int trimHeight = this.trimHeight();
        trim.x -= trimWidth / 2 + border;
        trim.y -= trimHeight - trimWidth / 2 + border;
        trim.width += trimWidth + border * 2;
        trim.height += trimHeight + border * 2;
        if (this.menuBar != null) {
            this.forceResize();
            int menuBarHeight = OS.GTK_WIDGET_HEIGHT(this.menuBar.handle);
            trim.y -= menuBarHeight;
            trim.height += menuBarHeight;
        }
        return trim;
    }

    void createHandle(int index) {
        this.state |= 0xA;
        if (this.shellHandle == 0L) {
            if (this.handle == 0L) {
                int type = 0;
                if ((this.style & 0x4000) != 0) {
                    type = 1;
                }
                this.shellHandle = OS.gtk_window_new(type);
            } else {
                this.shellHandle = OS.gtk_plug_new(this.handle);
            }
            if (this.shellHandle == 0L) {
                this.error(2);
            }
            if (this.parent != null) {
                OS.gtk_window_set_transient_for(this.shellHandle, this.parent.topHandle());
                OS.gtk_window_set_destroy_with_parent(this.shellHandle, true);
                if (!this.isUndecorated()) {
                    OS.gtk_window_set_type_hint(this.shellHandle, 1);
                } else if (OS.GTK_VERSION >= OS.VERSION(2, 2, 0)) {
                    OS.gtk_window_set_skip_taskbar_hint(this.shellHandle, true);
                }
            }
            if ((this.style & 0x10) != 0) {
                OS.gtk_widget_set_size_request(this.shellHandle, 0, 0);
                OS.gtk_window_set_resizable(this.shellHandle, true);
            } else {
                OS.gtk_window_set_resizable(this.shellHandle, false);
            }
            this.vboxHandle = OS.gtk_vbox_new(false, 0);
            if (this.vboxHandle == 0L) {
                this.error(2);
            }
            this.createHandle(index, false, true);
            OS.gtk_container_add(this.vboxHandle, this.scrolledHandle);
            OS.gtk_box_set_child_packing(this.vboxHandle, this.scrolledHandle, true, true, 0, 1);
            OS.gtk_window_set_title(this.shellHandle, new byte[1]);
            if ((this.style & 0xCF8) == 0) {
                OS.gtk_container_set_border_width(this.shellHandle, 1);
                GdkColor color = new GdkColor();
                OS.gtk_style_get_black(OS.gtk_widget_get_style(this.shellHandle), color);
                OS.gtk_widget_modify_bg(this.shellHandle, 0, color);
            }
        } else {
            long children;
            this.vboxHandle = OS.gtk_bin_get_child(this.shellHandle);
            if (this.vboxHandle == 0L) {
                this.error(2);
            }
            if (OS.g_list_length(children = OS.gtk_container_get_children(this.vboxHandle)) > 0) {
                this.scrolledHandle = OS.g_list_data(children);
            }
            OS.g_list_free(children);
            if (this.scrolledHandle == 0L) {
                this.error(2);
            }
            this.handle = OS.gtk_bin_get_child(this.scrolledHandle);
            if (this.handle == 0L) {
                this.error(2);
            }
        }
        this.group = OS.gtk_window_group_new();
        if (this.group == 0L) {
            this.error(2);
        }
        OS.gtk_widget_realize(this.shellHandle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long filterProc(long xEvent, long gdkEvent, long data2) {
        int eventType = OS.X_EVENT_TYPE(xEvent);
        if (eventType != 10 && eventType != 9) {
            return 0L;
        }
        XFocusChangeEvent xFocusEvent = new XFocusChangeEvent();
        OS.memmove(xFocusEvent, xEvent, (long)XFocusChangeEvent.sizeof);
        switch (eventType) {
            case 9: {
                if (xFocusEvent.mode != 0 && xFocusEvent.mode != 3) return 0L;
                switch (xFocusEvent.detail) {
                    case 0: 
                    case 3: 
                    case 4: {
                        if (this.tooltipsHandle != 0L) {
                            OS.gtk_tooltips_enable(this.tooltipsHandle);
                        }
                        this.display.activeShell = this;
                        this.display.activePending = false;
                        this.sendEvent(26);
                    }
                }
                return 0L;
            }
            case 10: {
                if (xFocusEvent.mode != 0 && xFocusEvent.mode != 3) return 0L;
                switch (xFocusEvent.detail) {
                    case 1: 
                    case 3: 
                    case 4: {
                        if (this.tooltipsHandle != 0L) {
                            OS.gtk_tooltips_disable(this.tooltipsHandle);
                        }
                        Display display = this.display;
                        this.sendEvent(27);
                        this.setActiveControl(null);
                        if (display.activeShell != this) return 0L;
                        display.activeShell = null;
                        display.activePending = false;
                    }
                }
            }
        }
        return 0L;
    }

    Control findBackgroundControl() {
        return (this.state & 0x2000) != 0 || this.backgroundImage != null ? this : null;
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    boolean hasBorder() {
        return false;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[27], 0, this.display.closures[27], false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[59], 0, this.display.closures[59], false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[47], 0, this.display.closures[47], false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[10], 0, this.display.closures[10], false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[11], 0, this.display.closures[11], false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[31], 0, this.display.shellMapProcClosure, false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[14], 0, this.display.closures[14], false);
        OS.g_signal_connect_closure(this.shellHandle, OS.move_focus, this.display.closures[35], false);
        long window = OS.GTK_WIDGET_WINDOW(this.shellHandle);
        OS.gdk_window_add_filter(window, this.display.filterProc, this.shellHandle);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    boolean isUndecorated() {
        return (this.style & 0xCF0) == 0 || (this.style & 0x4008) != 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void register() {
        super.register();
        this.display.addWidget(this.shellHandle, this);
    }

    void releaseParent() {
    }

    long topHandle() {
        return this.shellHandle;
    }

    void fixActiveShell() {
        if (this.display.activeShell == this) {
            Shell shell = null;
            if (this.parent != null && this.parent.isVisible()) {
                shell = this.parent.getShell();
            }
            if (shell == null && this.isUndecorated()) {
                Shell[] shells = this.display.getShells();
                int i = 0;
                while (i < shells.length) {
                    if (shells[i] != null && shells[i].isVisible()) {
                        shell = shells[i];
                        break;
                    }
                    ++i;
                }
            }
            if (shell != null) {
                shell.bringToTop(false);
            }
        }
    }

    void fixShell(Shell newShell, Control control) {
        String toolTipText;
        if (this == newShell) {
            return;
        }
        if (control == this.lastActive) {
            this.setActiveControl(null);
        }
        if ((toolTipText = control.toolTipText) != null) {
            control.setToolTipText(this, null);
            control.setToolTipText(newShell, toolTipText);
        }
    }

    long fixedSizeAllocateProc(long widget, long allocationPtr) {
        int clientWidth = 0;
        if ((this.style & 0x8000000) != 0) {
            clientWidth = this.getClientWidth();
        }
        long result = super.fixedSizeAllocateProc(widget, allocationPtr);
        if ((this.style & 0x8000000) != 0) {
            this.moveChildren(clientWidth);
        }
        return result;
    }

    void fixStyle(long handle) {
    }

    void forceResize() {
        this.forceResize(OS.GTK_WIDGET_WIDTH(this.vboxHandle), OS.GTK_WIDGET_HEIGHT(this.vboxHandle));
    }

    void forceResize(int width, int height) {
        int border;
        GtkRequisition requisition = new GtkRequisition();
        OS.gtk_widget_size_request(this.vboxHandle, requisition);
        GtkAllocation allocation = new GtkAllocation();
        allocation.x = border = OS.gtk_container_get_border_width(this.shellHandle);
        allocation.y = border;
        allocation.width = width;
        allocation.height = height;
        OS.gtk_widget_size_allocate(this.vboxHandle, allocation);
    }

    public int getAlpha() {
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0) && OS.gtk_widget_is_composited(this.shellHandle)) {
            return (int)(OS.gtk_window_get_opacity(this.shellHandle) * 255.0);
        }
        return 255;
    }

    public boolean getFullScreen() {
        this.checkWidget();
        return this.fullScreen;
    }

    public Point getLocation() {
        this.checkWidget();
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gtk_window_get_position(this.shellHandle, x, y);
        return new Point(x[0], y[0]);
    }

    public boolean getMaximized() {
        this.checkWidget();
        return !this.fullScreen && super.getMaximized();
    }

    public Point getMinimumSize() {
        this.checkWidget();
        int width = Math.max(1, this.minWidth + this.trimWidth());
        int height = Math.max(1, this.minHeight + this.trimHeight());
        return new Point(width, height);
    }

    Shell getModalShell() {
        Shell shell = null;
        Shell[] modalShells = this.display.modalShells;
        if (modalShells != null) {
            int bits = 196608;
            int index = modalShells.length;
            while (--index >= 0) {
                Shell modal = modalShells[index];
                if (modal == null) continue;
                if ((modal.style & bits) != 0) {
                    Composite control = this;
                    while (control != null) {
                        if (control == modal) break;
                        control = control.parent;
                    }
                    if (control == modal) break;
                    return modal;
                }
                if ((modal.style & 0x8000) == 0) continue;
                if (shell == null) {
                    shell = this.getShell();
                }
                if (modal.parent != shell) continue;
                return modal;
            }
        }
        return null;
    }

    public Point getSize() {
        this.checkWidget();
        int width = OS.GTK_WIDGET_WIDTH(this.vboxHandle);
        int height = OS.GTK_WIDGET_HEIGHT(this.vboxHandle);
        int border = 0;
        if ((this.style & 0xCF8) == 0) {
            border = OS.gtk_container_get_border_width(this.shellHandle);
        }
        return new Point(width + this.trimWidth() + 2 * border, height + this.trimHeight() + 2 * border);
    }

    public boolean getVisible() {
        this.checkWidget();
        return OS.GTK_WIDGET_VISIBLE(this.shellHandle);
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    Shell _getShell() {
        return this;
    }

    public Shell[] getShells() {
        this.checkWidget();
        int count = 0;
        Shell[] shells = this.display.getShells();
        int i = 0;
        while (i < shells.length) {
            Composite shell = shells[i];
            while ((shell = shell.getParent()) != null && shell != this) {
            }
            if (shell == this) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        int i2 = 0;
        while (i2 < shells.length) {
            Composite shell = shells[i2];
            while ((shell = shell.getParent()) != null && shell != this) {
            }
            if (shell == this) {
                result[index++] = shells[i2];
            }
            ++i2;
        }
        return result;
    }

    long gtk_configure_event(long widget, long event) {
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gtk_window_get_position(this.shellHandle, x, y);
        if (!this.moved || this.oldX != x[0] || this.oldY != y[0]) {
            this.moved = true;
            this.oldX = x[0];
            this.oldY = y[0];
            this.sendEvent(10);
        }
        return 0L;
    }

    long gtk_delete_event(long widget, long event) {
        if (this.isEnabled()) {
            this.closeWidget();
        }
        return 1L;
    }

    long gtk_enter_notify_event(long widget, long event) {
        if (widget != this.shellHandle) {
            return super.gtk_enter_notify_event(widget, event);
        }
        return 0L;
    }

    long gtk_focus(long widget, long directionType) {
        switch ((int)directionType) {
            case 0: 
            case 1: {
                Control control = this.display.getFocusControl();
                if (control == null || (control.state & 2) == 0 || (control.style & 0x1000000) == 0) break;
                int traversal = directionType == 0L ? 16 : 8;
                control.traverse(traversal);
                return 1L;
            }
        }
        return super.gtk_focus(widget, directionType);
    }

    long gtk_move_focus(long widget, long directionType) {
        Control control = this.display.getFocusControl();
        if (control != null) {
            long focusHandle = control.focusHandle();
            OS.gtk_widget_child_focus(focusHandle, (int)directionType);
        }
        OS.g_signal_stop_emission_by_name(this.shellHandle, OS.move_focus);
        return 1L;
    }

    long gtk_key_press_event(long widget, long event) {
        if (widget == this.shellHandle) {
            return (this.state & 0x10) != 0 ? 1 : 0;
        }
        return super.gtk_key_press_event(widget, event);
    }

    long gtk_size_allocate(long widget, long allocation) {
        int width = OS.GTK_WIDGET_WIDTH(this.shellHandle);
        int height = OS.GTK_WIDGET_HEIGHT(this.shellHandle);
        if (!this.resized || this.oldWidth != width || this.oldHeight != height) {
            this.oldWidth = width;
            this.oldHeight = height;
            this.resizeBounds(width, height, true);
        }
        return 0L;
    }

    long gtk_realize(long widget) {
        long result = super.gtk_realize(widget);
        long window = OS.GTK_WIDGET_WINDOW(this.shellHandle);
        if ((this.style & 0x4F0) != 1264) {
            int decorations = 0;
            if ((this.style & 8) == 0) {
                if ((this.style & 0x80) != 0) {
                    decorations |= 0x20;
                }
                if ((this.style & 0x400) != 0) {
                    decorations |= 0x40;
                }
                if ((this.style & 0x10) != 0) {
                    decorations |= 4;
                }
                if ((this.style & 0x800) != 0) {
                    decorations |= 2;
                }
                if ((this.style & 0x40) != 0) {
                    decorations |= 0x10;
                }
                if ((this.style & 0x20) != 0) {
                    decorations |= 8;
                }
                if ((this.style & 0x10) != 0) {
                    decorations |= 2;
                }
            }
            OS.gdk_window_set_decorations(window, decorations);
        }
        if ((this.style & 0x4000) != 0) {
            OS.gdk_window_set_override_redirect(window, true);
        }
        return result;
    }

    long gtk_window_state_event(long widget, long event) {
        GdkEventWindowState gdkEvent = new GdkEventWindowState();
        OS.memmove(gdkEvent, event, (long)GdkEventWindowState.sizeof);
        this.minimized = (gdkEvent.new_window_state & 2) != 0;
        this.maximized = (gdkEvent.new_window_state & 4) != 0;
        boolean bl = this.fullScreen = (gdkEvent.new_window_state & 0x10) != 0;
        if ((gdkEvent.changed_mask & 2) != 0) {
            if (this.minimized) {
                this.sendEvent(19);
            } else {
                this.sendEvent(20);
            }
            this.updateMinimized(this.minimized);
        }
        return 0L;
    }

    public void open() {
        this.checkWidget();
        this.bringToTop(false);
        this.setVisible(true);
        if (this.isDisposed()) {
            return;
        }
        if (!this.restoreFocus() && !this.traverseGroup(true)) {
            this.setFocus();
        }
    }

    public boolean print(GC gc) {
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        return false;
    }

    public void removeShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(21, listener);
        this.eventTable.unhook(19, listener);
        this.eventTable.unhook(20, listener);
        this.eventTable.unhook(26, listener);
        this.eventTable.unhook(27, listener);
    }

    public void setActive() {
        this.checkWidget();
        this.bringToTop(false);
    }

    void setActiveControl(Control control) {
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] activate = control == null ? new Control[]{} : control.getPath();
        Control[] deactivate = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int index = 0;
        int length = Math.min(activate.length, deactivate.length);
        while (index < length) {
            if (activate[index] != deactivate[index]) break;
            ++index;
        }
        int i = deactivate.length - 1;
        while (i >= index) {
            if (!deactivate[i].isDisposed()) {
                deactivate[i].sendEvent(27);
            }
            --i;
        }
        i = activate.length - 1;
        while (i >= index) {
            if (!activate[i].isDisposed()) {
                activate[i].sendEvent(26);
            }
            --i;
        }
    }

    public void setAlpha(int alpha) {
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0) && OS.gtk_widget_is_composited(this.shellHandle)) {
            OS.gtk_window_set_opacity(this.shellHandle, (float)(alpha &= 0xFF) / 255.0f);
        }
    }

    void resizeBounds(int width, int height, boolean notify) {
        if (this.redrawWindow != 0L) {
            OS.gdk_window_resize(this.redrawWindow, width, height);
        }
        if (this.enableWindow != 0L) {
            OS.gdk_window_resize(this.enableWindow, width, height);
        }
        int border = OS.gtk_container_get_border_width(this.shellHandle);
        int boxWidth = width - 2 * border;
        int boxHeight = height - 2 * border;
        OS.gtk_widget_set_size_request(this.vboxHandle, boxWidth, boxHeight);
        this.forceResize(boxWidth, boxHeight);
        if (notify) {
            this.resized = true;
            this.sendEvent(11);
            if (this.isDisposed()) {
                return;
            }
            if (this.layout != null) {
                this.markLayout(false, false);
                this.updateLayout(false);
            }
        }
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        if (this.fullScreen) {
            this.setFullScreen(false);
        }
        if (this.getMaximized()) {
            boolean sameExtent;
            Rectangle rect = this.getBounds();
            boolean sameOrigin = !move || rect.x == x && rect.y == y;
            boolean bl = sameExtent = !resize || rect.width == width && rect.height == height;
            if (sameOrigin && sameExtent) {
                return 0;
            }
            this.setMaximized(false);
        }
        int result = 0;
        if (move) {
            int[] x_pos = new int[1];
            int[] y_pos = new int[1];
            OS.gtk_window_get_position(this.shellHandle, x_pos, y_pos);
            OS.gtk_window_move(this.shellHandle, x, y);
            if (x_pos[0] != x || y_pos[0] != y) {
                this.moved = true;
                this.oldX = x;
                this.oldY = y;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return 0;
                }
                result |= 0x80;
            }
        }
        if (resize) {
            boolean changed;
            width = Math.max(1, Math.max(this.minWidth, width - this.trimWidth()));
            height = Math.max(1, Math.max(this.minHeight, height - this.trimHeight()));
            if ((this.style & 0x10) != 0) {
                OS.gtk_window_resize(this.shellHandle, width, height);
            }
            boolean bl = changed = width != this.oldWidth || height != this.oldHeight;
            if (changed) {
                this.oldWidth = width;
                this.oldHeight = height;
                result |= 0x100;
            }
            this.resizeBounds(width, height, changed);
        }
        return result;
    }

    void setCursor(long cursor) {
        if (this.enableWindow != 0L) {
            OS.gdk_window_set_cursor(this.enableWindow, cursor);
            if (!OS.GDK_WINDOWING_X11()) {
                OS.gdk_flush();
            } else {
                long xDisplay = OS.GDK_DISPLAY();
                OS.XFlush(xDisplay);
            }
        }
        super.setCursor(cursor);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if ((this.state & 0x10) == 0 == enabled) {
            return;
        }
        Display display = this.display;
        Control control = null;
        boolean fixFocus = false;
        if (!enabled && display.focusEvent != 16) {
            control = display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        this.state = enabled ? (this.state &= 0xFFFFFFEF) : (this.state |= 0x10);
        this.enableWidget(enabled);
        if (this.isDisposed()) {
            return;
        }
        if (enabled) {
            if (this.enableWindow != 0L) {
                OS.gdk_window_set_user_data(this.enableWindow, 0L);
                OS.gdk_window_destroy(this.enableWindow);
                this.enableWindow = 0L;
            }
        } else {
            long parentHandle = this.shellHandle;
            OS.gtk_widget_realize(parentHandle);
            long window = OS.GTK_WIDGET_WINDOW(parentHandle);
            Rectangle rect = this.getBounds();
            GdkWindowAttr attributes = new GdkWindowAttr();
            attributes.width = rect.width;
            attributes.height = rect.height;
            attributes.event_mask = -32769;
            attributes.wclass = 1;
            attributes.window_type = 2;
            this.enableWindow = OS.gdk_window_new(window, attributes, 0);
            if (this.enableWindow != 0L) {
                if (this.cursor != null) {
                    OS.gdk_window_set_cursor(this.enableWindow, this.cursor.handle);
                    if (!OS.GDK_WINDOWING_X11()) {
                        OS.gdk_flush();
                    } else {
                        long xDisplay = OS.GDK_DISPLAY();
                        OS.XFlush(xDisplay);
                    }
                }
                OS.gdk_window_set_user_data(this.enableWindow, parentHandle);
                OS.gdk_window_show(this.enableWindow);
            }
        }
        if (fixFocus) {
            this.fixFocus(control);
        }
        if (enabled && display.activeShell == this && !this.restoreFocus()) {
            this.traverseGroup(false);
        }
    }

    public void setFullScreen(boolean fullScreen) {
        this.checkWidget();
        if (fullScreen) {
            OS.gtk_window_fullscreen(this.shellHandle);
        } else {
            OS.gtk_window_unfullscreen(this.shellHandle);
            if (this.maximized) {
                this.setMaximized(true);
            }
        }
        this.fullScreen = fullScreen;
    }

    public void setImeInputMode(int mode) {
        this.checkWidget();
    }

    void setInitialBounds() {
        if ((this.state & 0x400000) != 0) {
            return;
        }
        Monitor monitor = this.getMonitor();
        Rectangle rect = monitor.getClientArea();
        int width = rect.width * 5 / 8;
        int height = rect.height * 5 / 8;
        if ((this.style & 0x10) != 0) {
            OS.gtk_window_resize(this.shellHandle, width, height);
        }
        this.resizeBounds(width, height, false);
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        super.setMaximized(maximized);
        if (maximized) {
            OS.gtk_window_maximize(this.shellHandle);
        } else {
            OS.gtk_window_unmaximize(this.shellHandle);
        }
    }

    public void setMenuBar(Menu menu) {
        long menuHandle;
        boolean both;
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        boolean bl = both = menu != null && this.menuBar != null;
        if (menu != null) {
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        if (this.menuBar != null) {
            menuHandle = this.menuBar.handle;
            OS.gtk_widget_hide(menuHandle);
            this.destroyAccelGroup();
        }
        this.menuBar = menu;
        if (this.menuBar != null) {
            menuHandle = menu.handle;
            OS.gtk_widget_show(menuHandle);
            this.createAccelGroup();
            this.menuBar.addAccelerators(this.accelGroup);
        }
        int width = OS.GTK_WIDGET_WIDTH(this.vboxHandle);
        int height = OS.GTK_WIDGET_HEIGHT(this.vboxHandle);
        this.resizeBounds(width, height, !both);
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        if (this.minimized == minimized) {
            return;
        }
        super.setMinimized(minimized);
        if (minimized) {
            OS.gtk_window_iconify(this.shellHandle);
        } else {
            OS.gtk_window_deiconify(this.shellHandle);
            this.bringToTop(false);
        }
    }

    public void setMinimumSize(int width, int height) {
        this.checkWidget();
        GdkGeometry geometry = new GdkGeometry();
        this.minWidth = geometry.min_width = Math.max(width, this.trimWidth()) - this.trimWidth();
        this.minHeight = geometry.min_height = Math.max(height, this.trimHeight()) - this.trimHeight();
        OS.gtk_window_set_geometry_hints(this.shellHandle, 0L, geometry, 2);
    }

    public void setMinimumSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setMinimumSize(size.x, size.y);
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        super.setRegion(region);
    }

    void setRelations() {
    }

    public void setText(String string) {
        super.setText(string);
        int length = string.length();
        char[] chars = new char[Math.max(6, length) + 1];
        string.getChars(0, length, chars, 0);
        int i = length;
        while (i < chars.length) {
            chars[i] = 32;
            ++i;
        }
        byte[] buffer = Converter.wcsToMbcs(null, chars, true);
        OS.gtk_window_set_title(this.shellHandle, buffer);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        int mask = 229376;
        if ((this.style & mask) != 0) {
            if (visible) {
                this.display.setModalShell(this);
                OS.gtk_window_set_modal(this.shellHandle, true);
            } else {
                this.display.clearModal(this);
                OS.gtk_window_set_modal(this.shellHandle, false);
            }
        } else {
            this.updateModal();
        }
        this.showWithParent = visible;
        if (OS.GTK_WIDGET_MAPPED(this.shellHandle) == visible) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            OS.gtk_widget_show(this.shellHandle);
            if (this.enableWindow != 0L) {
                OS.gdk_window_raise(this.enableWindow);
            }
            if (!OS.GTK_IS_PLUG(this.shellHandle)) {
                this.mapped = false;
                if (this.isDisposed()) {
                    return;
                }
                this.display.dispatchEvents = new int[]{2, 12, 13, 14, 15, 30};
                Display display = this.display;
                display.putGdkEvents();
                boolean iconic = false;
                Shell shell = this.parent != null ? this.parent.getShell() : null;
                do {
                    OS.g_main_context_iteration(0L, false);
                    if (this.isDisposed()) break;
                    boolean bl = iconic = this.minimized || shell != null && shell.minimized;
                } while (!this.mapped && !iconic);
                display.dispatchEvents = null;
                if (this.isDisposed()) {
                    return;
                }
                if (!iconic) {
                    this.update(true, true);
                    if (this.isDisposed()) {
                        return;
                    }
                    this.adjustTrim();
                }
            }
            this.mapped = true;
            if ((this.style & mask) != 0) {
                OS.gdk_pointer_ungrab(0);
            }
            this.opened = true;
            if (!this.moved) {
                this.moved = true;
                Point location = this.getLocation();
                this.oldX = location.x;
                this.oldY = location.y;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            if (!this.resized) {
                this.resized = true;
                Point size = this.getSize();
                this.oldWidth = size.x - this.trimWidth();
                this.oldHeight = size.y - this.trimHeight();
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false);
                }
            }
        } else {
            this.fixActiveShell();
            OS.gtk_widget_hide(this.shellHandle);
            this.sendEvent(23);
        }
    }

    void setZOrder(Control sibling, boolean above, boolean fixRelations) {
        if (this.mapped) {
            this.setZOrder(sibling, above, false, false);
        }
    }

    long shellMapProc(long handle, long arg0, long user_data) {
        this.mapped = true;
        this.display.dispatchEvents = null;
        return 0L;
    }

    void showWidget() {
        if ((this.state & 0x400000) != 0) {
            return;
        }
        OS.gtk_container_add(this.shellHandle, this.vboxHandle);
        if (this.scrolledHandle != 0L) {
            OS.gtk_widget_show(this.scrolledHandle);
        }
        if (this.handle != 0L) {
            OS.gtk_widget_show(this.handle);
        }
        if (this.vboxHandle != 0L) {
            OS.gtk_widget_show(this.vboxHandle);
        }
    }

    long sizeAllocateProc(long handle, long arg0, long user_data) {
        int offset = 16;
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gdk_window_get_pointer(0L, x, y, null);
        y[0] = y[0] + offset;
        long screen = OS.gdk_screen_get_default();
        if (screen != 0L) {
            int monitorNumber = OS.gdk_screen_get_monitor_at_point(screen, x[0], y[0]);
            GdkRectangle dest = new GdkRectangle();
            OS.gdk_screen_get_monitor_geometry(screen, monitorNumber, dest);
            int width = OS.GTK_WIDGET_WIDTH(handle);
            int height = OS.GTK_WIDGET_HEIGHT(handle);
            if (x[0] + width > dest.x + dest.width) {
                x[0] = dest.x + dest.width - width;
            }
            if (y[0] + height > dest.y + dest.height) {
                y[0] = dest.y + dest.height - height;
            }
        }
        OS.gtk_window_move(handle, x[0], y[0]);
        return 0L;
    }

    long sizeRequestProc(long handle, long arg0, long user_data) {
        OS.gtk_widget_hide(handle);
        return 0L;
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    int trimHeight() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        if (this.fullScreen) {
            return 0;
        }
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        hasTitle = (this.style & 0x4E0) != 0;
        hasResize = (this.style & 0x10) != 0;
        boolean bl = hasBorder = (this.style & 0x800) != 0;
        if (hasTitle) {
            if (hasResize) {
                return this.display.titleResizeTrimHeight;
            }
            if (hasBorder) {
                return this.display.titleBorderTrimHeight;
            }
            return this.display.titleTrimHeight;
        }
        if (hasResize) {
            return this.display.resizeTrimHeight;
        }
        if (hasBorder) {
            return this.display.borderTrimHeight;
        }
        return 0;
    }

    int trimWidth() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        if (this.fullScreen) {
            return 0;
        }
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        hasTitle = (this.style & 0x4E0) != 0;
        hasResize = (this.style & 0x10) != 0;
        boolean bl = hasBorder = (this.style & 0x800) != 0;
        if (hasTitle) {
            if (hasResize) {
                return this.display.titleResizeTrimWidth;
            }
            if (hasBorder) {
                return this.display.titleBorderTrimWidth;
            }
            return this.display.titleTrimWidth;
        }
        if (hasResize) {
            return this.display.resizeTrimWidth;
        }
        if (hasBorder) {
            return this.display.borderTrimWidth;
        }
        return 0;
    }

    void updateModal() {
        long group = 0L;
        if (this.display.getModalDialog() == null) {
            Shell modal = this.getModalShell();
            int mask = 229376;
            Composite shell = null;
            if (modal == null) {
                if ((this.style & mask) != 0) {
                    shell = this;
                }
            } else {
                shell = modal;
            }
            while (shell != null) {
                if ((shell.style & mask) == 0) {
                    group = shell.getShell().group;
                    break;
                }
                shell = shell.parent;
            }
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0) && group == 0L) {
            group = OS.gtk_window_get_group(0L);
        }
        if (group != 0L) {
            OS.gtk_window_group_add_window(group, this.shellHandle);
        } else if (this.modalGroup != 0L) {
            OS.gtk_window_group_remove_window(this.modalGroup, this.shellHandle);
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0)) {
            this.fixModal(group, this.modalGroup);
        }
        this.modalGroup = group;
    }

    void updateMinimized(boolean minimized) {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            boolean update = false;
            Shell shell = shells[i];
            while (shell != null && shell != this && !shell.isUndecorated()) {
                shell = (Shell)shell.getParent();
            }
            if (shell != null && shell != this) {
                update = true;
            }
            if (update) {
                if (minimized) {
                    if (shells[i].isVisible()) {
                        shells[i].showWithParent = true;
                        OS.gtk_widget_hide(shells[i].shellHandle);
                    }
                } else if (shells[i].showWithParent) {
                    shells[i].showWithParent = false;
                    OS.gtk_widget_show(shells[i].shellHandle);
                }
            }
            ++i;
        }
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.shellHandle);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.fixActiveShell();
        OS.gtk_widget_hide(this.shellHandle);
        super.dispose();
    }

    public void forceActive() {
        this.checkWidget();
        this.bringToTop(true);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gtk_window_get_position(this.shellHandle, x, y);
        int width = OS.GTK_WIDGET_WIDTH(this.vboxHandle);
        int height = OS.GTK_WIDGET_HEIGHT(this.vboxHandle);
        int border = 0;
        if ((this.style & 0xCF8) == 0) {
            border = OS.gtk_container_get_border_width(this.shellHandle);
        }
        return new Rectangle(x[0], y[0], width + this.trimWidth() + 2 * border, height + this.trimHeight() + 2 * border);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.shellHandle = 0L;
    }

    void releaseChildren(boolean destroy) {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (shell != null && !shell.isDisposed()) {
                shell.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.destroyAccelGroup();
        this.display.clearModal(this);
        if (this.display.activeShell == this) {
            this.display.activeShell = null;
        }
        if (this.tooltipsHandle != 0L) {
            OS.g_object_unref(this.tooltipsHandle);
        }
        this.tooltipsHandle = 0L;
        if (this.group != 0L) {
            OS.g_object_unref(this.group);
        }
        this.modalGroup = 0L;
        this.group = 0L;
        long window = OS.GTK_WIDGET_WINDOW(this.shellHandle);
        OS.gdk_window_remove_filter(window, this.display.filterProc, this.shellHandle);
        this.lastActive = null;
    }

    void setToolTipText(long tipWidget, String string) {
        this.setToolTipText(tipWidget, tipWidget, string);
    }

    void setToolTipText(long rootWidget, long tipWidget, String string) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
            byte[] buffer = null;
            if (string != null && string.length() > 0) {
                char[] chars = this.fixMnemonic(string, false);
                buffer = Converter.wcsToMbcs(null, chars, true);
            }
            OS.gtk_widget_set_tooltip_text(rootWidget, null);
            long eventPtr = 0L;
            long tipWindow = OS.GTK_WIDGET_WINDOW(rootWidget);
            if (tipWindow != 0L) {
                int[] x = new int[1];
                int[] y = new int[1];
                long window = OS.gdk_window_at_pointer(x, y);
                long[] user_data = new long[1];
                OS.gdk_window_get_user_data(window, user_data);
                if (tipWidget == user_data[0]) {
                    eventPtr = OS.gdk_event_new(3);
                    GdkEventMotion event = new GdkEventMotion();
                    event.type = 3;
                    event.window = OS.g_object_ref(tipWindow);
                    event.x = x[0];
                    event.y = y[0];
                    OS.gdk_window_get_origin(window, x, y);
                    event.x_root = event.x + (double)x[0];
                    event.y_root = event.y + (double)y[0];
                    OS.memmove(eventPtr, event, (long)GdkEventMotion.sizeof);
                    OS.gtk_main_do_event(eventPtr);
                }
            }
            OS.gtk_widget_set_tooltip_text(rootWidget, buffer);
            if (eventPtr != 0L) {
                OS.gtk_main_do_event(eventPtr);
                OS.gdk_event_free(eventPtr);
            }
        } else {
            int[] y;
            int[] x;
            long window;
            long tipWindow;
            byte[] buffer = null;
            if (string != null && string.length() > 0) {
                char[] chars = this.fixMnemonic(string, false);
                buffer = Converter.wcsToMbcs(null, chars, true);
            }
            if (this.tooltipsHandle == 0L) {
                this.tooltipsHandle = OS.gtk_tooltips_new();
                if (this.tooltipsHandle == 0L) {
                    this.error(2);
                }
                OS.g_object_ref(this.tooltipsHandle);
                OS.gtk_object_sink(this.tooltipsHandle);
            }
            if (OS.GTK_VERSION >= OS.VERSION(2, 2, 1)) {
                OS.gtk_tooltips_force_window(this.tooltipsHandle);
            }
            if ((tipWindow = OS.GTK_TOOLTIPS_TIP_WINDOW(this.tooltipsHandle)) != 0L && tipWindow != this.tooltipWindow) {
                OS.g_signal_connect(tipWindow, OS.size_allocate, this.display.sizeAllocateProc, this.shellHandle);
                this.tooltipWindow = tipWindow;
            }
            boolean set = true;
            if (tipWindow != 0L && (OS.GTK_WIDGET_FLAGS(tipWidget) & 0x140) != 0 && (window = OS.gdk_window_at_pointer(x = new int[1], y = new int[1])) != 0L) {
                long[] user_data = new long[1];
                OS.gdk_window_get_user_data(window, user_data);
                if (tipWidget == user_data[0]) {
                    set = false;
                    int handler_id = OS.g_signal_connect(tipWindow, OS.size_request, this.display.sizeRequestProc, this.shellHandle);
                    OS.gtk_tooltips_set_tip(this.tooltipsHandle, tipWidget, buffer, null);
                    OS.gtk_widget_hide(tipWindow);
                    long data = OS.gtk_tooltips_data_get(tipWidget);
                    OS.GTK_TOOLTIPS_SET_ACTIVE(this.tooltipsHandle, data);
                    OS.gtk_tooltips_set_tip(this.tooltipsHandle, tipWidget, buffer, null);
                    if (handler_id != 0) {
                        OS.g_signal_handler_disconnect(tipWindow, handler_id);
                    }
                }
            }
            if (set) {
                OS.gtk_tooltips_set_tip(this.tooltipsHandle, tipWidget, buffer, null);
            }
        }
    }
}

