/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SWT_AWT {
    public static String embeddedFrameClass;
    static String EMBEDDED_FRAME_KEY;
    static boolean loaded;
    static boolean swingInitialized;

    static {
        EMBEDDED_FRAME_KEY = "org.eclipse.swt.awt.SWT_AWT.embeddedFrame";
    }

    static final native long getAWTHandle(Canvas var0);

    static final native void setDebug(Frame var0, boolean var1);

    static synchronized void loadLibrary() {
        if (loaded) {
            return;
        }
        loaded = true;
        try {
            System.loadLibrary("jawt");
        }
        catch (Throwable throwable) {}
        Library.loadLibrary("swt-awt");
    }

    static synchronized void initializeSwing() {
        if (swingInitialized) {
            return;
        }
        swingInitialized = true;
        OS.gdk_error_trap_push();
        try {
            Class[] classArray = new Class[]{};
            Object[] objectArray = new Object[]{};
            Class<?> clazz = Class.forName("javax.swing.UIManager");
            Method method = clazz.getMethod("getDefaults", classArray);
            if (method != null) {
                method.invoke(clazz, objectArray);
            }
        }
        catch (Throwable throwable) {}
    }

    public static Frame getFrame(Composite composite) {
        if (composite == null) {
            SWT.error(4);
        }
        if ((composite.getStyle() & 0x1000000) == 0) {
            return null;
        }
        return (Frame)composite.getData(EMBEDDED_FRAME_KEY);
    }

    public static Frame new_Frame(final Composite composite) {
        Object object;
        String string;
        if (composite == null) {
            SWT.error(4);
        }
        if ((composite.getStyle() & 0x1000000) == 0) {
            SWT.error(5);
        }
        long l = composite.embeddedHandle;
        Class<?> clazz = null;
        try {
            string = embeddedFrameClass != null ? embeddedFrameClass : "sun.awt.X11.XEmbeddedFrame";
            clazz = Class.forName(string);
        }
        catch (Throwable throwable) {
            SWT.error(20, throwable, " [need JDK 1.5 or greater]");
        }
        SWT_AWT.initializeSwing();
        string = null;
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getConstructor(Integer.TYPE, Boolean.TYPE);
            string = constructor.newInstance(new Integer((int)l), Boolean.TRUE);
        }
        catch (Throwable throwable) {
            try {
                constructor = clazz.getConstructor(Long.TYPE, Boolean.TYPE);
                string = constructor.newInstance(new Long(l), Boolean.TRUE);
            }
            catch (Throwable throwable2) {
                SWT.error(20, throwable2);
            }
        }
        final Frame frame = (Frame)((Object)string);
        composite.setData(EMBEDDED_FRAME_KEY, frame);
        if (Device.DEBUG) {
            SWT_AWT.loadLibrary();
            SWT_AWT.setDebug(frame, true);
        }
        try {
            object = clazz.getMethod("registerListeners", null);
            if (object != null) {
                ((Method)object).invoke((Object)string, null);
            }
        }
        catch (Throwable throwable) {}
        object = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 20: {
                        EventQueue.invokeLater(new Runnable(this, frame){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ Frame val$frame;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                            }

                            public void run() {
                                this.val$frame.dispatchEvent(new WindowEvent(this.val$frame, 204));
                            }
                        });
                        break;
                    }
                    case 19: {
                        EventQueue.invokeLater(new Runnable(this, frame){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ Frame val$frame;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                            }

                            public void run() {
                                this.val$frame.dispatchEvent(new WindowEvent(this.val$frame, 203));
                            }
                        });
                    }
                }
            }
        };
        Shell shell = composite.getShell();
        shell.addListener(20, (Listener)object);
        shell.addListener(19, (Listener)object);
        Listener listener = new Listener((Listener)object, frame){
            private final /* synthetic */ Listener val$shellListener;
            private final /* synthetic */ Frame val$frame;
            {
                this.val$shellListener = listener;
                this.val$frame = frame;
            }

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        Shell shell = composite.getShell();
                        shell.removeListener(20, this.val$shellListener);
                        shell.removeListener(19, this.val$shellListener);
                        composite.setVisible(false);
                        EventQueue.invokeLater(new Runnable(this, this.val$frame){
                            final /* synthetic */ 4 this$1;
                            private final /* synthetic */ Frame val$frame;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                            }

                            public void run() {
                                this.val$frame.dispose();
                            }
                        });
                        break;
                    }
                    case 11: {
                        if (Library.JAVA_VERSION < Library.JAVA_VERSION(1, 6, 0)) break;
                        Rectangle rectangle = composite.getClientArea();
                        EventQueue.invokeLater(new Runnable(this, this.val$frame, rectangle){
                            final /* synthetic */ 4 this$1;
                            private final /* synthetic */ Frame val$frame;
                            private final /* synthetic */ Rectangle val$clientArea;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                                this.val$clientArea = rectangle;
                            }

                            public void run() {
                                this.val$frame.setSize(this.val$clientArea.width, this.val$clientArea.height);
                            }
                        });
                    }
                }
            }
        };
        composite.addListener(12, listener);
        composite.addListener(11, listener);
        composite.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (composite.isDisposed()) {
                    return;
                }
                Rectangle rectangle = composite.getClientArea();
                EventQueue.invokeLater(new Runnable(this, frame, rectangle){
                    final /* synthetic */ 7 this$1;
                    private final /* synthetic */ Frame val$frame;
                    private final /* synthetic */ Rectangle val$clientArea;
                    {
                        this.this$1 = var1_1;
                        this.val$frame = frame;
                        this.val$clientArea = rectangle;
                    }

                    public void run() {
                        this.val$frame.setSize(this.val$clientArea.width, this.val$clientArea.height);
                        this.val$frame.validate();
                    }
                });
            }
        });
        return frame;
    }

    public static Shell new_Shell(final Display display, final Canvas canvas) {
        if (display == null) {
            SWT.error(4);
        }
        if (canvas == null) {
            SWT.error(4);
        }
        long l = 0L;
        try {
            SWT_AWT.loadLibrary();
            l = SWT_AWT.getAWTHandle(canvas);
        }
        catch (Throwable throwable) {
            SWT.error(20, throwable);
        }
        if (l == 0L) {
            SWT.error(5, null, " [peer not created]");
        }
        final Shell shell = Shell.gtk_new(display, l);
        canvas.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                display.syncExec(new Runnable(this, canvas, shell){
                    final /* synthetic */ 9 this$1;
                    private final /* synthetic */ Canvas val$parent;
                    private final /* synthetic */ Shell val$shell;
                    {
                        this.this$1 = var1_1;
                        this.val$parent = canvas;
                        this.val$shell = shell;
                    }

                    public void run() {
                        Dimension dimension = this.val$parent.getSize();
                        this.val$shell.setSize(dimension.width, dimension.height);
                    }
                });
            }
        });
        shell.setVisible(true);
        return shell;
    }
}

