/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Slider
extends Control {
    int detail;
    boolean dragSent;

    public Slider(Composite composite, int n) {
        super(composite, Slider.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return Slider.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    void createHandle(int n) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        long l = OS.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 10.0);
        if (l == 0L) {
            this.error(2);
        }
        this.handle = (this.style & 0x100) != 0 ? OS.gtk_hscrollbar_new(l) : OS.gtk_vscrollbar_new(l);
        if (this.handle == 0L) {
            this.error(2);
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 10, 0) || (this.style & 0x200) != 0) {
            OS.GTK_WIDGET_SET_FLAGS(this.handle, 2048);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
    }

    long gtk_button_press_event(long l, long l2) {
        long l3 = super.gtk_button_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        this.detail = 0;
        this.dragSent = false;
        return l3;
    }

    long gtk_change_value(long l, long l2, long l3, long l4) {
        this.detail = (int)l2;
        return 0L;
    }

    long gtk_value_changed(long l) {
        Event event = new Event();
        this.dragSent = this.detail == 1;
        switch (this.detail) {
            case 0: {
                event.detail = 0;
                break;
            }
            case 1: {
                event.detail = 1;
                break;
            }
            case 14: {
                event.detail = 0x1000007;
                break;
            }
            case 15: {
                event.detail = 0x1000008;
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                event.detail = 0x1000006;
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                event.detail = 0x1000005;
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                event.detail = 0x1000002;
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                event.detail = 0x1000001;
            }
        }
        if (!this.dragSent) {
            this.detail = 0;
        }
        this.postEvent(13, event);
        return 0L;
    }

    long gtk_event_after(long l, long l2) {
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, l2, (long)GdkEvent.sizeof);
        switch (gdkEvent.type) {
            case 7: {
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
                if (gdkEventButton.button == 1 && this.detail == 1) {
                    if (!this.dragSent) {
                        Event event = new Event();
                        event.detail = 1;
                        this.postEvent(13, event);
                    }
                    this.postEvent(13);
                }
                this.detail = 0;
                this.dragSent = false;
            }
        }
        return super.gtk_event_after(l, l2);
    }

    void hookEvents() {
        super.hookEvents();
        if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
            OS.g_signal_connect_closure(this.handle, OS.change_value, this.display.closures[7], false);
        }
        OS.g_signal_connect_closure(this.handle, OS.value_changed, this.display.closures[57], false);
    }

    void register() {
        super.register();
        long l = OS.gtk_range_get_adjustment(this.handle);
        this.display.addWidget(l, this);
    }

    void deregister() {
        super.deregister();
        long l = OS.gtk_range_get_adjustment(this.handle);
        this.display.removeWidget(l);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        Point point = this.computeNativeSize(this.handle, n, n2, bl);
        if ((this.style & 0x100) != 0) {
            if (n == -1) {
                point.x = 2 * point.x;
            }
        } else if (n2 == -1) {
            point.y = 2 * point.y;
        }
        return point;
    }

    public int getIncrement() {
        this.checkWidget();
        long l = OS.gtk_range_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        return (int)gtkAdjustment.step_increment;
    }

    public int getMaximum() {
        this.checkWidget();
        long l = OS.gtk_range_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        return (int)gtkAdjustment.upper;
    }

    public int getMinimum() {
        this.checkWidget();
        long l = OS.gtk_range_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        return (int)gtkAdjustment.lower;
    }

    public int getPageIncrement() {
        this.checkWidget();
        long l = OS.gtk_range_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        return (int)gtkAdjustment.page_increment;
    }

    public int getSelection() {
        this.checkWidget();
        long l = OS.gtk_range_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        return (int)gtkAdjustment.value;
    }

    public int getThumb() {
        this.checkWidget();
        long l = OS.gtk_range_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        return (int)gtkAdjustment.page_size;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_range_set_increments(this.handle, n, this.getPageIncrement());
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        long l = OS.gtk_range_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        int n2 = (int)gtkAdjustment.lower;
        if (n <= n2) {
            return;
        }
        gtkAdjustment.upper = n;
        gtkAdjustment.page_size = Math.min((int)gtkAdjustment.page_size, n - n2);
        gtkAdjustment.value = Math.min((int)gtkAdjustment.value, (int)((double)n - gtkAdjustment.page_size));
        OS.memmove(l, gtkAdjustment);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_adjustment_changed(l);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        long l = OS.gtk_range_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        int n2 = (int)gtkAdjustment.upper;
        if (n >= n2) {
            return;
        }
        gtkAdjustment.lower = n;
        gtkAdjustment.page_size = Math.min((int)gtkAdjustment.page_size, n2 - n);
        gtkAdjustment.value = Math.max((int)gtkAdjustment.value, n);
        OS.memmove(l, gtkAdjustment);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_adjustment_changed(l);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    void setOrientation() {
        super.setOrientation();
        if ((this.style & 0x4000000) != 0 && (this.style & 0x100) != 0) {
            OS.gtk_range_set_inverted(this.handle, true);
        }
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_range_set_increments(this.handle, this.getIncrement(), n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setSelection(int n) {
        this.checkWidget();
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_range_set_value(this.handle, n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setThumb(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        long l = OS.gtk_range_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        n = Math.min(n, (int)(gtkAdjustment.upper - gtkAdjustment.lower));
        gtkAdjustment.page_size = n;
        gtkAdjustment.value = Math.min((int)gtkAdjustment.value, (int)(gtkAdjustment.upper - (double)n));
        OS.memmove(l, gtkAdjustment);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_adjustment_changed(l);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (n3 < 0) {
            return;
        }
        if (n4 < 1) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        n4 = Math.min(n4, n3 - n2);
        long l = OS.gtk_range_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        gtkAdjustment.value = Math.min(Math.max(n, n2), n3 - n4);
        gtkAdjustment.lower = n2;
        gtkAdjustment.upper = n3;
        gtkAdjustment.page_size = n4;
        gtkAdjustment.step_increment = n5;
        gtkAdjustment.page_increment = n6;
        OS.memmove(l, gtkAdjustment);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_adjustment_changed(l);
        OS.gtk_adjustment_value_changed(l);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }
}

