/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.mozilla.nsIBaseWindow;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

class MozillaDelegate {
    Browser browser;
    long mozillaHandle;
    long embedHandle;
    boolean hasFocus;
    Listener listener;
    static Callback eventCallback;
    static long eventProc;
    static final int STOP_PROPOGATE = 1;
    static boolean IsSparc;

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        IsSparc = (osName.startsWith("sunos") || osName.startsWith("solaris")) && osArch.startsWith("sparc");
    }

    MozillaDelegate(Browser browser) {
        if (IsSparc) {
            browser.dispose();
            SWT.error(2, null, " [Unsupported platform]");
        }
        this.browser = browser;
    }

    static long eventProc(long handle, long gdkEvent, long pointer) {
        long parent = OS.gtk_widget_get_parent(handle);
        if ((parent = OS.gtk_widget_get_parent(parent)) == 0L) {
            return 0L;
        }
        Widget widget = Display.getCurrent().findWidget(parent);
        if (widget != null && widget instanceof Browser) {
            return ((Mozilla)((Browser)widget).webBrowser).delegate.gtk_event(handle, gdkEvent, pointer);
        }
        return 0L;
    }

    static Browser findBrowser(long handle) {
        long parent = OS.gtk_widget_get_parent(handle);
        Display display = Display.getCurrent();
        return (Browser)display.findWidget(parent);
    }

    static char[] mbcsToWcs(String codePage, byte[] buffer) {
        return Converter.mbcsToWcs(codePage, buffer);
    }

    static byte[] wcsToMbcs(String codePage, String string, boolean terminate) {
        return Converter.wcsToMbcs(codePage, string, terminate);
    }

    void addWindowSubclass() {
    }

    int createBaseWindow(nsIBaseWindow baseWindow) {
        return baseWindow.Create();
    }

    long getHandle() {
        this.embedHandle = OS.gtk_hbox_new(false, 0);
        OS.gtk_container_add(this.browser.handle, this.embedHandle);
        OS.gtk_widget_show(this.embedHandle);
        return this.embedHandle;
    }

    String getJSLibraryName() {
        return "libmozjs.so";
    }

    String getLibraryName() {
        return "libxpcom.so";
    }

    String getSWTInitLibraryName() {
        return "swt-xpcominit";
    }

    long gtk_event(long handle, long gdkEvent, long pointer) {
        GdkEvent event = new GdkEvent();
        OS.memmove(event, gdkEvent, (long)GdkEvent.sizeof);
        if (event.type == 4 && !this.hasFocus) {
            this.browser.setFocus();
        }
        if (pointer == 1L) {
            return 1L;
        }
        return 0L;
    }

    void handleFocus() {
        if (this.hasFocus) {
            return;
        }
        this.hasFocus = true;
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == MozillaDelegate.this.browser) {
                    return;
                }
                ((Mozilla)MozillaDelegate.this.browser.webBrowser).Deactivate();
                MozillaDelegate.this.hasFocus = false;
                MozillaDelegate.this.browser.getDisplay().removeFilter(15, this);
                MozillaDelegate.this.browser.getShell().removeListener(27, this);
                MozillaDelegate.this.listener = null;
            }
        };
        this.browser.getDisplay().addFilter(15, this.listener);
        this.browser.getShell().addListener(27, this.listener);
    }

    void handleMouseDown() {
        int shellStyle = this.browser.getShell().getStyle();
        if ((shellStyle & 0x4000) != 0 && ((shellStyle & 0x80000) == 0 || (this.browser.getStyle() & 0x80000) == 0)) {
            this.browser.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (MozillaDelegate.this.browser == null || MozillaDelegate.this.browser.isDisposed()) {
                        return;
                    }
                    ((Mozilla)MozillaDelegate.this.browser.webBrowser).Activate();
                }
            });
        }
    }

    boolean hookEnterExit() {
        return false;
    }

    void init() {
        long list;
        if (eventCallback == null && (eventProc = (eventCallback = new Callback(this.getClass(), "eventProc", 3)).getAddress()) == 0L) {
            this.browser.dispose();
            Mozilla.error(3);
        }
        if ((list = OS.gtk_container_get_children(this.embedHandle)) != 0L) {
            this.mozillaHandle = OS.g_list_data(list);
            OS.g_list_free(list);
            if (this.mozillaHandle != 0L) {
                OS.g_signal_connect(this.mozillaHandle, OS.event, eventProc, 0L);
                OS.g_signal_connect(this.mozillaHandle, OS.key_press_event, eventProc, 1L);
                OS.g_signal_connect(this.mozillaHandle, OS.key_release_event, eventProc, 1L);
                OS.g_signal_connect(this.mozillaHandle, OS.button_press_event, eventProc, 1L);
            }
        }
    }

    boolean needsSpinup() {
        return true;
    }

    void onDispose(long embedHandle) {
        if (this.listener != null) {
            this.browser.getDisplay().removeFilter(15, this.listener);
            this.browser.getShell().removeListener(27, this.listener);
            this.listener = null;
        }
        this.browser = null;
    }

    void removeWindowSubclass() {
    }

    void setSize(long embedHandle, int width, int height) {
        OS.gtk_widget_set_size_request(embedHandle, width, height);
    }
}

