/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TableDragSourceEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDragSourceEffect;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkDragContext;
import org.eclipse.swt.internal.gtk.GtkSelectionData;
import org.eclipse.swt.internal.gtk.GtkTargetEntry;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DragSourceEffect dragEffect;
    int targetList;
    boolean moveData = false;
    static final String DEFAULT_DRAG_SOURCE_EFFECT = "DEFAULT_DRAG_SOURCE_EFFECT";
    static Callback DragGetData;
    static Callback DragEnd;
    static Callback DragDataDelete;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((DragGetData = new Callback(clazz3, "DragGetData", 5)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((clazz2 = class$0) == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((DragEnd = new Callback(clazz2, "DragEnd", 2)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((DragDataDelete = new Callback(clazz, "DragDataDelete", 2)).getAddress() == 0) {
            SWT.error(3);
        }
    }

    public DragSource(Control control, int n) {
        super(control, DragSource.checkStyle(n));
        this.control = control;
        if (DragGetData == null || DragEnd == null || DragDataDelete == null) {
            DND.error(2000);
        }
        if (control.getData("DragSource") != null) {
            DND.error(2000);
        }
        control.setData("DragSource", this);
        OS.g_signal_connect(control.handle, OS.drag_data_get, DragGetData.getAddress(), 0);
        OS.g_signal_connect(control.handle, OS.drag_end, DragEnd.getAddress(), 0);
        OS.g_signal_connect(control.handle, OS.drag_data_delete, DragDataDelete.getAddress(), 0);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 12 && !DragSource.this.isDisposed()) {
                    DragSource.this.dispose();
                }
                if (event.type == 29 && !DragSource.this.isDisposed()) {
                    DragSource.this.drag(event);
                }
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        Object object = control.getData(DEFAULT_DRAG_SOURCE_EFFECT);
        if (object instanceof DragSourceEffect) {
            this.dragEffect = (DragSourceEffect)object;
        } else if (control instanceof Tree) {
            this.dragEffect = new TreeDragSourceEffect((Tree)control);
        } else if (control instanceof Table) {
            this.dragEffect = new TableDragSourceEffect((Table)control);
        }
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DragSource.this.onDispose();
            }
        });
    }

    static int checkStyle(int n) {
        if (n == 0) {
            return 2;
        }
        return n;
    }

    static int DragDataDelete(int n, int n2) {
        DragSource dragSource = DragSource.FindDragSource(n);
        if (dragSource == null) {
            return 0;
        }
        dragSource.dragDataDelete(n, n2);
        return 0;
    }

    static int DragEnd(int n, int n2) {
        DragSource dragSource = DragSource.FindDragSource(n);
        if (dragSource == null) {
            return 0;
        }
        dragSource.dragEnd(n, n2);
        return 0;
    }

    static int DragGetData(int n, int n2, int n3, int n4, int n5) {
        DragSource dragSource = DragSource.FindDragSource(n);
        if (dragSource == null) {
            return 0;
        }
        dragSource.dragGetData(n, n2, n3, n4, n5);
        return 0;
    }

    static DragSource FindDragSource(int n) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(n);
        if (widget == null) {
            return null;
        }
        return (DragSource)widget.getData("DragSource");
    }

    public void addDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dragSourceListener);
        dNDListener.dndWidget = this;
        this.addListener(2008, dNDListener);
        this.addListener(2001, dNDListener);
        this.addListener(2000, dNDListener);
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            DND.error(43);
        }
    }

    void drag(Event event) {
        this.moveData = false;
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.x = event.x;
        dNDEvent.y = event.y;
        dNDEvent.time = event.time;
        dNDEvent.doit = true;
        this.notifyListeners(2008, dNDEvent);
        if (!dNDEvent.doit || this.transferAgents == null || this.transferAgents.length == 0) {
            return;
        }
        if (this.targetList == 0) {
            return;
        }
        int n = this.opToOsOp(this.getStyle());
        Image image = dNDEvent.image;
        int n2 = OS.gtk_drag_begin(this.control.handle, this.targetList, n, 1, 0);
        if (n2 != 0 && image != null) {
            int n3 = DragSource.createPixbuf(image);
            OS.gtk_drag_set_icon_pixbuf(n2, n3, 0, 0);
            OS.g_object_unref(n3);
        }
    }

    void dragEnd(int n, int n2) {
        Object object;
        OS.gdk_pointer_ungrab(0);
        OS.gdk_keyboard_ungrab(0);
        int n3 = 0;
        if (n2 != 0) {
            object = new GdkDragContext();
            OS.memmove((GdkDragContext)object, n2, GdkDragContext.sizeof);
            if (((GdkDragContext)object).dest_window != 0) {
                if (this.moveData) {
                    n3 = 2;
                } else {
                    n3 = this.osOpToOp(((GdkDragContext)object).action);
                    if (n3 == 2) {
                        n3 = 0;
                    }
                }
            }
        }
        object = new DNDEvent();
        ((DNDEvent)object).widget = this;
        ((DNDEvent)object).doit = n3 != 0;
        ((DNDEvent)object).detail = n3;
        this.notifyListeners(2000, (Event)object);
        this.moveData = false;
    }

    void dragGetData(int n, int n2, int n3, int n4, int n5) {
        if (n3 == 0) {
            return;
        }
        GtkSelectionData gtkSelectionData = new GtkSelectionData();
        OS.memmove(gtkSelectionData, n3, GtkSelectionData.sizeof);
        if (gtkSelectionData.target == 0) {
            return;
        }
        TransferData transferData = new TransferData();
        transferData.type = gtkSelectionData.target;
        transferData.pValue = gtkSelectionData.data;
        transferData.length = gtkSelectionData.length;
        transferData.format = gtkSelectionData.format;
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = n5;
        dNDEvent.dataType = transferData;
        this.notifyListeners(2001, dNDEvent);
        if (!dNDEvent.doit) {
            return;
        }
        Transfer transfer = null;
        int n6 = 0;
        while (n6 < this.transferAgents.length) {
            Transfer transfer2 = this.transferAgents[n6];
            if (transfer2 != null && transfer2.isSupportedType(transferData)) {
                transfer = transfer2;
                break;
            }
            ++n6;
        }
        if (transfer == null) {
            return;
        }
        transfer.javaToNative(dNDEvent.data, transferData);
        if (transferData.result != 1) {
            return;
        }
        OS.gtk_selection_data_set(n3, transferData.type, transferData.format, transferData.pValue, transferData.length);
        OS.g_free(transferData.pValue);
    }

    void dragDataDelete(int n, int n2) {
        this.moveData = true;
    }

    public Control getControl() {
        return this.control;
    }

    public DragSourceListener[] getDragListeners() {
        Listener[] listenerArray = this.getListeners(2008);
        int n = listenerArray.length;
        DragSourceListener[] dragSourceListenerArray = new DragSourceListener[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Listener listener = listenerArray[n3];
            if (listener instanceof DNDListener) {
                dragSourceListenerArray[n2] = (DragSourceListener)((DNDListener)listener).getEventListener();
                ++n2;
            }
            ++n3;
        }
        if (n2 == n) {
            return dragSourceListenerArray;
        }
        DragSourceListener[] dragSourceListenerArray2 = new DragSourceListener[n2];
        System.arraycopy(dragSourceListenerArray, 0, dragSourceListenerArray2, 0, n2);
        return dragSourceListenerArray2;
    }

    public DragSourceEffect getDragSourceEffect() {
        return this.dragEffect;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.targetList != 0) {
            OS.gtk_target_list_unref(this.targetList);
        }
        this.targetList = 0;
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DragSource", null);
        this.control = null;
        this.transferAgents = null;
    }

    int opToOsOp(int n) {
        int n2 = 0;
        if ((n & 1) == 1) {
            n2 |= 2;
        }
        if ((n & 2) == 2) {
            n2 |= 4;
        }
        if ((n & 4) == 4) {
            n2 |= 8;
        }
        return n2;
    }

    int osOpToOp(int n) {
        int n2 = 0;
        if ((n & 2) == 2) {
            n2 |= 1;
        }
        if ((n & 4) == 4) {
            n2 |= 2;
        }
        if ((n & 8) == 8) {
            n2 |= 4;
        }
        return n2;
    }

    public void removeDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error(4);
        }
        this.removeListener(2008, dragSourceListener);
        this.removeListener(2001, dragSourceListener);
        this.removeListener(2000, dragSourceListener);
    }

    public void setDragSourceEffect(DragSourceEffect dragSourceEffect) {
        this.dragEffect = dragSourceEffect;
    }

    public void setTransfer(Transfer[] transferArray) {
        if (this.targetList != 0) {
            OS.gtk_target_list_unref(this.targetList);
            this.targetList = 0;
        }
        this.transferAgents = transferArray;
        if (transferArray == null || transferArray.length == 0) {
            return;
        }
        GtkTargetEntry[] gtkTargetEntryArray = new GtkTargetEntry[]{};
        int n = 0;
        while (n < transferArray.length) {
            Transfer transfer = transferArray[n];
            if (transfer != null) {
                int[] nArray = transfer.getTypeIds();
                String[] stringArray = transfer.getTypeNames();
                int n2 = 0;
                while (n2 < nArray.length) {
                    GtkTargetEntry gtkTargetEntry = new GtkTargetEntry();
                    byte[] byArray = Converter.wcsToMbcs(null, stringArray[n2], true);
                    gtkTargetEntry.target = OS.g_malloc(byArray.length);
                    OS.memmove(gtkTargetEntry.target, byArray, byArray.length);
                    gtkTargetEntry.info = nArray[n2];
                    GtkTargetEntry[] gtkTargetEntryArray2 = new GtkTargetEntry[gtkTargetEntryArray.length + 1];
                    System.arraycopy(gtkTargetEntryArray, 0, gtkTargetEntryArray2, 0, gtkTargetEntryArray.length);
                    gtkTargetEntryArray2[gtkTargetEntryArray.length] = gtkTargetEntry;
                    gtkTargetEntryArray = gtkTargetEntryArray2;
                    ++n2;
                }
            }
            ++n;
        }
        n = OS.g_malloc(gtkTargetEntryArray.length * GtkTargetEntry.sizeof);
        int n3 = 0;
        while (n3 < gtkTargetEntryArray.length) {
            OS.memmove(n + n3 * GtkTargetEntry.sizeof, gtkTargetEntryArray[n3], GtkTargetEntry.sizeof);
            ++n3;
        }
        this.targetList = OS.gtk_target_list_new(n, gtkTargetEntryArray.length);
        n3 = 0;
        while (n3 < gtkTargetEntryArray.length) {
            OS.g_free(gtkTargetEntryArray[n3].target);
            ++n3;
        }
    }

    static int createPixbuf(Image image) {
        int n;
        boolean bl;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_drawable_get_size(image.pixmap, nArray, nArray2);
        int n2 = OS.gdk_colormap_get_system();
        boolean bl2 = bl = image.mask != 0 && OS.gdk_drawable_get_depth(image.mask) == 1;
        if (bl) {
            n = OS.gdk_pixbuf_new(0, true, 8, nArray[0], nArray2[0]);
            if (n == 0) {
                SWT.error(2);
            }
            OS.gdk_pixbuf_get_from_drawable(n, image.pixmap, n2, 0, 0, 0, 0, nArray[0], nArray2[0]);
            int n3 = OS.gdk_pixbuf_new(0, false, 8, nArray[0], nArray2[0]);
            if (n3 == 0) {
                SWT.error(2);
            }
            OS.gdk_pixbuf_get_from_drawable(n3, image.mask, 0, 0, 0, 0, 0, nArray[0], nArray2[0]);
            int n4 = OS.gdk_pixbuf_get_rowstride(n);
            int n5 = OS.gdk_pixbuf_get_pixels(n);
            byte[] byArray = new byte[n4];
            int n6 = OS.gdk_pixbuf_get_rowstride(n3);
            int n7 = OS.gdk_pixbuf_get_pixels(n3);
            byte[] byArray2 = new byte[n6];
            int n8 = 0;
            while (n8 < nArray2[0]) {
                int n9 = n5 + n8 * n4;
                OS.memmove(byArray, n9, n4);
                int n10 = n7 + n8 * n6;
                OS.memmove(byArray2, n10, n6);
                int n11 = 0;
                while (n11 < nArray[0]) {
                    if (byArray2[n11 * 3] == 0) {
                        byArray[n11 * 4 + 3] = 0;
                    }
                    ++n11;
                }
                OS.memmove(n9, byArray, n4);
                ++n8;
            }
            OS.g_object_unref(n3);
        } else {
            ImageData imageData = image.getImageData();
            boolean bl3 = imageData.getTransparencyType() == 1;
            n = OS.gdk_pixbuf_new(0, bl3, 8, nArray[0], nArray2[0]);
            if (n == 0) {
                SWT.error(2);
            }
            OS.gdk_pixbuf_get_from_drawable(n, image.pixmap, n2, 0, 0, 0, 0, nArray[0], nArray2[0]);
            if (bl3) {
                byte[] byArray = imageData.alphaData;
                int n12 = OS.gdk_pixbuf_get_rowstride(n);
                int n13 = OS.gdk_pixbuf_get_pixels(n);
                byte[] byArray3 = new byte[n12];
                int n14 = 0;
                while (n14 < nArray2[0]) {
                    int n15 = n13 + n14 * n12;
                    OS.memmove(byArray3, n15, n12);
                    int n16 = 0;
                    while (n16 < nArray[0]) {
                        byArray3[n16 * 4 + 3] = byArray[n14 * nArray[0] + n16];
                        ++n16;
                    }
                    OS.memmove(n15, byArray3, n12);
                    ++n14;
                }
            }
        }
        return n;
    }
}

