/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.Theme;

public class DrawData {
    public int style;
    public int[] state = new int[1];
    public Rectangle clientArea;
    public static final int SELECTED = 2;
    public static final int FOCUSED = 4;
    public static final int PRESSED = 8;
    public static final int ACTIVE = 16;
    public static final int DISABLED = 32;
    public static final int HOT = 64;
    public static final int DEFAULTED = 128;
    public static final int GRAYED = 256;
    public static final int DRAW_LEFT = 16;
    public static final int DRAW_TOP = 32;
    public static final int DRAW_RIGHT = 64;
    public static final int DRAW_BOTTOM = 128;
    public static final int DRAW_HCENTER = 256;
    public static final int DRAW_VCENTER = 512;
    public static final int WIDGET_NOWHERE = -1;
    public static final int WIDGET_WHOLE = 0;
    public static final int SCROLLBAR_UP_ARROW = 1;
    public static final int SCROLLBAR_DOWN_ARROW = 2;
    public static final int SCROLLBAR_LEFT_ARROW = 1;
    public static final int SCROLLBAR_RIGHT_ARROW = 2;
    public static final int SCROLLBAR_UP_TRACK = 3;
    public static final int SCROLLBAR_DOWN_TRACK = 4;
    public static final int SCROLLBAR_LEFT_TRACK = 3;
    public static final int SCROLLBAR_RIGHT_TRACK = 4;
    public static final int SCROLLBAR_THUMB = 5;
    public static final int SCALE_UP_TRACK = 1;
    public static final int SCALE_LEFT_TRACK = 1;
    public static final int SCALE_DOWN_TRACK = 2;
    public static final int SCALE_RIGHT_TRACK = 2;
    public static final int SCALE_THUMB = 3;
    public static final int TOOLITEM_ARROW = 1;
    public static final int COMBO_ARROW = 1;

    Rectangle computeTrim(Theme theme, GC gC) {
        return new Rectangle(this.clientArea.x, this.clientArea.y, this.clientArea.width, this.clientArea.height);
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
    }

    void drawImage(Theme theme, Image image, GC gC, Rectangle rectangle) {
        int n = gC.getGCData().drawable;
        Rectangle rectangle2 = image.getBounds();
        int n2 = this.getStateType(0);
        if (n2 == 0) {
            gC.drawImage(image, 0, 0, rectangle2.width, rectangle2.height, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            int n3 = Theme.createPixbuf(image);
            int n4 = OS.gtk_icon_source_new();
            if (n4 != 0) {
                OS.gtk_icon_source_set_pixbuf(n4, n3);
                int n5 = theme.buttonHandle;
                int n6 = OS.gtk_widget_get_style(n5);
                theme.transferClipping(gC, n6);
                int n7 = OS.gtk_style_render_icon(n6, n4, 0, n2, -1, n5, null);
                OS.g_object_unref(n3);
                if (n7 != 0) {
                    OS.gdk_draw_pixbuf(n, gC.handle, n7, 0, 0, rectangle.x, rectangle.y, rectangle.width, rectangle.height, 1, 0, 0);
                    OS.g_object_unref(n7);
                }
                OS.gtk_icon_source_free(n4);
            }
        }
    }

    void drawText(Theme theme, String string, int n, GC gC, Rectangle rectangle) {
        int n2 = this.getTextHandle(theme);
        int n3 = OS.gtk_widget_get_style(n2);
        int n4 = gC.getGCData().drawable;
        theme.transferClipping(gC, n3);
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int n5 = OS.gtk_widget_create_pango_layout(n2, byArray);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_size(n5, nArray, nArray2);
        OS.pango_layout_set_width(n5, rectangle.width * 1024);
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        if ((n & 0x10) != 0) {
            OS.pango_layout_set_alignment(n5, 0);
        }
        if ((n & 0x100) != 0) {
            OS.pango_layout_set_alignment(n5, 1);
        }
        if ((n & 0x40) != 0) {
            OS.pango_layout_set_alignment(n5, 2);
        }
        if ((n & 0x200) != 0) {
            n7 += (rectangle.height - OS.PANGO_PIXELS(nArray2[0])) / 2;
        }
        if ((n & 0x80) != 0) {
            n7 += rectangle.height - OS.PANGO_PIXELS(nArray2[0]);
        }
        int n8 = this.getStateType(0);
        byte[] byArray2 = Converter.wcsToMbcs(null, "label", true);
        OS.gtk_paint_layout(n3, n4, n8, false, null, n2, byArray2, n6, n7, n5);
        OS.g_object_unref(n5);
    }

    Rectangle getBounds(int n, Rectangle rectangle) {
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    int getStateType(int n) {
        int n2 = this.state[n];
        int n3 = 0;
        if ((n2 & 0x20) != 0) {
            n3 = 4;
        } else {
            if ((n2 & 2) != 0) {
                n3 = 1;
            }
            if ((n2 & 0x40) != 0) {
                n3 = (n2 & 8) != 0 ? 1 : 2;
            }
        }
        return n3;
    }

    int getTextHandle(Theme theme) {
        return theme.labelHandle;
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        return -1;
    }

    Rectangle measureText(Theme theme, String string, int n, GC gC, Rectangle rectangle) {
        int n2 = this.getTextHandle(theme);
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int n3 = OS.gtk_widget_create_pango_layout(n2, byArray);
        if (rectangle != null) {
            OS.pango_layout_set_width(n3, rectangle.width);
        }
        if ((n & 0x10) != 0) {
            OS.pango_layout_set_alignment(n3, 0);
        }
        if ((n & 0x100) != 0) {
            OS.pango_layout_set_alignment(n3, 1);
        }
        if ((n & 0x40) != 0) {
            OS.pango_layout_set_alignment(n3, 2);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_size(n3, nArray, nArray2);
        OS.g_object_unref(n3);
        return new Rectangle(0, 0, OS.PANGO_PIXELS(nArray[0]), OS.PANGO_PIXELS(nArray2[0]));
    }
}

