/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkCellRendererClass;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class Table
extends Composite {
    long modelHandle;
    long checkRenderer;
    int itemCount;
    int columnCount;
    int lastIndexOf;
    int sortDirection;
    long ignoreCell;
    TableItem[] items;
    TableColumn[] columns;
    TableItem currentItem;
    TableColumn sortColumn;
    ImageList imageList;
    ImageList headerImageList;
    boolean firstCustomDraw;
    int drawState;
    int drawFlags;
    GdkColor drawForeground;
    boolean ownerDraw;
    boolean ignoreSize;
    static final int CHECKED_COLUMN = 0;
    static final int GRAYED_COLUMN = 1;
    static final int FOREGROUND_COLUMN = 2;
    static final int BACKGROUND_COLUMN = 3;
    static final int FONT_COLUMN = 4;
    static final int FIRST_COLUMN = 5;
    static final int CELL_PIXBUF = 0;
    static final int CELL_TEXT = 1;
    static final int CELL_FOREGROUND = 2;
    static final int CELL_BACKGROUND = 3;
    static final int CELL_FONT = 4;
    static final int CELL_TYPES = 5;

    public Table(Composite composite, int n) {
        super(composite, Table.checkStyle(n));
    }

    void _addListener(int n, Listener listener) {
        super._addListener(n, listener);
        if (!this.ownerDraw) {
            switch (n) {
                case 40: 
                case 41: 
                case 42: {
                    this.ownerDraw = true;
                    this.recreateRenderers();
                }
            }
        }
    }

    TableItem _getItem(int n) {
        if ((this.style & 0x10000000) == 0) {
            return this.items[n];
        }
        if (this.items[n] != null) {
            return this.items[n];
        }
        this.items[n] = new TableItem(this, 0, n, false);
        return this.items[n];
    }

    static int checkStyle(int n) {
        if ((n & 0x10) == 0) {
            n |= 0x300;
        }
        return Table.checkBits(n |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    long cellDataProc(long l, long l2, long l3, long l4, long l5) {
        Object object;
        boolean bl;
        if (l2 == this.ignoreCell) {
            return 0L;
        }
        long l6 = OS.gtk_tree_model_get_path(l3, l4);
        int[] nArray = new int[1];
        OS.memmove(nArray, OS.gtk_tree_path_get_indices(l6), 4L);
        TableItem tableItem = this._getItem(nArray[0]);
        OS.gtk_tree_path_free(l6);
        if (tableItem != null) {
            OS.g_object_set_qdata(l2, Display.SWT_OBJECT_INDEX2, tableItem.handle);
        }
        if (!(bl = OS.GTK_IS_CELL_RENDERER_PIXBUF(l2)) && !OS.GTK_IS_CELL_RENDERER_TEXT(l2)) {
            return 0L;
        }
        int n = -1;
        boolean bl2 = false;
        if (this.columnCount == 0) {
            n = 5;
            bl2 = this.firstCustomDraw;
        } else {
            TableColumn tableColumn = (TableColumn)this.display.getWidget(l);
            if (tableColumn != null) {
                n = tableColumn.modelIndex;
                bl2 = tableColumn.customDraw;
            }
        }
        if (n == -1) {
            return 0L;
        }
        boolean bl3 = false;
        if ((this.style & 0x10000000) != 0) {
            if (OS.GTK_VERSION < OS.VERSION(2, 3, 2)) {
                OS.gtk_widget_realize(this.handle);
                object = new GdkRectangle();
                OS.gtk_tree_view_get_visible_rect(this.handle, (GdkRectangle)object);
                GdkRectangle gdkRectangle = new GdkRectangle();
                l6 = OS.gtk_tree_model_get_path(l3, l4);
                OS.gtk_tree_view_get_cell_area(this.handle, l6, l, gdkRectangle);
                OS.gtk_tree_path_free(l6);
                if (gdkRectangle.y + gdkRectangle.height < 0 || gdkRectangle.y + object.y > object.y + object.height) {
                    if (this.imageList != null && this.imageList.pixbufs.length > 0 && bl) {
                        OS.g_object_set(l2, OS.pixbuf, this.imageList.pixbufs[0], 0L);
                    }
                    return 0L;
                }
            }
            if (!tableItem.cached) {
                this.lastIndexOf = nArray[0];
                bl3 = this.checkData(tableItem);
            }
        }
        object = new long[1];
        if (bl3) {
            object[0] = 0L;
            if (bl) {
                OS.gtk_tree_model_get(l3, l4, n + 0, object, -1L);
                OS.g_object_set(l2, OS.pixbuf, object[0], 0L);
            } else {
                OS.gtk_tree_model_get(l3, l4, n + 1, object, -1L);
                if (object[0] != 0L) {
                    OS.g_object_set(l2, OS.text, object[0], 0L);
                    OS.g_free(object[0]);
                }
            }
        }
        if (bl2) {
            if (OS.GTK_VERSION > OS.VERSION(2, 2, 1) && !this.ownerDraw) {
                object[0] = 0L;
                OS.gtk_tree_model_get(l3, l4, n + 3, object, -1L);
                if (object[0] != 0L) {
                    OS.g_object_set(l2, OS.cell_background_gdk, object[0], 0L);
                }
            }
            if (!bl) {
                object[0] = 0L;
                OS.gtk_tree_model_get(l3, l4, n + 2, object, -1L);
                if (object[0] != 0L) {
                    OS.g_object_set(l2, OS.foreground_gdk, object[0], 0L);
                }
                object[0] = 0L;
                OS.gtk_tree_model_get(l3, l4, n + 4, object, -1L);
                if (object[0] != 0L) {
                    OS.g_object_set(l2, OS.font_desc, object[0], 0L);
                }
            }
        }
        if (bl3) {
            this.ignoreCell = l2;
            this.setScrollWidth(l, tableItem);
            this.ignoreCell = 0L;
        }
        return 0L;
    }

    boolean checkData(TableItem tableItem) {
        if (tableItem.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            tableItem.cached = true;
            Event event = new Event();
            event.item = tableItem;
            event.index = this.indexOf(tableItem);
            int n = 17;
            int n2 = OS.g_signal_lookup(OS.row_changed, OS.gtk_tree_model_get_type());
            OS.g_signal_handlers_block_matched(this.modelHandle, n, n2, 0, 0L, 0L, this.handle);
            this.currentItem = tableItem;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed()) {
                return false;
            }
            OS.g_signal_handlers_unblock_matched(this.modelHandle, n, n2, 0, 0L, 0L, this.handle);
            if (tableItem.isDisposed()) {
                return false;
            }
        }
        return true;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int calculateWidth(long l, long l2) {
        OS.gtk_tree_view_column_cell_set_cell_data(l, this.modelHandle, l2, false, false);
        int n = 0;
        int[] nArray = new int[1];
        OS.gtk_widget_style_get(this.handle, OS.focus_line_width, nArray, 0L);
        n += 2 * nArray[0];
        long l3 = OS.gtk_tree_view_column_get_cell_renderers(l);
        if (l3 == 0L) {
            return 0;
        }
        long l4 = l3;
        while (l4 != 0L) {
            long l5 = OS.g_list_data(l4);
            if (l5 != 0L) {
                OS.gtk_cell_renderer_get_size(l5, this.handle, null, null, null, nArray, null);
                n += nArray[0];
            }
            l4 = OS.g_list_next(l4);
        }
        OS.g_list_free(l3);
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0) && OS.gtk_tree_view_get_rules_hint(this.handle)) {
            OS.gtk_widget_style_get(this.handle, OS.grid_line_width, nArray, 0L);
            n += 2 * nArray[0];
        }
        return n;
    }

    public void clear(int n) {
        TableItem tableItem;
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            this.error(6);
        }
        if ((tableItem = this.items[n]) != null) {
            tableItem.clear();
        }
    }

    public void clear(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (n < 0 || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        if (n == 0 && n2 == this.itemCount - 1) {
            this.clearAll();
        } else {
            int n3 = n;
            while (n3 <= n2) {
                TableItem tableItem = this.items[n3];
                if (tableItem != null) {
                    tableItem.clear();
                }
                ++n3;
            }
        }
    }

    public void clear(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] < 0 || nArray[n] >= this.itemCount) {
                this.error(6);
            }
            ++n;
        }
        n = 0;
        while (n < nArray.length) {
            TableItem tableItem = this.items[nArray[n]];
            if (tableItem != null) {
                tableItem.clear();
            }
            ++n;
        }
    }

    public void clearAll() {
        this.checkWidget();
        int n = 0;
        while (n < this.itemCount) {
            TableItem tableItem = this.items[n];
            if (tableItem != null) {
                tableItem.clear();
            }
            ++n;
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        Point point = this.computeNativeSize(this.handle, n, n2, bl);
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        point.x = rectangle.width;
        point.y = rectangle.height;
        return point;
    }

    void createColumn(TableColumn tableColumn, int n) {
        boolean bl;
        long l;
        int n2;
        int n3 = 5;
        if (this.columnCount != 0) {
            int n4 = OS.gtk_tree_model_get_n_columns(this.modelHandle);
            boolean[] blArray = new boolean[n4];
            int n5 = 0;
            while (n5 < this.columnCount) {
                n2 = this.columns[n5].modelIndex;
                int n6 = 0;
                while (n6 < 5) {
                    blArray[n2 + n6] = true;
                    ++n6;
                }
                ++n5;
            }
            while (n3 < n4) {
                if (!blArray[n3]) break;
                ++n3;
            }
            if (n3 == n4) {
                long l2 = this.modelHandle;
                long[] lArray = this.getColumnTypes(this.columnCount + 4);
                long l3 = OS.gtk_list_store_newv(lArray.length, lArray);
                if (l3 == 0L) {
                    this.error(2);
                }
                long[] lArray2 = new long[1];
                int n7 = 0;
                while (n7 < this.itemCount) {
                    long l4 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                    if (l4 == 0L) {
                        this.error(2);
                    }
                    OS.gtk_list_store_append(l3, l4);
                    TableItem tableItem = this.items[n7];
                    if (tableItem != null) {
                        long l5 = tableItem.handle;
                        int n8 = 0;
                        while (n8 < n4) {
                            OS.gtk_tree_model_get(l2, l5, n8, lArray2, -1L);
                            OS.gtk_list_store_set(l3, l4, n8, lArray2[0], -1L);
                            if (lArray[n8] == OS.G_TYPE_STRING()) {
                                OS.g_free(lArray2[0]);
                            }
                            ++n8;
                        }
                        OS.gtk_list_store_remove(l2, l5);
                        OS.g_free(l5);
                        tableItem.handle = l4;
                    } else {
                        OS.g_free(l4);
                    }
                    ++n7;
                }
                OS.gtk_tree_view_set_model(this.handle, l3);
                OS.g_object_unref(l2);
                this.modelHandle = l3;
            }
        }
        if ((l = OS.gtk_tree_view_column_new()) == 0L) {
            this.error(2);
        }
        if (n == 0 && this.columnCount > 0) {
            TableColumn tableColumn2 = this.columns[0];
            this.createRenderers(tableColumn2.handle, tableColumn2.modelIndex, false, tableColumn2.style);
        }
        this.createRenderers(l, n3, n == 0, tableColumn == null ? 0 : tableColumn.style);
        boolean bl2 = bl = (this.style & 0x10000000) != 0 && OS.GTK_VERSION >= OS.VERSION(2, 3, 2);
        if (!bl && this.columnCount == 0) {
            OS.gtk_tree_view_column_set_sizing(l, 0);
        } else {
            OS.gtk_tree_view_column_set_sizing(l, 2);
            if (this.columnCount != 0) {
                OS.gtk_tree_view_column_set_visible(l, false);
            }
        }
        OS.gtk_tree_view_column_set_resizable(l, true);
        OS.gtk_tree_view_column_set_clickable(l, true);
        OS.gtk_tree_view_column_set_min_width(l, 0);
        OS.gtk_tree_view_insert_column(this.handle, l, n);
        if (tableColumn != null) {
            tableColumn.handle = l;
            tableColumn.modelIndex = n3;
        }
        if ((this.style & 0x10000000) != 0) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 5)) {
                OS.gtk_tree_view_set_search_column(this.handle, -1);
            } else {
                OS.gtk_tree_view_set_enable_search(this.handle, false);
            }
        } else {
            n2 = this.columnCount == 0 ? 5 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, n2 + 1);
        }
    }

    void createHandle(int n) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        this.scrolledHandle = OS.gtk_scrolled_window_new(0L, 0L);
        if (this.scrolledHandle == 0L) {
            this.error(2);
        }
        long[] lArray = this.getColumnTypes(1);
        this.modelHandle = OS.gtk_list_store_newv(lArray.length, lArray);
        if (this.modelHandle == 0L) {
            this.error(2);
        }
        this.handle = OS.gtk_tree_view_new_with_model(this.modelHandle);
        if (this.handle == 0L) {
            this.error(2);
        }
        if ((this.style & 0x20) != 0) {
            this.checkRenderer = OS.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0L) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
        }
        this.createColumn(null, 0);
        OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
        OS.gtk_container_add(this.scrolledHandle, this.handle);
        int n2 = (this.style & 2) != 0 ? 3 : 2;
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.gtk_tree_selection_set_mode(l, n2);
        OS.gtk_tree_view_set_headers_visible(this.handle, false);
        int n3 = (this.style & 0x100) != 0 ? 1 : 2;
        int n4 = (this.style & 0x200) != 0 ? 1 : 2;
        OS.gtk_scrolled_window_set_policy(this.scrolledHandle, n3, n4);
        if ((this.style & 0x800) != 0) {
            OS.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
        }
        if ((this.style & 0x10000000) != 0) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 3, 2)) {
                OS.g_object_set(this.handle, OS.fixed_height_mode, true, 0L);
            }
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 5)) {
                OS.gtk_tree_view_set_search_column(this.handle, -1);
            } else {
                OS.gtk_tree_view_set_enable_search(this.handle, false);
            }
        }
    }

    void createItem(TableColumn tableColumn, int n) {
        long l;
        long l2;
        if (n < 0 || n > this.columnCount) {
            this.error(6);
        }
        if (this.columnCount == 0) {
            tableColumn.handle = OS.gtk_tree_view_get_column(this.handle, 0);
            OS.gtk_tree_view_column_set_sizing(tableColumn.handle, 2);
            OS.gtk_tree_view_column_set_visible(tableColumn.handle, false);
            tableColumn.modelIndex = 5;
            this.createRenderers(tableColumn.handle, tableColumn.modelIndex, true, tableColumn.style);
            tableColumn.customDraw = this.firstCustomDraw;
            this.firstCustomDraw = false;
        } else {
            this.createColumn(tableColumn, n);
        }
        long l3 = OS.gtk_hbox_new(false, 3);
        if (l3 == 0L) {
            this.error(2);
        }
        if ((l2 = OS.gtk_label_new_with_mnemonic(null)) == 0L) {
            this.error(2);
        }
        if ((l = OS.gtk_image_new()) == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(l3, l);
        OS.gtk_container_add(l3, l2);
        OS.gtk_widget_show(l3);
        OS.gtk_widget_show(l2);
        tableColumn.labelHandle = l2;
        tableColumn.imageHandle = l;
        OS.gtk_tree_view_column_set_widget(tableColumn.handle, l3);
        long l4 = OS.gtk_widget_get_parent(l3);
        while (l4 != this.handle) {
            if (OS.GTK_IS_BUTTON(l4)) {
                tableColumn.buttonHandle = l4;
                break;
            }
            l4 = OS.gtk_widget_get_parent(l4);
        }
        if (this.columnCount == this.columns.length) {
            TableColumn[] tableColumnArray = new TableColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columns.length);
            this.columns = tableColumnArray;
        }
        System.arraycopy(this.columns, n, this.columns, n + 1, this.columnCount++ - n);
        this.columns[n] = tableColumn;
        if ((this.state & 0x4000) != 0) {
            tableColumn.setFontDescription(this.getFontDescription());
        }
        if (this.columnCount >= 1) {
            int n2 = 0;
            while (n2 < this.itemCount) {
                Font[] fontArray;
                TableItem tableItem = this.items[n2];
                if (tableItem != null && (fontArray = tableItem.cellFont) != null) {
                    Font[] fontArray2 = new Font[this.columnCount];
                    System.arraycopy(fontArray, 0, fontArray2, 0, n);
                    System.arraycopy(fontArray, n, fontArray2, n + 1, this.columnCount - n - 1);
                    tableItem.cellFont = fontArray2;
                }
                ++n2;
            }
        }
    }

    void createItem(TableItem tableItem, int n) {
        if (n < 0 || n > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            int n2 = this.drawCount == 0 ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TableItem[] tableItemArray = new TableItem[n2];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.items.length);
            this.items = tableItemArray;
        }
        tableItem.handle = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (tableItem.handle == 0L) {
            this.error(2);
        }
        if (n == this.itemCount) {
            OS.gtk_list_store_append(this.modelHandle, tableItem.handle);
        } else {
            OS.gtk_list_store_insert(this.modelHandle, tableItem.handle, n);
        }
        System.arraycopy(this.items, n, this.items, n + 1, this.itemCount++ - n);
        this.items[n] = tableItem;
    }

    void createRenderers(long l, int n, boolean bl, int n2) {
        long l2;
        long l3;
        OS.gtk_tree_view_column_clear(l);
        if ((this.style & 0x20) != 0 && bl) {
            OS.gtk_tree_view_column_pack_start(l, this.checkRenderer, false);
            OS.gtk_tree_view_column_add_attribute(l, this.checkRenderer, OS.active, 0);
            if (OS.GTK_VERSION >= OS.VERSION(2, 2, 0)) {
                OS.gtk_tree_view_column_add_attribute(l, this.checkRenderer, OS.inconsistent, 1);
            }
            if (OS.GTK_VERSION > OS.VERSION(2, 2, 1) && !this.ownerDraw) {
                OS.gtk_tree_view_column_add_attribute(l, this.checkRenderer, OS.cell_background_gdk, 3);
            }
            if (this.ownerDraw) {
                OS.gtk_tree_view_column_set_cell_data_func(l, this.checkRenderer, this.display.cellDataProc, this.handle, 0L);
                OS.g_object_set_qdata(this.checkRenderer, Display.SWT_OBJECT_INDEX1, l);
            }
        }
        long l4 = l3 = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_pixbuf_get_type(), 0L) : OS.gtk_cell_renderer_pixbuf_new();
        if (l3 == 0L) {
            this.error(2);
        }
        long l5 = l2 = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_text_get_type(), 0L) : OS.gtk_cell_renderer_text_new();
        if (l2 == 0L) {
            this.error(2);
        }
        if (this.ownerDraw) {
            OS.g_object_set_qdata(l3, Display.SWT_OBJECT_INDEX1, l);
            OS.g_object_set_qdata(l2, Display.SWT_OBJECT_INDEX1, l);
        }
        if ((this.style & 0x20) != 0 && bl) {
            OS.g_object_set(l3, OS.mode, 1, 0L);
        }
        if ((n2 & 0x20000) != 0) {
            OS.g_object_set(l2, OS.xalign, 1.0f, 0L);
            OS.gtk_tree_view_column_pack_end(l, l2, true);
            OS.gtk_tree_view_column_pack_end(l, l3, false);
            OS.gtk_tree_view_column_set_alignment(l, 1.0f);
        } else if ((n2 & 0x1000000) != 0) {
            OS.g_object_set(l2, OS.xalign, 0.5f, 0L);
            OS.gtk_tree_view_column_pack_start(l, l3, false);
            OS.gtk_tree_view_column_pack_end(l, l2, true);
            OS.gtk_tree_view_column_set_alignment(l, 0.5f);
        } else {
            OS.gtk_tree_view_column_pack_start(l, l3, false);
            OS.gtk_tree_view_column_pack_start(l, l2, true);
            OS.gtk_tree_view_column_set_alignment(l, 0.0f);
        }
        OS.gtk_tree_view_column_add_attribute(l, l3, OS.pixbuf, n + 0);
        if (OS.GTK_VERSION > OS.VERSION(2, 2, 1) && !this.ownerDraw) {
            OS.gtk_tree_view_column_add_attribute(l, l3, OS.cell_background_gdk, 3);
            OS.gtk_tree_view_column_add_attribute(l, l2, OS.cell_background_gdk, 3);
        }
        OS.gtk_tree_view_column_add_attribute(l, l2, OS.text, n + 1);
        OS.gtk_tree_view_column_add_attribute(l, l2, OS.foreground_gdk, 2);
        OS.gtk_tree_view_column_add_attribute(l, l2, OS.font_desc, 4);
        boolean bl2 = this.firstCustomDraw;
        if (this.columnCount != 0) {
            int n3 = 0;
            while (n3 < this.columnCount) {
                if (this.columns[n3].handle == l) {
                    bl2 = this.columns[n3].customDraw;
                    break;
                }
                ++n3;
            }
        }
        if ((this.style & 0x10000000) != 0 || bl2 || this.ownerDraw) {
            OS.gtk_tree_view_column_set_cell_data_func(l, l2, this.display.cellDataProc, this.handle, 0L);
            OS.gtk_tree_view_column_set_cell_data_func(l, l3, this.display.cellDataProc, this.handle, 0L);
        }
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.items = new TableItem[4];
        this.columns = new TableColumn[4];
        this.columnCount = 0;
        this.itemCount = 0;
    }

    GdkColor defaultBackground() {
        return this.display.COLOR_LIST_BACKGROUND;
    }

    GdkColor defaultForeground() {
        return this.display.COLOR_LIST_FOREGROUND;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(OS.gtk_tree_view_get_selection(this.handle));
        if (this.checkRenderer != 0L) {
            this.display.removeWidget(this.checkRenderer);
        }
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            return;
        }
        boolean bl = this.showFirstColumn();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_selection_unselect_iter(l, this._getItem((int)n).handle);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        boolean bl = this.showFirstColumn();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        int n3 = n;
        while (n3 <= n2) {
            if (n3 >= 0 && n3 < this.itemCount) {
                OS.gtk_tree_selection_unselect_iter(l, this._getItem((int)n3).handle);
            }
            ++n3;
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        boolean bl = this.showFirstColumn();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            if (n2 >= 0 && n2 < this.itemCount) {
                OS.gtk_tree_selection_unselect_iter(l, this._getItem((int)n2).handle);
            }
            ++n;
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        boolean bl = this.showFirstColumn();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_selection_unselect_all(l);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    void destroyItem(TableColumn tableColumn) {
        int n = 0;
        while (n < this.columnCount) {
            if (this.columns[n] == tableColumn) break;
            ++n;
        }
        if (n == this.columnCount) {
            return;
        }
        long l = tableColumn.handle;
        if (this.columnCount == 1) {
            this.firstCustomDraw = tableColumn.customDraw;
        }
        System.arraycopy(this.columns, n + 1, this.columns, n, --this.columnCount - n);
        this.columns[this.columnCount] = null;
        OS.gtk_tree_view_remove_column(this.handle, l);
        if (this.columnCount == 0) {
            long l2 = this.modelHandle;
            long[] lArray = this.getColumnTypes(1);
            long l3 = OS.gtk_list_store_newv(lArray.length, lArray);
            if (l3 == 0L) {
                this.error(2);
            }
            long[] lArray2 = new long[1];
            int n2 = 0;
            while (n2 < this.itemCount) {
                long l4 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                if (l4 == 0L) {
                    this.error(2);
                }
                OS.gtk_list_store_append(l3, l4);
                TableItem tableItem = this.items[n2];
                if (tableItem != null) {
                    long l5 = tableItem.handle;
                    int n3 = 0;
                    while (n3 < 5) {
                        OS.gtk_tree_model_get(l2, l5, n3, lArray2, -1L);
                        OS.gtk_list_store_set(l3, l4, n3, lArray2[0], -1L);
                        ++n3;
                    }
                    OS.gtk_tree_model_get(l2, l5, tableColumn.modelIndex + 0, lArray2, -1L);
                    OS.gtk_list_store_set(l3, l4, 5, lArray2[0], -1L);
                    OS.gtk_tree_model_get(l2, l5, tableColumn.modelIndex + 1, lArray2, -1L);
                    OS.gtk_list_store_set(l3, l4, 6, lArray2[0], -1L);
                    OS.g_free(lArray2[0]);
                    OS.gtk_tree_model_get(l2, l5, tableColumn.modelIndex + 2, lArray2, -1L);
                    OS.gtk_list_store_set(l3, l4, 7, lArray2[0], -1L);
                    OS.gtk_tree_model_get(l2, l5, tableColumn.modelIndex + 3, lArray2, -1L);
                    OS.gtk_list_store_set(l3, l4, 8, lArray2[0], -1L);
                    OS.gtk_tree_model_get(l2, l5, tableColumn.modelIndex + 4, lArray2, -1L);
                    OS.gtk_list_store_set(l3, l4, 9, lArray2[0], -1L);
                    OS.gtk_list_store_remove(l2, l5);
                    OS.g_free(l5);
                    tableItem.handle = l4;
                } else {
                    OS.g_free(l4);
                }
                ++n2;
            }
            OS.gtk_tree_view_set_model(this.handle, l3);
            OS.g_object_unref(l2);
            this.modelHandle = l3;
            this.createColumn(null, 0);
        } else {
            int n4 = 0;
            while (n4 < this.itemCount) {
                TableItem tableItem = this.items[n4];
                if (tableItem != null) {
                    long l6 = tableItem.handle;
                    int n5 = tableColumn.modelIndex;
                    OS.gtk_list_store_set(this.modelHandle, l6, n5 + 0, 0, -1L);
                    OS.gtk_list_store_set(this.modelHandle, l6, n5 + 1, 0, -1L);
                    OS.gtk_list_store_set(this.modelHandle, l6, n5 + 2, 0, -1L);
                    OS.gtk_list_store_set(this.modelHandle, l6, n5 + 3, 0, -1L);
                    OS.gtk_list_store_set(this.modelHandle, l6, n5 + 4, 0, -1L);
                    Font[] fontArray = tableItem.cellFont;
                    if (fontArray != null) {
                        if (this.columnCount == 0) {
                            tableItem.cellFont = null;
                        } else {
                            Font[] fontArray2 = new Font[this.columnCount];
                            System.arraycopy(fontArray, 0, fontArray2, 0, n);
                            System.arraycopy(fontArray, n + 1, fontArray2, n, this.columnCount - n);
                            tableItem.cellFont = fontArray2;
                        }
                    }
                }
                ++n4;
            }
            if (n == 0) {
                TableColumn tableColumn2 = this.columns[0];
                this.createRenderers(tableColumn2.handle, tableColumn2.modelIndex, true, tableColumn2.style);
            }
        }
        if ((this.style & 0x10000000) != 0) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 5)) {
                OS.gtk_tree_view_set_search_column(this.handle, -1);
            } else {
                OS.gtk_tree_view_set_enable_search(this.handle, false);
            }
        } else {
            int n6 = this.columnCount == 0 ? 5 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, n6 + 1);
        }
    }

    void destroyItem(TableItem tableItem) {
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == tableItem) break;
            ++n;
        }
        if (n == this.itemCount) {
            return;
        }
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_list_store_remove(this.modelHandle, tableItem.handle);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        if (this.itemCount == 0) {
            this.resetCustomDraw();
        }
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        boolean bl2;
        boolean bl3 = false;
        if (bl) {
            long[] lArray = new long[1];
            if (OS.gtk_tree_view_get_path_at_pos(this.handle, n, n2, lArray, null, null, null)) {
                if (lArray[0] != 0L) {
                    long l = OS.gtk_tree_view_get_selection(this.handle);
                    if (OS.gtk_tree_selection_path_is_selected(l, lArray[0])) {
                        bl3 = true;
                    }
                    OS.gtk_tree_path_free(lArray[0]);
                }
            } else {
                return false;
            }
        }
        if ((bl2 = super.dragDetect(n, n2, bl, blArray)) && bl3 && blArray != null) {
            blArray[0] = true;
        }
        return bl2;
    }

    long eventWindow() {
        return this.paintWindow();
    }

    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        super.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        int n = 0;
        while (n < this.columnCount) {
            TableColumn tableColumn = this.columns[n];
            if (tableColumn.toolTipText != null) {
                tableColumn.setToolTipText(shell2, null);
                tableColumn.setToolTipText(shell, tableColumn.toolTipText);
            }
            ++n;
        }
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        OS.gtk_widget_realize(this.handle);
        long l = OS.GTK_WIDGET_WINDOW(this.fixedHandle);
        long l2 = OS.gtk_tree_view_get_bin_window(this.handle);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_window_get_origin(l2, nArray, nArray2);
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        OS.gdk_window_get_origin(l, nArray3, nArray4);
        long l3 = this.clientHandle();
        int n = (this.state & 0x200) != 0 ? 0 : OS.GTK_WIDGET_WIDTH(l3);
        int n2 = (this.state & 0x400) != 0 ? 0 : OS.GTK_WIDGET_HEIGHT(l3);
        return new Rectangle(nArray3[0] - nArray[0], nArray4[0] - nArray2[0], n, n2);
    }

    int getClientWidth() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_widget_realize(this.handle);
        OS.gdk_drawable_get_size(OS.gtk_tree_view_get_bin_window(this.handle), nArray, nArray2);
        return nArray[0];
    }

    public TableColumn getColumn(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.columnCount) {
            this.error(6);
        }
        return this.columns[n];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    long[] getColumnTypes(int n) {
        long[] lArray = new long[5 + n * 5];
        lArray[0] = OS.G_TYPE_BOOLEAN();
        lArray[1] = OS.G_TYPE_BOOLEAN();
        lArray[2] = OS.GDK_TYPE_COLOR();
        lArray[3] = OS.GDK_TYPE_COLOR();
        lArray[4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
        int n2 = 5;
        while (n2 < lArray.length) {
            lArray[n2 + 0] = OS.GDK_TYPE_PIXBUF();
            lArray[n2 + 1] = OS.G_TYPE_STRING();
            lArray[n2 + 2] = OS.GDK_TYPE_COLOR();
            lArray[n2 + 3] = OS.GDK_TYPE_COLOR();
            lArray[n2 + 4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
            n2 += 5;
        }
        return lArray;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        if (this.columnCount == 0) {
            return new int[0];
        }
        long l = OS.gtk_tree_view_get_columns(this.handle);
        if (l == 0L) {
            return new int[0];
        }
        int n = 0;
        int n2 = OS.g_list_length(l);
        int[] nArray = new int[n2];
        long l2 = l;
        while (l2 != 0L) {
            long l3 = OS.g_list_data(l2);
            if (l3 != 0L) {
                int n3 = 0;
                while (n3 < this.columnCount) {
                    if (this.columns[n3].handle == l3) {
                        nArray[n++] = n3;
                        break;
                    }
                    ++n3;
                }
            }
            l2 = OS.g_list_next(l2);
        }
        OS.g_list_free(l);
        return nArray;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
        System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
        return tableColumnArray;
    }

    TableItem getFocusItem() {
        long[] lArray = new long[1];
        OS.gtk_tree_view_get_cursor(this.handle, lArray, null);
        if (lArray[0] == 0L) {
            return null;
        }
        TableItem tableItem = null;
        long l = OS.gtk_tree_path_get_indices(lArray[0]);
        if (l != 0L) {
            int[] nArray = new int[]{-1};
            OS.memmove(nArray, l, 4L);
            tableItem = this._getItem(nArray[0]);
        }
        OS.gtk_tree_path_free(lArray[0]);
        return tableItem;
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (!OS.gtk_tree_view_get_headers_visible(this.handle)) {
            return 0;
        }
        if (this.columnCount > 0) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            int n = 0;
            int n2 = 0;
            while (n2 < this.columnCount) {
                long l = this.columns[n2].buttonHandle;
                if (l != 0L) {
                    OS.gtk_widget_size_request(l, gtkRequisition);
                    n = Math.max(n, gtkRequisition.height);
                }
                ++n2;
            }
            return n;
        }
        OS.gtk_widget_realize(this.handle);
        long l = OS.GTK_WIDGET_WINDOW(this.fixedHandle);
        long l2 = OS.gtk_tree_view_get_bin_window(this.handle);
        int[] nArray = new int[1];
        OS.gdk_window_get_origin(l2, null, nArray);
        int[] nArray2 = new int[1];
        OS.gdk_window_get_origin(l, null, nArray2);
        return nArray[0] - nArray2[0];
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return OS.gtk_tree_view_get_headers_visible(this.handle);
    }

    public TableItem getItem(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            this.error(6);
        }
        return this._getItem(n);
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        long[] lArray = new long[1];
        OS.gtk_widget_realize(this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, point.x, point.y, lArray, null, null, null)) {
            return null;
        }
        if (lArray[0] == 0L) {
            return null;
        }
        long l = OS.gtk_tree_path_get_indices(lArray[0]);
        TableItem tableItem = null;
        if (l != 0L) {
            int[] nArray = new int[1];
            OS.memmove(nArray, l, 4L);
            tableItem = this._getItem(nArray[0]);
        }
        OS.gtk_tree_path_free(lArray[0]);
        return tableItem;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        if (this.itemCount == 0) {
            long l = OS.gtk_tree_view_get_column(this.handle, 0);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            this.ignoreSize = true;
            OS.gtk_tree_view_column_cell_get_size(l, null, null, null, nArray, nArray2);
            this.ignoreSize = false;
            return nArray2[0];
        }
        int n = 0;
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_get_iter_first(this.modelHandle, l);
        int n2 = Math.max(1, this.columnCount);
        int n3 = 0;
        while (n3 < n2) {
            long l2 = OS.gtk_tree_view_get_column(this.handle, n3);
            OS.gtk_tree_view_column_cell_set_cell_data(l2, this.modelHandle, l, false, false);
            int[] nArray = new int[1];
            int[] nArray3 = new int[1];
            OS.gtk_tree_view_column_cell_get_size(l2, null, null, null, nArray, nArray3);
            n = Math.max(n, nArray3[0]);
            ++n3;
        }
        OS.g_free(l);
        return n;
    }

    public TableItem[] getItems() {
        this.checkWidget();
        TableItem[] tableItemArray = new TableItem[this.itemCount];
        if ((this.style & 0x10000000) != 0) {
            int n = 0;
            while (n < this.itemCount) {
                tableItemArray[n] = this._getItem(n);
                ++n;
            }
        } else {
            System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
        }
        return tableItemArray;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return OS.gtk_tree_view_get_rules_hint(this.handle);
    }

    long getPixbufRenderer(long l) {
        long l2 = OS.gtk_tree_view_column_get_cell_renderers(l);
        if (l2 == 0L) {
            return 0L;
        }
        int n = OS.g_list_length(l2);
        long l3 = 0L;
        int n2 = 0;
        while (n2 < n) {
            long l4 = OS.g_list_nth_data(l2, n2);
            if (OS.GTK_IS_CELL_RENDERER_PIXBUF(l4)) {
                l3 = l4;
                break;
            }
            ++n2;
        }
        OS.g_list_free(l2);
        return l3;
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            this.display.treeSelectionLength = 0;
            this.display.treeSelection = new int[this.itemCount];
            OS.gtk_tree_selection_selected_foreach(l, this.display.treeSelectionProc, this.handle);
            TableItem[] tableItemArray = new TableItem[this.display.treeSelectionLength];
            int n = 0;
            while (n < tableItemArray.length) {
                tableItemArray[n] = this._getItem(this.display.treeSelection[n]);
                ++n;
            }
            return tableItemArray;
        }
        long[] lArray = OS.GTK_VERSION < OS.VERSION(2, 2, 4) ? new long[1] : null;
        long l2 = OS.gtk_tree_selection_get_selected_rows(l, lArray);
        if (l2 != 0L) {
            int n = OS.g_list_length(l2);
            int[] nArray = new int[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                long l3 = OS.g_list_nth_data(l2, n3);
                long l4 = OS.gtk_tree_path_get_indices(l3);
                if (l4 != 0L) {
                    int[] nArray2 = new int[1];
                    OS.memmove(nArray2, l4, 4L);
                    nArray[n2] = nArray2[0];
                    ++n2;
                }
                ++n3;
            }
            OS.g_list_free(l2);
            TableItem[] tableItemArray = new TableItem[n2];
            int n4 = 0;
            while (n4 < tableItemArray.length) {
                tableItemArray[n4] = this._getItem(nArray[n4]);
                ++n4;
            }
            return tableItemArray;
        }
        return new TableItem[0];
    }

    public int getSelectionCount() {
        this.checkWidget();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            this.display.treeSelectionLength = 0;
            this.display.treeSelection = null;
            OS.gtk_tree_selection_selected_foreach(l, this.display.treeSelectionProc, this.handle);
            return this.display.treeSelectionLength;
        }
        return OS.gtk_tree_selection_count_selected_rows(l);
    }

    public int getSelectionIndex() {
        long[] lArray;
        this.checkWidget();
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            this.display.treeSelectionLength = 0;
            this.display.treeSelection = new int[this.itemCount];
            long l = OS.gtk_tree_view_get_selection(this.handle);
            OS.gtk_tree_selection_selected_foreach(l, this.display.treeSelectionProc, this.handle);
            if (this.display.treeSelectionLength == 0) {
                return -1;
            }
            return this.display.treeSelection[0];
        }
        long l = OS.gtk_tree_view_get_selection(this.handle);
        long l2 = OS.gtk_tree_selection_get_selected_rows(l, lArray = OS.GTK_VERSION < OS.VERSION(2, 2, 4) ? new long[1] : null);
        if (l2 != 0L) {
            int n = OS.g_list_length(l2);
            int[] nArray = new int[1];
            int n2 = 0;
            while (n2 < n) {
                long l3 = OS.g_list_nth_data(l2, n2);
                long l4 = OS.gtk_tree_path_get_indices(l3);
                if (l4 != 0L) {
                    OS.memmove(nArray, l4, 4L);
                    break;
                }
                ++n2;
            }
            OS.g_list_free(l2);
            return nArray[0];
        }
        return -1;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            this.display.treeSelectionLength = 0;
            this.display.treeSelection = new int[this.itemCount];
            OS.gtk_tree_selection_selected_foreach(l, this.display.treeSelectionProc, this.handle);
            if (this.display.treeSelectionLength == this.display.treeSelection.length) {
                return this.display.treeSelection;
            }
            int[] nArray = new int[this.display.treeSelectionLength];
            System.arraycopy(this.display.treeSelection, 0, nArray, 0, this.display.treeSelectionLength);
            return nArray;
        }
        long[] lArray = OS.GTK_VERSION < OS.VERSION(2, 2, 4) ? new long[1] : null;
        long l2 = OS.gtk_tree_selection_get_selected_rows(l, lArray);
        if (l2 != 0L) {
            int n = OS.g_list_length(l2);
            int[] nArray = new int[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                long l3 = OS.g_list_nth_data(l2, n3);
                long l4 = OS.gtk_tree_path_get_indices(l3);
                if (l4 != 0L) {
                    int[] nArray2 = new int[1];
                    OS.memmove(nArray2, l4, 4L);
                    nArray[n2] = nArray2[0];
                    ++n2;
                }
                ++n3;
            }
            OS.g_list_free(l2);
            int[] nArray3 = new int[n2];
            System.arraycopy(nArray, 0, nArray3, 0, n2);
            return nArray3;
        }
        return new int[0];
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    long getTextRenderer(long l) {
        long l2 = OS.gtk_tree_view_column_get_cell_renderers(l);
        if (l2 == 0L) {
            return 0L;
        }
        int n = OS.g_list_length(l2);
        long l3 = 0L;
        int n2 = 0;
        while (n2 < n) {
            long l4 = OS.g_list_nth_data(l2, n2);
            if (OS.GTK_IS_CELL_RENDERER_TEXT(l4)) {
                l3 = l4;
                break;
            }
            ++n2;
        }
        OS.g_list_free(l2);
        return l3;
    }

    public int getTopIndex() {
        this.checkWidget();
        long[] lArray = new long[1];
        OS.gtk_widget_realize(this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, 1, 1, lArray, null, null, null)) {
            return 0;
        }
        if (lArray[0] == 0L) {
            return 0;
        }
        long l = OS.gtk_tree_path_get_indices(lArray[0]);
        int[] nArray = new int[1];
        if (l != 0L) {
            OS.memmove(nArray, l, 4L);
        }
        OS.gtk_tree_path_free(lArray[0]);
        return nArray[0];
    }

    long gtk_button_press_event(long l, long l2) {
        long l3;
        long[] lArray;
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
        if (gdkEventButton.window != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        long l4 = super.gtk_button_press_event(l, l2);
        if (l4 != 0L) {
            return l4;
        }
        int n = gdkEventButton.button;
        if (n == 3 && gdkEventButton.type == 4 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEventButton.x, (int)gdkEventButton.y, lArray = new long[1], null, null, null) && lArray[0] != 0L) {
            l3 = OS.gtk_tree_view_get_selection(this.handle);
            if (OS.gtk_tree_selection_path_is_selected(l3, lArray[0])) {
                l4 = 1L;
            }
            OS.gtk_tree_path_free(lArray[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEventButton.x, (int)gdkEventButton.y, lArray = new long[1], null, null, null) && lArray[0] != 0L) {
            l3 = OS.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(l3, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_tree_view_set_cursor(this.handle, lArray[0], 0L, false);
            OS.g_signal_handlers_unblock_matched(l3, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_tree_path_free(lArray[0]);
        }
        if (!OS.GTK_WIDGET_HAS_FOCUS(this.handle)) {
            OS.gtk_widget_grab_focus(this.handle);
        }
        return l4;
    }

    long gtk_button_release_event(long l, long l2) {
        long l3 = OS.GDK_EVENT_WINDOW(l2);
        if (l3 != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        return super.gtk_button_release_event(l, l2);
    }

    long gtk_changed(long l) {
        TableItem tableItem = this.getFocusItem();
        if (tableItem != null) {
            Event event = new Event();
            event.item = tableItem;
            this.postEvent(13, event);
        }
        return 0L;
    }

    long gtk_key_press_event(long l, long l2) {
        long l3 = super.gtk_key_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
            int n = gdkEventKey.keyval;
            switch (n) {
                case 65293: 
                case 65421: {
                    Event event = new Event();
                    event.item = this.getFocusItem();
                    this.postEvent(14, event);
                }
            }
        }
        return l3;
    }

    long gtk_popup_menu(long l) {
        long l2 = super.gtk_popup_menu(l);
        return OS.GTK_VERSION < OS.VERSION(2, 6, 5) ? 1L : l2;
    }

    long gtk_motion_notify_event(long l, long l2) {
        long l3 = OS.GDK_EVENT_WINDOW(l2);
        if (l3 != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        return super.gtk_motion_notify_event(l, l2);
    }

    long gtk_row_activated(long l, long l2, long l3) {
        Object object;
        TableItem tableItem = null;
        long l4 = OS.gtk_tree_path_get_indices(l2);
        if (l4 != 0L) {
            object = new int[]{-1};
            OS.memmove((int[])object, l4, 4L);
            tableItem = this._getItem((int)object[0]);
        }
        object = new Event();
        ((Event)object).item = tableItem;
        this.postEvent(14, (Event)object);
        return 0L;
    }

    long gtk_toggled(long l, long l2) {
        long l3 = OS.gtk_tree_path_new_from_string(l2);
        if (l3 == 0L) {
            return 0L;
        }
        long l4 = OS.gtk_tree_path_get_indices(l3);
        if (l4 != 0L) {
            int[] nArray = new int[1];
            OS.memmove(nArray, l4, 4L);
            TableItem tableItem = this._getItem(nArray[0]);
            tableItem.setChecked(!tableItem.getChecked());
            Event event = new Event();
            event.detail = 32;
            event.item = tableItem;
            this.postEvent(13, event);
        }
        OS.gtk_tree_path_free(l3);
        return 0L;
    }

    void gtk_widget_size_request(long l, GtkRequisition gtkRequisition) {
        long l2;
        long l3;
        if (this.columnCount == 0) {
            super.gtk_widget_size_request(l, gtkRequisition);
            return;
        }
        long l4 = l3 = OS.gtk_tree_view_get_columns(this.handle);
        boolean bl = l3 != 0L;
        while (l4 != 0L) {
            l2 = OS.g_list_data(l4);
            if (OS.gtk_tree_view_column_get_visible(l2)) {
                bl = false;
                break;
            }
            l4 = OS.g_list_next(l4);
        }
        l2 = 0L;
        if (bl) {
            l2 = OS.g_list_data(l3);
            OS.gtk_tree_view_column_set_visible(l2, true);
        }
        super.gtk_widget_size_request(l, gtkRequisition);
        if (bl) {
            OS.gtk_tree_view_column_set_visible(l2, false);
        }
        if (l3 != 0L) {
            OS.g_list_free(l3);
        }
    }

    void hideFirstColumn() {
        long l = OS.gtk_tree_view_get_column(this.handle, 0);
        OS.gtk_tree_view_column_set_visible(l, false);
    }

    void hookEvents() {
        super.hookEvents();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_connect_closure(l, OS.changed, this.display.closures[6], false);
        OS.g_signal_connect_closure(this.handle, OS.row_activated, this.display.closures[41], false);
        if (this.checkRenderer != 0L) {
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.closures[53], false);
        }
    }

    public int indexOf(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        int n = 0;
        while (n < this.columnCount) {
            if (this.columns[n] == tableColumn) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (1 <= this.lastIndexOf && this.lastIndexOf < this.itemCount - 1) {
            if (this.items[this.lastIndexOf] == tableItem) {
                return this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf + 1] == tableItem) {
                return ++this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf - 1] == tableItem) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < this.itemCount / 2) {
            int n = 0;
            while (n < this.itemCount) {
                if (this.items[n] == tableItem) {
                    this.lastIndexOf = n;
                    return this.lastIndexOf;
                }
                ++n;
            }
        } else {
            int n = this.itemCount - 1;
            while (n >= 0) {
                if (this.items[n] == tableItem) {
                    this.lastIndexOf = n;
                    return this.lastIndexOf;
                }
                --n;
            }
        }
        return -1;
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        byte[] byArray = Converter.wcsToMbcs(null, Integer.toString(n), true);
        long l2 = OS.gtk_tree_path_new_from_string(byArray);
        boolean bl = OS.gtk_tree_selection_path_is_selected(l, l2);
        OS.gtk_tree_path_free(l2);
        return bl;
    }

    boolean mnemonicHit(char c) {
        int n = 0;
        while (n < this.columnCount) {
            long l = this.columns[n].labelHandle;
            if (l != 0L && this.mnemonicHit(l, c)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean mnemonicMatch(char c) {
        int n = 0;
        while (n < this.columnCount) {
            long l = this.columns[n].labelHandle;
            if (l != 0L && this.mnemonicMatch(l, c)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    long paintWindow() {
        OS.gtk_widget_realize(this.handle);
        return OS.gtk_tree_view_get_bin_window(this.handle);
    }

    void recreateRenderers() {
        if (this.checkRenderer != 0L) {
            this.display.removeWidget(this.checkRenderer);
            OS.g_object_unref(this.checkRenderer);
            long l = this.checkRenderer = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_toggle_get_type(), 0L) : OS.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0L) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
            this.display.addWidget(this.checkRenderer, this);
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.closures[53], false);
        }
        if (this.columnCount == 0) {
            this.createRenderers(OS.gtk_tree_view_get_column(this.handle, 0), 5, true, 0);
        } else {
            int n = 0;
            while (n < this.columnCount) {
                TableColumn tableColumn = this.columns[n];
                this.createRenderers(tableColumn.handle, tableColumn.modelIndex, n == 0, tableColumn.style);
                ++n;
            }
        }
    }

    void redrawBackgroundImage() {
        Control control = this.findBackgroundControl();
        if (control != null && control.backgroundImage != null) {
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
    }

    void register() {
        super.register();
        this.display.addWidget(OS.gtk_tree_view_get_selection(this.handle), this);
        if (this.checkRenderer != 0L) {
            this.display.addWidget(this.checkRenderer, this);
        }
    }

    void releaseChildren(boolean bl) {
        Item item;
        int n;
        if (this.items != null) {
            n = 0;
            while (n < this.itemCount) {
                item = this.items[n];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++n;
            }
            this.items = null;
        }
        if (this.columns != null) {
            n = 0;
            while (n < this.columnCount) {
                item = this.columns[n];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++n;
            }
            this.columns = null;
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.modelHandle != 0L) {
            OS.g_object_unref(this.modelHandle);
        }
        this.modelHandle = 0L;
        if (this.checkRenderer != 0L) {
            OS.g_object_unref(this.checkRenderer);
        }
        this.checkRenderer = 0L;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        if (this.headerImageList != null) {
            this.headerImageList.dispose();
        }
        this.headerImageList = null;
        this.imageList = null;
        this.currentItem = null;
    }

    public void remove(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            this.error(15);
        }
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        TableItem tableItem = this.items[n];
        boolean bl = false;
        if (tableItem != null) {
            bl = tableItem.isDisposed();
            if (!bl) {
                OS.memmove(l, tableItem.handle, (long)OS.GtkTreeIter_sizeof());
                tableItem.release(false);
            }
        } else {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n);
        }
        if (!bl) {
            long l2 = OS.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_list_store_remove(this.modelHandle, l);
            OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
            System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
            this.items[this.itemCount] = null;
        }
        OS.g_free(l);
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (n < 0 || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        long l = OS.gtk_tree_view_get_selection(this.handle);
        long l2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int n3 = n2;
        while (n3 >= n) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, l2, 0L, n3);
            TableItem tableItem = this.items[n3];
            if (tableItem != null && !tableItem.isDisposed()) {
                tableItem.release(false);
            }
            OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_list_store_remove(this.modelHandle, l2);
            OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
            --n3;
        }
        OS.g_free(l2);
        n3 = n2 + 1;
        System.arraycopy(this.items, n3, this.items, n, this.itemCount - n3);
        int n4 = this.itemCount - (n3 - n);
        while (n4 < this.itemCount) {
            this.items[n4] = null;
            ++n4;
        }
        this.itemCount -= n3 - n;
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n = nArray2[nArray2.length - 1];
        int n2 = nArray2[0];
        if (n < 0 || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        long l = OS.gtk_tree_view_get_selection(this.handle);
        int n3 = -1;
        long l2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int n4 = 0;
        while (n4 < nArray2.length) {
            int n5 = nArray2[n4];
            if (n5 != n3) {
                TableItem tableItem = this.items[n5];
                boolean bl = false;
                if (tableItem != null) {
                    bl = tableItem.isDisposed();
                    if (!bl) {
                        OS.memmove(l2, tableItem.handle, (long)OS.GtkTreeIter_sizeof());
                        tableItem.release(false);
                    }
                } else {
                    OS.gtk_tree_model_iter_nth_child(this.modelHandle, l2, 0L, n5);
                }
                if (!bl) {
                    OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
                    OS.gtk_list_store_remove(this.modelHandle, l2);
                    OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
                    System.arraycopy(this.items, n5 + 1, this.items, n5, --this.itemCount - n5);
                    this.items[this.itemCount] = null;
                }
                n3 = n5;
            }
            ++n4;
        }
        OS.g_free(l2);
    }

    public void removeAll() {
        this.checkWidget();
        int n = this.itemCount - 1;
        while (n >= 0) {
            TableItem tableItem = this.items[n];
            if (tableItem != null && !tableItem.isDisposed()) {
                tableItem.release(false);
            }
            --n;
        }
        this.items = new TableItem[4];
        this.itemCount = 0;
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_list_store_clear(this.modelHandle);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        this.resetCustomDraw();
        if ((this.style & 0x10000000) != 0) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 5)) {
                OS.gtk_tree_view_set_search_column(this.handle, -1);
            } else {
                OS.gtk_tree_view_set_enable_search(this.handle, false);
            }
        } else {
            int n2 = this.columnCount == 0 ? 5 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, n2 + 1);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    long rendererGetSizeProc(long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        long l8 = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(l));
        GtkCellRendererClass gtkCellRendererClass = new GtkCellRendererClass();
        OS.memmove(gtkCellRendererClass, l8);
        long l9 = OS.call(gtkCellRendererClass.get_size, l, this.handle, l3, l4, l5, l6, l7);
        if (!this.ignoreSize && OS.GTK_IS_CELL_RENDERER_TEXT(l)) {
            int n;
            int[] nArray;
            long l10 = OS.g_object_get_qdata(l, Display.SWT_OBJECT_INDEX2);
            TableItem tableItem = null;
            if (l10 != 0L) {
                long l11 = OS.gtk_tree_model_get_path(this.modelHandle, l10);
                nArray = new int[1];
                OS.memmove(nArray, OS.gtk_tree_path_get_indices(l11), 4L);
                n = nArray[0];
                tableItem = this._getItem(n);
                OS.gtk_tree_path_free(l11);
            }
            if (tableItem != null) {
                int n2 = 0;
                if (this.columnCount > 0) {
                    long l12 = OS.g_object_get_qdata(l, Display.SWT_OBJECT_INDEX1);
                    n = 0;
                    while (n < this.columnCount) {
                        if (this.columns[n].handle == l12) {
                            n2 = n;
                            break;
                        }
                        ++n;
                    }
                }
                if (this.hooks(41)) {
                    Object object;
                    int[] nArray2 = new int[1];
                    nArray = new int[1];
                    if (l6 != 0L) {
                        OS.memmove(nArray2, l6, 4L);
                    }
                    if (l7 != 0L) {
                        OS.memmove(nArray, l7, 4L);
                    }
                    Image image = tableItem.getImage(n2);
                    int n3 = 0;
                    if (image != null) {
                        object = image.getBounds();
                        n3 = ((Rectangle)object).width;
                    }
                    nArray2[0] = nArray2[0] + n3;
                    object = new GC(this);
                    ((GC)object).setFont(tableItem.getFont(n2));
                    Event event = new Event();
                    event.item = tableItem;
                    event.index = n2;
                    event.gc = object;
                    event.width = nArray2[0];
                    event.height = nArray[0];
                    this.sendEvent(41, event);
                    ((Resource)object).dispose();
                    nArray2[0] = event.width - n3;
                    if (nArray[0] < event.height) {
                        nArray[0] = event.height;
                    }
                    if (l6 != 0L) {
                        OS.memmove(l6, nArray2, 4L);
                    }
                    if (l7 != 0L) {
                        OS.memmove(l7, nArray, 4L);
                    }
                }
            }
        }
        return l9;
    }

    long rendererRenderProc(long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        long l8;
        int n;
        long l9;
        TableItem tableItem = null;
        long l10 = OS.g_object_get_qdata(l, Display.SWT_OBJECT_INDEX2);
        if (l10 != 0L) {
            l9 = OS.gtk_tree_model_get_path(this.modelHandle, l10);
            int[] nArray = new int[1];
            OS.memmove(nArray, OS.gtk_tree_path_get_indices(l9), 4L);
            n = nArray[0];
            tableItem = this._getItem(n);
            OS.gtk_tree_path_free(l9);
        }
        l9 = OS.g_object_get_qdata(l, Display.SWT_OBJECT_INDEX1);
        int n2 = 0;
        if (this.columnCount > 0) {
            n = 0;
            while (n < this.columnCount) {
                if (this.columns[n].handle == l9) {
                    n2 = n;
                    break;
                }
                ++n;
            }
        }
        if (tableItem != null && (OS.GTK_IS_CELL_RENDERER_TOGGLE(l) || OS.GTK_IS_CELL_RENDERER_PIXBUF(l) && (n2 != 0 || (this.style & 0x20) == 0))) {
            this.drawFlags = (int)l7;
            this.drawState = 16;
            long[] lArray = new long[1];
            OS.gtk_tree_model_get(this.modelHandle, tableItem.handle, 3, lArray, -1L);
            if (lArray[0] == 0L) {
                int n3 = this.columnCount == 0 ? 5 : this.columns[n2].modelIndex;
                OS.gtk_tree_model_get(this.modelHandle, tableItem.handle, n3 + 3, lArray, -1L);
            }
            if (lArray[0] != 0L) {
                this.drawState |= 8;
            }
            if ((l7 & 1L) != 0L) {
                this.drawState |= 2;
            }
            if ((l7 & 0x10L) != 0L) {
                this.drawState |= 4;
            }
            GdkRectangle gdkRectangle = new GdkRectangle();
            l8 = OS.gtk_tree_model_get_path(this.modelHandle, l10);
            OS.gtk_tree_view_get_background_area(this.handle, l8, l9, gdkRectangle);
            OS.gtk_tree_path_free(l8);
            if ((this.drawState & 2) == 0 && (object4 = this.findBackgroundControl()) != null && ((Control)object4).backgroundImage != null) {
                OS.gdk_window_clear_area(l2, gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
            }
            if (this.hooks(40)) {
                boolean bl = false;
                if ((this.drawState & 2) != 0) {
                    bl = true;
                    OS.gdk_window_clear_area(l2, gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
                }
                object3 = new GC(this);
                if ((this.drawState & 2) != 0) {
                    ((GC)object3).setBackground(this.display.getSystemColor(26));
                    ((GC)object3).setForeground(this.display.getSystemColor(27));
                } else {
                    ((GC)object3).setBackground(tableItem.getBackground(n2));
                    ((GC)object3).setForeground(tableItem.getForeground(n2));
                }
                ((GC)object3).setFont(tableItem.getFont(n2));
                if ((this.style & 0x8000000) != 0) {
                    gdkRectangle.x = this.getClientWidth() - gdkRectangle.width - gdkRectangle.x;
                }
                ((GC)object3).setClipping(gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
                object2 = new Event();
                object2.item = tableItem;
                object2.index = n2;
                object2.gc = object3;
                object2.x = gdkRectangle.x;
                object2.y = gdkRectangle.y;
                object2.width = gdkRectangle.width;
                object2.height = gdkRectangle.height;
                object2.detail = this.drawState;
                this.sendEvent(40, (Event)object2);
                this.drawForeground = null;
                this.drawState = object2.doit ? object2.detail : 0;
                this.drawFlags &= 0xFFFFFFEE;
                if ((this.drawState & 2) != 0) {
                    this.drawFlags |= 1;
                }
                if ((this.drawState & 4) != 0) {
                    this.drawFlags |= 0x10;
                }
                if ((this.drawState & 2) != 0) {
                    long l11 = OS.gtk_widget_get_style(l3);
                    object = Converter.wcsToMbcs(null, "cell_odd", true);
                    OS.gtk_paint_flat_box(l11, l2, 3, 0, gdkRectangle, l3, (byte[])object, gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
                } else if (bl) {
                    this.drawForeground = ((GC)object3).getForeground().handle;
                }
                ((Resource)object3).dispose();
            }
        }
        long l12 = 0L;
        if ((this.drawState & 8) != 0 && (this.drawState & 2) == 0) {
            GC gC = new GC(this);
            gC.setBackground(tableItem.getBackground(n2));
            GdkRectangle gdkRectangle = new GdkRectangle();
            OS.memmove(gdkRectangle, l4, (long)GdkRectangle.sizeof);
            gC.fillRectangle(gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
            gC.dispose();
        }
        if ((this.drawState & 0x10) != 0 || OS.GTK_IS_CELL_RENDERER_TOGGLE(l)) {
            l8 = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(l));
            object4 = new GtkCellRendererClass();
            OS.memmove((GtkCellRendererClass)object4, l8);
            if (this.drawForeground != null && OS.GTK_IS_CELL_RENDERER_TEXT(l)) {
                OS.g_object_set(l, OS.foreground_gdk, this.drawForeground, 0L);
            }
            l12 = OS.call(((GtkCellRendererClass)object4).render, l, l2, this.handle, l4, l5, l6, this.drawFlags);
        }
        if (tableItem != null && OS.GTK_IS_CELL_RENDERER_TEXT(l) && this.hooks(42)) {
            Object object5;
            GdkRectangle gdkRectangle = new GdkRectangle();
            long l13 = OS.gtk_tree_model_get_path(this.modelHandle, l10);
            OS.gtk_tree_view_get_background_area(this.handle, l13, l9, gdkRectangle);
            OS.gtk_tree_path_free(l13);
            this.ignoreSize = true;
            object3 = new int[1];
            object2 = new int[1];
            OS.gtk_cell_renderer_get_size(l, this.handle, null, null, null, object2, null);
            OS.gtk_tree_view_column_cell_get_position(l9, l, (int[])object3, null);
            this.ignoreSize = false;
            Image image = tableItem.getImage(n2);
            int n4 = 0;
            if (image != null) {
                object = image.getBounds();
                n4 = ((Rectangle)object).width;
            }
            object3[0] = object3[0] - n4;
            object2[0] = object2[0] + n4;
            object = new GC(this);
            if ((this.drawState & 2) != 0) {
                ((GC)object).setBackground(this.display.getSystemColor(26));
                ((GC)object).setForeground(this.display.getSystemColor(27));
            } else {
                ((GC)object).setBackground(tableItem.getBackground(n2));
                object5 = this.drawForeground != null ? Color.gtk_new(this.display, this.drawForeground) : tableItem.getForeground(n2);
                ((GC)object).setForeground((Color)object5);
            }
            ((GC)object).setFont(tableItem.getFont(n2));
            if ((this.style & 0x8000000) != 0) {
                gdkRectangle.x = this.getClientWidth() - gdkRectangle.width - gdkRectangle.x;
            }
            ((GC)object).setClipping(gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
            object5 = new Event();
            ((Event)object5).item = tableItem;
            ((Event)object5).index = n2;
            ((Event)object5).gc = object;
            ((Event)object5).x = gdkRectangle.x + object3[0];
            ((Event)object5).y = gdkRectangle.y;
            ((Event)object5).width = object2[0];
            ((Event)object5).height = gdkRectangle.height;
            ((Event)object5).detail = this.drawState;
            this.sendEvent(42, (Event)object5);
            ((Resource)object).dispose();
        }
        return l12;
    }

    void resetCustomDraw() {
        if ((this.style & 0x10000000) != 0 || this.ownerDraw) {
            return;
        }
        int n = Math.max(1, this.columnCount);
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            boolean bl2 = bl = this.columnCount != 0 ? this.columns[n2].customDraw : this.firstCustomDraw;
            if (bl) {
                long l = OS.gtk_tree_view_get_column(this.handle, n2);
                long l2 = this.getTextRenderer(l);
                OS.gtk_tree_view_column_set_cell_data_func(l, l2, 0L, 0L, 0L);
                if (this.columnCount != 0) {
                    this.columns[n2].customDraw = false;
                }
            }
            ++n2;
        }
        this.firstCustomDraw = false;
    }

    public void select(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            return;
        }
        boolean bl = this.showFirstColumn();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        TableItem tableItem = this._getItem(n);
        OS.gtk_tree_selection_select_iter(l, tableItem.handle);
        if ((this.style & 4) != 0) {
            long l2 = OS.gtk_tree_model_get_path(this.modelHandle, tableItem.handle);
            OS.gtk_tree_view_set_cursor(this.handle, l2, 0L, false);
            OS.gtk_tree_path_free(l2);
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void select(int n, int n2) {
        this.checkWidget();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, this.itemCount - 1);
        boolean bl = this.showFirstColumn();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        int n3 = n;
        while (n3 <= n2) {
            TableItem tableItem = this._getItem(n3);
            OS.gtk_tree_selection_select_iter(l, tableItem.handle);
            if ((this.style & 4) != 0) {
                long l2 = OS.gtk_tree_model_get_path(this.modelHandle, tableItem.handle);
                OS.gtk_tree_view_set_cursor(this.handle, l2, 0L, false);
                OS.gtk_tree_path_free(l2);
            }
            ++n3;
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void select(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n = nArray.length) == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        boolean bl = this.showFirstColumn();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (n3 >= 0 && n3 < this.itemCount) {
                TableItem tableItem = this._getItem(n3);
                OS.gtk_tree_selection_select_iter(l, tableItem.handle);
                if ((this.style & 4) != 0) {
                    long l2 = OS.gtk_tree_model_get_path(this.modelHandle, tableItem.handle);
                    OS.gtk_tree_view_set_cursor(this.handle, l2, 0L, false);
                    OS.gtk_tree_path_free(l2);
                }
            }
            ++n2;
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        boolean bl = this.showFirstColumn();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_selection_select_all(l);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    void selectFocusIndex(int n) {
        if (n < 0 || n >= this.itemCount) {
            return;
        }
        TableItem tableItem = this._getItem(n);
        long l = OS.gtk_tree_model_get_path(this.modelHandle, tableItem.handle);
        long l2 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_view_set_cursor(this.handle, l, 0L, false);
        OS.gtk_tree_selection_select_iter(l2, tableItem.handle);
        OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_path_free(l);
    }

    void setBackgroundColor(GdkColor gdkColor) {
        super.setBackgroundColor(gdkColor);
        OS.gtk_widget_modify_base(this.handle, 0, gdkColor);
    }

    void setBackgroundPixmap(long l) {
        super.setBackgroundPixmap(l);
        long l2 = this.paintWindow();
        if (l2 != 0L) {
            OS.gdk_window_set_back_pixmap(l2, 0L, true);
        }
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        OS.gtk_widget_realize(this.handle);
        if (OS.GTK_VERSION < OS.VERSION(2, 6, 0) && this.itemCount == 0) {
            this.redraw(false);
        }
        return n5;
    }

    public void setColumnOrder(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (nArray.length > 0) {
                this.error(5);
            }
            return;
        }
        if (nArray.length != this.columnCount) {
            this.error(5);
        }
        boolean[] blArray = new boolean[this.columnCount];
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            if (n2 < 0 || n2 >= this.columnCount) {
                this.error(6);
            }
            if (blArray[n2]) {
                this.error(5);
            }
            blArray[n2] = true;
            ++n;
        }
        n = 0;
        while (n < nArray.length) {
            long l = this.columns[nArray[n]].handle;
            long l2 = n == 0 ? 0L : this.columns[nArray[n - 1]].handle;
            OS.gtk_tree_view_move_column_after(this.handle, l, l2);
            ++n;
        }
    }

    void setFontDescription(long l) {
        super.setFontDescription(l);
        TableColumn[] tableColumnArray = this.getColumns();
        int n = 0;
        while (n < tableColumnArray.length) {
            if (tableColumnArray[n] != null) {
                tableColumnArray[n].setFontDescription(l);
            }
            ++n;
        }
    }

    public void setHeaderVisible(boolean bl) {
        this.checkWidget();
        OS.gtk_tree_view_set_headers_visible(this.handle, bl);
    }

    public void setItemCount(int n) {
        boolean bl;
        this.checkWidget();
        n = Math.max(0, n);
        if (n == this.itemCount) {
            return;
        }
        boolean bl2 = bl = (this.style & 0x10000000) != 0;
        if (!bl) {
            this.setRedraw(false);
        }
        this.remove(n, this.itemCount - 1);
        int n2 = Math.max(4, (n + 3) / 4 * 4);
        TableItem[] tableItemArray = new TableItem[n2];
        System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
        this.items = tableItemArray;
        if (bl) {
            long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
            if (l == 0L) {
                this.error(2);
            }
            int n3 = this.itemCount;
            while (n3 < n) {
                OS.gtk_list_store_append(this.modelHandle, l);
                ++n3;
            }
            OS.g_free(l);
            this.itemCount = n;
        } else {
            int n4 = this.itemCount;
            while (n4 < n) {
                new TableItem(this, 0, n4, true);
                ++n4;
            }
        }
        if (!bl) {
            this.setRedraw(true);
        }
    }

    public void setLinesVisible(boolean bl) {
        this.checkWidget();
        OS.gtk_tree_view_set_rules_hint(this.handle, bl);
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
            OS.gtk_tree_view_set_grid_lines(this.handle, bl ? 2 : 0);
        }
    }

    void setParentBackground() {
        super.setParentBackground();
        long l = this.paintWindow();
        if (l != 0L) {
            OS.gdk_window_set_back_pixmap(l, 0L, true);
        }
    }

    void setParentWindow(long l) {
        long l2 = this.eventWindow();
        OS.gtk_widget_set_parent_window(l, l2);
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        super.setRedraw(bl);
        if (bl && this.drawCount == 0 && this.items.length > 4 && this.items.length - this.itemCount > 3) {
            int n = Math.max(4, (this.itemCount + 3) / 4 * 4);
            TableItem[] tableItemArray = new TableItem[n];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
            this.items = tableItemArray;
        }
    }

    void setScrollWidth(long l, TableItem tableItem) {
        int n;
        if (this.columnCount != 0 || this.currentItem == tableItem) {
            return;
        }
        if ((this.style & 0x10000000) != 0 && OS.GTK_VERSION < OS.VERSION(2, 3, 2)) {
            return;
        }
        int n2 = OS.gtk_tree_view_column_get_fixed_width(l);
        if (n2 < (n = this.calculateWidth(l, tableItem.handle))) {
            OS.gtk_tree_view_column_set_fixed_width(l, n);
        }
    }

    public void setSortColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn != null && tableColumn.isDisposed()) {
            this.error(5);
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        }
        this.sortColumn = tableColumn;
        if (this.sortColumn != null && this.sortDirection != 0) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            OS.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setSortDirection(int n) {
        this.checkWidget();
        if (n != 128 && n != 1024 && n != 0) {
            return;
        }
        this.sortDirection = n;
        if (this.sortColumn == null || this.sortColumn.isDisposed()) {
            return;
        }
        if (this.sortDirection == 0) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        } else {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            OS.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        boolean bl = this.showFirstColumn();
        this.deselectAll();
        this.selectFocusIndex(n);
        this.showSelection();
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.deselectAll();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        boolean bl = this.showFirstColumn();
        n = Math.max(0, n);
        n2 = Math.min(n2, this.itemCount - 1);
        this.selectFocusIndex(n);
        if ((this.style & 2) != 0) {
            this.select(n, n2);
        }
        this.showSelection();
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = nArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        boolean bl = this.showFirstColumn();
        this.selectFocusIndex(nArray[0]);
        if ((this.style & 2) != 0) {
            this.select(nArray);
        }
        this.showSelection();
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setSelection(TableItem tableItem) {
        if (tableItem == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{tableItem});
    }

    public void setSelection(TableItem[] tableItemArray) {
        this.checkWidget();
        if (tableItemArray == null) {
            this.error(4);
        }
        boolean bl = this.showFirstColumn();
        this.deselectAll();
        int n = tableItemArray.length;
        if (n != 0 && ((this.style & 4) == 0 || n <= 1)) {
            boolean bl2 = true;
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.indexOf(tableItemArray[n2]);
                if (n3 != -1) {
                    if (bl2) {
                        bl2 = false;
                        this.selectFocusIndex(n3);
                    } else {
                        this.select(n3);
                    }
                }
                ++n2;
            }
            this.showSelection();
        }
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            return;
        }
        long l = OS.gtk_tree_model_get_path(this.modelHandle, this._getItem((int)n).handle);
        OS.gtk_tree_view_scroll_to_cell(this.handle, l, 0L, true, 0.0f, 0.0f);
        if (OS.GTK_VERSION < OS.VERSION(2, 8, 0)) {
            OS.gtk_widget_realize(this.handle);
            GdkRectangle gdkRectangle = new GdkRectangle();
            OS.gtk_tree_view_get_cell_area(this.handle, l, 0L, gdkRectangle);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_tree_view_widget_to_tree_coords(this.handle, gdkRectangle.x, gdkRectangle.y, nArray, nArray2);
            OS.gtk_tree_view_scroll_to_point(this.handle, -1, nArray2[0]);
        }
        OS.gtk_tree_path_free(l);
    }

    public void showColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        if (tableColumn.isDisposed()) {
            this.error(5);
        }
        if (tableColumn.parent != this) {
            return;
        }
        OS.gtk_widget_realize(this.handle);
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(this.handle, 0L, tableColumn.handle, gdkRectangle);
        GdkRectangle gdkRectangle2 = new GdkRectangle();
        OS.gtk_tree_view_get_visible_rect(this.handle, gdkRectangle2);
        if (gdkRectangle.x < gdkRectangle2.x) {
            OS.gtk_tree_view_scroll_to_point(this.handle, gdkRectangle.x, -1);
        } else {
            int n = Math.min(gdkRectangle2.width, gdkRectangle.width);
            if (gdkRectangle.x + n > gdkRectangle2.x + gdkRectangle2.width) {
                int n2 = gdkRectangle.x + n - gdkRectangle2.width;
                OS.gtk_tree_view_scroll_to_point(this.handle, n2, -1);
            }
        }
    }

    boolean showFirstColumn() {
        int n = Math.max(1, this.columnCount);
        int n2 = 0;
        while (n2 < n) {
            long l = OS.gtk_tree_view_get_column(this.handle, n2);
            if (OS.gtk_tree_view_column_get_visible(l)) {
                return false;
            }
            ++n2;
        }
        long l = OS.gtk_tree_view_get_column(this.handle, 0);
        OS.gtk_tree_view_column_set_visible(l, true);
        return true;
    }

    public void showItem(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (tableItem.isDisposed()) {
            this.error(5);
        }
        if (tableItem.parent != this) {
            return;
        }
        this.showItem(tableItem.handle);
    }

    void showItem(long l) {
        long l2 = OS.gtk_tree_model_get_path(this.modelHandle, l);
        OS.gtk_widget_realize(this.handle);
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gtk_tree_view_get_visible_rect(this.handle, gdkRectangle);
        GdkRectangle gdkRectangle2 = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(this.handle, l2, 0L, gdkRectangle2);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_tree_view_widget_to_tree_coords(this.handle, gdkRectangle2.x, gdkRectangle2.y, nArray, nArray2);
        if (nArray2[0] < gdkRectangle.y) {
            OS.gtk_tree_view_scroll_to_cell(this.handle, l2, 0L, true, 0.0f, 0.0f);
            OS.gtk_tree_view_scroll_to_point(this.handle, -1, nArray2[0]);
        } else {
            int n = Math.min(gdkRectangle.height, gdkRectangle2.height);
            if (nArray2[0] + n > gdkRectangle.y + gdkRectangle.height) {
                OS.gtk_tree_view_scroll_to_cell(this.handle, l2, 0L, true, 1.0f, 0.0f);
                nArray2[0] = nArray2[0] + (gdkRectangle2.height - gdkRectangle.height);
                OS.gtk_tree_view_scroll_to_point(this.handle, -1, nArray2[0]);
            }
        }
        OS.gtk_tree_path_free(l2);
    }

    public void showSelection() {
        this.checkWidget();
        TableItem[] tableItemArray = this.getSelection();
        if (tableItemArray.length == 0) {
            return;
        }
        TableItem tableItem = tableItemArray[0];
        this.showItem(tableItem.handle);
    }

    long treeSelectionProc(long l, long l2, long l3, int[] nArray, int n) {
        long l4;
        if (nArray != null && (l4 = OS.gtk_tree_path_get_indices(l2)) != 0L) {
            int[] nArray2 = new int[1];
            OS.memmove(nArray2, l4, 4L);
            nArray[n] = nArray2[0];
        }
        return 0L;
    }

    void updateScrollBarValue(ScrollBar scrollBar) {
        super.updateScrollBarValue(scrollBar);
        long l = this.parentingHandle();
        long l2 = OS.gtk_container_get_children(l);
        if (l2 == 0L) {
            return;
        }
        long l3 = l2;
        while (l3 != 0L) {
            long l4 = OS.g_list_data(l3);
            if (l4 != 0L) {
                OS.gtk_widget_queue_resize(l4);
            }
            l3 = OS.g_list_next(l3);
        }
        OS.g_list_free(l2);
    }
}

