/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    Scrollable parent;
    long adjustmentHandle;
    int detail;
    boolean dragSent;

    ScrollBar() {
    }

    ScrollBar(Scrollable parent, int style) {
        super(parent, ScrollBar.checkStyle(style));
        this.parent = parent;
        this.createWidget(0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return ScrollBar.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    void deregister() {
        super.deregister();
        if (this.adjustmentHandle != 0L) {
            this.display.removeWidget(this.adjustmentHandle);
        }
    }

    void destroyHandle() {
        super.destroyWidget();
    }

    void destroyWidget() {
        this.parent.destroyScrollBar(this);
        this.releaseHandle();
    }

    public boolean getEnabled() {
        this.checkWidget();
        if (this.handle != 0L) {
            return OS.GTK_WIDGET_SENSITIVE(this.handle);
        }
        return true;
    }

    public int getIncrement() {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        return (int)adjustment.step_increment;
    }

    public int getMaximum() {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        return (int)adjustment.upper;
    }

    public int getMinimum() {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        return (int)adjustment.lower;
    }

    public int getPageIncrement() {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        return (int)adjustment.page_increment;
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        return (int)adjustment.value;
    }

    public Point getSize() {
        this.checkWidget();
        if (this.handle == 0L) {
            return new Point(0, 0);
        }
        GtkRequisition requisition = new GtkRequisition();
        OS.gtk_widget_size_request(this.handle, requisition);
        return new Point(requisition.width, requisition.height);
    }

    public int getThumb() {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        return (int)adjustment.page_size;
    }

    public boolean getVisible() {
        this.checkWidget();
        long scrolledHandle = this.parent.scrolledHandle;
        int[] hsp = new int[1];
        int[] vsp = new int[1];
        OS.gtk_scrolled_window_get_policy(scrolledHandle, hsp, vsp);
        if ((this.style & 0x100) != 0) {
            return hsp[0] != 2;
        }
        return vsp[0] != 2;
    }

    long gtk_button_press_event(long widget, long eventPtr) {
        long result = super.gtk_button_press_event(widget, eventPtr);
        if (result != 0L) {
            return result;
        }
        this.detail = 0;
        this.dragSent = false;
        return result;
    }

    long gtk_change_value(long widget, long scroll, long value1, long value2) {
        this.detail = (int)scroll;
        return 0L;
    }

    long gtk_value_changed(long adjustment) {
        Event event = new Event();
        this.dragSent = this.detail == 1;
        switch (this.detail) {
            case 0: {
                event.detail = 0;
                break;
            }
            case 1: {
                event.detail = 1;
                break;
            }
            case 14: {
                event.detail = 0x1000007;
                break;
            }
            case 15: {
                event.detail = 0x1000008;
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                event.detail = 0x1000006;
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                event.detail = 0x1000005;
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                event.detail = 0x1000002;
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                event.detail = 0x1000001;
            }
        }
        this.detail = 0;
        if (!this.dragSent) {
            this.detail = 0;
        }
        this.postEvent(13, event);
        this.parent.updateScrollBarValue(this);
        return 0L;
    }

    long gtk_event_after(long widget, long gdkEvent) {
        GdkEvent gtkEvent = new GdkEvent();
        OS.memmove(gtkEvent, gdkEvent, (long)GdkEvent.sizeof);
        switch (gtkEvent.type) {
            case 7: {
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, gdkEvent, (long)GdkEventButton.sizeof);
                if (gdkEventButton.button == 1 && this.detail == 1) {
                    if (!this.dragSent) {
                        Event event = new Event();
                        event.detail = 1;
                        this.postEvent(13, event);
                    }
                    this.postEvent(13);
                }
                this.detail = 0;
                this.dragSent = false;
            }
        }
        return super.gtk_event_after(widget, gdkEvent);
    }

    void hookEvents() {
        super.hookEvents();
        if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
            OS.g_signal_connect_closure(this.handle, OS.change_value, this.display.closures[7], false);
        }
        OS.g_signal_connect_closure(this.adjustmentHandle, OS.value_changed, this.display.closures[57], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[16], 0, this.display.closures[16], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[2], 0, this.display.closures[2], false);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.getParent().getEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.getParent().isVisible();
    }

    void register() {
        super.register();
        if (this.adjustmentHandle != 0L) {
            this.display.addWidget(this.adjustmentHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    void releaseWidget() {
        super.releaseWidget();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (this.handle != 0L) {
            OS.gtk_widget_set_sensitive(this.handle, enabled);
        }
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        adjustment.step_increment = value;
        OS.memmove(this.adjustmentHandle, adjustment);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_adjustment_changed(this.adjustmentHandle);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        int minimum = (int)adjustment.lower;
        if (value <= minimum) {
            return;
        }
        adjustment.upper = value;
        adjustment.page_size = Math.min((int)adjustment.page_size, value - minimum);
        adjustment.value = Math.min((int)adjustment.value, (int)((double)value - adjustment.page_size));
        OS.memmove(this.adjustmentHandle, adjustment);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_adjustment_changed(this.adjustmentHandle);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        int maximum = (int)adjustment.upper;
        if (value >= maximum) {
            return;
        }
        adjustment.lower = value;
        adjustment.page_size = Math.min((int)adjustment.page_size, maximum - value);
        adjustment.value = Math.max((int)adjustment.value, value);
        OS.memmove(this.adjustmentHandle, adjustment);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_adjustment_changed(this.adjustmentHandle);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    void setOrientation() {
        super.setOrientation();
        if ((this.parent.style & 0x8000000) != 0 && (this.parent.state & 2) != 0 && (this.style & 0x100) != 0) {
            OS.gtk_range_set_inverted(this.handle, true);
        }
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        adjustment.page_increment = value;
        OS.memmove(this.adjustmentHandle, adjustment);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_adjustment_changed(this.adjustmentHandle);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setSelection(int value) {
        this.checkWidget();
        value = Math.min(value, this.getMaximum() - this.getThumb());
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_adjustment_set_value(this.adjustmentHandle, value);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setThumb(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        value = Math.min(value, (int)(adjustment.upper - adjustment.lower));
        adjustment.page_size = value;
        adjustment.value = Math.min((int)adjustment.value, (int)(adjustment.upper - (double)value));
        OS.memmove(this.adjustmentHandle, adjustment);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_adjustment_changed(this.adjustmentHandle);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        if (minimum < 0) {
            return;
        }
        if (maximum < 0) {
            return;
        }
        if (thumb < 1) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        thumb = Math.min(thumb, maximum - minimum);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        adjustment.lower = minimum;
        adjustment.upper = maximum;
        adjustment.step_increment = increment;
        adjustment.page_increment = pageIncrement;
        adjustment.page_size = thumb;
        adjustment.value = Math.min(Math.max(selection, minimum), maximum - thumb);
        OS.memmove(this.adjustmentHandle, adjustment);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_adjustment_changed(this.adjustmentHandle);
        OS.gtk_adjustment_value_changed(this.adjustmentHandle);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (this.parent.setScrollBarVisible(this, visible)) {
            this.sendEvent(visible ? 22 : 23);
            this.parent.sendEvent(11);
        }
    }
}

