/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.cde.CDE;
import org.eclipse.swt.internal.cde.DtActionArg;
import org.eclipse.swt.internal.gnome.GNOME;
import org.eclipse.swt.internal.gnome.GnomeVFSMimeApplication;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public final class Program {
    String name;
    String command;
    String iconPath;
    Display display;
    boolean gnomeExpectUri;
    static int modTime;
    static Hashtable mimeTable;
    static int cdeShell;
    static final String[] CDE_ICON_EXT;
    static final String[] CDE_MASK_EXT;
    static final String DESKTOP_DATA = "Program_DESKTOP";
    static final String ICON_THEME_DATA = "Program_GNOME_ICON_THEME";
    static final String PREFIX_HTTP = "http://";
    static final String PREFIX_HTTPS = "https://";
    static final int DESKTOP_UNKNOWN = 0;
    static final int DESKTOP_GNOME = 1;
    static final int DESKTOP_GNOME_24 = 2;
    static final int DESKTOP_GIO = 3;
    static final int DESKTOP_CDE = 4;
    static final int PREFERRED_ICON_SIZE = 16;

    static {
        CDE_ICON_EXT = new String[]{".m.pm", ".l.pm", ".s.pm", ".t.pm"};
        CDE_MASK_EXT = new String[]{".m_m.bm", ".l_m.bm", ".s_m.bm", ".t_m.bm"};
    }

    Program() {
    }

    static int getDesktop(final Display display) {
        byte[] gnomeName;
        int gnome;
        if (display == null) {
            return 0;
        }
        Integer desktopValue = (Integer)display.getData(DESKTOP_DATA);
        if (desktopValue != null) {
            return desktopValue;
        }
        int desktop = 0;
        int xDisplay = OS.GDK_DISPLAY();
        int rootWindow = OS.XDefaultRootWindow(xDisplay);
        int[] numProp = new int[1];
        int propList = OS.XListProperties(xDisplay, rootWindow, numProp);
        int[] property = new int[numProp[0]];
        if (propList != 0) {
            OS.memmove(property, propList, property.length * OS.PTR_SIZEOF);
            OS.XFree(propList);
        }
        if (desktop == 0 && (gnome = OS.XInternAtom(xDisplay, gnomeName = Converter.wcsToMbcs(null, "_NET_SUPPORTING_WM_CHECK", true), true)) != 0 && OS.GTK_VERSION >= OS.VERSION(2, 2, 0) && Program.gnome_init()) {
            byte[] buffer;
            desktop = 1;
            int icon_theme = GNOME.gnome_icon_theme_new();
            display.setData(ICON_THEME_DATA, new LONG(icon_theme));
            display.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    LONG gnomeIconTheme = (LONG)display.getData(Program.ICON_THEME_DATA);
                    if (gnomeIconTheme == null) {
                        return;
                    }
                    display.setData(Program.ICON_THEME_DATA, null);
                    if (gnomeIconTheme.value != 0) {
                        OS.g_object_unref(gnomeIconTheme.value);
                    }
                }
            });
            int flags = OS.RTLD_LAZY;
            if (OS.IsAIX) {
                buffer = Converter.wcsToMbcs(null, "libgio-2.0.a(libgio-2.0.so.0)", true);
                flags |= 0x40000;
            } else {
                buffer = OS.IsHPUX ? Converter.wcsToMbcs(null, "libgio-2.0.so", true) : Converter.wcsToMbcs(null, "libgio-2.0.so.0", true);
            }
            int libgio = OS.dlopen(buffer, flags);
            if (libgio != 0) {
                buffer = Converter.wcsToMbcs(null, "g_app_info_launch_default_for_uri", true);
                int g_app_info_launch_default_for_uri = OS.dlsym(libgio, buffer);
                if (g_app_info_launch_default_for_uri != 0) {
                    desktop = 3;
                }
                OS.dlclose(libgio);
            } else {
                buffer = Converter.wcsToMbcs(null, "libgnomevfs-2.so.0", true);
                int libgnomevfs = OS.dlopen(buffer, OS.RTLD_LAZY);
                if (libgnomevfs != 0) {
                    buffer = Converter.wcsToMbcs(null, "gnome_vfs_url_show", true);
                    int gnome_vfs_url_show = OS.dlsym(libgnomevfs, buffer);
                    if (gnome_vfs_url_show != 0) {
                        desktop = 2;
                    }
                    OS.dlclose(libgnomevfs);
                }
            }
        }
        if (desktop == 0) {
            byte[] cdeName = Converter.wcsToMbcs(null, "_DT_SM_PREFERENCES", true);
            int cde = OS.XInternAtom(xDisplay, cdeName, true);
            int index = 0;
            while (desktop == 0 && index < property.length) {
                if (property[index] != 0 && property[index] == cde && Program.cde_init(display)) {
                    desktop = 4;
                }
                ++index;
            }
        }
        display.setData(DESKTOP_DATA, new Integer(desktop));
        return desktop;
    }

    boolean cde_execute(String fileName) {
        byte[] action = Converter.wcsToMbcs(null, this.command, true);
        byte[] fileArg = Converter.wcsToMbcs(null, fileName, true);
        int ptr = OS.g_malloc(fileArg.length);
        OS.memmove(ptr, fileArg, fileArg.length);
        DtActionArg args = new DtActionArg();
        args.argClass = 1;
        args.name = ptr;
        long actionID = CDE.DtActionInvoke(cdeShell, action, args, 1, null, null, null, 1, 0, 0);
        OS.g_free(ptr);
        return actionID != 0L;
    }

    static String cde_getAction(String dataType) {
        String action = null;
        String actions = Program.cde_getAttribute(dataType, "ACTIONS");
        if (actions != null) {
            int index = actions.indexOf("Open");
            action = index != -1 ? actions.substring(index, index + 4) : ((index = actions.indexOf(",")) != -1 ? actions.substring(0, index) : actions);
        }
        return action;
    }

    static String cde_getAttribute(String dataType, String attrName) {
        byte[] optNameBuf;
        byte[] attrNameBuf;
        byte[] dataTypeBuf = Converter.wcsToMbcs(null, dataType, true);
        int attrValue = CDE.DtDtsDataTypeToAttributeValue(dataTypeBuf, attrNameBuf = Converter.wcsToMbcs(null, attrName, true), optNameBuf = (byte[])null);
        if (attrValue == 0) {
            return null;
        }
        int length = OS.strlen(attrValue);
        byte[] attrValueBuf = new byte[length];
        OS.memmove(attrValueBuf, attrValue, length);
        CDE.DtDtsFreeAttributeValue(attrValue);
        return new String(Converter.mbcsToWcs(null, attrValueBuf));
    }

    static Hashtable cde_getDataTypeInfo() {
        Hashtable dataTypeInfo = new Hashtable();
        int dataTypeList = CDE.DtDtsDataTypeNames();
        if (dataTypeList != 0) {
            int index = 0;
            int[] dataType = new int[1];
            OS.memmove(dataType, dataTypeList + index++ * 4, 4);
            while (dataType[0] != 0) {
                int length = OS.strlen(dataType[0]);
                byte[] dataTypeBuf = new byte[length];
                OS.memmove(dataTypeBuf, dataType[0], length);
                String dataTypeName = new String(Converter.mbcsToWcs(null, dataTypeBuf));
                String extension = Program.cde_getExtension(dataTypeName);
                if (!CDE.DtDtsDataTypeIsAction(dataTypeBuf) && extension != null && Program.cde_getAction(dataTypeName) != null) {
                    Vector<String> exts = new Vector<String>();
                    exts.addElement(extension);
                    dataTypeInfo.put(dataTypeName, exts);
                }
                OS.memmove(dataType, dataTypeList + index++ * 4, 4);
            }
            CDE.DtDtsFreeDataTypeNames(dataTypeList);
        }
        return dataTypeInfo;
    }

    static String cde_getExtension(String dataType) {
        String fileExt = Program.cde_getAttribute(dataType, "NAME_TEMPLATE");
        if (fileExt == null || fileExt.indexOf("%s.") == -1) {
            return null;
        }
        int dot = fileExt.indexOf(".");
        return fileExt.substring(dot);
    }

    ImageData cde_getImageData() {
        return null;
    }

    static String cde_getMimeType(String extension) {
        String mimeType = null;
        Hashtable mimeInfo = Program.cde_getDataTypeInfo();
        if (mimeInfo == null) {
            return null;
        }
        Enumeration keys = mimeInfo.keys();
        block0: while (mimeType == null && keys.hasMoreElements()) {
            String type = (String)keys.nextElement();
            Vector mimeExts = (Vector)mimeInfo.get(type);
            int index = 0;
            while (index < mimeExts.size()) {
                if (extension.equals(mimeExts.elementAt(index))) {
                    mimeType = type;
                    continue block0;
                }
                ++index;
            }
        }
        return mimeType;
    }

    static Program cde_getProgram(Display display, String mimeType) {
        Program program = new Program();
        program.display = display;
        program.name = mimeType;
        program.command = Program.cde_getAction(mimeType);
        program.iconPath = Program.cde_getAttribute(program.name, "ICON");
        return program;
    }

    static boolean cde_init(Display display) {
        try {
            Library.loadLibrary("swt-cde");
        }
        catch (Throwable throwable) {
            return false;
        }
        CDE.XtToolkitInitialize();
        int xtContext = CDE.XtCreateApplicationContext();
        int xDisplay = OS.GDK_DISPLAY();
        byte[] appName = Converter.wcsToMbcs(null, "CDE", true);
        byte[] appClass = Converter.wcsToMbcs(null, "CDE", true);
        int[] argc = new int[1];
        CDE.XtDisplayInitialize(xtContext, xDisplay, appName, appClass, 0, 0, argc, 0);
        int widgetClass = CDE.topLevelShellWidgetClass();
        cdeShell = CDE.XtAppCreateShell(appName, appClass, widgetClass, xDisplay, null, 0);
        CDE.XtSetMappedWhenManaged(cdeShell, false);
        CDE.XtResizeWidget(cdeShell, 10, 10, 0);
        CDE.XtRealizeWidget(cdeShell);
        boolean initOK = CDE.DtAppInitialize(xtContext, xDisplay, cdeShell, appName, appName);
        if (initOK) {
            CDE.DtDbLoad();
        }
        return initOK;
    }

    static boolean cde_isExecutable(String fileName) {
        byte[] fileNameBuffer = Converter.wcsToMbcs(null, fileName, true);
        return OS.access(fileNameBuffer, 1) == 0;
    }

    /*
     * Unable to fully structure code
     */
    static String[] parseCommand(String cmd) {
        args = new Vector<String>();
        sIndex = 0;
        ** GOTO lbl25
        {
            ++sIndex;
            do {
                if (sIndex < cmd.length() && Compatibility.isWhitespace(cmd.charAt(sIndex))) continue block0;
                if (sIndex >= cmd.length()) continue;
                if (cmd.charAt(sIndex) == '\"' || cmd.charAt(sIndex) == '\'') {
                    eIndex = sIndex + 1;
                    while (eIndex < cmd.length() && cmd.charAt(eIndex) != cmd.charAt(sIndex)) {
                        ++eIndex;
                    }
                    if (eIndex >= cmd.length()) {
                        args.addElement(cmd.substring(sIndex, eIndex));
                    } else {
                        args.addElement(cmd.substring(sIndex + 1, eIndex));
                    }
                    sIndex = eIndex + 1;
                    continue;
                }
                eIndex = sIndex;
                while (eIndex < cmd.length() && !Compatibility.isWhitespace(cmd.charAt(eIndex))) {
                    ++eIndex;
                }
                args.addElement(cmd.substring(sIndex, eIndex));
                sIndex = eIndex + 1;
lbl25:
                // 4 sources

            } while (sIndex < cmd.length());
        }
        strings = new String[args.size()];
        index = 0;
        while (index < args.size()) {
            strings[index] = (String)args.elementAt(index);
            ++index;
        }
        return strings;
    }

    boolean gnome_24_execute(String fileName) {
        byte[] mimeTypeBuffer = Converter.wcsToMbcs(null, this.name, true);
        int ptr = GNOME.gnome_vfs_mime_get_default_application(mimeTypeBuffer);
        byte[] fileNameBuffer = Converter.wcsToMbcs(null, fileName, true);
        int uri = GNOME.gnome_vfs_make_uri_from_input_with_dirs(fileNameBuffer, 2);
        int list = GNOME.g_list_append(0, uri);
        int result = GNOME.gnome_vfs_mime_application_launch(ptr, list);
        GNOME.gnome_vfs_mime_application_free(ptr);
        GNOME.g_free(uri);
        GNOME.g_list_free(list);
        return result == 0;
    }

    static boolean gnome_24_launch(String fileName) {
        byte[] fileNameBuffer = Converter.wcsToMbcs(null, fileName, true);
        int uri = GNOME.gnome_vfs_make_uri_from_input_with_dirs(fileNameBuffer, 2);
        int result = GNOME.gnome_vfs_url_show(uri);
        GNOME.g_free(uri);
        return result == 0;
    }

    boolean gnome_execute(String fileName) {
        byte[] fileNameBuffer;
        int uri;
        if (this.gnomeExpectUri && (uri = GNOME.gnome_vfs_make_uri_from_input(fileNameBuffer = Converter.wcsToMbcs(null, fileName, true))) != 0) {
            int length = OS.strlen(uri);
            if (length > 0) {
                byte[] buffer = new byte[length];
                OS.memmove(buffer, uri, length);
                fileName = new String(Converter.mbcsToWcs(null, buffer));
            }
            GNOME.g_free(uri);
        }
        String[] args = Program.parseCommand(this.command);
        int fileArg = -1;
        int index = 0;
        while (index < args.length) {
            int j = args[index].indexOf("%f");
            if (j != -1) {
                String value = args[index];
                fileArg = index;
                args[index] = String.valueOf(value.substring(0, j)) + fileName + value.substring(j + 2);
            }
            ++index;
        }
        if (fileName.length() > 0 && fileArg < 0) {
            String[] newArgs = new String[args.length + 1];
            index = 0;
            while (index < args.length) {
                newArgs[index] = args[index];
                ++index;
            }
            newArgs[args.length] = fileName;
            args = newArgs;
        }
        try {
            Compatibility.exec(args);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    ImageData gnome_getImageData() {
        if (this.iconPath == null) {
            return null;
        }
        try {
            return new ImageData(this.iconPath);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static Hashtable gnome_getMimeInfo() {
        int mimeList;
        Hashtable mimeInfo = new Hashtable();
        int[] mimeData = new int[1];
        int[] extensionData = new int[1];
        int mimeElement = mimeList = GNOME.gnome_vfs_get_registered_mime_types();
        while (mimeElement != 0) {
            OS.memmove(mimeData, mimeElement, OS.PTR_SIZEOF);
            int mimePtr = mimeData[0];
            int mimeLength = OS.strlen(mimePtr);
            byte[] mimeTypeBuffer = new byte[mimeLength];
            OS.memmove(mimeTypeBuffer, mimePtr, mimeLength);
            String mimeType = new String(Converter.mbcsToWcs(null, mimeTypeBuffer));
            int extensionList = GNOME.gnome_vfs_mime_get_extensions_list(mimePtr);
            if (extensionList != 0) {
                Vector<String> extensions = new Vector<String>();
                int extensionElement = extensionList;
                while (extensionElement != 0) {
                    OS.memmove(extensionData, extensionElement, OS.PTR_SIZEOF);
                    int extensionPtr = extensionData[0];
                    int extensionLength = OS.strlen(extensionPtr);
                    byte[] extensionBuffer = new byte[extensionLength];
                    OS.memmove(extensionBuffer, extensionPtr, extensionLength);
                    String extension = new String(Converter.mbcsToWcs(null, extensionBuffer));
                    extension = String.valueOf('.') + extension;
                    extensions.addElement(extension);
                    extensionElement = GNOME.g_list_next(extensionElement);
                }
                GNOME.gnome_vfs_mime_extensions_list_free(extensionList);
                if (extensions.size() > 0) {
                    mimeInfo.put(mimeType, extensions);
                }
            }
            mimeElement = GNOME.g_list_next(mimeElement);
        }
        if (mimeList != 0) {
            GNOME.gnome_vfs_mime_registered_mime_type_list_free(mimeList);
        }
        return mimeInfo;
    }

    static String gnome_getMimeType(String extension) {
        int length;
        String mimeType = null;
        String fileName = "swt" + extension;
        byte[] extensionBuffer = Converter.wcsToMbcs(null, fileName, true);
        int typeName = GNOME.gnome_vfs_mime_type_from_name(extensionBuffer);
        if (typeName != 0 && (length = OS.strlen(typeName)) > 0) {
            byte[] buffer = new byte[length];
            OS.memmove(buffer, typeName, length);
            mimeType = new String(Converter.mbcsToWcs(null, buffer));
        }
        return mimeType;
    }

    static Program gnome_getProgram(Display display, String mimeType) {
        Program program = null;
        byte[] mimeTypeBuffer = Converter.wcsToMbcs(null, mimeType, true);
        int ptr = GNOME.gnome_vfs_mime_get_default_application(mimeTypeBuffer);
        if (ptr != 0) {
            program = new Program();
            program.display = display;
            program.name = mimeType;
            GnomeVFSMimeApplication application = new GnomeVFSMimeApplication();
            GNOME.memmove(application, ptr, GnomeVFSMimeApplication.sizeof);
            int length = OS.strlen(application.command);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, application.command, length);
            program.command = new String(Converter.mbcsToWcs(null, buffer));
            program.gnomeExpectUri = application.expects_uris == 0;
            length = OS.strlen(application.id);
            buffer = new byte[length + 1];
            OS.memmove(buffer, application.id, length);
            LONG gnomeIconTheme = (LONG)display.getData(ICON_THEME_DATA);
            int icon_name = GNOME.gnome_icon_lookup(gnomeIconTheme.value, 0, null, buffer, 0, mimeTypeBuffer, 0, null);
            int path = 0;
            if (icon_name != 0) {
                path = GNOME.gnome_icon_theme_lookup_icon(gnomeIconTheme.value, icon_name, 16, null, null);
            }
            if (path != 0) {
                length = OS.strlen(path);
                if (length > 0) {
                    buffer = new byte[length];
                    OS.memmove(buffer, path, length);
                    program.iconPath = new String(Converter.mbcsToWcs(null, buffer));
                }
                GNOME.g_free(path);
            }
            if (icon_name != 0) {
                GNOME.g_free(icon_name);
            }
            GNOME.gnome_vfs_mime_application_free(ptr);
        }
        return program;
    }

    static boolean gnome_init() {
        try {
            return GNOME.gnome_vfs_init();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static boolean gnome_isExecutable(String fileName) {
        boolean result;
        byte[] fileNameBuffer = Converter.wcsToMbcs(null, fileName, true);
        if (!GNOME.gnome_vfs_is_executable_command_string(fileNameBuffer)) {
            return false;
        }
        int uri = GNOME.gnome_vfs_make_uri_from_input(fileNameBuffer);
        int mimeType = GNOME.gnome_vfs_get_mime_type(uri);
        GNOME.g_free(uri);
        byte[] exeType = Converter.wcsToMbcs(null, "application/x-executable", true);
        boolean bl = result = GNOME.gnome_vfs_mime_type_get_equivalence(mimeType, exeType) != 0;
        if (!result) {
            byte[] shellType = Converter.wcsToMbcs(null, "application/x-shellscript", true);
            result = GNOME.gnome_vfs_mime_type_get_equivalence(mimeType, shellType) == 1;
        }
        return result;
    }

    public static Program findProgram(String extension) {
        return Program.findProgram(Display.getCurrent(), extension);
    }

    static Program findProgram(Display display, String extension) {
        if (extension == null) {
            SWT.error(4);
        }
        if (extension.length() == 0) {
            return null;
        }
        if (extension.charAt(0) != '.') {
            extension = "." + extension;
        }
        int desktop = Program.getDesktop(display);
        String mimeType = null;
        switch (desktop) {
            case 3: {
                mimeType = Program.gio_getMimeType(extension);
                break;
            }
            case 1: 
            case 2: {
                mimeType = Program.gnome_getMimeType(extension);
                break;
            }
            case 4: {
                mimeType = Program.cde_getMimeType(extension);
            }
        }
        if (mimeType == null) {
            return null;
        }
        Program program = null;
        switch (desktop) {
            case 3: {
                program = Program.gio_getProgram(display, mimeType);
                break;
            }
            case 1: 
            case 2: {
                program = Program.gnome_getProgram(display, mimeType);
                break;
            }
            case 4: {
                program = Program.cde_getProgram(display, mimeType);
            }
        }
        return program;
    }

    public static String[] getExtensions() {
        return Program.getExtensions(Display.getCurrent());
    }

    static String[] getExtensions(Display display) {
        int desktop = Program.getDesktop(display);
        Hashtable mimeInfo = null;
        switch (desktop) {
            case 3: {
                return Program.gio_getExtensions();
            }
            case 2: {
                break;
            }
            case 1: {
                mimeInfo = Program.gnome_getMimeInfo();
                break;
            }
            case 4: {
                mimeInfo = Program.cde_getDataTypeInfo();
            }
        }
        if (mimeInfo == null) {
            return new String[0];
        }
        Vector extensions = new Vector();
        Enumeration keys = mimeInfo.keys();
        while (keys.hasMoreElements()) {
            String mimeType = (String)keys.nextElement();
            Vector mimeExts = (Vector)mimeInfo.get(mimeType);
            int index = 0;
            while (index < mimeExts.size()) {
                if (!extensions.contains(mimeExts.elementAt(index))) {
                    extensions.addElement(mimeExts.elementAt(index));
                }
                ++index;
            }
        }
        String[] extStrings = new String[extensions.size()];
        int index = 0;
        while (index < extensions.size()) {
            extStrings[index] = (String)extensions.elementAt(index);
            ++index;
        }
        return extStrings;
    }

    public static Program[] getPrograms() {
        return Program.getPrograms(Display.getCurrent());
    }

    static Program[] getPrograms(Display display) {
        int desktop = Program.getDesktop(display);
        Hashtable mimeInfo = null;
        switch (desktop) {
            case 3: {
                return Program.gio_getPrograms(display);
            }
            case 2: {
                break;
            }
            case 1: {
                mimeInfo = Program.gnome_getMimeInfo();
                break;
            }
            case 4: {
                mimeInfo = Program.cde_getDataTypeInfo();
            }
        }
        if (mimeInfo == null) {
            return new Program[0];
        }
        Vector<Program> programs = new Vector<Program>();
        Enumeration keys = mimeInfo.keys();
        while (keys.hasMoreElements()) {
            String mimeType = (String)keys.nextElement();
            Program program = null;
            switch (desktop) {
                case 1: {
                    program = Program.gnome_getProgram(display, mimeType);
                    break;
                }
                case 4: {
                    program = Program.cde_getProgram(display, mimeType);
                }
            }
            if (program == null) continue;
            programs.addElement(program);
        }
        Program[] programList = new Program[programs.size()];
        int index = 0;
        while (index < programList.length) {
            programList[index] = (Program)programs.elementAt(index);
            ++index;
        }
        return programList;
    }

    ImageData gio_getImageData() {
        if (this.iconPath == null) {
            return null;
        }
        ImageData data = null;
        int icon_theme = OS.gtk_icon_theme_get_default();
        byte[] icon = Converter.wcsToMbcs(null, this.iconPath, true);
        int gicon = OS.g_icon_new_for_string(icon, null);
        if (gicon != 0) {
            int gicon_info = OS.gtk_icon_theme_lookup_by_gicon(icon_theme, gicon, 16, 0);
            if (gicon_info != 0) {
                int pixbuf = OS.gtk_icon_info_load_icon(gicon_info, null);
                if (pixbuf != 0) {
                    int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
                    int pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
                    int height = OS.gdk_pixbuf_get_height(pixbuf);
                    int width = OS.gdk_pixbuf_get_width(pixbuf);
                    boolean hasAlpha = OS.gdk_pixbuf_get_has_alpha(pixbuf);
                    byte[] srcData = new byte[stride * height];
                    OS.memmove(srcData, pixels, srcData.length);
                    OS.g_object_unref(pixbuf);
                    if (hasAlpha) {
                        PaletteData palette = new PaletteData(-16777216, 0xFF0000, 65280);
                        data = new ImageData(width, height, 32, palette, 4, srcData);
                        data.bytesPerLine = stride;
                        int s = 3;
                        int a = 0;
                        byte[] alphaData = new byte[width * height];
                        int y = 0;
                        while (y < height) {
                            int x = 0;
                            while (x < width) {
                                alphaData[a++] = srcData[s];
                                srcData[s] = 0;
                                s += 4;
                                ++x;
                            }
                            ++y;
                        }
                        data.alphaData = alphaData;
                    } else {
                        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
                        data = new ImageData(width, height, 24, palette, 4, srcData);
                        data.bytesPerLine = stride;
                    }
                }
                OS.gtk_icon_info_free(gicon_info);
            }
            OS.g_object_unref(gicon);
        }
        return data;
    }

    static Hashtable gio_getMimeInfo() {
        int fileInputStream;
        int mimeDatabase;
        block22: {
            int fileInfo;
            block18: {
                Hashtable hashtable;
                block21: {
                    int[] modTimestamp;
                    block19: {
                        Hashtable hashtable2;
                        block20: {
                            mimeDatabase = 0;
                            fileInfo = 0;
                            byte[] buffer = Converter.wcsToMbcs(null, "/usr/share/mime/globs", true);
                            mimeDatabase = OS.g_file_new_for_path(buffer);
                            fileInputStream = OS.g_file_read(mimeDatabase, 0, 0);
                            if (fileInputStream == 0) break block18;
                            modTimestamp = new int[2];
                            buffer = Converter.wcsToMbcs(null, "*", true);
                            fileInfo = OS.g_file_query_info(mimeDatabase, buffer, 0, 0, 0);
                            OS.g_file_info_get_modification_time(fileInfo, modTimestamp);
                            if (modTime == 0 || modTimestamp[0] != modTime) break block19;
                            hashtable2 = mimeTable;
                            Object var17_7 = null;
                            if (fileInfo == 0) break block20;
                            OS.g_object_unref(fileInfo);
                        }
                        if (fileInputStream != 0) {
                            OS.g_object_unref(fileInputStream);
                        }
                        if (mimeDatabase != 0) {
                            OS.g_object_unref(mimeDatabase);
                        }
                        return hashtable2;
                    }
                    try {
                        mimeTable = new Hashtable();
                        modTime = modTimestamp[0];
                        int reader = OS.g_data_input_stream_new(fileInputStream);
                        int[] length = new int[1];
                        if (reader != 0) {
                            int linePtr = OS.g_data_input_stream_read_line(reader, length, 0, 0);
                            while (linePtr != 0) {
                                byte[] lineBytes = new byte[length[0]];
                                OS.memmove(lineBytes, linePtr, length[0]);
                                String line = new String(Converter.mbcsToWcs(null, lineBytes));
                                int separatorIndex = line.indexOf(58);
                                if (separatorIndex > 0) {
                                    Vector<String> mimeTypes = new Vector<String>();
                                    String mimeType = line.substring(0, separatorIndex);
                                    String extensionFormat = line.substring(separatorIndex + 1);
                                    int extensionIndex = extensionFormat.indexOf(".");
                                    if (extensionIndex > 0) {
                                        String extension = extensionFormat.substring(extensionIndex);
                                        mimeTypes.add(mimeType);
                                        if (mimeTable.containsKey(extension)) {
                                            Vector value = (Vector)mimeTable.get(extension);
                                            mimeTypes.addAll(value);
                                        }
                                        mimeTable.put(extension, mimeTypes);
                                    }
                                }
                                OS.g_free(linePtr);
                                linePtr = OS.g_data_input_stream_read_line(reader, length, 0, 0);
                            }
                        }
                        if (reader != 0) {
                            OS.g_object_unref(reader);
                        }
                        hashtable = mimeTable;
                        Object var17_8 = null;
                        if (fileInfo == 0) break block21;
                    }
                    catch (Throwable throwable) {
                        block23: {
                            Object var17_10 = null;
                            if (fileInfo != 0) {
                                OS.g_object_unref(fileInfo);
                            }
                            if (fileInputStream != 0) {
                                OS.g_object_unref(fileInputStream);
                            }
                            if (mimeDatabase == 0) break block23;
                            OS.g_object_unref(mimeDatabase);
                        }
                        throw throwable;
                    }
                    OS.g_object_unref(fileInfo);
                }
                if (fileInputStream != 0) {
                    OS.g_object_unref(fileInputStream);
                }
                if (mimeDatabase != 0) {
                    OS.g_object_unref(mimeDatabase);
                }
                return hashtable;
            }
            Object var17_9 = null;
            if (fileInfo == 0) break block22;
            OS.g_object_unref(fileInfo);
        }
        if (fileInputStream != 0) {
            OS.g_object_unref(fileInputStream);
        }
        if (mimeDatabase != 0) {
            OS.g_object_unref(mimeDatabase);
        }
        return null;
    }

    static String gio_getMimeType(String extension) {
        String mimeType = null;
        Hashtable h = Program.gio_getMimeInfo();
        if (h != null && h.containsKey(extension)) {
            Vector mimeTypes = (Vector)h.get(extension);
            mimeType = (String)mimeTypes.get(0);
        }
        return mimeType;
    }

    static Program gio_getProgram(Display display, String mimeType) {
        Program program = null;
        byte[] mimeTypeBuffer = Converter.wcsToMbcs(null, mimeType, true);
        int application = OS.g_app_info_get_default_for_type(mimeTypeBuffer, false);
        if (application != 0) {
            program = Program.gio_getProgram(display, application);
        }
        return program;
    }

    static Program gio_getProgram(Display display, int application) {
        int applicationCommand;
        byte[] buffer;
        int length;
        Program program = new Program();
        program.display = display;
        int applicationName = OS.g_app_info_get_name(application);
        if (applicationName != 0 && (length = OS.strlen(applicationName)) > 0) {
            buffer = new byte[length];
            OS.memmove(buffer, applicationName, length);
            program.name = new String(Converter.mbcsToWcs(null, buffer));
        }
        if ((applicationCommand = OS.g_app_info_get_executable(application)) != 0 && (length = OS.strlen(applicationCommand)) > 0) {
            buffer = new byte[length];
            OS.memmove(buffer, applicationCommand, length);
            program.command = new String(Converter.mbcsToWcs(null, buffer));
        }
        program.gnomeExpectUri = OS.g_app_info_supports_uris(application);
        int icon = OS.g_app_info_get_icon(application);
        if (icon != 0) {
            int icon_name = OS.g_icon_to_string(icon);
            if (icon_name != 0) {
                length = OS.strlen(icon_name);
                if (length > 0) {
                    buffer = new byte[length];
                    OS.memmove(buffer, icon_name, length);
                    program.iconPath = new String(Converter.mbcsToWcs(null, buffer));
                }
                OS.g_free(icon_name);
            }
            OS.g_object_unref(icon);
        }
        return program;
    }

    static Program[] gio_getPrograms(Display display) {
        int applicationList;
        int list = applicationList = OS.g_app_info_get_all();
        Vector<Program> programs = new Vector<Program>();
        while (list != 0) {
            Program program;
            int application = OS.g_list_data(list);
            if (application != 0 && (program = Program.gio_getProgram(display, application)) != null) {
                programs.addElement(program);
            }
            list = OS.g_list_next(list);
        }
        if (applicationList != 0) {
            OS.g_list_free(applicationList);
        }
        Program[] programList = new Program[programs.size()];
        int index = 0;
        while (index < programList.length) {
            programList[index] = (Program)programs.elementAt(index);
            ++index;
        }
        return programList;
    }

    static boolean gio_isExecutable(String fileName) {
        byte[] fileNameBuffer = Converter.wcsToMbcs(null, fileName, true);
        if (OS.g_file_test(fileNameBuffer, 4)) {
            return false;
        }
        if (!OS.g_file_test(fileNameBuffer, 8)) {
            return false;
        }
        int file = OS.g_file_new_for_path(fileNameBuffer);
        boolean result = false;
        if (file != 0) {
            byte[] buffer = Converter.wcsToMbcs(null, "*", true);
            int fileInfo = OS.g_file_query_info(file, buffer, 0, 0, 0);
            if (fileInfo != 0) {
                byte[] exeType;
                int contentType = OS.g_file_info_get_content_type(fileInfo);
                if (contentType != 0 && !(result = OS.g_content_type_is_a(contentType, exeType = Converter.wcsToMbcs(null, "application/x-executable", true)))) {
                    byte[] shellType = Converter.wcsToMbcs(null, "application/x-shellscript", true);
                    result = OS.g_content_type_equals(contentType, shellType);
                }
                OS.g_object_unref(fileInfo);
            }
            OS.g_object_unref(file);
        }
        return result;
    }

    static boolean gio_launch(String fileName) {
        boolean result = false;
        byte[] fileNameBuffer = Converter.wcsToMbcs(null, fileName, true);
        int file = OS.g_file_new_for_path(fileNameBuffer);
        if (file != 0) {
            int uri = OS.g_file_get_uri(file);
            if (uri != 0) {
                result = OS.g_app_info_launch_default_for_uri(uri, 0, 0);
                OS.g_free(uri);
            }
            OS.g_object_unref(file);
        }
        return result;
    }

    boolean gio_execute(String fileName) {
        byte[] nameBuffer;
        boolean result = false;
        byte[] commandBuffer = Converter.wcsToMbcs(null, this.command, true);
        int application = OS.g_app_info_create_from_commandline(commandBuffer, nameBuffer = Converter.wcsToMbcs(null, this.name, true), this.gnomeExpectUri ? 2 : 0, 0);
        if (application != 0) {
            byte[] fileNameBuffer = Converter.wcsToMbcs(null, fileName, true);
            int file = 0;
            file = OS.g_app_info_supports_uris(application) ? OS.g_file_new_for_uri(fileNameBuffer) : OS.g_file_new_for_path(fileNameBuffer);
            if (file != 0) {
                int list = OS.g_list_append(0, file);
                result = OS.g_app_info_launch(application, list, 0, 0);
                OS.g_list_free(list);
                OS.g_object_unref(file);
            }
            OS.g_object_unref(application);
        }
        return result;
    }

    static String[] gio_getExtensions() {
        Hashtable mimeInfo = Program.gio_getMimeInfo();
        if (mimeInfo == null) {
            return new String[0];
        }
        Vector<String> extensions = new Vector<String>();
        Enumeration keys = mimeInfo.keys();
        while (keys.hasMoreElements()) {
            String extension = (String)keys.nextElement();
            extensions.add(extension);
        }
        String[] extStrings = new String[extensions.size()];
        int index = 0;
        while (index < extensions.size()) {
            extStrings[index] = (String)extensions.elementAt(index);
            ++index;
        }
        return extStrings;
    }

    static boolean isExecutable(Display display, String fileName) {
        switch (Program.getDesktop(display)) {
            case 3: {
                return Program.gio_isExecutable(fileName);
            }
            case 1: 
            case 2: {
                return Program.gnome_isExecutable(fileName);
            }
            case 4: {
                return false;
            }
        }
        return false;
    }

    public static boolean launch(String fileName) {
        return Program.launch(Display.getCurrent(), fileName, null);
    }

    public static boolean launch(String fileName, String workingDir) {
        return Program.launch(Display.getCurrent(), fileName, workingDir);
    }

    static boolean launch(Display display, String fileName, String workingDir) {
        String extension;
        Program program;
        if (fileName == null) {
            SWT.error(4);
        }
        if (workingDir != null && Program.isExecutable(display, fileName)) {
            try {
                Compatibility.exec(new String[]{fileName}, null, workingDir);
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        switch (Program.getDesktop(display)) {
            case 3: {
                if (Program.gio_launch(fileName)) {
                    return true;
                }
            }
            case 2: {
                if (!Program.gnome_24_launch(fileName)) break;
                return true;
            }
        }
        int index = fileName.lastIndexOf(46);
        if (index != -1 && (program = Program.findProgram(display, extension = fileName.substring(index))) != null && program.execute(fileName)) {
            return true;
        }
        String lowercaseName = fileName.toLowerCase();
        if (lowercaseName.startsWith(PREFIX_HTTP) || lowercaseName.startsWith(PREFIX_HTTPS)) {
            program = Program.findProgram(display, ".html");
            if (program == null) {
                program = Program.findProgram(display, ".htm");
            }
            if (program != null && program.execute(fileName)) {
                return true;
            }
        }
        try {
            Compatibility.exec(new String[]{fileName}, null, workingDir);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Program)) {
            return false;
        }
        Program program = (Program)other;
        return this.display == program.display && this.name.equals(program.name) && this.command.equals(program.command);
    }

    public boolean execute(String fileName) {
        if (fileName == null) {
            SWT.error(4);
        }
        int desktop = Program.getDesktop(this.display);
        switch (desktop) {
            case 3: {
                return this.gio_execute(fileName);
            }
            case 2: {
                return this.gnome_24_execute(fileName);
            }
            case 1: {
                return this.gnome_execute(fileName);
            }
            case 4: {
                return this.cde_execute(fileName);
            }
        }
        return false;
    }

    public ImageData getImageData() {
        switch (Program.getDesktop(this.display)) {
            case 3: {
                return this.gio_getImageData();
            }
            case 1: 
            case 2: {
                return this.gnome_getImageData();
            }
            case 4: {
                return this.cde_getImageData();
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.command.hashCode() ^ this.display.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

