/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkSelectionData;
import org.eclipse.swt.internal.gtk.GtkTargetEntry;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class ClipboardProxy {
    Object[] clipboardData;
    Transfer[] clipboardDataTypes;
    Object[] primaryClipboardData;
    Transfer[] primaryClipboardDataTypes;
    long clipboardOwner = OS.gtk_window_new(0);
    Display display;
    Clipboard activeClipboard = null;
    Clipboard activePrimaryClipboard = null;
    Callback getFunc;
    Callback clearFunc;
    static String ID = "CLIPBOARD PROXY OBJECT";

    static ClipboardProxy _getInstance(final Display display) {
        ClipboardProxy clipboardProxy = (ClipboardProxy)display.getData(ID);
        if (clipboardProxy != null) {
            return clipboardProxy;
        }
        clipboardProxy = new ClipboardProxy(display);
        display.setData(ID, clipboardProxy);
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                ClipboardProxy clipboardProxy = (ClipboardProxy)display.getData(ID);
                if (clipboardProxy == null) {
                    return;
                }
                display.setData(ID, null);
                clipboardProxy.dispose();
            }
        });
        return clipboardProxy;
    }

    ClipboardProxy(Display display) {
        this.display = display;
        this.getFunc = new Callback(this, "getFunc", 4);
        if (this.getFunc.getAddress() == 0L) {
            SWT.error(3);
        }
        this.clearFunc = new Callback(this, "clearFunc", 2);
        if (this.clearFunc.getAddress() == 0L) {
            SWT.error(3);
        }
    }

    void clear(Clipboard clipboard, int n) {
        if ((n & 1) != 0 && this.activeClipboard == clipboard) {
            OS.gtk_clipboard_clear(Clipboard.GTKCLIPBOARD);
        }
        if ((n & 2) != 0 && this.activePrimaryClipboard == clipboard) {
            OS.gtk_clipboard_clear(Clipboard.GTKPRIMARYCLIPBOARD);
        }
    }

    long clearFunc(long l, long l2) {
        if (l == Clipboard.GTKCLIPBOARD) {
            this.activeClipboard = null;
            this.clipboardData = null;
            this.clipboardDataTypes = null;
        }
        if (l == Clipboard.GTKPRIMARYCLIPBOARD) {
            this.activePrimaryClipboard = null;
            this.primaryClipboardData = null;
            this.primaryClipboardDataTypes = null;
        }
        return 1L;
    }

    void dispose() {
        if (this.display == null) {
            return;
        }
        if (this.activeClipboard != null) {
            OS.gtk_clipboard_clear(Clipboard.GTKCLIPBOARD);
        }
        if (this.activePrimaryClipboard != null) {
            OS.gtk_clipboard_clear(Clipboard.GTKPRIMARYCLIPBOARD);
        }
        this.display = null;
        if (this.getFunc != null) {
            this.getFunc.dispose();
        }
        this.getFunc = null;
        if (this.clearFunc != null) {
            this.clearFunc.dispose();
        }
        this.clearFunc = null;
        this.clipboardData = null;
        this.clipboardDataTypes = null;
        this.primaryClipboardData = null;
        this.primaryClipboardDataTypes = null;
        if (this.clipboardOwner != 0L) {
            OS.gtk_widget_destroy(this.clipboardOwner);
        }
        this.clipboardOwner = 0L;
    }

    long getFunc(long l, long l2, long l3, long l4) {
        if (l2 == 0L) {
            return 0L;
        }
        GtkSelectionData gtkSelectionData = new GtkSelectionData();
        OS.memmove(gtkSelectionData, l2, (long)GtkSelectionData.sizeof);
        TransferData transferData = new TransferData();
        transferData.type = gtkSelectionData.target;
        Transfer[] transferArray = l == Clipboard.GTKCLIPBOARD ? this.clipboardDataTypes : this.primaryClipboardDataTypes;
        int n = -1;
        int n2 = 0;
        while (n2 < transferArray.length) {
            if (transferArray[n2].isSupportedType(transferData)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return 0L;
        }
        Object[] objectArray = l == Clipboard.GTKCLIPBOARD ? this.clipboardData : this.primaryClipboardData;
        transferArray[n].javaToNative(objectArray[n], transferData);
        if (transferData.format < 8 || transferData.format % 8 != 0) {
            return 0L;
        }
        OS.gtk_selection_data_set(l2, transferData.type, transferData.format, transferData.pValue, transferData.length);
        OS.g_free(transferData.pValue);
        return 1L;
    }

    /*
     * Unable to fully structure code
     */
    boolean setData(Clipboard var1_1, Object[] var2_2, Transfer[] var3_3, int var4_4) {
        block17: {
            block16: {
                var5_5 = new GtkTargetEntry[]{};
                var6_6 = 0L;
                var8_7 = 0;
                while (var8_7 < var3_3.length) {
                    var9_8 = var3_3[var8_7];
                    var10_11 = var9_8.getTypeIds();
                    var11_12 = var9_8.getTypeNames();
                    var12_14 = 0;
                    while (var12_14 < var10_11.length) {
                        var13_15 = new GtkTargetEntry();
                        var13_15.info = var10_11[var12_14];
                        var14_16 = Converter.wcsToMbcs(null, var11_12[var12_14], true);
                        var15_17 = OS.g_malloc(var14_16.length);
                        OS.memmove(var15_17, var14_16, (long)var14_16.length);
                        var13_15.target = var15_17;
                        var17_18 = new GtkTargetEntry[var5_5.length + 1];
                        System.arraycopy(var5_5, 0, var17_18, 0, var5_5.length);
                        var17_18[var5_5.length] = var13_15;
                        var5_5 = var17_18;
                        ++var12_14;
                    }
                    ++var8_7;
                }
                var6_6 = OS.g_malloc(GtkTargetEntry.sizeof * var5_5.length);
                var8_7 = 0;
                var9_9 = 0;
                while (var9_9 < var5_5.length) {
                    OS.memmove(var6_6 + (long)var8_7, var5_5[var9_9], (long)GtkTargetEntry.sizeof);
                    var8_7 += GtkTargetEntry.sizeof;
                    ++var9_9;
                }
                if ((var4_4 & 1) == 0) ** GOTO lbl54
                this.clipboardData = var2_2;
                this.clipboardDataTypes = var3_3;
                var9_10 = this.getFunc.getAddress();
                if (OS.gtk_clipboard_set_with_owner(Clipboard.GTKCLIPBOARD, var6_6, var5_5.length, var9_10, var11_13 = this.clearFunc.getAddress(), this.clipboardOwner)) break block16;
                while (true) {
                    var18_19 = null;
                    var20_22 = 0;
                    while (var20_22 < var5_5.length) {
                        var21_25 = var5_5[var20_22];
                        if (var21_25.target != 0L) {
                            OS.g_free(var21_25.target);
                        }
                        ++var20_22;
                    }
                    if (var6_6 != 0L) {
                        OS.g_free(var6_6);
                    }
                    return false;
                }
            }
            try {
                this.activeClipboard = var1_1;
lbl54:
                // 2 sources

                if ((var4_4 & 2) != 0) {
                    this.primaryClipboardData = var2_2;
                    this.primaryClipboardDataTypes = var3_3;
                    if (!OS.gtk_clipboard_set_with_owner(Clipboard.GTKPRIMARYCLIPBOARD, var6_6, var5_5.length, var9_10 = this.getFunc.getAddress(), var11_13 = this.clearFunc.getAddress(), this.clipboardOwner)) ** continue;
                    this.activePrimaryClipboard = var1_1;
                }
                var18_20 = null;
                var20_23 = 0;
                ** while (var20_23 < var5_5.length)
            }
            catch (Throwable var19_28) {
                var18_21 = null;
                var20_24 = 0;
                ** while (var20_24 < var5_5.length)
            }
lbl-1000:
            // 1 sources

            {
                var21_26 = var5_5[var20_23];
                if (var21_26.target != 0L) {
                    OS.g_free(var21_26.target);
                }
                ++var20_23;
                continue;
            }
lbl68:
            // 1 sources

            if (var6_6 != 0L) {
                OS.g_free(var6_6);
            }
            return true;
lbl-1000:
            // 1 sources

            {
                var21_27 = var5_5[var20_24];
                if (var21_27.target != 0L) {
                    OS.g_free(var21_27.target);
                }
                ++var20_24;
                continue;
            }
lbl81:
            // 1 sources

            if (var6_6 == 0L) break block17;
            OS.g_free(var6_6);
        }
        throw var19_28;
    }
}

