/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkFileSelection;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String filterPath = "";
    String fileName = "";
    String[] fileNames = new String[0];
    String fullPath = "";
    int filterIndex = -1;
    boolean overwrite = false;
    boolean uriMode;
    long handle;
    static final char SEPARATOR = System.getProperty("file.separator").charAt(0);
    static final char EXTENSION_SEPARATOR = ';';
    static final char FILE_EXTENSION_SEPARATOR = '.';

    public FileDialog(Shell shell) {
        this(shell, 65536);
    }

    public FileDialog(Shell shell, int n) {
        super(shell, FileDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    String computeResultChooserDialog() {
        long l;
        int n;
        long l2;
        int n2;
        long l3;
        this.fullPath = null;
        if ((this.style & 2) != 0) {
            l3 = 0L;
            l3 = this.uriMode ? OS.gtk_file_chooser_get_uris(this.handle) : OS.gtk_file_chooser_get_filenames(this.handle);
            n2 = OS.g_slist_length(l3);
            this.fileNames = new String[n2];
            l2 = l3;
            n = 0;
            int n3 = 0;
            while (n3 < n2) {
                long l4 = OS.g_slist_data(l2);
                long l5 = 0L;
                if (this.uriMode) {
                    l5 = l4;
                } else {
                    l5 = OS.g_filename_to_utf8(l4, -1L, null, null, null);
                    OS.g_free(l4);
                }
                if (l5 != 0L) {
                    long[] lArray = new long[1];
                    long l6 = OS.g_utf8_to_utf16(l5, -1L, null, lArray, null);
                    OS.g_free(l5);
                    if (l6 != 0L) {
                        int n4 = (int)lArray[0];
                        char[] cArray = new char[n4];
                        OS.memmove(cArray, l6, (long)(n4 * 2));
                        OS.g_free(l6);
                        this.fullPath = new String(cArray);
                        this.fileNames[n++] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                    }
                }
                l2 = OS.g_slist_next(l2);
                ++n3;
            }
            if (n != 0 && n != n2) {
                String[] stringArray = new String[n];
                System.arraycopy(this.fileNames, 0, stringArray, 0, n);
                this.fileNames = stringArray;
            }
            OS.g_slist_free(l3);
        } else {
            l3 = 0L;
            if (this.uriMode) {
                l3 = OS.gtk_file_chooser_get_uri(this.handle);
            } else {
                long l7 = OS.gtk_file_chooser_get_filename(this.handle);
                if (l7 != 0L) {
                    l3 = OS.g_filename_to_utf8(l7, -1L, null, null, null);
                    OS.g_free(l7);
                }
            }
            if (l3 != 0L) {
                long[] lArray = new long[1];
                l2 = OS.g_utf8_to_utf16(l3, -1L, null, lArray, null);
                OS.g_free(l3);
                if (l2 != 0L) {
                    n = (int)lArray[0];
                    char[] cArray = new char[n];
                    OS.memmove(cArray, l2, (long)(n * 2));
                    OS.g_free(l2);
                    this.fullPath = new String(cArray);
                    this.fileNames = new String[1];
                    this.fileNames[0] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                }
            }
        }
        this.filterIndex = -1;
        l3 = OS.gtk_file_chooser_get_filter(this.handle);
        if (l3 != 0L && (l = OS.gtk_file_filter_get_name(l3)) != 0L) {
            int n5 = OS.strlen(l);
            byte[] byArray = new byte[n5];
            OS.memmove(byArray, l, (long)n5);
            String string = new String(Converter.mbcsToWcs(null, byArray));
            int n6 = 0;
            while (n6 < this.filterExtensions.length) {
                if (this.filterNames.length > 0) {
                    if (this.filterNames[n6].equals(string)) {
                        this.filterIndex = n6;
                        break;
                    }
                } else if (this.filterExtensions[n6].equals(string)) {
                    this.filterIndex = n6;
                    break;
                }
                ++n6;
            }
        }
        if (this.fullPath != null) {
            n2 = this.fullPath.lastIndexOf(SEPARATOR);
            this.fileName = this.fullPath.substring(n2 + 1);
            this.filterPath = this.fullPath.substring(0, n2);
            int n7 = this.fileName.indexOf(46);
            if ((this.style & 0x2000) != 0 && n7 == -1 && this.filterIndex != -1 && this.filterExtensions.length > this.filterIndex) {
                String string;
                String string2 = this.filterExtensions[this.filterIndex];
                int n8 = string2.length();
                int n9 = string2.indexOf(59);
                if (n9 == -1) {
                    n9 = n8;
                }
                if (!(string = string2.substring(0, n9).trim()).equals("*") && !string.equals("*.*")) {
                    if (string.startsWith("*.")) {
                        string = string.substring(1);
                    }
                    this.fullPath = String.valueOf(this.fullPath) + string;
                }
            }
        }
        return this.fullPath;
    }

    String computeResultClassicDialog() {
        long l;
        Object object;
        long l2;
        long[] lArray;
        long l3;
        long l4;
        this.filterIndex = -1;
        GtkFileSelection gtkFileSelection = new GtkFileSelection();
        OS.memmove(gtkFileSelection, this.handle);
        long l5 = gtkFileSelection.selection_entry;
        long l6 = OS.gtk_entry_get_text(l5);
        int n = OS.strlen(l6);
        if (n == 0) {
            l4 = gtkFileSelection.file_list;
            l3 = OS.gtk_tree_view_get_selection(l4);
            l2 = OS.gtk_tree_selection_get_selected_rows(l3, lArray = new long[1]);
            if (l2 == 0L) {
                return null;
            }
            int n2 = OS.g_list_length(l2);
            if (n2 == 0) {
                OS.g_list_free(l2);
                return null;
            }
            long l7 = OS.g_list_nth_data(l2, 0);
            object = new long[1];
            l = OS.g_malloc(OS.GtkTreeIter_sizeof());
            if (OS.gtk_tree_model_get_iter(lArray[0], l, l7)) {
                OS.gtk_tree_model_get(lArray[0], l, 0, object, -1L);
            }
            OS.g_free(l);
            int n3 = 0;
            while (n3 < n2) {
                OS.gtk_tree_path_free(OS.g_list_nth_data(l2, n3));
                ++n3;
            }
            OS.g_list_free(l2);
            if (object[0] == 0L) {
                return null;
            }
            n3 = OS.strlen(object[0]);
            byte[] byArray = new byte[n3];
            OS.memmove(byArray, object[0], (long)n3);
            OS.g_free(object[0]);
            OS.gtk_entry_set_text(l5, byArray);
        }
        l4 = OS.gtk_file_selection_get_filename(this.handle);
        l3 = OS.g_filename_to_utf8(l4, -1L, null, null, null);
        lArray = new long[1];
        l2 = OS.g_utf8_to_utf16(l3, -1L, null, lArray, null);
        n = (int)lArray[0];
        char[] cArray = new char[n];
        OS.memmove(cArray, l2, (long)(n * 2));
        String string = new String(cArray);
        OS.g_free(l2);
        OS.g_free(l3);
        int n4 = string.lastIndexOf(SEPARATOR);
        if (n4 + 1 == string.length()) {
            return null;
        }
        this.fullPath = string;
        object = this.fullPath;
        this.fileName = this.fullPath.substring(n4 + 1);
        this.filterPath = this.fullPath.substring(0, n4);
        if ((this.style & 2) == 0) {
            this.fileNames = new String[]{this.fileName};
        } else {
            long l8 = l = OS.gtk_file_selection_get_selections(this.handle);
            long[] lArray2 = new long[1];
            OS.memmove(lArray2, l8, (long)OS.PTR_SIZEOF);
            int n5 = 0;
            while (lArray2[0] != 0L) {
                ++n5;
                OS.memmove(lArray2, l8 += (long)OS.PTR_SIZEOF, (long)OS.PTR_SIZEOF);
            }
            this.fileNames = new String[n5];
            lArray2 = new long[n5];
            OS.memmove(lArray2, l, (long)(n5 * OS.PTR_SIZEOF));
            int n6 = 0;
            while (n6 < n5) {
                l3 = OS.g_filename_to_utf8(lArray2[n6], -1L, null, null, null);
                lArray = new long[1];
                l2 = OS.g_utf8_to_utf16(l3, -1L, null, lArray, null);
                cArray = new char[(int)lArray[0]];
                OS.memmove(cArray, l2, lArray[0] * 2L);
                String string2 = new String(cArray);
                this.fileNames[n6] = string2.substring(string2.lastIndexOf(SEPARATOR) + 1);
                OS.g_free(l2);
                OS.g_free(l3);
                ++n6;
            }
            OS.g_strfreev(l);
        }
        return object;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public String open() {
        boolean bl;
        boolean bl2 = bl = OS.GTK_VERSION >= OS.VERSION(2, 4, 10);
        if (bl) {
            return this.openChooserDialog();
        }
        return this.openClassicDialog();
    }

    String openChooserDialog() {
        long l;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        int n = (this.style & 0x2000) != 0 ? 1 : 0;
        long l2 = this.parent.topHandle();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        this.handle = display.getDismissalAlignment() == 131072 ? OS.gtk_file_chooser_dialog_new(byArray, l2, n, OS.GTK_STOCK_CANCEL(), -6, OS.GTK_STOCK_OK(), -5, 0L) : OS.gtk_file_chooser_dialog_new(byArray, l2, n, OS.GTK_STOCK_OK(), -5, OS.GTK_STOCK_CANCEL(), -6, 0L);
        OS.gtk_window_set_modal(this.handle, true);
        if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
            l = OS.gtk_window_get_group(0L);
            OS.gtk_window_group_add_window(l, this.handle);
        }
        if ((l = OS.gtk_window_get_icon_list(l2)) != 0L) {
            OS.gtk_window_set_icon_list(this.handle, l);
            OS.g_list_free(l);
        }
        if (this.uriMode) {
            OS.gtk_file_chooser_set_local_only(this.handle, false);
        }
        this.presetChooserDialog();
        display.addIdleProc();
        String string = null;
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(this.handle)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n2 = 0;
        long l3 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n2 = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            l3 = OS.g_signal_add_emission_hook(n2, 0, display.emissionProc, this.handle, 0L);
        }
        int n3 = OS.gtk_dialog_run(this.handle);
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n2, l3);
        }
        if (OS.gtk_window_get_modal(this.handle)) {
            display.setModalDialog(dialog);
        }
        if (n3 == -5) {
            string = this.computeResultChooserDialog();
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(this.handle);
        return string;
    }

    String openClassicDialog() {
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        this.handle = OS.gtk_file_selection_new(byArray);
        if (this.parent != null) {
            long l = this.parent.topHandle();
            OS.gtk_window_set_transient_for(this.handle, l);
            long l2 = OS.gtk_window_get_icon_list(l);
            if (l2 != 0L) {
                OS.gtk_window_set_icon_list(this.handle, l2);
                OS.g_list_free(l2);
            }
        }
        OS.gtk_window_set_modal(this.handle, true);
        this.presetClassicDialog();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.addIdleProc();
        String string = null;
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(this.handle)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n = 0;
        long l = 0L;
        if ((this.style & 0x4000000) != 0) {
            n = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            l = OS.g_signal_add_emission_hook(n, 0, display.emissionProc, this.handle, 0L);
        }
        int n2 = OS.gtk_dialog_run(this.handle);
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n, l);
        }
        if (OS.gtk_window_get_modal(this.handle)) {
            display.setModalDialog(dialog);
        }
        if (n2 == -5) {
            string = this.computeResultClassicDialog();
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(this.handle);
        return string;
    }

    void presetChooserDialog() {
        Object object;
        if ((this.style & 0x2002) == 2) {
            OS.gtk_file_chooser_set_select_multiple(this.handle, true);
        }
        if (this.filterPath == null) {
            this.filterPath = "";
        }
        if (this.fileName == null) {
            this.fileName = "";
        }
        if ((this.style & 0x2000) != 0) {
            if (this.filterPath.length() > 0) {
                if (this.uriMode) {
                    object = Converter.wcsToMbcs(null, this.filterPath, true);
                    OS.gtk_file_chooser_set_current_folder_uri(this.handle, (byte[])object);
                } else {
                    object = Converter.wcsToMbcs(null, String.valueOf(SEPARATOR) + this.filterPath, true);
                    long l = OS.realpath((byte[])object, null);
                    OS.gtk_file_chooser_set_current_folder(this.handle, l);
                    OS.g_free(l);
                }
            }
            if (this.fileName.length() > 0) {
                object = Converter.wcsToMbcs(null, this.fileName, true);
                OS.gtk_file_chooser_set_current_name(this.handle, (byte[])object);
            }
        } else {
            object = new StringBuffer();
            if (this.filterPath.length() > 0) {
                if (!this.uriMode) {
                    ((StringBuffer)object).append(SEPARATOR);
                }
                ((StringBuffer)object).append(this.filterPath);
                ((StringBuffer)object).append(SEPARATOR);
            }
            if (this.fileName.length() > 0) {
                ((StringBuffer)object).append(this.fileName);
            }
            byte[] byArray = Converter.wcsToMbcs(null, ((StringBuffer)object).toString(), true);
            if (this.uriMode) {
                OS.gtk_file_chooser_set_uri(this.handle, byArray);
            } else {
                long l = OS.realpath(byArray, null);
                if (l != 0L) {
                    if (this.fileName.length() > 0) {
                        OS.gtk_file_chooser_set_filename(this.handle, l);
                    } else {
                        OS.gtk_file_chooser_set_current_folder(this.handle, l);
                    }
                    OS.g_free(l);
                }
            }
        }
        if ((this.style & 0x2000) != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
            OS.gtk_file_chooser_set_do_overwrite_confirmation(this.handle, this.overwrite);
        }
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        long l = 0L;
        int n = 0;
        while (n < this.filterExtensions.length) {
            if (this.filterExtensions[n] != null) {
                byte[] byArray;
                String string;
                byte[] byArray2;
                long l2 = OS.gtk_file_filter_new();
                if (this.filterNames.length > n && this.filterNames[n] != null) {
                    byArray2 = Converter.wcsToMbcs(null, this.filterNames[n], true);
                    OS.gtk_file_filter_set_name(l2, byArray2);
                } else {
                    byArray2 = Converter.wcsToMbcs(null, this.filterExtensions[n], true);
                    OS.gtk_file_filter_set_name(l2, byArray2);
                }
                int n2 = 0;
                int n3 = this.filterExtensions[n].indexOf(59);
                while (n3 != -1) {
                    string = this.filterExtensions[n].substring(n2, n3);
                    byArray = Converter.wcsToMbcs(null, string, true);
                    OS.gtk_file_filter_add_pattern(l2, byArray);
                    n2 = n3 + 1;
                    n3 = this.filterExtensions[n].indexOf(59, n2);
                }
                string = this.filterExtensions[n].substring(n2);
                byArray = Converter.wcsToMbcs(null, string, true);
                OS.gtk_file_filter_add_pattern(l2, byArray);
                OS.gtk_file_chooser_add_filter(this.handle, l2);
                if (n == this.filterIndex) {
                    l = l2;
                }
            }
            ++n;
        }
        if (l != 0L) {
            OS.gtk_file_chooser_set_filter(this.handle, l);
        }
        this.fullPath = null;
        this.fileNames = new String[0];
    }

    void presetClassicDialog() {
        OS.gtk_file_selection_set_select_multiple(this.handle, (this.style & 2) != 0);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.filterPath == null) {
            this.filterPath = "";
        } else if (this.filterPath.length() > 0) {
            stringBuffer.append(this.filterPath);
            if (this.filterPath.charAt(this.filterPath.length() - 1) != SEPARATOR) {
                stringBuffer.append(SEPARATOR);
            }
        }
        if (this.fileName == null) {
            this.fileName = "";
        } else {
            stringBuffer.append(this.fileName);
        }
        this.fullPath = stringBuffer.toString();
        int n = this.fullPath.length();
        char[] cArray = new char[n + 1];
        this.fullPath.getChars(0, n, cArray, 0);
        long l = OS.g_utf16_to_utf8(cArray, -1L, null, null, null);
        long l2 = OS.g_filename_from_utf8(l, -1L, null, null, null);
        OS.gtk_file_selection_set_filename(this.handle, l2);
        OS.g_free(l);
        OS.g_free(l2);
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        this.fullPath = null;
        this.fileNames = new String[0];
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] stringArray) {
        this.filterExtensions = stringArray;
    }

    public void setFilterIndex(int n) {
        this.filterIndex = n;
    }

    public void setFilterNames(String[] stringArray) {
        this.filterNames = stringArray;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    void setURIMode(boolean bl) {
        this.uriMode = bl;
    }
}

