/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleActionEvent;
import org.eclipse.swt.accessibility.AccessibleActionListener;
import org.eclipse.swt.accessibility.AccessibleAttributeListener;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleFactory;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTableCellEvent;
import org.eclipse.swt.accessibility.AccessibleTableCellListener;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.accessibility.AccessibleTextAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextExtendedEvent;
import org.eclipse.swt.accessibility.AccessibleTextExtendedListener;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.accessibility.AccessibleValueEvent;
import org.eclipse.swt.accessibility.AccessibleValueListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.SWTEventObject;
import org.eclipse.swt.internal.accessibility.gtk.ATK;
import org.eclipse.swt.internal.accessibility.gtk.AtkActionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkAttribute;
import org.eclipse.swt.internal.accessibility.gtk.AtkComponentIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkHypertextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkSelectionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTableIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextRange;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextRectangle;
import org.eclipse.swt.internal.accessibility.gtk.AtkValueIface;
import org.eclipse.swt.internal.accessibility.gtk.GtkAccessible;
import org.eclipse.swt.internal.gtk.GObjectClass;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;

class AccessibleObject {
    int handle;
    int index = -1;
    int id = -1;
    Accessible accessible;
    AccessibleObject parent;
    AccessibleObject[] children;
    boolean isLightweight = false;
    static int actionNamePtr = -1;
    static int descriptionPtr = -1;
    static int keybindingPtr = -1;
    static int namePtr = -1;
    static final Hashtable AccessibleObjects = new Hashtable(9);
    static final boolean DEBUG = Device.DEBUG;

    AccessibleObject(int type, int widget, Accessible accessible, boolean isLightweight) {
        this.handle = ATK.g_object_new(type, 0);
        ATK.atk_object_initialize(this.handle, widget);
        this.accessible = accessible;
        this.isLightweight = isLightweight;
        AccessibleObjects.put(new LONG(this.handle), this);
        if (DEBUG) {
            AccessibleObject.print("new AccessibleObject: " + this.handle + " control=" + accessible.control + " lw=" + isLightweight);
        }
    }

    static void print(String str) {
        System.out.println(str);
    }

    static AtkActionIface getActionIface(int atkObject) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(atkObject)), ATK.ATK_TYPE_ACTION())) {
            AtkActionIface iface = new AtkActionIface();
            ATK.memmove(iface, ATK.g_type_interface_peek_parent(ATK.ATK_ACTION_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static int atkAction_do_action(int atkObject, int index) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_do_action");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleActionListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleActionEvent event = new AccessibleActionEvent(accessible);
                event.index = index;
                int i = 0;
                while (i < length) {
                    AccessibleActionListener listener = (AccessibleActionListener)listeners.elementAt(i);
                    listener.doAction(event);
                    ++i;
                }
                return 0;
            }
        }
        int parentResult = 0;
        AtkActionIface iface = AccessibleObject.getActionIface(atkObject);
        if (iface != null && iface.do_action != 0) {
            parentResult = ATK.call(iface.do_action, atkObject, index);
        }
        return parentResult;
    }

    static int atkAction_get_n_actions(int atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_get_n_actions");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleActionListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleActionEvent event = new AccessibleActionEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleActionListener listener = (AccessibleActionListener)listeners.elementAt(i);
                    listener.getActionCount(event);
                    ++i;
                }
                return event.count;
            }
        }
        int parentResult = 0;
        AtkActionIface iface = AccessibleObject.getActionIface(atkObject);
        if (iface != null && iface.get_n_actions != 0) {
            parentResult = ATK.call(iface.get_n_actions, atkObject);
        }
        return parentResult;
    }

    static int atkAction_get_description(int atkObject, int index) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_get_description");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleActionListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleActionEvent event = new AccessibleActionEvent(accessible);
                event.index = index;
                int i = 0;
                while (i < length) {
                    AccessibleActionListener listener = (AccessibleActionListener)listeners.elementAt(i);
                    listener.getDescription(event);
                    ++i;
                }
                if (event.result == null) {
                    return 0;
                }
                if (descriptionPtr != -1) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(event.result);
                return descriptionPtr;
            }
        }
        int parentResult = 0;
        AtkActionIface iface = AccessibleObject.getActionIface(atkObject);
        if (iface != null && iface.get_description != 0) {
            parentResult = ATK.call(iface.get_description, atkObject, index);
        }
        return parentResult;
    }

    static int atkAction_get_keybinding(int atkObject, int index) {
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_get_keybinding");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkActionIface iface = AccessibleObject.getActionIface(atkObject);
        if (iface != null && iface.get_keybinding != 0) {
            parentResult = ATK.call(iface.get_keybinding, atkObject, index);
        }
        if (object != null) {
            SWTEventListener listener;
            int i;
            SWTEventObject event;
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleActionListeners;
            int length = listeners.size();
            if (length > 0) {
                event = new AccessibleActionEvent(accessible);
                event.index = index;
                i = 0;
                while (i < length) {
                    listener = (AccessibleActionListener)listeners.elementAt(i);
                    listener.getKeyBinding((AccessibleActionEvent)event);
                    ++i;
                }
                if (event.result != null) {
                    if (keybindingPtr != -1) {
                        OS.g_free(keybindingPtr);
                    }
                    keybindingPtr = AccessibleObject.getStringPtr(event.result);
                    return keybindingPtr;
                }
            }
            if ((length = (listeners = accessible.accessibleListeners).size()) > 0) {
                event = new AccessibleEvent(accessible);
                ((AccessibleEvent)event).childID = object.id;
                if (parentResult != 0) {
                    ((AccessibleEvent)event).result = AccessibleObject.getString(parentResult);
                }
                i = 0;
                while (i < length) {
                    listener = (AccessibleListener)listeners.elementAt(i);
                    listener.getKeyboardShortcut((AccessibleEvent)event);
                    ++i;
                }
                if (((AccessibleEvent)event).result != null) {
                    if (keybindingPtr != -1) {
                        OS.g_free(keybindingPtr);
                    }
                    keybindingPtr = AccessibleObject.getStringPtr(((AccessibleEvent)event).result);
                    return keybindingPtr;
                }
            }
        }
        return parentResult;
    }

    static int atkAction_get_name(int atkObject, int index) {
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_get_name");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkActionIface iface = AccessibleObject.getActionIface(atkObject);
        if (iface != null && iface.get_name != 0) {
            parentResult = ATK.call(iface.get_name, atkObject, index);
        }
        if (object != null) {
            SWTEventListener listener;
            int i;
            SWTEventObject event;
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleActionListeners;
            int length = listeners.size();
            if (length > 0) {
                event = new AccessibleActionEvent(accessible);
                event.index = index;
                i = 0;
                while (i < length) {
                    listener = (AccessibleActionListener)listeners.elementAt(i);
                    listener.getName((AccessibleActionEvent)event);
                    ++i;
                }
                if (event.result != null) {
                    if (actionNamePtr != -1) {
                        OS.g_free(actionNamePtr);
                    }
                    actionNamePtr = AccessibleObject.getStringPtr(event.result);
                    return actionNamePtr;
                }
            }
            if (index == 0 && (length = (listeners = accessible.accessibleControlListeners).size()) > 0) {
                event = new AccessibleControlEvent(accessible);
                ((AccessibleControlEvent)event).childID = object.id;
                if (parentResult != 0) {
                    ((AccessibleControlEvent)event).result = AccessibleObject.getString(parentResult);
                }
                i = 0;
                while (i < length) {
                    listener = (AccessibleControlListener)listeners.elementAt(i);
                    listener.getDefaultAction((AccessibleControlEvent)event);
                    ++i;
                }
                if (((AccessibleControlEvent)event).result != null) {
                    if (actionNamePtr != -1) {
                        OS.g_free(actionNamePtr);
                    }
                    actionNamePtr = AccessibleObject.getStringPtr(((AccessibleControlEvent)event).result);
                    return actionNamePtr;
                }
            }
        }
        return parentResult;
    }

    static AtkComponentIface getComponentIface(int atkObject) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(atkObject)), ATK.ATK_TYPE_COMPONENT())) {
            AtkComponentIface iface = new AtkComponentIface();
            ATK.memmove(iface, ATK.g_type_interface_peek_parent(ATK.ATK_COMPONENT_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static int atkComponent_get_extents(int atkObject, int x, int y, int width, int height, int coord_type) {
        if (DEBUG) {
            AccessibleObject.print("-->atkComponent_get_extents");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        OS.memmove(x, new int[1], 4);
        OS.memmove(y, new int[1], 4);
        OS.memmove(width, new int[1], 4);
        OS.memmove(height, new int[1], 4);
        AtkComponentIface iface = AccessibleObject.getComponentIface(atkObject);
        if (iface != null && iface.get_extents != 0) {
            ATK.call(iface.get_extents, atkObject, x, y, width, height, coord_type);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleControlListeners;
            int length = listeners.size();
            if (length > 0) {
                int[] parentX = new int[1];
                int[] parentY = new int[1];
                int[] parentWidth = new int[1];
                int[] parentHeight = new int[1];
                OS.memmove(parentX, x, 4);
                OS.memmove(parentY, y, 4);
                OS.memmove(parentWidth, width, 4);
                OS.memmove(parentHeight, height, 4);
                AccessibleControlEvent event = new AccessibleControlEvent(object.accessible);
                event.childID = object.id;
                event.x = parentX[0];
                event.y = parentY[0];
                event.width = parentWidth[0];
                event.height = parentHeight[0];
                int[] topWindowX = new int[1];
                int[] topWindowY = new int[1];
                if (coord_type == 1) {
                    AccessibleObject.windowPoint(object, topWindowX, topWindowY);
                    event.x += topWindowX[0];
                    event.y += topWindowY[0];
                }
                int i = 0;
                while (i < length) {
                    AccessibleControlListener listener = (AccessibleControlListener)listeners.elementAt(i);
                    listener.getLocation(event);
                    ++i;
                }
                if (coord_type == 1) {
                    event.x -= topWindowX[0];
                    event.y -= topWindowY[0];
                }
                OS.memmove(x, new int[]{event.x}, 4);
                OS.memmove(y, new int[]{event.y}, 4);
                OS.memmove(width, new int[]{event.width}, 4);
                OS.memmove(height, new int[]{event.height}, 4);
            }
        }
        return 0;
    }

    static int atkComponent_get_position(int atkObject, int x, int y, int coord_type) {
        if (DEBUG) {
            AccessibleObject.print("-->atkComponent_get_position, object: " + atkObject + " x: " + x + " y: " + y + " coord: " + coord_type);
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        OS.memmove(x, new int[1], 4);
        OS.memmove(y, new int[1], 4);
        AtkComponentIface iface = AccessibleObject.getComponentIface(atkObject);
        if (iface != null && iface.get_position != 0) {
            ATK.call(iface.get_position, atkObject, x, y, coord_type);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleControlListeners;
            int length = listeners.size();
            if (length > 0) {
                int[] parentX = new int[1];
                int[] parentY = new int[1];
                OS.memmove(parentX, x, 4);
                OS.memmove(parentY, y, 4);
                AccessibleControlEvent event = new AccessibleControlEvent(object.accessible);
                event.childID = object.id;
                event.x = parentX[0];
                event.y = parentY[0];
                int[] topWindowX = new int[1];
                int[] topWindowY = new int[1];
                if (coord_type == 1) {
                    AccessibleObject.windowPoint(object, topWindowX, topWindowY);
                    event.x += topWindowX[0];
                    event.y += topWindowY[0];
                }
                int i = 0;
                while (i < length) {
                    AccessibleControlListener listener = (AccessibleControlListener)listeners.elementAt(i);
                    listener.getLocation(event);
                    ++i;
                }
                if (coord_type == 1) {
                    event.x -= topWindowX[0];
                    event.y -= topWindowY[0];
                }
                OS.memmove(x, new int[]{event.x}, 4);
                OS.memmove(y, new int[]{event.y}, 4);
            }
        }
        return 0;
    }

    static int atkComponent_get_size(int atkObject, int width, int height, int coord_type) {
        if (DEBUG) {
            AccessibleObject.print("-->atkComponent_get_size");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        OS.memmove(width, new int[1], 4);
        OS.memmove(height, new int[1], 4);
        AtkComponentIface iface = AccessibleObject.getComponentIface(atkObject);
        if (iface != null && iface.get_size != 0) {
            ATK.call(iface.get_size, atkObject, width, height, coord_type);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleControlListeners;
            int length = listeners.size();
            if (length > 0) {
                int[] parentWidth = new int[1];
                int[] parentHeight = new int[1];
                OS.memmove(parentWidth, width, 4);
                OS.memmove(parentHeight, height, 4);
                AccessibleControlEvent event = new AccessibleControlEvent(object.accessible);
                event.childID = object.id;
                event.width = parentWidth[0];
                event.height = parentHeight[0];
                int i = 0;
                while (i < length) {
                    AccessibleControlListener listener = (AccessibleControlListener)listeners.elementAt(i);
                    listener.getLocation(event);
                    ++i;
                }
                OS.memmove(width, new int[]{event.width}, 4);
                OS.memmove(height, new int[]{event.height}, 4);
            }
        }
        return 0;
    }

    static int atkComponent_ref_accessible_at_point(int atkObject, int x, int y, int coord_type) {
        if (DEBUG) {
            AccessibleObject.print("-->atkComponent_ref_accessible_at_point");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkComponentIface iface = AccessibleObject.getComponentIface(atkObject);
        if (iface != null && iface.ref_accessible_at_point != 0) {
            parentResult = ATK.call(iface.ref_accessible_at_point, atkObject, x, y, coord_type);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleControlListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleObject accObj;
                AccessibleControlEvent event = new AccessibleControlEvent(object.accessible);
                event.childID = object.id;
                event.x = x;
                event.y = y;
                int[] topWindowX = new int[1];
                int[] topWindowY = new int[1];
                if (coord_type == 1) {
                    AccessibleObject.windowPoint(object, topWindowX, topWindowY);
                    event.x += topWindowX[0];
                    event.y += topWindowY[0];
                }
                int i = 0;
                while (i < length) {
                    AccessibleControlListener listener = (AccessibleControlListener)listeners.elementAt(i);
                    listener.getChildAtPoint(event);
                    ++i;
                }
                if (event.childID == object.id) {
                    event.childID = -1;
                }
                if ((accObj = object.getChildByID(event.childID)) != null) {
                    if (parentResult != 0) {
                        OS.g_object_unref(parentResult);
                    }
                    return OS.g_object_ref(accObj.handle);
                }
            }
        }
        return parentResult;
    }

    static AtkHypertextIface getHypertextIface(int atkObject) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(atkObject)), ATK.ATK_TYPE_HYPERTEXT())) {
            AtkHypertextIface iface = new AtkHypertextIface();
            ATK.memmove(iface, ATK.g_type_interface_peek_parent(ATK.ATK_HYPERTEXT_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static int atkHypertext_get_link(int atkObject, int link_index) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkHypertext_get_link");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTextExtendedListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTextExtendedEvent event = new AccessibleTextExtendedEvent(accessible);
                event.index = link_index;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = (AccessibleTextExtendedListener)listeners.elementAt(i);
                    listener.getHyperlink(event);
                    ++i;
                }
                Accessible result = event.accessible;
                return result != null ? result.getAccessibleObject().handle : 0;
            }
        }
        int parentResult = 0;
        AtkHypertextIface iface = AccessibleObject.getHypertextIface(atkObject);
        if (iface != null && iface.get_link != 0) {
            parentResult = ATK.call(iface.get_link, atkObject, link_index);
        }
        return parentResult;
    }

    static int atkHypertext_get_n_links(int atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkHypertext_get_n_links");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTextExtendedListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTextExtendedEvent event = new AccessibleTextExtendedEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = (AccessibleTextExtendedListener)listeners.elementAt(i);
                    listener.getHyperlinkCount(event);
                    ++i;
                }
                return event.count;
            }
        }
        int parentResult = 0;
        AtkHypertextIface iface = AccessibleObject.getHypertextIface(atkObject);
        if (iface != null && iface.get_n_links != 0) {
            parentResult = ATK.call(iface.get_n_links, atkObject);
        }
        return parentResult;
    }

    static int atkHypertext_get_link_index(int atkObject, int char_index) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkHypertext_get_link_index");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTextExtendedListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTextExtendedEvent event = new AccessibleTextExtendedEvent(accessible);
                event.offset = char_index;
                event.index = -1;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = (AccessibleTextExtendedListener)listeners.elementAt(i);
                    listener.getHyperlinkIndex(event);
                    ++i;
                }
                return event.index;
            }
        }
        int parentResult = 0;
        AtkHypertextIface iface = AccessibleObject.getHypertextIface(atkObject);
        if (iface != null && iface.get_link != 0) {
            parentResult = ATK.call(iface.get_link, atkObject, char_index);
        }
        return parentResult;
    }

    static AtkObjectClass getObjectClass(int atkObject) {
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove(objectClass, ATK.g_type_class_peek(OS.g_type_parent(OS.G_OBJECT_TYPE(atkObject))));
        return objectClass;
    }

    static int atkObject_get_description(int atkObject) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_description");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkObjectClass objectClass = AccessibleObject.getObjectClass(atkObject);
        if (objectClass.get_description != 0) {
            parentResult = ATK.call(objectClass.get_description, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleEvent event = new AccessibleEvent(object.accessible);
                event.childID = object.id;
                if (parentResult != 0) {
                    event.result = AccessibleObject.getString(parentResult);
                }
                int i = 0;
                while (i < length) {
                    AccessibleListener listener = (AccessibleListener)listeners.elementAt(i);
                    listener.getDescription(event);
                    ++i;
                }
                if (event.result == null) {
                    return parentResult;
                }
                if (descriptionPtr != -1) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(event.result);
                return descriptionPtr;
            }
        }
        return parentResult;
    }

    static int atkObject_get_name(int atkObject) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_name: " + atkObject);
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkObjectClass objectClass = AccessibleObject.getObjectClass(atkObject);
        if (objectClass.get_name != 0) {
            parentResult = ATK.call(objectClass.get_name, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleEvent event = new AccessibleEvent(object.accessible);
                event.childID = object.id;
                if (parentResult != 0) {
                    event.result = AccessibleObject.getString(parentResult);
                }
                int i = 0;
                while (i < length) {
                    AccessibleListener listener = (AccessibleListener)listeners.elementAt(i);
                    listener.getName(event);
                    ++i;
                }
                if (event.result == null) {
                    return parentResult;
                }
                if (namePtr != -1) {
                    OS.g_free(namePtr);
                }
                namePtr = AccessibleObject.getStringPtr(event.result);
                return namePtr;
            }
        }
        return parentResult;
    }

    static int atkObject_get_n_children(int atkObject) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_n_children: " + atkObject);
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkObjectClass objectClass = AccessibleObject.getObjectClass(atkObject);
        if (objectClass.get_n_children != 0) {
            parentResult = ATK.call(objectClass.get_n_children, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleControlListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleControlEvent event = new AccessibleControlEvent(object.accessible);
                event.childID = object.id;
                event.detail = parentResult;
                int i = 0;
                while (i < length) {
                    AccessibleControlListener listener = (AccessibleControlListener)listeners.elementAt(i);
                    listener.getChildCount(event);
                    ++i;
                }
                return event.detail;
            }
        }
        return parentResult;
    }

    static int atkObject_get_index_in_parent(int atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkObjectCB_get_index_in_parent.  ");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null && object.index != -1) {
            return object.index;
        }
        AtkObjectClass objectClass = AccessibleObject.getObjectClass(atkObject);
        if (objectClass.get_index_in_parent == 0) {
            return 0;
        }
        return ATK.call(objectClass.get_index_in_parent, atkObject);
    }

    static int atkObject_get_parent(int atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_parent: " + atkObject);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null && object.parent != null) {
            return object.parent.handle;
        }
        AtkObjectClass objectClass = AccessibleObject.getObjectClass(atkObject);
        if (objectClass.get_parent == 0) {
            return 0;
        }
        return ATK.call(objectClass.get_parent, atkObject);
    }

    static int atkObject_get_role(int atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_role: " + atkObject);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleControlListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleControlEvent event = new AccessibleControlEvent(object.accessible);
                event.childID = object.id;
                event.detail = -1;
                int i = 0;
                while (i < length) {
                    AccessibleControlListener listener = (AccessibleControlListener)listeners.elementAt(i);
                    listener.getRole(event);
                    ++i;
                }
                if (event.detail != -1) {
                    switch (event.detail) {
                        case 44: {
                            return 7;
                        }
                        case 10: {
                            return 18;
                        }
                        case 46: {
                            return 11;
                        }
                        case 18: {
                            return 16;
                        }
                        case 41: {
                            return 28;
                        }
                        case 30: {
                            return 60;
                        }
                        case 33: {
                            return 30;
                        }
                        case 34: {
                            return 31;
                        }
                        case 11: {
                            return 32;
                        }
                        case 2: {
                            return 33;
                        }
                        case 12: {
                            return 34;
                        }
                        case 48: {
                            return 41;
                        }
                        case 43: {
                            return 42;
                        }
                        case 3: {
                            return 47;
                        }
                        case 21: {
                            return 49;
                        }
                        case 51: {
                            return 50;
                        }
                        case 24: {
                            return 54;
                        }
                        case 29: {
                            return 55;
                        }
                        case 25: {
                            return 56;
                        }
                        case 26: {
                            return 57;
                        }
                        case 60: {
                            return 37;
                        }
                        case 37: {
                            return 36;
                        }
                        case 42: {
                            return 60;
                        }
                        case 22: {
                            return 62;
                        }
                        case 13: {
                            return 63;
                        }
                        case 35: {
                            return 64;
                        }
                        case 36: {
                            return 31;
                        }
                        case 45: {
                            return 43;
                        }
                        case 62: {
                            return 42;
                        }
                        case 9: {
                            return 68;
                        }
                    }
                }
            }
        }
        AtkObjectClass objectClass = AccessibleObject.getObjectClass(atkObject);
        if (objectClass.get_role == 0) {
            return 0;
        }
        return ATK.call(objectClass.get_role, atkObject);
    }

    static int atkObject_ref_child(int atkObject, int index) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_ref_child: " + index + " of: " + atkObject);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            object.updateChildren();
            AccessibleObject accObject = object.getChildByIndex(index);
            if (accObject != null) {
                return OS.g_object_ref(accObject.handle);
            }
        }
        AtkObjectClass objectClass = AccessibleObject.getObjectClass(atkObject);
        if (objectClass.ref_child == 0) {
            return 0;
        }
        return ATK.call(objectClass.ref_child, atkObject, index);
    }

    static int atkObject_ref_state_set(int atkObject) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_ref_state_set");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkObjectClass objectClass = AccessibleObject.getObjectClass(atkObject);
        if (objectClass.ref_state_set != 0) {
            parentResult = ATK.call(objectClass.ref_state_set, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleControlListeners;
            int length = listeners.size();
            if (length > 0) {
                int set = parentResult;
                AccessibleControlEvent event = new AccessibleControlEvent(object.accessible);
                event.childID = object.id;
                event.detail = -1;
                int i = 0;
                while (i < length) {
                    AccessibleControlListener listener = (AccessibleControlListener)listeners.elementAt(i);
                    listener.getState(event);
                    ++i;
                }
                if (event.detail != -1) {
                    int state = event.detail;
                    if ((state & 0x800) != 0) {
                        ATK.atk_state_set_add_state(set, 3);
                    }
                    if ((state & 0x10) != 0) {
                        ATK.atk_state_set_add_state(set, 4);
                    }
                    if ((state & 1) != 0) {
                        ATK.atk_state_set_add_state(set, 7);
                    }
                    if ((state & 0x200) != 0) {
                        ATK.atk_state_set_add_state(set, 9);
                    }
                    if ((state & 0x100000) != 0) {
                        ATK.atk_state_set_add_state(set, 10);
                    }
                    if ((state & 4) != 0) {
                        ATK.atk_state_set_add_state(set, 11);
                    }
                    if ((state & 0x80) != 0) {
                        ATK.atk_state_set_add_state(set, 2);
                    }
                    if ((state & 0x8000) == 0) {
                        ATK.atk_state_set_add_state(set, 28);
                    }
                    if ((state & 0x1000000) != 0) {
                        ATK.atk_state_set_add_state(set, 16);
                    }
                    if ((state & 0x10000) == 0) {
                        ATK.atk_state_set_add_state(set, 23);
                    }
                    if ((state & 8) != 0) {
                        ATK.atk_state_set_add_state(set, 18);
                    }
                    if ((state & 0x40) == 0) {
                        ATK.atk_state_set_add_state(set, 6);
                    }
                    if ((state & 0x200000) != 0) {
                        ATK.atk_state_set_add_state(set, 20);
                    }
                    if ((state & 2) != 0) {
                        ATK.atk_state_set_add_state(set, 21);
                    }
                    if ((state & 0x20000) != 0) {
                        ATK.atk_state_set_add_state(set, 19);
                    }
                }
                return set;
            }
        }
        return parentResult;
    }

    static AtkSelectionIface getSelectionIface(int atkObject) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(atkObject)), ATK.ATK_TYPE_SELECTION())) {
            AtkSelectionIface iface = new AtkSelectionIface();
            ATK.memmove(iface, ATK.g_type_interface_peek_parent(ATK.ATK_SELECTION_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static int atkSelection_is_child_selected(int atkObject, int index) {
        if (DEBUG) {
            AccessibleObject.print("-->atkSelection_is_child_selected");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkSelectionIface iface = AccessibleObject.getSelectionIface(atkObject);
        if (iface != null && iface.is_child_selected != 0) {
            parentResult = ATK.call(iface.is_child_selected, atkObject, index);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleControlListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleControlEvent event = new AccessibleControlEvent(object.accessible);
                event.childID = object.id;
                int i = 0;
                while (i < length) {
                    AccessibleControlListener listener = (AccessibleControlListener)listeners.elementAt(i);
                    listener.getSelection(event);
                    ++i;
                }
                AccessibleObject accessibleObject = object.getChildByID(event.childID);
                if (accessibleObject != null) {
                    return accessibleObject.index == index ? 1 : 0;
                }
            }
        }
        return parentResult;
    }

    static int atkSelection_ref_selection(int atkObject, int index) {
        if (DEBUG) {
            AccessibleObject.print("-->atkSelection_ref_selection");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkSelectionIface iface = AccessibleObject.getSelectionIface(atkObject);
        if (iface != null && iface.ref_selection != 0) {
            parentResult = ATK.call(iface.ref_selection, atkObject, index);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleControlListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleControlEvent event = new AccessibleControlEvent(object.accessible);
                event.childID = object.id;
                int i = 0;
                while (i < length) {
                    AccessibleControlListener listener = (AccessibleControlListener)listeners.elementAt(i);
                    listener.getSelection(event);
                    ++i;
                }
                AccessibleObject accObj = object.getChildByID(event.childID);
                if (accObj != null) {
                    if (parentResult != 0) {
                        OS.g_object_unref(parentResult);
                    }
                    OS.g_object_ref(accObj.handle);
                    return accObj.handle;
                }
            }
        }
        return parentResult;
    }

    static AtkTableIface getTableIface(int atkObject) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(atkObject)), ATK.ATK_TYPE_TABLE())) {
            AtkTableIface iface = new AtkTableIface();
            ATK.memmove(iface, ATK.g_type_interface_peek_parent(ATK.ATK_TABLE_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static int atkTable_ref_at(int atkObject, int row, int column) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_ref_at");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.ref_at != 0) {
            parentResult = ATK.call(iface.ref_at, atkObject, row, column);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            AccessibleTableEvent event = new AccessibleTableEvent(accessible);
            event.row = row;
            event.column = column;
            int i = 0;
            int length = listeners.size();
            while (i < length) {
                AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                listener.getCell(event);
                ++i;
            }
            Accessible result = event.accessible;
            if (result != null) {
                if (parentResult != 0) {
                    OS.g_object_unref(parentResult);
                }
                AccessibleObject accessibleObject = result.getAccessibleObject();
                OS.g_object_ref(accessibleObject.handle);
                return accessibleObject.handle;
            }
        }
        return parentResult;
    }

    static int atkTable_get_index_at(int atkObject, int row, int column) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_index_at");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            AccessibleTableEvent event = new AccessibleTableEvent(accessible);
            event.row = row;
            event.column = column;
            int i = 0;
            int length = listeners.size();
            while (i < length) {
                AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                listener.getCell(event);
                ++i;
            }
            Accessible result = event.accessible;
            if (result == null) {
                return -1;
            }
            event = new AccessibleTableEvent(accessible);
            int i2 = 0;
            int length2 = listeners.size();
            while (i2 < length2) {
                AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i2);
                listener.getColumnCount(event);
                ++i2;
            }
            return row * event.count + column;
        }
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_index_at != 0) {
            parentResult = ATK.call(iface.get_index_at, atkObject, row, column);
        }
        return parentResult;
    }

    static int atkTable_get_column_at_index(int atkObject, int index) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_column_at_index");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            AccessibleTableEvent event = new AccessibleTableEvent(accessible);
            int i = 0;
            int length = listeners.size();
            while (i < length) {
                AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                listener.getColumnCount(event);
                ++i;
            }
            return index % event.count;
        }
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_column_at_index != 0) {
            parentResult = ATK.call(iface.get_column_at_index, atkObject, index);
        }
        return parentResult;
    }

    static int atkTable_get_row_at_index(int atkObject, int index) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_row_at_index");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            AccessibleTableEvent event = new AccessibleTableEvent(accessible);
            int i = 0;
            int length = listeners.size();
            while (i < length) {
                AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                listener.getColumnCount(event);
                ++i;
            }
            return index / event.count;
        }
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_row_at_index != 0) {
            parentResult = ATK.call(iface.get_row_at_index, atkObject, index);
        }
        return parentResult;
    }

    static int atkTable_get_n_columns(int atkObject) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_n_columns");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_n_columns != 0) {
            parentResult = ATK.call(iface.get_n_columns, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            AccessibleTableEvent event = new AccessibleTableEvent(accessible);
            event.count = parentResult;
            int i = 0;
            int length = listeners.size();
            while (i < length) {
                AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                listener.getColumnCount(event);
                parentResult = event.count;
                ++i;
            }
        }
        return parentResult;
    }

    static int atkTable_get_n_rows(int atkObject) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_n_rows");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_n_rows != 0) {
            parentResult = ATK.call(iface.get_n_rows, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            AccessibleTableEvent event = new AccessibleTableEvent(accessible);
            event.count = parentResult;
            int i = 0;
            int length = listeners.size();
            while (i < length) {
                AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                listener.getRowCount(event);
                parentResult = event.count;
                ++i;
            }
        }
        return parentResult;
    }

    static int atkTable_get_column_extent_at(int atkObject, int row, int column) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_column_extent_at");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_column_extent_at != 0) {
            parentResult = ATK.call(iface.get_column_extent_at, atkObject, row, column);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            AccessibleTableEvent event = new AccessibleTableEvent(accessible);
            event.row = row;
            event.column = column;
            int i = 0;
            int length = listeners.size();
            while (i < length) {
                AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                listener.getCell(event);
                ++i;
            }
            Accessible result = event.accessible;
            if (result != null) {
                listeners = result.accessibleTableCellListeners;
                AccessibleTableCellEvent cellEvent = new AccessibleTableCellEvent(result);
                cellEvent.count = parentResult;
                int i2 = 0;
                int length2 = listeners.size();
                while (i2 < length2) {
                    AccessibleTableCellListener listener = (AccessibleTableCellListener)listeners.elementAt(i2);
                    listener.getColumnSpan(cellEvent);
                    ++i2;
                }
                return cellEvent.count;
            }
        }
        return parentResult;
    }

    static int atkTable_get_row_extent_at(int atkObject, int row, int column) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_row_extent_at");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_row_extent_at != 0) {
            parentResult = ATK.call(iface.get_row_extent_at, atkObject, row, column);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            AccessibleTableEvent event = new AccessibleTableEvent(accessible);
            event.row = row;
            event.column = column;
            int i = 0;
            int length = listeners.size();
            while (i < length) {
                AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                listener.getCell(event);
                ++i;
            }
            Accessible result = event.accessible;
            if (result != null) {
                listeners = result.accessibleTableCellListeners;
                AccessibleTableCellEvent cellEvent = new AccessibleTableCellEvent(result);
                cellEvent.count = parentResult;
                int i2 = 0;
                int length2 = listeners.size();
                while (i2 < length2) {
                    AccessibleTableCellListener listener = (AccessibleTableCellListener)listeners.elementAt(i2);
                    listener.getRowSpan(cellEvent);
                    ++i2;
                }
                return cellEvent.count;
            }
        }
        return parentResult;
    }

    static int atkTable_get_caption(int atkObject) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_caption");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_caption != 0) {
            parentResult = ATK.call(iface.get_caption, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                    listener.getCaption(event);
                    ++i;
                }
                Accessible result = event.accessible;
                if (result != null) {
                    return result.getAccessibleObject().handle;
                }
            }
        }
        return parentResult;
    }

    static int atkTable_get_summary(int atkObject) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_summary");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_summary != 0) {
            parentResult = ATK.call(iface.get_summary, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                    listener.getSummary(event);
                    ++i;
                }
                Accessible result = event.accessible;
                if (result != null) {
                    return result.getAccessibleObject().handle;
                }
            }
        }
        return parentResult;
    }

    static int atkTable_get_column_description(int atkObject, int column) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_column_description");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_column_description != 0) {
            parentResult = ATK.call(iface.get_column_description, atkObject, column);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            AccessibleTableEvent event = new AccessibleTableEvent(accessible);
            event.column = column;
            if (parentResult != 0) {
                event.result = AccessibleObject.getString(parentResult);
            }
            int i = 0;
            int length = listeners.size();
            while (i < length) {
                AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                listener.getColumnDescription(event);
                ++i;
            }
            if (event.result == null) {
                return parentResult;
            }
            if (descriptionPtr != -1) {
                OS.g_free(descriptionPtr);
            }
            descriptionPtr = AccessibleObject.getStringPtr(event.result);
            return descriptionPtr;
        }
        return parentResult;
    }

    static int atkTable_get_column_header(int atkObject, int column) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_column_header");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_column_header != 0) {
            parentResult = ATK.call(iface.get_column_header, atkObject, column);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                    listener.getRowHeaders(event);
                    ++i;
                }
                Accessible[] accessibles = event.accessibles;
                if (accessibles != null && column >= 0 && column < accessibles.length) {
                    return accessibles[column].getAccessibleObject().handle;
                }
            }
        }
        return parentResult;
    }

    static int atkTable_get_row_description(int atkObject, int row) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_row_description");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_row_description != 0) {
            parentResult = ATK.call(iface.get_row_description, atkObject, row);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            AccessibleTableEvent event = new AccessibleTableEvent(accessible);
            event.row = row;
            if (parentResult != 0) {
                event.result = AccessibleObject.getString(parentResult);
            }
            int i = 0;
            int length = listeners.size();
            while (i < length) {
                AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                listener.getRowDescription(event);
                ++i;
            }
            if (event.result == null) {
                return parentResult;
            }
            if (descriptionPtr != -1) {
                OS.g_free(descriptionPtr);
            }
            descriptionPtr = AccessibleObject.getStringPtr(event.result);
            return descriptionPtr;
        }
        return parentResult;
    }

    static int atkTable_get_row_header(int atkObject, int row) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_row_header");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_row_header != 0) {
            parentResult = ATK.call(iface.get_row_header, atkObject, row);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                    listener.getRowHeaders(event);
                    ++i;
                }
                Accessible[] accessibles = event.accessibles;
                if (accessibles != null && row >= 0 && row < accessibles.length) {
                    return accessibles[row].getAccessibleObject().handle;
                }
            }
        }
        return parentResult;
    }

    static int atkTable_get_selected_columns(int atkObject, int selected) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_selected_columns");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                    listener.getSelectedColumns(event);
                    ++i;
                }
                int count = event.selected != null ? event.selected.length : 0;
                int result = OS.g_malloc(count * 4);
                if (event.selected != null) {
                    OS.memmove(result, event.selected, count * 4);
                }
                if (selected != 0) {
                    OS.memmove(selected, new int[]{result}, C.PTR_SIZEOF);
                }
                return count;
            }
        }
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_selected_columns != 0) {
            parentResult = ATK.call(iface.get_selected_columns, atkObject, selected);
        }
        return parentResult;
    }

    static int atkTable_get_selected_rows(int atkObject, int selected) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_selected_rows");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                    listener.getSelectedRows(event);
                    ++i;
                }
                int count = event.selected != null ? event.selected.length : 0;
                int result = OS.g_malloc(count * 4);
                if (event.selected != null) {
                    OS.memmove(result, event.selected, count * 4);
                }
                if (selected != 0) {
                    OS.memmove(selected, new int[]{result}, C.PTR_SIZEOF);
                }
                return count;
            }
        }
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.get_selected_rows != 0) {
            parentResult = ATK.call(iface.get_selected_rows, atkObject, selected);
        }
        return parentResult;
    }

    static int atkTable_is_column_selected(int atkObject, int column) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_is_column_selected");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.is_column_selected != 0) {
            parentResult = ATK.call(iface.is_column_selected, atkObject, column);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.isSelected = parentResult != 0;
                event.column = column;
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                    listener.isColumnSelected(event);
                    ++i;
                }
                return event.isSelected ? 1 : 0;
            }
        }
        return parentResult;
    }

    static int atkTable_is_row_selected(int atkObject, int row) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_is_row_selected");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.is_row_selected != 0) {
            parentResult = ATK.call(iface.is_row_selected, atkObject, row);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.isSelected = parentResult != 0;
                event.row = row;
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                    listener.isRowSelected(event);
                    ++i;
                }
                return event.isSelected ? 1 : 0;
            }
        }
        return parentResult;
    }

    static int atkTable_is_selected(int atkObject, int row, int column) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_is_selected");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.is_selected != 0) {
            parentResult = ATK.call(iface.is_selected, atkObject, row, column);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            AccessibleTableEvent event = new AccessibleTableEvent(accessible);
            event.row = row;
            event.column = column;
            int i = 0;
            int length = listeners.size();
            while (i < length) {
                AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                listener.getCell(event);
                ++i;
            }
            Accessible result = event.accessible;
            if (result != null) {
                listeners = result.accessibleTableCellListeners;
                AccessibleTableCellEvent cellEvent = new AccessibleTableCellEvent(result);
                cellEvent.isSelected = parentResult != 0;
                int i2 = 0;
                int length2 = listeners.size();
                while (i2 < length2) {
                    AccessibleTableCellListener listener = (AccessibleTableCellListener)listeners.elementAt(i2);
                    listener.isSelected(cellEvent);
                    ++i2;
                }
                return cellEvent.isSelected ? 1 : 0;
            }
        }
        return parentResult;
    }

    static int atkTable_add_row_selection(int atkObject, int row) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_add_row_selection");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.column = row;
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                    listener.selectRow(event);
                    ++i;
                }
                return 1;
            }
        }
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.add_row_selection != 0) {
            parentResult = ATK.call(iface.add_row_selection, atkObject, row);
        }
        return parentResult;
    }

    static int atkTable_remove_row_selection(int atkObject, int row) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_remove_row_selection");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.row = row;
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                    listener.deselectRow(event);
                    ++i;
                }
                return 1;
            }
        }
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.remove_row_selection != 0) {
            parentResult = ATK.call(iface.remove_row_selection, atkObject, row);
        }
        return parentResult;
    }

    static int atkTable_add_column_selection(int atkObject, int column) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_add_column_selection");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.column = column;
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                    listener.selectColumn(event);
                    ++i;
                }
                return 1;
            }
        }
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.add_column_selection != 0) {
            parentResult = ATK.call(iface.add_column_selection, atkObject, column);
        }
        return parentResult;
    }

    static int atkTable_remove_column_selection(int atkObject, int column) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_remove_column_selection");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTableListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.column = column;
                int i = 0;
                while (i < length) {
                    AccessibleTableListener listener = (AccessibleTableListener)listeners.elementAt(i);
                    listener.deselectColumn(event);
                    ++i;
                }
                return 1;
            }
        }
        int parentResult = 0;
        AtkTableIface iface = AccessibleObject.getTableIface(atkObject);
        if (iface != null && iface.remove_column_selection != 0) {
            parentResult = ATK.call(iface.remove_column_selection, atkObject, column);
        }
        return parentResult;
    }

    static AtkTextIface getTextIface(int atkObject) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(atkObject)), ATK.ATK_TYPE_TEXT())) {
            AtkTextIface iface = new AtkTextIface();
            ATK.memmove(iface, ATK.g_type_interface_peek_parent(ATK.ATK_TEXT_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static int atkText_get_character_extents(int atkObject, int offset, int x, int y, int width, int height, int coords) {
        AtkTextIface iface;
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_character_extents");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTextExtendedListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTextExtendedEvent event = new AccessibleTextExtendedEvent(accessible);
                event.start = offset;
                event.end = offset + 1;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = (AccessibleTextExtendedListener)listeners.elementAt(i);
                    listener.getTextBounds(event);
                    ++i;
                }
                int[] topWindowX = new int[1];
                int[] topWindowY = new int[1];
                if (coords == 1) {
                    AccessibleObject.windowPoint(object, topWindowX, topWindowY);
                    event.x -= topWindowX[0];
                    event.y -= topWindowY[0];
                }
                OS.memmove(x, new int[]{event.x}, 4);
                OS.memmove(y, new int[]{event.y}, 4);
                OS.memmove(width, new int[]{event.width}, 4);
                OS.memmove(height, new int[]{event.height}, 4);
                return 0;
            }
        }
        if ((iface = AccessibleObject.getTextIface(atkObject)) != null && iface.get_character_extents != 0) {
            ATK.call(iface.get_character_extents, atkObject, offset, x, y, width, height, coords);
        }
        return 0;
    }

    static String getString(int strPtr) {
        int length = OS.strlen(strPtr);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, strPtr, length);
        return new String(Converter.mbcsToWcs(null, buffer));
    }

    static int getStringPtr(String str) {
        byte[] buffer = Converter.wcsToMbcs(null, str != null ? str : "", true);
        int ptr = OS.g_malloc(buffer.length);
        OS.memmove(ptr, buffer, buffer.length);
        return ptr;
    }

    static int atkText_get_range_extents(int atkObject, int start_offset, int end_offset, int coord_type, int rect) {
        AtkTextIface iface;
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_range_extents");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTextExtendedListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTextExtendedEvent event = new AccessibleTextExtendedEvent(accessible);
                event.start = start_offset;
                event.end = end_offset;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = (AccessibleTextExtendedListener)listeners.elementAt(i);
                    listener.getTextBounds(event);
                    ++i;
                }
                int[] topWindowX = new int[1];
                int[] topWindowY = new int[1];
                if (coord_type == 1) {
                    AccessibleObject.windowPoint(object, topWindowX, topWindowY);
                    event.x -= topWindowX[0];
                    event.y -= topWindowY[0];
                }
                AtkTextRectangle atkRect = new AtkTextRectangle();
                atkRect.x = event.x;
                atkRect.y = event.y;
                atkRect.width = event.width;
                atkRect.height = event.height;
                ATK.memmove(rect, atkRect, AtkTextRectangle.sizeof);
                return 0;
            }
        }
        if ((iface = AccessibleObject.getTextIface(atkObject)) != null && iface.get_range_extents != 0) {
            ATK.call(iface.get_range_extents, atkObject, start_offset, end_offset, coord_type, rect);
        }
        return 0;
    }

    static int atkText_get_run_attributes(int atkObject, int offset, int start_offset, int end_offset) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_run_attributes");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleAttributeListeners;
            int length = listeners.size();
            if (length > 0) {
                int attrPtr;
                Color color;
                Font font;
                int attrPtr2;
                AccessibleTextAttributeEvent event = new AccessibleTextAttributeEvent(accessible);
                event.offset = offset;
                int i = 0;
                while (i < length) {
                    AccessibleAttributeListener listener = (AccessibleAttributeListener)listeners.elementAt(i);
                    listener.getTextAttributes(event);
                    ++i;
                }
                OS.memmove(start_offset, new int[]{event.start}, 4);
                OS.memmove(end_offset, new int[]{event.end}, 4);
                TextStyle style = event.textStyle;
                if (style == null) {
                    return 0;
                }
                int result = 0;
                AtkAttribute attr = new AtkAttribute();
                if (style.rise != 0) {
                    attrPtr2 = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(10));
                    attr.value = AccessibleObject.getStringPtr(String.valueOf(style.rise));
                    ATK.memmove(attrPtr2, attr, AtkAttribute.sizeof);
                    result = OS.g_list_append(result, attrPtr2);
                }
                if (style.underline) {
                    attrPtr2 = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(11));
                    String str = "none";
                    switch (style.underlineStyle) {
                        case 1: {
                            str = "double";
                            break;
                        }
                        case 0: {
                            str = "single";
                            break;
                        }
                        case 2: {
                            str = "error";
                            break;
                        }
                        case 3: {
                            str = "squiggle";
                        }
                    }
                    attr.value = AccessibleObject.getStringPtr(str);
                    ATK.memmove(attrPtr2, attr, AtkAttribute.sizeof);
                    result = OS.g_list_append(result, attrPtr2);
                }
                if (style.strikeout) {
                    attrPtr2 = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(12));
                    attr.value = AccessibleObject.getStringPtr("1");
                    ATK.memmove(attrPtr2, attr, AtkAttribute.sizeof);
                    result = OS.g_list_append(result, attrPtr2);
                }
                if ((font = style.font) != null && !font.isDisposed()) {
                    int attrPtr3 = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(17));
                    attr.value = ATK.g_strdup(OS.pango_font_description_get_family(font.handle));
                    ATK.memmove(attrPtr3, attr, AtkAttribute.sizeof);
                    result = OS.g_list_append(result, attrPtr3);
                    attrPtr3 = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(13));
                    attr.value = AccessibleObject.getStringPtr(String.valueOf(OS.pango_font_description_get_size(font.handle) / 1024));
                    ATK.memmove(attrPtr3, attr, AtkAttribute.sizeof);
                    result = OS.g_list_append(result, attrPtr3);
                    attrPtr3 = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(27));
                    attr.value = ATK.g_strdup(ATK.atk_text_attribute_get_value(27, OS.pango_font_description_get_style(font.handle)));
                    ATK.memmove(attrPtr3, attr, AtkAttribute.sizeof);
                    result = OS.g_list_append(result, attrPtr3);
                    attrPtr3 = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(26));
                    attr.value = ATK.g_strdup(ATK.atk_text_attribute_get_value(26, OS.pango_font_description_get_variant(font.handle)));
                    ATK.memmove(attrPtr3, attr, AtkAttribute.sizeof);
                    result = OS.g_list_append(result, attrPtr3);
                    attrPtr3 = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(25));
                    attr.value = ATK.g_strdup(ATK.atk_text_attribute_get_value(25, OS.pango_font_description_get_stretch(font.handle)));
                    ATK.memmove(attrPtr3, attr, AtkAttribute.sizeof);
                    result = OS.g_list_append(result, attrPtr3);
                    attrPtr3 = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(15));
                    attr.value = AccessibleObject.getStringPtr(String.valueOf(OS.pango_font_description_get_weight(font.handle)));
                    ATK.memmove(attrPtr3, attr, AtkAttribute.sizeof);
                    result = OS.g_list_append(result, attrPtr3);
                }
                if ((color = style.foreground) != null && !color.isDisposed()) {
                    attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(19));
                    attr.value = AccessibleObject.getStringPtr(String.valueOf(color.handle.red & 0xFFFF) + "," + (color.handle.blue & 0xFFFF) + "," + (color.handle.blue & 0xFFFF));
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    result = OS.g_list_append(result, attrPtr);
                }
                if ((color = style.background) != null && !color.isDisposed()) {
                    attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(18));
                    attr.value = AccessibleObject.getStringPtr(String.valueOf(color.handle.red & 0xFFFF) + "," + (color.handle.blue & 0xFFFF) + "," + (color.handle.blue & 0xFFFF));
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    result = OS.g_list_append(result, attrPtr);
                }
                return result;
            }
        }
        int parentResult = 0;
        AtkTextIface iface = AccessibleObject.getTextIface(atkObject);
        if (iface != null && iface.get_run_attributes != 0) {
            parentResult = ATK.call(iface.get_run_attributes, atkObject, offset, start_offset, end_offset);
        }
        return parentResult;
    }

    static int atkText_get_offset_at_point(int atkObject, int x, int y, int coords) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_offset_at_point");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTextExtendedListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTextExtendedEvent event = new AccessibleTextExtendedEvent(accessible);
                event.x = x;
                event.y = y;
                int[] topWindowX = new int[1];
                int[] topWindowY = new int[1];
                if (coords == 1) {
                    AccessibleObject.windowPoint(object, topWindowX, topWindowY);
                    event.x += topWindowX[0];
                    event.y += topWindowY[0];
                }
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = (AccessibleTextExtendedListener)listeners.elementAt(i);
                    listener.getOffsetAtPoint(event);
                    ++i;
                }
                return event.offset;
            }
        }
        int parentResult = 0;
        AtkTextIface iface = AccessibleObject.getTextIface(atkObject);
        if (iface != null && iface.get_offset_at_point != 0) {
            parentResult = ATK.call(iface.get_offset_at_point, atkObject, x, y, coords);
        }
        return parentResult;
    }

    static int atkText_add_selection(int atkObject, int start_offset, int end_offset) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_add_selection");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTextExtendedListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTextExtendedEvent event = new AccessibleTextExtendedEvent(accessible);
                event.start = start_offset;
                event.end = end_offset;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = (AccessibleTextExtendedListener)listeners.elementAt(i);
                    listener.addSelection(event);
                    ++i;
                }
                return 1;
            }
        }
        int parentResult = 0;
        AtkTextIface iface = AccessibleObject.getTextIface(atkObject);
        if (iface != null && iface.add_selection != 0) {
            parentResult = ATK.call(iface.add_selection, atkObject, start_offset, end_offset);
        }
        return parentResult;
    }

    static int atkText_remove_selection(int atkObject, int selection_num) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_remove_selection");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTextExtendedListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTextExtendedEvent event = new AccessibleTextExtendedEvent(accessible);
                event.index = selection_num;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = (AccessibleTextExtendedListener)listeners.elementAt(i);
                    listener.removeSelection(event);
                    ++i;
                }
                return 1;
            }
        }
        int parentResult = 0;
        AtkTextIface iface = AccessibleObject.getTextIface(atkObject);
        if (iface != null && iface.remove_selection != 0) {
            parentResult = ATK.call(iface.remove_selection, atkObject, selection_num);
        }
        return parentResult;
    }

    static int atkText_set_caret_offset(int atkObject, int offset) {
        AtkTextIface iface;
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_gset_character_offset");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTextExtendedListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTextExtendedEvent event = new AccessibleTextExtendedEvent(accessible);
                event.offset = offset;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = (AccessibleTextExtendedListener)listeners.elementAt(i);
                    listener.setCaretOffset(event);
                    ++i;
                }
                return 1;
            }
        }
        if ((iface = AccessibleObject.getTextIface(atkObject)) != null && iface.get_character_at_offset != 0) {
            return ATK.call(iface.get_character_at_offset, atkObject, offset);
        }
        return 0;
    }

    static int atkText_set_selection(int atkObject, int selection_num, int start_offset, int end_offset) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_set_selection");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTextExtendedListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTextExtendedEvent event = new AccessibleTextExtendedEvent(accessible);
                event.index = selection_num;
                event.start = start_offset;
                event.end = end_offset;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = (AccessibleTextExtendedListener)listeners.elementAt(i);
                    listener.setSelection(event);
                    ++i;
                }
                return 1;
            }
        }
        int parentResult = 0;
        AtkTextIface iface = AccessibleObject.getTextIface(atkObject);
        if (iface != null && iface.set_selection != 0) {
            parentResult = ATK.call(iface.set_selection, atkObject, selection_num, start_offset, end_offset);
        }
        return parentResult;
    }

    static int atkText_get_caret_offset(int atkObject) {
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_caret_offset");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        AtkTextIface iface = AccessibleObject.getTextIface(atkObject);
        if (iface != null && iface.get_caret_offset != 0) {
            parentResult = ATK.call(iface.get_caret_offset, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTextExtendedListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTextExtendedEvent event = new AccessibleTextExtendedEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = (AccessibleTextExtendedListener)listeners.elementAt(i);
                    listener.getCaretOffset(event);
                    ++i;
                }
                return event.offset;
            }
            listeners = accessible.accessibleTextListeners;
            length = listeners.size();
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(object.accessible);
                event.childID = object.id;
                event.offset = parentResult;
                int i = 0;
                while (i < length) {
                    AccessibleTextListener listener = (AccessibleTextListener)listeners.elementAt(i);
                    listener.getCaretOffset(event);
                    ++i;
                }
                return event.offset;
            }
        }
        return parentResult;
    }

    static int atkText_get_bounded_ranges(int atkObject, int rect, int coord_type, int x_clip_type, int y_clip_type) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_bounded_ranges");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTextExtendedListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTextExtendedEvent event = new AccessibleTextExtendedEvent(accessible);
                AtkTextRectangle atkRect = new AtkTextRectangle();
                ATK.memmove(atkRect, rect, AtkTextRectangle.sizeof);
                event.x = atkRect.x;
                event.y = atkRect.y;
                event.width = atkRect.width;
                event.height = atkRect.height;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = (AccessibleTextExtendedListener)listeners.elementAt(i);
                    listener.getRanges(event);
                    ++i;
                }
                int[] ranges = event.ranges;
                int size = ranges == null ? 1 : ranges.length / 2;
                int result = OS.malloc(size * AtkTextRange.sizeof);
                AtkTextRange range = new AtkTextRange();
                int j = 0;
                int end = ranges != null ? ranges.length / 2 : 1;
                while (j < end) {
                    AccessibleTextExtendedListener listener;
                    if (ranges != null) {
                        int index = j * 2;
                        event.start = ranges[index];
                        event.end = ranges[index + 1];
                    }
                    event.count = 0;
                    event.type = 5;
                    int i2 = 0;
                    while (i2 < length) {
                        listener = (AccessibleTextExtendedListener)listeners.elementAt(i2);
                        listener.getText(event);
                        ++i2;
                    }
                    range.start_offset = event.start;
                    range.end_offset = event.end;
                    range.content = AccessibleObject.getStringPtr(event.result);
                    event.result = null;
                    event.height = 0;
                    event.width = 0;
                    event.y = 0;
                    event.x = 0;
                    event.type = 0;
                    event.count = 0;
                    i2 = 0;
                    while (i2 < length) {
                        listener = (AccessibleTextExtendedListener)listeners.elementAt(i2);
                        listener.getTextBounds(event);
                        ++i2;
                    }
                    range.bounds.x = event.x;
                    range.bounds.y = event.y;
                    range.bounds.width = event.width;
                    range.bounds.height = event.height;
                    ATK.memmove(result + j * AtkTextRange.sizeof, range, AtkTextRange.sizeof);
                    ++j;
                }
                return result;
            }
        }
        int parentResult = 0;
        AtkTextIface iface = AccessibleObject.getTextIface(atkObject);
        if (iface != null && iface.get_bounded_ranges != 0) {
            parentResult = ATK.call(iface.get_bounded_ranges, atkObject);
        }
        return parentResult;
    }

    static int atkText_get_character_at_offset(int atkObject, int offset) {
        AtkTextIface iface;
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_character_at_offset");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            String text;
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTextExtendedListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTextExtendedEvent event = new AccessibleTextExtendedEvent(accessible);
                event.start = offset;
                event.end = offset + 1;
                event.type = 0;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = (AccessibleTextExtendedListener)listeners.elementAt(i);
                    listener.getText(event);
                    ++i;
                }
                String text2 = event.result;
                if (text2 != null && text2.length() > 0) {
                    return text2.charAt(0);
                }
            }
            if ((text = object.getText()) != null) {
                return text.charAt(offset);
            }
        }
        if ((iface = AccessibleObject.getTextIface(atkObject)) != null && iface.get_character_at_offset != 0) {
            return ATK.call(iface.get_character_at_offset, atkObject, offset);
        }
        return 0;
    }

    static int atkText_get_character_count(int atkObject) {
        AtkTextIface iface;
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_character_count");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTextExtendedListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTextExtendedEvent event = new AccessibleTextExtendedEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = (AccessibleTextExtendedListener)listeners.elementAt(i);
                    listener.getCharacterCount(event);
                    ++i;
                }
                return event.count;
            }
            String text = object.getText();
            if (text != null) {
                return text.length();
            }
        }
        if ((iface = AccessibleObject.getTextIface(atkObject)) != null && iface.get_character_count != 0) {
            return ATK.call(iface.get_character_count, atkObject);
        }
        return 0;
    }

    static int atkText_get_n_selections(int atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_n_selections");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTextExtendedListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTextExtendedEvent event = new AccessibleTextExtendedEvent(accessible);
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = (AccessibleTextExtendedListener)listeners.elementAt(i);
                    listener.getSelectionCount(event);
                    ++i;
                }
                return event.count;
            }
            listeners = accessible.accessibleTextListeners;
            length = listeners.size();
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(object.accessible);
                event.childID = object.id;
                int i = 0;
                while (i < length) {
                    AccessibleTextListener listener = (AccessibleTextListener)listeners.elementAt(i);
                    listener.getSelectionRange(event);
                    ++i;
                }
                if (event.length > 0) {
                    return 1;
                }
            }
        }
        int parentResult = 0;
        AtkTextIface iface = AccessibleObject.getTextIface(atkObject);
        if (iface != null && iface.get_n_selections != 0) {
            parentResult = ATK.call(iface.get_n_selections, atkObject);
        }
        return parentResult;
    }

    static int atkText_get_selection(int atkObject, int selection_num, int start_offset, int end_offset) {
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_selection");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        int parentResult = 0;
        OS.memmove(start_offset, new int[1], 4);
        OS.memmove(end_offset, new int[1], 4);
        AtkTextIface iface = AccessibleObject.getTextIface(atkObject);
        if (iface != null && iface.get_selection != 0) {
            parentResult = ATK.call(iface.get_selection, atkObject, selection_num, start_offset, end_offset);
        }
        if (object != null) {
            int[] parentStart = new int[1];
            int[] parentEnd = new int[1];
            OS.memmove(parentStart, start_offset, 4);
            OS.memmove(parentEnd, end_offset, 4);
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTextExtendedListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTextExtendedListener listener;
                AccessibleTextExtendedEvent event = new AccessibleTextExtendedEvent(accessible);
                event.index = selection_num;
                event.start = parentStart[0];
                event.end = parentEnd[0];
                int i = 0;
                while (i < length) {
                    listener = (AccessibleTextExtendedListener)listeners.elementAt(i);
                    listener.getSelection(event);
                    ++i;
                }
                parentStart[0] = event.start;
                parentEnd[0] = event.end;
                OS.memmove(start_offset, parentStart, 4);
                OS.memmove(end_offset, parentEnd, 4);
                event.index = 0;
                event.count = 0;
                event.type = 5;
                i = 0;
                while (i < length) {
                    listener = (AccessibleTextExtendedListener)listeners.elementAt(i);
                    listener.getText(event);
                    ++i;
                }
                return AccessibleObject.getStringPtr(event.result);
            }
            if (selection_num == 0 && (length = (listeners = accessible.accessibleTextListeners).size()) > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.childID = object.id;
                event.offset = parentStart[0];
                event.length = parentEnd[0] - parentStart[0];
                int i = 0;
                while (i < length) {
                    AccessibleTextListener listener = (AccessibleTextListener)listeners.elementAt(i);
                    listener.getSelectionRange(event);
                    ++i;
                }
                OS.memmove(start_offset, new int[]{event.offset}, 4);
                OS.memmove(end_offset, new int[]{event.offset + event.length}, 4);
                return 0;
            }
        }
        return parentResult;
    }

    static int atkText_get_text(int atkObject, int start_offset, int end_offset) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_text: " + start_offset + "," + end_offset);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTextExtendedListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTextExtendedEvent event = new AccessibleTextExtendedEvent(accessible);
                event.start = start_offset;
                event.end = end_offset;
                event.type = 5;
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = (AccessibleTextExtendedListener)listeners.elementAt(i);
                    listener.getText(event);
                    ++i;
                }
                return AccessibleObject.getStringPtr(event.result);
            }
            String text = object.getText();
            if (text != null && text.length() > 0) {
                end_offset = end_offset == -1 ? text.length() : Math.min(end_offset, text.length());
                start_offset = Math.min(start_offset, end_offset);
                text = text.substring(start_offset, end_offset);
                return AccessibleObject.getStringPtr(text);
            }
        }
        return 0;
    }

    static int atkText_get_text_after_offset(int atkObject, int offset_value, int boundary_type, int start_offset, int end_offset) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_text_after_offset");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTextExtendedListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTextExtendedEvent event = new AccessibleTextExtendedEvent(accessible);
                event.start = event.end = offset_value;
                event.count = 1;
                switch (boundary_type) {
                    case 0: {
                        event.type = 0;
                        break;
                    }
                    case 1: {
                        event.type = 1;
                        break;
                    }
                    case 2: {
                        event.type = 1;
                        break;
                    }
                    case 3: {
                        event.type = 2;
                        break;
                    }
                    case 4: {
                        event.type = 2;
                        break;
                    }
                    case 5: {
                        event.type = 4;
                        break;
                    }
                    case 6: {
                        event.type = 4;
                    }
                }
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = (AccessibleTextExtendedListener)listeners.elementAt(i);
                    listener.getText(event);
                    ++i;
                }
                OS.memmove(start_offset, new int[]{event.start}, 4);
                OS.memmove(end_offset, new int[]{event.end}, 4);
                return AccessibleObject.getStringPtr(event.result);
            }
            int offset = offset_value;
            String text = object.getText();
            if (text != null && text.length() > 0) {
                length = text.length();
                int startBounds = offset = Math.min(offset, length - 1);
                int endBounds = offset;
                switch (boundary_type) {
                    case 0: {
                        if (length <= offset) break;
                        break;
                    }
                    case 1: {
                        int wordStart1 = AccessibleObject.nextIndexOfChar(text, " !?.\n", offset - 1);
                        if (wordStart1 == -1) {
                            startBounds = endBounds = length;
                            break;
                        }
                        if ((wordStart1 = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", wordStart1)) == length) {
                            startBounds = endBounds = length;
                            break;
                        }
                        startBounds = wordStart1;
                        int wordStart2 = AccessibleObject.nextIndexOfChar(text, " !?.\n", wordStart1);
                        if (wordStart2 == -1) {
                            endBounds = length;
                            break;
                        }
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", wordStart2);
                        break;
                    }
                    case 2: {
                        int previousWordEnd = AccessibleObject.previousIndexOfNotChar(text, " \n", offset);
                        if (previousWordEnd == -1 || previousWordEnd != offset - 1) {
                            offset = AccessibleObject.nextIndexOfNotChar(text, " \n", offset);
                        }
                        if (offset == -1) {
                            startBounds = endBounds = length;
                            break;
                        }
                        int wordEnd1 = AccessibleObject.nextIndexOfChar(text, " !?.\n", offset);
                        if (wordEnd1 == -1) {
                            startBounds = endBounds = length;
                            break;
                        }
                        if ((wordEnd1 = AccessibleObject.nextIndexOfNotChar(text, "!?.", wordEnd1)) == length) {
                            startBounds = endBounds = length;
                            break;
                        }
                        startBounds = wordEnd1;
                        int wordEnd2 = AccessibleObject.nextIndexOfNotChar(text, " \n", wordEnd1);
                        if (wordEnd2 == length) {
                            startBounds = endBounds = length;
                            break;
                        }
                        if ((wordEnd2 = AccessibleObject.nextIndexOfChar(text, " !?.\n", wordEnd2)) == -1) {
                            endBounds = length;
                            break;
                        }
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, "!?.", wordEnd2);
                        break;
                    }
                    case 3: {
                        int previousSentenceEnd = AccessibleObject.previousIndexOfChar(text, "!?.", offset);
                        int previousText = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", offset);
                        int sentenceStart1 = 0;
                        if (previousSentenceEnd >= previousText) {
                            sentenceStart1 = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", offset);
                        } else {
                            sentenceStart1 = AccessibleObject.nextIndexOfChar(text, "!?.", offset);
                            if (sentenceStart1 == -1) {
                                startBounds = endBounds = length;
                                break;
                            }
                            sentenceStart1 = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", sentenceStart1);
                        }
                        if (sentenceStart1 == length) {
                            startBounds = endBounds = length;
                            break;
                        }
                        startBounds = sentenceStart1;
                        int sentenceStart2 = AccessibleObject.nextIndexOfChar(text, "!?.", sentenceStart1);
                        if (sentenceStart2 == -1) {
                            endBounds = length;
                            break;
                        }
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", sentenceStart2);
                        break;
                    }
                    case 4: {
                        int sentenceEnd1 = AccessibleObject.nextIndexOfChar(text, "!?.", offset);
                        if (sentenceEnd1 == -1) {
                            startBounds = endBounds = length;
                            break;
                        }
                        if ((sentenceEnd1 = AccessibleObject.nextIndexOfNotChar(text, "!?.", sentenceEnd1)) == length) {
                            startBounds = endBounds = length;
                            break;
                        }
                        startBounds = sentenceEnd1;
                        int sentenceEnd2 = AccessibleObject.nextIndexOfNotChar(text, " \n", sentenceEnd1);
                        if (sentenceEnd2 == length) {
                            startBounds = endBounds = length;
                            break;
                        }
                        if ((sentenceEnd2 = AccessibleObject.nextIndexOfChar(text, "!?.", sentenceEnd2)) == -1) {
                            endBounds = length;
                            break;
                        }
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, "!?.", sentenceEnd2);
                        break;
                    }
                    case 5: {
                        int lineStart1 = text.indexOf(10, offset - 1);
                        if (lineStart1 == -1) {
                            startBounds = endBounds = length;
                            break;
                        }
                        if ((lineStart1 = AccessibleObject.nextIndexOfNotChar(text, "\n", lineStart1)) == length) {
                            startBounds = endBounds = length;
                            break;
                        }
                        startBounds = lineStart1;
                        int lineStart2 = text.indexOf(10, lineStart1);
                        if (lineStart2 == -1) {
                            endBounds = length;
                            break;
                        }
                        endBounds = lineStart2 = AccessibleObject.nextIndexOfNotChar(text, "\n", lineStart2);
                        break;
                    }
                    case 6: {
                        int lineEnd2;
                        int lineEnd1 = AccessibleObject.nextIndexOfChar(text, "\n", offset);
                        if (lineEnd1 == -1) {
                            startBounds = endBounds = length;
                            break;
                        }
                        startBounds = lineEnd1;
                        endBounds = startBounds == length ? length : ((lineEnd2 = AccessibleObject.nextIndexOfChar(text, "\n", lineEnd1 + 1)) == -1 ? length : lineEnd2);
                    }
                }
                OS.memmove(start_offset, new int[]{startBounds}, 4);
                OS.memmove(end_offset, new int[]{++endBounds}, 4);
                text = text.substring(startBounds, endBounds);
                return AccessibleObject.getStringPtr(text);
            }
        }
        return 0;
    }

    static int atkText_get_text_at_offset(int atkObject, int offset_value, int boundary_type, int start_offset, int end_offset) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_text_at_offset: " + offset_value + " start: " + start_offset + " end: " + end_offset);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTextExtendedListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTextExtendedEvent event = new AccessibleTextExtendedEvent(accessible);
                event.start = event.end = offset_value;
                event.count = 0;
                switch (boundary_type) {
                    case 0: {
                        event.type = 0;
                        break;
                    }
                    case 1: {
                        event.type = 1;
                        break;
                    }
                    case 2: {
                        event.type = 1;
                        break;
                    }
                    case 3: {
                        event.type = 2;
                        break;
                    }
                    case 4: {
                        event.type = 2;
                        break;
                    }
                    case 5: {
                        event.type = 4;
                        break;
                    }
                    case 6: {
                        event.type = 4;
                    }
                }
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = (AccessibleTextExtendedListener)listeners.elementAt(i);
                    listener.getText(event);
                    ++i;
                }
                OS.memmove(start_offset, new int[]{event.start}, 4);
                OS.memmove(end_offset, new int[]{event.end}, 4);
                return AccessibleObject.getStringPtr(event.result);
            }
            int offset = offset_value;
            String text = object.getText();
            if (text != null && text.length() > 0) {
                length = text.length();
                int startBounds = offset = Math.min(offset, length - 1);
                int endBounds = offset;
                switch (boundary_type) {
                    case 0: {
                        if (length <= offset) break;
                        break;
                    }
                    case 1: {
                        int wordStart1 = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", offset);
                        if (wordStart1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        if ((wordStart1 = AccessibleObject.previousIndexOfChar(text, " !?.\n", wordStart1) + 1) == -1) {
                            startBounds = 0;
                            break;
                        }
                        startBounds = wordStart1;
                        int wordStart2 = AccessibleObject.nextIndexOfChar(text, " !?.\n", wordStart1);
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", wordStart2);
                        break;
                    }
                    case 2: {
                        int wordEnd1 = AccessibleObject.previousIndexOfNotChar(text, "!?.", offset + 1);
                        wordEnd1 = AccessibleObject.previousIndexOfChar(text, " !?.\n", wordEnd1);
                        wordEnd1 = AccessibleObject.previousIndexOfNotChar(text, " \n", wordEnd1 + 1);
                        if (wordEnd1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        startBounds = wordEnd1 + 1;
                        int wordEnd2 = AccessibleObject.nextIndexOfNotChar(text, " \n", startBounds);
                        if (wordEnd2 == length) {
                            endBounds = startBounds;
                            break;
                        }
                        if ((wordEnd2 = AccessibleObject.nextIndexOfChar(text, " !?.\n", wordEnd2)) == -1) {
                            endBounds = startBounds;
                            break;
                        }
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, "!?.", wordEnd2);
                        break;
                    }
                    case 3: {
                        int sentenceStart1 = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", offset + 1);
                        if (sentenceStart1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        sentenceStart1 = AccessibleObject.previousIndexOfChar(text, "!?.", sentenceStart1) + 1;
                        startBounds = AccessibleObject.nextIndexOfNotChar(text, " \n", sentenceStart1);
                        int sentenceStart2 = AccessibleObject.nextIndexOfChar(text, "!?.", startBounds);
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", sentenceStart2);
                        break;
                    }
                    case 4: {
                        int sentenceEnd1 = AccessibleObject.previousIndexOfNotChar(text, "!?.", offset + 1);
                        sentenceEnd1 = AccessibleObject.previousIndexOfChar(text, "!?.", sentenceEnd1);
                        sentenceEnd1 = AccessibleObject.previousIndexOfNotChar(text, " \n", sentenceEnd1 + 1);
                        if (sentenceEnd1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        startBounds = sentenceEnd1 + 1;
                        int sentenceEnd2 = AccessibleObject.nextIndexOfNotChar(text, " \n", startBounds);
                        if (sentenceEnd2 == length) {
                            endBounds = startBounds;
                            break;
                        }
                        if ((sentenceEnd2 = AccessibleObject.nextIndexOfChar(text, "!?.", sentenceEnd2)) == -1) {
                            endBounds = startBounds;
                            break;
                        }
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, "!?.", sentenceEnd2);
                        break;
                    }
                    case 5: {
                        startBounds = AccessibleObject.previousIndexOfChar(text, "\n", offset) + 1;
                        int lineEnd2 = AccessibleObject.nextIndexOfChar(text, "\n", startBounds);
                        if (lineEnd2 < length) {
                            ++lineEnd2;
                        }
                        endBounds = lineEnd2;
                        break;
                    }
                    case 6: {
                        int lineEnd1 = AccessibleObject.previousIndexOfChar(text, "\n", offset);
                        if (lineEnd1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        startBounds = lineEnd1;
                        endBounds = AccessibleObject.nextIndexOfChar(text, "\n", lineEnd1 + 1);
                    }
                }
                OS.memmove(start_offset, new int[]{startBounds}, 4);
                OS.memmove(end_offset, new int[]{++endBounds}, 4);
                text = text.substring(startBounds, endBounds);
                return AccessibleObject.getStringPtr(text);
            }
        }
        return 0;
    }

    static int atkText_get_text_before_offset(int atkObject, int offset_value, int boundary_type, int start_offset, int end_offset) {
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_text_before_offset");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleTextExtendedListeners;
            int length = listeners.size();
            if (length > 0) {
                AccessibleTextExtendedEvent event = new AccessibleTextExtendedEvent(accessible);
                event.start = event.end = offset_value;
                event.count = -1;
                switch (boundary_type) {
                    case 0: {
                        event.type = 0;
                        break;
                    }
                    case 1: {
                        event.type = 1;
                        break;
                    }
                    case 2: {
                        event.type = 1;
                        break;
                    }
                    case 3: {
                        event.type = 2;
                        break;
                    }
                    case 4: {
                        event.type = 2;
                        break;
                    }
                    case 5: {
                        event.type = 4;
                        break;
                    }
                    case 6: {
                        event.type = 4;
                    }
                }
                int i = 0;
                while (i < length) {
                    AccessibleTextExtendedListener listener = (AccessibleTextExtendedListener)listeners.elementAt(i);
                    listener.getText(event);
                    ++i;
                }
                OS.memmove(start_offset, new int[]{event.start}, 4);
                OS.memmove(end_offset, new int[]{event.end}, 4);
                return AccessibleObject.getStringPtr(event.result);
            }
            int offset = offset_value;
            String text = object.getText();
            if (text != null && text.length() > 0) {
                length = text.length();
                int startBounds = offset = Math.min(offset, length - 1);
                int endBounds = offset;
                switch (boundary_type) {
                    case 0: {
                        if (length < offset || offset <= 0) break;
                        break;
                    }
                    case 1: {
                        int wordStart1 = AccessibleObject.previousIndexOfChar(text, " !?.\n", offset - 1);
                        if (wordStart1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        int wordStart2 = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", wordStart1);
                        if (wordStart2 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        endBounds = wordStart1 + 1;
                        startBounds = AccessibleObject.previousIndexOfChar(text, " !?.\n", wordStart2) + 1;
                        break;
                    }
                    case 2: {
                        int wordEnd1 = AccessibleObject.previousIndexOfChar(text, " !?.\n", offset);
                        if (wordEnd1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        if ((wordEnd1 = AccessibleObject.previousIndexOfNotChar(text, " \n", wordEnd1 + 1)) == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        endBounds = wordEnd1 + 1;
                        int wordEnd2 = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", endBounds);
                        if ((wordEnd2 = AccessibleObject.previousIndexOfChar(text, " !?.\n", wordEnd2)) == -1) {
                            startBounds = 0;
                            break;
                        }
                        startBounds = AccessibleObject.previousIndexOfNotChar(text, " \n", wordEnd2 + 1) + 1;
                        break;
                    }
                    case 3: {
                        int sentenceStart1 = AccessibleObject.previousIndexOfChar(text, "!?.", offset);
                        if (sentenceStart1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        int sentenceStart2 = AccessibleObject.previousIndexOfNotChar(text, "!?.", sentenceStart1);
                        if (sentenceStart2 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        endBounds = sentenceStart1 + 1;
                        startBounds = AccessibleObject.previousIndexOfChar(text, "!?.", sentenceStart2) + 1;
                        break;
                    }
                    case 4: {
                        int sentenceEnd1 = AccessibleObject.previousIndexOfChar(text, "!?.", offset);
                        if (sentenceEnd1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        if ((sentenceEnd1 = AccessibleObject.previousIndexOfNotChar(text, " \n", sentenceEnd1 + 1)) == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        endBounds = sentenceEnd1 + 1;
                        int sentenceEnd2 = AccessibleObject.previousIndexOfNotChar(text, "!?.", endBounds);
                        if ((sentenceEnd2 = AccessibleObject.previousIndexOfChar(text, "!?.", sentenceEnd2)) == -1) {
                            startBounds = 0;
                            break;
                        }
                        startBounds = AccessibleObject.previousIndexOfNotChar(text, " \n", sentenceEnd2 + 1) + 1;
                        break;
                    }
                    case 5: {
                        int lineStart1 = AccessibleObject.previousIndexOfChar(text, "\n", offset);
                        if (lineStart1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        endBounds = lineStart1 + 1;
                        startBounds = AccessibleObject.previousIndexOfChar(text, "\n", lineStart1) + 1;
                        break;
                    }
                    case 6: {
                        int lineEnd1 = AccessibleObject.previousIndexOfChar(text, "\n", offset);
                        if (lineEnd1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        endBounds = lineEnd1;
                        startBounds = AccessibleObject.previousIndexOfChar(text, "\n", lineEnd1);
                        if (startBounds != -1) break;
                        startBounds = 0;
                    }
                }
                OS.memmove(start_offset, new int[]{--startBounds}, 4);
                OS.memmove(end_offset, new int[]{endBounds}, 4);
                text = text.substring(startBounds, endBounds);
                return AccessibleObject.getStringPtr(text);
            }
        }
        return 0;
    }

    static void setGValue(int value, Number number) {
        if (number == null) {
            return;
        }
        OS.g_value_unset(value);
        if (number instanceof Double) {
            OS.g_value_init(value, OS.G_TYPE_DOUBLE());
            OS.g_value_set_double(value, number.doubleValue());
        } else if (number instanceof Float) {
            OS.g_value_init(value, OS.G_TYPE_FLOAT());
            OS.g_value_set_float(value, number.floatValue());
        } else if (number instanceof Long) {
            OS.g_value_init(value, OS.G_TYPE_INT64());
            OS.g_value_set_int64(value, number.longValue());
        } else {
            OS.g_value_init(value, OS.G_TYPE_INT());
            OS.g_value_set_int(value, number.intValue());
        }
    }

    static Number getGValue(int value) {
        int type = OS.G_VALUE_TYPE(value);
        if (type == OS.G_TYPE_DOUBLE()) {
            return new Double(OS.g_value_get_double(value));
        }
        if (type == OS.G_TYPE_FLOAT()) {
            return new Float(OS.g_value_get_float(value));
        }
        if (type == OS.G_TYPE_INT64()) {
            return new Long(OS.g_value_get_int64(value));
        }
        return new Integer(OS.g_value_get_int(value));
    }

    static AtkValueIface getValueIface(int atkObject) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(atkObject)), ATK.ATK_TYPE_VALUE())) {
            AtkValueIface iface = new AtkValueIface();
            ATK.memmove(iface, ATK.g_type_interface_peek_parent(ATK.ATK_VALUE_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static int atkValue_get_current_value(int atkObject, int value) {
        if (DEBUG) {
            AccessibleObject.print("-->atkValue_get_current_value");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        AtkValueIface iface = AccessibleObject.getValueIface(atkObject);
        if (iface != null && iface.get_current_value != 0) {
            ATK.call(iface.get_current_value, atkObject, value);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleValueListeners;
            AccessibleValueEvent event = new AccessibleValueEvent(accessible);
            event.value = AccessibleObject.getGValue(value);
            int i = 0;
            int length = listeners.size();
            while (i < length) {
                AccessibleValueListener listener = (AccessibleValueListener)listeners.elementAt(i);
                listener.getCurrentValue(event);
                ++i;
            }
            AccessibleObject.setGValue(value, event.value);
        }
        return 0;
    }

    static int atkValue_get_maximum_value(int atkObject, int value) {
        if (DEBUG) {
            AccessibleObject.print("-->atkValue_get_maximum_value");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        AtkValueIface iface = AccessibleObject.getValueIface(atkObject);
        if (iface != null && iface.get_maximum_value != 0) {
            ATK.call(iface.get_maximum_value, atkObject, value);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleValueListeners;
            AccessibleValueEvent event = new AccessibleValueEvent(accessible);
            event.value = AccessibleObject.getGValue(value);
            int i = 0;
            int length = listeners.size();
            while (i < length) {
                AccessibleValueListener listener = (AccessibleValueListener)listeners.elementAt(i);
                listener.getMaximumValue(event);
                ++i;
            }
            AccessibleObject.setGValue(value, event.value);
        }
        return 0;
    }

    static int atkValue_get_minimum_value(int atkObject, int value) {
        if (DEBUG) {
            AccessibleObject.print("-->atkValue_get_minimum_value");
        }
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        AtkValueIface iface = AccessibleObject.getValueIface(atkObject);
        if (iface != null && iface.get_minimum_value != 0) {
            ATK.call(iface.get_minimum_value, atkObject, value);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            Vector listeners = accessible.accessibleValueListeners;
            AccessibleValueEvent event = new AccessibleValueEvent(accessible);
            event.value = AccessibleObject.getGValue(value);
            int i = 0;
            int length = listeners.size();
            while (i < length) {
                AccessibleValueListener listener = (AccessibleValueListener)listeners.elementAt(i);
                listener.getMinimumValue(event);
                ++i;
            }
            AccessibleObject.setGValue(value, event.value);
        }
        return 0;
    }

    static int atkValue_set_current_value(int atkObject, int value) {
        Vector listeners;
        int length;
        Accessible accessible;
        AccessibleObject object;
        if (DEBUG) {
            AccessibleObject.print("-->atkValue_set_current_value");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) != null && (accessible = object.accessible) != null && (length = (listeners = accessible.accessibleValueListeners).size()) > 0) {
            AccessibleValueEvent event = new AccessibleValueEvent(accessible);
            event.value = AccessibleObject.getGValue(value);
            int i = 0;
            while (i < length) {
                AccessibleValueListener listener = (AccessibleValueListener)listeners.elementAt(i);
                listener.setCurrentValue(event);
                ++i;
            }
            return 0;
        }
        int parentResult = 0;
        AtkValueIface iface = AccessibleObject.getValueIface(atkObject);
        if (iface != null && iface.set_current_value != 0) {
            parentResult = ATK.call(iface.set_current_value, atkObject, value);
        }
        return parentResult;
    }

    static AccessibleObject getAccessibleObject(int atkObject) {
        AccessibleObject object = (AccessibleObject)AccessibleObjects.get(new LONG(atkObject));
        if (object == null) {
            return null;
        }
        if (object.accessible == null) {
            return null;
        }
        Control control = object.accessible.control;
        if (control == null || control.isDisposed()) {
            return null;
        }
        return object;
    }

    AccessibleObject getChildByID(int childId) {
        if (childId == -1) {
            return this;
        }
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                if (this.children[i] != null && this.children[i].id == childId) {
                    return this.children[0];
                }
                ++i;
            }
        }
        return null;
    }

    AccessibleObject getChildByIndex(int childIndex) {
        if (this.children != null && childIndex < this.children.length) {
            return this.children[childIndex];
        }
        return null;
    }

    String getText() {
        Vector listeners;
        int length;
        int characterCount;
        int parentResult = 0;
        String parentText = "";
        AtkTextIface iface = AccessibleObject.getTextIface(this.handle);
        if (iface != null && iface.get_character_count != 0 && (characterCount = ATK.call(iface.get_character_count, this.handle)) > 0 && iface.get_text != 0 && (parentResult = ATK.call(iface.get_text, this.handle, 0, characterCount)) != 0) {
            parentText = AccessibleObject.getString(parentResult);
            OS.g_free(parentResult);
        }
        if ((length = (listeners = this.accessible.accessibleControlListeners).size()) > 0) {
            AccessibleControlEvent event = new AccessibleControlEvent(this.accessible);
            event.childID = this.id;
            event.result = parentText;
            int i = 0;
            while (i < length) {
                AccessibleControlListener listener = (AccessibleControlListener)listeners.elementAt(i);
                listener.getValue(event);
                ++i;
            }
            return event.result;
        }
        return null;
    }

    static int gObjectClass_finalize(int atkObject) {
        if (DEBUG) {
            AccessibleObject.print("-->gObjectClass_finalize: " + atkObject);
        }
        int superType = ATK.g_type_class_peek_parent(ATK.G_OBJECT_GET_CLASS(atkObject));
        int gObjectClass = ATK.G_OBJECT_CLASS(superType);
        GObjectClass objectClassStruct = new GObjectClass();
        ATK.memmove(objectClassStruct, gObjectClass);
        ATK.call(objectClassStruct.finalize, atkObject);
        AccessibleObject object = (AccessibleObject)AccessibleObjects.get(new LONG(atkObject));
        if (object != null) {
            AccessibleObjects.remove(new LONG(atkObject));
        }
        return 0;
    }

    static int toATKRelation(int relation) {
        switch (relation) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 14;
            }
            case 3: {
                return 15;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 10;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 3;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 5;
            }
            case 11: {
                return 6;
            }
            case 12: {
                return 13;
            }
            case 13: {
                return 12;
            }
            case 14: {
                return 9;
            }
        }
        return 0;
    }

    static void windowPoint(AccessibleObject object, int[] x, int[] y) {
        GtkAccessible gtkAccessible = new GtkAccessible();
        ATK.memmove(gtkAccessible, object.handle);
        while (gtkAccessible.widget == 0 && object.parent != null) {
            object = object.parent;
            ATK.memmove(gtkAccessible, object.handle);
        }
        if (gtkAccessible.widget == 0) {
            return;
        }
        int topLevel = ATK.gtk_widget_get_toplevel(gtkAccessible.widget);
        int window = OS.GTK_WIDGET_WINDOW(topLevel);
        OS.gdk_window_get_origin(window, x, y);
    }

    static int nextIndexOfChar(String string, String searchChars, int startIndex) {
        int result = string.length();
        int i = 0;
        while (i < searchChars.length()) {
            char current = searchChars.charAt(i);
            int index = string.indexOf(current, startIndex);
            if (index != -1) {
                result = Math.min(result, index);
            }
            ++i;
        }
        return result;
    }

    static int nextIndexOfNotChar(String string, String searchChars, int startIndex) {
        int length = string.length();
        int index = startIndex;
        while (index < length) {
            char current = string.charAt(index);
            if (searchChars.indexOf(current) == -1) break;
            ++index;
        }
        return index;
    }

    static int previousIndexOfChar(String string, String searchChars, int startIndex) {
        int result = -1;
        if (startIndex < 0) {
            return result;
        }
        string = string.substring(0, startIndex);
        int i = 0;
        while (i < searchChars.length()) {
            char current = searchChars.charAt(i);
            int index = string.lastIndexOf(current);
            if (index != -1) {
                result = Math.max(result, index);
            }
            ++i;
        }
        return result;
    }

    static int previousIndexOfNotChar(String string, String searchChars, int startIndex) {
        if (startIndex < 0) {
            return -1;
        }
        int index = startIndex - 1;
        while (index >= 0) {
            char current = string.charAt(index);
            if (searchChars.indexOf(current) == -1) break;
            --index;
        }
        return index;
    }

    void addRelation(int type, Accessible target) {
        OS.atk_object_add_relationship(this.handle, AccessibleObject.toATKRelation(type), target.getAccessibleObject().handle);
    }

    void release() {
        if (DEBUG) {
            AccessibleObject.print("AccessibleObject.release: " + this.handle);
        }
        this.accessible = null;
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                AccessibleObject child = this.children[i];
                if (child != null) {
                    OS.g_object_unref(child.handle);
                }
                ++i;
            }
            this.children = null;
        }
        if (this.isLightweight) {
            OS.g_object_unref(this.handle);
        }
    }

    void removeRelation(int type, Accessible target) {
        OS.atk_object_remove_relationship(this.handle, AccessibleObject.toATKRelation(type), target.getAccessibleObject().handle);
    }

    void selectionChanged() {
        OS.g_signal_emit_by_name(this.handle, ATK.selection_changed);
    }

    void setFocus(int childID) {
        this.updateChildren();
        AccessibleObject accObject = this.getChildByID(childID);
        if (accObject != null) {
            ATK.atk_focus_tracker_notify(accObject.handle);
        }
    }

    void textCaretMoved(int index) {
        OS.g_signal_emit_by_name(this.handle, ATK.text_caret_moved, index);
    }

    void textChanged(int type, int startIndex, int length) {
        if (type == 1) {
            OS.g_signal_emit_by_name(this.handle, ATK.text_changed_delete, startIndex, length);
        } else {
            OS.g_signal_emit_by_name(this.handle, ATK.text_changed_insert, startIndex, length);
        }
    }

    void textSelectionChanged() {
        OS.g_signal_emit_by_name(this.handle, ATK.text_selection_changed);
    }

    void updateChildren() {
        if (this.isLightweight) {
            return;
        }
        Vector listeners = this.accessible.accessibleControlListeners;
        int length = listeners.size();
        AccessibleControlEvent event = new AccessibleControlEvent(this.accessible);
        event.childID = this.id;
        int i = 0;
        while (i < length) {
            AccessibleControlListener listener = (AccessibleControlListener)listeners.elementAt(i);
            listener.getChildren(event);
            ++i;
        }
        Object[] children = event.children;
        AccessibleObject[] oldChildren = this.children;
        int count = children != null ? children.length : 0;
        AccessibleObject[] newChildren = new AccessibleObject[count];
        int i2 = 0;
        while (i2 < count) {
            Object child = children[i2];
            AccessibleObject object = null;
            if (child instanceof Integer) {
                int id = (Integer)child;
                AccessibleObject accessibleObject = object = oldChildren != null && i2 < oldChildren.length ? oldChildren[i2] : null;
                if (object == null || object.id != id) {
                    object = AccessibleFactory.createChildAccessible(this.accessible, id);
                    object.id = id;
                } else {
                    OS.g_object_ref(object.handle);
                }
            } else if (child instanceof Accessible && (object = ((Accessible)child).getAccessibleObject()) != null) {
                OS.g_object_ref(object.handle);
            }
            if (object != null) {
                object.index = i2;
                object.parent = this;
                newChildren[i2] = object;
            }
            ++i2;
        }
        if (oldChildren != null) {
            i2 = 0;
            while (i2 < oldChildren.length) {
                AccessibleObject object = oldChildren[i2];
                if (object != null) {
                    OS.g_object_unref(object.handle);
                }
                ++i2;
            }
        }
        this.children = newChildren;
    }
}

