/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleObject;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.accessibility.gtk.ATK;
import org.eclipse.swt.internal.accessibility.gtk.AtkActionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkComponentIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkHypertextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectFactoryClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkSelectionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTableIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkValueIface;
import org.eclipse.swt.internal.gtk.GInterfaceInfo;
import org.eclipse.swt.internal.gtk.GObjectClass;
import org.eclipse.swt.internal.gtk.GTypeInfo;
import org.eclipse.swt.internal.gtk.GTypeQuery;
import org.eclipse.swt.internal.gtk.OS;

class AccessibleFactory {
    static final Hashtable Accessibles = new Hashtable(9);
    static final Hashtable Factories = new Hashtable(9);
    static final String SWT_TYPE_PREFIX = "SWTAccessible";
    static final String CHILD_TYPENAME = "Child";
    static final String FACTORY_TYPENAME = "SWTFactory";
    static final int[] actionRoles = new int[]{44, 46, 30, 12, 43, 45, 62};
    static final int[] hypertextRoles = new int[]{30};
    static final int[] selectionRoles = new int[]{33, 60, 24, 35};
    static final int[] textRoles = new int[]{46, 30, 41, 42};
    static final int[] tableRoles = new int[]{24, 35};
    static final int[] valueRoles = new int[]{3, 52, 48};
    static final Callback AtkActionCB_do_action;
    static final Callback AtkActionCB_get_n_actions;
    static final Callback AtkActionCB_get_description;
    static final Callback AtkActionCB_get_keybinding;
    static final Callback AtkActionCB_get_name;
    static final Callback AtkComponentCB_get_extents;
    static final Callback AtkComponentCB_get_position;
    static final Callback AtkComponentCB_get_size;
    static final Callback AtkComponentCB_ref_accessible_at_point;
    static final Callback AtkHypertextCB_get_link;
    static final Callback AtkHypertextCB_get_n_links;
    static final Callback AtkHypertextCB_get_link_index;
    static final Callback AtkObjectCB_get_description;
    static final Callback AtkObjectCB_get_index_in_parent;
    static final Callback AtkObjectCB_get_n_children;
    static final Callback AtkObjectCB_get_name;
    static final Callback AtkObjectCB_get_parent;
    static final Callback AtkObjectCB_get_role;
    static final Callback AtkObjectCB_ref_child;
    static final Callback AtkObjectCB_ref_state_set;
    static final Callback AtkSelectionCB_is_child_selected;
    static final Callback AtkSelectionCB_ref_selection;
    static final Callback AtkTableCB_ref_at;
    static final Callback AtkTableCB_get_index_at;
    static final Callback AtkTableCB_get_column_at_index;
    static final Callback AtkTableCB_get_row_at_index;
    static final Callback AtkTableCB_get_n_columns;
    static final Callback AtkTableCB_get_n_rows;
    static final Callback AtkTableCB_get_column_extent_at;
    static final Callback AtkTableCB_get_row_extent_at;
    static final Callback AtkTableCB_get_summary;
    static final Callback AtkTableCB_get_caption;
    static final Callback AtkTableCB_get_column_description;
    static final Callback AtkTableCB_get_row_description;
    static final Callback AtkTableCB_get_column_header;
    static final Callback AtkTableCB_get_row_header;
    static final Callback AtkTableCB_get_selected_columns;
    static final Callback AtkTableCB_get_selected_rows;
    static final Callback AtkTableCB_is_column_selected;
    static final Callback AtkTableCB_is_row_selected;
    static final Callback AtkTableCB_is_selected;
    static final Callback AtkTableCB_add_column_selection;
    static final Callback AtkTableCB_add_row_selection;
    static final Callback AtkTableCB_remove_column_selection;
    static final Callback AtkTableCB_remove_row_selection;
    static final Callback AtkTextCB_get_character_extents;
    static final Callback AtkTextCB_get_range_extents;
    static final Callback AtkTextCB_get_run_attributes;
    static final Callback AtkTextCB_get_offset_at_point;
    static final Callback AtkTextCB_add_selection;
    static final Callback AtkTextCB_remove_selection;
    static final Callback AtkTextCB_set_selection;
    static final Callback AtkTextCB_get_caret_offset;
    static final Callback AtkTextCB_set_caret_offset;
    static final Callback AtkTextCB_get_n_selections;
    static final Callback AtkTextCB_get_selection;
    static final Callback AtkTextCB_get_text;
    static final Callback AtkTextCB_get_text_after_offset;
    static final Callback AtkTextCB_get_text_at_offset;
    static final Callback AtkTextCB_get_text_before_offset;
    static final Callback AtkTextCB_get_character_at_offset;
    static final Callback AtkTextCB_get_character_count;
    static final Callback AtkTextCB_get_bounded_ranges;
    static final Callback AtkValueCB_get_current_value;
    static final Callback AtkValueCB_get_maximum_value;
    static final Callback AtkValueCB_get_minimum_value;
    static final Callback AtkValueCB_set_current_value;
    static final Callback GObjectClass_finalize;
    static final Callback AtkObjectFactoryCB_create_accessible;
    static final Callback InitActionIfaceCB;
    static final Callback InitComponentIfaceCB;
    static final Callback InitHypertextIfaceCB;
    static final Callback GTypeInfo_base_init_type;
    static final Callback InitSelectionIfaceCB;
    static final Callback InitTableIfaceCB;
    static final Callback InitTextIfaceCB;
    static final Callback InitValueIfaceCB;
    static final Callback GTypeInfo_base_init_factory;
    static final long ActionIfaceDefinition;
    static final long ComponentIfaceDefinition;
    static final long HypertextIfaceDefinition;
    static final long SelectionIfaceDefinition;
    static final long TableIfaceDefinition;
    static final long TextIfaceDefinition;
    static final long ValueIfaceDefinition;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkActionCB_do_action = AccessibleFactory.newCallback(clazz, "atkAction_do_action", 2);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkActionCB_get_n_actions = AccessibleFactory.newCallback(clazz2, "atkAction_get_n_actions", 1);
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkActionCB_get_description = AccessibleFactory.newCallback(clazz3, "atkAction_get_description", 2);
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkActionCB_get_keybinding = AccessibleFactory.newCallback(clazz4, "atkAction_get_keybinding", 2);
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkActionCB_get_name = AccessibleFactory.newCallback(clazz5, "atkAction_get_name", 2);
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkComponentCB_get_extents = AccessibleFactory.newCallback(clazz6, "atkComponent_get_extents", 6);
        Class<?> clazz7 = class$0;
        if (clazz7 == null) {
            try {
                clazz7 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkComponentCB_get_position = AccessibleFactory.newCallback(clazz7, "atkComponent_get_position", 4);
        Class<?> clazz8 = class$0;
        if (clazz8 == null) {
            try {
                clazz8 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkComponentCB_get_size = AccessibleFactory.newCallback(clazz8, "atkComponent_get_size", 4);
        Class<?> clazz9 = class$0;
        if (clazz9 == null) {
            try {
                clazz9 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkComponentCB_ref_accessible_at_point = AccessibleFactory.newCallback(clazz9, "atkComponent_ref_accessible_at_point", 4);
        Class<?> clazz10 = class$0;
        if (clazz10 == null) {
            try {
                clazz10 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkHypertextCB_get_link = AccessibleFactory.newCallback(clazz10, "atkHypertext_get_link", 2);
        Class<?> clazz11 = class$0;
        if (clazz11 == null) {
            try {
                clazz11 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkHypertextCB_get_n_links = AccessibleFactory.newCallback(clazz11, "atkHypertext_get_n_links", 1);
        Class<?> clazz12 = class$0;
        if (clazz12 == null) {
            try {
                clazz12 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkHypertextCB_get_link_index = AccessibleFactory.newCallback(clazz12, "atkHypertext_get_link_index", 2);
        Class<?> clazz13 = class$0;
        if (clazz13 == null) {
            try {
                clazz13 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkObjectCB_get_name = AccessibleFactory.newCallback(clazz13, "atkObject_get_name", 1);
        Class<?> clazz14 = class$0;
        if (clazz14 == null) {
            try {
                clazz14 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkObjectCB_get_description = AccessibleFactory.newCallback(clazz14, "atkObject_get_description", 1);
        Class<?> clazz15 = class$0;
        if (clazz15 == null) {
            try {
                clazz15 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkObjectCB_get_n_children = AccessibleFactory.newCallback(clazz15, "atkObject_get_n_children", 1);
        Class<?> clazz16 = class$0;
        if (clazz16 == null) {
            try {
                clazz16 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkObjectCB_get_role = AccessibleFactory.newCallback(clazz16, "atkObject_get_role", 1);
        Class<?> clazz17 = class$0;
        if (clazz17 == null) {
            try {
                clazz17 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkObjectCB_get_parent = AccessibleFactory.newCallback(clazz17, "atkObject_get_parent", 1);
        Class<?> clazz18 = class$0;
        if (clazz18 == null) {
            try {
                clazz18 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkObjectCB_ref_state_set = AccessibleFactory.newCallback(clazz18, "atkObject_ref_state_set", 1);
        Class<?> clazz19 = class$0;
        if (clazz19 == null) {
            try {
                clazz19 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkObjectCB_get_index_in_parent = AccessibleFactory.newCallback(clazz19, "atkObject_get_index_in_parent", 1);
        Class<?> clazz20 = class$0;
        if (clazz20 == null) {
            try {
                clazz20 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkObjectCB_ref_child = AccessibleFactory.newCallback(clazz20, "atkObject_ref_child", 2);
        Class<?> clazz21 = class$0;
        if (clazz21 == null) {
            try {
                clazz21 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkSelectionCB_is_child_selected = AccessibleFactory.newCallback(clazz21, "atkSelection_is_child_selected", 2);
        Class<?> clazz22 = class$0;
        if (clazz22 == null) {
            try {
                clazz22 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkSelectionCB_ref_selection = AccessibleFactory.newCallback(clazz22, "atkSelection_ref_selection", 2);
        Class<?> clazz23 = class$0;
        if (clazz23 == null) {
            try {
                clazz23 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_ref_at = AccessibleFactory.newCallback(clazz23, "atkTable_ref_at", 3);
        Class<?> clazz24 = class$0;
        if (clazz24 == null) {
            try {
                clazz24 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_get_index_at = AccessibleFactory.newCallback(clazz24, "atkTable_get_index_at", 3);
        Class<?> clazz25 = class$0;
        if (clazz25 == null) {
            try {
                clazz25 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_get_column_at_index = AccessibleFactory.newCallback(clazz25, "atkTable_get_column_at_index", 2);
        Class<?> clazz26 = class$0;
        if (clazz26 == null) {
            try {
                clazz26 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_get_row_at_index = AccessibleFactory.newCallback(clazz26, "atkTable_get_row_at_index", 2);
        Class<?> clazz27 = class$0;
        if (clazz27 == null) {
            try {
                clazz27 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_get_n_columns = AccessibleFactory.newCallback(clazz27, "atkTable_get_n_columns", 1);
        Class<?> clazz28 = class$0;
        if (clazz28 == null) {
            try {
                clazz28 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_get_n_rows = AccessibleFactory.newCallback(clazz28, "atkTable_get_n_rows", 1);
        Class<?> clazz29 = class$0;
        if (clazz29 == null) {
            try {
                clazz29 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_get_column_extent_at = AccessibleFactory.newCallback(clazz29, "atkTable_get_column_extent_at", 3);
        Class<?> clazz30 = class$0;
        if (clazz30 == null) {
            try {
                clazz30 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_get_row_extent_at = AccessibleFactory.newCallback(clazz30, "atkTable_get_row_extent_at", 3);
        Class<?> clazz31 = class$0;
        if (clazz31 == null) {
            try {
                clazz31 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_get_caption = AccessibleFactory.newCallback(clazz31, "atkTable_get_caption", 1);
        Class<?> clazz32 = class$0;
        if (clazz32 == null) {
            try {
                clazz32 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_get_summary = AccessibleFactory.newCallback(clazz32, "atkTable_get_summary", 1);
        Class<?> clazz33 = class$0;
        if (clazz33 == null) {
            try {
                clazz33 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_get_column_description = AccessibleFactory.newCallback(clazz33, "atkTable_get_column_description", 2);
        Class<?> clazz34 = class$0;
        if (clazz34 == null) {
            try {
                clazz34 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_get_row_description = AccessibleFactory.newCallback(clazz34, "atkTable_get_row_description", 2);
        Class<?> clazz35 = class$0;
        if (clazz35 == null) {
            try {
                clazz35 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_get_column_header = AccessibleFactory.newCallback(clazz35, "atkTable_get_column_header", 2);
        Class<?> clazz36 = class$0;
        if (clazz36 == null) {
            try {
                clazz36 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_get_row_header = AccessibleFactory.newCallback(clazz36, "atkTable_get_row_header", 2);
        Class<?> clazz37 = class$0;
        if (clazz37 == null) {
            try {
                clazz37 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_get_selected_columns = AccessibleFactory.newCallback(clazz37, "atkTable_get_selected_columns", 2);
        Class<?> clazz38 = class$0;
        if (clazz38 == null) {
            try {
                clazz38 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_get_selected_rows = AccessibleFactory.newCallback(clazz38, "atkTable_get_selected_rows", 2);
        Class<?> clazz39 = class$0;
        if (clazz39 == null) {
            try {
                clazz39 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_is_column_selected = AccessibleFactory.newCallback(clazz39, "atkTable_is_column_selected", 2);
        Class<?> clazz40 = class$0;
        if (clazz40 == null) {
            try {
                clazz40 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_is_row_selected = AccessibleFactory.newCallback(clazz40, "atkTable_is_row_selected", 2);
        Class<?> clazz41 = class$0;
        if (clazz41 == null) {
            try {
                clazz41 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_is_selected = AccessibleFactory.newCallback(clazz41, "atkTable_is_selected", 3);
        Class<?> clazz42 = class$0;
        if (clazz42 == null) {
            try {
                clazz42 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_add_column_selection = AccessibleFactory.newCallback(clazz42, "atkTable_add_column_selection", 2);
        Class<?> clazz43 = class$0;
        if (clazz43 == null) {
            try {
                clazz43 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_add_row_selection = AccessibleFactory.newCallback(clazz43, "atkTable_add_row_selection", 2);
        Class<?> clazz44 = class$0;
        if (clazz44 == null) {
            try {
                clazz44 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_remove_column_selection = AccessibleFactory.newCallback(clazz44, "atkTable_remove_column_selection", 2);
        Class<?> clazz45 = class$0;
        if (clazz45 == null) {
            try {
                clazz45 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTableCB_remove_row_selection = AccessibleFactory.newCallback(clazz45, "atkTable_remove_row_selection", 2);
        Class<?> clazz46 = class$0;
        if (clazz46 == null) {
            try {
                clazz46 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_character_extents = AccessibleFactory.newCallback(clazz46, "atkText_get_character_extents", 7);
        Class<?> clazz47 = class$0;
        if (clazz47 == null) {
            try {
                clazz47 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_range_extents = AccessibleFactory.newCallback(clazz47, "atkText_get_range_extents", 5);
        Class<?> clazz48 = class$0;
        if (clazz48 == null) {
            try {
                clazz48 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_run_attributes = AccessibleFactory.newCallback(clazz48, "atkText_get_run_attributes", 4);
        Class<?> clazz49 = class$0;
        if (clazz49 == null) {
            try {
                clazz49 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_offset_at_point = AccessibleFactory.newCallback(clazz49, "atkText_get_offset_at_point", 4);
        Class<?> clazz50 = class$0;
        if (clazz50 == null) {
            try {
                clazz50 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_add_selection = AccessibleFactory.newCallback(clazz50, "atkText_add_selection", 3);
        Class<?> clazz51 = class$0;
        if (clazz51 == null) {
            try {
                clazz51 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_remove_selection = AccessibleFactory.newCallback(clazz51, "atkText_remove_selection", 2);
        Class<?> clazz52 = class$0;
        if (clazz52 == null) {
            try {
                clazz52 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_set_selection = AccessibleFactory.newCallback(clazz52, "atkText_set_selection", 4);
        Class<?> clazz53 = class$0;
        if (clazz53 == null) {
            try {
                clazz53 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_caret_offset = AccessibleFactory.newCallback(clazz53, "atkText_get_caret_offset", 1);
        Class<?> clazz54 = class$0;
        if (clazz54 == null) {
            try {
                clazz54 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_set_caret_offset = AccessibleFactory.newCallback(clazz54, "atkText_set_caret_offset", 2);
        Class<?> clazz55 = class$0;
        if (clazz55 == null) {
            try {
                clazz55 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_n_selections = AccessibleFactory.newCallback(clazz55, "atkText_get_n_selections", 1);
        Class<?> clazz56 = class$0;
        if (clazz56 == null) {
            try {
                clazz56 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_selection = AccessibleFactory.newCallback(clazz56, "atkText_get_selection", 4);
        Class<?> clazz57 = class$0;
        if (clazz57 == null) {
            try {
                clazz57 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_text = AccessibleFactory.newCallback(clazz57, "atkText_get_text", 3);
        Class<?> clazz58 = class$0;
        if (clazz58 == null) {
            try {
                clazz58 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_text_after_offset = AccessibleFactory.newCallback(clazz58, "atkText_get_text_after_offset", 5);
        Class<?> clazz59 = class$0;
        if (clazz59 == null) {
            try {
                clazz59 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_text_at_offset = AccessibleFactory.newCallback(clazz59, "atkText_get_text_at_offset", 5);
        Class<?> clazz60 = class$0;
        if (clazz60 == null) {
            try {
                clazz60 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_text_before_offset = AccessibleFactory.newCallback(clazz60, "atkText_get_text_before_offset", 5);
        Class<?> clazz61 = class$0;
        if (clazz61 == null) {
            try {
                clazz61 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_character_at_offset = AccessibleFactory.newCallback(clazz61, "atkText_get_character_at_offset", 2);
        Class<?> clazz62 = class$0;
        if (clazz62 == null) {
            try {
                clazz62 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_character_count = AccessibleFactory.newCallback(clazz62, "atkText_get_character_count", 1);
        Class<?> clazz63 = class$0;
        if (clazz63 == null) {
            try {
                clazz63 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_bounded_ranges = AccessibleFactory.newCallback(clazz63, "atkText_get_bounded_ranges", 5);
        Class<?> clazz64 = class$0;
        if (clazz64 == null) {
            try {
                clazz64 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkValueCB_get_current_value = AccessibleFactory.newCallback(clazz64, "atkValue_get_current_value", 2);
        Class<?> clazz65 = class$0;
        if (clazz65 == null) {
            try {
                clazz65 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkValueCB_get_maximum_value = AccessibleFactory.newCallback(clazz65, "atkValue_get_maximum_value", 2);
        Class<?> clazz66 = class$0;
        if (clazz66 == null) {
            try {
                clazz66 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkValueCB_get_minimum_value = AccessibleFactory.newCallback(clazz66, "atkValue_get_minimum_value", 2);
        Class<?> clazz67 = class$0;
        if (clazz67 == null) {
            try {
                clazz67 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkValueCB_set_current_value = AccessibleFactory.newCallback(clazz67, "atkValue_set_current_value", 2);
        Class<?> clazz68 = class$0;
        if (clazz68 == null) {
            try {
                clazz68 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GObjectClass_finalize = AccessibleFactory.newCallback(clazz68, "gObjectClass_finalize", 1);
        Class<?> clazz69 = class$1;
        if (clazz69 == null) {
            try {
                clazz69 = class$1 = Class.forName("org.eclipse.swt.accessibility.AccessibleFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GTypeInfo_base_init_type = AccessibleFactory.newCallback(clazz69, "gTypeInfo_base_init_type", 1);
        Class<?> clazz70 = class$1;
        if (clazz70 == null) {
            try {
                clazz70 = class$1 = Class.forName("org.eclipse.swt.accessibility.AccessibleFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GTypeInfo_base_init_factory = AccessibleFactory.newCallback(clazz70, "gTypeInfo_base_init_factory", 1);
        Class<?> clazz71 = class$1;
        if (clazz71 == null) {
            try {
                clazz71 = class$1 = Class.forName("org.eclipse.swt.accessibility.AccessibleFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkObjectFactoryCB_create_accessible = AccessibleFactory.newCallback(clazz71, "atkObjectFactory_create_accessible", 1);
        Class<?> clazz72 = class$1;
        if (clazz72 == null) {
            try {
                clazz72 = class$1 = Class.forName("org.eclipse.swt.accessibility.AccessibleFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InitActionIfaceCB = AccessibleFactory.newCallback(clazz72, "initActionIfaceCB", 1);
        GInterfaceInfo interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitActionIfaceCB.getAddress();
        ActionIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(ActionIfaceDefinition, interfaceInfo, GInterfaceInfo.sizeof);
        Class<?> clazz73 = class$1;
        if (clazz73 == null) {
            try {
                clazz73 = class$1 = Class.forName("org.eclipse.swt.accessibility.AccessibleFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InitComponentIfaceCB = AccessibleFactory.newCallback(clazz73, "initComponentIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitComponentIfaceCB.getAddress();
        ComponentIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(ComponentIfaceDefinition, interfaceInfo, GInterfaceInfo.sizeof);
        Class<?> clazz74 = class$1;
        if (clazz74 == null) {
            try {
                clazz74 = class$1 = Class.forName("org.eclipse.swt.accessibility.AccessibleFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InitHypertextIfaceCB = AccessibleFactory.newCallback(clazz74, "initHypertextIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitHypertextIfaceCB.getAddress();
        HypertextIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(HypertextIfaceDefinition, interfaceInfo, GInterfaceInfo.sizeof);
        Class<?> clazz75 = class$1;
        if (clazz75 == null) {
            try {
                clazz75 = class$1 = Class.forName("org.eclipse.swt.accessibility.AccessibleFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InitSelectionIfaceCB = AccessibleFactory.newCallback(clazz75, "initSelectionIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitSelectionIfaceCB.getAddress();
        SelectionIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(SelectionIfaceDefinition, interfaceInfo, GInterfaceInfo.sizeof);
        Class<?> clazz76 = class$1;
        if (clazz76 == null) {
            try {
                clazz76 = class$1 = Class.forName("org.eclipse.swt.accessibility.AccessibleFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InitTableIfaceCB = AccessibleFactory.newCallback(clazz76, "initTableIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitTableIfaceCB.getAddress();
        TableIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(TableIfaceDefinition, interfaceInfo, GInterfaceInfo.sizeof);
        Class<?> clazz77 = class$1;
        if (clazz77 == null) {
            try {
                clazz77 = class$1 = Class.forName("org.eclipse.swt.accessibility.AccessibleFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InitTextIfaceCB = AccessibleFactory.newCallback(clazz77, "initTextIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitTextIfaceCB.getAddress();
        TextIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(TextIfaceDefinition, interfaceInfo, GInterfaceInfo.sizeof);
        Class<?> clazz78 = class$1;
        if (clazz78 == null) {
            try {
                clazz78 = class$1 = Class.forName("org.eclipse.swt.accessibility.AccessibleFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InitValueIfaceCB = AccessibleFactory.newCallback(clazz78, "initValueIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitValueIfaceCB.getAddress();
        ValueIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(ValueIfaceDefinition, interfaceInfo, GInterfaceInfo.sizeof);
    }

    AccessibleFactory() {
    }

    private static Callback newCallback(Object object, String method, int argCount) {
        Callback callback = new Callback(object, method, argCount);
        if (callback.getAddress() == 0L) {
            SWT.error(3);
        }
        return callback;
    }

    static String getTypeName(long type) {
        long typeName = OS.g_type_name(type);
        int widgetTypeNameLength = OS.strlen(typeName);
        byte[] buffer = new byte[widgetTypeNameLength];
        OS.memmove(buffer, typeName, (long)widgetTypeNameLength);
        return new String(Converter.mbcsToWcs(null, buffer));
    }

    static long getParentType(long widgetType) {
        return ((LONG)AccessibleFactory.Factories.get((Object)new LONG((long)widgetType))).value;
    }

    static long atkObjectFactory_create_accessible(long widget) {
        AccessibleObject object;
        Accessible accessible = (Accessible)Accessibles.get(new LONG(widget));
        if (accessible == null) {
            long result = OS.g_object_new(AccessibleFactory.getParentType(OS.G_OBJECT_TYPE(widget)), 0L);
            ATK.atk_object_initialize(result, widget);
            return result;
        }
        if (accessible.accessibleObject != null) {
            return accessible.accessibleObject.handle;
        }
        long widgetType = OS.G_OBJECT_TYPE(widget);
        long parentType = AccessibleFactory.getParentType(widgetType);
        if (parentType == 0L) {
            parentType = ATK.GTK_TYPE_ACCESSIBLE();
        }
        long type = AccessibleFactory.getType(AccessibleFactory.getTypeName(widgetType), accessible, parentType, -1);
        accessible.accessibleObject = object = new AccessibleObject(type, widget, accessible, false);
        accessible.addRelations();
        return object.handle;
    }

    static AccessibleObject createChildAccessible(Accessible accessible, int childId) {
        long childType = AccessibleFactory.getType(CHILD_TYPENAME, accessible, ATK.GTK_TYPE_ACCESSIBLE(), childId);
        return new AccessibleObject(childType, 0L, accessible, true);
    }

    static void createAccessible(Accessible accessible) {
        long controlHandle = accessible.getControlHandle();
        long widgetType = OS.G_OBJECT_TYPE(controlHandle);
        long registry = ATK.atk_get_default_registry();
        long factory = ATK.atk_registry_get_factory(registry, widgetType);
        ATK.atk_object_factory_create_accessible(factory, controlHandle);
    }

    static long getType(String widgetTypeName, Accessible accessible, long parentType, int childId) {
        byte[] nameBytes;
        long type;
        AccessibleControlEvent event = new AccessibleControlEvent(accessible);
        event.childID = childId;
        Vector listeners = accessible.accessibleControlListeners;
        int i = 0;
        int length = listeners.size();
        while (i < length) {
            AccessibleControlListener listener = (AccessibleControlListener)listeners.elementAt(i);
            listener.getRole(event);
            ++i;
        }
        boolean action = false;
        boolean hypertext = false;
        boolean selection = false;
        boolean table = false;
        boolean text = false;
        boolean value = false;
        if (event.detail != 0) {
            int i2 = 0;
            while (i2 < actionRoles.length) {
                if (event.detail == actionRoles[i2]) {
                    action = true;
                    break;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < hypertextRoles.length) {
                if (event.detail == hypertextRoles[i2]) {
                    hypertext = true;
                    break;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < selectionRoles.length) {
                if (event.detail == selectionRoles[i2]) {
                    selection = true;
                    break;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < tableRoles.length) {
                if (event.detail == tableRoles[i2]) {
                    table = true;
                    break;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < textRoles.length) {
                if (event.detail == textRoles[i2]) {
                    text = true;
                    break;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < valueRoles.length) {
                if (event.detail == valueRoles[i2]) {
                    value = true;
                    break;
                }
                ++i2;
            }
        } else {
            value = true;
            text = true;
            table = true;
            selection = true;
            hypertext = true;
            action = true;
        }
        String swtTypeName = SWT_TYPE_PREFIX + widgetTypeName;
        if (action) {
            swtTypeName = String.valueOf(swtTypeName) + "Action";
        }
        if (hypertext) {
            swtTypeName = String.valueOf(swtTypeName) + "Hypertext";
        }
        if (selection) {
            swtTypeName = String.valueOf(swtTypeName) + "Selection";
        }
        if (table) {
            swtTypeName = String.valueOf(swtTypeName) + "Table";
        }
        if (text) {
            swtTypeName = String.valueOf(swtTypeName) + "Text";
        }
        if (value) {
            swtTypeName = String.valueOf(swtTypeName) + "Value";
        }
        if ((type = OS.g_type_from_name(nameBytes = Converter.wcsToMbcs(null, swtTypeName, true))) == 0L) {
            if (AccessibleObject.DEBUG) {
                AccessibleObject.print("-->New Type=" + swtTypeName);
            }
            long queryPtr = OS.g_malloc(GTypeQuery.sizeof);
            OS.g_type_query(parentType, queryPtr);
            GTypeQuery query = new GTypeQuery();
            OS.memmove(query, queryPtr, (long)GTypeQuery.sizeof);
            OS.g_free(queryPtr);
            GTypeInfo typeInfo = new GTypeInfo();
            typeInfo.base_init = GTypeInfo_base_init_type.getAddress();
            typeInfo.class_size = (short)query.class_size;
            typeInfo.instance_size = (short)query.instance_size;
            long definition = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(definition, typeInfo, GTypeInfo.sizeof);
            type = OS.g_type_register_static(parentType, nameBytes, definition, 0);
            OS.g_type_add_interface_static(type, ATK.ATK_TYPE_COMPONENT(), ComponentIfaceDefinition);
            if (action) {
                OS.g_type_add_interface_static(type, ATK.ATK_TYPE_ACTION(), ActionIfaceDefinition);
            }
            if (hypertext) {
                OS.g_type_add_interface_static(type, ATK.ATK_TYPE_HYPERTEXT(), HypertextIfaceDefinition);
            }
            if (selection) {
                OS.g_type_add_interface_static(type, ATK.ATK_TYPE_SELECTION(), SelectionIfaceDefinition);
            }
            if (table) {
                OS.g_type_add_interface_static(type, ATK.ATK_TYPE_TABLE(), TableIfaceDefinition);
            }
            if (text) {
                OS.g_type_add_interface_static(type, ATK.ATK_TYPE_TEXT(), TextIfaceDefinition);
            }
            if (value) {
                OS.g_type_add_interface_static(type, ATK.ATK_TYPE_VALUE(), ValueIfaceDefinition);
            }
        }
        return type;
    }

    static long gTypeInfo_base_init_factory(long klass) {
        AtkObjectFactoryClass objectClass = new AtkObjectFactoryClass();
        ATK.memmove(objectClass, klass);
        objectClass.create_accessible = AtkObjectFactoryCB_create_accessible.getAddress();
        ATK.memmove(klass, objectClass);
        return 0L;
    }

    static long gTypeInfo_base_init_type(long klass) {
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove(objectClass, klass);
        objectClass.get_name = AtkObjectCB_get_name.getAddress();
        objectClass.get_description = AtkObjectCB_get_description.getAddress();
        objectClass.get_n_children = AtkObjectCB_get_n_children.getAddress();
        objectClass.get_role = AtkObjectCB_get_role.getAddress();
        objectClass.get_parent = AtkObjectCB_get_parent.getAddress();
        objectClass.ref_state_set = AtkObjectCB_ref_state_set.getAddress();
        objectClass.get_index_in_parent = AtkObjectCB_get_index_in_parent.getAddress();
        objectClass.ref_child = AtkObjectCB_ref_child.getAddress();
        long gObjectClass = OS.G_OBJECT_CLASS(klass);
        GObjectClass objectClassStruct = new GObjectClass();
        OS.memmove(objectClassStruct, gObjectClass);
        objectClassStruct.finalize = GObjectClass_finalize.getAddress();
        OS.memmove(gObjectClass, objectClassStruct);
        ATK.memmove(klass, objectClass);
        return 0L;
    }

    static long initActionIfaceCB(long iface) {
        AtkActionIface inter = new AtkActionIface();
        ATK.memmove(inter, iface);
        inter.do_action = AtkActionCB_do_action.getAddress();
        inter.get_n_actions = AtkActionCB_get_n_actions.getAddress();
        inter.get_description = AtkActionCB_get_description.getAddress();
        inter.get_keybinding = AtkActionCB_get_keybinding.getAddress();
        inter.get_name = AtkActionCB_get_name.getAddress();
        ATK.memmove(iface, inter);
        return 0L;
    }

    static long initComponentIfaceCB(long iface) {
        AtkComponentIface inter = new AtkComponentIface();
        ATK.memmove(inter, iface);
        inter.get_extents = AtkComponentCB_get_extents.getAddress();
        inter.get_position = AtkComponentCB_get_position.getAddress();
        inter.get_size = AtkComponentCB_get_size.getAddress();
        inter.ref_accessible_at_point = AtkComponentCB_ref_accessible_at_point.getAddress();
        ATK.memmove(iface, inter);
        return 0L;
    }

    static long initHypertextIfaceCB(long iface) {
        AtkHypertextIface inter = new AtkHypertextIface();
        ATK.memmove(inter, iface);
        inter.get_link = AtkHypertextCB_get_link.getAddress();
        inter.get_link_index = AtkHypertextCB_get_link_index.getAddress();
        inter.get_n_links = AtkHypertextCB_get_n_links.getAddress();
        ATK.memmove(iface, inter);
        return 0L;
    }

    static long initSelectionIfaceCB(long iface) {
        AtkSelectionIface inter = new AtkSelectionIface();
        ATK.memmove(inter, iface);
        inter.is_child_selected = AtkSelectionCB_is_child_selected.getAddress();
        inter.ref_selection = AtkSelectionCB_ref_selection.getAddress();
        ATK.memmove(iface, inter);
        return 0L;
    }

    static long initTableIfaceCB(long iface) {
        AtkTableIface inter = new AtkTableIface();
        ATK.memmove(inter, iface);
        inter.ref_at = AtkTableCB_ref_at.getAddress();
        inter.get_index_at = AtkTableCB_get_index_at.getAddress();
        inter.get_column_at_index = AtkTableCB_get_column_at_index.getAddress();
        inter.get_row_at_index = AtkTableCB_get_row_at_index.getAddress();
        inter.get_n_columns = AtkTableCB_get_n_columns.getAddress();
        inter.get_n_rows = AtkTableCB_get_n_rows.getAddress();
        inter.get_column_extent_at = AtkTableCB_get_column_extent_at.getAddress();
        inter.get_row_extent_at = AtkTableCB_get_row_extent_at.getAddress();
        inter.get_caption = AtkTableCB_get_caption.getAddress();
        inter.get_summary = AtkTableCB_get_summary.getAddress();
        inter.get_column_description = AtkTableCB_get_column_description.getAddress();
        inter.get_row_description = AtkTableCB_get_row_description.getAddress();
        inter.get_column_header = AtkTableCB_get_column_header.getAddress();
        inter.get_row_header = AtkTableCB_get_row_header.getAddress();
        inter.get_selected_columns = AtkTableCB_get_selected_columns.getAddress();
        inter.get_selected_rows = AtkTableCB_get_selected_rows.getAddress();
        inter.is_column_selected = AtkTableCB_is_column_selected.getAddress();
        inter.is_row_selected = AtkTableCB_is_row_selected.getAddress();
        inter.is_selected = AtkTableCB_is_selected.getAddress();
        inter.add_column_selection = AtkTableCB_add_column_selection.getAddress();
        inter.add_row_selection = AtkTableCB_add_row_selection.getAddress();
        inter.remove_column_selection = AtkTableCB_remove_column_selection.getAddress();
        inter.remove_row_selection = AtkTableCB_remove_row_selection.getAddress();
        ATK.memmove(iface, inter);
        return 0L;
    }

    static long initTextIfaceCB(long iface) {
        AtkTextIface inter = new AtkTextIface();
        ATK.memmove(inter, iface);
        inter.get_range_extents = AtkTextCB_get_range_extents.getAddress();
        inter.get_character_extents = AtkTextCB_get_character_extents.getAddress();
        inter.get_run_attributes = AtkTextCB_get_run_attributes.getAddress();
        inter.get_offset_at_point = AtkTextCB_get_offset_at_point.getAddress();
        inter.add_selection = AtkTextCB_add_selection.getAddress();
        inter.remove_selection = AtkTextCB_remove_selection.getAddress();
        inter.set_selection = AtkTextCB_set_selection.getAddress();
        inter.get_caret_offset = AtkTextCB_get_caret_offset.getAddress();
        inter.set_caret_offset = AtkTextCB_set_caret_offset.getAddress();
        inter.get_character_at_offset = AtkTextCB_get_character_at_offset.getAddress();
        inter.get_character_count = AtkTextCB_get_character_count.getAddress();
        inter.get_n_selections = AtkTextCB_get_n_selections.getAddress();
        inter.get_selection = AtkTextCB_get_selection.getAddress();
        inter.get_text = AtkTextCB_get_text.getAddress();
        inter.get_text_after_offset = AtkTextCB_get_text_after_offset.getAddress();
        inter.get_text_at_offset = AtkTextCB_get_text_at_offset.getAddress();
        inter.get_text_before_offset = AtkTextCB_get_text_before_offset.getAddress();
        inter.get_bounded_ranges = AtkTextCB_get_bounded_ranges.getAddress();
        ATK.memmove(iface, inter);
        return 0L;
    }

    static long initValueIfaceCB(long iface) {
        AtkValueIface inter = new AtkValueIface();
        ATK.memmove(inter, iface);
        inter.get_current_value = AtkValueCB_get_current_value.getAddress();
        inter.get_maximum_value = AtkValueCB_get_maximum_value.getAddress();
        inter.get_minimum_value = AtkValueCB_get_minimum_value.getAddress();
        inter.set_current_value = AtkValueCB_set_current_value.getAddress();
        ATK.memmove(iface, inter);
        return 0L;
    }

    static void registerAccessible(Accessible accessible) {
        long widget = accessible.getControlHandle();
        long widgetType = OS.G_OBJECT_TYPE(widget);
        long registry = ATK.atk_get_default_registry();
        long factory = ATK.atk_registry_get_factory(registry, widgetType);
        if (ATK.ATK_IS_NO_OP_OBJECT_FACTORY(factory)) {
            return;
        }
        String name = FACTORY_TYPENAME + AccessibleFactory.getTypeName(widgetType);
        byte[] factoryName = Converter.wcsToMbcs(null, name, true);
        if (OS.g_type_from_name(factoryName) == 0L) {
            if (AccessibleObject.DEBUG) {
                AccessibleObject.print("-->New Factory=" + name);
            }
            GTypeInfo typeInfo = new GTypeInfo();
            typeInfo.base_init = GTypeInfo_base_init_factory.getAddress();
            typeInfo.class_size = (short)ATK.AtkObjectFactoryClass_sizeof();
            typeInfo.instance_size = (short)ATK.AtkObjectFactory_sizeof();
            long info = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(info, typeInfo, GTypeInfo.sizeof);
            long swtFactoryType = OS.g_type_register_static(ATK.ATK_TYPE_OBJECT_FACTORY(), factoryName, info, 0);
            long parentType = ATK.atk_object_factory_get_accessible_type(factory);
            ATK.atk_registry_set_factory_type(registry, widgetType, swtFactoryType);
            Factories.put(new LONG(widgetType), new LONG(parentType));
        }
        if (AccessibleObject.DEBUG) {
            AccessibleObject.print("-->Register=" + accessible.control + " " + widget);
        }
        Accessibles.put(new LONG(widget), accessible);
    }

    static void unregisterAccessible(Accessible accessible) {
        long widget = accessible.getControlHandle();
        Accessibles.remove(new LONG(widget));
        if (AccessibleObject.DEBUG) {
            AccessibleObject.print("-->Deregister=" + accessible.control + " " + widget);
        }
    }
}

