/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkGCValues;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;
import org.eclipse.swt.internal.gtk.PangoItem;
import org.eclipse.swt.internal.gtk.PangoLayoutLine;
import org.eclipse.swt.internal.gtk.PangoLayoutRun;
import org.eclipse.swt.internal.gtk.PangoLogAttr;
import org.eclipse.swt.internal.gtk.PangoRectangle;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    int ascent;
    int descent;
    int indent;
    int wrapIndent;
    int wrapWidth;
    int[] segments;
    char[] segmentsChars;
    int[] tabs;
    StyleItem[] styles;
    int stylesCount;
    long layout;
    long context;
    long attrList;
    int[] invalidOffsets;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final char ZWS = '\u200b';
    static final char ZWNBS = '\ufeff';

    public TextLayout(Device device) {
        super(device);
        device = this.device;
        this.context = OS.gdk_pango_context_get();
        if (this.context == 0L) {
            SWT.error(2);
        }
        OS.pango_context_set_language(this.context, OS.gtk_get_default_language());
        OS.pango_context_set_base_dir(this.context, 0);
        OS.gdk_pango_context_set_colormap(this.context, OS.gdk_colormap_get_system());
        this.layout = OS.pango_layout_new(this.context);
        if (this.layout == 0L) {
            SWT.error(2);
        }
        OS.pango_layout_set_font_description(this.layout, device.systemFont.handle);
        OS.pango_layout_set_wrap(this.layout, 2);
        OS.pango_layout_set_tabs(this.layout, device.emptyTab);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.pango_layout_set_auto_dir(this.layout, false);
        }
        this.text = "";
        this.descent = -1;
        this.ascent = -1;
        this.wrapWidth = -1;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.stylesCount = 2;
        this.init();
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns() {
        int nSegments;
        if (this.attrList != 0L) {
            return;
        }
        String segmentsText = this.getSegmentsText();
        byte[] buffer = Converter.wcsToMbcs(null, segmentsText, false);
        OS.pango_layout_set_text(this.layout, buffer, buffer.length);
        if (this.stylesCount == 2 && this.styles[0].style == null && this.ascent == -1 && this.descent == -1 && this.segments == null) {
            return;
        }
        long ptr = OS.pango_layout_get_text(this.layout);
        this.attrList = OS.pango_attr_list_new();
        PangoAttribute attribute = new PangoAttribute();
        char[] chars = null;
        int segementsLength = segmentsText.length();
        int offsetCount = nSegments = segementsLength - this.text.length();
        if ((this.ascent != -1 || this.descent != -1) && segementsLength > 0) {
            PangoRectangle rect = new PangoRectangle();
            if (this.ascent != -1) {
                rect.y = -(this.ascent * 1024);
            }
            rect.height = (Math.max(0, this.ascent) + Math.max(0, this.descent)) * 1024;
            int lineCount = OS.pango_layout_get_line_count(this.layout);
            chars = new char[segementsLength + lineCount * 2];
            int oldPos = 0;
            int lineIndex = 0;
            PangoLayoutLine line = new PangoLayoutLine();
            while (lineIndex < lineCount) {
                long linePtr = OS.pango_layout_get_line(this.layout, lineIndex);
                OS.memmove(line, linePtr, (long)PangoLayoutLine.sizeof);
                int bytePos = line.start_index;
                int offset = lineIndex * 6;
                long attr = OS.pango_attr_shape_new(rect, rect);
                OS.memmove(attribute, attr, (long)PangoAttribute.sizeof);
                attribute.start_index = bytePos + offset;
                attribute.end_index = bytePos + offset + 3;
                OS.memmove(attr, attribute, (long)PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, attr);
                attr = OS.pango_attr_shape_new(rect, rect);
                OS.memmove(attribute, attr, (long)PangoAttribute.sizeof);
                attribute.start_index = bytePos + offset + 3;
                attribute.end_index = bytePos + offset + 6;
                OS.memmove(attr, attribute, (long)PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, attr);
                int pos = (int)OS.g_utf8_pointer_to_offset(ptr, ptr + (long)bytePos);
                chars[pos + lineIndex * 2] = 8203;
                chars[pos + lineIndex * 2 + 1] = 65279;
                segmentsText.getChars(oldPos, pos, chars, oldPos + lineIndex * 2);
                oldPos = pos;
                ++lineIndex;
            }
            segmentsText.getChars(oldPos, segementsLength, chars, oldPos + lineIndex * 2);
            buffer = Converter.wcsToMbcs(null, chars, false);
            OS.pango_layout_set_text(this.layout, buffer, buffer.length);
            ptr = OS.pango_layout_get_text(this.layout);
            offsetCount += 2 * lineCount;
        } else {
            chars = new char[segementsLength];
            segmentsText.getChars(0, segementsLength, chars, 0);
        }
        this.invalidOffsets = new int[offsetCount];
        if (offsetCount > 0) {
            offsetCount = 0;
            int segmentCount = 0;
            int i = 0;
            while (i < chars.length) {
                char c = chars[i];
                if (c == '\ufeff' || c == '\u200b') {
                    this.invalidOffsets[offsetCount++] = i;
                } else if (segmentCount < nSegments && i - offsetCount == this.segments[segmentCount]) {
                    this.invalidOffsets[offsetCount++] = i;
                    ++segmentCount;
                }
                ++i;
            }
        }
        int strlen = OS.strlen(ptr);
        Font defaultFont = this.font != null ? this.font : this.device.systemFont;
        int i = 0;
        while (i < this.stylesCount - 1) {
            StyleItem styleItem = this.styles[i];
            TextStyle style = styleItem.style;
            if (style != null) {
                int rise;
                long attr;
                GlyphMetrics metrics;
                Color background;
                Color foreground;
                long attr2;
                int start = this.translateOffset(styleItem.start);
                int end = this.translateOffset(this.styles[i + 1].start - 1);
                int byteStart = (int)(OS.g_utf8_offset_to_pointer(ptr, start) - ptr);
                int byteEnd = (int)(OS.g_utf8_offset_to_pointer(ptr, end + 1) - ptr);
                byteStart = Math.min(byteStart, strlen);
                byteEnd = Math.min(byteEnd, strlen);
                Font font = style.font;
                if (font != null && !font.isDisposed() && !defaultFont.equals(font)) {
                    attr2 = OS.pango_attr_font_desc_new(font.handle);
                    OS.memmove(attribute, attr2, (long)PangoAttribute.sizeof);
                    attribute.start_index = byteStart;
                    attribute.end_index = byteEnd;
                    OS.memmove(attr2, attribute, (long)PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, attr2);
                }
                if (style.underline) {
                    int underlineStyle = 0;
                    switch (style.underlineStyle) {
                        case 0: {
                            underlineStyle = 1;
                            break;
                        }
                        case 1: {
                            underlineStyle = 2;
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (OS.GTK_VERSION < OS.VERSION(2, 4, 0)) break;
                            underlineStyle = 4;
                            break;
                        }
                        case 4: {
                            if (style.foreground == null) {
                                long attr3 = OS.pango_attr_foreground_new((short)0, (short)13107, (short)-26215);
                                OS.memmove(attribute, attr3, (long)PangoAttribute.sizeof);
                                attribute.start_index = byteStart;
                                attribute.end_index = byteEnd;
                                OS.memmove(attr3, attribute, (long)PangoAttribute.sizeof);
                                OS.pango_attr_list_insert(this.attrList, attr3);
                            }
                            if (style.underlineColor != null) break;
                            underlineStyle = 1;
                        }
                    }
                    if (underlineStyle != 0 && style.underlineColor == null) {
                        long attr4 = OS.pango_attr_underline_new(underlineStyle);
                        OS.memmove(attribute, attr4, (long)PangoAttribute.sizeof);
                        attribute.start_index = byteStart;
                        attribute.end_index = byteEnd;
                        OS.memmove(attr4, attribute, (long)PangoAttribute.sizeof);
                        OS.pango_attr_list_insert(this.attrList, attr4);
                    }
                }
                if (style.strikeout && style.strikeoutColor == null) {
                    attr2 = OS.pango_attr_strikethrough_new(true);
                    OS.memmove(attribute, attr2, (long)PangoAttribute.sizeof);
                    attribute.start_index = byteStart;
                    attribute.end_index = byteEnd;
                    OS.memmove(attr2, attribute, (long)PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, attr2);
                }
                if ((foreground = style.foreground) != null && !foreground.isDisposed()) {
                    GdkColor fg = foreground.handle;
                    long attr5 = OS.pango_attr_foreground_new(fg.red, fg.green, fg.blue);
                    OS.memmove(attribute, attr5, (long)PangoAttribute.sizeof);
                    attribute.start_index = byteStart;
                    attribute.end_index = byteEnd;
                    OS.memmove(attr5, attribute, (long)PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, attr5);
                }
                if ((background = style.background) != null && !background.isDisposed()) {
                    GdkColor bg = background.handle;
                    long attr6 = OS.pango_attr_background_new(bg.red, bg.green, bg.blue);
                    OS.memmove(attribute, attr6, (long)PangoAttribute.sizeof);
                    attribute.start_index = byteStart;
                    attribute.end_index = byteEnd;
                    OS.memmove(attr6, attribute, (long)PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, attr6);
                }
                if ((metrics = style.metrics) != null) {
                    PangoRectangle rect = new PangoRectangle();
                    rect.y = -(metrics.ascent * 1024);
                    rect.height = (metrics.ascent + metrics.descent) * 1024;
                    rect.width = metrics.width * 1024;
                    attr = OS.pango_attr_shape_new(rect, rect);
                    OS.memmove(attribute, attr, (long)PangoAttribute.sizeof);
                    attribute.start_index = byteStart;
                    attribute.end_index = byteEnd;
                    OS.memmove(attr, attribute, (long)PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, attr);
                }
                if ((rise = style.rise) != 0) {
                    attr = OS.pango_attr_rise_new(rise * 1024);
                    OS.memmove(attribute, attr, (long)PangoAttribute.sizeof);
                    attribute.start_index = byteStart;
                    attribute.end_index = byteEnd;
                    OS.memmove(attr, attribute, (long)PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, attr);
                }
            }
            ++i;
        }
        OS.pango_layout_set_attributes(this.layout, this.attrList);
    }

    int[] computePolyline(int left, int top, int right, int bottom) {
        int length;
        int height = bottom - top;
        int width = 2 * height;
        int peaks = Compatibility.ceil(right - left, width);
        if (peaks == 0 && right - left > 2) {
            peaks = 1;
        }
        if ((length = (2 * peaks + 1) * 2) < 0) {
            return new int[0];
        }
        int[] coordinates = new int[length];
        int i = 0;
        while (i < peaks) {
            int index = 4 * i;
            coordinates[index] = left + width * i;
            coordinates[index + 1] = bottom;
            coordinates[index + 2] = coordinates[index] + width / 2;
            coordinates[index + 3] = top;
            ++i;
        }
        coordinates[length - 2] = left + width * peaks;
        coordinates[length - 1] = bottom;
        return coordinates;
    }

    void destroy() {
        this.font = null;
        this.text = null;
        this.styles = null;
        this.freeRuns();
        this.segments = null;
        this.segmentsChars = null;
        if (this.layout != 0L) {
            OS.g_object_unref(this.layout);
        }
        this.layout = 0L;
        if (this.context != 0L) {
            OS.g_object_unref(this.context);
        }
        this.context = 0L;
    }

    public void draw(GC gc, int x, int y) {
        this.draw(gc, x, y, -1, -1, null, null);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.draw(gc, x, y, selectionStart, selectionEnd, selectionForeground, selectionBackground, 0);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground, int flags) {
        this.checkLayout();
        this.computeRuns();
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        if (selectionForeground != null && selectionForeground.isDisposed()) {
            SWT.error(5);
        }
        if (selectionBackground != null && selectionBackground.isDisposed()) {
            SWT.error(5);
        }
        gc.checkGC(1);
        int length = this.text.length();
        x += Math.min(this.indent, this.wrapIndent);
        boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
        GCData data = gc.data;
        long cairo = data.cairo;
        if (flags != 0 && (hasSelection || (flags & 0x100000) != 0)) {
            long[] attrs = new long[1];
            int[] nAttrs = new int[1];
            PangoLogAttr logAttr = new PangoLogAttr();
            PangoRectangle rect = new PangoRectangle();
            int lineCount = OS.pango_layout_get_line_count(this.layout);
            long ptr = OS.pango_layout_get_text(this.layout);
            long iter = OS.pango_layout_get_iter(this.layout);
            if (selectionBackground == null) {
                selectionBackground = this.device.getSystemColor(26);
            }
            if (cairo != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                Cairo.cairo_save(cairo);
                GdkColor color = selectionBackground.handle;
                Cairo.cairo_set_source_rgba(cairo, (float)(color.red & 0xFFFF) / 65535.0f, (float)(color.green & 0xFFFF) / 65535.0f, (float)(color.blue & 0xFFFF) / 65535.0f, (float)data.alpha / 255.0f);
            } else {
                OS.gdk_gc_set_foreground(gc.handle, selectionBackground.handle);
            }
            int lineIndex = 0;
            do {
                int width;
                int lineEnd;
                OS.pango_layout_iter_get_line_extents(iter, null, rect);
                if (OS.pango_layout_iter_next_line(iter)) {
                    int bytePos = OS.pango_layout_iter_get_index(iter);
                    lineEnd = (int)OS.g_utf8_pointer_to_offset(ptr, ptr + (long)bytePos);
                } else {
                    lineEnd = (int)OS.g_utf8_strlen(ptr, -1L);
                }
                boolean extent = false;
                if (lineIndex == lineCount - 1 && (flags & 0x100000) != 0) {
                    extent = true;
                } else {
                    if (attrs[0] == 0L) {
                        OS.pango_layout_get_log_attrs(this.layout, attrs, nAttrs);
                    }
                    OS.memmove(logAttr, attrs[0] + (long)(lineEnd * PangoLogAttr.sizeof), (long)PangoLogAttr.sizeof);
                    if (!logAttr.is_line_break) {
                        if (selectionStart <= lineEnd && lineEnd <= selectionEnd) {
                            extent = true;
                        }
                    } else if (selectionStart <= lineEnd && lineEnd < selectionEnd && (flags & 0x10000) != 0) {
                        extent = true;
                    }
                }
                if (!extent) continue;
                int lineX = x + OS.PANGO_PIXELS(rect.x) + OS.PANGO_PIXELS(rect.width);
                int lineY = y + OS.PANGO_PIXELS(rect.y);
                int height = OS.PANGO_PIXELS(rect.height);
                if (this.ascent != -1 && this.descent != -1) {
                    height = Math.max(height, this.ascent + this.descent);
                }
                int n = width = (flags & 0x10000) != 0 ? Integer.MAX_VALUE : height / 3;
                if (cairo != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                    Cairo.cairo_rectangle(cairo, lineX, lineY, width, height);
                    Cairo.cairo_fill(cairo);
                    continue;
                }
                OS.gdk_draw_rectangle(data.drawable, gc.handle, 1, lineX, lineY, width, height);
            } while (++lineIndex < lineCount);
            OS.pango_layout_iter_free(iter);
            if (attrs[0] != 0L) {
                OS.g_free(attrs[0]);
            }
            if (cairo != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                Cairo.cairo_restore(cairo);
            } else {
                OS.gdk_gc_set_foreground(gc.handle, data.foreground);
            }
        }
        if (length == 0) {
            return;
        }
        if (!hasSelection) {
            if (cairo != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                if ((data.style & 0x8000000) != 0) {
                    Cairo.cairo_save(cairo);
                    Cairo.cairo_scale(cairo, -1.0, 1.0);
                    Cairo.cairo_translate(cairo, -2 * x - this.width(), 0.0);
                }
                Cairo.cairo_move_to(cairo, x, y);
                OS.pango_cairo_show_layout(cairo, this.layout);
                this.drawBorder(gc, x, y, null);
                if ((data.style & 0x8000000) != 0) {
                    Cairo.cairo_restore(cairo);
                }
            } else {
                OS.gdk_draw_layout(data.drawable, gc.handle, x, y, this.layout);
                this.drawBorder(gc, x, y, null);
            }
        } else {
            boolean fullSelection;
            selectionStart = Math.min(Math.max(0, selectionStart), length - 1);
            selectionEnd = Math.min(Math.max(0, selectionEnd), length - 1);
            length = (int)OS.g_utf8_strlen(OS.pango_layout_get_text(this.layout), -1L);
            selectionStart = this.translateOffset(selectionStart);
            selectionEnd = this.translateOffset(selectionEnd);
            if (selectionForeground == null) {
                selectionForeground = this.device.getSystemColor(27);
            }
            if (selectionBackground == null) {
                selectionBackground = this.device.getSystemColor(26);
            }
            boolean bl = fullSelection = selectionStart == 0 && selectionEnd == length - 1;
            if (fullSelection) {
                if (cairo != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                    long ptr = OS.pango_layout_get_text(this.layout);
                    if ((data.style & 0x8000000) != 0) {
                        Cairo.cairo_save(cairo);
                        Cairo.cairo_scale(cairo, -1.0, 1.0);
                        Cairo.cairo_translate(cairo, -2 * x - this.width(), 0.0);
                    }
                    this.drawWithCairo(gc, x, y, 0, OS.strlen(ptr), fullSelection, selectionForeground.handle, selectionBackground.handle);
                    if ((data.style & 0x8000000) != 0) {
                        Cairo.cairo_restore(cairo);
                    }
                } else {
                    OS.gdk_draw_layout_with_colors(data.drawable, gc.handle, x, y, this.layout, selectionForeground.handle, selectionBackground.handle);
                    this.drawBorder(gc, x, y, selectionForeground.handle);
                }
            } else {
                long ptr = OS.pango_layout_get_text(this.layout);
                int byteSelStart = (int)(OS.g_utf8_offset_to_pointer(ptr, selectionStart) - ptr);
                int byteSelEnd = (int)(OS.g_utf8_offset_to_pointer(ptr, selectionEnd + 1) - ptr);
                int strlen = OS.strlen(ptr);
                byteSelStart = Math.min(byteSelStart, strlen);
                byteSelEnd = Math.min(byteSelEnd, strlen);
                if (cairo != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                    if ((data.style & 0x8000000) != 0) {
                        Cairo.cairo_save(cairo);
                        Cairo.cairo_scale(cairo, -1.0, 1.0);
                        Cairo.cairo_translate(cairo, -2 * x - this.width(), 0.0);
                    }
                    this.drawWithCairo(gc, x, y, byteSelStart, byteSelEnd, fullSelection, selectionForeground.handle, selectionBackground.handle);
                    if ((data.style & 0x8000000) != 0) {
                        Cairo.cairo_restore(cairo);
                    }
                } else {
                    Region clipping = new Region();
                    gc.getClipping(clipping);
                    OS.gdk_draw_layout(data.drawable, gc.handle, x, y, this.layout);
                    this.drawBorder(gc, x, y, null);
                    int[] ranges = new int[]{byteSelStart, byteSelEnd};
                    long rgn = OS.gdk_pango_layout_get_clip_region(this.layout, x, y, ranges, ranges.length / 2);
                    if (rgn != 0L) {
                        OS.gdk_gc_set_clip_region(gc.handle, rgn);
                        OS.gdk_region_destroy(rgn);
                    }
                    OS.gdk_draw_layout_with_colors(data.drawable, gc.handle, x, y, this.layout, selectionForeground.handle, selectionBackground.handle);
                    this.drawBorder(gc, x, y, selectionForeground.handle);
                    gc.setClipping(clipping);
                    clipping.dispose();
                }
            }
        }
    }

    void drawWithCairo(GC gc, int x, int y, int start, int end, boolean fullSelection, GdkColor fg, GdkColor bg) {
        int[] ranges;
        long rgn;
        GCData data = gc.data;
        long cairo = data.cairo;
        Cairo.cairo_save(cairo);
        if (!fullSelection) {
            Cairo.cairo_move_to(cairo, x, y);
            OS.pango_cairo_show_layout(cairo, this.layout);
            this.drawBorder(gc, x, y, null);
        }
        if ((rgn = OS.gdk_pango_layout_get_clip_region(this.layout, x, y, ranges = new int[]{start, end}, ranges.length / 2)) != 0L) {
            OS.gdk_cairo_region(cairo, rgn);
            Cairo.cairo_clip(cairo);
            Cairo.cairo_set_source_rgba(cairo, (float)(bg.red & 0xFFFF) / 65535.0f, (float)(bg.green & 0xFFFF) / 65535.0f, (float)(bg.blue & 0xFFFF) / 65535.0f, (float)data.alpha / 255.0f);
            Cairo.cairo_paint(cairo);
            OS.gdk_region_destroy(rgn);
        }
        Cairo.cairo_set_source_rgba(cairo, (float)(fg.red & 0xFFFF) / 65535.0f, (float)(fg.green & 0xFFFF) / 65535.0f, (float)(fg.blue & 0xFFFF) / 65535.0f, (float)data.alpha / 255.0f);
        Cairo.cairo_move_to(cairo, x, y);
        OS.pango_cairo_show_layout(cairo, this.layout);
        this.drawBorder(gc, x, y, fg);
        Cairo.cairo_restore(cairo);
    }

    void drawBorder(GC gc, int x, int y, GdkColor selectionColor) {
        GCData data = gc.data;
        long cairo = data.cairo;
        long gdkGC = gc.handle;
        long ptr = OS.pango_layout_get_text(this.layout);
        GdkGCValues gcValues = null;
        if (cairo != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
            Cairo.cairo_save(cairo);
        }
        int i = 0;
        while (i < this.stylesCount - 1) {
            TextStyle style = this.styles[i].style;
            if (style != null) {
                int j;
                boolean drawBorder;
                boolean bl = drawBorder = style.borderStyle != 0;
                if (drawBorder && !style.isAdherentBorder(this.styles[i + 1].style)) {
                    int byteEnd;
                    int start = this.styles[i].start;
                    int j2 = i;
                    while (j2 > 0 && style.isAdherentBorder(this.styles[j2 - 1].style)) {
                        start = this.styles[j2 - 1].start;
                        --j2;
                    }
                    start = this.translateOffset(start);
                    int end = this.translateOffset(this.styles[i + 1].start - 1);
                    int byteStart = (int)(OS.g_utf8_offset_to_pointer(ptr, start) - ptr);
                    int[] ranges = new int[]{byteStart, byteEnd = (int)(OS.g_utf8_offset_to_pointer(ptr, end + 1) - ptr)};
                    long rgn = OS.gdk_pango_layout_get_clip_region(this.layout, x, y, ranges, ranges.length / 2);
                    if (rgn != 0L) {
                        int[] nRects = new int[1];
                        long[] rects = new long[1];
                        OS.gdk_region_get_rectangles(rgn, rects, nRects);
                        GdkRectangle rect = new GdkRectangle();
                        GdkColor color = null;
                        if (color == null && style.borderColor != null) {
                            color = style.borderColor.handle;
                        }
                        if (color == null && selectionColor != null) {
                            color = selectionColor;
                        }
                        if (color == null && style.foreground != null) {
                            color = style.foreground.handle;
                        }
                        if (color == null) {
                            color = data.foreground;
                        }
                        int width = 1;
                        float[] dashes = null;
                        switch (style.borderStyle) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                dashes = width != 0 ? GC.LINE_DASH : GC.LINE_DASH_ZERO;
                                break;
                            }
                            case 4: {
                                float[] fArray = dashes = width != 0 ? GC.LINE_DOT : GC.LINE_DOT_ZERO;
                            }
                        }
                        if (cairo != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                            Cairo.cairo_set_source_rgba(cairo, (float)(color.red & 0xFFFF) / 65535.0f, (float)(color.green & 0xFFFF) / 65535.0f, (float)(color.blue & 0xFFFF) / 65535.0f, (float)data.alpha / 255.0f);
                            Cairo.cairo_set_line_width(cairo, width);
                            if (dashes != null) {
                                double[] cairoDashes = new double[dashes.length];
                                j = 0;
                                while (j < cairoDashes.length) {
                                    cairoDashes[j] = width == 0 || data.lineStyle == 6 ? dashes[j] : dashes[j] * (float)width;
                                    ++j;
                                }
                                Cairo.cairo_set_dash(cairo, cairoDashes, cairoDashes.length, 0.0);
                            } else {
                                Cairo.cairo_set_dash(cairo, null, 0, 0.0);
                            }
                            int j3 = 0;
                            while (j3 < nRects[0]) {
                                OS.memmove(rect, rects[0] + (long)(j3 * GdkRectangle.sizeof), (long)GdkRectangle.sizeof);
                                Cairo.cairo_rectangle(cairo, (double)rect.x + 0.5, (double)rect.y + 0.5, rect.width - 1, rect.height - 1);
                                ++j3;
                            }
                            Cairo.cairo_stroke(cairo);
                        } else {
                            if (gcValues == null) {
                                gcValues = new GdkGCValues();
                                OS.gdk_gc_get_values(gdkGC, gcValues);
                            }
                            OS.gdk_gc_set_foreground(gdkGC, color);
                            int cap_style = 1;
                            int join_style = 0;
                            int line_style = 0;
                            if (dashes != null) {
                                byte[] dash_list = new byte[dashes.length];
                                int j4 = 0;
                                while (j4 < dash_list.length) {
                                    dash_list[j4] = (byte)(width == 0 || data.lineStyle == 6 ? dashes[j4] : dashes[j4] * (float)width);
                                    ++j4;
                                }
                                OS.gdk_gc_set_dashes(gdkGC, 0, dash_list, dash_list.length);
                                line_style = 1;
                            } else {
                                line_style = 0;
                            }
                            OS.gdk_gc_set_line_attributes(gdkGC, width, line_style, cap_style, join_style);
                            int j5 = 0;
                            while (j5 < nRects[0]) {
                                OS.memmove(rect, rects[0] + (long)(j5 * GdkRectangle.sizeof), (long)GdkRectangle.sizeof);
                                OS.gdk_draw_rectangle(data.drawable, gdkGC, 0, rect.x, rect.y, rect.width - 1, rect.height - 1);
                                ++j5;
                            }
                        }
                        if (rects[0] != 0L) {
                            OS.g_free(rects[0]);
                        }
                        OS.gdk_region_destroy(rgn);
                    }
                }
                boolean drawUnderline = false;
                if (style.underline && style.underlineColor != null) {
                    drawUnderline = true;
                }
                if (style.underline && (style.underlineStyle == 2 || style.underlineStyle == 3) && OS.GTK_VERSION < OS.VERSION(2, 4, 0)) {
                    drawUnderline = true;
                }
                if (drawUnderline && !style.isAdherentUnderline(this.styles[i + 1].style)) {
                    int byteEnd;
                    int start = this.styles[i].start;
                    int j6 = i;
                    while (j6 > 0 && style.isAdherentUnderline(this.styles[j6 - 1].style)) {
                        start = this.styles[j6 - 1].start;
                        --j6;
                    }
                    start = this.translateOffset(start);
                    int end = this.translateOffset(this.styles[i + 1].start - 1);
                    int byteStart = (int)(OS.g_utf8_offset_to_pointer(ptr, start) - ptr);
                    int[] ranges = new int[]{byteStart, byteEnd = (int)(OS.g_utf8_offset_to_pointer(ptr, end + 1) - ptr)};
                    long rgn = OS.gdk_pango_layout_get_clip_region(this.layout, x, y, ranges, ranges.length / 2);
                    if (rgn != 0L) {
                        int[] nRects = new int[1];
                        long[] rects = new long[1];
                        OS.gdk_region_get_rectangles(rgn, rects, nRects);
                        GdkRectangle rect = new GdkRectangle();
                        GdkColor color = null;
                        if (color == null && style.underlineColor != null) {
                            color = style.underlineColor.handle;
                        }
                        if (color == null && selectionColor != null) {
                            color = selectionColor;
                        }
                        if (color == null && style.foreground != null) {
                            color = style.foreground.handle;
                        }
                        if (color == null) {
                            color = data.foreground;
                        }
                        if (cairo != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                            Cairo.cairo_set_source_rgba(cairo, (float)(color.red & 0xFFFF) / 65535.0f, (float)(color.green & 0xFFFF) / 65535.0f, (float)(color.blue & 0xFFFF) / 65535.0f, (float)data.alpha / 255.0f);
                        } else {
                            if (gcValues == null) {
                                gcValues = new GdkGCValues();
                                OS.gdk_gc_get_values(gdkGC, gcValues);
                            }
                            OS.gdk_gc_set_foreground(gdkGC, color);
                        }
                        int underlinePosition = -1;
                        int underlineThickness = 1;
                        if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
                            Font font = style.font;
                            if (font == null) {
                                font = this.font;
                            }
                            if (font == null) {
                                font = this.device.systemFont;
                            }
                            long lang = OS.pango_context_get_language(this.context);
                            long metrics = OS.pango_context_get_metrics(this.context, font.handle, lang);
                            underlinePosition = OS.PANGO_PIXELS(OS.pango_font_metrics_get_underline_position(metrics));
                            underlineThickness = OS.PANGO_PIXELS(OS.pango_font_metrics_get_underline_thickness(metrics));
                            OS.pango_font_metrics_unref(metrics);
                        }
                        j = 0;
                        while (j < nRects[0]) {
                            OS.memmove(rect, rects[0] + (long)(j * GdkRectangle.sizeof), (long)GdkRectangle.sizeof);
                            int offset = this.getOffset(rect.x - x, rect.y - y, null);
                            int lineIndex = this.getLineIndex(offset);
                            FontMetrics metrics = this.getLineMetrics(lineIndex);
                            int underlineY = rect.y + metrics.ascent - underlinePosition - style.rise;
                            switch (style.underlineStyle) {
                                case 2: 
                                case 3: {
                                    int squigglyThickness = underlineThickness;
                                    int squigglyHeight = 2 * squigglyThickness;
                                    int squigglyY = Math.min(underlineY, rect.y + rect.height - squigglyHeight - 1);
                                    int[] points = this.computePolyline(rect.x, squigglyY, rect.x + rect.width, squigglyY + squigglyHeight);
                                    if (cairo != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                                        Cairo.cairo_set_line_width(cairo, squigglyThickness);
                                        Cairo.cairo_set_line_cap(cairo, 0);
                                        Cairo.cairo_set_line_join(cairo, 0);
                                        if (points.length <= 0) break;
                                        double xOffset = 0.5;
                                        double yOffset = 0.5;
                                        Cairo.cairo_move_to(cairo, (double)points[0] + xOffset, (double)points[1] + yOffset);
                                        int k = 2;
                                        while (k < points.length) {
                                            Cairo.cairo_line_to(cairo, (double)points[k] + xOffset, (double)points[k + 1] + yOffset);
                                            k += 2;
                                        }
                                        Cairo.cairo_stroke(cairo);
                                        break;
                                    }
                                    OS.gdk_gc_set_line_attributes(gdkGC, squigglyThickness, 0, 1, 0);
                                    OS.gdk_draw_lines(data.drawable, gdkGC, points, points.length / 2);
                                    break;
                                }
                                case 1: {
                                    if (cairo != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                                        Cairo.cairo_rectangle(cairo, rect.x, underlineY + underlineThickness * 2, rect.width, underlineThickness);
                                        Cairo.cairo_fill(cairo);
                                    } else {
                                        OS.gdk_draw_rectangle(data.drawable, gdkGC, 1, rect.x, underlineY + underlineThickness * 2, rect.width, underlineThickness);
                                    }
                                }
                                case 0: 
                                case 4: {
                                    if (cairo != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                                        Cairo.cairo_rectangle(cairo, rect.x, underlineY, rect.width, underlineThickness);
                                        Cairo.cairo_fill(cairo);
                                        break;
                                    }
                                    OS.gdk_draw_rectangle(data.drawable, gdkGC, 1, rect.x, underlineY, rect.width, underlineThickness);
                                }
                            }
                            ++j;
                        }
                        if (rects[0] != 0L) {
                            OS.g_free(rects[0]);
                        }
                        OS.gdk_region_destroy(rgn);
                    }
                }
                boolean drawStrikeout = false;
                if (style.strikeout && style.strikeoutColor != null) {
                    drawStrikeout = true;
                }
                if (drawStrikeout && !style.isAdherentStrikeout(this.styles[i + 1].style)) {
                    int byteEnd;
                    int start = this.styles[i].start;
                    int j7 = i;
                    while (j7 > 0 && style.isAdherentStrikeout(this.styles[j7 - 1].style)) {
                        start = this.styles[j7 - 1].start;
                        --j7;
                    }
                    start = this.translateOffset(start);
                    int end = this.translateOffset(this.styles[i + 1].start - 1);
                    int byteStart = (int)(OS.g_utf8_offset_to_pointer(ptr, start) - ptr);
                    int[] ranges = new int[]{byteStart, byteEnd = (int)(OS.g_utf8_offset_to_pointer(ptr, end + 1) - ptr)};
                    long rgn = OS.gdk_pango_layout_get_clip_region(this.layout, x, y, ranges, ranges.length / 2);
                    if (rgn != 0L) {
                        int[] nRects = new int[1];
                        long[] rects = new long[1];
                        OS.gdk_region_get_rectangles(rgn, rects, nRects);
                        GdkRectangle rect = new GdkRectangle();
                        GdkColor color = null;
                        if (color == null && style.strikeoutColor != null) {
                            color = style.strikeoutColor.handle;
                        }
                        if (color == null && selectionColor != null) {
                            color = selectionColor;
                        }
                        if (color == null && style.foreground != null) {
                            color = style.foreground.handle;
                        }
                        if (color == null) {
                            color = data.foreground;
                        }
                        if (cairo != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                            Cairo.cairo_set_source_rgba(cairo, (float)(color.red & 0xFFFF) / 65535.0f, (float)(color.green & 0xFFFF) / 65535.0f, (float)(color.blue & 0xFFFF) / 65535.0f, (float)data.alpha / 255.0f);
                        } else {
                            if (gcValues == null) {
                                gcValues = new GdkGCValues();
                                OS.gdk_gc_get_values(gdkGC, gcValues);
                            }
                            OS.gdk_gc_set_foreground(gdkGC, color);
                        }
                        int strikeoutPosition = -1;
                        int strikeoutThickness = 1;
                        if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
                            Font font = style.font;
                            if (font == null) {
                                font = this.font;
                            }
                            if (font == null) {
                                font = this.device.systemFont;
                            }
                            long lang = OS.pango_context_get_language(this.context);
                            long metrics = OS.pango_context_get_metrics(this.context, font.handle, lang);
                            strikeoutPosition = OS.PANGO_PIXELS(OS.pango_font_metrics_get_strikethrough_position(metrics));
                            strikeoutThickness = OS.PANGO_PIXELS(OS.pango_font_metrics_get_strikethrough_thickness(metrics));
                            OS.pango_font_metrics_unref(metrics);
                        }
                        int j8 = 0;
                        while (j8 < nRects[0]) {
                            OS.memmove(rect, rects[0] + (long)(j8 * GdkRectangle.sizeof), (long)GdkRectangle.sizeof);
                            int strikeoutY = rect.y + rect.height / 2 - style.rise;
                            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
                                int offset = this.getOffset(rect.x - x, rect.y - y, null);
                                int lineIndex = this.getLineIndex(offset);
                                FontMetrics metrics = this.getLineMetrics(lineIndex);
                                strikeoutY = rect.y + metrics.ascent - strikeoutPosition - style.rise;
                            }
                            if (cairo != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                                Cairo.cairo_rectangle(cairo, rect.x, strikeoutY, rect.width, strikeoutThickness);
                                Cairo.cairo_fill(cairo);
                            } else {
                                OS.gdk_draw_rectangle(data.drawable, gdkGC, 1, rect.x, strikeoutY, rect.width, strikeoutThickness);
                            }
                            ++j8;
                        }
                        if (rects[0] != 0L) {
                            OS.g_free(rects[0]);
                        }
                        OS.gdk_region_destroy(rgn);
                    }
                }
            }
            ++i;
        }
        if (gcValues != null) {
            int mask = 245761;
            OS.gdk_gc_set_values(gdkGC, gcValues, mask);
            data.state &= 0xFFFFFFF7;
        }
        if (cairo != 0L && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
            Cairo.cairo_restore(cairo);
        }
    }

    void freeRuns() {
        if (this.attrList == 0L) {
            return;
        }
        OS.pango_layout_set_attributes(this.layout, 0L);
        OS.pango_attr_list_unref(this.attrList);
        this.attrList = 0L;
        this.invalidOffsets = null;
    }

    public int getAlignment() {
        this.checkLayout();
        int align = OS.pango_layout_get_alignment(this.layout);
        boolean rtl = OS.pango_context_get_base_dir(this.context) == 1;
        switch (align) {
            case 0: {
                return rtl ? 131072 : 16384;
            }
            case 2: {
                return rtl ? 16384 : 131072;
            }
        }
        return 0x1000000;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns();
        int[] w = new int[1];
        int[] h = new int[1];
        OS.pango_layout_get_size(this.layout, w, h);
        int wrapWidth = OS.pango_layout_get_width(this.layout);
        w[0] = wrapWidth != -1 ? wrapWidth : w[0] + OS.pango_layout_get_indent(this.layout);
        int width = OS.PANGO_PIXELS(w[0]);
        int height = OS.PANGO_PIXELS(h[0]);
        if (this.ascent != -1 && this.descent != -1) {
            height = Math.max(height, this.ascent + this.descent);
        }
        return new Rectangle(0, 0, width, height += OS.PANGO_PIXELS(OS.pango_layout_get_spacing(this.layout)));
    }

    public Rectangle getBounds(int start, int end) {
        long linesRegion;
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (length == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (start > end) {
            return new Rectangle(0, 0, 0, 0);
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        start = this.translateOffset(start);
        end = this.translateOffset(end);
        long ptr = OS.pango_layout_get_text(this.layout);
        int byteStart = (int)(OS.g_utf8_offset_to_pointer(ptr, start) - ptr);
        int byteEnd = (int)(OS.g_utf8_offset_to_pointer(ptr, end + 1) - ptr);
        int strlen = OS.strlen(ptr);
        int[] ranges = new int[]{byteStart = Math.min(byteStart, strlen), byteEnd = Math.min(byteEnd, strlen)};
        long clipRegion = OS.gdk_pango_layout_get_clip_region(this.layout, 0, 0, ranges, 1);
        if (clipRegion == 0L) {
            return new Rectangle(0, 0, 0, 0);
        }
        GdkRectangle rect = new GdkRectangle();
        PangoRectangle pangoRect = new PangoRectangle();
        long iter = OS.pango_layout_get_iter(this.layout);
        if (iter == 0L) {
            SWT.error(2);
        }
        if ((linesRegion = OS.gdk_region_new()) == 0L) {
            SWT.error(2);
        }
        int lineEnd = 0;
        do {
            OS.pango_layout_iter_get_line_extents(iter, null, pangoRect);
            lineEnd = OS.pango_layout_iter_next_line(iter) ? OS.pango_layout_iter_get_index(iter) - 1 : strlen;
            if (byteStart > lineEnd) continue;
            rect.x = OS.PANGO_PIXELS(pangoRect.x);
            rect.y = OS.PANGO_PIXELS(pangoRect.y);
            rect.width = OS.PANGO_PIXELS(pangoRect.width);
            rect.height = OS.PANGO_PIXELS(pangoRect.height);
            OS.gdk_region_union_with_rect(linesRegion, rect);
        } while (lineEnd + 1 <= byteEnd);
        OS.gdk_region_intersect(clipRegion, linesRegion);
        OS.gdk_region_destroy(linesRegion);
        OS.pango_layout_iter_free(iter);
        OS.gdk_region_get_clipbox(clipRegion, rect);
        OS.gdk_region_destroy(clipRegion);
        if (OS.pango_context_get_base_dir(this.context) == 1) {
            rect.x = this.width() - rect.x - rect.width;
        }
        rect.x += Math.min(this.indent, this.wrapIndent);
        return new Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return OS.pango_layout_get_justify(this.layout);
    }

    public int getLevel(int offset) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        long iter = OS.pango_layout_get_iter(this.layout);
        if (iter == 0L) {
            SWT.error(2);
        }
        int level = 0;
        PangoItem item = new PangoItem();
        PangoLayoutRun run = new PangoLayoutRun();
        long ptr = OS.pango_layout_get_text(this.layout);
        long byteOffset = OS.g_utf8_offset_to_pointer(ptr, offset) - ptr;
        int strlen = OS.strlen(ptr);
        byteOffset = Math.min(byteOffset, (long)strlen);
        do {
            long runPtr;
            if ((runPtr = OS.pango_layout_iter_get_run(iter)) == 0L) continue;
            OS.memmove(run, runPtr, (long)PangoLayoutRun.sizeof);
            OS.memmove(item, run.item, (long)PangoItem.sizeof);
            if ((long)item.offset > byteOffset || byteOffset >= (long)(item.offset + item.length)) continue;
            level = item.analysis_level;
            break;
        } while (OS.pango_layout_iter_next_run(iter));
        OS.pango_layout_iter_free(iter);
        return level;
    }

    public Rectangle getLineBounds(int lineIndex) {
        long iter;
        this.checkLayout();
        this.computeRuns();
        int lineCount = OS.pango_layout_get_line_count(this.layout);
        if (lineIndex < 0 || lineIndex >= lineCount) {
            SWT.error(6);
        }
        if ((iter = OS.pango_layout_get_iter(this.layout)) == 0L) {
            SWT.error(2);
        }
        int i = 0;
        while (i < lineIndex) {
            OS.pango_layout_iter_next_line(iter);
            ++i;
        }
        PangoRectangle rect = new PangoRectangle();
        OS.pango_layout_iter_get_line_extents(iter, null, rect);
        OS.pango_layout_iter_free(iter);
        int x = OS.PANGO_PIXELS(rect.x);
        int y = OS.PANGO_PIXELS(rect.y);
        int width = OS.PANGO_PIXELS(rect.width);
        int height = OS.PANGO_PIXELS(rect.height);
        if (this.ascent != -1 && this.descent != -1) {
            height = Math.max(height, this.ascent + this.descent);
        }
        if (OS.pango_context_get_base_dir(this.context) == 1) {
            x = this.width() - x - width;
        }
        return new Rectangle(x += Math.min(this.indent, this.wrapIndent), y, width, height);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns();
        return OS.pango_layout_get_line_count(this.layout);
    }

    public int getLineIndex(int offset) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(5);
        }
        offset = this.translateOffset(offset);
        int line = 0;
        long ptr = OS.pango_layout_get_text(this.layout);
        long byteOffset = OS.g_utf8_offset_to_pointer(ptr, offset) - ptr;
        int strlen = OS.strlen(ptr);
        byteOffset = Math.min(byteOffset, (long)strlen);
        long iter = OS.pango_layout_get_iter(this.layout);
        if (iter == 0L) {
            SWT.error(2);
        }
        while (OS.pango_layout_iter_next_line(iter)) {
            if ((long)OS.pango_layout_iter_get_index(iter) > byteOffset) break;
            ++line;
        }
        OS.pango_layout_iter_free(iter);
        return line;
    }

    public FontMetrics getLineMetrics(int lineIndex) {
        this.checkLayout();
        this.computeRuns();
        int lineCount = OS.pango_layout_get_line_count(this.layout);
        if (lineIndex < 0 || lineIndex >= lineCount) {
            SWT.error(6);
        }
        int ascent = 0;
        int descent = 0;
        PangoLayoutLine line = new PangoLayoutLine();
        OS.memmove(line, OS.pango_layout_get_line(this.layout, lineIndex), (long)PangoLayoutLine.sizeof);
        if (line.runs == 0L) {
            long font = this.font != null ? this.font.handle : this.device.systemFont.handle;
            long lang = OS.pango_context_get_language(this.context);
            long metrics = OS.pango_context_get_metrics(this.context, font, lang);
            ascent = OS.pango_font_metrics_get_ascent(metrics);
            descent = OS.pango_font_metrics_get_descent(metrics);
            OS.pango_font_metrics_unref(metrics);
        } else {
            PangoRectangle rect = new PangoRectangle();
            OS.pango_layout_line_get_extents(OS.pango_layout_get_line(this.layout, lineIndex), null, rect);
            ascent = -rect.y;
            descent = rect.height - ascent;
        }
        ascent = Math.max(this.ascent, OS.PANGO_PIXELS(ascent));
        descent = Math.max(this.descent, OS.PANGO_PIXELS(descent));
        return FontMetrics.gtk_new(ascent, descent, 0, 0, ascent + descent);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns();
        int lineCount = OS.pango_layout_get_line_count(this.layout);
        int[] offsets = new int[lineCount + 1];
        long ptr = OS.pango_layout_get_text(this.layout);
        PangoLayoutLine line = new PangoLayoutLine();
        int i = 0;
        while (i < lineCount) {
            long linePtr = OS.pango_layout_get_line(this.layout, i);
            OS.memmove(line, linePtr, (long)PangoLayoutLine.sizeof);
            int pos = (int)OS.g_utf8_pointer_to_offset(ptr, ptr + (long)line.start_index);
            offsets[i] = this.untranslateOffset(pos);
            ++i;
        }
        offsets[lineCount] = this.text.length();
        return offsets;
    }

    public Point getLocation(int offset, boolean trailing) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        long ptr = OS.pango_layout_get_text(this.layout);
        int byteOffset = (int)(OS.g_utf8_offset_to_pointer(ptr, offset) - ptr);
        int strlen = OS.strlen(ptr);
        byteOffset = Math.min(byteOffset, strlen);
        PangoRectangle pos = new PangoRectangle();
        OS.pango_layout_index_to_pos(this.layout, byteOffset, pos);
        int x = trailing ? pos.x + pos.width : pos.x;
        int y = pos.y;
        x = OS.PANGO_PIXELS(x);
        if (OS.pango_context_get_base_dir(this.context) == 1) {
            x = this.width() - x;
        }
        return new Point(x += Math.min(this.indent, this.wrapIndent), OS.PANGO_PIXELS(y));
    }

    public int getNextOffset(int offset, int movement) {
        return this._getOffset(offset, movement, true);
    }

    int _getOffset(int offset, int movement, boolean forward) {
        int step;
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        if (forward) {
            if (offset == length) {
                return length;
            }
        } else if (offset == 0) {
            return 0;
        }
        int n = step = forward ? 1 : -1;
        if ((movement & 1) != 0) {
            return offset + step;
        }
        long[] attrs = new long[1];
        int[] nAttrs = new int[1];
        OS.pango_layout_get_log_attrs(this.layout, attrs, nAttrs);
        if (attrs[0] == 0L) {
            return offset + step;
        }
        length = (int)OS.g_utf8_strlen(OS.pango_layout_get_text(this.layout), -1L);
        int internalOffset = this.translateOffset(offset += step);
        PangoLogAttr logAttr = new PangoLogAttr();
        while (internalOffset > 0 && internalOffset < length) {
            OS.memmove(logAttr, attrs[0] + (long)(internalOffset * PangoLogAttr.sizeof), (long)PangoLogAttr.sizeof);
            if ((movement & 2) != 0 && logAttr.is_cursor_position || (movement & 4) != 0 && (!forward ? logAttr.is_word_start : logAttr.is_word_end)) break;
            if ((movement & 0x10) != 0 && (logAttr.is_word_start || logAttr.is_sentence_end) || (movement & 8) != 0 && logAttr.is_word_end) break;
            internalOffset = this.translateOffset(offset += step);
        }
        OS.g_free(attrs[0]);
        return Math.min(Math.max(0, offset), this.text.length());
    }

    public int getOffset(Point point, int[] trailing) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, trailing);
    }

    public int getOffset(int x, int y, int[] trailing) {
        long iter;
        this.checkLayout();
        this.computeRuns();
        if (trailing != null && trailing.length < 1) {
            SWT.error(5);
        }
        x -= Math.min(this.indent, this.wrapIndent);
        if (OS.pango_context_get_base_dir(this.context) == 1) {
            x = this.width() - x;
        }
        if ((iter = OS.pango_layout_get_iter(this.layout)) == 0L) {
            SWT.error(2);
        }
        PangoRectangle rect = new PangoRectangle();
        do {
            OS.pango_layout_iter_get_line_extents(iter, null, rect);
            rect.y = OS.PANGO_PIXELS(rect.y);
            rect.height = OS.PANGO_PIXELS(rect.height);
            if (rect.y > y || y >= rect.y + rect.height) continue;
            rect.x = OS.PANGO_PIXELS(rect.x);
            rect.width = OS.PANGO_PIXELS(rect.width);
            if (x >= rect.x + rect.width) {
                x = rect.x + rect.width - 1;
            }
            if (x >= rect.x) break;
            x = rect.x;
            break;
        } while (OS.pango_layout_iter_next_line(iter));
        OS.pango_layout_iter_free(iter);
        int[] index = new int[1];
        int[] piTrailing = new int[1];
        OS.pango_layout_xy_to_index(this.layout, x * 1024, y * 1024, index, piTrailing);
        long ptr = OS.pango_layout_get_text(this.layout);
        int offset = (int)OS.g_utf8_pointer_to_offset(ptr, ptr + (long)index[0]);
        if (trailing != null) {
            trailing[0] = piTrailing[0];
        }
        return this.untranslateOffset(offset);
    }

    public int getOrientation() {
        this.checkLayout();
        int baseDir = OS.pango_context_get_base_dir(this.context);
        return baseDir == 1 ? 0x4000000 : 0x2000000;
    }

    public int getPreviousOffset(int index, int movement) {
        return this._getOffset(index, movement, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] result = new int[this.stylesCount * 2];
        int count = 0;
        int i = 0;
        while (i < this.stylesCount - 1) {
            if (this.styles[i].style != null) {
                result[count++] = this.styles[i].start;
                result[count++] = this.styles[i + 1].start - 1;
            }
            ++i;
        }
        if (count != result.length) {
            int[] newResult = new int[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public char[] getSegmentsChars() {
        this.checkLayout();
        return this.segmentsChars;
    }

    String getSegmentsText() {
        int separator;
        int length = this.text.length();
        if (length == 0) {
            return this.text;
        }
        if (this.segments == null) {
            return this.text;
        }
        int nSegments = this.segments.length;
        if (nSegments == 0) {
            return this.text;
        }
        if (this.segmentsChars == null) {
            if (nSegments == 1) {
                return this.text;
            }
            if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
                return this.text;
            }
        }
        char[] oldChars = new char[length];
        this.text.getChars(0, length, oldChars, 0);
        char[] newChars = new char[length + nSegments];
        int charCount = 0;
        int segmentCount = 0;
        int defaultSeparator = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (charCount < length) {
            if (segmentCount < nSegments && charCount == this.segments[segmentCount]) {
                separator = this.segmentsChars != null && this.segmentsChars.length > segmentCount ? this.segmentsChars[segmentCount] : defaultSeparator;
                newChars[charCount + segmentCount++] = separator;
                continue;
            }
            newChars[charCount + segmentCount] = oldChars[charCount++];
        }
        while (segmentCount < nSegments) {
            this.segments[segmentCount] = charCount;
            separator = this.segmentsChars != null && this.segmentsChars.length > segmentCount ? this.segmentsChars[segmentCount] : defaultSeparator;
            newChars[charCount + segmentCount++] = separator;
        }
        return new String(newChars, 0, newChars.length);
    }

    public int getSpacing() {
        this.checkLayout();
        return OS.PANGO_PIXELS(OS.pango_layout_get_spacing(this.layout));
    }

    public TextStyle getStyle(int offset) {
        this.checkLayout();
        int length = this.text.length();
        if (offset < 0 || offset >= length) {
            SWT.error(6);
        }
        int i = 1;
        while (i < this.stylesCount) {
            StyleItem item = this.styles[i];
            if (item.start > offset) {
                return this.styles[i - 1].style;
            }
            ++i;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] result = new TextStyle[this.stylesCount];
        int count = 0;
        int i = 0;
        while (i < this.stylesCount) {
            if (this.styles[i].style != null) {
                result[count++] = this.styles[i].style;
            }
            ++i;
        }
        if (count != result.length) {
            TextStyle[] newResult = new TextStyle[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public int getWrapIndent() {
        this.checkLayout();
        return this.wrapIndent;
    }

    public boolean isDisposed() {
        return this.layout == 0L;
    }

    public void setAlignment(int alignment) {
        this.checkLayout();
        int mask = 16924672;
        if ((alignment &= mask) == 0) {
            return;
        }
        if ((alignment & 0x4000) != 0) {
            alignment = 16384;
        }
        if ((alignment & 0x20000) != 0) {
            alignment = 131072;
        }
        boolean rtl = OS.pango_context_get_base_dir(this.context) == 1;
        int align = 1;
        switch (alignment) {
            case 16384: {
                align = rtl ? 2 : 0;
                break;
            }
            case 131072: {
                align = rtl ? 0 : 2;
            }
        }
        OS.pango_layout_set_alignment(this.layout, align);
    }

    public void setAscent(int ascent) {
        this.checkLayout();
        if (ascent < -1) {
            SWT.error(5);
        }
        if (this.ascent == ascent) {
            return;
        }
        this.freeRuns();
        this.ascent = ascent;
    }

    public void setDescent(int descent) {
        this.checkLayout();
        if (descent < -1) {
            SWT.error(5);
        }
        if (this.descent == descent) {
            return;
        }
        this.freeRuns();
        this.descent = descent;
    }

    public void setFont(Font font) {
        Font oldFont;
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((oldFont = this.font) == font) {
            return;
        }
        this.freeRuns();
        this.font = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        OS.pango_layout_set_font_description(this.layout, font != null ? font.handle : this.device.systemFont.handle);
    }

    public void setIndent(int indent) {
        this.checkLayout();
        if (indent < 0) {
            return;
        }
        if (this.indent == indent) {
            return;
        }
        this.indent = indent;
        OS.pango_layout_set_indent(this.layout, (indent - this.wrapIndent) * 1024);
        if (this.wrapWidth != -1) {
            this.setWidth();
        }
    }

    public void setJustify(boolean justify) {
        this.checkLayout();
        OS.pango_layout_set_justify(this.layout, justify);
    }

    public void setOrientation(int orientation) {
        int baseDir;
        this.checkLayout();
        int mask = 0x6000000;
        if ((orientation &= mask) == 0) {
            return;
        }
        if ((orientation & 0x2000000) != 0) {
            orientation = 0x2000000;
        }
        int n = baseDir = orientation == 0x4000000 ? 1 : 0;
        if (OS.pango_context_get_base_dir(this.context) == baseDir) {
            return;
        }
        OS.pango_context_set_base_dir(this.context, baseDir);
        OS.pango_layout_context_changed(this.layout);
        int align = OS.pango_layout_get_alignment(this.layout);
        if (align != 1) {
            align = align == 0 ? 2 : 0;
            OS.pango_layout_set_alignment(this.layout, align);
        }
    }

    public void setSpacing(int spacing) {
        this.checkLayout();
        if (spacing < 0) {
            SWT.error(5);
        }
        OS.pango_layout_set_spacing(this.layout, spacing * 1024);
    }

    public void setSegments(int[] segments) {
        this.checkLayout();
        if (this.segments == null && segments == null) {
            return;
        }
        if (this.segments != null && segments != null && this.segments.length == segments.length) {
            int i = 0;
            while (i < segments.length) {
                if (this.segments[i] != segments[i]) break;
                ++i;
            }
            if (i == segments.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = segments;
    }

    public void setSegmentsChars(char[] segmentsChars) {
        this.checkLayout();
        if (this.segmentsChars == null && segmentsChars == null) {
            return;
        }
        if (this.segmentsChars != null && segmentsChars != null && this.segmentsChars.length == segmentsChars.length) {
            int i = 0;
            while (i < segmentsChars.length) {
                if (this.segmentsChars[i] != segmentsChars[i]) break;
                ++i;
            }
            if (i == segmentsChars.length) {
                return;
            }
        }
        this.freeRuns();
        this.segmentsChars = segmentsChars;
    }

    public void setStyle(TextStyle style, int start, int end) {
        int newLength;
        int modifyStart;
        this.checkLayout();
        int length = this.text.length();
        if (length == 0) {
            return;
        }
        if (start > end) {
            return;
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        if (start > 0 && TextLayout.isAlef(this.text.charAt(start)) && TextLayout.isLam(this.text.charAt(start - 1))) {
            --start;
        }
        if (end < length - 1 && TextLayout.isLam(this.text.charAt(end)) && TextLayout.isAlef(this.text.charAt(end + 1))) {
            ++end;
        }
        int low = -1;
        int high = this.stylesCount;
        while (high - low > 1) {
            int index = (high + low) / 2;
            if (this.styles[index + 1].start > start) {
                high = index;
                continue;
            }
            low = index;
        }
        if (high >= 0 && high < this.stylesCount) {
            StyleItem item = this.styles[high];
            if (item.start == start && this.styles[high + 1].start - 1 == end && (style == null ? item.style == null : style.equals(item.style))) {
                return;
            }
        }
        this.freeRuns();
        int modifyEnd = modifyStart = high;
        while (modifyEnd < this.stylesCount) {
            if (this.styles[modifyEnd + 1].start > end) break;
            ++modifyEnd;
        }
        if (modifyStart == modifyEnd) {
            int styleStart = this.styles[modifyStart].start;
            int styleEnd = this.styles[modifyEnd + 1].start - 1;
            if (styleStart == start && styleEnd == end) {
                this.styles[modifyStart].style = style;
                return;
            }
            if (styleStart != start && styleEnd != end) {
                int newLength2 = this.stylesCount + 2;
                if (newLength2 > this.styles.length) {
                    int newSize = Math.min(newLength2 + 1024, Math.max(64, newLength2 * 2));
                    StyleItem[] newStyles = new StyleItem[newSize];
                    System.arraycopy(this.styles, 0, newStyles, 0, this.stylesCount);
                    this.styles = newStyles;
                }
                System.arraycopy(this.styles, modifyEnd + 1, this.styles, modifyEnd + 3, this.stylesCount - modifyEnd - 1);
                StyleItem item = new StyleItem();
                item.start = start;
                item.style = style;
                this.styles[modifyStart + 1] = item;
                item = new StyleItem();
                item.start = end + 1;
                item.style = this.styles[modifyStart].style;
                this.styles[modifyStart + 2] = item;
                this.stylesCount = newLength2;
                return;
            }
        }
        if (start == this.styles[modifyStart].start) {
            --modifyStart;
        }
        if (end == this.styles[modifyEnd + 1].start - 1) {
            ++modifyEnd;
        }
        if ((newLength = this.stylesCount + 1 - (modifyEnd - modifyStart - 1)) > this.styles.length) {
            int newSize = Math.min(newLength + 1024, Math.max(64, newLength * 2));
            StyleItem[] newStyles = new StyleItem[newSize];
            System.arraycopy(this.styles, 0, newStyles, 0, this.stylesCount);
            this.styles = newStyles;
        }
        System.arraycopy(this.styles, modifyEnd, this.styles, modifyStart + 2, this.stylesCount - modifyEnd);
        StyleItem item = new StyleItem();
        item.start = start;
        item.style = style;
        this.styles[modifyStart + 1] = item;
        this.styles[modifyStart + 2].start = end + 1;
        this.stylesCount = newLength;
    }

    public void setTabs(int[] tabs) {
        this.checkLayout();
        if (this.tabs == null && tabs == null) {
            return;
        }
        if (this.tabs != null && tabs != null && this.tabs.length == tabs.length) {
            int i = 0;
            while (i < tabs.length) {
                if (this.tabs[i] != tabs[i]) break;
                ++i;
            }
            if (i == tabs.length) {
                return;
            }
        }
        this.tabs = tabs;
        if (tabs == null) {
            OS.pango_layout_set_tabs(this.layout, this.device.emptyTab);
        } else {
            long tabArray = OS.pango_tab_array_new(tabs.length, true);
            if (tabArray != 0L) {
                int i = 0;
                while (i < tabs.length) {
                    OS.pango_tab_array_set_tab(tabArray, i, 0L, tabs[i]);
                    ++i;
                }
                OS.pango_layout_set_tabs(this.layout, tabArray);
                OS.pango_tab_array_free(tabArray);
            }
        }
        OS.pango_layout_context_changed(this.layout);
    }

    public void setText(String text) {
        this.checkLayout();
        if (text == null) {
            SWT.error(4);
        }
        if (text.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = text;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = text.length();
        this.stylesCount = 2;
    }

    public void setWidth(int width) {
        this.checkLayout();
        if (width < -1 || width == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == width) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = width;
        this.setWidth();
    }

    void setWidth() {
        if (this.wrapWidth == -1) {
            OS.pango_layout_set_width(this.layout, -1);
            boolean rtl = OS.pango_context_get_base_dir(this.context) == 1;
            OS.pango_layout_set_alignment(this.layout, rtl ? 2 : 0);
        } else {
            int margin = Math.min(this.indent, this.wrapIndent);
            OS.pango_layout_set_width(this.layout, (this.wrapWidth - margin) * 1024);
        }
    }

    public void setWrapIndent(int wrapIndent) {
        this.checkLayout();
        if (wrapIndent < 0) {
            return;
        }
        if (this.wrapIndent == wrapIndent) {
            return;
        }
        this.wrapIndent = wrapIndent;
        OS.pango_layout_set_indent(this.layout, (this.indent - wrapIndent) * 1024);
        if (this.wrapWidth != -1) {
            this.setWidth();
        }
    }

    static final boolean isLam(int ch) {
        return ch == 1604;
    }

    static final boolean isAlef(int ch) {
        switch (ch) {
            case 1570: 
            case 1571: 
            case 1573: 
            case 1575: 
            case 1609: 
            case 1648: 
            case 1649: 
            case 1650: 
            case 1651: 
            case 1653: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {" + this.layout + "}";
    }

    int translateOffset(int offset) {
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (this.invalidOffsets == null) {
            return offset;
        }
        int i = 0;
        while (i < this.invalidOffsets.length) {
            if (offset < this.invalidOffsets[i]) break;
            ++offset;
            ++i;
        }
        return offset;
    }

    int untranslateOffset(int offset) {
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (this.invalidOffsets == null) {
            return offset;
        }
        int i = 0;
        while (i < this.invalidOffsets.length && offset > this.invalidOffsets[i]) {
            ++i;
        }
        return offset - i;
    }

    int width() {
        int wrapWidth = OS.pango_layout_get_width(this.layout);
        if (wrapWidth != -1) {
            return OS.PANGO_PIXELS(wrapWidth);
        }
        int[] w = new int[1];
        int[] h = new int[1];
        OS.pango_layout_get_size(this.layout, w, h);
        return OS.PANGO_PIXELS(w[0]);
    }

    static class StyleItem {
        TextStyle style;
        int start;

        StyleItem() {
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

