/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventFocus;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoRectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class Text
extends Scrollable {
    long bufferHandle;
    int tabs = 8;
    int lastEventTime = 0;
    long gdkEventKey = 0L;
    int fixStart = -1;
    int fixEnd = -1;
    boolean doubleClick;
    String message = "";
    static final int ITER_SIZEOF = OS.GtkTextIter_sizeof();
    static final int SPACE_FOR_CURSOR = 1;
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = "\n";

    public Text(Composite composite, int n) {
        super(composite, Text.checkStyle(n));
        if (OS.GTK_VERSION >= OS.VERSION(2, 16, 0) && (n & 0x80) != 0) {
            if ((n & 0x100) != 0) {
                this.style |= 0x100;
                OS.gtk_entry_set_icon_from_stock(this.handle, 1, OS.GTK_STOCK_CLEAR);
                OS.gtk_entry_set_icon_sensitive(this.handle, 1, false);
            }
            if ((n & 0x200) != 0) {
                this.style |= 0x200;
                OS.gtk_entry_set_icon_from_stock(this.handle, 0, OS.GTK_STOCK_FIND);
            }
        }
    }

    static int checkStyle(int n) {
        if ((n & 0x80) != 0) {
            n |= 0x804;
            n &= 0xFFBFFFFF;
        }
        if ((n & 4) != 0 && (n & 2) != 0) {
            n &= 0xFFFFFFFD;
        }
        if (((n = Text.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            n &= 0xFFFFFCBF;
        }
        if ((n & 0x40) != 0) {
            n |= 2;
            n &= 0xFFFFFEFF;
        }
        if ((n & 2) != 0) {
            n &= 0xFFBFFFFF;
        }
        if ((n & 6) != 0) {
            return n;
        }
        if ((n & 0x300) != 0) {
            return n | 2;
        }
        return n | 4;
    }

    void createHandle(int n) {
        this.state |= 0x28;
        if ((this.style & 8) != 0 && (this.style & 0xB00) == 0) {
            this.state |= 0x10000;
        }
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        if ((this.style & 4) != 0) {
            this.handle = OS.gtk_entry_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            OS.gtk_container_add(this.fixedHandle, this.handle);
            OS.gtk_editable_set_editable(this.handle, (this.style & 8) == 0);
            OS.gtk_entry_set_has_frame(this.handle, (this.style & 0x800) != 0);
            OS.gtk_entry_set_visibility(this.handle, (this.style & 0x400000) == 0);
            float f = 0.0f;
            if ((this.style & 0x1000000) != 0) {
                f = 0.5f;
            }
            if ((this.style & 0x20000) != 0) {
                f = 1.0f;
            }
            if (f > 0.0f) {
                OS.gtk_entry_set_alignment(this.handle, f);
            }
        } else {
            this.scrolledHandle = OS.gtk_scrolled_window_new(0L, 0L);
            if (this.scrolledHandle == 0L) {
                this.error(2);
            }
            this.handle = OS.gtk_text_view_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            this.bufferHandle = OS.gtk_text_view_get_buffer(this.handle);
            if (this.bufferHandle == 0L) {
                this.error(2);
            }
            OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
            OS.gtk_container_add(this.scrolledHandle, this.handle);
            OS.gtk_text_view_set_editable(this.handle, (this.style & 8) == 0);
            if ((this.style & 0x40) != 0) {
                OS.gtk_text_view_set_wrap_mode(this.handle, OS.GTK_VERSION < OS.VERSION(2, 4, 0) ? 2 : 3);
            }
            int n2 = (this.style & 0x100) != 0 ? 0 : 2;
            int n3 = (this.style & 0x200) != 0 ? 0 : 2;
            OS.gtk_scrolled_window_set_policy(this.scrolledHandle, n2, n3);
            if ((this.style & 0x800) != 0) {
                OS.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
            }
            int n4 = 0;
            if ((this.style & 0x1000000) != 0) {
                n4 = 2;
            }
            if ((this.style & 0x20000) != 0) {
                n4 = 1;
            }
            OS.gtk_text_view_set_justification(this.handle, n4);
        }
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.doubleClick = true;
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, false);
        if ((this.style & 4) != 0) {
            OS.gtk_editable_insert_text(this.handle, byArray, byArray.length, new int[]{-1});
            OS.gtk_editable_set_position(this.handle, -1);
        } else {
            byte[] byArray2 = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_end_iter(this.bufferHandle, byArray2);
            OS.gtk_text_buffer_insert(this.bufferHandle, byArray2, byArray, byArray.length);
            OS.gtk_text_buffer_place_cursor(this.bufferHandle, byArray2);
            long l = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen(this.handle, l);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int n = OS.gtk_editable_get_position(this.handle);
            OS.gtk_editable_select_region(this.handle, n, n);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            long l = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            long l2 = OS.gtk_text_buffer_get_selection_bound(this.bufferHandle);
            OS.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, byArray, l);
            OS.gtk_text_buffer_move_mark(this.bufferHandle, l2, byArray);
            OS.gtk_text_buffer_move_mark(this.bufferHandle, l, byArray);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if ((this.style & 4) != 0) {
            OS.gtk_widget_realize(this.handle);
            long l = OS.gtk_entry_get_layout(this.handle);
            OS.pango_layout_get_size(l, nArray, nArray2);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_bounds(this.bufferHandle, byArray, byArray2);
            long l = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray, byArray2, true);
            long l2 = OS.gtk_widget_create_pango_layout(this.handle, l);
            OS.g_free(l);
            OS.pango_layout_set_width(l2, n * 1024);
            OS.pango_layout_get_size(l2, nArray, nArray2);
            OS.g_object_unref(l2);
        }
        int n3 = OS.PANGO_PIXELS(nArray[0]);
        int n4 = OS.PANGO_PIXELS(nArray2[0]);
        if ((this.style & 4) != 0 && this.message.length() > 0) {
            byte[] byArray = Converter.wcsToMbcs(null, this.message, true);
            long l = OS.gtk_widget_create_pango_layout(this.handle, byArray);
            OS.pango_layout_get_size(l, nArray, nArray2);
            OS.g_object_unref(l);
            n3 = Math.max(n3, OS.PANGO_PIXELS(nArray[0]));
        }
        if (n3 == 0) {
            n3 = 64;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        n3 = n == -1 ? n3 : n;
        n4 = n2 == -1 ? n4 : n2;
        Rectangle rectangle = this.computeTrim(0, 0, n3, n4);
        return new Point(rectangle.width, rectangle.height);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        int n5 = 0;
        int n6 = 0;
        if ((this.style & 4) != 0) {
            if ((this.style & 0x800) != 0) {
                long l = OS.gtk_widget_get_style(this.handle);
                n5 += OS.gtk_style_get_xthickness(l);
                n6 += OS.gtk_style_get_ythickness(l);
            }
            GtkBorder gtkBorder = Display.getEntryInnerBorder(this.handle);
            rectangle.x -= gtkBorder.left;
            rectangle.y -= gtkBorder.top;
            rectangle.width += gtkBorder.left + gtkBorder.right;
            rectangle.height += gtkBorder.top + gtkBorder.bottom;
        } else {
            int n7 = OS.gtk_container_get_border_width(this.handle);
            n5 += n7;
            n6 += n7;
        }
        int[] nArray = new int[1];
        OS.gtk_widget_style_get(this.handle, OS.interior_focus, nArray, 0L);
        if (nArray[0] == 0) {
            OS.gtk_widget_style_get(this.handle, OS.focus_line_width, nArray, 0L);
            n5 += nArray[0];
            n6 += nArray[0];
        }
        rectangle.x -= n5;
        rectangle.y -= n6;
        rectangle.width += 2 * n5;
        rectangle.height += 2 * n6;
        ++rectangle.width;
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void copy() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_copy_clipboard(this.handle);
        } else {
            long l = OS.gtk_clipboard_get(0L);
            OS.gtk_text_buffer_copy_clipboard(this.bufferHandle, l);
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_cut_clipboard(this.handle);
        } else {
            long l = OS.gtk_clipboard_get(0L);
            OS.gtk_text_buffer_cut_clipboard(this.bufferHandle, l, OS.gtk_text_view_get_editable(this.handle));
        }
    }

    void deregister() {
        long l;
        super.deregister();
        if (this.bufferHandle != 0L) {
            this.display.removeWidget(this.bufferHandle);
        }
        if ((l = this.imContext()) != 0L) {
            this.display.removeWidget(l);
        }
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean bl2, boolean[] blArray) {
        if (bl) {
            Object[] objectArray;
            Object[] objectArray2;
            int n3 = 0;
            int n4 = 0;
            if ((this.style & 4) != 0) {
                objectArray2 = new int[1];
                objectArray = new int[1];
                OS.gtk_editable_get_selection_bounds(this.handle, objectArray2, objectArray);
                n3 = objectArray2[0];
                n4 = objectArray[0];
            } else {
                objectArray2 = new byte[ITER_SIZEOF];
                objectArray = new byte[ITER_SIZEOF];
                OS.gtk_text_buffer_get_selection_bounds(this.bufferHandle, (byte[])objectArray2, (byte[])objectArray);
                n3 = OS.gtk_text_iter_get_offset((byte[])objectArray2);
                n4 = OS.gtk_text_iter_get_offset((byte[])objectArray);
            }
            if (n3 != n4) {
                if (n4 < n3) {
                    int n5 = n4;
                    n4 = n3;
                    n3 = n5;
                }
                int n6 = -1;
                if ((this.style & 4) != 0) {
                    objectArray = new int[1];
                    int[] nArray = new int[1];
                    long l = OS.gtk_entry_get_layout(this.handle);
                    OS.pango_layout_xy_to_index(l, n * 1024, n2 * 1024, objectArray, nArray);
                    long l2 = OS.pango_layout_get_text(l);
                    n6 = (int)OS.g_utf8_pointer_to_offset(l2, l2 + (long)objectArray[0]) + nArray[0];
                } else {
                    objectArray = new byte[ITER_SIZEOF];
                    OS.gtk_text_view_get_iter_at_location(this.handle, (byte[])objectArray, n, n2);
                    n6 = OS.gtk_text_iter_get_offset((byte[])objectArray);
                }
                if (n3 <= n6 && n6 < n4 && super.dragDetect(n, n2, bl, bl2, blArray)) {
                    if (blArray != null) {
                        blArray[0] = true;
                    }
                    return true;
                }
            }
            return false;
        }
        return super.dragDetect(n, n2, bl, bl2, blArray);
    }

    long eventWindow() {
        return this.paintWindow();
    }

    boolean filterKey(int n, long l) {
        int n2 = OS.gdk_event_get_time(l);
        if (n2 != this.lastEventTime) {
            this.lastEventTime = n2;
            long l2 = this.imContext();
            if (l2 != 0L) {
                return OS.gtk_im_context_filter_keypress(l2, l);
            }
        }
        this.gdkEventKey = l;
        return false;
    }

    void fixIM() {
        long l;
        if (this.gdkEventKey != 0L && this.gdkEventKey != -1L && (l = this.imContext()) != 0L) {
            OS.gtk_im_context_filter_keypress(l, this.gdkEventKey);
            this.gdkEventKey = -1L;
            return;
        }
        this.gdkEventKey = 0L;
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public int getBorderWidth() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return super.getBorderWidth();
        }
        long l = OS.gtk_widget_get_style(this.handle);
        if ((this.style & 0x800) != 0) {
            return OS.gtk_style_get_xthickness(l);
        }
        return 0;
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        long l = OS.gtk_text_buffer_get_insert(this.bufferHandle);
        OS.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, byArray, l);
        return OS.gtk_text_iter_get_line(byArray);
    }

    public Point getCaretLocation() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int n = OS.gtk_editable_get_position(this.handle);
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
                n = OS.gtk_entry_text_index_to_layout_index(this.handle, n);
            }
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_entry_get_layout_offsets(this.handle, nArray, nArray2);
            long l = OS.gtk_entry_get_layout(this.handle);
            PangoRectangle pangoRectangle = new PangoRectangle();
            OS.pango_layout_index_to_pos(l, n, pangoRectangle);
            int n2 = nArray[0] + OS.PANGO_PIXELS(pangoRectangle.x) - this.getBorderWidth();
            int n3 = nArray2[0] + OS.PANGO_PIXELS(pangoRectangle.y);
            return new Point(n2, n3);
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        long l = OS.gtk_text_buffer_get_insert(this.bufferHandle);
        OS.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, byArray, l);
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gtk_text_view_get_iter_location(this.handle, byArray, gdkRectangle);
        int[] nArray = new int[1];
        int[] nArray3 = new int[1];
        OS.gtk_text_view_buffer_to_window_coords(this.handle, 2, gdkRectangle.x, gdkRectangle.y, nArray, nArray3);
        return new Point(nArray[0], nArray3[0]);
    }

    public int getCaretPosition() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            long l = OS.gtk_entry_get_text(this.handle);
            return (int)OS.g_utf8_offset_to_utf16_offset(l, OS.gtk_editable_get_position(this.handle));
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        long l = OS.gtk_text_buffer_get_insert(this.bufferHandle);
        OS.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, byArray, l);
        byte[] byArray2 = new byte[ITER_SIZEOF];
        OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray2, 0);
        long l2 = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray2, byArray, true);
        int n = (int)OS.g_utf8_offset_to_utf16_offset(l2, OS.gtk_text_iter_get_offset(byArray));
        OS.g_free(l2);
        return n;
    }

    public int getCharCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            long l = OS.gtk_entry_get_text(this.handle);
            return (int)OS.g_utf16_strlen(l, -1L);
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        byte[] byArray2 = new byte[ITER_SIZEOF];
        OS.gtk_text_buffer_get_bounds(this.bufferHandle, byArray, byArray2);
        long l = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray, byArray2, true);
        int n = (int)OS.g_utf16_strlen(l, -1L);
        OS.g_free(l);
        return n;
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClick;
    }

    public char getEchoChar() {
        this.checkWidget();
        if ((this.style & 4) != 0 && !OS.gtk_entry_get_visibility(this.handle)) {
            return OS.gtk_entry_get_invisible_char(this.handle);
        }
        return '\u0000';
    }

    public boolean getEditable() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return OS.gtk_editable_get_editable(this.handle);
        }
        return OS.gtk_text_view_get_editable(this.handle);
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getLineCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 1;
        }
        return OS.gtk_text_buffer_get_line_count(this.bufferHandle);
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return "\n";
    }

    public int getLineHeight() {
        this.checkWidget();
        return this.fontHeight(this.getFontDescription(), this.handle);
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    public int getOrientation() {
        return super.getOrientation();
    }

    int getPosition(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int n = -1;
        if ((this.style & 4) != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            long l = OS.gtk_entry_get_layout(this.handle);
            OS.pango_layout_xy_to_index(l, point.x * 1024, point.y * 1024, nArray, nArray2);
            long l2 = OS.pango_layout_get_text(l);
            n = (int)OS.g_utf16_pointer_to_offset(l2, l2 + (long)nArray[0]) + nArray2[0];
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            OS.gtk_text_view_get_iter_at_location(this.handle, byArray, point.x, point.y);
            byte[] byArray2 = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray2, 0);
            long l = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray2, byArray, true);
            n = (int)OS.g_utf8_offset_to_utf16_offset(l, OS.gtk_text_iter_get_offset(byArray));
            OS.g_free(l);
        }
        return n;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_editable_get_selection_bounds(this.handle, nArray, nArray2);
            long l = OS.gtk_entry_get_text(this.handle);
            nArray[0] = (int)OS.g_utf8_offset_to_utf16_offset(l, nArray[0]);
            nArray2[0] = (int)OS.g_utf8_offset_to_utf16_offset(l, nArray2[0]);
            return new Point(nArray[0], nArray2[0]);
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        byte[] byArray2 = new byte[ITER_SIZEOF];
        OS.gtk_text_buffer_get_selection_bounds(this.bufferHandle, byArray, byArray2);
        byte[] byArray3 = new byte[ITER_SIZEOF];
        OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray3, 0);
        long l = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray3, byArray2, true);
        int n = (int)OS.g_utf8_offset_to_utf16_offset(l, OS.gtk_text_iter_get_offset(byArray));
        int n2 = (int)OS.g_utf8_offset_to_utf16_offset(l, OS.gtk_text_iter_get_offset(byArray2));
        OS.g_free(l);
        return new Point(n, n2);
    }

    public int getSelectionCount() {
        this.checkWidget();
        Point point = this.getSelection();
        return Math.abs(point.y - point.x);
    }

    public String getSelectionText() {
        this.checkWidget();
        Point point = this.getSelection();
        return this.getText().substring(point.x, point.y);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabs;
    }

    int getTabWidth(int n) {
        byte[] byArray = Converter.wcsToMbcs(null, " ", true);
        long l = OS.gtk_widget_create_pango_layout(this.handle, byArray);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_size(l, nArray, nArray2);
        OS.g_object_unref(l);
        return nArray[0] * n;
    }

    public String getText() {
        return new String(this.getTextChars());
    }

    public String getText(int n, int n2) {
        this.checkWidget();
        if (n > n2 || n2 < 0) {
            return "";
        }
        String string = this.getText();
        int n3 = string.length();
        if (n > (n2 = Math.min(n2, n3 - 1))) {
            return "";
        }
        n = Math.max(0, n);
        return string.substring(n, n2 + 1);
    }

    public char[] getTextChars() {
        byte[] byArray;
        long l;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            l = OS.gtk_entry_get_text(this.handle);
        } else {
            byte[] byArray2 = new byte[ITER_SIZEOF];
            byArray = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_bounds(this.bufferHandle, byArray2, byArray);
            l = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray2, byArray, true);
        }
        if (l == 0L) {
            return new char[0];
        }
        int n = OS.strlen(l);
        byArray = new byte[n];
        OS.memmove(byArray, l, (long)n);
        if ((this.style & 2) != 0) {
            OS.g_free(l);
        }
        return Converter.mbcsToWcs(null, byArray);
    }

    public int getTextLimit() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return LIMIT;
        }
        int n = OS.gtk_entry_get_max_length(this.handle);
        return n == 0 ? 65535 : n;
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gtk_text_view_get_visible_rect(this.handle, gdkRectangle);
        OS.gtk_text_view_get_line_at_y(this.handle, byArray, gdkRectangle.y, null);
        return OS.gtk_text_iter_get_line(byArray);
    }

    public int getTopPixel() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gtk_text_view_get_visible_rect(this.handle, gdkRectangle);
        int[] nArray = new int[1];
        OS.gtk_text_view_get_line_at_y(this.handle, byArray, gdkRectangle.y, nArray);
        return nArray[0];
    }

    long gtk_activate(long l) {
        this.sendSelectionEvent(14);
        return 0L;
    }

    long gtk_button_press_event(long l, long l2) {
        long l3 = super.gtk_button_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
        if (!this.doubleClick) {
            switch (gdkEventButton.type) {
                case 5: 
                case 6: {
                    return 1L;
                }
            }
        }
        return l3;
    }

    long gtk_changed(long l) {
        boolean bl = false;
        long l2 = OS.gtk_get_current_event();
        if (l2 != 0L) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: {
                    bl = true;
                }
            }
            OS.gdk_event_free(l2);
        }
        if (bl) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        if ((this.style & 0x80) != 0 && (this.style & 0x100) != 0) {
            long l3 = OS.gtk_entry_get_text(this.handle);
            OS.gtk_entry_set_icon_sensitive(this.handle, 1, OS.g_utf16_strlen(l3, -1L) > 0L);
        }
        return 0L;
    }

    long gtk_commit(long l, long l2) {
        if (l2 == 0L) {
            return 0L;
        }
        if ((this.style & 4) != 0 && !OS.gtk_editable_get_editable(this.handle)) {
            return 0L;
        }
        int n = OS.strlen(l2);
        if (n == 0) {
            return 0L;
        }
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l2, (long)n);
        char[] cArray = Converter.mbcsToWcs(null, byArray);
        char[] cArray2 = this.sendIMKeyEvent(1, null, cArray);
        if (cArray2 == null) {
            return 0L;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 9L);
        int n2 = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
        int n3 = 17;
        OS.g_signal_handlers_unblock_matched(l, n3, n2, 0, 0L, 0L, this.handle);
        if (cArray2 == cArray) {
            OS.g_signal_emit_by_name(l, OS.commit, l2);
        } else {
            byArray = Converter.wcsToMbcs(null, cArray2, true);
            OS.g_signal_emit_by_name(l, OS.commit, byArray);
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 9L);
        OS.g_signal_handlers_block_matched(l, n3, n2, 0, 0L, 0L, this.handle);
        if ((this.style & 4) != 0 && this.fixStart != -1 && this.fixEnd != -1) {
            OS.gtk_editable_set_position(this.handle, this.fixStart);
            OS.gtk_editable_select_region(this.handle, this.fixStart, this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0L;
    }

    long gtk_delete_range(long l, long l2, long l3) {
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        byte[] byArray2 = new byte[ITER_SIZEOF];
        OS.memmove(byArray, l2, (long)byArray.length);
        OS.memmove(byArray2, l3, (long)byArray2.length);
        int n = OS.gtk_text_iter_get_offset(byArray);
        int n2 = OS.gtk_text_iter_get_offset(byArray2);
        byte[] byArray3 = new byte[ITER_SIZEOF];
        OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray3, 0);
        long l4 = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray3, byArray2, true);
        n = (int)OS.g_utf8_offset_to_utf16_offset(l4, n);
        n2 = (int)OS.g_utf8_offset_to_utf16_offset(l4, n2);
        OS.g_free(l4);
        String string = this.verifyText("", n, n2);
        if (string == null) {
            OS.gtk_text_buffer_get_selection_bounds(this.bufferHandle, byArray, byArray2);
            n = OS.gtk_text_iter_get_offset(byArray);
            n2 = OS.gtk_text_iter_get_offset(byArray2);
            if (n != n2) {
                this.fixStart = n;
                this.fixEnd = n2;
            }
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.delete_range);
        } else if (string.length() > 0) {
            byte[] byArray4 = Converter.wcsToMbcs(null, string, false);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            OS.gtk_text_buffer_delete(this.bufferHandle, byArray, byArray2);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            OS.gtk_text_buffer_insert(this.bufferHandle, byArray, byArray4, byArray4.length);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.delete_range);
        }
        return 0L;
    }

    long gtk_delete_text(long l, long l2, long l3) {
        int n;
        int n2;
        String string;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        long l4 = OS.gtk_entry_get_text(this.handle);
        if (l3 == -1L) {
            l3 = OS.g_utf8_strlen(l4, -1L);
        }
        if ((string = this.verifyText("", n2 = (int)OS.g_utf8_offset_to_utf16_offset(l4, l2), n = (int)OS.g_utf8_offset_to_utf16_offset(l4, l3))) == null) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_editable_get_selection_bounds(this.handle, nArray, nArray2);
            if (nArray[0] != nArray2[0]) {
                this.fixStart = nArray[0];
                this.fixEnd = nArray2[0];
            }
            OS.g_signal_stop_emission_by_name(this.handle, OS.delete_text);
        } else if (string.length() > 0) {
            int[] nArray = new int[]{(int)l3};
            byte[] byArray = Converter.wcsToMbcs(null, string, false);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            OS.gtk_editable_insert_text(this.handle, byArray, byArray.length, nArray);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_editable_set_position(this.handle, nArray[0]);
        }
        return 0L;
    }

    long gtk_event_after(long l, long l2) {
        if (this.cursor != null) {
            this.setCursor(this.cursor.handle);
        }
        if ((this.style & 4) != 0 && this.display.entrySelectOnFocus) {
            GdkEvent gdkEvent = new GdkEvent();
            OS.memmove(gdkEvent, l2, (long)GdkEvent.sizeof);
            switch (gdkEvent.type) {
                case 12: {
                    GdkEventFocus gdkEventFocus = new GdkEventFocus();
                    OS.memmove(gdkEventFocus, l2, (long)GdkEventFocus.sizeof);
                    if (gdkEventFocus.in != 0) break;
                    long l3 = OS.gtk_settings_get_default();
                    OS.g_object_set(l3, OS.gtk_entry_select_on_focus, true, 0L);
                }
            }
        }
        return super.gtk_event_after(l, l2);
    }

    long gtk_expose_event(long l, long l2) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        long l3 = super.gtk_expose_event(l, l2);
        if ((this.style & 4) != 0 && this.message.length() > 0) {
            long l4 = OS.gtk_entry_get_text(this.handle);
            if (!OS.GTK_WIDGET_HAS_FOCUS(this.handle) && OS.strlen(l4) == 0) {
                GdkEventExpose gdkEventExpose = new GdkEventExpose();
                OS.memmove(gdkEventExpose, l2, (long)GdkEventExpose.sizeof);
                long l5 = this.paintWindow();
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.gdk_drawable_get_size(l5, nArray, nArray2);
                GtkBorder gtkBorder = Display.getEntryInnerBorder(this.handle);
                int n = nArray[0] - gtkBorder.left - gtkBorder.right;
                int n2 = nArray2[0] - gtkBorder.top - gtkBorder.bottom;
                long l6 = OS.gtk_widget_get_pango_context(this.handle);
                long l7 = OS.pango_context_get_language(l6);
                long l8 = OS.pango_context_get_metrics(l6, this.getFontDescription(), l7);
                int n3 = OS.PANGO_PIXELS(OS.pango_font_metrics_get_ascent(l8));
                int n4 = OS.PANGO_PIXELS(OS.pango_font_metrics_get_descent(l8));
                OS.pango_font_metrics_unref(l8);
                byte[] byArray = Converter.wcsToMbcs(null, this.message, true);
                long l9 = OS.gtk_widget_create_pango_layout(this.handle, byArray);
                long l10 = OS.pango_layout_get_line(l9, 0);
                PangoRectangle pangoRectangle = new PangoRectangle();
                OS.pango_layout_line_get_extents(l10, null, pangoRectangle);
                pangoRectangle.y = OS.PANGO_PIXELS(pangoRectangle.y);
                pangoRectangle.height = OS.PANGO_PIXELS(pangoRectangle.height);
                pangoRectangle.width = OS.PANGO_PIXELS(pangoRectangle.width);
                int n5 = (n2 - n3 - n4) / 2 + n3 + pangoRectangle.y;
                if (pangoRectangle.height > n2) {
                    n5 = (n2 - pangoRectangle.height) / 2;
                } else if (n5 < 0) {
                    n5 = 0;
                } else if (n5 + pangoRectangle.height > n2) {
                    n5 = n2 - pangoRectangle.height;
                }
                n5 += gtkBorder.top;
                int n6 = gtkBorder.left;
                boolean bl = (this.style & 0x4000000) != 0;
                int n7 = this.style & 0x1024000;
                switch (n7) {
                    case 16384: {
                        n6 = bl ? n - pangoRectangle.width : gtkBorder.left;
                        break;
                    }
                    case 0x1000000: {
                        n6 = (n - pangoRectangle.width) / 2;
                        break;
                    }
                    case 131072: {
                        n6 = bl ? gtkBorder.left : n - pangoRectangle.width;
                    }
                }
                long l11 = OS.gdk_gc_new(l5);
                long l12 = OS.gtk_widget_get_style(this.handle);
                GdkColor gdkColor = new GdkColor();
                OS.gtk_style_get_text(l12, 4, gdkColor);
                GdkColor gdkColor2 = new GdkColor();
                OS.gtk_style_get_base(l12, 0, gdkColor2);
                OS.gdk_draw_layout_with_colors(l5, l11, n6, n5, l9, gdkColor, gdkColor2);
                OS.g_object_unref(l11);
                OS.g_object_unref(l9);
            }
        }
        return l3;
    }

    long gtk_focus_out_event(long l, long l2) {
        this.fixIM();
        return super.gtk_focus_out_event(l, l2);
    }

    long gtk_grab_focus(long l) {
        long l2 = super.gtk_grab_focus(l);
        if ((this.style & 4) != 0 && this.display.entrySelectOnFocus) {
            long l3 = OS.gtk_settings_get_default();
            OS.g_object_set(l3, OS.gtk_entry_select_on_focus, false, 0L);
        }
        return l2;
    }

    long gtk_icon_release(long l, long l2, long l3) {
        Event event = new Event();
        if (l2 == 0L) {
            event.detail = 512;
        } else {
            event.detail = 256;
            OS.gtk_editable_delete_text(this.handle, 0, -1);
        }
        this.sendSelectionEvent(14, event, false);
        return 0L;
    }

    long gtk_insert_text(long l, long l2, long l3, long l4) {
        String string;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        if (l2 == 0L || l3 == 0L) {
            return 0L;
        }
        byte[] byArray = new byte[(int)l3];
        OS.memmove(byArray, l2, (long)byArray.length);
        String string2 = new String(Converter.mbcsToWcs(null, byArray));
        int[] nArray = new int[1];
        OS.memmove(nArray, l4, 4L);
        long l5 = OS.gtk_entry_get_text(this.handle);
        if (nArray[0] == -1) {
            nArray[0] = (int)OS.g_utf8_strlen(l5, -1L);
        }
        int n = nArray[0];
        int n2 = nArray[0];
        if (this.fixStart != -1 && this.fixEnd != -1) {
            n = nArray[0] = this.fixStart;
            n2 = this.fixEnd;
            this.fixEnd = -1;
            this.fixStart = -1;
        }
        if ((string = this.verifyText(string2, n = (int)OS.g_utf8_offset_to_utf16_offset(l5, n), n2 = (int)OS.g_utf8_offset_to_utf16_offset(l5, n2))) != string2) {
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            OS.gtk_editable_get_selection_bounds(this.handle, nArray2, nArray3);
            if (string != null) {
                if (nArray2[0] != nArray3[0]) {
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
                    OS.gtk_editable_delete_selection(this.handle);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
                }
                byte[] byArray2 = Converter.wcsToMbcs(null, string, false);
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
                OS.gtk_editable_insert_text(this.handle, byArray2, byArray2.length, nArray);
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
                nArray2[0] = nArray3[0] = nArray[0];
            }
            nArray[0] = nArray3[0];
            if (nArray2[0] != nArray3[0]) {
                this.fixStart = nArray2[0];
                this.fixEnd = nArray3[0];
            }
            OS.memmove(l4, nArray, 4L);
            OS.g_signal_stop_emission_by_name(this.handle, OS.insert_text);
        }
        return 0L;
    }

    long gtk_key_press_event(long l, long l2) {
        long l3 = super.gtk_key_press_event(l, l2);
        if (l3 != 0L) {
            this.fixIM();
        }
        if (this.gdkEventKey == -1L) {
            l3 = 1L;
        }
        this.gdkEventKey = 0L;
        return l3;
    }

    long gtk_populate_popup(long l, long l2) {
        if ((this.style & 0x4000000) != 0) {
            OS.gtk_widget_set_direction(l2, 2);
            OS.gtk_container_forall(l2, this.display.setDirectionProc, 2L);
        }
        return 0L;
    }

    long gtk_text_buffer_insert_text(long l, long l2, long l3, long l4) {
        int n;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        OS.memmove(byArray, l2, (long)byArray.length);
        int n2 = n = OS.gtk_text_iter_get_offset(byArray);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            n = this.fixStart;
            n2 = this.fixEnd;
            this.fixEnd = -1;
            this.fixStart = -1;
        }
        byte[] byArray2 = new byte[ITER_SIZEOF];
        OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray2, 0);
        long l5 = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray2, byArray, true);
        n = (int)OS.g_utf8_offset_to_utf16_offset(l5, n);
        n2 = (int)OS.g_utf8_offset_to_utf16_offset(l5, n2);
        OS.g_free(l5);
        byte[] byArray3 = new byte[(int)l4];
        OS.memmove(byArray3, l3, (long)byArray3.length);
        String string = new String(Converter.mbcsToWcs(null, byArray3));
        String string2 = this.verifyText(string, n, n2);
        if (string2 == null) {
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.insert_text);
        } else if (string2 != string) {
            byte[] byArray4 = Converter.wcsToMbcs(null, string2, false);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            OS.gtk_text_buffer_insert(this.bufferHandle, l2, byArray4, byArray4.length);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.insert_text);
        }
        return 0L;
    }

    void hookEvents() {
        long l;
        super.hookEvents();
        if ((this.style & 4) != 0) {
            OS.g_signal_connect_closure(this.handle, OS.changed, this.display.closures[6], true);
            OS.g_signal_connect_closure(this.handle, OS.insert_text, this.display.closures[26], false);
            OS.g_signal_connect_closure(this.handle, OS.delete_text, this.display.closures[13], false);
            OS.g_signal_connect_closure(this.handle, OS.activate, this.display.closures[1], false);
            OS.g_signal_connect_closure(this.handle, OS.grab_focus, this.display.closures[23], false);
            OS.g_signal_connect_closure(this.handle, OS.populate_popup, this.display.closures[37], false);
            if ((this.style & 0x80) != 0 && OS.GTK_VERSION >= OS.VERSION(2, 16, 0)) {
                OS.g_signal_connect_closure(this.handle, OS.icon_release, this.display.closures[67], false);
            }
        } else {
            OS.g_signal_connect_closure(this.bufferHandle, OS.changed, this.display.closures[6], false);
            OS.g_signal_connect_closure(this.bufferHandle, OS.insert_text, this.display.closures[52], false);
            OS.g_signal_connect_closure(this.bufferHandle, OS.delete_range, this.display.closures[12], false);
            OS.g_signal_connect_closure(this.handle, OS.populate_popup, this.display.closures[37], false);
        }
        if ((l = this.imContext()) != 0L) {
            OS.g_signal_connect_closure(l, OS.commit, this.display.closures[9], false);
            int n = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
            int n2 = 17;
            OS.g_signal_handlers_block_matched(l, n2, n, 0, 0L, 0L, this.handle);
        }
    }

    long imContext() {
        if ((this.style & 4) != 0) {
            return OS.gtk_editable_get_editable(this.handle) ? OS.GTK_ENTRY_IM_CONTEXT(this.handle) : 0L;
        }
        return OS.GTK_TEXTVIEW_IM_CONTEXT(this.handle);
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, false);
        if ((this.style & 4) != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_editable_get_selection_bounds(this.handle, nArray, nArray2);
            OS.gtk_editable_delete_selection(this.handle);
            OS.gtk_editable_insert_text(this.handle, byArray, byArray.length, nArray);
            OS.gtk_editable_set_position(this.handle, nArray[0]);
        } else {
            byte[] byArray2 = new byte[ITER_SIZEOF];
            byte[] byArray3 = new byte[ITER_SIZEOF];
            if (OS.gtk_text_buffer_get_selection_bounds(this.bufferHandle, byArray2, byArray3)) {
                OS.gtk_text_buffer_delete(this.bufferHandle, byArray2, byArray3);
            }
            OS.gtk_text_buffer_insert(this.bufferHandle, byArray2, byArray, byArray.length);
            OS.gtk_text_buffer_place_cursor(this.bufferHandle, byArray2);
            long l = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen(this.handle, l);
        }
    }

    long paintWindow() {
        if ((this.style & 4) != 0) {
            long l = super.paintWindow();
            long l2 = OS.gdk_window_get_children(l);
            if (l2 != 0L) {
                do {
                    l = OS.g_list_data(l2);
                } while ((l2 = OS.g_list_next(l2)) != 0L);
            }
            OS.g_list_free(l2);
            return l;
        }
        OS.gtk_widget_realize(this.handle);
        return OS.gtk_text_view_get_window(this.handle, 2);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_paste_clipboard(this.handle);
        } else {
            long l = OS.gtk_clipboard_get(0L);
            OS.gtk_text_buffer_paste_clipboard(this.bufferHandle, l, null, OS.gtk_text_view_get_editable(this.handle));
        }
    }

    void register() {
        long l;
        super.register();
        if (this.bufferHandle != 0L) {
            this.display.addWidget(this.bufferHandle, this);
        }
        if ((l = this.imContext()) != 0L) {
            this.display.addWidget(l, this);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.fixIM();
        if (OS.GTK_VERSION < OS.VERSION(2, 6, 0) && (this.style & 2) != 0) {
            long l = OS.gtk_clipboard_get(0L);
            OS.gtk_text_buffer_paste_clipboard(this.bufferHandle, l, null, OS.gtk_text_view_get_editable(this.handle));
        }
        this.message = null;
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_select_region(this.handle, 0, -1);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray, 0);
            OS.gtk_text_buffer_get_end_iter(this.bufferHandle, byArray2);
            long l = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            long l2 = OS.gtk_text_buffer_get_selection_bound(this.bufferHandle);
            OS.gtk_text_buffer_move_mark(this.bufferHandle, l2, byArray);
            OS.gtk_text_buffer_move_mark(this.bufferHandle, l, byArray2);
        }
    }

    void setBackgroundColor(GdkColor gdkColor) {
        super.setBackgroundColor(gdkColor);
        OS.gtk_widget_modify_base(this.handle, 0, gdkColor);
    }

    void setCursor(long l) {
        long l2 = 0L;
        if (l == 0L) {
            l2 = OS.gdk_cursor_new(152L);
        }
        super.setCursor(l != 0L ? l : l2);
        if (l == 0L) {
            OS.gdk_cursor_destroy(l2);
        }
    }

    public void setDoubleClickEnabled(boolean bl) {
        this.checkWidget();
        this.doubleClick = bl;
    }

    public void setEchoChar(char c) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_entry_set_visibility(this.handle, c == '\u0000');
            OS.gtk_entry_set_invisible_char(this.handle, c);
        }
    }

    public void setEditable(boolean bl) {
        this.checkWidget();
        this.style &= 0xFFFFFFF7;
        if (!bl) {
            this.style |= 8;
        }
        if ((this.style & 4) != 0) {
            OS.gtk_editable_set_editable(this.handle, bl);
        } else {
            OS.gtk_text_view_set_editable(this.handle, bl);
        }
    }

    void setFontDescription(long l) {
        super.setFontDescription(l);
        this.setTabStops(this.tabs);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        this.redraw(false);
    }

    public void setOrientation(int n) {
        this.checkWidget();
    }

    public void setSelection(int n) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            long l = OS.gtk_entry_get_text(this.handle);
            n = (int)OS.g_utf16_offset_to_utf8_offset(l, n);
            OS.gtk_editable_set_position(this.handle, n);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_bounds(this.bufferHandle, byArray, byArray2);
            long l = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray, byArray2, true);
            n = (int)OS.g_utf16_offset_to_utf8_offset(l, n);
            OS.g_free(l);
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray, n);
            OS.gtk_text_buffer_place_cursor(this.bufferHandle, byArray);
            long l2 = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen(this.handle, l2);
        }
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            long l = OS.gtk_entry_get_text(this.handle);
            n = (int)OS.g_utf16_offset_to_utf8_offset(l, n);
            n2 = (int)OS.g_utf16_offset_to_utf8_offset(l, n2);
            OS.gtk_editable_set_position(this.handle, n);
            OS.gtk_editable_select_region(this.handle, n, n2);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_bounds(this.bufferHandle, byArray, byArray2);
            long l = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray, byArray2, true);
            n = (int)OS.g_utf16_offset_to_utf8_offset(l, n);
            n2 = (int)OS.g_utf16_offset_to_utf8_offset(l, n2);
            OS.g_free(l);
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray, n);
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray2, n2);
            long l2 = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            long l3 = OS.gtk_text_buffer_get_selection_bound(this.bufferHandle);
            OS.gtk_text_buffer_move_mark(this.bufferHandle, l3, byArray);
            OS.gtk_text_buffer_move_mark(this.bufferHandle, l2, byArray2);
        }
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSelection(point.x, point.y);
    }

    public void setTabs(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.tabs = n;
        this.setTabStops(this.tabs);
    }

    void setTabStops(int n) {
        if ((this.style & 4) != 0) {
            return;
        }
        int n2 = this.getTabWidth(n);
        long l = OS.pango_tab_array_new(1, false);
        OS.pango_tab_array_set_tab(l, 0, 0L, n2);
        OS.gtk_text_view_set_tabs(this.handle, l);
        OS.pango_tab_array_free(l);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount())) == null) {
            return;
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        this.setText(cArray);
    }

    public void setTextChars(char[] cArray) {
        this.checkWidget();
        if (cArray == null) {
            this.error(4);
        }
        if (this.hooks(25) || this.filters(25)) {
            String string = this.verifyText(new String(cArray), 0, this.getCharCount());
            if (string == null) {
                return;
            }
            cArray = new char[string.length()];
            string.getChars(0, cArray.length, cArray, 0);
        }
        this.setText(cArray);
    }

    void setText(char[] cArray) {
        if ((this.style & 4) != 0) {
            byte[] byArray = Converter.wcsToMbcs(null, cArray, true);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            OS.gtk_entry_set_text(this.handle, byArray);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
        } else {
            byte[] byArray = Converter.wcsToMbcs(null, cArray, false);
            byte[] byArray2 = new byte[ITER_SIZEOF];
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            OS.gtk_text_buffer_set_text(this.bufferHandle, byArray, byArray.length);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray2, 0);
            OS.gtk_text_buffer_place_cursor(this.bufferHandle, byArray2);
            long l = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen(this.handle, l);
        }
        this.sendEvent(24);
        if ((this.style & 0x80) != 0 && (this.style & 0x100) != 0) {
            OS.gtk_entry_set_icon_sensitive(this.handle, 1, true);
        }
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        if ((this.style & 4) != 0) {
            OS.gtk_entry_set_max_length(this.handle, n);
        }
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        OS.gtk_text_buffer_get_iter_at_line(this.bufferHandle, byArray, n);
        OS.gtk_text_view_scroll_to_iter(this.handle, byArray, 0.0, true, 0.0, 0.0);
    }

    public void showSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        long l = OS.gtk_text_buffer_get_selection_bound(this.bufferHandle);
        OS.gtk_text_view_scroll_mark_onscreen(this.handle, l);
        l = OS.gtk_text_buffer_get_insert(this.bufferHandle);
        OS.gtk_text_view_scroll_mark_onscreen(this.handle, l);
    }

    boolean translateTraversal(GdkEventKey gdkEventKey) {
        int n = gdkEventKey.keyval;
        switch (n) {
            case 65293: 
            case 65421: {
                long l = this.imContext();
                if (l == 0L) break;
                long[] lArray = new long[1];
                OS.gtk_im_context_get_preedit_string(l, lArray, null, null);
                if (lArray[0] == 0L) break;
                int n2 = OS.strlen(lArray[0]);
                OS.g_free(lArray[0]);
                if (n2 == 0) break;
                return false;
            }
        }
        return super.translateTraversal(gdkEventKey);
    }

    int traversalCode(int n, GdkEventKey gdkEventKey) {
        int n2 = super.traversalCode(n, gdkEventKey);
        if ((this.style & 8) != 0) {
            return n2;
        }
        if ((this.style & 2) != 0) {
            n2 &= 0xFFFFFFFB;
            if (n == 65289 && gdkEventKey != null) {
                boolean bl;
                boolean bl2 = bl = (gdkEventKey.state & 1) == 0;
                if (bl && (gdkEventKey.state & 4) == 0) {
                    n2 &= 0xFFFFFFE7;
                }
            }
        }
        return n2;
    }

    String verifyText(String string, int n, int n2) {
        if (string != null && string.length() == 0 && n == n2) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = n;
        event.end = n2;
        long l = OS.gtk_get_current_event();
        if (l != 0L) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, l, (long)GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: {
                    this.setKeyState(event, gdkEventKey);
                }
            }
            OS.gdk_event_free(l);
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

