/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tintfu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import net.sourceforge.tintfu.DotAttribute;
import net.sourceforge.tintfu.DotEdge;
import net.sourceforge.tintfu.DotTreeNode;

public class EdgeListEditor
extends JDialog {
    DotTreeNode root;
    List nodes = new ArrayList();
    List edges = new ArrayList();
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JPanel jPanel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JPanel buttonPanel;
    private JButton okButton;
    private JTable jTable1;
    private JButton buttAddEdge;
    private JComboBox boxTo;
    private JComboBox boxFrom;
    private JButton cancelButton;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private int returnStatus = 0;

    public EdgeListEditor(Frame parent, boolean modal, DotTreeNode root) {
        super(parent, modal);
        this.root = root;
        root.getGlobalLists(this.nodes, this.edges);
        this.initComponents();
        String[] names = new String[this.nodes.size()];
        int i = 0;
        while (i < this.nodes.size()) {
            names[i] = ((DotTreeNode)this.nodes.get((int)i)).elm.getName();
            ++i;
        }
        this.boxFrom.setModel(new DefaultComboBoxModel<String>(names));
        this.boxTo.setModel(new DefaultComboBoxModel<String>(names));
    }

    TableModel createTableModel() {
        return new EdgeTableModel();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.boxFrom = new JComboBox();
        this.jLabel2 = new JLabel();
        this.boxTo = new JComboBox();
        this.buttAddEdge = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                EdgeListEditor.this.closeDialog(evt);
            }
        });
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EdgeListEditor.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EdgeListEditor.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.jPanel1.setLayout(new BorderLayout());
        this.jLabel1.setText("From");
        this.jPanel2.add(this.jLabel1);
        this.jPanel2.add(this.boxFrom);
        this.jLabel2.setText("To");
        this.jPanel2.add(this.jLabel2);
        this.jPanel2.add(this.boxTo);
        this.buttAddEdge.setText("Add");
        this.buttAddEdge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EdgeListEditor.this.buttAddEdgeActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.buttAddEdge);
        this.jPanel1.add((Component)this.jPanel2, "North");
        this.jTable1.setModel(this.createTableModel());
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void buttAddEdgeActionPerformed(ActionEvent evt) {
        DotTreeNode n = new DotTreeNode(new DotEdge(DotEdge.createEdgeList()));
        ((DotAttribute)((DotEdge)n.elm).fields.get(0)).setValue(this.boxFrom.getSelectedItem().toString());
        ((DotAttribute)((DotEdge)n.elm).fields.get(1)).setValue(this.boxTo.getSelectedItem().toString());
        this.root.add(n);
        this.edges.add(n);
        this.jTable1.setModel(this.createTableModel());
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    class EdgeTableModel
    extends AbstractTableModel {
        EdgeTableModel() {
        }

        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            return EdgeListEditor.this.edges.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            DotEdge ed = (DotEdge)((DotTreeNode)EdgeListEditor.this.edges.get((int)rowIndex)).elm;
            DotAttribute da = null;
            switch (columnIndex) {
                case 0: 
                case 1: {
                    da = (DotAttribute)ed.fields.get(columnIndex);
                    break;
                }
                case 2: {
                    da = ed.getByName("dir");
                    break;
                }
                case 3: {
                    da = ed.getByName("label");
                }
            }
            if (da == null) {
                System.out.println("getValueAt: " + rowIndex + ", " + columnIndex + " ???");
                System.exit(1);
            }
            if (columnIndex < 2) {
                return EdgeListEditor.this.root.getNodeDesc(da.getValue());
            }
            return da.getValue();
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "From";
                }
                case 1: {
                    return "To";
                }
                case 2: {
                    return "Direction";
                }
                case 3: {
                    return "Label";
                }
            }
            return "getColumnName: " + column + " ???";
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 3;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            DotEdge ed = (DotEdge)((DotTreeNode)EdgeListEditor.this.edges.get((int)rowIndex)).elm;
            DotAttribute da = ed.getByName("label");
            da.setValue(aValue.toString());
        }
    }
}

