/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tintfu;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class Queue
extends LinkedList {
    private int queueSize = 0;

    public Queue() {
    }

    public Queue(int queueSize) {
        if (queueSize > 0) {
            this.queueSize = queueSize;
        }
    }

    public synchronized void setQueueSize(int queueSize) {
        this.queueSize = queueSize > 0 ? queueSize : 0;
        this.reduce();
    }

    public synchronized int getQueueSize() {
        return this.queueSize;
    }

    public synchronized void add(int index, Object element) {
        super.add(index, element);
        this.reduce();
    }

    public synchronized boolean add(Object o) {
        boolean retValue = super.add(o);
        if (retValue) {
            this.reduce();
        }
        return retValue;
    }

    public synchronized boolean addAll(Collection c) {
        boolean retValue = super.addAll(c);
        if (retValue) {
            this.reduce();
        }
        return retValue;
    }

    public synchronized boolean addAll(int index, Collection c) {
        boolean retValue = super.addAll(index, c);
        if (retValue) {
            this.reduce();
        }
        return retValue;
    }

    public synchronized void addFirst(Object o) {
        super.addFirst(o);
        this.reduce();
    }

    public synchronized void addLast(Object o) {
        super.addLast(o);
        this.reduce();
    }

    public synchronized boolean contains(Object obj) {
        return super.contains(obj);
    }

    public synchronized Object dequeue() {
        while (this.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        Object obj = this.get(0);
        this.remove(0);
        this.notifyAll();
        return obj;
    }

    public synchronized Queue dequeueAll() {
        Queue ret = new Queue();
        Collections.copy(ret, this);
        this.clear();
        this.notifyAll();
        return ret;
    }

    public synchronized void enqueue(Object value) {
        while (this.queueSize != 0 && this.size() >= this.queueSize) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.add(value);
        this.notifyAll();
    }

    public synchronized void enqueueAll(Collection values) {
        Iterator i = values.iterator();
        while (i.hasNext()) {
            this.enqueue(i.next());
        }
    }

    public synchronized void enqueueAll(Object[] values) {
        int i = 0;
        while (i < values.length) {
            this.enqueue(values[i]);
            ++i;
        }
    }

    private void reduce() {
        if (this.queueSize > 0) {
            while (this.size() > this.queueSize) {
                this.remove(0);
            }
        }
        this.notifyAll();
    }
}

