/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tintfu;

import java.io.BufferedReader;
import net.sourceforge.tintfu.AbstractTokenizer;
import net.sourceforge.tintfu.DefaultToken;
import net.sourceforge.tintfu.Token;

public class WHSPTokenizer
extends AbstractTokenizer {
    public static final int WHSP = 32;
    public static final int EOLN = 10;
    private BufferedReader in = null;

    public WHSPTokenizer(BufferedReader in) {
        this.in = in;
    }

    public Token nextToken() {
        try {
            String w = "";
            int c = this.in.read();
            if (c == -1) {
                return DefaultToken.EOF;
            }
            char ch = (char)c;
            while (!Character.isISOControl(ch) && !Character.isSpaceChar(ch)) {
                w = w + ch;
                this.in.mark(100);
                c = this.in.read();
                if (c == -1) {
                    return new DefaultToken(w);
                }
                ch = (char)c;
            }
            if (w.length() > 0) {
                this.in.reset();
                return new DefaultToken(w);
            }
            int type = 32;
            char ch2 = (char)c;
            while (Character.isISOControl(ch2) || Character.isSpaceChar(ch2)) {
                if (ch2 == '\n') {
                    type = 10;
                }
                this.in.mark(100);
                c = this.in.read();
                if (c == -1) break;
                ch2 = (char)c;
            }
            this.in.reset();
            return new DefaultToken(" ", type);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return DefaultToken.EOF;
        }
    }
}

