/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarSeparatorUI;

public class TinyToolBarSeparatorUI
extends BasicToolBarSeparatorUI {
    private static final int YQ_SIZE = 7;

    public static ComponentUI createUI(JComponent jComponent) {
        return new TinyToolBarSeparatorUI();
    }

    protected void installDefaults(JSeparator jSeparator) {
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        JToolBar.Separator separator = (JToolBar.Separator)jComponent;
        if (separator.getOrientation() == 0) {
            return new Dimension(0, 1);
        }
        return new Dimension(1, 0);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        JToolBar.Separator separator = (JToolBar.Separator)jComponent;
        Dimension dimension = separator.getSeparatorSize();
        if (separator.getOrientation() == 0) {
            if (dimension != null) {
                return new Dimension(Short.MAX_VALUE, dimension.height);
            }
            return new Dimension(Short.MAX_VALUE, 7);
        }
        if (dimension != null) {
            return new Dimension(Short.MAX_VALUE, dimension.width);
        }
        return new Dimension(7, Short.MAX_VALUE);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        JToolBar.Separator separator = (JToolBar.Separator)jComponent;
        Dimension dimension = separator.getSeparatorSize();
        if (dimension != null) {
            return dimension.getSize();
        }
        if (separator.getOrientation() == 0) {
            return new Dimension(0, 7);
        }
        return new Dimension(7, 0);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.drawXpToolBarSeparator(graphics, jComponent);
    }

    protected void drawXpToolBarSeparator(Graphics graphics, JComponent jComponent) {
        JToolBar.Separator separator = (JToolBar.Separator)jComponent;
        if (separator.getOrientation() == 0) {
            int n = separator.getHeight() / 2;
            graphics.setColor(Theme.toolSeparatorColor.getColor());
            graphics.drawLine(0, n, separator.getWidth(), n);
        } else {
            int n = separator.getWidth() / 2;
            graphics.setColor(Theme.toolSeparatorColor.getColor());
            graphics.drawLine(n, 0, n, separator.getHeight());
        }
    }
}

