/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class ThemeDescription {
    private URI uri;
    private URL url;
    private File file;
    private boolean fileHasBeenSet = false;
    private String name = null;

    public ThemeDescription(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url may not be null");
        }
        try {
            this.uri = !"file".equals(url.getProtocol()) ? new URI(url.getPath()) : new URI(url.toExternalForm());
            this.url = url;
        }
        catch (URISyntaxException ex) {
            this.uri = null;
        }
    }

    public ThemeDescription(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri may not be null");
        }
        try {
            this.url = uri.toURL();
            this.uri = uri;
        }
        catch (MalformedURLException ex) {
            this.url = null;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof ThemeDescription)) {
            return false;
        }
        ThemeDescription other = (ThemeDescription)o;
        if (this.isValid() != other.isValid()) {
            return false;
        }
        if (this.isValid()) {
            return this.uri.equals(other.uri);
        }
        return true;
    }

    public boolean isValid() {
        return this.uri != null && this.url != null;
    }

    public String getName() {
        if (this.uri == null) {
            return "? URI == null ?";
        }
        if (this.name == null) {
            this.name = ThemeDescription.getName(this.uri.getPath());
        }
        return this.name;
    }

    private static String getName(String path) {
        if (path == null) {
            return "? uri.getPath() == null ?";
        }
        String namePart = path.substring(path.lastIndexOf("/") + 1);
        int index = namePart.indexOf(".");
        if (index == -1) {
            return namePart;
        }
        return namePart.substring(0, index);
    }

    public URL getURL() {
        return this.url;
    }

    public boolean isFile() {
        if (!this.isValid()) {
            return false;
        }
        if (Theme.YQ_URL.equals(this.url)) {
            return false;
        }
        return "file".equals(this.url.getProtocol());
    }

    public File getFile() {
        if (this.fileHasBeenSet) {
            return this.file;
        }
        this.fileHasBeenSet = true;
        if (!this.isFile()) {
            return null;
        }
        try {
            this.file = new File(this.uri);
        }
        catch (IllegalArgumentException ex) {
            System.err.println(this.getClass().getName() + ".getFile() " + ex.toString());
            System.err.println("URI=" + this.uri + "\nURL=" + this.url);
        }
        return this.file;
    }

    public String toString() {
        return this.getName();
    }
}

