/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.MenuItemIconFactory;
import de.muntjak.tinylookandfeel.SpecialUIButton;
import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyMenuUI;
import de.muntjak.tinylookandfeel.TinyWindowButtonUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class TinyInternalFrameTitlePane
extends BasicInternalFrameTitlePane
implements LayoutManager {
    protected boolean isPalette = false;
    private int buttonsWidth;
    static TinyWindowButtonUI iconButtonUI;
    static TinyWindowButtonUI maxButtonUI;
    static TinyWindowButtonUI closeButtonUI;

    protected PropertyChangeListener createPropertyChangeListener() {
        return new TinyPropertyChangeHandler();
    }

    public TinyInternalFrameTitlePane(JInternalFrame frame) {
        super(frame);
    }

    protected JMenu createSystemMenu() {
        JMenu menu = new JMenu("");
        menu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                if (TinyInternalFrameTitlePane.this.frameHasMenuBar()) {
                    TinyMenuUI.systemMenuShowing = true;
                }
            }

            public void menuDeselected(MenuEvent e) {
                TinyMenuUI.systemMenuShowing = false;
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
        menu.putClientProperty("isSystemMenu", Boolean.TRUE);
        return menu;
    }

    private boolean frameHasMenuBar() {
        if (this.frame != null) {
            return this.frame.getJMenuBar() != null;
        }
        return false;
    }

    protected void addSystemMenuItems(JMenu systemMenu) {
        JMenuItem item = systemMenu.add(this.restoreAction);
        item.setIcon(MenuItemIconFactory.getSystemRestoreIcon());
        item.setMnemonic('R');
        item = systemMenu.add(this.iconifyAction);
        item.setIcon(MenuItemIconFactory.getSystemIconifyIcon());
        item.setMnemonic('n');
        item = systemMenu.add(this.maximizeAction);
        item.setIcon(MenuItemIconFactory.getSystemMaximizeIcon());
        item.setMnemonic('x');
        systemMenu.add(new JSeparator());
        item = systemMenu.add(this.closeAction);
        item.setIcon(MenuItemIconFactory.getSystemCloseIcon());
        item.setMnemonic('C');
    }

    protected void paintTitleBackground(Graphics g) {
    }

    public boolean isFrameSelected() {
        return this.frame.isSelected();
    }

    public boolean isFrameMaximized() {
        return this.frame.isMaximum();
    }

    public void paintComponent(Graphics g) {
        this.frame.setOpaque(false);
        boolean leftToRight = this.frame.getComponentOrientation().isLeftToRight();
        boolean isSelected = this.frame.isSelected();
        int width = this.getWidth();
        int height = this.getHeight();
        String frameTitle = this.frame.getTitle();
        if (frameTitle != null) {
            int xOffset = leftToRight ? 24 : width - 4 - 16 - 4;
            Font f = this.getFont();
            g.setFont(f);
            FontMetrics fm = g.getFontMetrics();
            int titleLength = fm.stringWidth(frameTitle);
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent() + 1;
            if (!leftToRight) {
                xOffset -= titleLength;
            }
            if (g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (isSelected) {
                g.setColor(Theme.frameTitleShadowColor.getColor());
                g.drawString(frameTitle, xOffset + 1, yOffset + 1);
                g.setColor(Theme.frameTitleColor.getColor());
                g.drawString(frameTitle, xOffset, yOffset);
            } else {
                g.setColor(Theme.frameTitleDisabledColor.getColor());
                g.drawString(frameTitle, xOffset, yOffset);
            }
        }
    }

    protected LayoutManager createLayout() {
        return this;
    }

    protected void setButtonIcons() {
    }

    protected void createButtons() {
        if (iconButtonUI == null) {
            iconButtonUI = TinyWindowButtonUI.createButtonUIForType(2);
            maxButtonUI = TinyWindowButtonUI.createButtonUIForType(1);
            closeButtonUI = TinyWindowButtonUI.createButtonUIForType(0);
        }
        this.iconButton = new SpecialUIButton(iconButtonUI);
        this.iconButton.addActionListener(this.iconifyAction);
        this.iconButton.setText(null);
        this.iconButton.setRolloverEnabled(true);
        this.iconButton.addMouseListener(new RolloverListener(this.iconButton));
        this.maxButton = new SpecialUIButton(maxButtonUI);
        this.maxButton.addActionListener(this.maximizeAction);
        this.maxButton.setText(null);
        this.maxButton.setRolloverEnabled(true);
        this.maxButton.addMouseListener(new RolloverListener(this.maxButton));
        this.closeButton = new SpecialUIButton(closeButtonUI);
        this.closeButton.addActionListener(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.setRolloverEnabled(true);
        this.closeButton.addMouseListener(new RolloverListener(this.closeButton));
        this.iconButton.putClientProperty("externalFrameButton", Boolean.FALSE);
        this.maxButton.putClientProperty("externalFrameButton", Boolean.FALSE);
        this.closeButton.putClientProperty("externalFrameButton", Boolean.FALSE);
        this.iconButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.iconifyButtonAccessibleName"));
        this.maxButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.maximizeButtonAccessibleName"));
        this.closeButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.closeButtonAccessibleName"));
        if (this.frame.isSelected()) {
            this.activate();
        } else {
            this.deactivate();
        }
    }

    public void paintPalette(Graphics g) {
    }

    public void addLayoutComponent(String name, Component c) {
    }

    public void removeLayoutComponent(Component c) {
    }

    public Dimension preferredLayoutSize(Container c) {
        return this.getPreferredSize(c);
    }

    public Dimension getPreferredSize(Container c) {
        int subtitle_w;
        int title_length;
        this.isPalette = this.frame.getClientProperty("isPalette") == Boolean.TRUE;
        int width = 22;
        if (this.frame.isClosable()) {
            width += 19;
        }
        if (this.frame.isMaximizable()) {
            width += 19;
        }
        if (this.frame.isIconifiable()) {
            width += 19;
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        String frameTitle = this.frame.getTitle();
        int title_w = frameTitle != null ? fm.stringWidth(frameTitle) : 0;
        int n = title_length = frameTitle != null ? frameTitle.length() : 0;
        width = title_length > 3 ? (width += title_w < (subtitle_w = fm.stringWidth(frameTitle.substring(0, 3) + "...")) ? title_w : subtitle_w) : (width += title_w);
        int height = this.isPalette ? 21 : 25;
        Dimension dim = new Dimension(width, height);
        if (this.getBorder() != null) {
            Insets insets = this.getBorder().getBorderInsets(c);
            dim.height += insets.top + insets.bottom;
            dim.width += insets.left + insets.right;
        }
        return dim;
    }

    public Dimension getMinimumSize() {
        this.isPalette = this.frame.getClientProperty("isPalette") == Boolean.TRUE;
        int height = this.isPalette ? 21 : 25;
        return new Dimension(32, height);
    }

    public Dimension minimumLayoutSize(Container c) {
        return this.preferredLayoutSize(c);
    }

    public void setPalette(boolean b) {
        this.isPalette = b;
    }

    public boolean isPalette() {
        return this.isPalette;
    }

    public void layoutContainer(Container c) {
        int spacing;
        this.isPalette = this.frame.getClientProperty("isPalette") == Boolean.TRUE;
        boolean leftToRight = this.frame.getComponentOrientation().isLeftToRight();
        int buttonHeight = this.closeButton.getPreferredSize().height;
        int h = this.getHeight();
        int w = this.getWidth();
        int x = leftToRight ? w : 0;
        int y = (h - buttonHeight) / 2 + 1;
        int buttonWidth = 0;
        buttonWidth = this.isPalette ? TinyWindowButtonUI.framePaletteButtonSize.width : TinyWindowButtonUI.frameInternalButtonSize.width;
        Icon icon = this.frame.getFrameIcon();
        int iconHeight = 0;
        if (icon != null) {
            iconHeight = icon.getIconHeight();
        }
        x = leftToRight ? 4 : w - 16 - 4;
        this.menuBar.setBounds(x, (h - iconHeight) / 2, 16, 16);
        int n = x = leftToRight ? w : 0;
        if (this.frame.isClosable()) {
            spacing = 2;
            this.closeButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
            if (!leftToRight) {
                x += buttonWidth;
            }
        }
        if (this.frame.isMaximizable()) {
            spacing = 2;
            this.maxButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
            if (!leftToRight) {
                x += buttonWidth;
            }
        }
        if (this.frame.isIconifiable()) {
            spacing = 2;
            this.iconButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
            if (!leftToRight) {
                x += buttonWidth;
            }
        }
        this.buttonsWidth = leftToRight ? w - x : x;
    }

    public void activate() {
        this.closeButton.setEnabled(true);
        this.iconButton.setEnabled(true);
        this.maxButton.setEnabled(true);
    }

    public void deactivate() {
        this.closeButton.setEnabled(false);
        this.iconButton.setEnabled(false);
        this.maxButton.setEnabled(false);
    }

    public Font getFont() {
        Font f = null;
        f = this.isPalette ? UIManager.getFont("InternalFrame.paletteTitleFont") : UIManager.getFont("InternalFrame.normalTitleFont");
        return f;
    }

    class TinyPropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        TinyPropertyChangeHandler() {
            super(TinyInternalFrameTitlePane.this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if (prop.equals("selected")) {
                Boolean b = (Boolean)evt.getNewValue();
                TinyInternalFrameTitlePane.this.iconButton.putClientProperty("paintActive", b);
                TinyInternalFrameTitlePane.this.closeButton.putClientProperty("paintActive", b);
                TinyInternalFrameTitlePane.this.maxButton.putClientProperty("paintActive", b);
            }
            super.propertyChange(evt);
        }
    }

    class RolloverListener
    implements MouseListener {
        JButton button;

        public RolloverListener(JButton b) {
            this.button = b;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            this.button.getModel().setRollover(true);
            if (!this.button.isEnabled()) {
                this.button.setEnabled(true);
            }
            this.button.repaint();
        }

        public void mouseExited(MouseEvent e) {
            this.button.getModel().setRollover(false);
            if (!TinyInternalFrameTitlePane.this.frame.isSelected()) {
                this.button.setEnabled(false);
            }
            this.button.repaint();
        }
    }
}

