/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyUtils;
import de.muntjak.tinylookandfeel.borders.TinyPopupMenuBorder;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class TinyMenuItemUI
extends MenuItemUI {
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    private static final int DEFAULT_ICON_GAP = 4;
    private static final int DEFAULT_ACC_GAP = 8;
    private static final int DEFAULT_ARROW_GAP = 12;
    private static final int CHECK_WIDTH = 14;
    private static final int ARROW_WIDTH = 16;
    protected JMenuItem menuItem = null;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    private String acceleratorDelimiter;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    private PropertyChangeListener propertyChangeListener;
    protected Icon arrowIcon = null;
    protected Icon checkIcon = null;
    protected boolean oldBorderPainted;
    InputMap windowInputMap;
    public static final String MAX_TEXT_WIDTH = "TinyMenuItemUI.maxTextWidth";
    public static final String MAX_ICON_WIDTH = "TinyMenuItemUI.maxIconWidth";
    public static final String MAX_LABEL_WIDTH = "TinyMenuItemUI.maxLabelWidth";
    public static final String MAX_ACC_WIDTH = "TinyMenuItemUI.maxAccWidth";
    protected static Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    protected static Rectangle iconRect = new Rectangle();
    protected static Rectangle textRect = new Rectangle();
    protected static Rectangle acceleratorRect = new Rectangle();
    protected static Rectangle checkIconRect = new Rectangle();
    protected static Rectangle arrowIconRect = new Rectangle();
    protected static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    protected static Rectangle rect = new Rectangle();

    public void installUI(JComponent c) {
        this.menuItem = (JMenuItem)c;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installComponents(JMenuItem menuItem) {
        BasicHTML.updateRenderer(menuItem, menuItem.getText());
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        if (this.mouseInputListener != null) {
            this.menuItem.addMouseListener(this.mouseInputListener);
            this.menuItem.addMouseMotionListener(this.mouseInputListener);
        }
        if ((this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem)) != null) {
            this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem)) != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.menuItem, actionMap);
        this.updateAcceleratorBinding();
    }

    public void uninstallUI(JComponent c) {
        this.menuItem = (JMenuItem)c;
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        Container parent = this.menuItem.getParent();
        if (parent != null && parent instanceof JComponent) {
            JComponent p = (JComponent)parent;
            p.putClientProperty(MAX_ACC_WIDTH, null);
            p.putClientProperty(MAX_TEXT_WIDTH, null);
            p.putClientProperty(MAX_ICON_WIDTH, null);
            p.putClientProperty(MAX_LABEL_WIDTH, null);
        }
        this.menuItem = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.menuItem);
        this.menuItem.setBorderPainted(this.oldBorderPainted);
        if (this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(null);
        }
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallComponents(JMenuItem menuItem) {
        BasicHTML.updateRenderer(menuItem, "");
    }

    protected void uninstallListeners() {
        if (this.mouseInputListener != null) {
            this.menuItem.removeMouseListener(this.mouseInputListener);
            this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        }
        if (this.menuDragMouseListener != null) {
            this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
        this.propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.menuItem, null);
        if (this.windowInputMap != null) {
            SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
            this.windowInputMap = null;
        }
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return new MenuDragMouseHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent c) {
        return new PropertyChangeHandler();
    }

    ActionMap getActionMap() {
        String propertyPrefix = this.getPropertyPrefix();
        String uiKey = propertyPrefix + ".actionMap";
        ActionMap am = (ActionMap)UIManager.get(uiKey);
        if (am == null) {
            am = this.createActionMap();
            UIManager.getLookAndFeelDefaults().put(uiKey, am);
        }
        return am;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("doClick", new ClickAction());
        return map;
    }

    InputMap createInputMap(int condition) {
        if (condition == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    void updateAcceleratorBinding() {
        KeyStroke accelerator = this.menuItem.getAccelerator();
        if (this.windowInputMap != null) {
            this.windowInputMap.clear();
        }
        if (accelerator != null) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            this.windowInputMap.put(accelerator, "doClick");
        }
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension d = null;
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d = this.getPreferredSize(c);
            d.width = (int)((float)d.width - (v.getPreferredSpan(0) - v.getMinimumSpan(0)));
        }
        return d;
    }

    public Dimension getPreferredSize(JComponent c) {
        if (Theme.menuAllowTwoIcons.getValue()) {
            return this.getPreferredMenuItemSizeTwoIcons(c, this.checkIcon, this.arrowIcon);
        }
        return this.getPreferredMenuItemSizeOneIcon(c, this.checkIcon, this.arrowIcon);
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        if (!model.isEnabled()) {
            if (this.isTopLevelMenu()) {
                g.setColor(Theme.menuDisabledFgColor.getColor());
            } else {
                g.setColor(Theme.menuItemDisabledFgColor.getColor());
            }
            TinyUtils.drawStringUnderlineCharAt(menuItem, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        } else {
            if (this.isTopLevelMenu()) {
                if (menuItem.getClientProperty("rollover") == Boolean.TRUE && Theme.menuRollover.getValue() && !model.isSelected()) {
                    g.setColor(Theme.menuRolloverFgColor.getColor());
                } else if (!(menuItem.getForeground() instanceof ColorUIResource)) {
                    g.setColor(menuItem.getForeground());
                } else {
                    g.setColor(Theme.menuFontColor.getColor());
                }
            } else if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g.setColor(Theme.menuItemSelectedTextColor.getColor());
            } else {
                g.setColor(menuItem.getForeground());
            }
            TinyUtils.drawStringUnderlineCharAt(menuItem, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension d = null;
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d = this.getPreferredSize(c);
            d.width = (int)((float)d.width + (v.getMaximumSpan(0) - v.getPreferredSpan(0)));
        }
        return d;
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        rect.setBounds(zeroRect);
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    public void paint(Graphics g, JComponent c) {
        if (Theme.menuAllowTwoIcons.getValue()) {
            this.paintMenuItemTwoIcons(g, c, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, 4);
        } else {
            this.paintMenuItemOneIcon(g, c, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, 4);
        }
    }

    private boolean isTopLevelMenu() {
        return this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu();
    }

    private boolean isTopLevelMenu(Component item) {
        return item instanceof JMenu && ((JMenu)item).isTopLevelMenu();
    }

    public MenuElement[] getPath() {
        MenuElement[] newPath;
        MenuSelectionManager m = MenuSelectionManager.defaultManager();
        MenuElement[] oldPath = m.getSelectedPath();
        int i = oldPath.length;
        if (i == 0) {
            return new MenuElement[0];
        }
        Container parent = this.menuItem.getParent();
        if (oldPath[i - 1].getComponent() == parent) {
            newPath = new MenuElement[i + 1];
            System.arraycopy(oldPath, 0, newPath, 0, i);
            newPath[i] = this.menuItem;
        } else {
            int j;
            for (j = oldPath.length - 1; j >= 0 && oldPath[j].getComponent() != parent; --j) {
            }
            newPath = new MenuElement[j + 2];
            System.arraycopy(oldPath, 0, newPath, 0, j + 1);
            newPath[j + 1] = this.menuItem;
        }
        return newPath;
    }

    protected void doClick(MenuSelectionManager msm) {
        if (msm == null) {
            msm = MenuSelectionManager.defaultManager();
        }
        msm.clearSelectedPath();
        this.menuItem.doClick(0);
    }

    private boolean isInternalFrameSystemMenu() {
        String actionCommand = this.menuItem.getActionCommand();
        return actionCommand == "Close" || actionCommand == "Minimize" || actionCommand == "Restore" || actionCommand == "Maximize";
    }

    public static ComponentUI createUI(JComponent c) {
        return new TinyMenuItemUI();
    }

    protected void installDefaults() {
        String prefix = this.getPropertyPrefix();
        this.acceleratorFont = UIManager.getFont(prefix + ".acceleratorFont");
        this.menuItem.setOpaque(true);
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIManager.getInsets(prefix + ".margin"));
        }
        LookAndFeel.installBorder(this.menuItem, prefix + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        this.menuItem.setBorderPainted((Boolean)UIManager.get(prefix + ".borderPainted"));
        LookAndFeel.installColorsAndFont(this.menuItem, prefix + ".background", prefix + ".foreground", prefix + ".font");
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = UIManager.getColor(prefix + ".selectionBackground");
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = UIManager.getColor(prefix + ".selectionForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIManager.getColor(prefix + ".disabledForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIManager.getColor(prefix + ".acceleratorForeground");
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIManager.getColor(prefix + ".acceleratorSelectionForeground");
        }
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "+";
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon(prefix + ".arrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = UIManager.getIcon(prefix + ".checkIcon");
        }
    }

    private String getAcceleratorText(KeyStroke accelerator) {
        int keyCode;
        if (accelerator == null) {
            return "";
        }
        String acceleratorText = "";
        int modifiers = accelerator.getModifiers();
        if (modifiers > 0) {
            acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
            acceleratorText = acceleratorText + this.acceleratorDelimiter;
        }
        acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        return acceleratorText;
    }

    protected Dimension getPreferredMenuItemSizeTwoIcons(JComponent c, Icon checkIcon, Icon arrowIcon) {
        int maxAccWidth;
        JMenuItem b = (JMenuItem)c;
        String text = b.getText();
        String acceleratorText = this.getAcceleratorText(b.getAccelerator());
        boolean isTopLevelMenu = this.isTopLevelMenu(c);
        Icon icon = b.getIcon();
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        FontMetrics fmAccel = b.getFontMetrics(this.acceleratorFont);
        int horizontalAlignment = b.getHorizontalAlignment();
        int horizontalTextPosition = b.getHorizontalTextPosition();
        this.resetRects();
        this.layoutMenuItem(fm, text, fmAccel, acceleratorText, icon, checkIcon, arrowIcon, b.getVerticalAlignment(), horizontalAlignment, b.getVerticalTextPosition(), horizontalTextPosition, viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, text == null ? 0 : 4, true);
        rect.setBounds(textRect);
        rect = SwingUtilities.computeUnion(TinyMenuItemUI.iconRect.x, TinyMenuItemUI.iconRect.y, TinyMenuItemUI.iconRect.width, TinyMenuItemUI.iconRect.height, rect);
        Insets insets = b.getInsets();
        if (isTopLevelMenu) {
            TinyMenuItemUI.rect.width += insets.left + insets.right;
            TinyMenuItemUI.rect.height += insets.top + insets.bottom;
            TinyMenuItemUI.rect.width += 5;
            return rect.getSize();
        }
        JComponent parent = (JComponent)c.getParent();
        Integer val = (Integer)parent.getClientProperty(MAX_TEXT_WIDTH);
        int maxTextWidth = val == null ? 0 : val;
        val = (Integer)parent.getClientProperty(MAX_LABEL_WIDTH);
        int maxLabelWidth = val == null ? 0 : val;
        val = (Integer)parent.getClientProperty(MAX_ICON_WIDTH);
        int maxIconWidth = val == null ? 0 : val;
        val = (Integer)parent.getClientProperty(MAX_ACC_WIDTH);
        int n = maxAccWidth = val == null ? 0 : val;
        if (horizontalTextPosition == 2 || horizontalTextPosition == 10 || horizontalTextPosition == 0) {
            if (TinyMenuItemUI.rect.width > maxTextWidth) {
                maxTextWidth = TinyMenuItemUI.rect.width;
                parent.putClientProperty(MAX_TEXT_WIDTH, new Integer(maxTextWidth));
            } else if (maxTextWidth > 0) {
                TinyMenuItemUI.rect.width = maxTextWidth;
            }
        } else {
            if (TinyMenuItemUI.textRect.width > maxTextWidth) {
                maxTextWidth = TinyMenuItemUI.textRect.width;
                parent.putClientProperty(MAX_TEXT_WIDTH, new Integer(maxTextWidth));
            } else if (maxTextWidth > 0 && TinyMenuItemUI.iconRect.width < maxTextWidth) {
                TinyMenuItemUI.rect.width += maxTextWidth - TinyMenuItemUI.textRect.width;
            }
            if (horizontalAlignment == 2 || horizontalAlignment == 10) {
                if (TinyMenuItemUI.iconRect.width > maxIconWidth) {
                    maxIconWidth = TinyMenuItemUI.iconRect.width;
                    parent.putClientProperty(MAX_ICON_WIDTH, new Integer(maxIconWidth));
                } else if (TinyMenuItemUI.iconRect.width > 0) {
                    TinyMenuItemUI.rect.width += maxIconWidth - TinyMenuItemUI.iconRect.width;
                }
            }
        }
        if (TinyMenuItemUI.rect.width > maxLabelWidth) {
            maxLabelWidth = TinyMenuItemUI.rect.width;
            parent.putClientProperty(MAX_LABEL_WIDTH, new Integer(maxLabelWidth));
        } else if (maxLabelWidth > 0) {
            TinyMenuItemUI.rect.width = maxLabelWidth;
        }
        if (TinyMenuItemUI.acceleratorRect.width > maxAccWidth) {
            maxAccWidth = TinyMenuItemUI.acceleratorRect.width;
            parent.putClientProperty(MAX_ACC_WIDTH, new Integer(maxAccWidth));
        }
        TinyMenuItemUI.rect.width += Math.max(insets.left + insets.right, 11);
        TinyMenuItemUI.rect.height += insets.top + insets.bottom;
        TinyMenuItemUI.rect.width += 30;
        if (maxAccWidth > 0) {
            TinyMenuItemUI.rect.width += maxAccWidth + 8;
        }
        return rect.getSize();
    }

    protected Dimension getPreferredMenuItemSizeOneIcon(JComponent c, Icon checkIcon, Icon arrowIcon) {
        int maxAccWidth;
        JMenuItem b = (JMenuItem)c;
        String text = b.getText();
        String acceleratorText = this.getAcceleratorText(b.getAccelerator());
        boolean isTopLevelMenu = this.isTopLevelMenu(c);
        Icon icon = b.getIcon();
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        FontMetrics fmAccel = b.getFontMetrics(this.acceleratorFont);
        int horizontalAlignment = b.getHorizontalAlignment();
        int horizontalTextPosition = b.getHorizontalTextPosition();
        if (icon == null && checkIcon != null) {
            icon = checkIcon;
            checkIcon = null;
        }
        this.resetRects();
        this.layoutMenuItem(fm, text, fmAccel, acceleratorText, icon, checkIcon, arrowIcon, b.getVerticalAlignment(), horizontalAlignment, b.getVerticalTextPosition(), horizontalTextPosition, viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, text == null ? 0 : 4, true);
        rect.setBounds(textRect);
        rect = SwingUtilities.computeUnion(TinyMenuItemUI.iconRect.x, TinyMenuItemUI.iconRect.y, TinyMenuItemUI.iconRect.width, TinyMenuItemUI.iconRect.height, rect);
        Insets insets = b.getInsets();
        if (isTopLevelMenu) {
            TinyMenuItemUI.rect.width += insets.left + insets.right;
            TinyMenuItemUI.rect.height += insets.top + insets.bottom;
            TinyMenuItemUI.rect.width += 5;
            return rect.getSize();
        }
        JComponent parent = (JComponent)c.getParent();
        Integer val = (Integer)parent.getClientProperty(MAX_TEXT_WIDTH);
        int maxTextWidth = val == null ? 0 : val;
        val = (Integer)parent.getClientProperty(MAX_LABEL_WIDTH);
        int maxLabelWidth = val == null ? 0 : val;
        val = (Integer)parent.getClientProperty(MAX_ICON_WIDTH);
        int maxIconWidth = val == null ? 0 : val;
        val = (Integer)parent.getClientProperty(MAX_ACC_WIDTH);
        int n = maxAccWidth = val == null ? 0 : val;
        if (horizontalTextPosition == 2 || horizontalTextPosition == 10 || horizontalTextPosition == 0) {
            if (TinyMenuItemUI.rect.width > maxTextWidth) {
                maxTextWidth = TinyMenuItemUI.rect.width;
                parent.putClientProperty(MAX_TEXT_WIDTH, new Integer(maxTextWidth));
            } else if (maxTextWidth > 0) {
                TinyMenuItemUI.rect.width = maxTextWidth;
            }
        } else {
            if (TinyMenuItemUI.textRect.width > maxTextWidth) {
                maxTextWidth = TinyMenuItemUI.textRect.width;
                parent.putClientProperty(MAX_TEXT_WIDTH, new Integer(maxTextWidth));
            } else if (maxTextWidth > 0 && TinyMenuItemUI.iconRect.width < maxTextWidth) {
                TinyMenuItemUI.rect.width += maxTextWidth - TinyMenuItemUI.textRect.width;
            }
            if (horizontalAlignment == 2 || horizontalAlignment == 10) {
                if (TinyMenuItemUI.iconRect.width > maxIconWidth) {
                    maxIconWidth = TinyMenuItemUI.iconRect.width;
                    parent.putClientProperty(MAX_ICON_WIDTH, new Integer(maxIconWidth));
                } else if (TinyMenuItemUI.iconRect.width > 0) {
                    TinyMenuItemUI.rect.width += maxIconWidth - TinyMenuItemUI.iconRect.width;
                }
            }
        }
        if (TinyMenuItemUI.rect.width > maxLabelWidth) {
            maxLabelWidth = TinyMenuItemUI.rect.width;
            parent.putClientProperty(MAX_LABEL_WIDTH, new Integer(maxLabelWidth));
        } else if (maxLabelWidth > 0) {
            TinyMenuItemUI.rect.width = maxLabelWidth;
        }
        if (TinyMenuItemUI.acceleratorRect.width > maxAccWidth) {
            maxAccWidth = TinyMenuItemUI.acceleratorRect.width;
            parent.putClientProperty(MAX_ACC_WIDTH, new Integer(maxAccWidth));
        }
        TinyMenuItemUI.rect.width += Math.max(insets.left + insets.right, 11);
        TinyMenuItemUI.rect.height += insets.top + insets.bottom;
        TinyMenuItemUI.rect.width += 16;
        if (maxAccWidth > 0) {
            TinyMenuItemUI.rect.width += maxAccWidth + 8;
        }
        return rect.getSize();
    }

    private String p(Rectangle r) {
        if (r == null) {
            return "null";
        }
        return r.x + ", " + r.y + ", " + r.width + ", " + r.height;
    }

    private String p(Insets i) {
        if (i == null) {
            return "null";
        }
        return i.top + ", " + i.left + ", " + i.bottom + ", " + i.right;
    }

    private String p(Dimension d) {
        if (d == null) {
            return "null";
        }
        return d.width + ", " + d.height;
    }

    private String getSwingConstantsString(int htp) {
        if (htp == 0) {
            return "CENTER";
        }
        if (htp == 10) {
            return "LEADING";
        }
        if (htp == 2) {
            return "LEFT";
        }
        if (htp == 4) {
            return "RIGHT";
        }
        if (htp == 11) {
            return "TRAILING";
        }
        return "???";
    }

    private String getSwingConstantsString(int htp, int ha) {
        return this.getSwingConstantsString(htp) + ", " + this.getSwingConstantsString(ha);
    }

    protected void paintMenuItemTwoIcons(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int iconGap) {
        JMenuItem b = (JMenuItem)c;
        ButtonModel model = b.getModel();
        JComponent parent = (JComponent)b.getParent();
        Integer val = (Integer)parent.getClientProperty(MAX_ACC_WIDTH);
        int maxAccWidth = val == null ? 0 : val;
        val = (Integer)parent.getClientProperty(MAX_ICON_WIDTH);
        int maxIconWidth = val == null ? 0 : val;
        val = (Integer)parent.getClientProperty(MAX_LABEL_WIDTH);
        int maxLabelWidth = val == null ? 0 : val;
        val = (Integer)parent.getClientProperty(MAX_TEXT_WIDTH);
        int maxTextWidth = val == null ? 0 : val;
        int menuWidth = b.getWidth();
        int menuHeight = b.getHeight();
        Insets insets = c.getInsets();
        boolean isTopLevelMenu = this.isTopLevelMenu();
        boolean isLeftToRight = c.getComponentOrientation().isLeftToRight();
        int horizontalAlignment = b.getHorizontalAlignment();
        int horizontalTextPosition = b.getHorizontalTextPosition();
        this.resetRects();
        viewRect.setBounds(0, 0, menuWidth, menuHeight);
        TinyMenuItemUI.viewRect.x += insets.left;
        TinyMenuItemUI.viewRect.y += insets.top;
        TinyMenuItemUI.viewRect.width -= insets.right + insets.left;
        TinyMenuItemUI.viewRect.height -= insets.bottom + insets.top;
        Font holdf = g.getFont();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        FontMetrics fmAccel = g.getFontMetrics(this.acceleratorFont);
        String acceleratorText = this.getAcceleratorText(b.getAccelerator());
        Icon ic = b.getIcon();
        Icon cIcon = null;
        Icon paintIcon = ic;
        if (b instanceof JCheckBoxMenuItem || b instanceof JRadioButtonMenuItem) {
            cIcon = checkIcon;
        }
        String text = this.layoutMenuItem(fm, b.getText(), fmAccel, acceleratorText, ic, cIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, b.getText() == null ? 0 : iconGap, false);
        if (!isTopLevelMenu) {
            if (isLeftToRight) {
                int labelWidth;
                int xd;
                int right;
                TinyMenuItemUI.checkIconRect.x = insets.left;
                TinyMenuItemUI.acceleratorRect.x = insets.left + 14 + maxLabelWidth + 8;
                if (horizontalTextPosition == 4 || horizontalTextPosition == 11) {
                    TinyMenuItemUI.iconRect.x = insets.left + 14;
                    TinyMenuItemUI.textRect.x = TinyMenuItemUI.iconRect.x + maxIconWidth + (maxIconWidth == 0 ? 0 : 4);
                    if (horizontalAlignment == 4 || horizontalAlignment == 11) {
                        right = insets.left + 14 + maxLabelWidth;
                        xd = right - (TinyMenuItemUI.textRect.x + TinyMenuItemUI.textRect.width);
                        TinyMenuItemUI.textRect.x = right - TinyMenuItemUI.textRect.width;
                        TinyMenuItemUI.iconRect.x = TinyMenuItemUI.textRect.x - 4 - TinyMenuItemUI.iconRect.width;
                    } else if (horizontalAlignment == 0) {
                        labelWidth = TinyMenuItemUI.iconRect.width + (TinyMenuItemUI.iconRect.width == 0 ? 0 : 4) + TinyMenuItemUI.textRect.width;
                        TinyMenuItemUI.iconRect.x = insets.left + 14 + (maxLabelWidth - labelWidth) / 2;
                        TinyMenuItemUI.textRect.x = TinyMenuItemUI.iconRect.x + TinyMenuItemUI.iconRect.width + (TinyMenuItemUI.iconRect.width == 0 ? 0 : 4);
                    }
                } else if (horizontalTextPosition == 2 || horizontalTextPosition == 10) {
                    TinyMenuItemUI.textRect.x = insets.left + 14 + maxIconWidth + (maxIconWidth == 0 ? 0 : 4);
                    TinyMenuItemUI.iconRect.x = TinyMenuItemUI.textRect.x + TinyMenuItemUI.textRect.width + 4;
                    if (horizontalAlignment == 4 || horizontalAlignment == 11) {
                        right = insets.left + 14 + maxLabelWidth;
                        xd = right - (TinyMenuItemUI.textRect.x + TinyMenuItemUI.textRect.width);
                        TinyMenuItemUI.iconRect.x = right - TinyMenuItemUI.iconRect.width;
                        TinyMenuItemUI.textRect.x = TinyMenuItemUI.iconRect.x - 4 - TinyMenuItemUI.textRect.width;
                    } else if (horizontalAlignment == 0) {
                        labelWidth = TinyMenuItemUI.iconRect.width + (TinyMenuItemUI.iconRect.width == 0 ? 0 : 4) + TinyMenuItemUI.textRect.width;
                        TinyMenuItemUI.textRect.x = insets.left + 14 + (maxLabelWidth - labelWidth) / 2;
                        TinyMenuItemUI.iconRect.x = TinyMenuItemUI.textRect.x + TinyMenuItemUI.textRect.width + 4;
                    }
                } else if (horizontalTextPosition == 0) {
                    labelWidth = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? TinyMenuItemUI.textRect.width : TinyMenuItemUI.iconRect.width;
                    int labelx = insets.left + 14 + maxIconWidth + (maxIconWidth == 0 ? 0 : 4);
                    int xd2 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? labelx - TinyMenuItemUI.textRect.x : labelx - TinyMenuItemUI.iconRect.x;
                    TinyMenuItemUI.iconRect.x += xd2;
                    TinyMenuItemUI.textRect.x += xd2;
                    if (horizontalAlignment == 4 || horizontalAlignment == 11) {
                        int right2 = insets.left + 14 + maxLabelWidth;
                        labelx = right2 - labelWidth;
                        xd2 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? labelx - TinyMenuItemUI.textRect.x : labelx - TinyMenuItemUI.iconRect.x;
                        TinyMenuItemUI.iconRect.x += xd2;
                        TinyMenuItemUI.textRect.x += xd2;
                    } else if (horizontalAlignment == 0) {
                        labelx = insets.left + 14 + (maxLabelWidth - labelWidth) / 2;
                        xd2 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? labelx - TinyMenuItemUI.textRect.x : labelx - TinyMenuItemUI.iconRect.x;
                        TinyMenuItemUI.iconRect.x += xd2;
                        TinyMenuItemUI.textRect.x += xd2;
                    }
                }
            } else {
                int labelWidth;
                int left;
                TinyMenuItemUI.checkIconRect.x = TinyMenuItemUI.viewRect.x + TinyMenuItemUI.viewRect.width - 14 + 4;
                TinyMenuItemUI.acceleratorRect.x = insets.left + 16 + maxAccWidth - TinyMenuItemUI.acceleratorRect.width;
                if (horizontalTextPosition == 4 || horizontalTextPosition == 11) {
                    TinyMenuItemUI.iconRect.x = TinyMenuItemUI.checkIconRect.x - 4 - TinyMenuItemUI.iconRect.width;
                    TinyMenuItemUI.textRect.x = TinyMenuItemUI.checkIconRect.x - 4 - maxIconWidth - (maxIconWidth == 0 ? 0 : 4) - TinyMenuItemUI.textRect.width;
                    if (horizontalAlignment == 4 || horizontalAlignment == 11) {
                        TinyMenuItemUI.textRect.x = left = insets.left + 16 + maxAccWidth + (maxAccWidth == 0 ? 0 : 8);
                        TinyMenuItemUI.iconRect.x = left + TinyMenuItemUI.textRect.width + 4;
                    } else if (horizontalAlignment == 0) {
                        left = insets.left + 16 + maxAccWidth + (maxAccWidth == 0 ? 0 : 8);
                        labelWidth = TinyMenuItemUI.iconRect.width + (TinyMenuItemUI.iconRect.width == 0 ? 0 : 4) + TinyMenuItemUI.textRect.width;
                        TinyMenuItemUI.textRect.x = left + (maxLabelWidth - labelWidth) / 2;
                        TinyMenuItemUI.iconRect.x = TinyMenuItemUI.textRect.x + TinyMenuItemUI.textRect.width + 4;
                    }
                } else if (horizontalTextPosition == 2 || horizontalTextPosition == 10) {
                    TinyMenuItemUI.textRect.x = TinyMenuItemUI.checkIconRect.x - 4 - TinyMenuItemUI.textRect.width - maxIconWidth - (maxIconWidth == 0 ? 0 : 4);
                    TinyMenuItemUI.iconRect.x = TinyMenuItemUI.textRect.x - 4 - TinyMenuItemUI.iconRect.width;
                    if (horizontalAlignment == 4 || horizontalAlignment == 11) {
                        TinyMenuItemUI.iconRect.x = left = insets.left + 16 + maxAccWidth + (maxAccWidth == 0 ? 0 : 8);
                        TinyMenuItemUI.textRect.x = left + TinyMenuItemUI.iconRect.width + 4;
                    } else if (horizontalAlignment == 0) {
                        left = insets.left + 16 + maxAccWidth + (maxAccWidth == 0 ? 0 : 8);
                        labelWidth = TinyMenuItemUI.iconRect.width + (TinyMenuItemUI.iconRect.width == 0 ? 0 : 4) + TinyMenuItemUI.textRect.width;
                        TinyMenuItemUI.iconRect.x = left + (maxLabelWidth - labelWidth) / 2;
                        TinyMenuItemUI.textRect.x = TinyMenuItemUI.iconRect.x + TinyMenuItemUI.iconRect.width + 4;
                    }
                } else if (horizontalTextPosition == 0) {
                    left = insets.left + 16 + maxAccWidth + (maxAccWidth == 0 ? 0 : 8);
                    labelWidth = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? TinyMenuItemUI.textRect.width : TinyMenuItemUI.iconRect.width;
                    int labelx = left + maxTextWidth - labelWidth;
                    int xd = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? labelx - TinyMenuItemUI.textRect.x : labelx - TinyMenuItemUI.iconRect.x;
                    TinyMenuItemUI.iconRect.x += xd;
                    TinyMenuItemUI.textRect.x += xd;
                    if (horizontalAlignment == 4 || horizontalAlignment == 11) {
                        xd = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? left - TinyMenuItemUI.textRect.x : left - TinyMenuItemUI.iconRect.x;
                        TinyMenuItemUI.iconRect.x += xd;
                        TinyMenuItemUI.textRect.x += xd;
                    } else if (horizontalAlignment == 0) {
                        labelx = left + (maxLabelWidth - labelWidth) / 2;
                        xd = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? labelx - TinyMenuItemUI.textRect.x : labelx - TinyMenuItemUI.iconRect.x;
                        TinyMenuItemUI.iconRect.x += xd;
                        TinyMenuItemUI.textRect.x += xd;
                    }
                }
            }
        }
        this.paintBackground(g, b, background, isLeftToRight);
        Color holdc = g.getColor();
        if (cIcon != null && !isTopLevelMenu) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            } else {
                g.setColor(holdc);
            }
            cIcon.paintIcon(c, g, TinyMenuItemUI.checkIconRect.x, TinyMenuItemUI.checkIconRect.y);
            g.setColor(holdc);
        }
        if (paintIcon != null) {
            Icon icon;
            if (!model.isEnabled()) {
                icon = b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                icon = b.getPressedIcon();
                if (icon == null) {
                    icon = b.getIcon();
                }
            } else if (model.isSelected()) {
                icon = b.getSelectedIcon();
                if (icon == null) {
                    icon = b.getIcon();
                }
            } else {
                icon = model.isArmed() ? b.getIcon() : b.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(c, g, TinyMenuItemUI.iconRect.x, TinyMenuItemUI.iconRect.y);
            }
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            g.setColor(Theme.menuItemFontColor.getColor());
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (!"".equals(acceleratorText)) {
            g.setFont(this.acceleratorFont);
            if (!model.isEnabled()) {
                g.setColor(Theme.menuItemDisabledFgColor.getColor());
                BasicGraphicsUtils.drawString(g, acceleratorText, 0, TinyMenuItemUI.acceleratorRect.x, TinyMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
            } else {
                if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                    g.setColor(Theme.menuItemSelectedTextColor.getColor());
                } else {
                    g.setColor(Theme.menuItemFontColor.getColor());
                }
                BasicGraphicsUtils.drawString(g, acceleratorText, 0, TinyMenuItemUI.acceleratorRect.x, TinyMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
            }
        }
        if (arrowIcon != null) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            }
            if (!isTopLevelMenu) {
                arrowIcon.paintIcon(c, g, TinyMenuItemUI.arrowIconRect.x, TinyMenuItemUI.arrowIconRect.y);
            }
        }
        g.setColor(holdc);
        g.setFont(holdf);
    }

    protected void paintMenuItemOneIcon(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int iconGap) {
        JMenuItem b = (JMenuItem)c;
        ButtonModel model = b.getModel();
        JComponent parent = (JComponent)b.getParent();
        Integer val = (Integer)parent.getClientProperty(MAX_ACC_WIDTH);
        int maxAccWidth = val == null ? 0 : val;
        val = (Integer)parent.getClientProperty(MAX_ICON_WIDTH);
        int maxIconWidth = val == null ? 0 : val;
        val = (Integer)parent.getClientProperty(MAX_LABEL_WIDTH);
        int maxLabelWidth = val == null ? 0 : val;
        val = (Integer)parent.getClientProperty(MAX_TEXT_WIDTH);
        int maxTextWidth = val == null ? 0 : val;
        int menuWidth = b.getWidth();
        int menuHeight = b.getHeight();
        Insets insets = c.getInsets();
        boolean isTopLevelMenu = this.isTopLevelMenu();
        boolean isLeftToRight = c.getComponentOrientation().isLeftToRight();
        int horizontalAlignment = b.getHorizontalAlignment();
        int horizontalTextPosition = b.getHorizontalTextPosition();
        this.resetRects();
        viewRect.setBounds(0, 0, menuWidth, menuHeight);
        TinyMenuItemUI.viewRect.x += insets.left;
        TinyMenuItemUI.viewRect.y += insets.top;
        TinyMenuItemUI.viewRect.width -= insets.right + insets.left;
        TinyMenuItemUI.viewRect.height -= insets.bottom + insets.top;
        Font holdf = g.getFont();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        FontMetrics fmAccel = g.getFontMetrics(this.acceleratorFont);
        String acceleratorText = this.getAcceleratorText(b.getAccelerator());
        Icon ic = b.getIcon();
        Icon cIcon = null;
        Icon paintIcon = ic;
        if ((b instanceof JCheckBoxMenuItem || b instanceof JRadioButtonMenuItem) && ic == null) {
            cIcon = checkIcon;
        }
        String text = this.layoutMenuItem(fm, b.getText(), fmAccel, acceleratorText, ic, cIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, b.getText() == null ? 0 : iconGap, false);
        if (!isTopLevelMenu) {
            if (isLeftToRight) {
                int labelWidth;
                int xd;
                int right;
                TinyMenuItemUI.checkIconRect.x = insets.left;
                TinyMenuItemUI.acceleratorRect.x = insets.left + maxLabelWidth + 8;
                if (horizontalTextPosition == 4 || horizontalTextPosition == 11) {
                    TinyMenuItemUI.iconRect.x = TinyMenuItemUI.checkIconRect.x;
                    TinyMenuItemUI.textRect.x = TinyMenuItemUI.iconRect.x + maxIconWidth + (maxIconWidth == 0 ? 0 : 4);
                    if (horizontalAlignment == 4 || horizontalAlignment == 11) {
                        right = insets.left + maxLabelWidth;
                        xd = right - (TinyMenuItemUI.textRect.x + TinyMenuItemUI.textRect.width);
                        TinyMenuItemUI.textRect.x = right - TinyMenuItemUI.textRect.width;
                        TinyMenuItemUI.iconRect.x = TinyMenuItemUI.textRect.x - 4 - TinyMenuItemUI.iconRect.width;
                    } else if (horizontalAlignment == 0) {
                        labelWidth = TinyMenuItemUI.iconRect.width + (TinyMenuItemUI.iconRect.width == 0 ? 0 : 4) + TinyMenuItemUI.textRect.width;
                        TinyMenuItemUI.iconRect.x = insets.left + (maxLabelWidth - labelWidth) / 2;
                        TinyMenuItemUI.textRect.x = TinyMenuItemUI.iconRect.x + TinyMenuItemUI.iconRect.width + (TinyMenuItemUI.iconRect.width == 0 ? 0 : 4);
                    }
                } else if (horizontalTextPosition == 2 || horizontalTextPosition == 10) {
                    TinyMenuItemUI.textRect.x = insets.left + maxIconWidth + (maxIconWidth == 0 ? 0 : 4);
                    TinyMenuItemUI.iconRect.x = TinyMenuItemUI.textRect.x + TinyMenuItemUI.textRect.width + 4;
                    if (horizontalAlignment == 4 || horizontalAlignment == 11) {
                        right = insets.left + maxLabelWidth;
                        xd = right - (TinyMenuItemUI.textRect.x + TinyMenuItemUI.textRect.width);
                        TinyMenuItemUI.iconRect.x = right - TinyMenuItemUI.iconRect.width;
                        TinyMenuItemUI.textRect.x = TinyMenuItemUI.iconRect.x - 4 - TinyMenuItemUI.textRect.width;
                    } else if (horizontalAlignment == 0) {
                        labelWidth = TinyMenuItemUI.iconRect.width + (TinyMenuItemUI.iconRect.width == 0 ? 0 : 4) + TinyMenuItemUI.textRect.width;
                        TinyMenuItemUI.textRect.x = insets.left + (maxLabelWidth - labelWidth) / 2;
                        TinyMenuItemUI.iconRect.x = TinyMenuItemUI.textRect.x + TinyMenuItemUI.textRect.width + 4;
                    }
                } else if (horizontalTextPosition == 0) {
                    labelWidth = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? TinyMenuItemUI.textRect.width : TinyMenuItemUI.iconRect.width;
                    int labelx = insets.left + maxIconWidth + (maxIconWidth == 0 ? 0 : 4);
                    int xd2 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? labelx - TinyMenuItemUI.textRect.x : labelx - TinyMenuItemUI.iconRect.x;
                    TinyMenuItemUI.iconRect.x += xd2;
                    TinyMenuItemUI.textRect.x += xd2;
                    if (horizontalAlignment == 4 || horizontalAlignment == 11) {
                        int right2 = insets.left + maxLabelWidth;
                        labelx = right2 - labelWidth;
                        xd2 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? labelx - TinyMenuItemUI.textRect.x : labelx - TinyMenuItemUI.iconRect.x;
                        TinyMenuItemUI.iconRect.x += xd2;
                        TinyMenuItemUI.textRect.x += xd2;
                    } else if (horizontalAlignment == 0) {
                        labelx = insets.left + (maxLabelWidth - labelWidth) / 2;
                        xd2 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? labelx - TinyMenuItemUI.textRect.x : labelx - TinyMenuItemUI.iconRect.x;
                        TinyMenuItemUI.iconRect.x += xd2;
                        TinyMenuItemUI.textRect.x += xd2;
                    }
                }
            } else {
                int labelWidth;
                int left;
                TinyMenuItemUI.checkIconRect.x = TinyMenuItemUI.viewRect.x + TinyMenuItemUI.viewRect.width - 14 + 4;
                TinyMenuItemUI.acceleratorRect.x = insets.left + 16 + maxAccWidth - TinyMenuItemUI.acceleratorRect.width;
                if (horizontalTextPosition == 4 || horizontalTextPosition == 11) {
                    TinyMenuItemUI.iconRect.x = TinyMenuItemUI.viewRect.x + TinyMenuItemUI.viewRect.width - TinyMenuItemUI.iconRect.width;
                    TinyMenuItemUI.textRect.x = TinyMenuItemUI.checkIconRect.x - 4 - maxIconWidth - (maxIconWidth == 0 ? 0 : 4) - TinyMenuItemUI.textRect.width;
                    if (horizontalAlignment == 4 || horizontalAlignment == 11) {
                        TinyMenuItemUI.textRect.x = left = insets.left + 16 + maxAccWidth + (maxAccWidth == 0 ? 0 : 8);
                        TinyMenuItemUI.iconRect.x = left + TinyMenuItemUI.textRect.width + 4;
                    } else if (horizontalAlignment == 0) {
                        left = insets.left + 16 + maxAccWidth + (maxAccWidth == 0 ? 0 : 8);
                        labelWidth = TinyMenuItemUI.iconRect.width + (TinyMenuItemUI.iconRect.width == 0 ? 0 : 4) + TinyMenuItemUI.textRect.width;
                        TinyMenuItemUI.textRect.x = left + (maxLabelWidth - labelWidth) / 2;
                        TinyMenuItemUI.iconRect.x = TinyMenuItemUI.textRect.x + TinyMenuItemUI.textRect.width + 4;
                    }
                } else if (horizontalTextPosition == 2 || horizontalTextPosition == 10) {
                    TinyMenuItemUI.textRect.x = TinyMenuItemUI.checkIconRect.x - 4 - TinyMenuItemUI.textRect.width - maxIconWidth - (maxIconWidth == 0 ? 0 : 4);
                    TinyMenuItemUI.iconRect.x = TinyMenuItemUI.textRect.x - 4 - TinyMenuItemUI.iconRect.width;
                    if (horizontalAlignment == 4 || horizontalAlignment == 11) {
                        TinyMenuItemUI.iconRect.x = left = insets.left + 16 + maxAccWidth + (maxAccWidth == 0 ? 0 : 8);
                        TinyMenuItemUI.textRect.x = left + TinyMenuItemUI.iconRect.width + 4;
                    } else if (horizontalAlignment == 0) {
                        left = insets.left + 16 + maxAccWidth + (maxAccWidth == 0 ? 0 : 8);
                        labelWidth = TinyMenuItemUI.iconRect.width + (TinyMenuItemUI.iconRect.width == 0 ? 0 : 4) + TinyMenuItemUI.textRect.width;
                        TinyMenuItemUI.iconRect.x = left + (maxLabelWidth - labelWidth) / 2;
                        TinyMenuItemUI.textRect.x = TinyMenuItemUI.iconRect.x + TinyMenuItemUI.iconRect.width + 4;
                    }
                } else if (horizontalTextPosition == 0) {
                    left = insets.left + 16 + maxAccWidth + (maxAccWidth == 0 ? 0 : 8);
                    labelWidth = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? TinyMenuItemUI.textRect.width : TinyMenuItemUI.iconRect.width;
                    int labelx = left + maxTextWidth - labelWidth;
                    int xd = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? labelx - TinyMenuItemUI.textRect.x : labelx - TinyMenuItemUI.iconRect.x;
                    TinyMenuItemUI.iconRect.x += xd;
                    TinyMenuItemUI.textRect.x += xd;
                    if (horizontalAlignment == 4 || horizontalAlignment == 11) {
                        xd = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? left - TinyMenuItemUI.textRect.x : left - TinyMenuItemUI.iconRect.x;
                        TinyMenuItemUI.iconRect.x += xd;
                        TinyMenuItemUI.textRect.x += xd;
                    } else if (horizontalAlignment == 0) {
                        labelx = left + (maxLabelWidth - labelWidth) / 2;
                        xd = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? labelx - TinyMenuItemUI.textRect.x : labelx - TinyMenuItemUI.iconRect.x;
                        TinyMenuItemUI.iconRect.x += xd;
                        TinyMenuItemUI.textRect.x += xd;
                    }
                }
            }
        }
        this.paintBackground(g, b, background, isLeftToRight);
        Color holdc = g.getColor();
        if (cIcon != null && !isTopLevelMenu) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            } else {
                g.setColor(holdc);
            }
            cIcon.paintIcon(c, g, TinyMenuItemUI.checkIconRect.x, TinyMenuItemUI.checkIconRect.y);
            g.setColor(holdc);
        }
        if (paintIcon != null) {
            Icon icon = paintIcon;
            Icon selectedIcon = null;
            Icon tmpIcon = null;
            if (model.isSelected() && (selectedIcon = b.getSelectedIcon()) != null) {
                icon = selectedIcon;
            }
            if (!model.isEnabled()) {
                if (model.isSelected() && (tmpIcon = b.getDisabledSelectedIcon()) == null) {
                    tmpIcon = selectedIcon;
                }
                if (tmpIcon == null) {
                    tmpIcon = b.getDisabledIcon();
                }
            } else if (model.isPressed() && model.isArmed()) {
                tmpIcon = b.getPressedIcon();
            } else if (model.isArmed()) {
                if (model.isSelected() && (tmpIcon = b.getRolloverSelectedIcon()) == null) {
                    tmpIcon = selectedIcon;
                }
                if (tmpIcon == null) {
                    tmpIcon = b.getRolloverIcon();
                }
            }
            if (tmpIcon != null) {
                icon = tmpIcon;
            }
            if (icon != null) {
                icon.paintIcon(c, g, TinyMenuItemUI.iconRect.x, TinyMenuItemUI.iconRect.y);
                if ((b instanceof JCheckBoxMenuItem || b instanceof JRadioButtonMenuItem) && b.getSelectedIcon() == null && model.isSelected()) {
                    this.paintSelected(g, b);
                }
            }
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            g.setColor(Theme.menuItemFontColor.getColor());
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (!"".equals(acceleratorText)) {
            g.setFont(this.acceleratorFont);
            if (!model.isEnabled()) {
                g.setColor(Theme.menuItemDisabledFgColor.getColor());
                BasicGraphicsUtils.drawString(g, acceleratorText, 0, TinyMenuItemUI.acceleratorRect.x, TinyMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
            } else {
                if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                    g.setColor(Theme.menuItemSelectedTextColor.getColor());
                } else {
                    g.setColor(Theme.menuItemFontColor.getColor());
                }
                BasicGraphicsUtils.drawString(g, acceleratorText, 0, TinyMenuItemUI.acceleratorRect.x, TinyMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
            }
        }
        if (arrowIcon != null) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            }
            if (!isTopLevelMenu) {
                arrowIcon.paintIcon(c, g, TinyMenuItemUI.arrowIconRect.x, TinyMenuItemUI.arrowIconRect.y);
            }
        }
        g.setColor(holdc);
        g.setFont(holdf);
    }

    private void paintSelected(Graphics g, JMenuItem b) {
        ColorUIResource bgColor;
        ColorUIResource iconColor;
        if (!b.isEnabled()) {
            iconColor = Theme.menuIconDisabledColor.getColor();
            bgColor = Theme.menuPopupColor.getColor();
        } else if (b.isArmed()) {
            iconColor = Theme.menuIconRolloverColor.getColor();
            bgColor = Theme.menuItemRolloverColor.getColor();
        } else {
            iconColor = Theme.menuIconColor.getColor();
            bgColor = Theme.menuPopupColor.getColor();
        }
        int x1 = TinyMenuItemUI.iconRect.x - 3;
        int y1 = TinyMenuItemUI.iconRect.y - 1;
        if (b.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
            x1 = TinyMenuItemUI.iconRect.x + TinyMenuItemUI.iconRect.width - 4;
        }
        g.translate(x1, y1);
        g.setColor(iconColor);
        if (b instanceof JCheckBoxMenuItem) {
            g.drawLine(0, 2, 0, 4);
            g.drawLine(1, 3, 1, 5);
            g.drawLine(2, 4, 2, 6);
            g.drawLine(3, 3, 3, 5);
            g.drawLine(4, 2, 4, 4);
            g.drawLine(5, 1, 5, 3);
            g.drawLine(6, 0, 6, 2);
            g.setColor(bgColor);
            g.drawLine(3, 1, 4, 1);
            g.drawLine(3, 2, 3, 2);
            g.setColor(ColorRoutines.getAlphaColor(bgColor, 128));
            g.drawLine(3, 6, 3, 6);
            g.drawLine(4, 5, 4, 5);
            g.drawLine(5, 4, 5, 4);
            g.drawLine(6, 3, 6, 3);
        } else {
            g.setColor(ColorRoutines.getAlphaColor(iconColor, 96));
            g.drawLine(1, 0, 1, 0);
            g.drawLine(5, 0, 5, 0);
            g.drawLine(0, 1, 0, 1);
            g.drawLine(6, 1, 6, 1);
            g.drawLine(0, 5, 0, 5);
            g.drawLine(6, 5, 6, 5);
            g.drawLine(1, 6, 1, 6);
            g.drawLine(5, 6, 5, 6);
            g.setColor(ColorRoutines.getAlphaColor(iconColor, 184));
            g.drawLine(2, 0, 2, 0);
            g.drawLine(4, 0, 4, 0);
            g.drawLine(0, 2, 0, 2);
            g.drawLine(6, 2, 6, 2);
            g.drawLine(0, 4, 0, 4);
            g.drawLine(6, 4, 6, 4);
            g.drawLine(2, 6, 2, 6);
            g.drawLine(4, 6, 4, 6);
            g.setColor(ColorRoutines.getAlphaColor(iconColor, 245));
            g.drawLine(3, 0, 3, 0);
            g.drawLine(3, 6, 3, 6);
            g.drawLine(0, 3, 0, 3);
            g.drawLine(6, 3, 6, 3);
            g.setColor(ColorRoutines.getAlphaColor(iconColor, 159));
            g.drawLine(1, 1, 1, 1);
            g.drawLine(5, 1, 5, 1);
            g.drawLine(1, 5, 1, 5);
            g.drawLine(5, 5, 5, 5);
            g.setColor(ColorRoutines.getAlphaColor(iconColor, 71));
            g.drawLine(2, 1, 2, 1);
            g.drawLine(4, 1, 4, 1);
            g.drawLine(1, 2, 1, 2);
            g.drawLine(5, 2, 5, 2);
            g.drawLine(1, 4, 1, 4);
            g.drawLine(5, 4, 5, 4);
            g.drawLine(2, 5, 2, 5);
            g.drawLine(4, 5, 4, 5);
            g.setColor(ColorRoutines.getAlphaColor(iconColor, 112));
            g.drawLine(2, 2, 2, 2);
            g.drawLine(4, 2, 4, 2);
            g.drawLine(2, 4, 2, 4);
            g.drawLine(4, 4, 4, 4);
            g.setColor(ColorRoutines.getAlphaColor(iconColor, 224));
            g.drawLine(3, 2, 3, 2);
            g.drawLine(3, 4, 3, 4);
            g.drawLine(2, 3, 2, 3);
            g.drawLine(4, 3, 4, 3);
            g.setColor(iconColor);
            g.drawLine(3, 3, 3, 3);
            g.setColor(ColorRoutines.getAlphaColor(bgColor, 128));
            g.drawLine(3, 1, 3, 1);
            g.drawLine(5, 3, 5, 3);
            g.drawLine(3, 5, 3, 5);
        }
        g.translate(-x1, -y1);
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor, boolean isLeftToRight) {
        boolean armed;
        if (!menuItem.isOpaque()) {
            return;
        }
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        boolean bl = armed = model.isArmed() || menuItem instanceof JMenu && model.isSelected();
        if (this.isTopLevelMenu(menuItem)) {
            Color parentBg = menuItem.getParent().getBackground();
            if (parentBg instanceof ColorUIResource) {
                parentBg = Theme.menuBarColor.getColor();
            }
            if (model.isSelected()) {
                g.setColor(parentBg);
                g.fillRect(0, 0, menuWidth, menuHeight);
                this.paintXpTopMenuBorder(g, 0, 0, menuWidth, menuHeight, true, isLeftToRight, parentBg);
            } else if (menuItem.getClientProperty("rollover") == Boolean.TRUE && Theme.menuRollover.getValue()) {
                g.setColor(Theme.menuRolloverBgColor.getColor());
                if (isLeftToRight) {
                    g.fillRect(0, 0, menuWidth - 5, menuHeight);
                    g.setColor(parentBg);
                    g.fillRect(menuWidth - 5, 0, 5, menuHeight);
                } else {
                    g.fillRect(5, 0, menuWidth, menuHeight);
                    g.setColor(parentBg);
                    g.fillRect(0, 0, 5, menuHeight);
                }
                this.paintXpTopMenuBorder(g, 0, 0, menuWidth, menuHeight, false, isLeftToRight, parentBg);
            } else {
                if (menuItem.getBackground() instanceof ColorUIResource) {
                    g.setColor(parentBg);
                } else {
                    g.setColor(menuItem.getBackground());
                }
                g.fillRect(0, 0, menuWidth, menuHeight);
            }
        } else if (armed) {
            g.setColor(Theme.menuItemRolloverColor.getColor());
            g.fillRect(0, 0, menuWidth, menuHeight);
        } else {
            if (menuItem.getBackground() instanceof ColorUIResource) {
                g.setColor(Theme.menuPopupColor.getColor());
            } else {
                g.setColor(menuItem.getBackground());
            }
            g.fillRect(0, 0, menuWidth, menuHeight);
        }
        g.setColor(oldColor);
    }

    private void paintXpTopMenuBorder(Graphics g, int x, int y, int w, int h, boolean selected, boolean isLeftToRight, Color bg) {
        g.setColor(Theme.menuBorderColor.getColor());
        if (selected) {
            if (isLeftToRight) {
                g.drawLine(x, y, x + w - 5 - 1, y);
                g.drawLine(x, y, x, y + h - 1);
                g.drawLine(x + w - 5 - 1, y, x + w - 5 - 1, y + h - 1);
                this.paintTopMenuShadow(g, x + w - 5, y + 1, 5, h - 1, isLeftToRight);
            } else {
                g.drawLine(x + 5, y, x + w - 1, y);
                g.drawLine(x + 5, y, x + 5, y + h - 1);
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
                this.paintTopMenuShadow(g, x, y + 1, 5, h - 1, isLeftToRight);
            }
        } else if (isLeftToRight) {
            g.drawRect(x, y, w - 5 - 1, h - 1);
        } else {
            g.drawRect(x + 5, y, w - 5 - 1, h - 1);
        }
    }

    private void paintTopMenuShadow(Graphics g, int x, int y, int w, int h, boolean isLeftToRight) {
        if (isLeftToRight) {
            Image img = TinyPopupMenuBorder.LEFT_TO_RIGHT_SHADOW_MASK;
            g.drawImage(img, x, y, x + 5, y + 4, 6, 0, 11, 4, null);
            g.drawImage(img, x, y + 4, x + 5, y + h, 6, 4, 11, 5, null);
        } else {
            Image img = TinyPopupMenuBorder.RIGHT_TO_LEFT_SHADOW_MASK;
            g.drawImage(img, x, y, x + 5, y + 4, 0, 0, 5, 4, null);
            g.drawImage(img, x, y + 4, x + 5, y + h, 0, 4, 5, 5, null);
        }
    }

    private String layoutMenuItem(FontMetrics fm, String text, FontMetrics fmAccel, String acceleratorText, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int iconGap, boolean calcPreferredSize) {
        boolean isTopLevelMenu = this.isTopLevelMenu();
        boolean hasIcon = icon != null && icon.getIconWidth() > 0;
        boolean isLeftToRight = this.menuItem.getComponentOrientation().isLeftToRight();
        SwingUtilities.layoutCompoundLabel(this.menuItem, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewRect, iconRect, textRect, hasIcon ? iconGap : 0);
        if (!isTopLevelMenu) {
            if (isLeftToRight) {
                iconRect.x += 14;
                textRect.x += 14;
            } else {
                iconRect.x -= 14;
                textRect.x -= 14;
            }
        }
        if (acceleratorText == null || acceleratorText.equals("")) {
            acceleratorRect.height = 0;
            acceleratorRect.width = 0;
            acceleratorText = "";
        } else {
            acceleratorRect.width = SwingUtilities.computeStringWidth(fmAccel, acceleratorText);
            acceleratorRect.height = fmAccel.getHeight();
        }
        if (!isTopLevelMenu) {
            if (checkIcon != null) {
                checkIconRect.height = checkIcon.getIconHeight();
                checkIconRect.width = checkIcon.getIconWidth();
            } else {
                checkIconRect.height = 0;
                checkIconRect.width = 0;
            }
            if (arrowIcon != null) {
                arrowIconRect.width = arrowIcon.getIconWidth();
                arrowIconRect.height = arrowIcon.getIconHeight();
            } else {
                arrowIconRect.height = 0;
                arrowIconRect.width = 0;
            }
        } else {
            checkIconRect.height = 0;
            checkIconRect.width = 0;
            arrowIconRect.height = 0;
            arrowIconRect.width = 0;
        }
        Rectangle labelRect = iconRect.union(textRect);
        acceleratorRect.y = labelRect.y + labelRect.height / 2 - acceleratorRect.height / 2;
        if (!isTopLevelMenu) {
            arrowIconRect.y = labelRect.y + labelRect.height / 2 - arrowIconRect.height / 2;
            checkIconRect.y = labelRect.y + labelRect.height / 2 - checkIconRect.height / 2;
            arrowIconRect.x = isLeftToRight ? viewRect.x + viewRect.width - arrowIconRect.width : viewRect.x;
        }
        return text;
    }

    private static class ClickAction
    extends AbstractAction {
        private ClickAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            mi.doClick();
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("labelFor") || name.equals("displayedMnemonic") || name.equals("accelerator")) {
                TinyMenuItemUI.this.updateAcceleratorBinding();
            } else if (name.equals("text") || "font".equals(name) || "foreground".equals(name)) {
                JMenuItem lbl = (JMenuItem)e.getSource();
                String text = lbl.getText();
                BasicHTML.updateRenderer(lbl, text);
            }
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent e) {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            manager.setSelectedPath(path);
        }

        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < TinyMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < TinyMenuItemUI.this.menuItem.getHeight()) {
                TinyMenuItemUI.this.doClick(manager);
            } else {
                manager.clearSelectedPath();
            }
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < TinyMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < TinyMenuItemUI.this.menuItem.getHeight()) {
                TinyMenuItemUI.this.doClick(manager);
            } else {
                manager.processMouseEvent(e);
            }
        }

        public void mouseEntered(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                manager.setSelectedPath(TinyMenuItemUI.this.getPath());
            }
        }

        public void mouseExited(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                MenuElement[] path = manager.getSelectedPath();
                if (path.length > 1) {
                    MenuElement[] newPath = new MenuElement[path.length - 1];
                    int c = path.length - 1;
                    for (int i = 0; i < c; ++i) {
                        newPath[i] = path[i];
                    }
                    manager.setSelectedPath(newPath);
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

