/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;

public class TinyUtils {
    private static final String OS_NAME = TinyUtils.getSystemPropertyPrivileged("os.name");
    private static final RenderingHints SAVED_HINTS = new RenderingHints(null);
    private static Map osSettings;
    private static boolean is1dot4;
    private static boolean is1dot5;
    private static boolean is1dot6;
    private static String javaVersion;
    public static final Object AA_TEXT_PROPERTY_KEY;

    public static String getSystemPropertyPrivileged(final String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException ex) {
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(key);
                }
            });
        }
    }

    public static boolean isOSLinux() {
        return OS_NAME.toLowerCase().startsWith("linux");
    }

    public static boolean isOSMac() {
        return OS_NAME.toLowerCase().startsWith("mac");
    }

    public static boolean is1dot4() {
        return is1dot4;
    }

    public static boolean is1dot5() {
        return is1dot5;
    }

    public static boolean is1dot6() {
        return is1dot6;
    }

    public static String getJavaVersion() {
        return javaVersion;
    }

    public static void drawStringUnderlineCharAt(JComponent client, Graphics g, String text, int underlinedIndex, int x, int y) {
        if (text == null || text.length() <= 0) {
            return;
        }
        if (g instanceof Graphics2D) {
            TinyUtils.drawString(client, (Graphics2D)g, text, x, y);
        } else {
            g.drawString(text, x, y);
        }
        if (underlinedIndex >= 0 && underlinedIndex < text.length()) {
            FontMetrics fm = g.getFontMetrics();
            int underlineRectX = x + fm.stringWidth(text.substring(0, underlinedIndex));
            int underlineRectY = y;
            int underlineRectWidth = fm.charWidth(text.charAt(underlinedIndex));
            int underlineRectHeight = 1;
            g.fillRect(underlineRectX, underlineRectY + fm.getDescent() - 1, underlineRectWidth, underlineRectHeight);
        }
    }

    private static void drawString(JComponent client, Graphics2D g2d, String text, int x, int y) {
        if (client != null && Boolean.TRUE.equals(client.getClientProperty(AA_TEXT_PROPERTY_KEY))) {
            Object oldTA = g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.drawString(text, x, y);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldTA);
            return;
        }
        if (osSettings != null) {
            RenderingHints oldHints = TinyUtils.getRenderingHints(g2d, osSettings, SAVED_HINTS);
            g2d.addRenderingHints(osSettings);
            g2d.drawString(text, x, y);
            g2d.addRenderingHints(oldHints);
            return;
        }
        if (TinyUtils.is1dot5() && "true".equals(System.getProperty("swing.aatext"))) {
            Object oldTA = g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.drawString(text, x, y);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldTA);
            return;
        }
        g2d.drawString(text, x, y);
    }

    private static RenderingHints getRenderingHints(Graphics2D g2d, Map hintsToSave, RenderingHints savedHints) {
        if (savedHints == null) {
            savedHints = new RenderingHints(null);
        } else {
            savedHints.clear();
        }
        if (hintsToSave == null || hintsToSave.size() == 0) {
            return savedHints;
        }
        Iterator ii = hintsToSave.keySet().iterator();
        while (ii.hasNext()) {
            RenderingHints.Key key = (RenderingHints.Key)ii.next();
            Object value = g2d.getRenderingHint(key);
            savedHints.put(key, value);
        }
        return savedHints;
    }

    public static String getSystemProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException ex) {
            System.out.println("Exception while trying to get " + key + " system property. " + ex);
            return null;
        }
    }

    static {
        is1dot4 = false;
        is1dot5 = false;
        is1dot6 = false;
        AA_TEXT_PROPERTY_KEY = new StringBuffer("TinyAATextPropertyKey");
        javaVersion = TinyUtils.getSystemPropertyPrivileged("java.version");
        if (javaVersion != null) {
            is1dot4 = javaVersion.startsWith("1.0") || javaVersion.startsWith("1.1") || javaVersion.startsWith("1.2") || javaVersion.startsWith("1.3") || javaVersion.startsWith("1.4");
            is1dot5 = javaVersion.startsWith("1.5");
            is1dot6 = javaVersion.startsWith("1.6");
        }
        osSettings = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        Toolkit.getDefaultToolkit().addPropertyChangeListener("awt.font.desktophints", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                osSettings = (Map)evt.getNewValue();
            }
        });
    }
}

