/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.borders;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.util.DrawRoutines;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class TinyProgressBarBorder
extends AbstractBorder
implements UIResource {
    protected static final Insets INSETS_YQ = new Insets(3, 3, 3, 3);

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        this.drawXpBorder(c, g, x, y, w, h);
    }

    private void drawXpBorder(Component c, Graphics g, int x, int y, int w, int h) {
        DrawRoutines.drawProgressBarBorder(g, Theme.progressBorderColor.getColor(), x, y, w, h);
        DrawRoutines.drawProgressBarBorder(g, Theme.progressDarkColor.getColor(), x + 1, y + 1, w - 2, h - 2);
        g.setColor(Theme.progressLightColor.getColor());
        g.drawLine((x += 2) + 1, y += 2, x + (w -= 4) - 2, y);
        g.drawLine(x, y + 1, x, y + (h -= 4) - 2);
        g.setColor(Theme.progressTrackColor.getColor());
        g.drawLine(x + 1, y + h - 1, x + w - 2, y + h - 1);
        g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 2);
    }

    public Insets getBorderInsets(Component c) {
        return INSETS_YQ;
    }
}

