/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.borders;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.util.DrawRoutines;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class TinyToolButtonBorder
extends AbstractBorder {
    protected static final Insets insets = new Insets(1, 1, 1, 1);

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        this.drawXpBorder(c, g, x, y, w, h);
    }

    private void drawXpBorder(Component c, Graphics g, int x, int y, int w, int h) {
        boolean isRollover;
        AbstractButton b = (AbstractButton)c;
        ColorUIResource col = null;
        boolean isFileChooserButton = Boolean.TRUE.equals(b.getClientProperty("isFileChooserButton"));
        boolean bl = isRollover = b.getModel().isRollover() || b.getModel().isArmed();
        if (b.getModel().isPressed()) {
            if (isRollover) {
                col = Theme.toolBorderPressedColor.getColor();
            } else if (b.isSelected()) {
                col = Theme.toolBorderSelectedColor.getColor();
            } else {
                if (isFileChooserButton) {
                    return;
                }
                col = Theme.toolBorderColor.getColor();
            }
        } else if (isRollover) {
            col = b.isSelected() ? Theme.toolBorderSelectedColor.getColor() : Theme.toolBorderRolloverColor.getColor();
        } else if (b.isSelected()) {
            col = Theme.toolBorderSelectedColor.getColor();
        } else {
            if (isFileChooserButton) {
                return;
            }
            col = Theme.toolBorderColor.getColor();
        }
        DrawRoutines.drawRoundedBorder(g, col, x, y, w, h);
    }

    public Insets getBorderInsets(Component c) {
        if (!(c instanceof AbstractButton)) {
            return insets;
        }
        AbstractButton b = (AbstractButton)c;
        if (b.getMargin() == null || b.getMargin() instanceof UIResource) {
            return Theme.toolMargin;
        }
        Insets margin = b.getMargin();
        return new Insets(margin.top + 1, margin.left + 1, margin.bottom + 1, margin.right + 1);
    }
}

