/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.ControlPanel;
import de.muntjak.tinylookandfeel.util.DrawRoutines;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class HSBChooser
extends JDialog {
    private static HSBChooser myInstance;
    private static int hue;
    private static int sat;
    private static int bri;
    private ImageIcon icon;
    private ImageIcon colorizedIcon;
    private boolean result = false;
    private ControlPanel.HSBControl hsbControl;
    private IconPanel iconPanel;
    private JSlider hueSlider;
    private JSlider satSlider;
    private JSlider briSlider;
    private JTextField hueField;
    private JTextField satField;
    private JTextField briField;
    private JCheckBox preserveGrey;
    private boolean keyInput = false;
    private boolean valueIsAdjusting = false;

    private HSBChooser(Frame frame) {
        super(frame, "Hue/Saturation/Brightness", true);
        this.setDefaultCloseOperation(1);
        this.getContentPane().setLayout(new BorderLayout(16, 4));
        this.setupUI(frame);
    }

    private void setupUI(Frame frame) {
        SliderAction sliderAction = new SliderAction();
        JPanel p1 = new JPanel(new BorderLayout(12, 0));
        p1.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        JPanel p2 = new JPanel(new GridLayout(3, 1, 0, 4));
        JPanel p3 = new JPanel(new FlowLayout(0, 2, 4));
        JPanel p4 = new JPanel(new BorderLayout(4, 0));
        p4.add((Component)new JLabel("Hue"), "North");
        this.hueSlider = new JSlider(0, 360, hue);
        this.hueSlider.addChangeListener(sliderAction);
        this.hueSlider.setMajorTickSpacing(180);
        this.hueSlider.setPaintTicks(true);
        p4.add((Component)this.hueSlider, "Center");
        JPanel p5 = new JPanel(new FlowLayout(0, 0, 0));
        this.hueField = new JTextField("" + this.hueSlider.getValue(), 4);
        this.hueField.getDocument().addDocumentListener(new HueInputListener());
        this.hueField.addKeyListener(new ArrowKeyAction(this.hueField, 0, 360));
        this.hueField.setHorizontalAlignment(0);
        p5.add(this.hueField);
        p4.add((Component)p5, "East");
        p2.add(p4);
        p5 = new JPanel(new FlowLayout(0, 0, 0));
        p4 = new JPanel(new BorderLayout(4, 0));
        p4.add((Component)new JLabel("Saturation"), "North");
        this.satSlider = new JSlider(0, 100, sat);
        this.satSlider.addChangeListener(sliderAction);
        this.satSlider.setMajorTickSpacing(50);
        this.satSlider.setPaintTicks(true);
        p4.add((Component)this.satSlider, "Center");
        this.satField = new JTextField("" + this.satSlider.getValue(), 4);
        this.satField.getDocument().addDocumentListener(new SatInputListener());
        this.satField.addKeyListener(new ArrowKeyAction(this.satField, 0, 100));
        this.satField.setHorizontalAlignment(0);
        p5.add(this.satField);
        p4.add((Component)p5, "East");
        p2.add(p4);
        p5 = new JPanel(new FlowLayout(0, 0, 0));
        p4 = new JPanel(new BorderLayout(4, 0));
        p4.add((Component)new JLabel("Brightness"), "North");
        this.briSlider = new JSlider(-100, 100, bri);
        this.briSlider.addChangeListener(sliderAction);
        this.briSlider.setMajorTickSpacing(100);
        this.briSlider.setPaintTicks(true);
        p4.add((Component)this.briSlider, "Center");
        this.briField = new JTextField("" + this.briSlider.getValue(), 4);
        this.briField.getDocument().addDocumentListener(new BriInputListener());
        this.briField.addKeyListener(new ArrowKeyAction(this.briField, -100, 100));
        this.briField.setHorizontalAlignment(0);
        p5.add(this.briField);
        p4.add((Component)p5, "East");
        p2.add(p4);
        p3.add(p2);
        p1.add((Component)p3, "Center");
        p5 = new JPanel(new FlowLayout(0, 2, 6));
        this.preserveGrey = new JCheckBox("Preserve grey values", true);
        this.preserveGrey.addActionListener(new PreserveAction());
        p5.add(this.preserveGrey);
        p1.add((Component)p5, "South");
        this.getContentPane().add((Component)p1, "Center");
        p3 = new JPanel(new FlowLayout(2, 8, 4));
        p3.setBorder(new EtchedBorder());
        JButton b = new JButton("Cancel");
        b.setMnemonic(67);
        b.addActionListener(new CancelAction());
        p3.add(b);
        b = new JButton("OK");
        b.setMnemonic(79);
        this.getRootPane().setDefaultButton(b);
        b.addActionListener(new OKAction());
        p3.add(b);
        this.getContentPane().add((Component)p3, "South");
        p5 = new JPanel(new FlowLayout(1, 8, 8));
        this.iconPanel = new IconPanel();
        p5.add(this.iconPanel);
        this.getContentPane().add((Component)p5, "East");
        this.pack();
        Dimension size = this.getSize();
        this.setLocation(frame.getLocationOnScreen().x + (frame.getWidth() - this.getSize().width) / 2, frame.getLocationOnScreen().y + (frame.getHeight() - this.getSize().height) / 2);
    }

    public static boolean showDialog(Frame frame, ControlPanel.HSBControl control) {
        if (myInstance == null) {
            myInstance = new HSBChooser(frame);
        }
        HSBChooser.myInstance.hsbControl = control;
        HSBChooser.myInstance.result = false;
        myInstance.setParams(control);
        myInstance.setVisible(true);
        return HSBChooser.myInstance.result;
    }

    public static void deleteInstance() {
        myInstance = null;
    }

    private void setParams(ControlPanel.HSBControl control) {
        hue = control.getHue();
        sat = control.getSaturation();
        bri = control.getBrightness();
        this.icon = (ImageIcon)control.getUncolorizedIcon();
        this.colorizedIcon = DrawRoutines.colorizeIcon(this.icon.getImage(), control.getHSBReference());
        this.valueIsAdjusting = true;
        this.hueSlider.setValue(hue);
        this.satSlider.setValue(sat);
        this.briSlider.setValue(bri);
        this.preserveGrey.setSelected(control.isPreserveGrey());
        this.valueIsAdjusting = false;
        this.iconPanel.installIcons();
    }

    private void performAction() {
        if (this.valueIsAdjusting) {
            return;
        }
        this.hsbControl.setHue(hue);
        this.hsbControl.setSaturation(sat);
        this.hsbControl.setBrightness(bri);
        this.hsbControl.setPreserveGrey(this.preserveGrey.isSelected());
        this.colorizedIcon = DrawRoutines.colorizeIcon(this.icon.getImage(), this.hsbControl.getHSBReference());
        this.iconPanel.updateColorizedIcon();
    }

    class IconPanel
    extends JPanel {
        JLabel colorizedLabel;

        IconPanel() {
            super(new GridLayout(2, 1, 4, 8));
            this.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
            this.add(new BorderLabel(null));
            this.add(new BorderLabel(null));
        }

        void installIcons() {
            this.removeAll();
            this.colorizedLabel = new BorderLabel(HSBChooser.this.colorizedIcon);
            this.add(this.colorizedLabel);
            this.add(new BorderLabel(HSBChooser.this.icon));
        }

        void updateColorizedIcon() {
            this.colorizedLabel.setIcon(HSBChooser.this.colorizedIcon);
        }

        class BorderLabel
        extends JLabel {
            private Icon icon;
            private Dimension size;

            BorderLabel(Icon icon) {
                super(icon);
                this.size = new Dimension(48, 48);
                this.icon = icon;
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
                this.setOpaque(true);
                if (HSBChooser.this.hsbControl != null) {
                    if (HSBChooser.this.hsbControl.controlsTreeIcon()) {
                        this.setBackground(Theme.treeBgColor.getColor());
                    } else if (HSBChooser.this.hsbControl.controlsFrameIcon()) {
                        this.setBackground(Theme.frameColor.getColor());
                    } else {
                        this.setBackground(Theme.backColor.getColor());
                    }
                }
            }

            public Dimension getPreferredSize() {
                return this.size;
            }
        }
    }

    class CancelAction
    implements ActionListener {
        CancelAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HSBChooser.this.result = false;
            HSBChooser.this.setVisible(false);
        }
    }

    class OKAction
    implements ActionListener {
        OKAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HSBChooser.this.result = true;
            HSBChooser.this.setVisible(false);
        }
    }

    class PreserveAction
    implements ActionListener {
        PreserveAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HSBChooser.this.performAction();
        }
    }

    class ArrowKeyAction
    extends KeyAdapter
    implements ActionListener {
        private JTextField theField;
        private Timer keyTimer;
        private int step;
        private int min;
        private int max;

        ArrowKeyAction(JTextField field, int min, int max) {
            this.theField = field;
            this.min = min;
            this.max = max;
            this.keyTimer = new Timer(20, this);
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 38) {
                this.step = 1;
                if (e.getModifiers() == 1) {
                    this.step = 10;
                }
                this.changeVal();
                this.keyTimer.setInitialDelay(300);
                this.keyTimer.start();
            } else if (e.getKeyCode() == 40) {
                this.step = -1;
                if (e.getModifiers() == 1) {
                    this.step = -10;
                }
                this.changeVal();
                this.keyTimer.setInitialDelay(300);
                this.keyTimer.start();
            }
        }

        public void keyReleased(KeyEvent e) {
            this.keyTimer.stop();
        }

        public void actionPerformed(ActionEvent e) {
            this.changeVal();
        }

        private void changeVal() {
            int val = Integer.parseInt(this.theField.getText()) + this.step;
            if (val > this.max) {
                val = this.max;
            } else if (val < this.min) {
                val = this.min;
            }
            this.theField.setText("" + val);
        }
    }

    class BriInputListener
    implements DocumentListener {
        BriInputListener() {
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        private void update(DocumentEvent e) {
            Document doc = e.getDocument();
            try {
                String text = doc.getText(0, doc.getLength());
                try {
                    int val = Integer.parseInt(text);
                    HSBChooser.this.keyInput = true;
                    bri = val;
                    HSBChooser.this.briSlider.setValue(val);
                    HSBChooser.this.keyInput = false;
                    HSBChooser.this.performAction();
                }
                catch (NumberFormatException ignore) {}
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    class SatInputListener
    implements DocumentListener {
        SatInputListener() {
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        private void update(DocumentEvent e) {
            Document doc = e.getDocument();
            try {
                String text = doc.getText(0, doc.getLength());
                try {
                    int val = Integer.parseInt(text);
                    HSBChooser.this.keyInput = true;
                    sat = val;
                    HSBChooser.this.satSlider.setValue(val);
                    HSBChooser.this.keyInput = false;
                    HSBChooser.this.performAction();
                }
                catch (NumberFormatException ignore) {}
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    class HueInputListener
    implements DocumentListener {
        HueInputListener() {
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        private void update(DocumentEvent e) {
            Document doc = e.getDocument();
            try {
                String text = doc.getText(0, doc.getLength());
                try {
                    int val = Integer.parseInt(text);
                    HSBChooser.this.keyInput = true;
                    hue = val;
                    HSBChooser.this.hueSlider.setValue(val);
                    HSBChooser.this.keyInput = false;
                    HSBChooser.this.performAction();
                }
                catch (NumberFormatException ignore) {}
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    class SliderAction
    implements ChangeListener {
        SliderAction() {
        }

        public void stateChanged(ChangeEvent e) {
            if (!HSBChooser.this.keyInput) {
                if (e.getSource().equals(HSBChooser.this.hueSlider)) {
                    hue = HSBChooser.this.hueSlider.getValue();
                    HSBChooser.this.hueField.setText("" + hue);
                } else if (e.getSource().equals(HSBChooser.this.briSlider)) {
                    bri = HSBChooser.this.briSlider.getValue();
                    HSBChooser.this.briField.setText("" + bri);
                } else if (e.getSource().equals(HSBChooser.this.satSlider)) {
                    sat = HSBChooser.this.satSlider.getValue();
                    HSBChooser.this.satField.setText("" + sat);
                }
                HSBChooser.this.performAction();
            }
        }
    }
}

