/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import de.muntjak.tinylookandfeel.controlpanel.ControlPanel;
import de.muntjak.tinylookandfeel.controlpanel.UndoManager;
import de.muntjak.tinylookandfeel.util.IntReference;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IntControl
extends JSpinner
implements ChangeListener {
    private static final Vector armedControls = new Vector();
    private IntReference ref;
    private boolean forceUpdate;
    private String description;
    private int oldValue;
    private boolean changeState = true;

    IntControl(SpinnerModel model, IntReference ref, boolean forceUpdate, String description) {
        super(model);
        this.ref = ref;
        this.forceUpdate = forceUpdate;
        this.description = description;
        this.oldValue = (Integer)model.getValue();
        this.addChangeListener(this);
    }

    public IntReference getIntReference() {
        return this.ref;
    }

    public String getDescription() {
        return this.description;
    }

    public void commitValue(int value) {
        this.changeState = false;
        this.oldValue = value;
        super.setValue(new Integer(value));
        this.ref.setValue(value);
        this.changeState = true;
    }

    static void confirmChanges() {
        if (armedControls.isEmpty()) {
            return;
        }
        Iterator ii = armedControls.iterator();
        while (ii.hasNext()) {
            ((IntControl)ii.next()).confirmChange();
        }
        armedControls.clear();
    }

    private void confirmChange() {
        UndoManager.storeUndoData(this, this.oldValue);
        this.oldValue = (Integer)this.getValue();
        this.ref.setValue(this.oldValue);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof IntControl)) {
            return false;
        }
        if (this.description == null) {
            return ((IntControl)o).description == null;
        }
        return this.description.equals(((IntControl)o).description);
    }

    public void stateChanged(ChangeEvent e) {
        if (!this.changeState) {
            return;
        }
        if (!armedControls.contains(this)) {
            armedControls.add(this);
        }
        if (!ControlPanel.instance.applySettingsButton.isEnabled()) {
            ControlPanel.instance.applySettingsButton.setEnabled(true);
        }
    }
}

