#include <QtTest/QtTest>
#include <QtGui>
#include <QWidget>
#include <QChar>
#include <QString>
#include <QSignalSpy>
#include "keyboard.h"

class UnitTest : public QObject {
    Q_OBJECT

	private slots:
	    void initializeTestCase();
	    void testKeyboard();
	private:
		KeyBoard *keyBoard;
};

void UnitTest::initializeTestCase() {
	keyBoard = new KeyBoard();
}

void UnitTest::testKeyboard() {
	QSignalSpy spy(keyBoard, SIGNAL(keyPressed(QChar)));

	// Different key clicks
	QTest::keyClicks(keyBoard, "^`+*#<>~@|");

	// Check wether correct key chars emitted
	QCOMPARE(spy[0][0].toString(), QString::fromLatin1("^"));
	QCOMPARE(spy[1][0].toString(), QString::fromLatin1(""));
	QCOMPARE(spy[2][0].toString(), QString::fromLatin1(""));
	QCOMPARE(spy[3][0].toString(), QString::fromLatin1("`"));
	QCOMPARE(spy[4][0].toString(), QString::fromLatin1("+"));
	QCOMPARE(spy[5][0].toString(), QString::fromLatin1("*"));
	QCOMPARE(spy[6][0].toString(), QString::fromLatin1("#"));
	QCOMPARE(spy[7][0].toString(), QString::fromLatin1("<"));
	QCOMPARE(spy[8][0].toString(), QString::fromLatin1(">"));
	QCOMPARE(spy[9][0].toString(), QString::fromLatin1(""));
	QCOMPARE(spy[10][0].toString(), QString::fromLatin1(""));
	QCOMPARE(spy[11][0].toString(), QString::fromLatin1("~"));
	QCOMPARE(spy[12][0].toString(), QString::fromLatin1("@"));
	QCOMPARE(spy[13][0].toString(), QString::fromLatin1("|"));
	QCOMPARE(spy[14][0].toString(), QString::fromLatin1(""));
//QTest::toString()
}

QTEST_MAIN(UnitTest)
#include "unittest.moc"
