/*
Copyright (c) 2006-2007, Tom Thielicke IT Solutions

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301, USA.
*/

/****************************************************************
**
** Implementation of the EvaluationWidget class
** File name: evaluationwidget.cpp
**
****************************************************************/

#include <QHBoxLayout>
#include <QVBoxLayout>

#include "evaluationwidget.h"

EvaluationWidget::EvaluationWidget(int row, int type, QWidget *parent) : QWidget(parent) {
	// Set the logo
	companyLogo = new CompanyLogo(this);
	// Create tab widget
	tabEvaluation = new QTabWidget(this);
	// Object of the user's lesson table
	lessonTableSql = new LessonTableSql(row, type, this);
	// Object of the user's char table
	charTableSql = new CharTableSql(this);
	// Object of the progression chart widget
	progressionWidget = new ProgressionWidget(this);
	// Object of the comparison chart widget
	comparisonWidget  = new IllustrationImage("comparisontable.png", "", this);

	// Add three tabs and insert the table objects
	tabEvaluation->addTab(lessonTableSql, QObject::tr("Lektionen"));
	tabEvaluation->addTab(progressionWidget, QObject::tr("Lektionenverlauf"));
	tabEvaluation->addTab(charTableSql, QObject::tr("Schriftzeichen"));
	tabEvaluation->addTab(comparisonWidget, QObject::tr("Vergleichstabelle"));

    // Create exit (ready) button
    createButtons();

	// Set the layout of all widgets above
	createLayout();

	// Button connection to private slot clickReady()
    connect(buttonReady, SIGNAL(clicked()), this, SLOT(clickReady()));
    connect(buttonHelp, SIGNAL(clicked()), this, SLOT(showHelp()));

	// Set focus on button
    //buttonReady->setFocus();
}

void EvaluationWidget::createButtons() {
	// Default button "Ready"
	buttonHelp = new QPushButton(QObject::tr("&Hilfe"));
	buttonReady = new QPushButton(QObject::tr("&Fertig"));
	buttonReady->setDefault(true);
}

void EvaluationWidget::createLayout() {
	// Button layout horizontal
	QHBoxLayout *buttonLayoutHorizontal = new QHBoxLayout;
    buttonLayoutHorizontal->addWidget(buttonHelp);
    buttonLayoutHorizontal->addWidget(buttonReady);
	// Button layout vertical
	QVBoxLayout *buttonLayoutVertical = new QVBoxLayout;
    buttonLayoutVertical->addSpacing(20);
    buttonLayoutVertical->addLayout(buttonLayoutHorizontal);
	// Logo layout vertical
	QVBoxLayout *logoLayout = new QVBoxLayout;
    logoLayout->addSpacing(10);
    logoLayout->addWidget(companyLogo);
	// Logo layout + button layout horizontal
	QHBoxLayout *bottomLayout = new QHBoxLayout;
    bottomLayout->addLayout(logoLayout);
    bottomLayout->addStretch(1);
    bottomLayout->addLayout(buttonLayoutVertical);
	// Full layout of all widgets vertical
	QVBoxLayout *mainLayout = new QVBoxLayout;
    mainLayout->addWidget(tabEvaluation);
    mainLayout->addSpacing(1);
    mainLayout->addLayout(bottomLayout);
    mainLayout->setMargin(15);
    mainLayout->setSpacing(15);
    // Pass layout to parent widget (this)
	this->setLayout(mainLayout);
}

void EvaluationWidget::clickReady() {
	// User finished the evaluation
	// -> emit a ready signal
	emit readyClicked();
}

void EvaluationWidget::showHelp() {
	QString ahref = "";
	switch (tabEvaluation->currentIndex()) {
		case 0:
			ahref = "#registerlessons";
			break;
		case 1:
			ahref = "#registerprogression";
			break;
		case 2:
			ahref = "#registerchars";
			break;
		case 3:
			ahref = "#registercomparison";
			break;
	}
	helpBrowser = new HelpBrowser("evaluation.html" + ahref, 0);
	helpBrowser->show();
}
