/*
Copyright (c) 2006-2007, Tom Thielicke IT Solutions

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301, USA.
*/

/****************************************************************
**
** Implementation of the IllustrationDialog class
** File name: illustrationdialog.cpp
**
****************************************************************/

#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QSqlQuery>
#include <QSettings>
#include <QMessageBox>
#include <QFontDialog>
#include <QPalette>
#include <QSettings>

#include "illustrationdialog.h"
#include "def/errordefines.h"
#include "errormessage.h"
#include "def/defines.h"

IllustrationDialog::IllustrationDialog(QString filename, int width, int height,
	QString title, QString version, QString setting, int button, QWidget *parent) : QDialog(parent) {

	buttonStyle = button;
	imageName = filename;
	settingName = setting;
	setWindowTitle(title);
	setWindowIcon(QIcon("img/icon.ico"));
	scrollArea = new QScrollArea;
	scrollArea->setBackgroundRole(QPalette::Light);
    // Set the image
	illustrationImage = new IllustrationImage(filename, version);

    // Create buttons
    createButtons();

	// Set the layout of all widgets created above
	createLayout();

	scrollArea->setWidget(illustrationImage);
	scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    buttonStart->setFocus();
    //setFixedWidth(illustrationImage->width() + 31);

    //Max window size for the bitmap
    if (height > 420) {
		height = 420;
	}
    if (width > 560) {
		width = 560;
	}
    setFixedSize(width, height);
}

void IllustrationDialog::createButtons() {
	//Buttons
	buttonStart = new QPushButton(this);
	buttonCancel = new QPushButton(this);
	switch (buttonStyle) {
		case 0:
			buttonStart->setText(QObject::tr("&TIPP10 starten"));
			buttonCancel->setVisible(false);
			break;
		case 1:
			buttonStart->setText(QObject::tr("&Schlieen"));
			buttonCancel->setVisible(false);
			break;
		case 2:
			buttonStart->setText(QObject::tr("&Weiter"));
			buttonCancel->setVisible(false);
			break;
		case 3:
			buttonStart->setText(QObject::tr("&Weiter"));
			buttonCancel->setText(QObject::tr("&Abbrechen"));
			break;
	}
	buttonStart->setDefault(true);
	// Widget connections
    connect(buttonStart, SIGNAL(clicked()), this, SLOT(clickStart()));
    connect(buttonCancel, SIGNAL(clicked()), this, SLOT(clickCancel()));
	showDialogCheck = new QCheckBox(QObject::tr("Dieses &Fenster nicht mehr anzeigen"));
}

void IllustrationDialog::createLayout() {
	// Button layout horizontal
	QHBoxLayout *layoutHorizontal = new QHBoxLayout;
    layoutHorizontal->addSpacing(1);
    layoutHorizontal->addWidget(scrollArea, 1);
    layoutHorizontal->addSpacing(1);
	// Button layout horizontal
	QHBoxLayout *buttonLayoutHorizontal = new QHBoxLayout;
    buttonLayoutHorizontal->addStretch(1);
    if (settingName != "") {
    	buttonLayoutHorizontal->addWidget(showDialogCheck);
	}
    buttonLayoutHorizontal->addSpacing(1);
    buttonLayoutHorizontal->addWidget(buttonCancel);
    buttonLayoutHorizontal->addWidget(buttonStart);
	// Full layout of all widgets vertical
	QVBoxLayout *mainLayout = new QVBoxLayout;
    mainLayout->addLayout(layoutHorizontal);
    mainLayout->addSpacing(1);
    mainLayout->addLayout(buttonLayoutHorizontal);
    mainLayout->setMargin(15);
    mainLayout->setSpacing(15);
    // Pass layout to parent widget (this)
	this->setLayout(mainLayout);
}

void IllustrationDialog::clickStart() {
	writeSettings();
	accept();
}

void IllustrationDialog::clickCancel() {
	writeSettings();
	reject();
}

void IllustrationDialog::writeSettings() {
	// Saves settings of the startwiget
	// (uses the default constructor of QSettings, passing
	// the application and company name see main function)
	QSettings settings;
	if (settingName != "") {
		settings.beginGroup("general");
		settings.setValue(settingName, !showDialogCheck->isChecked());
		settings.endGroup();
	}
}
