/*
Copyright (c) 2006-2007, Tom Thielicke IT Solutions

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301, USA.
*/

/****************************************************************
**
** File name: defines.h
**
****************************************************************/

#ifndef DEFINES_H
#define DEFINES_H

// Common program constants
#define APP_ORGANIZATION 			"Tom Thielicke IT Solutions"
#define APP_COPYRIGHT 				"(c) 2006-2007, Tom Thielicke IT Solutions"
#define APP_NAME 					"TIPP10"
#define APP_URL 					"http://www.tipp10.de"
#define APP_DB 						"tipp10v2.template"
#define APP_USER_DB					"tipp10v2.db"
#define APP_WIDTH_STANDARD			640 //MAC = 680
#define APP_HEIGHT_STANDARD			470 //MAC = 480
#define APP_WIDTH_SMALL				640 //MAC = 680
#define APP_HEIGHT_SMALL			140 //MAC = 150

// Update constants
#define UPDATE_URL 					"www.tipp10.de"
#define UPDATE_URL_VERSION 			"/update/version.tipp10v201"
#define UPDATE_URL_SQL 				"/update/sql.tipp10v201.utf"

// Standard constants
#define DATE_TIME_FORMAT 			"dd.MM.yyyy hh:mm"
#define DATE_FORMAT					"dd.MM.yyyy"
#define FONT_STANDARD 				"Arial"
#define FONT_SIZE_TICKER			18 //MAC = 22
#define FONT_SIZE_TICKER_PAUSE		16 //MAC = 20
#define FONT_SIZE_STATUS			8 //MAC = 10
#define FONT_SIZE_PROGRESS			8 //MAC = 10
#define FONT_SIZE_PROGRESS_LESSON	6 //MAC = 8
#define KEYBOARD_LAYOUT_STANDARD 	0 // 0=DE, 1=CH, 2=NEO etc.
#define KEYBOARD_LAYOUT_MAC		 	0 // 0=WIN, 1=MAC
#define LESSON_TIMELEN_STANDARD 	5
#define LESSON_TOKENLEN_STANDARD	500
#define TICKERSPEED_STANDARD 		2

// Lesson text constants
#define NUM_TOKEN_UNTIL_REFRESH 	25
#define NUM_TOKEN_UNTIL_NEW_LINE 	35
#define TOKEN_NEW_LINE 				0x00b6
#define TOKEN_TAB					0x2192
#define TOKEN_BACKSPACE				0x00b9 //0x00ac

// Constants for dynamic training
#define NUM_TEXT_UNTIL_REPEAT 		10
#define BORDER_LESSON_IS_SENTENCE 	7
#define LAST_LESSON				 	17
#define SYNCHRON_DB_WHILE_TRAINING 	false

#endif // DEFINES_H
