/**
 * Title: NativeCodePage
 * Copyright:   Copyright (c) 2001, 2002, 2003
 * Company:
 * @author  Kenneth J. Pouncey
 *          rewritten by LDC, WVL, Luc
 * @version 0.4
 *
 * Description:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */
package org.tn5250j.encoding;

class NativeCodePage extends CodePage
{
  NativeCodePage(String encoding, int[] ebcdic)
  {
    super(encoding);
    installCP(ebcdic);
  }

   /**
    * This routine will convert an ebcdic value to a displayable unicode
    *    value.
    *
    * If the codepage needs to be converted:
    *    1. first check if a conversion is to take place from ascii to unicode
    *    2. if conversion then first get the ascii value from the ebcdic to
    *          ascii lookup array then obtain the unicode value to from the ascii
    *          to unicode array
    *
    *    For example Code page 870 ebcdic will translate to ascii latin 2
    *       (ISO 8859-2) and we need to convert latin 2 (ISO 8859-2) to
    *       latin 1 (ISO 8859-1) unicode 1250.
    *
    *    So in reality we have an intermediate value to be converted to something
    *       we understand for display.
    *
    */
  public char ebcdic2uni (int index)
  {
      if (convert) {

         if (encoding.equals("1141")) {
            char c = ' ';
            try {
               byte[] b = new byte[1];
               b[0] = (byte)index;
               c = (new String(b, "Cp1141")).charAt(0);
            } catch (java.io.UnsupportedEncodingException uee) {
               uee.printStackTrace();
            }
            return c;
         }

         if (encoding.equals("1140")) {
            char c = ' ';
            try {
               byte[] b = new byte[1];
               b[0] = (byte)index;
               c = (new String(b, "Cp1140")).charAt(0);
            } catch (java.io.UnsupportedEncodingException uee) {
               uee.printStackTrace();
            }
            return c;
         }

         if (encoding.equals("1147")) {
            char c = ' ';
            try {
               byte[] b = new byte[1];
               b[0] = (byte)index;
               c = (new String(b, "Cp1147")).charAt(0);
            } catch (java.io.UnsupportedEncodingException uee) {
               uee.printStackTrace();
            }
            return c;
         }

         if (encoding.equals("1148")) {
          char c = ' ';
          try {
             byte[] b = new byte[1];
             b[0] = (byte)index;
             c = (new String(b, "Cp1148")).charAt(0);
          } catch (java.io.UnsupportedEncodingException uee) {
             uee.printStackTrace();
          }
          return c;
       }

         if (encoding.equals("1112")) {
            char c = ' ';
            try {
               byte[] b = new byte[1];
               b[0] = (byte)index;
               c = (new String(b, "Cp1112")).charAt(0);
            } catch (java.io.UnsupportedEncodingException uee) {
               uee.printStackTrace();
            }
            return c;
         }

         int ea = ebcdic[index & 0xff];
         if (ea > 0x7F) {
//            System.out.println("conversion found for index: " + index + " "  + ea + " "  + (char)ebcdic[index & 0xff] + " " + unicode[ea]);
            return unicode[ea];
         }
         else {
            return (char)ea;
         }

      }
      else
         return (char)ebcdic[index & 0xff];
   }

  public byte uni2ebcdic (char index)
  {
      if (convert) {
        if (encoding.equals("1141")) {
            byte b = 0x0;
            try {
               b = characterToString(index).getBytes("Cp1141")[0];

            } catch (java.io.UnsupportedEncodingException uee) {
               uee.printStackTrace();
            }
            return b;
         }

         if (encoding.equals("1140")) {
            byte b = 0x0;
            try {
               b = characterToString(index).getBytes("Cp1140")[0];
            } catch (java.io.UnsupportedEncodingException uee) {
               uee.printStackTrace();
            }
            return b;
         }

         if (encoding.equals("1147")) {
            byte b = 0x0;
            try {
               b = characterToString(index).getBytes("Cp1147")[0];
            } catch (java.io.UnsupportedEncodingException uee) {
               uee.printStackTrace();
            }
            return b;
         }

         if (encoding.equals("1148")) {
          byte b = 0x0;
          try {
             b = characterToString(index).getBytes("Cp1148")[0];
          } catch (java.io.UnsupportedEncodingException uee) {
             uee.printStackTrace();
          }
          return b;
       }

         if (encoding.equals("1112")) {
            byte b = 0x0;
            try {
               b = characterToString(index).getBytes("Cp1112")[0];
            } catch (java.io.UnsupportedEncodingException uee) {
               uee.printStackTrace();
            }
            return b;
         }

         int ind = index;
         int len = unicode.length;
         if (index > '\u007F')
            for (int x = 0x80; x < len; x++) {
               if (unicode[x] == index) {
//                  System.out.println("conversion found " + (char)index + " " + unicode[x]);
                  ind = x;
                  break;
               }
            }

//         System.out.println("using conversion");
         return (byte)ascii[ind & 0xff];
       }
      else
         return (byte)ascii[index & 0xff];
  }

  private void installCP(int[] cp)
  {
    ebcdic = new int[256];
    ascii  = new int[256];

//    for (int i = 0; i < 256; i++)
//    {
//      ebcdic[i] = cp[i];
//      ascii[cp[i]] = i;
//    }
//
//    if (this.encoding.toLowerCase().startsWith("870-pl"))
//      unicode = uni1250;
//    else if(encoding.toLowerCase().startsWith("1025"))
//      unicode = uni1025;
//    else if(encoding.toLowerCase().startsWith("1026"))
//      unicode = uni1026;
//
//      if (unicode != null)
//      {
//        convert = true;
//  //      System.out.println("Using codepage conversion");
//      }
//      else
//      {
//        convert = false;
//  //      System.out.println("Not using codepage conversion");
//      }

/////////////////////////////////////////////////////////////////////////
//      if (!codePage.toLowerCase().equals(newCodePage.toLowerCase())) {
//         codePage = newCodePage;

         if (!encoding.equals("1112")) {

            int i = 0;
//            int[] cp = CharMappings.getCodePage(codePage);
            do {

               ebcdic[i] = cp[i];
               ascii[cp[i]] = i;
            } while(++i < 256);
         }

         if (encoding.toLowerCase().startsWith("870-pl")) {
            unicode = uni1250;
            convert = true;
//            System.out.println("using conversion");
         } else if(encoding.toLowerCase().startsWith("1025")) {
            unicode = uni1025;
            convert = true;
//            System.out.println("using conversion");
         } else if(encoding.toLowerCase().startsWith("1026")) {
             unicode = uni1026;
             convert = true;
             //            System.out.println("using conversion");
         } else if(encoding.toLowerCase().startsWith("875")) {
             unicode = uni1253;
             convert = true;
             //            System.out.println("using conversion");
         } else if(encoding.toLowerCase().startsWith("1141")) {
             convert = true;
         } else if(encoding.toLowerCase().startsWith("1140")) {
             convert = true;
         } else if(encoding.toLowerCase().startsWith("1147")) {
             convert = true;
         } else if(encoding.toLowerCase().startsWith("1148")) {
          convert = true;
         } else if(encoding.toLowerCase().startsWith("1112")) {
             convert = true;
         } else {
            convert = false;
//            System.out.println("not using conversion");
         }
  }

   private int     ascii[]   = null;
   private int     ebcdic[]  = null;
   private char    unicode[] = null;
   private boolean convert;

   private static final char[] uni1250 = {
      '\u0000', '\u0001', '\u0002', '\u0003' , '\u0004', '\u0005', '\u0006', '\u0007',	/*   0 -   7  */
      '\u0008', '\u0009', 0x0A,     '\u000B' , '\u000C', 0x0D,     '\u000E', '\u000F', /*   8 -  15  */
      '\u0010', '\u0011', '\u0012', '\u0013' , '\u0014', '\u0015', '\u0016', '\u0017',	/*  16 -  23  */
      '\u0018', '\u0019', '\u001A', '\u001B' , '\u001C', '\u001D', '\u001E', '\u001F',	/*  24 -  31  */
      '\u0020', '\u0021', '\u0022', '\u0023' , '\u0024', '\u0025', '\u0026', 0x27,	   /*  32 -  39  */
      '\u0028', '\u0029', '\u002A', '\u002B' , '\u002C', '\u002D', '\u002E', '\u002F',	/*  40 -  47  */
      '\u0030', '\u0031', '\u0032', '\u0033' , '\u0034', '\u0035', '\u0036', '\u0037',	/*  48 -  55  */
      '\u0038', '\u0039', '\u003A', '\u003B' , '\u003C', '\u003D', '\u003E', '\u003F',	/*  56 -  63  */
      '\u0040', '\u0041', '\u0042', '\u0043' , '\u0044', '\u0045', '\u0046', '\u0047',	/*  64 -  71  */
      '\u0048', '\u0049', '\u004A', '\u004B' , '\u004C', '\u004D', '\u004E', '\u004F',	/*  72 -  81  */
      '\u0050', '\u0051', '\u0052', '\u0053' , '\u0054', '\u0055', '\u0056', '\u0057',	/*  80 -  89  */
      '\u0058', '\u0059', '\u005A', '\u005B' , 0x5C,     '\u005D', '\u005E', '\u005F',	/*  88 -  95  */
      '\u0060', '\u0061', '\u0062', '\u0063' , '\u0064', '\u0065', '\u0066', '\u0067',	/*  96 - 103  */
      '\u0068', '\u0069', '\u006A', '\u006B' , '\u006C', '\u006D', '\u006E', '\u006F',	/* 104 - 111  */
      '\u0070', '\u0071', '\u0072', '\u0073' , '\u0074', '\u0075', '\u0076', '\u0077',	/* 112 - 119  */
      '\u0088', '\u0079', '\u007A', '\u007B' , '\u007C', '\u007D', '\u007E', '\u007F',	/* 120 - 127  */
      '\u20AC', '\u0000', '\u201A', '\u0000' , '\u201E', '\u2026', '\u2020', '\u2021',	/* 128 - 135  */
      '\u0000', '\u2030', '\u0160', '\u2039' , '\u015A', '\u0164', '\u017D', '\u0179',	/* 136 - 143  */
      '\u0000', '\u2018', '\u2019', '\u201C' , '\u201D', '\u2022', '\u2013', '\u2014',	/* 144 - 151  */
      '\u0000', '\u2122', '\u0161', '\u203A' , '\u015B', '\u0165', '\u017E', '\u017A',	/* 152 - 159  */
      '\u00A0', '\u20C7', '\u02D8', '\u0141' , '\u00A4', '\u0104', '\u00A6', '\u00A7',	/* 160 - 167  */
      '\u00A8', '\u00A9', '\u015E', '\u00AB' , '\u00AC', '\u00AD', '\u00AE', '\u017B',	/* 168 - 175  */
      '\u00B0', '\u00B1', '\u02DB', '\u0142' , '\u00B4', '\u00B5', '\u00B6', '\u00B7',	/* 176 - 183  */
      '\u00B8', '\u0105', '\u015F', '\u00BB' , '\u013D', '\u02DD', '\u013E', '\u017C',	/* 184 - 191  */
      '\u0154', '\u00C1', '\u00C2', '\u0102', '\u00C4' , '\u0139', '\u0106', '\u00C7', /* 192 - 199  */
      '\u010C', '\u00C9', '\u0118', '\u00CB', '\u011A' , '\u00CD', '\u00CE', '\u010E', /* 200 - 207  */
      '\u0110', '\u0143', '\u0147', '\u00D3', '\u00D4' , '\u0150', '\u00D6', '\u00D7', /* 208 - 215  */
      '\u0158', '\u016E', '\u00DA', '\u0170', '\u00DC' , '\u00DD', '\u0162', '\u00DF', /* 216 - 223  */
      '\u0155', '\u00E1', '\u00E2', '\u0103', '\u00E4' , '\u013A', '\u0107', '\u00E7', /* 224 - 231  */
      '\u010D', '\u00E9', '\u0119', '\u00EB', '\u011B' , '\u00ED', '\u00EE', '\u010F', /* 232 - 239  */
      '\u0111', '\u0144', '\u0148', '\u00F3', '\u00F4' , '\u0151', '\u00F6', '\u00F7', /* 240 - 247  */
      '\u0159', '\u016F', '\u00FA', '\u0171', '\u00FC' , '\u00FD', '\u0163', '\u02D9', /* 248 - 255  */
   };

   // Added 1025 code pages by Fomin, Leonid <leonid.fomin@mosnar.com>
   private static final char[] uni1025 = {
     '\u0000','\u0001','\u0002','\u0003','\u0004','\u0005','\u0006','\u0007',
     '\u0008','\u0009',0x0A,'\u000B','\u000C',0x0D,'\u000E','\u000F',
     '\u0010','\u0011','\u0012','\u0013','\u0014','\u0015','\u0016','\u0017',
     '\u0018','\u0019','\u001A','\u001b','\u001c','\u001d','\u001e','\u001f',
     '\u0020','\u0021','\u0022','\u0023','\u0024','\u0025','\u0026',0x27,
     '\u0028','\u0029','\u002a','\u002b','\u002c','\u002d','\u002e','\u002f',
     '\u0030','\u0031','\u0032','\u0033','\u0034','\u0035','\u0036','\u0037',
     '\u0038','\u0039','\u003a','\u003b','\u003c','\u003d','\u003e','\u003f',
     '\u0040','\u0041','\u0042','\u0043','\u0044','\u0045','\u0046','\u0047',
     '\u0048','\u0049','\u004a','\u004b','\u004c','\u004d','\u004e','\u004f',
     '\u0050','\u0051','\u0052','\u0053','\u0054','\u0055','\u0056','\u0057',
     '\u0058','\u0059','\u005a','\u005b',0x5c,'\u005d','\u005e','\u005f',
     '\u0060','\u0061','\u0062','\u0063','\u0064','\u0065','\u0066','\u0067',
     '\u0068','\u0069','\u006A','\u006B','\u006C','\u006D','\u006E','\u006F',
     '\u0070','\u0071','\u0072','\u0073','\u0074','\u0075','\u0076','\u0077',
     '\u0078','\u0079','\u007A','\u007B','\u007C','\u007D','\u007E','\u007F',
     '\u0402','\u0403','\u201A','\u0453','\u201E','\u2026','\u2020','\u2021',
     '\u20AC','\u2030','\u0409','\u2039','\u040A','\u040C','\u040B','\u040F',
     '\u0452','\u2018','\u2019','\u201C','\u201D','\u2022','\u2013','\u2014',
     '\u0098','\u2122','\u0459','\u203A','\u045A','\u045C','\u045B','\u045F',
     '\u00A0','\u040E','\u045E','\u0408','\u00A4','\u0490','\u00A6','\u00A7',
     '\u00A8','\u00A9','\u0404','\u00AB','\u00AC','\u00AD','\u00AE','\u0407',
     '\u00B0','\u00B1','\u0406','\u0456','\u0491','\u00B5','\u00B6','\u00B7',
     '\u0451','\u2116','\u0454','\u00BB','\u0458','\u0405','\u0455','\u0457',
     '\u0410','\u0411','\u0412','\u0413','\u0414','\u0415','\u0416','\u0417',
     '\u0418','\u0419','\u041A','\u041B','\u041C','\u041D','\u041E','\u041E',
     '\u0420','\u0421','\u0422','\u0423','\u0424','\u0425','\u0426','\u0427',
     '\u0428','\u0429','\u042a','\u042b','\u042c','\u042d','\u042e','\u042f',
     '\u0430','\u0431','\u0432','\u0433','\u0434','\u0435','\u0436','\u0437',
     '\u0438','\u0439','\u043a','\u043b','\u043c','\u043d','\u043e','\u043f',
     '\u0440','\u0441','\u0442','\u0443','\u0444','\u0445','\u0446','\u0447',
     '\u0448','\u0449','\u044a','\u044b','\u044c','\u044d','\u044E','\u044F'
     };

    private static final char[] uni1026 = {
        '\u0000','\u0001','\u0002','\u0003','\u0004','\u0005','\u0006','\u0007',
        '\b'    ,'\t'    ,'\n'    ,'\u000B','\f'    ,'\r'    ,'\u000E','\u000F',
        '\u0010','\u0011','\u0012','\u0013','\u0014','\u0015','\u0016','\u0017',
        '\u0018','\u0019','\u001A','\u001B','\u001C','\u001D','\u001E','\u001F',
        '\u0020','\u0021','\"'    ,'\u0023','\u0024','\u0025','\u0026','\''    ,
        '\u0028','\u0029','\u002A','\u002B','\u002C','\u002D','\u002E','\u002F',
        '\u0030','\u0031','\u0032','\u0033','\u0034','\u0035','\u0036','\u0037',
        '\u0038','\u0039','\u003A','\u003B','\u003C','\u003D','\u003E','\u003F',
        '\u0040','\u0041','\u0042','\u0043','\u0044','\u0045','\u0046','\u0047',
        '\u0048','\u0049','\u004A','\u004B','\u004C','\u004D','\u004E','\u004F',
        '\u0050','\u0051','\u0052','\u0053','\u0054','\u0055','\u0056','\u0057',
        '\u0058','\u0059','\u005A','\u005B','\\'    ,'\u005D','\u005E','\u005F',
        '\u0060','\u0061','\u0062','\u0063','\u0064','\u0065','\u0066','\u0067',
        '\u0068','\u0069','\u006A','\u006B','\u006C','\u006D','\u006E','\u006F',
        '\u0070','\u0071','\u0072','\u0073','\u0074','\u0075','\u0076','\u0077',
        '\u0078','\u0079','\u007A','\u007B','\u007C','\u007D','\u007E','\u007F',
        '\u20AC','\u0081','\u201A','\u0192','\u201E','\u2026','\u2020','\u2021',
        '\u02C6','\u2030','\u0160','\u2039','\u0152','\u008D','\u008E','\u008F',
        '\u0090','\u2018','\u2019','\u201C','\u201D','\u2022','\u2013','\u2014',
        '\u02DC','\u2122','\u0161','\u203A','\u0153','\u009D','\u009E','\u0178',
        '\u00A0','\u00A1','\u00A2','\u00A3','\u00A4','\u00A5','\u00A6','\u00A7',
        '\u00A8','\u00A9','\u00AA','\u00AB','\u00AC','\u00AD','\u00AE','\u00AF',
        '\u00B0','\u00B1','\u00B2','\u00B3','\u00B4','\u00B5','\u00B6','\u00B7',
        '\u00B8','\u00B9','\u00BA','\u00BB','\u00BC','\u00BD','\u00BE','\u00BF',
        '\u00C0','\u00C1','\u00C2','\u00C3','\u00C4','\u00C5','\u00C6','\u00C7',
        '\u00C8','\u00C9','\u00CA','\u00CB','\u00CC','\u00CD','\u00CE','\u00CF',
        '\u011E','\u00D1','\u00D2','\u00D3','\u00D4','\u00D5','\u00D6','\u00D7',
        '\u00D8','\u00D9','\u00DA','\u00DB','\u00DC','\u0130','\u015E','\u00DF',
        '\u00E0','\u00E1','\u00E2','\u00E3','\u00E4','\u00E5','\u00E6','\u00E7',
        '\u00E8','\u00E9','\u00EA','\u00EB','\u00EC','\u00ED','\u00EE','\u00EF',
        '\u011F','\u00F1','\u00F2','\u00F3','\u00F4','\u00F5','\u00F6','\u00F7',
        '\u00F8','\u00F9','\u00FA','\u00FB','\u00FC','\u0131','\u015F','\u00FF'
    };

   private static final char[] uni1253 = {
      '\u0000','\u0001','\u0002','\u0003','\u0004','\u0005','\u0006','\u0007',
      '\b','\t','\n','\u000B','\f','\r','\u000E','\u000F',
      '\u0010','\u0011','\u0012','\u0013','\u0014','\u0015','\u0016','\u0017',
      '\u0018','\u0019','\u001A','\u001B','\u001C','\u001D','\u001E','\u001F',
      '\u0020','\u0021','\"','\u0023','\u0024','\u0025','\u0026','\'',
      '\u0028','\u0029','\u002A','\u002B','\u002C','\u002D','\u002E','\u002F',
      '\u0030','\u0031','\u0032','\u0033','\u0034','\u0035','\u0036','\u0037',
      '\u0038','\u0039','\u003A','\u003B','\u003C','\u003D','\u003E','\u003F',
      '\u0040','\u0041','\u0042','\u0043','\u0044','\u0045','\u0046','\u0047',
      '\u0048','\u0049','\u004A','\u004B','\u004C','\u004D','\u004E','\u004F',
      '\u0050','\u0051','\u0052','\u0053','\u0054','\u0055','\u0056','\u0057',
      '\u0058','\u0059','\u005A','\u005B','\\','\u005D','\u005E','\u005F',
      '\u0060','\u0061','\u0062','\u0063','\u0064','\u0065','\u0066','\u0067',
      '\u0068','\u0069','\u006A','\u006B','\u006C','\u006D','\u006E','\u006F',
      '\u0070','\u0071','\u0072','\u0073','\u0074','\u0075','\u0076','\u0077',
      '\u0078','\u0079','\u007A','\u007B','\u007C','\u007D','\u007E','\u007F',
      '\u20AC','\u0081','\u201A','\u0192','\u201E','\u2026','\u2020','\u2021',
      '\u0088','\u2030','\u008A','\u2039','\u008C','\u008D','\u008E','\u008F',
      '\u0090','\u2018','\u2019','\u201C','\u201D','\u2022','\u2013','\u2014',
      '\u0098','\u2122','\u009A','\u203A','\u009C','\u009D','\u009E','\u009F',
      '\u03CA','\u03A7','\u0389','\u00A3','\u038A','\u038C','\u00A6','\u00A7',
      '\u00A8','\u00A9','\u03BD','\u00AB','\u00AC','\u00AD','\u03C1','\u03C3',
      '\u00B0','\u00B1','\u00B2','\u00B3','\u0384','\u03AF','\u03CC','\u00B7',
      '\u03CB','\u03CE','\u03C2','\u00BB','\u03C5','\u00BD','\u03C7','\u03C8',
      '\u03A5','\u0391','\u0392','\u0393','\u0394','\u0395','\u0396','\u0397',
      '\u0398','\u0399','\u03C0','\u03C9','\u0390','\u03B0','\u00A4','\u2015',
      '\u03B6','\u03A6','\u03A8','\u03BA','\u03AA','\u03B2','\u03A4','\u03A9',
      '\u039A','\u039B','\u03AC','\u03C6','\u0385','\u03CD','\u00A0','\u038E',
      '\u03B1','\u00B5','\u039C','\u039D','\u039E','\u039F','\u03A0','\u03A1',
      '\u03A3','\u03AB','\u03AD','\u038F','\u0387','\u00AA','\u03BE','\u03BF',
      '\u03C0','\u00AE','\u03B4','\u03B5','\u03B8','\u03BB','\u03B3','\u03B9',
      '\u0386','\u0388','\u03AE','\u03B7','\u00B6','\u00A5','\u03C4','\u03BC',
   };

   static final String[] acp = {"37","37PT","273","280","284","285",
                                       "277-dk","277-no","278","297","424","500-ch",
                                       "870-pl","870-sk","871","875","1025-r","1026",
                                       "1112","1141","1140","1147","1148"};

   /* Conversion table generated mechanically by Free `recode' 3.5
   for sequence IBM037..ISO-8859-1 (reversible).  */

   private static final int[] codePage37 = {
      0,   1,   2,   3, 156,   9, 134, 127,	/*   0 -   7  */
    151, 141, 142,  11,  12,  13,  14,  15,	/*   8 -  15  */
     16,  17,  18,  19, 157, 133,   8, 135,	/*  16 -  23  */
     24,  25, 146, 143,  28,  29,  30,  31,	/*  24 -  31  */
    128, 129, 130, 131, 132,  10,  23,  27,	/*  32 -  39  */
    136, 137, 138, 139, 140,   5,   6,   7,	/*  40 -  47  */
    144, 145,  22, 147, 148, 149, 150,   4,	/*  48 -  55  */
    152, 153, 154, 155,  20,  21, 158,  26,	/*  56 -  63  */
     32, 160, 226, 228, 224, 225, 227, 229,	/*  64 -  71  */
    231, 241, 162,  46,  60,  40,  43, 124,	/*  72 -  79  */
     38, 233, 234, 235, 232, 237, 238, 239,	/*  80 -  87  */
    236, 223,  33,  36,  42,  41,  59, 172,	/*  88 -  95  */
     45,  47, 194, 196, 192, 193, 195, 197,	/*  96 - 103  */
    199, 209, 166,  44,  37,  95,  62,  63,	/* 104 - 111  */
    248, 201, 202, 203, 200, 205, 206, 207,	/* 112 - 119  */
    204,  96,  58,  35,  64,  39,  61,  34,	/* 120 - 127  */
    216,  97,  98,  99, 100, 101, 102, 103,	/* 128 - 135  */
    104, 105, 171, 187, 240, 253, 254, 177,	/* 136 - 143  */
    176, 106, 107, 108, 109, 110, 111, 112,	/* 144 - 151  */
    113, 114, 170, 186, 230, 184, 198, 164,	/* 152 - 159  */
    181, 126, 115, 116, 117, 118, 119, 120,	/* 160 - 167  */
    121, 122, 161, 191, 208, 221, 222, 174,	/* 168 - 175  */
     94, 163, 165, 183, 169, 167, 182, 188,	/* 176 - 183  */
    189, 190,  91,  93, 175, 168, 180, 215,	/* 184 - 191  */
    123,  65,  66,  67,  68,  69,  70,  71,	/* 192 - 199  */
     72,  73, 173, 244, 246, 242, 243, 245,	/* 200 - 207  */
    125,  74,  75,  76,  77,  78,  79,  80,	/* 208 - 215  */
     81,  82, 185, 251, 252, 249, 250, 255,	/* 216 - 223  */
     92, 247,  83,  84,  85,  86,  87,  88,	/* 224 - 231  */
     89,  90, 178, 212, 214, 210, 211, 213,	/* 232 - 239  */
     48,  49,  50,  51,  52,  53,  54,  55,	/* 240 - 247  */
     56,  57, 179, 219, 220, 217, 218, 159,	/* 248 - 255  */
   };

   /* Conversion table generated mechanically by Free `recode' 3.5
   for sequence IBM273..ISO-8859-1 (reversible).  */

   private static final int[] codePage273 = {
      0,   1,   2,   3, 156,   9, 134, 127,	/*   0 -   7  */
    151, 141, 142,  11,  12,  13,  14,  15,	/*   8 -  15  */
     16,  17,  18,  19, 157, 133,   8, 135,	/*  16 -  23  */
     24,  25, 146, 143,  28,  29,  30,  31,	/*  24 -  31  */
    128, 129, 130, 131, 132,  10,  23,  27,	/*  32 -  39  */
    136, 137, 138, 139, 140,   5,   6,   7,	/*  40 -  47  */
    144, 145,  22, 147, 148, 149, 150,   4,	/*  48 -  55  */
    152, 153, 154, 155,  20,  21, 158,  26,	/*  56 -  63  */
     32, 160, 226, 123, 224, 225, 227, 229,	/*  64 -  71  */
    231, 241, 196,  46,  60,  40,  43,  33,	/*  72 -  79  */
     38, 233, 234, 235, 232, 237, 238, 239,	/*  80 -  87  */
    236, 126, 220,  36,  42,  41,  59,  94,	/*  88 -  95  */
     45,  47, 194,  91, 192, 193, 195, 197,	/*  96 - 103  */
    199, 209, 246,  44,  37,  95,  62,  63,	/* 104 - 111  */
    248, 201, 202, 203, 200, 205, 206, 207,	/* 112 - 119  */
    204,  96,  58,  35, 167,  39,  61,  34,	/* 120 - 127  */
    216,  97,  98,  99, 100, 101, 102, 103,	/* 128 - 135  */
    104, 105, 171, 187, 240, 253, 254, 177,	/* 136 - 143  */
    176, 106, 107, 108, 109, 110, 111, 112,	/* 144 - 151  */
    113, 114, 170, 186, 230, 184, 198, 164,	/* 152 - 159  */
    181, 223, 115, 116, 117, 118, 119, 120,	/* 160 - 167  */
    121, 122, 161, 191, 208, 221, 222, 174,	/* 168 - 175  */
    162, 163, 165, 183, 169,  64, 182, 188,	/* 176 - 183  */
    189, 190, 172, 124, 175, 168, 180, 215,	/* 184 - 191  */
    228,  65,  66,  67,  68,  69,  70,  71,	/* 192 - 199  */
     72,  73, 173, 244, 166, 242, 243, 245,	/* 200 - 207  */
    252,  74,  75,  76,  77,  78,  79,  80,	/* 208 - 215  */
     81,  82, 185, 251, 125, 249, 250, 255,	/* 216 - 223  */
    214, 247,  83,  84,  85,  86,  87,  88,	/* 224 - 231  */
     89,  90, 178, 212,  92, 210, 211, 213,	/* 232 - 239  */
     48,  49,  50,  51,  52,  53,  54,  55,	/* 240 - 247  */
     56,  57, 179, 219,  93, 217, 218, 159,	/* 248 - 255  */
   };

   /* Conversion table generated mechanically by Free `recode' 3.5
   for sequence IBM277..ISO-8859-1 (reversible).  */

   private static final int[] codePage277_DK = {

      0,   1,   2,   3, 156,   9, 134, 127,	/*   0 -   7  */
    151, 141, 142,  11,  12,  13,  14,  15,	/*   8 -  15  */
     16,  17,  18,  19, 157, 133,   8, 135,	/*  16 -  23  */
     24,  25, 146, 143,  28,  29,  30,  31,	/*  24 -  31  */
    128, 129, 130, 131, 132,  10,  23,  27,	/*  32 -  39  */
    136, 137, 138, 139, 140,   5,   6,   7,	/*  40 -  47  */
    144, 145,  22, 147, 148, 149, 150,   4,	/*  48 -  55  */
    152, 153, 154, 155,  20,  21, 158,  26,	/*  56 -  63  */
     32, 160, 226, 228, 224, 225, 227, 125,	/*  64 -  71  */
    231, 241,  35,  46,  60,  40,  43,  33,	/*  72 -  79  */
     38, 233, 234, 235, 232, 237, 238, 239,	/*  80 -  87  */
    236, 223, 164, 197,  42,  41,  59,  94,	/*  88 -  95  */
     45,  47, 194, 196, 192, 193, 195,  36,	/*  96 - 103  */
    199, 209, 248,  44,  37,  95,  62,  63,	/* 104 - 111  */
    166, 201, 202, 203, 200, 205, 206, 207,	/* 112 - 119  */
    204,  96,  58, 198, 216,  39,  61,  34,	/* 120 - 127  */
     64,  97,  98,  99, 100, 101, 102, 103,	/* 128 - 135  */
    104, 105, 171, 187, 240, 253, 254, 177,	/* 136 - 143  */
    176, 106, 107, 108, 109, 110, 111, 112,	/* 144 - 151  */
    113, 114, 170, 186, 123, 184,  91,  93,	/* 152 - 159  */
    181, 252, 115, 116, 117, 118, 119, 120,	/* 160 - 167  */
    121, 122, 161, 191, 208, 221, 222, 174,	/* 168 - 175  */
    162, 163, 165, 183, 169, 167, 182, 188,	/* 176 - 183  */
    189, 190, 172, 124, 175, 168, 180, 215,	/* 184 - 191  */
    230,  65,  66,  67,  68,  69,  70,  71,	/* 192 - 199  */
     72,  73, 173, 244, 246, 242, 243, 245,	/* 200 - 207  */
    229,  74,  75,  76,  77,  78,  79,  80,	/* 208 - 215  */
     81,  82, 185, 251, 126, 249, 250, 255,	/* 216 - 223  */
     92, 247,  83,  84,  85,  86,  87,  88,	/* 224 - 231  */
     89,  90, 178, 212, 214, 210, 211, 213,	/* 232 - 239  */
     48,  49,  50,  51,  52,  53,  54,  55,	/* 240 - 247  */
     56,  57, 179, 219, 220, 217, 218, 159,	/* 248 - 255  */
  };

/* Conversion table generated mechanically by Free `recode' 3.5
   for sequence IBM277..ISO-8859-1 (reversible).  */

   private static final int[] codePage277_NO = {
      0,   1,   2,   3, 156,   9, 134, 127,	/*   0 -   7  */
    151, 141, 142,  11,  12,  13,  14,  15,	/*   8 -  15  */
     16,  17,  18,  19, 157, 133,   8, 135,	/*  16 -  23  */
     24,  25, 146, 143,  28,  29,  30,  31,	/*  24 -  31  */
    128, 129, 130, 131, 132,  10,  23,  27,	/*  32 -  39  */
    136, 137, 138, 139, 140,   5,   6,   7,	/*  40 -  47  */
    144, 145,  22, 147, 148, 149, 150,   4,	/*  48 -  55  */
    152, 153, 154, 155,  20,  21, 158,  26,	/*  56 -  63  */
     32, 160, 226, 228, 224, 225, 227, 125,	/*  64 -  71  */
    231, 241,  35,  46,  60,  40,  43,  33,	/*  72 -  79  */
     38, 233, 234, 235, 232, 237, 238, 239,	/*  80 -  87  */
    236, 223, 164, 197,  42,  41,  59,  94,	/*  88 -  95  */
     45,  47, 194, 196, 192, 193, 195,  36,	/*  96 - 103  */
    199, 209, 248,  44,  37,  95,  62,  63,	/* 104 - 111  */
    166, 201, 202, 203, 200, 205, 206, 207,	/* 112 - 119  */
    204,  96,  58, 198, 216,  39,  61,  34,	/* 120 - 127  */
     64,  97,  98,  99, 100, 101, 102, 103,	/* 128 - 135  */
    104, 105, 171, 187, 240, 253, 254, 177,	/* 136 - 143  */
    176, 106, 107, 108, 109, 110, 111, 112,	/* 144 - 151  */
    113, 114, 170, 186, 123, 184,  91,  93,	/* 152 - 159  */
    181, 252, 115, 116, 117, 118, 119, 120,	/* 160 - 167  */
    121, 122, 161, 191, 208, 221, 222, 174,	/* 168 - 175  */
    162, 163, 165, 183, 169, 167, 182, 188,	/* 176 - 183  */
    189, 190, 172, 124, 175, 168, 180, 215,	/* 184 - 191  */
    230,  65,  66,  67,  68,  69,  70,  71,	/* 192 - 199  */
     72,  73, 173, 244, 246, 242, 243, 245,	/* 200 - 207  */
    229,  74,  75,  76,  77,  78,  79,  80,	/* 208 - 215  */
     81,  82, 185, 251, 126, 249, 250, 255,	/* 216 - 223  */
     92, 247,  83,  84,  85,  86,  87,  88,	/* 224 - 231  */
     89,  90, 178, 212, 214, 210, 211, 213,	/* 232 - 239  */
     48,  49,  50,  51,  52,  53,  54,  55,	/* 240 - 247  */
     56,  57, 179, 219, 220, 217, 218, 159,	/* 248 - 255  */
  };

/* Conversion table generated mechanically by Free `recode' 3.5
   for sequence IBM280..ISO-8859-1 (reversible).  */

   private static final int[] codePage280 = {
      0,   1,   2,   3, 156,   9, 134, 127,	/*   0 -   7  */
    151, 141, 142,  11,  12,  13,  14,  15,	/*   8 -  15  */
     16,  17,  18,  19, 157, 133,   8, 135,	/*  16 -  23  */
     24,  25, 146, 143,  28,  29,  30,  31,	/*  24 -  31  */
    128, 129, 130, 131, 132,  10,  23,  27,	/*  32 -  39  */
    136, 137, 138, 139, 140,   5,   6,   7,	/*  40 -  47  */
    144, 145,  22, 147, 148, 149, 150,   4,	/*  48 -  55  */
    152, 153, 154, 155,  20,  21, 158,  26,	/*  56 -  63  */
     32, 160, 226, 228, 123, 225, 227, 229,	/*  64 -  71  */
     92, 241, 176,  46,  60,  40,  43,  33,	/*  72 -  79  */
     38,  93, 234, 235, 125, 237, 238, 239,	/*  80 -  87  */
    126, 223, 233,  36,  42,  41,  59,  94,	/*  88 -  95  */
     45,  47, 194, 196, 192, 193, 195, 197,	/*  96 - 103  */
    199, 209, 242,  44,  37,  95,  62,  63,	/* 104 - 111  */
    248, 201, 202, 203, 200, 205, 206, 207,	/* 112 - 119  */
    204, 249,  58, 163, 167,  39,  61,  34,	/* 120 - 127  */
    216,  97,  98,  99, 100, 101, 102, 103,	/* 128 - 135  */
    104, 105, 171, 187, 240, 253, 254, 177,	/* 136 - 143  */
     91, 106, 107, 108, 109, 110, 111, 112,	/* 144 - 151  */
    113, 114, 170, 186, 230, 184, 198, 164,	/* 152 - 159  */
    181, 236, 115, 116, 117, 118, 119, 120,	/* 160 - 167  */
    121, 122, 161, 191, 208, 221, 222, 174,	/* 168 - 175  */
    162,  35, 165, 183, 169,  64, 182, 188,	/* 176 - 183  */
    189, 190, 172, 124, 175, 168, 180, 215,	/* 184 - 191  */
    224,  65,  66,  67,  68,  69,  70,  71,	/* 192 - 199  */
     72,  73, 173, 244, 246, 166, 243, 245,	/* 200 - 207  */
    232,  74,  75,  76,  77,  78,  79,  80,	/* 208 - 215  */
     81,  82, 185, 251, 252,  96, 250, 255,	/* 216 - 223  */
    231, 247,  83,  84,  85,  86,  87,  88,	/* 224 - 231  */
     89,  90, 178, 212, 214, 210, 211, 213,	/* 232 - 239  */
     48,  49,  50,  51,  52,  53,  54,  55,	/* 240 - 247  */
     56,  57, 179, 219, 220, 217, 218, 159,	/* 248 - 255  */
   };

   /* Conversion table generated mechanically by Free `recode' 3.5
   for sequence IBM284..ISO-8859-1 (reversible).  */
   private static final int[] codePage284 =  {
      0,   1,   2,   3, 156,   9, 134, 127,	/*   0 -   7  */
    151, 141, 142,  11,  12,  13,  14,  15,	/*   8 -  15  */
     16,  17,  18,  19, 157, 133,   8, 135,	/*  16 -  23  */
     24,  25, 146, 143,  28,  29,  30,  31,	/*  24 -  31  */
    128, 129, 130, 131, 132,  10,  23,  27,	/*  32 -  39  */
    136, 137, 138, 139, 140,   5,   6,   7,	/*  40 -  47  */
    144, 145,  22, 147, 148, 149, 150,   4,	/*  48 -  55  */
    152, 153, 154, 155,  20,  21, 158,  26,	/*  56 -  63  */
     32, 160, 226, 228, 224, 225, 227, 229,	/*  64 -  71  */
    231, 166,  91,  46,  60,  40,  43, 124,	/*  72 -  79  */
     38, 233, 234, 235, 232, 237, 238, 239,	/*  80 -  87  */
    236, 223,  93,  36,  42,  41,  59, 172,	/*  88 -  95  */
     45,  47, 194, 196, 192, 193, 195, 197,	/*  96 - 103  */
    199,  35, 241,  44,  37,  95,  62,  63,	/* 104 - 111  */
    248, 201, 202, 203, 200, 205, 206, 207,	/* 112 - 119  */
    204,  96,  58, 209,  64,  39,  61,  34,	/* 120 - 127  */
    216,  97,  98,  99, 100, 101, 102, 103,	/* 128 - 135  */
    104, 105, 171, 187, 240, 253, 254, 177,	/* 136 - 143  */
    176, 106, 107, 108, 109, 110, 111, 112,	/* 144 - 151  */
    113, 114, 170, 186, 230, 184, 198, 164,	/* 152 - 159  */
    181, 168, 115, 116, 117, 118, 119, 120,	/* 160 - 167  */
    121, 122, 161, 191, 208, 221, 222, 174,	/* 168 - 175  */
    162, 163, 165, 183, 169, 167, 182, 188,	/* 176 - 183  */
    189, 190,  94,  33, 175, 126, 180, 215,	/* 184 - 191  */
    123,  65,  66,  67,  68,  69,  70,  71,	/* 192 - 199  */
     72,  73, 173, 244, 246, 242, 243, 245,	/* 200 - 207  */
    125,  74,  75,  76,  77,  78,  79,  80,	/* 208 - 215  */
     81,  82, 185, 251, 252, 249, 250, 255,	/* 216 - 223  */
     92, 247,  83,  84,  85,  86,  87,  88,	/* 224 - 231  */
     89,  90, 178, 212, 214, 210, 211, 213,	/* 232 - 239  */
     48,  49,  50,  51,  52,  53,  54,  55,	/* 240 - 247  */
     56,  57, 179, 219, 220, 217, 218, 159,	/* 248 - 255  */
   };

/* Conversion table generated mechanically by Free `recode' 3.5
   for sequence IBM297..ISO-8859-1 (reversible).  */
   private static final int[] codePage297 =  {
      0,   1,   2,   3, 156,   9, 134, 127,	/*   0 -   7  */
    151, 141, 142,  11,  12,  13,  14,  15,	/*   8 -  15  */
     16,  17,  18,  19, 157, 133,   8, 135,	/*  16 -  23  */
     24,  25, 146, 143,  28,  29,  30,  31,	/*  24 -  31  */
    128, 129, 130, 131, 132,  10,  23,  27,	/*  32 -  39  */
    136, 137, 138, 139, 140,   5,   6,   7,	/*  40 -  47  */
    144, 145,  22, 147, 148, 149, 150,   4,	/*  48 -  55  */
    152, 153, 154, 155,  20,  21, 158,  26,	/*  56 -  63  */
     32, 160, 226, 228,  64, 225, 227, 229,	/*  64 -  71  */
     92, 241, 176,  46,  60,  40,  43,  33,	/*  72 -  79  */
     38, 123, 234, 235, 125, 237, 238, 239,	/*  80 -  87  */
    236, 223, 167,  36,  42,  41,  59,  94,	/*  88 -  95  */
     45,  47, 194, 196, 192, 193, 195, 197,	/*  96 - 103  */
    199, 209, 249,  44,  37,  95,  62,  63,	/* 104 - 111  */
    248, 201, 202, 203, 200, 205, 206, 207,	/* 112 - 119  */
    204, 181,  58, 163, 224,  39,  61,  34,	/* 120 - 127  */
    216,  97,  98,  99, 100, 101, 102, 103,	/* 128 - 135  */
    104, 105, 171, 187, 240, 253, 254, 177,	/* 136 - 143  */
     91, 106, 107, 108, 109, 110, 111, 112,	/* 144 - 151  */
    113, 114, 170, 186, 230, 184, 198, 164,	/* 152 - 159  */
     96, 168, 115, 116, 117, 118, 119, 120,	/* 160 - 167  */
    121, 122, 161, 191, 208, 221, 222, 174,	/* 168 - 175  */
    162,  35, 165, 183, 169,  93, 182, 188,	/* 176 - 183  */
    189, 190, 172, 124, 175, 126, 180, 215,	/* 184 - 191  */
    233,  65,  66,  67,  68,  69,  70,  71,	/* 192 - 199  */
     72,  73, 173, 244, 246, 242, 243, 245,	/* 200 - 207  */
    232,  74,  75,  76,  77,  78,  79,  80,	/* 208 - 215  */
     81,  82, 185, 251, 252, 166, 250, 255,	/* 216 - 223  */
    231, 247,  83,  84,  85,  86,  87,  88,	/* 224 - 231  */
     89,  90, 178, 212, 214, 210, 211, 213,	/* 232 - 239  */
     48,  49,  50,  51,  52,  53,  54,  55,	/* 240 - 247  */
     56,  57, 179, 219, 220, 217, 218, 159,	/* 248 - 255  */
   };

/* Conversion table generated mechanically by Free `recode' 3.5
   for sequence EBCDIC-PT..ISO-8859-1 (reversible).  */

   private static final int[] codePage37PT = {
      0,   1,   2,   3, 156,   9, 134, 127,	/*   0 -   7  */
    151, 141, 142,  11,  12,  13,  14,  15,	/*   8 -  15  */
     16,  17,  18,  19, 157, 133,   8, 135,	/*  16 -  23  */
     24,  25, 146, 143,  28,  29,  30,  31,	/*  24 -  31  */
    128, 129, 130, 131, 132,  10,  23,  27,	/*  32 -  39  */
    136, 137, 138, 139, 140,   5,   6,   7,	/*  40 -  47  */
    144, 145,  22, 147, 148, 149, 150,   4,	/*  48 -  55  */
    152, 153, 154, 155,  20,  21, 158,  26,	/*  56 -  63  */
     32, 193, 194, 123, 196, 197, 198, 224,	/*  64 -  71  */
    200, 201,  91,  46,  60,  40,  43,  33,	/*  72 -  79  */
     38, 216, 217, 226, 192, 228, 229, 230,	/*  80 -  87  */
    161, 232,  93,  36,  42,  41,  59,  94,	/*  88 -  95  */
     45,  47, 214,  35, 209, 126, 210, 215,	/*  96 - 103  */
    212, 233, 245,  44,  37,  95,  62,  63,	/* 104 - 111  */
    242, 248, 249, 162, 163, 164, 165, 166,	/* 112 - 119  */
    167,  96,  58, 195, 213,  39,  61,  34,	/* 120 - 127  */
     64,  97,  98,  99, 100, 101, 102, 103,	/* 128 - 135  */
    104, 105,  92, 124, 246, 168, 243, 125,	/* 136 - 143  */
    240, 106, 107, 108, 109, 110, 111, 112,	/* 144 - 151  */
    113, 114, 169, 244, 247, 211, 241, 255,	/* 152 - 159  */
    160, 231, 115, 116, 117, 118, 119, 120,	/* 160 - 167  */
    121, 122, 170, 171, 172, 173, 174, 175,	/* 168 - 175  */
    176, 177, 178, 179, 208, 181, 182, 183,	/* 176 - 183  */
    184, 185, 186, 187, 188, 189, 190, 191,	/* 184 - 191  */
    227,  65,  66,  67,  68,  69,  70,  71,	/* 192 - 199  */
     72,  73, 202, 203, 204, 205, 206, 207,	/* 200 - 207  */
    180,  74,  75,  76,  77,  78,  79,  80,	/* 208 - 215  */
     81,  82, 218, 219, 220, 221, 222, 223,	/* 216 - 223  */
    199, 225,  83,  84,  85,  86,  87,  88,	/* 224 - 231  */
     89,  90, 234, 235, 236, 237, 238, 239,	/* 232 - 239  */
     48,  49,  50,  51,  52,  53,  54,  55,	/* 240 - 247  */
     56,  57, 250, 251, 252, 253, 254, 159,	/* 248 - 255  */
  };

/* Conversion table generated mechanically by Free `recode' 3.5
   for sequence IBM500..ISO-8859-1 (reversible).  */

   private static final int[] codePage500ch = {

      0,   1,   2,   3, 156,   9, 134, 127,	/*   0 -   7  */
    151, 141, 142,  11,  12,  13,  14,  15,	/*   8 -  15  */
     16,  17,  18,  19, 157, 133,   8, 135,	/*  16 -  23  */
     24,  25, 146, 143,  28,  29,  30,  31,	/*  24 -  31  */
    128, 129, 130, 131, 132,  10,  23,  27,	/*  32 -  39  */
    136, 137, 138, 139, 140,   5,   6,   7,	/*  40 -  47  */
    144, 145,  22, 147, 148, 149, 150,   4,	/*  48 -  55  */
    152, 153, 154, 155,  20,  21, 158,  26,	/*  56 -  63  */
     32, 160, 226, 228, 224, 225, 227, 229,	/*  64 -  71  */
    231, 241,  91,  46,  60,  40,  43,  33,	/*  72 -  79  */
     38, 233, 234, 235, 232, 237, 238, 239,	/*  80 -  87  */
    236, 223,  93,  36,  42,  41,  59,  94,	/*  88 -  95  */
     45,  47, 194, 196, 192, 193, 195, 197,	/*  96 - 103  */
    199, 209, 166,  44,  37,  95,  62,  63,	/* 104 - 111  */
    248, 201, 202, 203, 200, 205, 206, 207,	/* 112 - 119  */
    204,  96,  58,  35,  64,  39,  61,  34,	/* 120 - 127  */
    216,  97,  98,  99, 100, 101, 102, 103,	/* 128 - 135  */
    104, 105, 171, 187, 240, 253, 254, 177,	/* 136 - 143  */
    176, 106, 107, 108, 109, 110, 111, 112,	/* 144 - 151  */
    113, 114, 170, 186, 230, 184, 198, 164,	/* 152 - 159  */
    181, 126, 115, 116, 117, 118, 119, 120,	/* 160 - 167  */
    121, 122, 161, 191, 208, 221, 222, 174,	/* 168 - 175  */
    162, 163, 165, 183, 169, 167, 182, 188,	/* 176 - 183  */
    189, 190, 172, 124, 175, 168, 180, 215,	/* 184 - 191  */
    123,  65,  66,  67,  68,  69,  70,  71,	/* 192 - 199  */
     72,  73, 173, 244, 246, 242, 243, 245,	/* 200 - 207  */
    125,  74,  75,  76,  77,  78,  79,  80,	/* 208 - 215  */
     81,  82, 185, 251, 252, 249, 250, 255,	/* 216 - 223  */
     92, 247,  83,  84,  85,  86,  87,  88,	/* 224 - 231  */
     89,  90, 178, 212, 214, 210, 211, 213,	/* 232 - 239  */
     48,  49,  50,  51,  52,  53,  54,  55,	/* 240 - 247  */
     56,  57, 179, 219, 220, 217, 218, 159,	/* 248 - 255  */
  };


/* Conversion table generated mechanically by Free `recode' 3.5
   for sequence IBM285..ISO-8859-1 (reversible).  */

   private static final int[] codePage285 = {

      0,   1,   2,   3, 156,   9, 134, 127,	/*   0 -   7  */
    151, 141, 142,  11,  12,  13,  14,  15,	/*   8 -  15  */
     16,  17,  18,  19, 157, 133,   8, 135,	/*  16 -  23  */
     24,  25, 146, 143,  28,  29,  30,  31,	/*  24 -  31  */
    128, 129, 130, 131, 132,  10,  23,  27,	/*  32 -  39  */
    136, 137, 138, 139, 140,   5,   6,   7,	/*  40 -  47  */
    144, 145,  22, 147, 148, 149, 150,   4,	/*  48 -  55  */
    152, 153, 154, 155,  20,  21, 158,  26,	/*  56 -  63  */
     32, 160, 226, 228, 224, 225, 227, 229,	/*  64 -  71  */
    231, 241,  36,  46,  60,  40,  43, 124,	/*  72 -  79  */
     38, 233, 234, 235, 232, 237, 238, 239,	/*  80 -  87  */
    236, 223,  33, 163,  42,  41,  59, 172,	/*  88 -  95  */
     45,  47, 194, 196, 192, 193, 195, 197,	/*  96 - 103  */
    199, 209, 166,  44,  37,  95,  62,  63,	/* 104 - 111  */
    248, 201, 202, 203, 200, 205, 206, 207,	/* 112 - 119  */
    204,  96,  58,  35,  64,  39,  61,  34,	/* 120 - 127  */
    216,  97,  98,  99, 100, 101, 102, 103,	/* 128 - 135  */
    104, 105, 171, 187, 240, 253, 254, 177,	/* 136 - 143  */
    176, 106, 107, 108, 109, 110, 111, 112,	/* 144 - 151  */
    113, 114, 170, 186, 230, 184, 198, 164,	/* 152 - 159  */
    181, 175, 115, 116, 117, 118, 119, 120,	/* 160 - 167  */
    121, 122, 161, 191, 208, 221, 222, 174,	/* 168 - 175  */
    162,  91, 165, 183, 169, 167, 182, 188,	/* 176 - 183  */
    189, 190,  94,  93, 126, 168, 180, 215,	/* 184 - 191  */
    123,  65,  66,  67,  68,  69,  70,  71,	/* 192 - 199  */
     72,  73, 173, 244, 246, 242, 243, 245,	/* 200 - 207  */
    125,  74,  75,  76,  77,  78,  79,  80,	/* 208 - 215  */
     81,  82, 185, 251, 252, 249, 250, 255,	/* 216 - 223  */
     92, 247,  83,  84,  85,  86,  87,  88,	/* 224 - 231  */
     89,  90, 178, 212, 214, 210, 211, 213,	/* 232 - 239  */
     48,  49,  50,  51,  52,  53,  54,  55,	/* 240 - 247  */
     56,  57, 179, 219, 220, 217, 218, 159,	/* 248 - 255  */
  };

  /* Conversion table generated mechanically by Free `recode' 3.5
   for sequence IBM424..ISO-8859-1 (reversible).  */

   private static final int[] codePage424 = {
      0,   1,   2,   3, 156,   9, 134, 127,	/*   0 -   7  */
    151, 141, 142,  11,  12,  13,  14,  15,	/*   8 -  15  */
     16,  17,  18,  19, 157, 133,   8, 135,	/*  16 -  23  */
     24,  25, 146, 143,  28,  29,  30,  31,	/*  24 -  31  */
    128, 129, 130, 131, 132,  10,  23,  27,	/*  32 -  39  */
    136, 137, 138, 139, 140,   5,   6,   7,	/*  40 -  47  */
    144, 145,  22, 147, 148, 149, 150,   4,	/*  48 -  55  */
    152, 153, 154, 155,  20,  21, 158,  26,	/*  56 -  63  */
     32, 193, 194, 195, 196, 197, 198, 199,	/*  64 -  71  */
    200, 201, 162,  46,  60,  40,  43, 124,	/*  72 -  79  */
     38, 216, 217, 226, 227, 228, 229, 230,	/*  80 -  87  */
    231, 232,  33,  36,  42,  41,  59, 172,	/*  88 -  95  */
     45,  47, 233, 192, 186, 161, 210, 191,	/*  96 - 103  */
    212, 213, 166,  44,  37,  95,  62,  63,	/* 104 - 111  */
    242, 248, 249, 209, 160, 255, 234, 241,	/* 112 - 119  */
    177,  96,  58,  35,  64,  39,  61,  34,	/* 120 - 127  */
    214,  97,  98,  99, 100, 101, 102, 103,	/* 128 - 135  */
    104, 105, 171, 187, 246, 211, 243, 208,	/* 136 - 143  */
    176, 106, 107, 108, 109, 110, 111, 112,	/* 144 - 151  */
    113, 114, 218, 240, 225, 184, 245, 164,	/* 152 - 159  */
    181, 126, 115, 116, 117, 118, 119, 120,	/* 160 - 167  */
    121, 122, 170, 224, 244, 202, 175, 174,	/* 168 - 175  */
     94, 163, 165, 183, 169, 167, 182, 188,	/* 176 - 183  */
    189, 190,  91,  93, 250, 168, 180, 215,	/* 184 - 191  */
    123,  65,  66,  67,  68,  69,  70,  71,	/* 192 - 199  */
     72,  73, 173, 203, 204, 205, 206, 207,	/* 200 - 207  */
    125,  74,  75,  76,  77,  78,  79,  80,	/* 208 - 215  */
     81,  82, 185, 219, 220, 221, 222, 223,	/* 216 - 223  */
     92, 247,  83,  84,  85,  86,  87,  88,	/* 224 - 231  */
     89,  90, 178, 235, 236, 237, 238, 239,	/* 232 - 239  */
     48,  49,  50,  51,  52,  53,  54,  55,	/* 240 - 247  */
     56,  57, 179, 251, 252, 253, 254, 159,	/* 248 - 255  */
  };

/* Conversion table generated mechanically by my own hands.  */
   private static final int[] codePage870 = {
      0x00, 0x01, 0x02, 0x03, 0xA6, 0x09, 0x86, 0x7F,
      0x97, 0xA9, 0xAB, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
      0x10, 0x11, 0x12, 0x13, 0xAC, 0x85, 0x08, 0x87,
      0x18, 0x19, 0x92, 0xAE, 0x1C, 0x1D, 0x1E, 0x1F,
      0x80, 0x81, 0x82, 0x83, 0x84, 0x0A, 0x17, 0x1B,
      0x88, 0x89, 0xB1, 0x8B, 0xB5, 0x05, 0x06, 0x07,
      0x90, 0x91, 0x16, 0x93, 0x94, 0x95, 0x96, 0x04,
      0x98, 0x99, 0xB6, 0x9B, 0x14, 0x15, 0xB7, 0x1A,
      0x20, 0xA0, 0xE2, 0xE4, 0xFE, 0xE1, 0xE3, 0xE8,
      0xE7, 0xE6, 0x5B, 0x2E, 0x3C, 0x28, 0x2B, 0x21,
      0x26, 0xE9, 0xEA, 0xEB, 0xF9, 0xED, 0xEE, 0xBE,
      0xE5, 0xDF, 0x5D, 0x24, 0x2A, 0x29, 0x3B, 0x5E,
      0x2D, 0x2F, 0xC2, 0xC4, 0xBD, 0xC1, 0xC3, 0xC8,
      0xC7, 0xC6, 0x7C, 0x2C, 0x25, 0x5F, 0x3E, 0x3F,
      0xA1, 0xC9, 0xCA, 0xCB, 0xD9, 0xCD, 0xCE, 0xBC,
      0xC5, 0x60, 0x3A, 0x23, 0x40, 0x27, 0x3D, 0x22,
      0xA2, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
      0x68, 0x69, 0x9C, 0xF2, 0xF0, 0xFD, 0xF8, 0xBA,
      0xB0, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0x70,
      0x71, 0x72, 0xB3, 0xF1, 0x9A, 0xB8, 0xB2, 0xA4,
      0xB9, 0x7E, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
      0x79, 0x7A, 0x8C, 0xD2, 0xD0, 0xDD, 0xD8, 0xAA,
      0xFF, 0xA5, 0xBF, 0xDE, 0xAF, 0xA7, 0x9E, 0x9F,
      0x8E, 0x8F, 0xA3, 0xD1, 0x8A, 0xA8, 0xB4, 0xD7,
      0x7B, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
      0x48, 0x49, 0xAD, 0xF4, 0xF6, 0xE0, 0xF3, 0xF5,
      0x7D, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50,
      0x51, 0x52, 0xCC, 0xFB, 0xFC, 0x9D, 0xFA, 0xEC,
      0x5C, 0xF7, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
      0x59, 0x5A, 0xEF, 0xD4, 0xD6, 0xC0, 0xD3, 0xD5,
      0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
      0x38, 0x39, 0xCF, 0xDB, 0xDC, 0x8D, 0xDA, 0xBB,
   };

   /* Conversion table generated mechanically by Free `recode' 3.5
   for sequence IBM870..ISO-8859-1 (reversible).  */
   private static final int[] codePage870sk = {

      0,   1,   2,   3, 156,   9, 134, 127,	/*   0 -   7  */
    151, 141, 142,  11,  12,  13,  14,  15,	/*   8 -  15  */
     16,  17,  18,  19, 157, 133,   8, 135,	/*  16 -  23  */
     24,  25, 146, 143,  28,  29,  30,  31,	/*  24 -  31  */
    128, 129, 130, 131, 132,  10,  23,  27,	/*  32 -  39  */
    136, 137, 138, 139, 140,   5,   6,   7,	/*  40 -  47  */
    144, 145,  22, 147, 148, 149, 150,   4,	/*  48 -  55  */
    152, 153, 154, 155,  20,  21, 158,  26,	/*  56 -  63  */
     32, 160, 194, 228, 192, 225, 198, 226,	/*  64 -  71  */
    231, 248,  91,  46,  60,  40,  43,  33,	/*  72 -  79  */
     38, 233, 217, 235, 227, 237, 229, 230,	/*  80 -  87  */
    200, 223,  93,  36,  42,  41,  59,  94,	/*  88 -  95  */
     45,  47, 236, 196, 209, 193, 210, 191,	/*  96 - 103  */
    199, 216, 124,  44,  37,  95,  62,  63,	/* 104 - 111  */
    242, 201, 249, 203, 163, 205, 165, 166,	/* 112 - 119  */
    181,  96,  58,  35,  64,  39,  61,  34,	/* 120 - 127  */
    241,  97,  98,  99, 100, 101, 102, 103,	/* 128 - 135  */
    104, 105, 224, 213, 204, 253, 206, 208,	/* 136 - 143  */
    176, 106, 107, 108, 109, 110, 111, 112,	/* 144 - 151  */
    113, 114, 169, 162, 197, 184, 245, 164,	/* 152 - 159  */
    161, 126, 115, 116, 117, 118, 119, 120,	/* 160 - 167  */
    121, 122, 170, 171, 172, 221, 174, 175,	/* 168 - 175  */
    183, 177, 178, 179, 190, 167, 182, 240,	/* 176 - 183  */
    238, 185, 186, 187, 188, 168, 180, 215,	/* 184 - 191  */
    123,  65,  66,  67,  68,  69,  70,  71,	/* 192 - 199  */
     72,  73, 173, 244, 246, 255, 243, 207,	/* 200 - 207  */
    125,  74,  75,  76,  77,  78,  79,  80,	/* 208 - 215  */
     81,  82, 254, 219, 252, 202, 250, 232,	/* 216 - 223  */
     92, 247,  83,  84,  85,  86,  87,  88,	/* 224 - 231  */
     89,  90, 234, 212, 214, 195, 211, 239,	/* 232 - 239  */
     48,  49,  50,  51,  52,  53,  54,  55,	/* 240 - 247  */
     56,  57, 222, 251, 220, 189, 218, 159,	/* 248 - 255  */
  };

   /* Added 871 code page by Karl Helgason, <kalli@midverk.is */
   /* Icelandic characters added, based on codePage870sk above. */
   private static final int[] codePage871 = {
      0,   1,   2,   3, 156,   9, 134, 127,	/*   0 -   7  */
    151, 141, 142,  11,  12,  13,  14,  15,	/*   8 -  15  */
     16,  17,  18,  19, 157, 133,   8, 135,	/*  16 -  23  */
     24,  25, 146, 143,  28,  29,  30,  31,	/*  24 -  31  */
    128, 129, 130, 131, 132,  10,  23,  27,	/*  32 -  39  */
    136, 137, 138, 139, 140,   5,   6,   7,	/*  40 -  47  */
    144, 145,  22, 147, 148, 149, 150,   4,	/*  48 -  55  */
    152, 153, 154, 155,  20,  21, 158,  26,	/*  56 -  63  */
     32, 160, 194, 228, 192, 225,  93, 226,	/*  64 -  71  */
    231, 248, 222,  46,  60,  40,  43,  33,	/*  72 -  79  */
     38, 233, 217, 235, 227, 237, 229, 125,	/*  80 -  87  */
    200, 223, 198,  36,  42,  41,  59, 214,	/*  88 -  95  */
     45,  47, 236, 196, 209, 193, 210, 191,	/*  96 - 103  */
    199, 216, 124,  44,  37,  95,  62,  63,	/* 104 - 111  */
    242, 201, 249, 203, 163, 205, 165, 166,	/* 112 - 119  */
    181, 240,  58,  35, 208,  39,  61,  34,	/* 120 - 127  */
    241,  97,  98,  99, 100, 101, 102, 103,	/* 128 - 135  */
    104, 105, 224, 213, 204, 253, 206,  64,	/* 136 - 143  */
    176, 106, 107, 108, 109, 110, 111, 112,	/* 144 - 151  */
    113, 114, 169, 162, 197, 184, 245, 164,	/* 152 - 159  */
    161, 246, 115, 116, 117, 118, 119, 120,	/* 160 - 167  */
    121, 122, 170, 171, 172, 221, 174, 175,	/* 168 - 175  */
    183, 177, 178, 179, 190, 167, 182, 96,	/* 176 - 183  */
    238, 185, 186, 187, 188, 168, 180, 215,	/* 184 - 191  */
    254,  65,  66,  67,  68,  69,  70,  71,	/* 192 - 199  */
     72,  73, 173, 244, 126, 255, 243, 207,	/* 200 - 207  */
    230,  74,  75,  76,  77,  78,  79,  80,	/* 208 - 215  */
     81,  82, 123, 219, 252, 202, 250, 232,	/* 216 - 223  */
     92, 247,  83,  84,  85,  86,  87,  88,	/* 224 - 231  */
     89,  90, 234, 212, 94, 195, 211, 239,	/* 232 - 239  */
     48,  49,  50,  51,  52,  53,  54,  55,	/* 240 - 247  */
     56,  57,  91, 251, 220, 189, 218, 159,	/* 248 - 255  */
  };

   /* Conversion table generated mechanically by Free `recode' 3.5
   for sequence IBM875..ISO-8859-1 (reversible).  */
   private static final int[] codePage875 = {
      0,   1,   2,   3, 156,   9, 134, 127,	/*   0 -   7  */
    151, 141, 142,  11,  12,  13,  14,  15,	/*   8 -  15  */
     16,  17,  18,  19, 157, 133,   8, 135,	/*  16 -  23  */
     24,  25, 146, 143,  28,  29,  30,  31,	/*  24 -  31  */
    128, 129, 130, 131, 132,  10,  23,  27,	/*  32 -  39  */
    136, 137, 138, 139, 140,   5,   6,   7,	/*  40 -  47  */
    144, 145,  22, 147, 148, 149, 150,   4,	/*  48 -  55  */
    152, 153, 154, 155,  20,  21, 158,  26,	/*  56 -  63  */
     32, 193, 194, 195, 196, 197, 198, 199,	/*  64 -  71  */
    200, 201,  91,  46,  60,  40,  43,  33,	/*  72 -  79  */
     38, 216, 217, 226, 227, 228, 229, 230,	/*  80 -  87  */
    231, 232,  93,  36,  42,  41,  59,  94,	/*  88 -  95  */
     45,  47, 214, 192, 209, 161, 210, 215,	/*  96 - 103  */
    212, 233, 241,  44,  37,  95,  62,  63,	/* 104 - 111  */
    168, 248, 249, 162, 240, 164, 165, 223,	/* 112 - 119  */
    235,  96,  58,  35,  64,  39,  61,  34,	/* 120 - 127  */
    124,  97,  98,  99, 100, 101, 102, 103,	/* 128 - 135  */
    104, 105, 224, 213, 246, 242, 243, 208,	/* 136 - 143  */
    176, 106, 107, 108, 109, 110, 111, 112,	/* 144 - 151  */
    113, 114, 251, 244, 247, 211, 245, 255,	/* 152 - 159  */
    180, 126, 115, 116, 117, 118, 119, 120,	/* 160 - 167  */
    121, 122, 170, 238, 239, 202, 174, 175,	/* 168 - 175  */
    163, 218, 234, 250, 160, 181, 182, 221,	/* 176 - 183  */
    184, 185, 186, 254, 188, 219, 190, 191,	/* 184 - 191  */
    123,  65,  66,  67,  68,  69,  70,  71,	/* 192 - 199  */
     72,  73, 173, 203, 204, 205, 206, 207,	/* 200 - 207  */
    125,  74,  75,  76,  77,  78,  79,  80,	/* 208 - 215  */
     81,  82, 177, 189, 220, 183, 222, 166,	/* 216 - 223  */
     92, 225,  83,  84,  85,  86,  87,  88,	/* 224 - 231  */
     89,  90, 178, 167, 236, 237, 171, 172,	/* 232 - 239  */
     48,  49,  50,  51,  52,  53,  54,  55,	/* 240 - 247  */
     56,  57, 179, 169, 252, 253, 187, 159,	/* 248 - 255  */
  };

   /* Added 1025 code pages by Fomin, Leonid <leonid.fomin@mosnar.com */
   /* Conversion table generated mechanically by my own hands. */
   private static final int[] codePage1025 = {
   0,  1,  2,  3,  164,  9,  134,  127,
   151,  165,  166,  11,  12,  13,  14,  15,
   16,  17,  18,  19,  169,  133,  8,  135,
   24,  25,  146,  171,  28,  29,  30,  31,
   172,  174,  130,  176,  132,  10,  23,  27,
   136,  137,  177,  139,  180,  5,  6,  7,
   181,  145,  22,  147,  148,  149,  150,  4,
   152,  153,  182,  155,  20,  21,  183,  26,
   32,  160,  144,  131,  184,  186,  190,  179,
   191,  188,  91,  46,  60,  40,  43,  33,
   38,  154,  156,  158,  157,  162,  159,  218,
   185,  128,  93,  36,  42,  41,  59,  94,
   45,  47,  129,  168,  170,  189,  178,  175,
   163,  138,  124,  44,  37,  95,  62,  63,
   140,  142,  141,  173,  161,  143,  254,  224,
   225,  96,  58,  35,  64,  39,  61,  34,
   246,  97,  98,  99,  100,  101,  102,  103,
   104,  105,  228,  229,  244,  227,  245,  232,
   233,  106,  107,  108,  109,  110,  111,  112,
   113,  114,  234,  235,  236,  237,  238,  239,
   255,  126,  115,  116,  117,  118,  119,  120,
   121,  122,  240,  241,  242,  243,  230,  226,
   252,  251,  231,  248,  253,  249,  247,  250,
   222,  192,  193,  214,  196,  197,  212,  195,
   123,  65,  66,  67,  68,  69,  70,  71,
   72,  73,  213,  200,  201,  202,  203,  204,
   125,  74,  75,  76,  77,  78,  79,  80,
   81,  82,  205,  206,  207,  223,  208,  209,
   92,  167,  83,  84,  85,  86,  87,  88,
   89,  90,  210,  211,  198,  194,  220,  219,
   48,  49,  50,  51,  52,  53,  54,  55,
   56,  57,  199,  216,  221,  217,  215,  187,
   };

   /* Added 1026 code pages by Omer Guclu <oguclu@superonline.com */
   /* Conversion table generated mechanically by my own hands. */
    private static final int[] codePage1026 = {
        0, 1, 2, 3, 156, 9, 134, 127,
        151, 141, 142, 11, 12, 13, 14, 15,
        16, 17, 18, 19, 157, 133, 8, 135,
        24, 25, 146, 143, 28, 29, 30, 31,
        128, 129, 130, 131, 132, 10, 23, 27,
        136, 137, 138, 139, 140, 5, 6, 7,
        144, 145, 22, 147, 148, 149, 150, 4,
        152, 153, 154, 155, 20, 21, 158, 26,
        32, 160, 226, 228, 224, 225, 227, 229,
        123, 241, 199, 46, 60, 40, 43, 33,
        38, 233, 234, 235, 232, 237, 238, 239,
        236, 223, 208, 221, 42, 41, 59, 94,
        45, 47, 194, 196, 192, 193, 195, 197,
        91, 209, 254, 44, 37, 95, 62, 63,
        248, 201, 202, 203, 200, 205, 206, 207,
        204, 253, 58, 214, 222, 39, 61, 220,
        216, 97, 98, 99, 100, 101, 102, 103,
        104, 105, 171, 187, 125, 96, 166, 177,
        176, 106, 107, 108, 109, 110, 111, 112,
        113, 114, 170, 186, 230, 184, 198, 164,
        181, 246, 115, 116, 117, 118, 119, 120,
        121, 122, 161, 191, 93, 36, 64, 174,
        162, 163, 165, 183, 169, 167, 182, 188,
        189, 190, 172, 124, 175, 168, 180, 215,
        231, 65, 66, 67, 68, 69, 70, 71,
        72, 73, 173, 244, 126, 242, 243, 245,
        240, 74, 75, 76, 77, 78, 79, 80,
        81, 82, 185, 251, 92, 249, 250, 255,
        252, 247, 83, 84, 85, 86, 87, 88,
        89, 90, 178, 212, 35, 210, 211, 213,
        48, 49, 50, 51, 52, 53, 54, 55,
        56, 57, 179, 219, 34, 217, 218, 159,
    };

   /* Conversion table generated mechanically by Free `recode' 3.5
   for sequence IBM273..ISO-8859-1 (reversible).  */
   /* This is CP273 with euro-sign support */

   private static final int[] codePage1141 = {
      0,   1,   2,   3, 156,   9, 134, 127,	/*   0 -   7  */
    151, 141, 142,  11,  12,  13,  14,  15,	/*   8 -  15  */
     16,  17,  18,  19, 157, 133,   8, 135,	/*  16 -  23  */
     24,  25, 146, 143,  28,  29,  30,  31,	/*  24 -  31  */
    128, 129, 130, 131, 132,  10,  23,  27,	/*  32 -  39  */
    136, 137, 138, 139, 140,   5,   6,   7,	/*  40 -  47  */
    144, 145,  22, 147, 148, 149, 150,   4,	/*  48 -  55  */
    152, 153, 154, 155,  20,  21, 158,  26,	/*  56 -  63  */
     32, 160, 226, 123, 224, 225, 227, 229,	/*  64 -  71  */
    231, 241, 196,  46,  60,  40,  43,  33,	/*  72 -  79  */
     38, 233, 234, 235, 232, 237, 238, 239,	/*  80 -  87  */
    236, 126, 220,  36,  42,  41,  59,  94,	/*  88 -  95  */
     45,  47, 194,  91, 192, 193, 195, 197,	/*  96 - 103  */
    199, 209, 246,  44,  37,  95,  62,  63,	/* 104 - 111  */
    248, 201, 202, 203, 200, 205, 206, 207,	/* 112 - 119  */
    204,  96,  58,  35, 167,  39,  61,  34,	/* 120 - 127  */
    216,  97,  98,  99, 100, 101, 102, 103,	/* 128 - 135  */
    104, 105, 171, 187, 240, 253, 254, 177,	/* 136 - 143  */
    176, 106, 107, 108, 109, 110, 111, 112,	/* 144 - 151  */
    //113, 114, 170, 186, 230, 184, 198, 0x20AC,	/* 152 - 159  */
    113, 114, 170, 186, 230, 184, 198, 164,	/* 152 - 159  */
    181, 223, 115, 116, 117, 118, 119, 120,	/* 160 - 167  */
    121, 122, 161, 191, 208, 221, 222, 174,	/* 168 - 175  */
    162, 163, 165, 183, 169,  64, 182, 188,	/* 176 - 183  */
    189, 190, 172, 124, 175, 168, 180, 215,	/* 184 - 191  */
    228,  65,  66,  67,  68,  69,  70,  71,	/* 192 - 199  */
     72,  73, 173, 244, 166, 242, 243, 245,	/* 200 - 207  */
    252,  74,  75,  76,  77,  78,  79,  80,	/* 208 - 215  */
     81,  82, 185, 251, 125, 249, 250, 255,	/* 216 - 223  */
    214, 247,  83,  84,  85,  86,  87,  88,	/* 224 - 231  */
     89,  90, 178, 212,  92, 210, 211, 213,	/* 232 - 239  */
     48,  49,  50,  51,  52,  53,  54,  55,	/* 240 - 247  */
     56,  57, 179, 219,  93, 217, 218, 159,	/* 248 - 255  */
   };

      /* Conversion table generated mechanically by Free `recode' 3.5
   for sequence IBM037..ISO-8859-1 (reversible).  */

   private static final int[] codePage1140 = {
      0,   1,   2,   3, 156,   9, 134, 127,	/*   0 -   7  */
    151, 141, 142,  11,  12,  13,  14,  15,	/*   8 -  15  */
     16,  17,  18,  19, 157, 133,   8, 135,	/*  16 -  23  */
     24,  25, 146, 143,  28,  29,  30,  31,	/*  24 -  31  */
    128, 129, 130, 131, 132,  10,  23,  27,	/*  32 -  39  */
    136, 137, 138, 139, 140,   5,   6,   7,	/*  40 -  47  */
    144, 145,  22, 147, 148, 149, 150,   4,	/*  48 -  55  */
    152, 153, 154, 155,  20,  21, 158,  26,	/*  56 -  63  */
     32, 160, 226, 228, 224, 225, 227, 229,	/*  64 -  71  */
    231, 241, 162,  46,  60,  40,  43, 124,	/*  72 -  79  */
     38, 233, 234, 235, 232, 237, 238, 239,	/*  80 -  87  */
    236, 223,  33,  36,  42,  41,  59, 172,	/*  88 -  95  */
     45,  47, 194, 196, 192, 193, 195, 197,	/*  96 - 103  */
    199, 209, 166,  44,  37,  95,  62,  63,	/* 104 - 111  */
    248, 201, 202, 203, 200, 205, 206, 207,	/* 112 - 119  */
    204,  96,  58,  35,  64,  39,  61,  34,	/* 120 - 127  */
    216,  97,  98,  99, 100, 101, 102, 103,	/* 128 - 135  */
    104, 105, 171, 187, 240, 253, 254, 177,	/* 136 - 143  */
    176, 106, 107, 108, 109, 110, 111, 112,	/* 144 - 151  */
    //176, 106, 107, 108, 109, 110, 111, 0x20AC,	/* 144 - 151  */
    113, 114, 170, 186, 230, 184, 198, 164,	/* 152 - 159  */
    181, 126, 115, 116, 117, 118, 119, 120,	/* 160 - 167  */
    121, 122, 161, 191, 208, 221, 222, 174,	/* 168 - 175  */
     94, 163, 165, 183, 169, 167, 182, 188,	/* 176 - 183  */
    189, 190,  91,  93, 175, 168, 180, 215,	/* 184 - 191  */
    123,  65,  66,  67,  68,  69,  70,  71,	/* 192 - 199  */
     72,  73, 173, 244, 246, 242, 243, 245,	/* 200 - 207  */
    125,  74,  75,  76,  77,  78,  79,  80,	/* 208 - 215  */
     81,  82, 185, 251, 252, 249, 250, 255,	/* 216 - 223  */
     92, 247,  83,  84,  85,  86,  87,  88,	/* 224 - 231  */
     89,  90, 178, 212, 214, 210, 211, 213,	/* 232 - 239  */
     48,  49,  50,  51,  52,  53,  54,  55,	/* 240 - 247  */
     56,  57, 179, 219, 220, 217, 218, 159,	/* 248 - 255  */
   };

/* Conversion table generated mechanically by Free `recode' 3.5
   for sequence IBM297..ISO-8859-1 (reversible).  */
   private static final int[] codePage1147 =  {
      0,   1,   2,   3, 156,   9, 134, 127,	/*   0 -   7  */
    151, 141, 142,  11,  12,  13,  14,  15,	/*   8 -  15  */
     16,  17,  18,  19, 157, 133,   8, 135,	/*  16 -  23  */
     24,  25, 146, 143,  28,  29,  30,  31,	/*  24 -  31  */
    128, 129, 130, 131, 132,  10,  23,  27,	/*  32 -  39  */
    136, 137, 138, 139, 140,   5,   6,   7,	/*  40 -  47  */
    144, 145,  22, 147, 148, 149, 150,   4,	/*  48 -  55  */
    152, 153, 154, 155,  20,  21, 158,  26,	/*  56 -  63  */
     32, 160, 226, 228,  64, 225, 227, 229,	/*  64 -  71  */
     92, 241, 176,  46,  60,  40,  43,  33,	/*  72 -  79  */
     38, 123, 234, 235, 125, 237, 238, 239,	/*  80 -  87  */
    236, 223, 167,  36,  42,  41,  59,  94,	/*  88 -  95  */
     45,  47, 194, 196, 192, 193, 195, 197,	/*  96 - 103  */
    199, 209, 249,  44,  37,  95,  62,  63,	/* 104 - 111  */
    248, 201, 202, 203, 200, 205, 206, 207,	/* 112 - 119  */
    204, 181,  58, 163, 224,  39,  61,  34,	/* 120 - 127  */
    216,  97,  98,  99, 100, 101, 102, 103,	/* 128 - 135  */
    104, 105, 171, 187, 240, 253, 254, 177,	/* 136 - 143  */
     91, 106, 107, 108, 109, 110, 111, 112,	/* 144 - 151  */
//     91, 106, 107, 108, 109, 110, 111, 0x02A,	/* 144 - 151  */
    113, 114, 170, 186, 230, 184, 198, 164,	/* 152 - 159  */
     96, 168, 115, 116, 117, 118, 119, 120,	/* 160 - 167  */
    121, 122, 161, 191, 208, 221, 222, 174,	/* 168 - 175  */
    162,  35, 165, 183, 169,  93, 182, 188,	/* 176 - 183  */
    189, 190, 172, 124, 175, 126, 180, 215,	/* 184 - 191  */
    233,  65,  66,  67,  68,  69,  70,  71,	/* 192 - 199  */
     72,  73, 173, 244, 246, 242, 243, 245,	/* 200 - 207  */
    232,  74,  75,  76,  77,  78,  79,  80,	/* 208 - 215  */
     81,  82, 185, 251, 252, 166, 250, 255,	/* 216 - 223  */
    231, 247,  83,  84,  85,  86,  87,  88,	/* 224 - 231  */
     89,  90, 178, 212, 214, 210, 211, 213,	/* 232 - 239  */
     48,  49,  50,  51,  52,  53,  54,  55,	/* 240 - 247  */
     56,  57, 179, 219, 220, 217, 218, 159,	/* 248 - 255  */
   };

/* Codepage 1148: copied from 500ch  */

   private static final int[] codePage1148 = {

      0,   1,   2,   3, 156,   9, 134, 127,	/*   0 -   7  */
    151, 141, 142,  11,  12,  13,  14,  15,	/*   8 -  15  */
     16,  17,  18,  19, 157, 133,   8, 135,	/*  16 -  23  */
     24,  25, 146, 143,  28,  29,  30,  31,	/*  24 -  31  */
    128, 129, 130, 131, 132,  10,  23,  27,	/*  32 -  39  */
    136, 137, 138, 139, 140,   5,   6,   7,	/*  40 -  47  */
    144, 145,  22, 147, 148, 149, 150,   4,	/*  48 -  55  */
    152, 153, 154, 155,  20,  21, 158,  26,	/*  56 -  63  */
     32, 160, 226, 228, 224, 225, 227, 229,	/*  64 -  71  */
    231, 241,  91,  46,  60,  40,  43,  33,	/*  72 -  79  */
     38, 233, 234, 235, 232, 237, 238, 239,	/*  80 -  87  */
    236, 223,  93,  36,  42,  41,  59,  94,	/*  88 -  95  */
     45,  47, 194, 196, 192, 193, 195, 197,	/*  96 - 103  */
    199, 209, 166,  44,  37,  95,  62,  63,	/* 104 - 111  */
    248, 201, 202, 203, 200, 205, 206, 207,	/* 112 - 119  */
    204,  96,  58,  35,  64,  39,  61,  34,	/* 120 - 127  */
    216,  97,  98,  99, 100, 101, 102, 103,	/* 128 - 135  */
    104, 105, 171, 187, 240, 253, 254, 177,	/* 136 - 143  */
    176, 106, 107, 108, 109, 110, 111, 112,	/* 144 - 151  */
    113, 114, 170, 186, 230, 184, 198, 164,	/* 152 - 159  */
    181, 126, 115, 116, 117, 118, 119, 120,	/* 160 - 167  */
    121, 122, 161, 191, 208, 221, 222, 174,	/* 168 - 175  */
    162, 163, 165, 183, 169, 167, 182, 188,	/* 176 - 183  */
    189, 190, 172, 124, 175, 168, 180, 215,	/* 184 - 191  */
    123,  65,  66,  67,  68,  69,  70,  71,	/* 192 - 199  */
     72,  73, 173, 244, 246, 242, 243, 245,	/* 200 - 207  */
    125,  74,  75,  76,  77,  78,  79,  80,	/* 208 - 215  */
     81,  82, 185, 251, 252, 249, 250, 255,	/* 216 - 223  */
     92, 247,  83,  84,  85,  86,  87,  88,	/* 224 - 231  */
     89,  90, 178, 212, 214, 210, 211, 213,	/* 232 - 239  */
     48,  49,  50,  51,  52,  53,  54,  55,	/* 240 - 247  */
     56,  57, 179, 219, 220, 217, 218, 159,	/* 248 - 255  */
  };


/* Conversion table generated mechanically by Free `recode' 3.5
   for sequence IBM278..ISO-8859-1 (reversible).  */
   private static final int[] codePage278 =  {
      0,   1,   2,   3, 156,   9, 134, 127,	/*   0 -   7  */
    151, 141, 142,  11,  12,  13,  14,  15,	/*   8 -  15  */
     16,  17,  18,  19, 157, 133,   8, 135,	/*  16 -  23  */
     24,  25, 146, 143,  28,  29,  30,  31,	/*  24 -  31  */
    128, 129, 130, 131, 132,  10,  23,  27,	/*  32 -  39  */
    136, 137, 138, 139, 140,   5,   6,   7,	/*  40 -  47  */
    144, 145,  22, 147, 148, 149, 150,   4,	/*  48 -  55  */
    152, 153, 154, 155,  20,  21, 158,  26,	/*  56 -  63  */
     32, 160, 226, 123, 224, 225, 227, 125,	/*  64 -  71  */
    231, 241, 167,  46,  60,  40,  43,  33,	/*  72 -  79  */
     38,  96, 234, 235, 232, 237, 238, 239,	/*  80 -  87  */
    236, 223, 164, 197,  42,  41,  59,  94,	/*  88 -  95  */
     45,  47, 194,  35, 192, 193, 195,  36,	/*  96 - 103  */
    199, 209, 246,  44,  37,  95,  62,  63,	/* 104 - 111  */
    248, 201, 202, 203, 200, 205, 206, 207,	/* 112 - 119  */
    204, 233,  58, 196, 214,  39,  61,  34,	/* 120 - 127  */
    216,  97,  98,  99, 100, 101, 102, 103,	/* 128 - 135  */
    104, 105, 171, 187, 240, 253, 254, 177,	/* 136 - 143  */
    176, 106, 107, 108, 109, 110, 111, 112,	/* 144 - 151  */
    113, 114, 170, 186, 230, 184, 198,  93,	/* 152 - 159  */
    181, 252, 115, 116, 117, 118, 119, 120,	/* 160 - 167  */
    121, 122, 161, 191, 208, 221, 222, 174,	/* 168 - 175  */
    162, 163, 165, 183, 169,  91, 182, 188,	/* 176 - 183  */
    189, 190, 172, 124, 175, 168, 180, 215,	/* 184 - 191  */
    228,  65,  66,  67,  68,  69,  70,  71,	/* 192 - 199  */
     72,  73, 173, 244, 166, 242, 243, 245,	/* 200 - 207  */
    229,  74,  75,  76,  77,  78,  79,  80,	/* 208 - 215  */
     81,  82, 185, 251, 126, 249, 250, 255,	/* 216 - 223  */
     92, 247,  83,  84,  85,  86,  87,  88,	/* 224 - 231  */
     89,  90, 178, 212,  64, 210, 211, 213,	/* 232 - 239  */
     48,  49,  50,  51,  52,  53,  54,  55,	/* 240 - 247  */
     56,  57, 179, 219, 220, 217, 218, 159,	/* 248 - 255  */
  };

   static final CodePage getCodePage(String cp)
   {
      if (cp.equals("37"))
         return new NativeCodePage(cp, codePage37);
      if (cp.equals("37PT"))
         return new NativeCodePage(cp, codePage37PT);
      if (cp.equals("273"))
         return new NativeCodePage(cp, codePage273);
      if (cp.equals("277-dk"))
         return new NativeCodePage(cp, codePage277_DK);
      if (cp.equals("277-no"))
         return new NativeCodePage(cp, codePage277_NO);
      if (cp.equals("278"))
         return new NativeCodePage(cp, codePage278);
      if (cp.equals("280"))
         return new NativeCodePage(cp, codePage280);
      if (cp.equals("284"))
         return new NativeCodePage(cp, codePage284);
      if (cp.equals("285"))
         return new NativeCodePage(cp, codePage285);
      if (cp.equals("297"))
         return new NativeCodePage(cp, codePage297);
      if (cp.equals("424"))
         return new NativeCodePage(cp, codePage500ch);
      if (cp.equals("500-ch"))
         return new NativeCodePage(cp, codePage500ch);
      if (cp.equals("870-pl"))
         return new NativeCodePage(cp, codePage870);
      if (cp.equals("870-sk"))
         return new NativeCodePage(cp, codePage870sk);
      if (cp.equals("871"))
         return new NativeCodePage(cp, codePage871);
      if (cp.equals("875"))
         return new NativeCodePage(cp, codePage875);
      if (cp.equals("1025-r"))
         return new NativeCodePage(cp, codePage1025);
      if (cp.equals("1026"))
         return new NativeCodePage(cp, codePage1026);
      if (cp.equals("1141"))
         return new NativeCodePage(cp, codePage1141);
      if (cp.equals("1140"))
         return new NativeCodePage(cp, codePage1140);
      if (cp.equals("1147"))
         return new NativeCodePage(cp, codePage1147);
      if (cp.equals("1148"))
        return new NativeCodePage(cp, codePage1148);

//      return codePage37;
      return null;

   }

   /**
    * Returns a <code>String</code> object representing the
    * specified <code>char</code>.  The result is a string of length
    * 1 consisting solely of the specified <code>char</code>.
    *
    * @param c the <code>char</code> to be converted
    * @return the string representation of the specified <code>char</code>
    *
    * This code was taken from the Character.toString implementation of the
    * JDK 1.4 so that we can compile on version 1.3
    *
    */
   public static String characterToString(char c) {
     return String.valueOf(new char[] {c});
   }

}