/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.db.impl;

import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.DHTStorageAdapter;
import com.aelitis.azureus.core.dht.DHTStorageBlock;
import com.aelitis.azureus.core.dht.DHTStorageKey;
import com.aelitis.azureus.core.dht.DHTStorageKeyStats;
import com.aelitis.azureus.core.dht.control.DHTControl;
import com.aelitis.azureus.core.dht.db.DHTDB;
import com.aelitis.azureus.core.dht.db.DHTDBLookupResult;
import com.aelitis.azureus.core.dht.db.DHTDBStats;
import com.aelitis.azureus.core.dht.db.DHTDBValue;
import com.aelitis.azureus.core.dht.db.impl.DHTDBMapping;
import com.aelitis.azureus.core.dht.db.impl.DHTDBValueImpl;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.router.DHTRouter;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class DHTDBImpl
implements DHTDB,
DHTDBStats {
    private int original_republish_interval;
    private int ORIGINAL_REPUBLISH_INTERVAL_GRACE = 3600000;
    private int cache_republish_interval;
    private long MIN_CACHE_EXPIRY_CHECK_INTERVAL = 60000L;
    private long last_cache_expiry_check;
    private static final long IP_BLOOM_FILTER_REBUILD_PERIOD = 900000L;
    private static final int IP_COUNT_BLOOM_SIZE_INCREASE_CHUNK = 1000;
    private BloomFilter ip_count_bloom_filter = BloomFilterFactory.createAddRemove8Bit(1000);
    private static final int VALUE_VERSION_CHUNK = 128;
    private int next_value_version;
    private int next_value_version_left;
    private Map stored_values = new HashMap();
    private DHTControl control;
    private DHTStorageAdapter adapter;
    private DHTRouter router;
    private DHTTransportContact local_contact;
    private DHTLogger logger;
    private static final long MAX_TOTAL_SIZE = 0x400000L;
    private long total_size;
    private long total_values;
    private long total_keys;
    private boolean force_original_republish;
    private IpFilter ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
    private AEMonitor this_mon = new AEMonitor("DHTDB");

    public DHTDBImpl(DHTStorageAdapter _adapter, int _original_republish_interval, int _cache_republish_interval, DHTLogger _logger) {
        this.adapter = _adapter == null ? null : new adapterFacade(_adapter);
        this.original_republish_interval = _original_republish_interval;
        this.cache_republish_interval = _cache_republish_interval;
        this.logger = _logger;
        SimpleTimer.addPeriodicEvent("DHTDB:op", this.original_republish_interval, new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                DHTDBImpl.this.logger.log("Republish of original mappings starts");
                long start = SystemTime.getCurrentTime();
                int stats = DHTDBImpl.this.republishOriginalMappings();
                long end = SystemTime.getCurrentTime();
                DHTDBImpl.this.logger.log("Republish of original mappings completed in " + (end - start) + ": " + "values = " + stats);
            }
        });
        SimpleTimer.addPeriodicEvent("DHTDB:cp", this.cache_republish_interval + 10000 - (int)(Math.random() * 20000.0), new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                DHTDBImpl.this.logger.log("Republish of cached mappings starts");
                long start = SystemTime.getCurrentTime();
                int[] stats = DHTDBImpl.this.republishCachedMappings();
                long end = SystemTime.getCurrentTime();
                DHTDBImpl.this.logger.log("Republish of cached mappings completed in " + (end - start) + ": " + "values = " + stats[0] + ", keys = " + stats[1] + ", ops = " + stats[2]);
                if (DHTDBImpl.this.force_original_republish) {
                    DHTDBImpl.this.force_original_republish = false;
                    DHTDBImpl.this.logger.log("Force republish of original mappings due to router change starts");
                    start = SystemTime.getCurrentTime();
                    int stats2 = DHTDBImpl.this.republishOriginalMappings();
                    end = SystemTime.getCurrentTime();
                    DHTDBImpl.this.logger.log("Force republish of original mappings due to router change completed in " + (end - start) + ": " + "values = " + stats2);
                }
            }
        });
        SimpleTimer.addPeriodicEvent("DHTDB:bloom", 900000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent event2) {
                try {
                    DHTDBImpl.this.this_mon.enter();
                    DHTDBImpl.this.rebuildIPBloomFilter(false);
                }
                finally {
                    DHTDBImpl.this.this_mon.exit();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setControl(DHTControl _control) {
        this.control = _control;
        this.force_original_republish = this.router != null;
        this.router = this.control.getRouter();
        this.local_contact = this.control.getTransport().getLocalContact();
        try {
            this.this_mon.enter();
            Iterator it = this.stored_values.values().iterator();
            while (it.hasNext()) {
                DHTDBMapping mapping = (DHTDBMapping)it.next();
                mapping.updateLocalContact(this.local_contact);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHTDBValue store(HashWrapper key, byte[] value, byte flags) {
        try {
            this.this_mon.enter();
            DHTDBMapping mapping = (DHTDBMapping)this.stored_values.get(key);
            if (mapping == null) {
                mapping = new DHTDBMapping(this, key, true);
                this.stored_values.put(key, mapping);
            }
            DHTDBValueImpl res = new DHTDBValueImpl(SystemTime.getCurrentTime(), value, this.getNextValueVersion(), this.local_contact, this.local_contact, true, flags);
            mapping.add(res);
            DHTDBValueImpl dHTDBValueImpl = res;
            return dHTDBValueImpl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte store(DHTTransportContact sender, HashWrapper key, DHTTransportValue[] values) {
        byte[] my_id;
        DHTTransportContact furthest;
        if (this.total_size + this.total_values * 4L > 0x400000L) {
            DHTLog.log("Not storing " + DHTLog.getString2(key.getHash()) + " as maximum storage limit exceeded");
            return 3;
        }
        List closest_contacts = this.control.getClosestKContactsList(key.getHash(), true);
        boolean store_it = false;
        for (int i = 0; i < closest_contacts.size(); ++i) {
            if (!this.router.isID(((DHTTransportContact)closest_contacts.get(i)).getID())) continue;
            store_it = true;
            break;
        }
        if (!store_it) {
            DHTLog.log("Not storing " + DHTLog.getString2(key.getHash()) + " as key too far away");
            return 1;
        }
        boolean cache_forward = false;
        for (int i = 0; i < values.length; ++i) {
            if (Arrays.equals(sender.getID(), values[i].getOriginator().getID())) continue;
            cache_forward = true;
            break;
        }
        if (cache_forward && this.control.computeAndCompareDistances((furthest = (DHTTransportContact)(closest_contacts = this.control.getClosestKContactsList(my_id = this.local_contact.getID(), true)).get(closest_contacts.size() - 1)).getID(), sender.getID(), my_id) < 0) {
            store_it = false;
        }
        if (!store_it) {
            DHTLog.log("Not storing " + DHTLog.getString2(key.getHash()) + " as cache forward and sender too far away");
            return 1;
        }
        try {
            this.this_mon.enter();
            this.checkCacheExpiration(false);
            DHTDBMapping mapping = (DHTDBMapping)this.stored_values.get(key);
            if (mapping == null) {
                mapping = new DHTDBMapping(this, key, false);
                this.stored_values.put(key, mapping);
            }
            boolean contact_checked = false;
            boolean contact_ok = false;
            for (int i = 0; i < values.length; ++i) {
                DHTTransportValue t_value = values[i];
                DHTTransportValue value = values[i];
                boolean ok_to_store = false;
                boolean direct = Arrays.equals(sender.getID(), value.getOriginator().getID());
                if (!contact_checked) {
                    contact_ok = this.control.verifyContact(sender, direct);
                    if (!contact_ok) {
                        this.logger.log("DB: verification of contact '" + sender.getName() + "' failed for store operation");
                    }
                    contact_checked = true;
                }
                if (!(ok_to_store = contact_ok)) continue;
                DHTDBValueImpl mapping_value = new DHTDBValueImpl(sender, value, false);
                mapping.add(mapping_value);
            }
            byte by = mapping.getDiversificationType();
            return by;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHTDBLookupResult get(DHTTransportContact reader, HashWrapper key, int max_values, byte flags, boolean external_request) {
        try {
            this.this_mon.enter();
            this.checkCacheExpiration(false);
            final DHTDBMapping mapping = (DHTDBMapping)this.stored_values.get(key);
            if (mapping == null) {
                DHTDBLookupResult dHTDBLookupResult = null;
                return dHTDBLookupResult;
            }
            if (external_request) {
                mapping.addHit();
            }
            final DHTDBValue[] values = mapping.get(reader, max_values, flags);
            DHTDBLookupResult dHTDBLookupResult = new DHTDBLookupResult(){

                public DHTDBValue[] getValues() {
                    return values;
                }

                public byte getDiversificationType() {
                    return mapping.getDiversificationType();
                }
            };
            return dHTDBLookupResult;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHTDBValue get(HashWrapper key) {
        try {
            this.this_mon.enter();
            DHTDBMapping mapping = (DHTDBMapping)this.stored_values.get(key);
            if (mapping != null) {
                DHTDBValueImpl dHTDBValueImpl = mapping.get(this.local_contact);
                return dHTDBValueImpl;
            }
            DHTDBValue dHTDBValue = null;
            return dHTDBValue;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHTDBValue remove(DHTTransportContact originator, HashWrapper key) {
        try {
            this.this_mon.enter();
            DHTDBMapping mapping = (DHTDBMapping)this.stored_values.get(key);
            if (mapping != null) {
                DHTDBValueImpl res = mapping.remove(originator);
                if (res != null) {
                    DHTDBValue dHTDBValue = res.getValueForDeletion(this.getNextValueVersion());
                    return dHTDBValue;
                }
                DHTDBValue dHTDBValue = null;
                return dHTDBValue;
            }
            DHTDBValue dHTDBValue = null;
            return dHTDBValue;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public DHTStorageBlock keyBlockRequest(DHTTransportContact direct_sender, byte[] request2, byte[] signature) {
        if (this.adapter == null) {
            return null;
        }
        if (direct_sender != null) {
            byte[] key = this.adapter.getKeyForKeyBlock(request2);
            List closest_contacts = this.control.getClosestKContactsList(key, true);
            boolean process_it = false;
            for (int i = 0; i < closest_contacts.size(); ++i) {
                if (!this.router.isID(((DHTTransportContact)closest_contacts.get(i)).getID())) continue;
                process_it = true;
                break;
            }
            if (!process_it) {
                DHTLog.log("Not processing key block for  " + DHTLog.getString2(key) + " as key too far away");
                return null;
            }
            if (!this.control.verifyContact(direct_sender, true)) {
                DHTLog.log("Not processing key block for  " + DHTLog.getString2(key) + " as verification failed");
                return null;
            }
        }
        return this.adapter.keyBlockRequest(direct_sender, request2, signature);
    }

    public DHTStorageBlock getKeyBlockDetails(byte[] key) {
        if (this.adapter == null) {
            return null;
        }
        return this.adapter.getKeyBlockDetails(key);
    }

    public boolean isKeyBlocked(byte[] key) {
        return this.getKeyBlockDetails(key) != null;
    }

    public DHTStorageBlock[] getDirectKeyBlocks() {
        if (this.adapter == null) {
            return new DHTStorageBlock[0];
        }
        return this.adapter.getDirectKeyBlocks();
    }

    public boolean isEmpty() {
        return this.total_keys == 0L;
    }

    public int getKeyCount() {
        return (int)this.total_keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getValueDetails() {
        try {
            this.this_mon.enter();
            int[] res = new int[6];
            Iterator it = this.stored_values.values().iterator();
            while (it.hasNext()) {
                DHTDBMapping mapping = (DHTDBMapping)it.next();
                res[0] = res[0] + mapping.getValueCount();
                res[1] = res[1] + mapping.getLocalSize();
                res[2] = res[2] + mapping.getDirectSize();
                res[3] = res[3] + mapping.getIndirectSize();
                byte dt = mapping.getDiversificationType();
                if (dt == 2) {
                    res[4] = res[4] + 1;
                    continue;
                }
                if (dt != 3) continue;
                res[5] = res[5] + 1;
            }
            int[] nArray = res;
            return nArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public int getKeyBlockCount() {
        if (this.adapter == null) {
            return 0;
        }
        return this.adapter.getDirectKeyBlocks().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getKeys() {
        try {
            this.this_mon.enter();
            Iterator iterator = new ArrayList(this.stored_values.keySet()).iterator();
            return iterator;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int republishOriginalMappings() {
        HashWrapper key;
        Map.Entry entry;
        Iterator it;
        int values_published = 0;
        HashMap republish = new HashMap();
        try {
            this.this_mon.enter();
            it = this.stored_values.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                key = (HashWrapper)entry.getKey();
                DHTDBMapping mapping = (DHTDBMapping)entry.getValue();
                Iterator it2 = mapping.getValues();
                ArrayList<DHTDBValueImpl> values = new ArrayList<DHTDBValueImpl>();
                while (it2.hasNext()) {
                    DHTDBValueImpl value = (DHTDBValueImpl)it2.next();
                    if (value == null || !value.isLocal()) continue;
                    value.setCreationTime();
                    values.add(value);
                }
                if (values.size() <= 0) continue;
                republish.put(key, values);
            }
        }
        finally {
            this.this_mon.exit();
        }
        it = republish.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            key = (HashWrapper)entry.getKey();
            List values = (List)entry.getValue();
            for (int i = 0; i < values.size(); ++i) {
                ++values_published;
                this.control.putEncodedKey(key.getHash(), "Republish", (DHTDBValueImpl)values.get(i), 0L, true);
            }
        }
        return values_published;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] republishCachedMappings() {
        DHTStorageBlock[] direct_key_blocks;
        this.router.refreshIdleLeaves(this.cache_republish_interval);
        final HashMap republish = new HashMap();
        long now = System.currentTimeMillis();
        try {
            this.this_mon.enter();
            this.checkCacheExpiration(true);
            Iterator it = this.stored_values.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                HashWrapper key = (HashWrapper)entry.getKey();
                DHTDBMapping mapping = (DHTDBMapping)entry.getValue();
                if (mapping.getDiversificationType() != 1) continue;
                Iterator it2 = mapping.getValues();
                ArrayList<DHTDBValueImpl> values = new ArrayList<DHTDBValueImpl>();
                while (it2.hasNext()) {
                    DHTDBValueImpl value = (DHTDBValueImpl)it2.next();
                    if (value.isLocal()) continue;
                    if (now < value.getStoreTime()) {
                        value.setStoreTime(now);
                        continue;
                    }
                    if (now - value.getStoreTime() <= (long)this.cache_republish_interval) continue;
                    values.add(value);
                }
                if (values.size() <= 0) continue;
                republish.put(key, values);
            }
        }
        finally {
            this.this_mon.exit();
        }
        final int[] values_published = new int[]{0};
        final int[] keys_published = new int[]{0};
        final int[] republish_ops = new int[]{0};
        final HashSet anti_spoof_done = new HashSet();
        if (republish.size() > 0) {
            Iterator it = republish.entrySet().iterator();
            ArrayList<HashWrapper> stop_caching = new ArrayList<HashWrapper>();
            HashMap<HashWrapper, Object[]> contact_map = new HashMap<HashWrapper, Object[]>();
            while (it.hasNext()) {
                int j;
                Map.Entry entry = it.next();
                HashWrapper key = (HashWrapper)entry.getKey();
                byte[] lookup_id = key.getHash();
                List contacts = this.control.getClosestKContactsList(lookup_id, false);
                boolean keep_caching = false;
                for (j = 0; j < contacts.size(); ++j) {
                    if (!this.router.isID(((DHTTransportContact)contacts.get(j)).getID())) continue;
                    keep_caching = true;
                    break;
                }
                if (!keep_caching) {
                    DHTLog.log("Dropping cache entry for " + DHTLog.getString(lookup_id) + " as now too far away");
                    stop_caching.add(key);
                }
                for (j = 0; j < contacts.size(); ++j) {
                    DHTTransportContact contact = (DHTTransportContact)contacts.get(j);
                    if (this.router.isID(contact.getID())) continue;
                    Object[] data = (Object[])contact_map.get(new HashWrapper(contact.getID()));
                    if (data == null) {
                        data = new Object[]{contact, new ArrayList()};
                        contact_map.put(new HashWrapper(contact.getID()), data);
                    }
                    ((List)data[1]).add(key);
                }
            }
            it = contact_map.values().iterator();
            while (it.hasNext()) {
                final Object[] data = (Object[])it.next();
                final DHTTransportContact contact = (DHTTransportContact)data[0];
                final AESemaphore sem = new AESemaphore("DHTDB:cacheForward");
                contact.sendFindNode(new DHTTransportReplyHandlerAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void findNodeReply(DHTTransportContact _contact, DHTTransportContact[] _contacts) {
                        anti_spoof_done.add(_contact);
                        try {
                            List keys = (List)data[1];
                            byte[][] store_keys = new byte[keys.size()][];
                            DHTTransportValue[][] store_values = new DHTTransportValue[store_keys.length][];
                            keys_published[0] = keys_published[0] + store_keys.length;
                            for (int i = 0; i < store_keys.length; ++i) {
                                HashWrapper wrapper2 = (HashWrapper)keys.get(i);
                                store_keys[i] = wrapper2.getHash();
                                List values = (List)republish.get(wrapper2);
                                store_values[i] = new DHTTransportValue[values.size()];
                                values_published[0] = values_published[0] + store_values[i].length;
                                for (int j = 0; j < values.size(); ++j) {
                                    DHTDBValueImpl value = (DHTDBValueImpl)values.get(j);
                                    store_values[i][j] = value.getValueForRelay(DHTDBImpl.this.local_contact);
                                }
                            }
                            ArrayList<DHTTransportContact> contacts = new ArrayList<DHTTransportContact>();
                            contacts.add(contact);
                            republish_ops[0] = republish_ops[0] + 1;
                            DHTDBImpl.this.control.putDirectEncodedKeys(store_keys, "Republish cache", store_values, contacts);
                        }
                        finally {
                            sem.release();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void failed(DHTTransportContact _contact, Throwable _error) {
                        try {
                            DHTLog.log("cacheForward: pre-store findNode failed " + DHTLog.getString(_contact) + " -> failed: " + _error.getMessage());
                            DHTDBImpl.this.router.contactDead(_contact.getID(), false);
                        }
                        finally {
                            sem.release();
                        }
                    }
                }, contact.getProtocolVersion() >= 8 ? new byte[]{} : new byte[20]);
                sem.reserve();
            }
            try {
                this.this_mon.enter();
                for (int i = 0; i < stop_caching.size(); ++i) {
                    DHTDBMapping mapping = (DHTDBMapping)this.stored_values.remove(stop_caching.get(i));
                    if (mapping == null) continue;
                    mapping.destroy();
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
        if ((direct_key_blocks = this.getDirectKeyBlocks()).length > 0) {
            for (int i = 0; i < direct_key_blocks.length; ++i) {
                DHTTransportContact contact;
                int j;
                final DHTStorageBlock key_block = direct_key_blocks[i];
                List contacts = this.control.getClosestKContactsList(key_block.getKey(), false);
                boolean forward_it = false;
                for (j = 0; j < contacts.size(); ++j) {
                    contact = (DHTTransportContact)contacts.get(j);
                    if (!this.router.isID(contact.getID())) continue;
                    forward_it = true;
                    break;
                }
                for (j = 0; forward_it && j < contacts.size(); ++j) {
                    contact = (DHTTransportContact)contacts.get(j);
                    if (key_block.hasBeenSentTo(contact) || contact.getProtocolVersion() < 14) continue;
                    final Runnable task2 = new Runnable(){

                        public void run() {
                            contact.sendKeyBlock(new DHTTransportReplyHandlerAdapter(this){
                                private final /* synthetic */ 6 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void keyBlockReply(DHTTransportContact _contact) {
                                    DHTLog.log("key block forward ok " + DHTLog.getString(_contact));
                                    6.access$600(this.this$1).sentTo(_contact);
                                }

                                public void failed(DHTTransportContact _contact, Throwable _error) {
                                    DHTLog.log("key block forward failed " + DHTLog.getString(_contact) + " -> failed: " + _error.getMessage());
                                }
                            }, key_block.getRequest(), key_block.getCertificate());
                        }

                        static /* synthetic */ DHTStorageBlock access$600(6 x0) {
                            return x0.key_block;
                        }
                    };
                    if (anti_spoof_done.contains(contact)) {
                        task2.run();
                        continue;
                    }
                    contact.sendFindNode(new DHTTransportReplyHandlerAdapter(){

                        public void findNodeReply(DHTTransportContact contact, DHTTransportContact[] contacts) {
                            task2.run();
                        }

                        public void failed(DHTTransportContact _contact, Throwable _error) {
                            DHTLog.log("pre-kb findNode failed " + DHTLog.getString(_contact) + " -> failed: " + _error.getMessage());
                            DHTDBImpl.this.router.contactDead(_contact.getID(), false);
                        }
                    }, contact.getProtocolVersion() >= 8 ? new byte[]{} : new byte[20]);
                }
            }
        }
        return new int[]{values_published[0], keys_published[0], republish_ops[0]};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCacheExpiration(boolean force) {
        long elapsed;
        long now = SystemTime.getCurrentTime();
        if (!force && (elapsed = now - this.last_cache_expiry_check) > 0L && elapsed < this.MIN_CACHE_EXPIRY_CHECK_INTERVAL) {
            return;
        }
        try {
            this.this_mon.enter();
            this.last_cache_expiry_check = now;
            Iterator it = this.stored_values.values().iterator();
            while (it.hasNext()) {
                DHTDBMapping mapping = (DHTDBMapping)it.next();
                if (mapping.getValueCount() == 0) {
                    mapping.destroy();
                    it.remove();
                    continue;
                }
                Iterator it2 = mapping.getValues();
                while (it2.hasNext()) {
                    DHTDBValueImpl value = (DHTDBValueImpl)it2.next();
                    if (value.isLocal() || now - value.getCreationTime() <= (long)(this.original_republish_interval + this.ORIGINAL_REPUBLISH_INTERVAL_GRACE)) continue;
                    DHTLog.log("removing cache entry (" + value.getString() + ")");
                    it2.remove();
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected DHTTransportContact getLocalContact() {
        return this.local_contact;
    }

    protected DHTStorageAdapter getAdapter() {
        return this.adapter;
    }

    protected void log(String str) {
        this.logger.log(str);
    }

    public DHTDBStats getStats() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() {
        TreeMap<Integer, Object[]> count = new TreeMap<Integer, Object[]>();
        try {
            this.this_mon.enter();
            this.logger.log("Stored keys = " + this.stored_values.size() + ", values = " + this.getValueDetails()[0]);
            Iterator it = this.stored_values.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                HashWrapper value_key = (HashWrapper)entry.getKey();
                DHTDBMapping mapping = (DHTDBMapping)entry.getValue();
                DHTDBValueImpl[] values = mapping.get(null, 0, (byte)0);
                for (int i = 0; i < values.length; ++i) {
                    DHTDBValueImpl value = values[i];
                    Integer key = new Integer(value.isLocal() ? 0 : 1);
                    Object[] data = (Object[])count.get(key);
                    if (data == null) {
                        data = new Object[]{new Integer(1), ""};
                        count.put(key, data);
                    } else {
                        data[0] = new Integer((Integer)data[0] + 1);
                    }
                    String s = (String)data[1];
                    s = s + (s.length() == 0 ? "" : ", ") + "key=" + DHTLog.getString2(value_key.getHash()) + ",val=" + value.getString();
                    data[1] = s;
                }
            }
            it = count.keySet().iterator();
            while (it.hasNext()) {
                Integer k = (Integer)((Object)it.next());
                Object[] data = (Object[])count.get(k);
                this.logger.log("    " + k + " -> " + data[0] + " entries");
            }
            it = this.stored_values.entrySet().iterator();
            String str = "    ";
            int str_entries = 0;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                HashWrapper value_key = (HashWrapper)entry.getKey();
                DHTDBMapping mapping = (DHTDBMapping)entry.getValue();
                if (str_entries == 16) {
                    this.logger.log(str);
                    str = "    ";
                    str_entries = 0;
                }
                str = str + (++str_entries == 1 ? "" : ", ") + DHTLog.getString2(value_key.getHash()) + " -> " + mapping.getValueCount() + "/" + mapping.getHits() + "[" + mapping.getLocalSize() + "," + mapping.getDirectSize() + "," + mapping.getIndirectSize() + "]";
            }
            if (str_entries > 0) {
                this.logger.log(str);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void banContact(final DHTTransportContact contact, String reason) {
        new AEThread("DHTDBImpl:delayed flood delete", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                try {
                    DHTDBImpl.this.this_mon.enter();
                    Iterator it = DHTDBImpl.this.stored_values.values().iterator();
                    while (it.hasNext()) {
                        DHTDBMapping mapping = (DHTDBMapping)it.next();
                        Iterator it2 = mapping.getDirectValues();
                        while (it2.hasNext()) {
                            DHTDBValueImpl val = (DHTDBValueImpl)it2.next();
                            if (val.isLocal() || !Arrays.equals(val.getOriginator().getID(), contact.getID())) continue;
                            it.remove();
                        }
                    }
                }
                finally {
                    DHTDBImpl.this.this_mon.exit();
                }
            }
        }.start();
        this.logger.log("Banning " + contact.getString() + " due to store flooding (" + reason + ")");
        this.ip_filter.ban(contact.getAddress().getAddress().getHostAddress(), "DHT: Sender stored excessive entries at this node (" + reason + ")");
    }

    protected void incrementValueAdds(DHTTransportContact contact) {
        int hit_count = this.ip_count_bloom_filter.add(contact.getAddress().getAddress().getAddress());
        if (this.ip_count_bloom_filter.getSize() / this.ip_count_bloom_filter.getEntryCount() < 10) {
            this.rebuildIPBloomFilter(true);
        }
        if (hit_count > 64) {
            this.banContact(contact, "global flood");
        }
    }

    protected void decrementValueAdds(DHTTransportContact contact) {
        int hit_count = this.ip_count_bloom_filter.remove(contact.getAddress().getAddress().getAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildIPBloomFilter(boolean increase_size) {
        BloomFilter new_filter = increase_size ? BloomFilterFactory.createAddRemove8Bit(this.ip_count_bloom_filter.getSize() + 1000) : BloomFilterFactory.createAddRemove8Bit(this.ip_count_bloom_filter.getSize());
        try {
            Iterator it = this.stored_values.values().iterator();
            int max_hits = 0;
            while (it.hasNext()) {
                DHTDBMapping mapping = (DHTDBMapping)it.next();
                mapping.rebuildIPBloomFilter(false);
                Iterator it2 = mapping.getDirectValues();
                while (it2.hasNext()) {
                    int hits;
                    DHTDBValueImpl val = (DHTDBValueImpl)it2.next();
                    if (val.isLocal() || (hits = new_filter.add(val.getOriginator().getAddress().getAddress().getAddress())) <= max_hits) continue;
                    max_hits = hits;
                }
            }
            this.logger.log("Rebuilt global IP bloom filter, size = " + new_filter.getSize() + ", entries =" + new_filter.getEntryCount() + ", max hits = " + max_hits);
        }
        finally {
            this.ip_count_bloom_filter = new_filter;
        }
    }

    protected void reportSizes(String op) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextValueVersion() {
        try {
            int res;
            this.this_mon.enter();
            if (this.next_value_version_left == 0) {
                this.next_value_version_left = 128;
                if (this.adapter != null) {
                    this.next_value_version = this.adapter.getNextValueVersions(128);
                }
            }
            --this.next_value_version_left;
            int n = res = this.next_value_version++;
            return n;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected class adapterFacade
    implements DHTStorageAdapter {
        private DHTStorageAdapter delegate;

        protected adapterFacade(DHTStorageAdapter _delegate) {
            this.delegate = _delegate;
        }

        public DHTStorageKey keyCreated(HashWrapper key, boolean local) {
            DHTDBImpl.this.reportSizes("keyAdded");
            DHTDBImpl.this.total_keys++;
            return this.delegate.keyCreated(key, local);
        }

        public void keyDeleted(DHTStorageKey adapter_key) {
            DHTDBImpl.this.total_keys--;
            DHTDBImpl.this.reportSizes("keyDeleted");
            this.delegate.keyDeleted(adapter_key);
        }

        public void keyRead(DHTStorageKey adapter_key, DHTTransportContact contact) {
            DHTDBImpl.this.reportSizes("keyRead");
            this.delegate.keyRead(adapter_key, contact);
        }

        public DHTStorageKeyStats deserialiseStats(DataInputStream is) throws IOException {
            return this.delegate.deserialiseStats(is);
        }

        public void valueAdded(DHTStorageKey key, DHTTransportValue value) {
            DHTDBImpl.this.total_values++;
            DHTDBImpl.this.total_size += value.getValue().length;
            DHTDBImpl.this.reportSizes("valueAdded");
            if (!value.isLocal()) {
                DHTDBValueImpl val = (DHTDBValueImpl)value;
                boolean direct = Arrays.equals(value.getOriginator().getID(), val.getSender().getID());
                if (direct) {
                    DHTDBImpl.this.incrementValueAdds(value.getOriginator());
                }
            }
            this.delegate.valueAdded(key, value);
        }

        public void valueUpdated(DHTStorageKey key, DHTTransportValue old_value, DHTTransportValue new_value) {
            DHTDBImpl.this.total_size += new_value.getValue().length - old_value.getValue().length;
            DHTDBImpl.this.reportSizes("valueUpdated");
            this.delegate.valueUpdated(key, old_value, new_value);
        }

        public void valueDeleted(DHTStorageKey key, DHTTransportValue value) {
            DHTDBImpl.this.total_values--;
            DHTDBImpl.this.total_size -= value.getValue().length;
            DHTDBImpl.this.reportSizes("valueDeleted");
            if (!value.isLocal()) {
                DHTDBValueImpl val = (DHTDBValueImpl)value;
                boolean direct = Arrays.equals(value.getOriginator().getID(), val.getSender().getID());
                if (direct) {
                    DHTDBImpl.this.decrementValueAdds(value.getOriginator());
                }
            }
            this.delegate.valueDeleted(key, value);
        }

        public boolean isDiversified(byte[] key) {
            return this.delegate.isDiversified(key);
        }

        public byte[][] getExistingDiversification(byte[] key, boolean put_operation, boolean exhaustive_get) {
            return this.delegate.getExistingDiversification(key, put_operation, exhaustive_get);
        }

        public byte[][] createNewDiversification(DHTTransportContact cause, byte[] key, boolean put_operation, byte diversification_type, boolean exhaustive_get) {
            return this.delegate.createNewDiversification(cause, key, put_operation, diversification_type, exhaustive_get);
        }

        public int getNextValueVersions(int num) {
            return this.delegate.getNextValueVersions(num);
        }

        public DHTStorageBlock keyBlockRequest(DHTTransportContact direct_sender, byte[] request2, byte[] signature) {
            return this.delegate.keyBlockRequest(direct_sender, request2, signature);
        }

        public DHTStorageBlock getKeyBlockDetails(byte[] key) {
            return this.delegate.getKeyBlockDetails(key);
        }

        public DHTStorageBlock[] getDirectKeyBlocks() {
            return this.delegate.getDirectKeyBlocks();
        }

        public byte[] getKeyForKeyBlock(byte[] request2) {
            return this.delegate.getKeyForKeyBlock(request2);
        }
    }
}

