/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.router.impl;

import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.router.DHTRouterContact;
import com.aelitis.azureus.core.dht.router.DHTRouterContactAttachment;
import org.gudy.azureus2.core3.util.SystemTime;

public class DHTRouterContactImpl
implements DHTRouterContact {
    private byte[] node_id;
    private DHTRouterContactAttachment attachment;
    private boolean has_been_alive;
    private boolean ping_outstanding;
    private int fail_count;
    private long first_alive_time;
    private long first_fail_or_last_alive_time;
    private long last_added_time;
    private boolean is_bucket_entry;

    protected DHTRouterContactImpl(byte[] _node_id, DHTRouterContactAttachment _attachment, boolean _has_been_alive) {
        this.node_id = _node_id;
        this.attachment = _attachment;
        this.has_been_alive = _has_been_alive;
        this.attachment.setRouterContact(this);
        this.is_bucket_entry = false;
    }

    public byte[] getID() {
        return this.node_id;
    }

    public DHTRouterContactAttachment getAttachment() {
        return this.attachment;
    }

    protected void setAttachment(DHTRouterContactAttachment _attachment) {
        this.attachment = _attachment;
    }

    public void setAlive() {
        this.fail_count = 0;
        this.first_fail_or_last_alive_time = SystemTime.getCurrentTime();
        this.has_been_alive = true;
        if (this.first_alive_time == 0L) {
            this.first_alive_time = this.first_fail_or_last_alive_time;
        }
    }

    public boolean hasBeenAlive() {
        return this.has_been_alive;
    }

    public boolean isAlive() {
        return this.has_been_alive && this.fail_count == 0;
    }

    public boolean isFailing() {
        return this.fail_count > 0;
    }

    public long getTimeAlive() {
        if (this.fail_count > 0 || this.first_alive_time == 0L) {
            return 0L;
        }
        return SystemTime.getCurrentTime() - this.first_alive_time;
    }

    protected boolean setFailed() {
        ++this.fail_count;
        if (this.fail_count == 1) {
            this.first_fail_or_last_alive_time = SystemTime.getCurrentTime();
        }
        return this.hasFailed();
    }

    protected boolean hasFailed() {
        if (this.has_been_alive) {
            return this.fail_count >= this.attachment.getMaxFailForLiveCount();
        }
        return this.fail_count >= this.attachment.getMaxFailForUnknownCount();
    }

    protected long getFirstFailTime() {
        return this.fail_count == 0 ? 0L : this.first_fail_or_last_alive_time;
    }

    protected long getLastAliveTime() {
        return this.fail_count == 0 ? this.first_fail_or_last_alive_time : 0L;
    }

    protected long getFirstFailOrLastAliveTime() {
        return this.first_fail_or_last_alive_time;
    }

    protected long getFirstAliveTime() {
        return this.first_alive_time;
    }

    protected long getLastAddedTime() {
        return this.last_added_time;
    }

    protected void setLastAddedTime(long l) {
        this.last_added_time = l;
    }

    protected void setPingOutstanding(boolean b) {
        this.ping_outstanding = b;
    }

    protected boolean getPingOutstanding() {
        return this.ping_outstanding;
    }

    public String getString() {
        return DHTLog.getString2(this.node_id) + "[hba=" + (this.has_been_alive ? "Y" : "N") + ",bad=" + this.fail_count + ",OK=" + this.getTimeAlive() + "]";
    }

    public boolean isBucketEntry() {
        return this.is_bucket_entry;
    }

    public void setBucketEntry() {
        this.is_bucket_entry = true;
    }

    public boolean isReplacement() {
        return !this.is_bucket_entry;
    }

    public void setReplacement() {
        this.is_bucket_entry = false;
    }
}

