/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.router.impl;

import com.aelitis.azureus.core.dht.router.DHTRouter;
import com.aelitis.azureus.core.dht.router.DHTRouterContact;
import com.aelitis.azureus.core.dht.router.DHTRouterFactory;
import java.util.List;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;

public class Test {
    protected static long next_sha1_seed = 0L;

    public static void main(String[] args) {
        Test.simpleTest();
    }

    protected static void simpleTest() {
        DHTRouter router = DHTRouterFactory.create(1, 1, 1, new byte[]{0}, null, com.aelitis.azureus.core.dht.impl.Test.getLogger());
        byte[][] node_ids = new byte[][]{{Test.toByte("11111111")}, {Test.toByte("01111111")}, {Test.toByte("00101111")}, {Test.toByte("00100111")}};
        for (int i = 0; i < node_ids.length; ++i) {
            router.contactKnown(node_ids[i], null);
        }
        router.print();
    }

    protected static void randomTest() {
        DHTRouter router = DHTRouterFactory.create(20, 5, 5, Test.getSHA1(), null, com.aelitis.azureus.core.dht.impl.Test.getLogger());
        for (int i = 0; i < 100000; ++i) {
            DHTRouterContact res;
            byte[] id = Test.getSHA1();
            DHTRouterContact cont = router.contactKnown(id, null);
            if (cont == (res = router.findContact(id))) continue;
            Debug.out("whoops");
        }
        byte[] search = Test.getSHA1();
        List l = router.findClosestContacts(search, false);
        System.out.println("search: " + ByteFormatter.nicePrint(search));
        for (int i = 0; i < l.size(); ++i) {
            System.out.println("    -> " + ByteFormatter.nicePrint(((DHTRouterContact)l.get(i)).getID()));
        }
    }

    protected static byte[] getSHA1() {
        return new SHA1Simple().calculateHash(("" + next_sha1_seed++).getBytes());
    }

    protected static byte toByte(String str) {
        int res = 0;
        for (int i = 0; i < 8; ++i) {
            if (str.charAt(i) != '1') continue;
            res += 1 << 7 - i;
        }
        return (byte)res;
    }
}

