/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class IncomingMessageQueue {
    private volatile ArrayList listeners = new ArrayList();
    private final AEMonitor listeners_mon = new AEMonitor("IncomingMessageQueue:listeners");
    private MessageStreamDecoder stream_decoder;
    private final NetworkConnection connection;

    public IncomingMessageQueue(MessageStreamDecoder stream_decoder, NetworkConnection connection) {
        this.connection = connection;
        this.stream_decoder = stream_decoder;
    }

    public void setDecoder(MessageStreamDecoder new_stream_decoder) {
        ByteBuffer already_read = this.stream_decoder.destroy();
        this.connection.getTransport().setAlreadyRead(already_read);
        this.stream_decoder = new_stream_decoder;
        this.stream_decoder.resumeDecoding();
    }

    public int getPercentDoneOfCurrentMessage() {
        return this.stream_decoder.getPercentDoneOfCurrentMessage();
    }

    public int receiveFromTransport(int max_bytes) throws IOException {
        int data_read;
        int protocol_read;
        if (max_bytes < 1) {
            Debug.out("max_bytes < 1: " + max_bytes);
            return 0;
        }
        if (this.listeners.isEmpty()) {
            Debug.out("no queue listeners registered!");
            throw new IOException("no queue listeners registered!");
        }
        int bytes_read = this.stream_decoder.performStreamDecode(this.connection.getTransport(), max_bytes);
        Message[] messages = this.stream_decoder.removeDecodedMessages();
        if (messages != null) {
            for (int i = 0; i < messages.length; ++i) {
                Message msg = messages[i];
                if (msg == null) {
                    System.out.println("received msg == null [messages.length=" + messages.length + ", #" + i + "]: " + this.connection.getTransport().getDescription());
                    continue;
                }
                ArrayList listeners_ref = this.listeners;
                boolean handled = false;
                for (int x = 0; x < listeners_ref.size(); ++x) {
                    MessageQueueListener mql = (MessageQueueListener)listeners_ref.get(x);
                    handled = handled || mql.messageReceived(msg);
                }
                if (handled) continue;
                if (listeners_ref.size() > 0) {
                    System.out.println("no registered listeners [out of " + listeners_ref.size() + "] handled decoded message [" + msg.getDescription() + "]");
                }
                DirectByteBuffer[] buffs = msg.getData();
                for (int x = 0; x < buffs.length; ++x) {
                    buffs[x].returnToPool();
                }
            }
        }
        if ((protocol_read = this.stream_decoder.getProtocolBytesDecoded()) > 0) {
            ArrayList listeners_ref = this.listeners;
            for (int i = 0; i < listeners_ref.size(); ++i) {
                MessageQueueListener mql = (MessageQueueListener)listeners_ref.get(i);
                mql.protocolBytesReceived(protocol_read);
            }
        }
        if ((data_read = this.stream_decoder.getDataBytesDecoded()) > 0) {
            ArrayList listeners_ref = this.listeners;
            for (int i = 0; i < listeners_ref.size(); ++i) {
                MessageQueueListener mql = (MessageQueueListener)listeners_ref.get(i);
                mql.dataBytesReceived(data_read);
            }
        }
        return bytes_read;
    }

    public void notifyOfExternallyReceivedMessage(Message message) {
        ArrayList listeners_ref = this.listeners;
        boolean handled = false;
        DirectByteBuffer[] dbbs = message.getData();
        int size = 0;
        for (int i = 0; i < dbbs.length; ++i) {
            size += dbbs[i].remaining((byte)5);
        }
        for (int x = 0; x < listeners_ref.size(); ++x) {
            MessageQueueListener mql = (MessageQueueListener)listeners_ref.get(x);
            boolean bl = handled = handled || mql.messageReceived(message);
            if (message.getType() == 1) {
                mql.dataBytesReceived(size);
                continue;
            }
            mql.protocolBytesReceived(size);
        }
        if (!handled) {
            if (listeners_ref.size() > 0) {
                System.out.println("no registered listeners [out of " + listeners_ref.size() + "] handled decoded message [" + message.getDescription() + "]");
            }
            DirectByteBuffer[] buffs = message.getData();
            for (int x = 0; x < buffs.length; ++x) {
                buffs[x].returnToPool();
            }
        }
    }

    public void resumeQueueProcessing() {
        this.stream_decoder.resumeDecoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerQueueListener(MessageQueueListener listener) {
        try {
            this.listeners_mon.enter();
            ArrayList<MessageQueueListener> new_list = new ArrayList<MessageQueueListener>(this.listeners.size() + 1);
            new_list.addAll(this.listeners);
            new_list.add(listener);
            this.listeners = new_list;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelQueueListener(MessageQueueListener listener) {
        try {
            this.listeners_mon.enter();
            ArrayList new_list = new ArrayList(this.listeners);
            new_list.remove(listener);
            this.listeners = new_list;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public void destroy() {
        this.stream_decoder.destroy();
    }

    public static interface MessageQueueListener {
        public boolean messageReceived(Message var1);

        public void protocolBytesReceived(int var1);

        public void dataBytesReceived(int var1);
    }
}

