/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.ConnectionAttempt;
import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.IncomingMessageQueue;
import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;

public class NetworkConnectionImpl
implements NetworkConnection {
    private final ConnectionEndpoint connection_endpoint;
    private boolean connect_with_crypto;
    private boolean allow_fallback;
    private byte[] shared_secret;
    private NetworkConnection.ConnectionListener connection_listener;
    private boolean is_connected;
    private byte is_lan_local = 0;
    private final OutgoingMessageQueue outgoing_message_queue;
    private final IncomingMessageQueue incoming_message_queue;
    private Transport transport;
    private volatile ConnectionAttempt connection_attempt;
    private volatile boolean closed;

    public NetworkConnectionImpl(ConnectionEndpoint _target, MessageStreamEncoder encoder, MessageStreamDecoder decoder, boolean _connect_with_crypto, boolean _allow_fallback, byte[] _shared_secret) {
        this.connection_endpoint = _target;
        this.connect_with_crypto = _connect_with_crypto;
        this.allow_fallback = _allow_fallback;
        this.shared_secret = _shared_secret;
        this.is_connected = false;
        this.outgoing_message_queue = new OutgoingMessageQueue(encoder);
        this.incoming_message_queue = new IncomingMessageQueue(decoder, this);
    }

    public NetworkConnectionImpl(Transport _transport, MessageStreamEncoder encoder, MessageStreamDecoder decoder) {
        this.transport = _transport;
        this.connection_endpoint = this.transport.getTransportEndpoint().getProtocolEndpoint().getConnectionEndpoint();
        this.is_connected = true;
        this.outgoing_message_queue = new OutgoingMessageQueue(encoder);
        this.outgoing_message_queue.setTransport(this.transport);
        this.incoming_message_queue = new IncomingMessageQueue(decoder, this);
    }

    public ConnectionEndpoint getEndpoint() {
        return this.connection_endpoint;
    }

    public void connect(NetworkConnection.ConnectionListener listener) {
        this.connect(null, listener);
    }

    public void connect(ByteBuffer initial_outbound_data, NetworkConnection.ConnectionListener listener) {
        ConnectionAttempt ca;
        this.connection_listener = listener;
        if (this.is_connected) {
            this.connection_listener.connectStarted();
            this.connection_listener.connectSuccess(initial_outbound_data);
            return;
        }
        if (this.connection_attempt != null) {
            Debug.out("Connection attempt already active");
            listener.connectFailure(new Throwable("Connection attempt already active"));
            return;
        }
        this.connection_attempt = this.connection_endpoint.connectOutbound(this.connect_with_crypto, this.allow_fallback, this.shared_secret, initial_outbound_data, new Transport.ConnectListener(){

            public void connectAttemptStarted() {
                NetworkConnectionImpl.this.connection_listener.connectStarted();
            }

            public void connectSuccess(Transport _transport, ByteBuffer remaining_initial_data) {
                NetworkConnectionImpl.this.is_connected = true;
                NetworkConnectionImpl.this.transport = _transport;
                NetworkConnectionImpl.this.outgoing_message_queue.setTransport(NetworkConnectionImpl.this.transport);
                NetworkConnectionImpl.this.connection_listener.connectSuccess(remaining_initial_data);
                NetworkConnectionImpl.this.connection_attempt = null;
            }

            public void connectFailure(Throwable failure_msg) {
                NetworkConnectionImpl.this.is_connected = false;
                NetworkConnectionImpl.this.connection_listener.connectFailure(failure_msg);
            }
        });
        if (this.closed && (ca = this.connection_attempt) != null) {
            ca.abandon();
        }
    }

    public void close() {
        NetworkManager.getSingleton().stopTransferProcessing(this);
        this.closed = true;
        if (this.connection_attempt != null) {
            this.connection_attempt.abandon();
        }
        if (this.transport != null) {
            this.transport.close("Tidy close");
        }
        this.incoming_message_queue.destroy();
        this.outgoing_message_queue.destroy();
        this.is_connected = false;
    }

    public void notifyOfException(Throwable error) {
        if (this.connection_listener != null) {
            this.connection_listener.exceptionThrown(error);
        } else {
            Debug.out("notifyOfException():: connection_listener == null for exception: " + error.getMessage());
        }
    }

    public OutgoingMessageQueue getOutgoingMessageQueue() {
        return this.outgoing_message_queue;
    }

    public IncomingMessageQueue getIncomingMessageQueue() {
        return this.incoming_message_queue;
    }

    public void startMessageProcessing(LimitedRateGroup upload_group, LimitedRateGroup download_group) {
        NetworkManager.getSingleton().startTransferProcessing(this, upload_group, download_group);
    }

    public void enableEnhancedMessageProcessing(boolean enable) {
        if (enable) {
            NetworkManager.getSingleton().upgradeTransferProcessing(this);
        } else {
            NetworkManager.getSingleton().downgradeTransferProcessing(this);
        }
    }

    public Transport getTransport() {
        return this.transport;
    }

    public int getMssSize() {
        if (this.transport == null) {
            return NetworkManager.getMinMssSize();
        }
        return this.transport.getMssSize();
    }

    public String toString() {
        return this.transport == null ? this.connection_endpoint.getDescription() : this.transport.getDescription();
    }

    public boolean isConnected() {
        return this.is_connected;
    }

    public boolean isLANLocal() {
        if (this.is_lan_local == 0) {
            this.is_lan_local = AddressUtils.isLANLocalAddress(this.connection_endpoint.getNotionalAddress());
        }
        return this.is_lan_local == 1;
    }
}

