/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;

public class TCPTransportHelper
implements TransportHelper {
    public static final int READ_TIMEOUT = 10000;
    public static final int CONNECT_TIMEOUT = 60000;
    private static boolean enable_efficient_io = !Constants.JAVA_VERSION.startsWith("1.4");
    private final SocketChannel channel;

    public TCPTransportHelper(SocketChannel _channel) {
        this.channel = _channel;
    }

    public InetSocketAddress getAddress() {
        return new InetSocketAddress(this.channel.socket().getInetAddress(), this.channel.socket().getPort());
    }

    public String getName() {
        return "";
    }

    public boolean minimiseOverheads() {
        return false;
    }

    public int getConnectTimeout() {
        return 60000;
    }

    public int getReadTimeout() {
        return 10000;
    }

    public int write(ByteBuffer buffer, boolean partial_write) throws IOException {
        if (this.channel == null) {
            Debug.out("channel == null");
            return 0;
        }
        return this.channel.write(buffer);
    }

    public long write(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        if (this.channel == null) {
            Debug.out("channel == null");
            return 0L;
        }
        if (enable_efficient_io) {
            try {
                return this.channel.write(buffers, array_offset, length);
            }
            catch (IOException ioe) {
                String msg = ioe.getMessage();
                if (msg != null && msg.equals("A non-blocking socket operation could not be completed immediately")) {
                    enable_efficient_io = false;
                    Logger.log(new LogAlert(false, 1, "WARNING: Multi-buffer socket write failed; switching to single-buffer mode.\nUpgrade to JRE 1.5 (5.0) series to fix this problem!"));
                }
                throw ioe;
            }
        }
        long written_sofar = 0L;
        for (int i = array_offset; i < array_offset + length; ++i) {
            int data_length = buffers[i].remaining();
            int written = this.channel.write(buffers[i]);
            written_sofar += (long)written;
            if (written < data_length) break;
        }
        return written_sofar;
    }

    public int read(ByteBuffer buffer) throws IOException {
        if (this.channel == null) {
            Debug.out("channel == null");
            return 0;
        }
        return this.channel.read(buffer);
    }

    public long read(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        if (this.channel == null) {
            Debug.out("channel == null");
            return 0L;
        }
        if (buffers == null) {
            Debug.out("read: buffers == null");
            return 0L;
        }
        long bytes_read = 0L;
        if (enable_efficient_io) {
            try {
                bytes_read = this.channel.read(buffers, array_offset, length);
            }
            catch (IOException ioe) {
                String msg = ioe.getMessage();
                if (msg != null && msg.equals("A non-blocking socket operation could not be completed immediately")) {
                    enable_efficient_io = false;
                    Logger.log(new LogAlert(false, 1, "WARNING: Multi-buffer socket read failed; switching to single-buffer mode.\nUpgrade to JRE 1.5 (5.0) series to fix this problem!"));
                }
                throw ioe;
            }
        } else {
            for (int i = array_offset; i < array_offset + length; ++i) {
                int data_length = buffers[i].remaining();
                int read = this.channel.read(buffers[i]);
                bytes_read += (long)read;
                if (read < data_length) break;
            }
        }
        if (bytes_read < 0L) {
            throw new IOException("end of stream on socket read");
        }
        return bytes_read;
    }

    public void registerForReadSelects(final TransportHelper.selectListener listener, Object attachment) {
        TCPNetworkManager.getSingleton().getReadSelector().register(this.channel, new VirtualChannelSelector.VirtualSelectorListener(){

            public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                return listener.selectSuccess(TCPTransportHelper.this, attachment);
            }

            public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                listener.selectFailure(TCPTransportHelper.this, attachment, msg);
            }
        }, attachment);
    }

    public void registerForWriteSelects(final TransportHelper.selectListener listener, Object attachment) {
        TCPNetworkManager.getSingleton().getWriteSelector().register(this.channel, new VirtualChannelSelector.VirtualSelectorListener(){

            public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                return listener.selectSuccess(TCPTransportHelper.this, attachment);
            }

            public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                listener.selectFailure(TCPTransportHelper.this, attachment, msg);
            }
        }, attachment);
    }

    public void cancelReadSelects() {
        TCPNetworkManager.getSingleton().getReadSelector().cancel(this.channel);
    }

    public void cancelWriteSelects() {
        TCPNetworkManager.getSingleton().getWriteSelector().cancel(this.channel);
    }

    public void resumeReadSelects() {
        TCPNetworkManager.getSingleton().getReadSelector().resumeSelects(this.channel);
    }

    public void resumeWriteSelects() {
        TCPNetworkManager.getSingleton().getWriteSelector().resumeSelects(this.channel);
    }

    public void pauseReadSelects() {
        TCPNetworkManager.getSingleton().getReadSelector().pauseSelects(this.channel);
    }

    public void pauseWriteSelects() {
        TCPNetworkManager.getSingleton().getWriteSelector().pauseSelects(this.channel);
    }

    public void close(String reason) {
        TCPNetworkManager.getSingleton().getReadSelector().cancel(this.channel);
        TCPNetworkManager.getSingleton().getWriteSelector().cancel(this.channel);
        TCPNetworkManager.getSingleton().getConnectDisconnectManager().closeConnection(this.channel);
    }

    public void failed(Throwable reason) {
        this.close(Debug.getNestedExceptionMessage(reason));
    }

    public SocketChannel getSocketChannel() {
        return this.channel;
    }
}

